﻿# -*- encoding: utf-8 -*-
=begin
=図鑑_敵キャラデータ設定セクション by nwapeg

図鑑の敵キャラの項に表示する内容を設定します。
解説のスクロールを実装した際に、制御文字の描画が不可能になりました。

==更新履歴
Date     Version Author Comment
13/07/24 0.2.1   Foo    出現場所配列の追加
13/07/21 0.2.0   Foo    エネミー画像設定の追加
12/06/08 0.1.0   nwapeg 試作

=end

#==============================================================================
# ■ NWConst::Library
#==============================================================================
module NWConst::Library

  # エネミー画像の設定
  # パス,ファイル名,色相,X調整値,Y調整値,拡縮率で記述します。
  # X座標の基準点は中央,Y座標の基準点は最下部です。
  # X調整値に値が設定された時点で自動縮小機能がOFFになります。
  # 色相以降の設定値は省略可能です。(デフォルト値:色相=0,X調整値=0,Y調整値=0,拡縮率=1.00)
  # 設定がないエネミーはデフォルトのエネミー画像が表示されます
  ENEMY_IMAGE = {
    1 => ["Graphics/Pictures/", "80_slime_st01",0,0,-30,0.9],
    2 => ["Graphics/Pictures/", "80_bunnyslime_st01",0,0,0,0.8],
    3 => ["Graphics/Pictures/", "80_bunnyslime_st01",0,0,0,0.8],
    4 => ["Graphics/Pictures/", "80_name_st01",0,-30,-40,0.9],
    5 => ["Graphics/Pictures/", "80_inp_st01",0,0,-20,0.9],
    6 => ["Graphics/Pictures/", "80_mdg_st01",0,0,0,0.8],
    7 => ["Graphics/Pictures/", "80_dog_st01",0,0,-10,0.9],
    8 => ["Graphics/Pictures/", "80_mimizu_st01",0,0,0,0.8],
    9 => ["Graphics/Pictures/", "80_gob_st01",0,0,0,0.9],
    10 => ["Graphics/Pictures/", "80_pramia_st01",0,0,0,0.9],
    11 => ["Graphics/Pictures/", "80_vgirl_st01",0,0,0,0.9],
    12 => ["Graphics/Pictures/", "80_dragonp_st01",0,0,0,0.9],
    13 => ["Graphics/Pictures/", "80_nezumi_st01",0,-20,-20,0.9],
    14 => ["Graphics/Pictures/", "80_okami_st01",0,0,-20,0.9],
    15 => ["Graphics/Pictures/", "80_phoenix_st01",0,0,0,0.9],
    16 => ["Graphics/Pictures/", "80_hiru_st01",0,0,0,0.8],
    17 => ["Graphics/Pictures/", "80_usagi_st01",0,0,0,0.85],
    18 => ["Graphics/Pictures/", "80_hituzi_st01",0,0,-30,0.8],
    19 => ["Graphics/Pictures/", "80_syuree_st01",0,0,0,0.8],
    20 => ["Graphics/Pictures/", "80_jeid_st01",0,0,0,0.9],
    21 => ["Graphics/Pictures/", "80_syesta_st01",0,0,0,0.9],
    22 => ["Graphics/Pictures/", "80_nuruko_st01",0,0,-50,0.9],
    23 => ["Graphics/Pictures/", "80_orc_st01",0,40,-40],
    24 => ["Graphics/Pictures/", "80_mitubati_st01",0,0,0,0.8],
    25 => ["Graphics/Pictures/", "80_suzume_st01",0,0,0,0.8],
    26 => ["Graphics/Pictures/", "80_hapy_a_st01",0,0,0,0.9],
    27 => ["Graphics/Pictures/", "80_hapy_bc_st01",0,0,0,0.9],
    28 => ["Graphics/Pictures/", "80_queenhapy_st01",0,0,0,0.9],
    29 => ["Graphics/Pictures/", "80_highslag_st01",0,0,0,0.8],
    30 => ["Graphics/Pictures/", "80_name_s_st01",0,0,-30,0.9],
    31 => ["Graphics/Pictures/", "80_name2_st01",0,0,0,0.8],
    32 => ["Graphics/Pictures/", "80_jack_st01",0,-40,0,0.8],
    33 => ["Graphics/Pictures/", "80_ropa_st01",0,0,0,0.8],
    34 => ["Graphics/Pictures/", "80_meda_st01",0,0,-20,0.9],
    35 => ["Graphics/Pictures/", "80_candle_st01",0,0,-20,0.9],
    36 => ["Graphics/Pictures/", "80_eater_st01",0,0,-20,0.9],
    37 => ["Graphics/Pictures/", "80_liot_st01",0,0,-20,0.9],
    38 => ["Graphics/Pictures/", "80_luksl_st01",0,0,-20,0.9],
    39 => ["Graphics/Pictures/", "80_delh_a_st01",0,0,-20,0.9],
    40 => ["Graphics/Pictures/", "80_delh_b_st01",0,0,-20,0.9],
    41 => ["Graphics/Pictures/", "80_fairy_st01",0,0,-20,0.9],
    42 => ["Graphics/Pictures/", "80_minikani_st01",0,0,-20,0.9],
    43 => ["Graphics/Pictures/", "80_namazu_st01",0,0,-20,0.9],
    44 => ["Graphics/Pictures/", "80_rahure_st01",0,0,-20,0.9],
    45 => ["Graphics/Pictures/", "80_cent2_st01",0,0,-20,0.9],
    46 => ["Graphics/Pictures/", "80_youko_st01",0,0,-20,0.9],
    47 => ["Graphics/Pictures/", "80_kamuro_st01",0,0,-20,0.9],
    48 => ["Graphics/Pictures/", "80_kumo_st01",0,0,-20,0.9],
    49 => ["Graphics/Pictures/", "80_mimic_st01",0,0,-20,0.9],
    50 => ["Graphics/Pictures/", "80_nanabi_st01",0,0,-20,0.9],
    51 => ["Graphics/Pictures/", "80_morrigan_st01",0,0,-50],
    52 => ["Graphics/Pictures/", "80_namako_st01",0,0,-20,0.9],
    53 => ["Graphics/Pictures/", "80_kai_st01",0,0,-20,0.9],
    54 => ["Graphics/Pictures/", "80_kani_st01",0,0,-20,0.9],
    55 => ["Graphics/Pictures/", "80_slimelord_st01",0,0,0,0.7],
    56 => ["Graphics/Pictures/", "80_suika_st01",0,0,-20,0.9],
    57 => ["Graphics/Pictures/", "80_utubo_st01",0,0,-20,0.9],
    58 => ["Graphics/Pictures/", "80_lamia_st01",0,0,-20,0.9],
    59 => ["Graphics/Pictures/", "80_wakame_st01",0,0,-20,0.9],
    60 => ["Graphics/Pictures/", "80_kurage_st01",0,0,-20,0.9],
    61 => ["Graphics/Pictures/", "80_iso_st01",0,0,-20,0.9],
    62 => ["Graphics/Pictures/", "80_ankou_st01",0,0,-20,0.9],
    63 => ["Graphics/Pictures/", "80_meia_st01",0,0,-20,0.9],
    64 => ["Graphics/Pictures/", "80_page17_st01",0,0,-20,0.9],
    65 => ["Graphics/Pictures/", "80_page257_st01",0,0,-20,0.9],
    66 => ["Graphics/Pictures/", "80_page65537_st01",0,0,-20,0.9],
    67 => ["Graphics/Pictures/", "80_sisterlamia_st01",0,50,-20,0.9],
    68 => ["Graphics/Pictures/", "80_sisccubus_st01",0,0,-20,0.9],
    69 => ["Graphics/Pictures/", "80_arikui_st01",0,0,0,0.8],
    70 => ["Graphics/Pictures/", "80_grizzly_st01",0,0,-40],
    71 => ["Graphics/Pictures/", "80_XX-7_st01",0,0,0,0.8],
    72 => ["Graphics/Pictures/", "80_littlebug_st01",0,0,-20,0.9],
    73 => ["Graphics/Pictures/", "80_kaniloid_st01",0,0,-20,0.9],
    74 => ["Graphics/Pictures/", "80_brunhild_st01",0,0,-20,0.9],
    75 => ["Graphics/Pictures/", "80_ghost_st01",0,0,-20,0.9],
    76 => ["Graphics/Pictures/", "80_doll_st01",0,0,-20,0.9],
    77 => ["Graphics/Pictures/", "80_zonbe_st11",0,0,-20,0.9],
    78 => ["Graphics/Pictures/", "80_zonbe_st21",0,0,-20,0.9],
    79 => ["Graphics/Pictures/", "80_zonbe_st31",0,0,-20,0.9],
    80 => ["Graphics/Pictures/", "80_zonbe_st41",0,0,-20,0.9],
    81 => ["Graphics/Pictures/", "80_zonbe_st01",0,0,-20,0.9],
    82 => ["Graphics/Pictures/", "80_frederika_st01",0,0,-20,0.9],
    83 => ["Graphics/Pictures/", "80_chrom_st21",0,0,-20,0.9],
    84 => ["Graphics/Pictures/", "80_elf_st01",0,0,-20,0.9],
    85 => ["Graphics/Pictures/", "80_braunys_st01",0,0,-20,0.8],
    86 => ["Graphics/Pictures/", "80_tfairy_st01",0,0,-20,0.9],
    87 => ["Graphics/Pictures/", "80_fairys_st01",0,0,-20,0.9],
    88 => ["Graphics/Pictures/", "80_fairys_st11",0,0,-20,0.9],
    89 => ["Graphics/Pictures/", "80_fairys_st21",0,0,-20,0.9],
    90 => ["Graphics/Pictures/", "80_fairys_st31",0,0,50,0.9],
    91 => ["Graphics/Pictures/", "80_fairys_st41",0,0,50,0.9],
    92 => ["Graphics/Pictures/", "80_fairys_st51",0,0,50,0.9],
    93 => ["Graphics/Pictures/", "80_sylph_st01",0,0,-20,0.9],
    94 => ["Graphics/Pictures/", "80_heinrich_st11",0,0,-20,0.9],
    95 => ["Graphics/Pictures/", "80_taran_st01",0,0,-20,0.9],
    96 => ["Graphics/Pictures/", "80_mino_st01",0,0,-20,0.9],
    97 => ["Graphics/Pictures/", "80_bander_st01",0,0,-20,0.9],
    98 => ["Graphics/Pictures/", "80_eva_st01",0,0,0,0.9],
    99 => ["Graphics/Pictures/", "80_saboresu_st01",0,0,-80],
    100 => ["Graphics/Pictures/", "80_mukade_st01",0,0,-20,0.9],
    101 => ["Graphics/Pictures/", "80_sasori_st01",0,0,-20,0.9],
    102 => ["Graphics/Pictures/", "80_saboten_st01",0,0,-20,0.9],
    103 => ["Graphics/Pictures/", "80_datyou_st01",0,80,-20,0.9],
    104 => ["Graphics/Pictures/", "80_lamp_st21",0,0,-20,0.9],
    105 => ["Graphics/Pictures/", "80_mummy_st01",0,0,-20,0.9],
    106 => ["Graphics/Pictures/", "80_kobura_st01",0,0,-20,0.9],
    107 => ["Graphics/Pictures/", "80_lamias_st01",0,0,-20,0.9],
    108 => ["Graphics/Pictures/", "80_sphinx_st01",0,0,-20,0.9],
    109 => ["Graphics/Pictures/", "80_saraevil_st01",0,0,-20,0.9],
    110 => ["Graphics/Pictures/", "80_astaroth_st01",0,0,-50],
    111 => ["Graphics/Pictures/", "80_wani_st01",0,0,-20,0.9],
    112 => ["Graphics/Pictures/", "80_saki_st01",0,0,-20,0.9],
    113 => ["Graphics/Pictures/", "80_d_fighter_st01",0,0,-20,0.9],
    114 => ["Graphics/Pictures/", "80_oogumo_st01",0,0,-20,0.8],
    115 => ["Graphics/Pictures/", "80_suckvore_st01",0,0,-20,0.9],
    116 => ["Graphics/Pictures/", "80_ironmaiden_st01",0,0,-20,0.9],
    117 => ["Graphics/Pictures/", "80_wormv_st01",0,0,-20,0.9],
    118 => ["Graphics/Pictures/", "80_ustrel_st01",0,0,-40,0.9],
    119 => ["Graphics/Pictures/", "80_mitutubo_st01",0,0,-20,0.9],
    120 => ["Graphics/Pictures/", "80_lily_st01",0,0,-20,0.9],
    121 => ["Graphics/Pictures/", "80_kooni_st01",0,0,-50],
    122 => ["Graphics/Pictures/", "80_onaho_st01",0,0,0,0.8],
    123 => ["Graphics/Pictures/", "80_narcubus_st11",0,0,-20,0.9],
    124 => ["Graphics/Pictures/", "80_lusia_st01",0,0,-20,0.9],
    125 => ["Graphics/Pictures/", "80_dodome_st01",0,0,-20,0.9],
    126 => ["Graphics/Pictures/", "80_lizardthief_st01",0,0,-40,0.9],
    127 => ["Graphics/Pictures/", "80_lizardthief_st11",0,0,-40,0.9],
    128 => ["Graphics/Pictures/", "80_lizardboss_st01",0,0,-20,0.9],
    129 => ["Graphics/Pictures/", "80_sinkiro_st01",0,0,-20,0.9],
    130 => ["Graphics/Pictures/", "80_arizigoku_st01",0,0,-20,0.9],
    131 => ["Graphics/Pictures/", "80_sandw_st01",0,30,-20,0.9],
    132 => ["Graphics/Pictures/", "80_d_scylla_st01",0,0,-20,0.9],
    133 => ["Graphics/Pictures/", "80_gnome_st01",0,0,0,0.9],
    134 => ["Graphics/Pictures/", "80_vitae_st01",0,0,-20,0.9],
    135 => ["Graphics/Pictures/", "80_vetala_st01",0,0,-20,0.9],
    136 => ["Graphics/Pictures/", "80_valt_st01",0,0,-20,0.9],
    137 => ["Graphics/Pictures/", "80_sinifa_st01",0,0,-20,0.9],
    138 => ["Graphics/Pictures/", "80_shadow_st01",0,0,-20,0.9],
    139 => ["Graphics/Pictures/", "80_gaistvine_st01",0,0,-20,0.9],
    140 => ["Graphics/Pictures/", "80_c_homunculus_st01",0,0,-20,0.9],
    141 => ["Graphics/Pictures/", "80_ironmaiden_k_st01",0,0,-20,0.9],
    142 => ["Graphics/Pictures/", "80_junkdoll_st01",0,0,-20,0.9],
    143 => ["Graphics/Pictures/", "80_adramelek_st11",0,0,-20,0.9],
    144 => ["Graphics/Pictures/", "80_alice_st01",0,0,-20,0.9],
    145 => ["Graphics/Pictures/", "80_sinigami_st01",0,0,-20,0.9],
    146 => ["Graphics/Pictures/", "80_ranael_st31",0,0,-20,0.9],
    147 => ["Graphics/Pictures/", "80_nagael_st01",0,0,-20,0.9],
    148 => ["Graphics/Pictures/", "80_inp_st21",0,0,-10,0.9],
    151 => ["Graphics/Pictures/", "80_kinoko_st01",0,0,-20,0.9],
    152 => ["Graphics/Pictures/", "80_nobisutam_st01",0,0,-20,0.9],
    153 => ["Graphics/Pictures/", "80_u_scylla_st01",0,0,-20,0.9],
    154 => ["Graphics/Pictures/", "80_husuma_st01",0,0,-20,0.8],
    155 => ["Graphics/Pictures/", "80_mermaid_st01",0,0,-20,0.8],
    156 => ["Graphics/Pictures/", "80_s_mermaid_st01",0,0,-20,0.9],
    157 => ["Graphics/Pictures/", "80_k_mermaid_st01",0,0,-20,0.9],
    158 => ["Graphics/Pictures/", "80_ittanmomen_st01",0,0,-20,0.8],
    159 => ["Graphics/Pictures/", "80_ittanmomen_st11",0,100,-20,0.8],
    160 => ["Graphics/Pictures/", "80_ittanmomen_st21",0,-100,-20,0.8],
    161 => ["Graphics/Pictures/", "80_dagon_st01",0,0,-20,0.9],
    162 => ["Graphics/Pictures/", "80_hitodama_st01",0,0,-20,0.9],
    163 => ["Graphics/Pictures/", "80_ashel_st01",0,0,-20,0.9],
    164 => ["Graphics/Pictures/", "80_bonny_st01",0,0,-20,0.9],
    165 => ["Graphics/Pictures/", "80_tatunoko_k_st01",0,0,-20,0.9],
    166 => ["Graphics/Pictures/", "80_umiusi_k_st01",0,0,-20,0.9],
    167 => ["Graphics/Pictures/", "80_levia_st01",0,0,-20,0.9],
    168 => ["Graphics/Pictures/", "80_kaeru_st01",0,0,-20,0.9],
    169 => ["Graphics/Pictures/", "80_kaeru_st11",0,0,-20,0.9],
    170 => ["Graphics/Pictures/", "80_centa_st01",0,0,-20,0.9],
    171 => ["Graphics/Pictures/", "80_alraune_st01",0,0,-20,0.9],
    172 => ["Graphics/Pictures/", "80_okikumusi_st01",0,0,-20,0.7],
    173 => ["Graphics/Pictures/", "80_ghost2_st01",0,0,-20,0.9],
    174 => ["Graphics/Pictures/", "80_hakoiri_st01",0,0,-20,0.9],
    175 => ["Graphics/Pictures/", "80_durahan_st01",0,0,-20,0.9],
    176 => ["Graphics/Pictures/", "80_kerberos_st01",0,0,-20,0.9],
    177 => ["Graphics/Pictures/", "80_arumaeruma_st61",0,0,-20,0.8],
    178 => ["Graphics/Pictures/", "80_granberia_st61",0,0,-20,0.8],
    179 => ["Graphics/Pictures/", "80_nureonnna_st01",0,0,-20,0.9],
    180 => ["Graphics/Pictures/", "80_h_mino_st01",0,0,-20,0.9],
    181 => ["Graphics/Pictures/", "80_m_mino_st01",0,0,-20,0.9],
    182 => ["Graphics/Pictures/", "80_zinitauros_st01",0,0,-20,0.9],
    183 => ["Graphics/Pictures/", "80_seitentaisei_st01",0,0,-20,0.9],
    184 => ["Graphics/Pictures/", "80_nyumaou_st01",0,0,-20,0.9],
    185 => ["Graphics/Pictures/", "80_kunoitielf_st01",0,0,-20,0.9],
    186 => ["Graphics/Pictures/", "80_samuraielf_st01",0,0,-20,0.9],
    187 => ["Graphics/Pictures/", "80_yukionna_st01",0,0,-20,0.8],
    188 => ["Graphics/Pictures/", "80_nekomata_st01",0,0,-50,0.9],
    189 => ["Graphics/Pictures/", "80_akaname_st01",0,0,-20,0.9],
    190 => ["Graphics/Pictures/", "80_kappa_st01",0,0,-20,0.8],
    191 => ["Graphics/Pictures/", "80_hutakuti_st11",0,0,-20,0.9],
    192 => ["Graphics/Pictures/", "80_sirohebisama_st01",0,0,-20,0.9],
    193 => ["Graphics/Pictures/", "80_mikolamia_st01",0,0,-20,0.8],
    194 => ["Graphics/Pictures/", "80_mikoarachne_st01",0,0,-50,0.9],
    195 => ["Graphics/Pictures/", "80_kezyorou_st01",0,0,-20,0.9],
    196 => ["Graphics/Pictures/", "80_yamatanooroti_st01",0,0,-20,0.8],
    197 => ["Graphics/Pictures/", "80_m_batterfly_st01",0,0,-20,0.8],
    198 => ["Graphics/Pictures/", "80_m_dragonfly_st01",0,0,-20,0.8],
    199 => ["Graphics/Pictures/", "80_m_tento_st01",0,0,-20,0.8],
    200 => ["Graphics/Pictures/", "80_m_fairy_st01",0,-200,-50,0.9],
    201 => ["Graphics/Pictures/", "80_m_elf_st01",0,0,-20,0.9],
    202 => ["Graphics/Pictures/", "80_m_succubus_st01",0,150,-50,0.9],
    203 => ["Graphics/Pictures/", "80_mefist_st11",0,0,-20,0.8],
    204 => ["Graphics/Pictures/", "80_kamakiri_st01",0,0,-20,0.9],
    205 => ["Graphics/Pictures/", "80_kaiko_st01",0,0,-20,0.9],
    206 => ["Graphics/Pictures/", "80_a_alm_st01",0,0,-20,0.9],
    207 => ["Graphics/Pictures/", "80_a_looty_st01",0,0,-20,0.9],
    208 => ["Graphics/Pictures/", "80_a_vore_st01",0,0,-20,0.9],
    209 => ["Graphics/Pictures/", "80_a_parasol_st01",0,0,-20,0.9],
    210 => ["Graphics/Pictures/", "80_a_prison_st01",0,0,-20,0.9],
    211 => ["Graphics/Pictures/", "80_a_mash_st01",0,0,-20,0.9],
    212 => ["Graphics/Pictures/", "80_dorothy_st01",0,0,-20,0.9],
    213 => ["Graphics/Pictures/", "80_rafi_st01",0,0,-20,0.9],
    214 => ["Graphics/Pictures/", "80_dina_st01",0,0,-20,0.9],
    215 => ["Graphics/Pictures/", "80_a_emp_st01",0,0,-20,0.9],
    216 => ["Graphics/Pictures/", "80_moss_st01",0,0,-20,0.9],
    217 => ["Graphics/Pictures/", "80_mosquito_st01",0,0,-20,0.9],
    218 => ["Graphics/Pictures/", "80_imomusi_st01",0,0,-20,0.9],
    219 => ["Graphics/Pictures/", "80_suzumebati_st01",0,0,-20,0.9],
    220 => ["Graphics/Pictures/", "80_queenbee_st01",0,0,-20,0.9],
    221 => ["Graphics/Pictures/", "80_tezcatlipoca_st01",0,0,-20,0.9],
    222 => ["Graphics/Pictures/", "80_coatlus_st01",0,0,-20,0.9],
    223 => ["Graphics/Pictures/", "80_gnosis_st01",0,0,-20,0.9],
    224 => ["Graphics/Pictures/", "80_shion_st01",0,0,-20,0.9],
    225 => ["Graphics/Pictures/", "80_jelly_st01",0,0,-20,0.8],
    226 => ["Graphics/Pictures/", "80_blob_st01",0,0,-20,0.8],
    227 => ["Graphics/Pictures/", "80_slime_green_st01",0,0,-20,0.9],
    228 => ["Graphics/Pictures/", "80_slime_red_st01",0,0,-20,0.9],
    229 => ["Graphics/Pictures/", "80_slime_blue_st01",0,0,-20,0.9],
    230 => ["Graphics/Pictures/", "80_slime_purple_st01",0,0,-20,0.9],
    231 => ["Graphics/Pictures/", "80_undine_st01",0,0,-20,0.9],
    232 => ["Graphics/Pictures/", "80_erbetie_st01",0,0,-20,0.9],
    233 => ["Graphics/Pictures/", "80_ant_st11",0,0,-20,0.9],
    234 => ["Graphics/Pictures/", "80_artm_st01",0,0,-20,0.8],
    235 => ["Graphics/Pictures/", "80_paizuridoll_st01",0,0,-20,0.8],
    236 => ["Graphics/Pictures/", "80_scylla_st01",0,0,-20,0.8],
    237 => ["Graphics/Pictures/", "80_medusa_st01",0,0,-20,0.8],
    238 => ["Graphics/Pictures/", "80_ageha_st01",0,0,-20,0.9],
    239 => ["Graphics/Pictures/", "80_blom_st01",0,0,-20,0.9],
    240 => ["Graphics/Pictures/", "80_warmer_st01",0,0,-20,0.8],
    241 => ["Graphics/Pictures/", "80_gool_st01",0,0,-20,0.9],
    242 => ["Graphics/Pictures/", "80_gool_st11",0,150,-20,0.9],
    243 => ["Graphics/Pictures/", "80_gool_st21",0,-150,-20,0.9],
    244 => ["Graphics/Pictures/", "80_fakejelly_st01",0,0,-20,0.9],
    245 => ["Graphics/Pictures/", "80_w_hapy_st01",0,0,-20,0.9],
    246 => ["Graphics/Pictures/", "80_k_hapy_st01",0,0,-20,0.9],
    247 => ["Graphics/Pictures/", "80_madgolem_st01",0,0,-20,0.9],
    248 => ["Graphics/Pictures/", "80_golem_st01",0,0,-20,0.9],
    249 => ["Graphics/Pictures/", "80_h_kamakiri_st01",0,0,-20,0.8],
    250 => ["Graphics/Pictures/", "80_bgolem_st01",0,0,-20,0.9],
    251 => ["Graphics/Pictures/", "80_kitunezyu_st01",0,0,-20,0.9],
    252 => ["Graphics/Pictures/", "80_kunoitisanbi_st01",0,0,-20,0.9],
    253 => ["Graphics/Pictures/", "80_mononohuyonbi_st01",0,0,-20,0.9],
    254 => ["Graphics/Pictures/", "80_queenant_st01",0,0,-20,0.9],
    255 => ["Graphics/Pictures/", "80_lilith2_st01b",0,0,-20,0.8],
    256 => ["Graphics/Pictures/", "80_yougan_st01",0,0,-20,0.9],
    257 => ["Graphics/Pictures/", "80_lamiad_st01",0,0,-20,0.9],
    258 => ["Graphics/Pictures/", "80_scyllad_st01",0,0,-20,0.9],
    259 => ["Graphics/Pictures/", "80_seiren_st01",0,0,-20,0.9],
    260 => ["Graphics/Pictures/", "80_sango_st01",0,0,-20,0.8],
    261 => ["Graphics/Pictures/", "80_hitode_st01",0,0,-20,0.9],
    262 => ["Graphics/Pictures/", "80_beelzebub_st01",0,0,-20,0.8],
    263 => ["Graphics/Pictures/", "80_beelzebub_st11",0,0,-20,0.8],
    264 => ["Graphics/Pictures/", "80_beelzebub_st21",0,0,-20,0.8],
    265 => ["Graphics/Pictures/", "80_arkjelly_st01",0,0,-20,0.8],
    266 => ["Graphics/Pictures/", "80_e_scylla_st01",0,0,-20,0.8],
    267 => ["Graphics/Pictures/", "80_poseidones_st01",0,0,-20,0.9],
    268 => ["Graphics/Pictures/", "80_succubuses_st01",0,160,-50,0.9],
    269 => ["Graphics/Pictures/", "80_succubuses_st11",0,50,-20,0.9],
    270 => ["Graphics/Pictures/", "80_succubuses_st21",0,-60,-50,0.9],
    271 => ["Graphics/Pictures/", "80_succubuses_st31",0,-220,-20,0.9],
    272 => ["Graphics/Pictures/", "80_maycubbus_st01",0,0,-20,0.9],
    273 => ["Graphics/Pictures/", "80_maccubus_st31",0,0,-20,0.9],
    274 => ["Graphics/Pictures/", "80_minccubus_st21",0,0,-20,0.9],
    275 => ["Graphics/Pictures/", "80_renccubus_st21",0,0,-20,0.9],
    276 => ["Graphics/Pictures/", "80_succubus_st01",0,0,-20,0.8],
    277 => ["Graphics/Pictures/", "80_d_succubus_st01",0,0,-20,0.9],
    278 => ["Graphics/Pictures/", "80_maidscyulla_st01",0,0,-20,0.8],
    279 => ["Graphics/Pictures/", "80_madaminsect_st01",0,0,-20,0.8],
    280 => ["Graphics/Pictures/", "80_madamumbrella_st01",0,0,-20,0.9],
    281 => ["Graphics/Pictures/", "80_aradia_st01",0,0,-20,0.8],
    282 => ["Graphics/Pictures/", "80_candy_st01",0,0,-20,0.8],
    283 => ["Graphics/Pictures/", "80_basilisk_st01",0,0,-20,0.9],
    284 => ["Graphics/Pictures/", "80_dragon_st01",0,0,-20,0.8],
    285 => ["Graphics/Pictures/", "80_salamander_st01",0,0,-20,0.9],
    286 => ["Graphics/Pictures/", "80_granberia_st61",0,0,-20,0.8],
    287 => ["Graphics/Pictures/", "80_gelatinous_st01",0,0,-20,0.9],
    288 => ["Graphics/Pictures/", "80_youki_st01",0,20,-20,0.8],
    289 => ["Graphics/Pictures/", "80_tora_st01",0,0,-20,0.8],
    290 => ["Graphics/Pictures/", "80_vampire_st01",0,0,-20,0.8],
    291 => ["Graphics/Pictures/", "80_jeraira_st01",0,0,-20,0.9],
    292 => ["Graphics/Pictures/", "80_libolibo_st01",0,0,-20,0.9],
    293 => ["Graphics/Pictures/", "80_anfill_st01",0,0,-20,0.9],
    294 => ["Graphics/Pictures/", "80_twinkel_st01",0,0,-20,0.8],
    295 => ["Graphics/Pictures/", "80_lilith_st01",0,0,-20,0.8],
    296 => ["Graphics/Pictures/", "80_emily_st01",0,0,-20,0.8],
    297 => ["Graphics/Pictures/", "80_cassandra_st21",0,0,-20,0.8],
    298 => ["Graphics/Pictures/", "80_witchs_st01",0,0,-20,0.8],
    299 => ["Graphics/Pictures/", "80_seaanemone_st01",0,0,-20,0.8],
    300 => ["Graphics/Pictures/", "80_suiryu_st01",0,0,-20,0.9],
    301 => ["Graphics/Pictures/", "80_manta_st01",0,0,-20,0.9],
    302 => ["Graphics/Pictures/", "80_ikkaku_st01",0,0,-20,0.9],
    303 => ["Graphics/Pictures/", "80_trickfairy_st01",0,0,-20,0.8],
    304 => ["Graphics/Pictures/", "80_amazoneself_st01",0,0,-20,0.9],
    305 => ["Graphics/Pictures/", "80_carbuncle_st01",0,0,-20,0.8],
    306 => ["Graphics/Pictures/", "80_gigantic_st01",0,0,-20,0.9],
    307 => ["Graphics/Pictures/", "80_queenfairy_st01",0,0,-20,0.8],
    308 => ["Graphics/Pictures/", "80_queenelf_st01",0,0,-20,0.9],
    309 => ["Graphics/Pictures/", "80_f_alraune_st01",0,0,-20,0.8],
    310 => ["Graphics/Pictures/", "80_f_dryad_st01",0,0,-20,0.8],
    311 => ["Graphics/Pictures/", "80_walraune_st01",0,0,-20,0.9],
    312 => ["Graphics/Pictures/", "80_dryad_st01",0,60,-50,0.9],
    313 => ["Graphics/Pictures/", "80_dryad_st11",0,60,-50,0.9],
    314 => ["Graphics/Pictures/", "80_queenalraune_st01",0,0,-20,0.8],
    315 => ["Graphics/Pictures/", "80_azidahaka_st01",0,0,-20,0.8],
    316 => ["Graphics/Pictures/", "80_knight_mermaid_st01",0,0,-20,0.8],
    317 => ["Graphics/Pictures/", "80_g_mermaid_st01",0,-50,-20,0.9],
    318 => ["Graphics/Pictures/", "80_loreley_st01",0,0,-20,0.9],
    319 => ["Graphics/Pictures/", "80_ningyohime_st04",0,0,-20,0.8],
    320 => ["Graphics/Pictures/", "80_queenmermaid_st01",0,0,-20,0.8],
    321 => ["Graphics/Pictures/", "80_arachnes_st01",0,0,-20,0.9],
    322 => ["Graphics/Pictures/", "80_arachnes_st11",0,160,-20,0.9],
    323 => ["Graphics/Pictures/", "80_arachnes_st21",0,-160,-20,0.9],
    324 => ["Graphics/Pictures/", "80_tutigumo_st11",0,0,-20,0.8],
    325 => ["Graphics/Pictures/", "80_alakneload_st01",0,0,-20,0.8],
    326 => ["Graphics/Pictures/", "80_atlach_st02",0,0,-20,0.8],
    327 => ["Graphics/Pictures/", "80_kumonomiko_st01",0,0,-20,0.9],
    328 => ["Graphics/Pictures/", "80_conquista_st01",0,0,-20,0.8],
    329 => ["Graphics/Pictures/", "80_vendetta_st01",0,0,-20,0.8],
    330 => ["Graphics/Pictures/", "80_e_vampire_st01",0,0,-20,0.8],
    331 => ["Graphics/Pictures/", "80_carmilla_st01",0,0,-20,0.9],
    332 => ["Graphics/Pictures/", "80_elisabeth_st01",0,0,-20,0.9],
    333 => ["Graphics/Pictures/", "80_queenvanpire_st11",0,0,-20,0.9],
    334 => ["Graphics/Pictures/", "80_m_shadow_st01",0,0,-20,0.9],
    335 => ["Graphics/Pictures/", "80_enenra_st11",0,0,-20,0.8],
    336 => ["Graphics/Pictures/", "80_kirin_st01",0,0,-20,0.9],
    337 => ["Graphics/Pictures/", "80_zyakotuonna_st01",0,0,-20,0.9],
    338 => ["Graphics/Pictures/", "80_behemoth_st01",0,0,-20,0.9],
    339 => ["Graphics/Pictures/", "80_wyvern_st01",0,0,-20,0.9],
    340 => ["Graphics/Pictures/", "80_kyoryuu_st01",0,0,-20,0.9],
    341 => ["Graphics/Pictures/", "80_monk_sucubuss_st01",0,0,-20,0.9],
    342 => ["Graphics/Pictures/", "80_monk_demon_st01",0,0,-20,0.9],
    343 => ["Graphics/Pictures/", "80_scylla_s_st01",0,0,-20,0.9],
    344 => ["Graphics/Pictures/", "80_vouivre_st01",0,0,-20,0.9],
    345 => ["Graphics/Pictures/", "80_sanki_st01",0,10,-100,1.0],
    346 => ["Graphics/Pictures/", "80_sanki_st11",0,180,-20,1.0],
    347 => ["Graphics/Pictures/", "80_sanki_st21",0,-200,-50,1.0],
    348 => ["Graphics/Pictures/", "80_alice8th_st01",0,0,-20,0.9],
    349 => ["Graphics/Pictures/", "80_alice8th2_st01",0,0,-20,0.9],
    350 => ["Graphics/Pictures/", "80_alice8th3_st01",0,0,-20,0.9],
    351 => ["Graphics/Pictures/", "80_icemaze_st01",0,0,-20,0.9],
    352 => ["Graphics/Pictures/", "80_shirokuma_st01",0,20,-20,0.9],
    353 => ["Graphics/Pictures/", "80_angels_st01",0,8,-28,0.9],
    354 => ["Graphics/Pictures/", "80_angels_st11",0,0,-20,0.9],
    355 => ["Graphics/Pictures/", "80_angels_st21",0,0,-20,0.9],
    356 => ["Graphics/Pictures/", "80_angels_st31",0,0,-20,0.9],
    357 => ["Graphics/Pictures/", "80_angels_st41",0,0,-20,0.9],
    358 => ["Graphics/Pictures/", "80_trinity_st01",0,0,-50,0.9],
    359 => ["Graphics/Pictures/", "80_trinity_st11",0,190,-50,0.9],
    360 => ["Graphics/Pictures/", "80_trinity_st21",0,-190,-50,0.9],
    361 => ["Graphics/Pictures/", "80_uranus_st01",0,50,-20,0.9],
    362 => ["Graphics/Pictures/", "80_ediniel_st11",0,0,-20,0.9],
    363 => ["Graphics/Pictures/", "80_cupid_st01",0,0,-20,0.9],
    364 => ["Graphics/Pictures/", "80_valkyrie_st01",0,-50,-20,0.9],
    365 => ["Graphics/Pictures/", "80_eden_st21",0,0,-20,0.9],
    366 => ["Graphics/Pictures/", "80_heriel_st01",0,0,-20,0.9],
    367 => ["Graphics/Pictures/", "80_arusiel_st11",0,0,-20,0.9],
    368 => ["Graphics/Pictures/", "80_soniamazda_st01",0,0,-20,0.9],
    369 => ["Graphics/Pictures/", "80_soniamanyu_st01",0,0,-20,0.9],
    370 => ["Graphics/Pictures/", "80_soniachaos_st01",0,0,-20,0.9],
    373 => ["Graphics/Pictures/", "80_c_beast_st01",0,0,-20,0.8],
    374 => ["Graphics/Pictures/", "80_c_s2_st01",0,0,-20,0.8],
    375 => ["Graphics/Pictures/", "80_c_a3_st01",0,0,-20,0.8],
    376 => ["Graphics/Pictures/", "80_AD-5_st01",0,0,-20,0.8],
    377 => ["Graphics/Pictures/", "80_q_5_st01",0,50,-20,0.8],
    378 => ["Graphics/Pictures/", "80_cirqueb_st01",0,0,-20,0.9],
    379 => ["Graphics/Pictures/", "80_cirqueb_st11",0,-30,-50,0.9],
    380 => ["Graphics/Pictures/", "80_cirqueb_st21",0,0,-20,0.9],
    381 => ["Graphics/Pictures/", "80_cirqueb_st31",0,0,-20,0.9],
    382 => ["Graphics/Pictures/", "80_cirqueb_st41",0,0,-20,0.8],
    383 => ["Graphics/Pictures/", "80_cirqueb_st51",0,0,-20,0.9],
    384 => ["Graphics/Pictures/", "80_tamamo_st61",0,0,-20,0.9],
    385 => ["Graphics/Pictures/", "80_arumaeruma_st61",0,0,-20,0.8],
    396 => ["Graphics/Pictures/", "80_lusia_st21",0,0,-20,0.9],
    455 => ["Graphics/Pictures/", "80_lanpass_st01",0,0,-20,0.9],
    456 => ["Graphics/Pictures/", "80_youkosan_st01",0,0,-20,0.9],
    457 => ["Graphics/Pictures/", "80_mukuro_st01",0,0,-20,0.9],
    460 => ["Graphics/Pictures/", "80_gilgoon_st01",0,0,-20,0.9],
    462 => ["Graphics/Pictures/", "80_succubusq_st01",0,0,-20,0.9],
    470 => ["Graphics/Pictures/", "80_bell_st01",0,0,-20,0.9],
    471 => ["Graphics/Pictures/", "80_lira_st01",0,0,-20,0.9],
    472 => ["Graphics/Pictures/", "80_muzet_st01",0,0,-20,0.9],
    473 => ["Graphics/Pictures/", "80_fulbeua_st01",0,0,-20,0.9],
    474 => ["Graphics/Pictures/", "80_dakki_st01",0,0,40,0.7],
    475 => ["Graphics/Pictures/", "80_est_st01",0,0,-20,0.9],
    476 => ["Graphics/Pictures/", "80_est_st11",0,0,60,0.7],
    477 => ["Graphics/Pictures/", "80_executioner_st01",0,0,-20,0.9],
    478 => ["Graphics/Pictures/", "80_ogretooth_st01",0,0,-20,0.9],
    479 => ["Graphics/Pictures/", "80_mistilteinn_st01",0,0,-20,0.8],
    480 => ["Graphics/Pictures/", "80_myuska_st11",0,0,-20,0.9],
    481 => ["Graphics/Pictures/", "80_nemea_st01",0,0,-20,0.9],
    482 => ["Graphics/Pictures/", "80_vinum_st01",0,0,-20,0.9],
    483 => ["Graphics/Pictures/", "80_bell_st01",0,0,-20,0.9],
    484 => ["Graphics/Pictures/", "80_lira_st01",0,0,-20,0.9],
    485 => ["Graphics/Pictures/", "80_muzet_st01",0,0,-20,0.9],
    486 => ["Graphics/Pictures/", "80_fulbeua_st01",0,0,-20,0.9],
    487 => ["Graphics/Pictures/", "80_gilgoon_st01",0,0,-20,0.9],
    488 => ["Graphics/Pictures/", "80_daimeikai_st11",0,0,-20,0.9],
    489 => ["Graphics/Pictures/", "80_tarsa_st11",0,0,-20,0.9],
    490 => ["Graphics/Pictures/", "80_dakki_st01",0,0,40,0.7],
    491 => ["Graphics/Pictures/", "80_est_st01",0,0,-20,0.9],
    492 => ["Graphics/Pictures/", "80_succubusj_st01",0,0,-20,0.9],
    494 => ["Graphics/Pictures/", "80_succubusm_st01",0,0,-50,0.9],
    498 => ["Graphics/Pictures/", "80_cassandra_st02",0,0,-20,0.8],
    501 => ["Graphics/Pictures/", "80_galda_st01",0,0,-20,0.8],
    502 => ["Graphics/Pictures/", "80_cockroacha_st01",0,0,-20,0.8],
    503 => ["Graphics/Pictures/", "80_cockroachb_st01",0,0,-20,0.9],
    504 => ["Graphics/Pictures/", "80_queenroach_st01",0,0,-20,0.9],
    505 => ["Graphics/Pictures/", "80_erbetie_st01",0,0,-20,0.9],
    506 => ["Graphics/Pictures/", "80_erbetie_st01",0,0,-20,0.9],
    507 => ["Graphics/Pictures/", "80_magicpot_st01",0,0,-50,0.9],
    508 => ["Graphics/Pictures/", "80_mametanuki_st01",0,0,-20,0.9],
    509 => ["Graphics/Pictures/", "80_zyoutanuki_st01",0,0,-20,0.9],
    510 => ["Graphics/Pictures/", "80_shinobitanuki_st01",0,0,-20,0.9],
    511 => ["Graphics/Pictures/", "80_baketanuki_st01",0,0,-20,0.9],
    512 => ["Graphics/Pictures/", "80_inugami_st01",0,0,-20,0.9],
    513 => ["Graphics/Pictures/", "80_kurodanuki_st01",0,0,-20,0.9],
    514 => ["Graphics/Pictures/", "80_tukumokomati_st01",0,0,-20,0.9],
    515 => ["Graphics/Pictures/", "80_kunoitielf2_st01",0,0,-20,0.9],
    516 => ["Graphics/Pictures/", "80_kunoitielf2_st11",0,160,-20,0.9],
    517 => ["Graphics/Pictures/", "80_kunoitielf2_st21",0,-170,-20,0.9],
    518 => ["Graphics/Pictures/", "80_kuno_succubus_st01",0,0,-20,0.9],
    519 => ["Graphics/Pictures/", "80_kuno_hapy_st01",0,0,-20,0.9],
    520 => ["Graphics/Pictures/", "80_kuno_scylla_st01",0,0,-20,0.9],
    521 => ["Graphics/Pictures/", "80_kuno_arachne_st01",0,0,-20,0.9],
    522 => ["Graphics/Pictures/", "80_elfhime_st01",0,0,-20,0.9],
    523 => ["Graphics/Pictures/", "80_izanami_st01",0,0,-20,0.9],
    524 => ["Graphics/Pictures/", "80_heinrich_st51",0,0,-20,0.9],
    525 => ["Graphics/Pictures/", "80_hatibi_st01",0,0,-20,0.9],
    526 => ["Graphics/Pictures/", "80_esuccubus_st01",0,0,-20,0.9],
    527 => ["Graphics/Pictures/", "80_gran_centa_st01",0,0,-20,0.9],
    528 => ["Graphics/Pictures/", "80_abis_st01",0,0,-20,0.9],
    529 => ["Graphics/Pictures/", "80_onmyougobi_st01",0,0,-20,0.9],
    530 => ["Graphics/Pictures/", "80_oiranrokubi_st01",0,0,-20,0.9],
    531 => ["Graphics/Pictures/", "80_sanki_st01",0,10,-100,1.0],
    532 => ["Graphics/Pictures/", "80_sanki_st11",0,180,-20,1.0],
    533 => ["Graphics/Pictures/", "80_sanki_st21",0,-200,-50,1.0],
    534 => ["Graphics/Pictures/", "80_tamamo_st01",0,0,-20,0.9],
    535 => ["Graphics/Pictures/", "80_erbetie_st01",0,0,-20,0.9],
    536 => ["Graphics/Pictures/", "80_granberia_st61",0,0,-20,0.8],
    537 => ["Graphics/Pictures/", "80_rafaera_st11",0,0,-20,0.9],
    538 => ["Graphics/Pictures/", "80_shion_st01",0,0,-20,0.9],
    539 => ["Graphics/Pictures/", "80_gnosis_st01",0,0,-20,0.9],
    540 => ["Graphics/Pictures/", "80_eden_st31",0,0,-20,0.9],
    541 => ["Graphics/Pictures/", "80_alice15th_st51",0,0,-20,0.9],
    542 => ["Graphics/Pictures/", "80_morrigan_st01",0,0,-50],
    543 => ["Graphics/Pictures/", "80_astaroth_st01",0,0,-50],
    544 => ["Graphics/Pictures/", "80_sabasa_st11",0,0,-20,0.9],
    545 => ["Graphics/Pictures/", "80_amoldoll_st01",0,0,-20,0.9],
    546 => ["Graphics/Pictures/", "80_amoldoll_st11",0,0,-20,0.9],
    547 => ["Graphics/Pictures/", "80_amoldoll_st21",0,0,-20,0.9],
    548 => ["Graphics/Pictures/", "80_persephone_st01",0,0,-20,0.9],
    549 => ["Graphics/Pictures/", "80_trilobite_st11",0,0,-20,0.9],
    550 => ["Graphics/Pictures/", "80_heavensgate_st01",0,0,-20,0.9],
    551 => ["Graphics/Pictures/", "80_nephilim_st01",0,0,-20,0.9],
    552 => ["Graphics/Pictures/", "80_gigantweapon_st01",0,50,-20,0.9],
    554 => ["Graphics/Pictures/", "80_mariel_st01",0,0,-20,0.9],
    555 => ["Graphics/Pictures/", "80_tennyo_st01",0,0,-20,0.9],
    556 => ["Graphics/Pictures/", "80_c_tentacle_st01",0,0,-20,0.9],
    557 => ["Graphics/Pictures/", "80_grandine_st01",0,0,-20,0.8],
    558 => ["Graphics/Pictures/", "80_ariel_st01",0,0,-20,0.9],
    559 => ["Graphics/Pictures/", "80_ranael_st31",0,0,-20,0.9],
    560 => ["Graphics/Pictures/", "80_rifaiel_st11",0,0,-20,0.9],
    561 => ["Graphics/Pictures/", "80_rapun_st01",0,0,-20,0.9],
    562 => ["Graphics/Pictures/", "80_nagael_st01",0,0,-20,0.9],
    563 => ["Graphics/Pictures/", "80_c_medulahan_st01",0,0,-20,0.9],
    564 => ["Graphics/Pictures/", "80_gnomaren_st01",0,0,-20,0.8],
    565 => ["Graphics/Pictures/", "80_ratael_st01",0,0,-20,0.9],
    566 => ["Graphics/Pictures/", "80_rifaiel_st11",0,0,-20,0.9],
    567 => ["Graphics/Pictures/", "80_gaburiera_st11",0,0,-20,0.9],
    568 => ["Graphics/Pictures/", "80_giriel_st01",0,0,-20,0.9],
    569 => ["Graphics/Pictures/", "80_trooperloid_st01",0,0,-20,0.9],
    570 => ["Graphics/Pictures/", "80_sabiriel_st11",0,0,-20,0.9],
    571 => ["Graphics/Pictures/", "80_sabiriel_st01",0,0,-20,0.9],
    572 => ["Graphics/Pictures/", "80_cirquec_st01",0,0,-20,0.9],
    573 => ["Graphics/Pictures/", "80_uriera_st11",0,0,-20,0.9],
    574 => ["Graphics/Pictures/", "80_muzukiel_st01",0,0,-20,0.9],
    575 => ["Graphics/Pictures/", "80_silkiel_st01",0,0,-20,0.9],
    576 => ["Graphics/Pictures/", "80_sariera_st11",0,0,-20,0.9],
    577 => ["Graphics/Pictures/", "80_berryel_st01",0,0,-20,0.9],
    578 => ["Graphics/Pictures/", "80_evilprant_st01",0,0,-20,0.9],
    579 => ["Graphics/Pictures/", "80_revel_st01",0,0,-20,0.9],
    580 => ["Graphics/Pictures/", "80_gigamander_st01",0,0,-20,0.9],
    581 => ["Graphics/Pictures/", "80_hainu_st01",0,0,-20,0.9],
    582 => ["Graphics/Pictures/", "80_doppeleb_st01",0,0,-20,0.9],
    583 => ["Graphics/Pictures/", "80_doppele_st11",0,0,-20,0.9],
    584 => ["Graphics/Pictures/", "80_c_tangh_st01",0,0,-20,0.9],
    585 => ["Graphics/Pictures/", "80_c_bug_st01",0,0,-20,0.8],
    586 => ["Graphics/Pictures/", "80_c_slag_st01",0,0,-20,0.9],
    587 => ["Graphics/Pictures/", "80_c_dryad_st01",0,0,-20,0.9],
    588 => ["Graphics/Pictures/", "80_heinrich_st51",0,0,-20,0.9],
    589 => ["Graphics/Pictures/", "80_catoblepas_st01",0,0,-20,0.9],
    590 => ["Graphics/Pictures/", "80_typhon_st01",0,0,-20,0.9],
    591 => ["Graphics/Pictures/", "80_amphis_st01",0,0,-20,0.9],
    592 => ["Graphics/Pictures/", "80_laplace_st01",0,0,-20,0.9],
    593 => ["Graphics/Pictures/", "80_traptemis_st01",0,0,-20,0.9],
    594 => ["Graphics/Pictures/", "80_tukuyomi_st01",0,0,-20,0.9],
    595 => ["Graphics/Pictures/", "80_furiel_st01",0,0,-20,0.9],
    596 => ["Graphics/Pictures/", "80_drainplant_st01",0,0,-20,0.9],
    597 => ["Graphics/Pictures/", "80_drainloid_st01",0,0,-20,0.9],
    598 => ["Graphics/Pictures/", "80_handyloid_st01",0,0,-20,0.9],
    599 => ["Graphics/Pictures/", "80_metatorone_st11",0,0,-20,0.9],
    600 => ["Graphics/Pictures/", "80_sandalforne_st11",0,-50,-20,0.9],
    601 => ["Graphics/Pictures/", "80_maid_angel_st01",0,0,-20,0.9],
    602 => ["Graphics/Pictures/", "80_cooc_angel_st01",0,0,-20,0.9],
    603 => ["Graphics/Pictures/", "80_whiteyel_st01",0,0,-20,0.9],
    604 => ["Graphics/Pictures/", "80_lamianloid_st01",0,0,-20,0.9],
    605 => ["Graphics/Pictures/", "80_shion_st31",0,0,-20,0.9],
    606 => ["Graphics/Pictures/", "80_shion_st51",0,0,-20,0.9],
    607 => ["Graphics/Pictures/", "80_shion_st71",0,0,-20,0.9],
    608 => ["Graphics/Pictures/", "80_iriasu_st31",0,0,0,0.8],
    609 => ["Graphics/Pictures/", "80_slime_st01",0,0,-30,0.9],
    610 => ["Graphics/Pictures/", "80_dog_st01",0,0,-10,0.9],
    611 => ["Graphics/Pictures/", "80_endiel_st11",0,0,-20,0.9],
    612 => ["Graphics/Pictures/", "80_holmiel_st01",0,0,-50,0.9],
    613 => ["Graphics/Pictures/", "80_replicant_st01",0,30,-20,0.9],
    614 => ["Graphics/Pictures/", "80_doppeleb_st01",0,0,-20,0.9],
    615 => ["Graphics/Pictures/", "80_doppele_st31",0,0,-20,0.9],
    616 => ["Graphics/Pictures/", "80_c_prison_st01",0,0,-20,0.9],
    617 => ["Graphics/Pictures/", "80_zylphe_st01",0,0,-20,0.9],
    618 => ["Graphics/Pictures/", "80_cirquec_st11",0,0,-20,0.9],
    619 => ["Graphics/Pictures/", "80_maikonido_st01",0,0,-20,0.9],
    620 => ["Graphics/Pictures/", "80_matango_st01",0,0,-20,0.9],
    621 => ["Graphics/Pictures/", "80_meltymoss_st01",0,0,-20,0.9],
    622 => ["Graphics/Pictures/", "80_meltyrose_st01",0,0,-20,0.9],
    623 => ["Graphics/Pictures/", "80_c_dryad_vore_st01",0,0,-20,0.9],
    624 => ["Graphics/Pictures/", "80_queenmoss_st01",0,0,-20,0.9],
    625 => ["Graphics/Pictures/", "80_queenmoss_st11",0,0,-20,0.9],
    626 => ["Graphics/Pictures/", "80_alice8thx01_st01",0,0,-20,0.9],
    627 => ["Graphics/Pictures/", "80_alice8thx01_st02",0,0,-20,0.9],
    628 => ["Graphics/Pictures/", "80_alice8thx01_st03",0,0,-20,0.9],
    629 => ["Graphics/Pictures/", "80_alice8thx01_st04",0,0,-20,0.9],
    630 => ["Graphics/Pictures/", "80_alice8thx01_st05",0,0,-20,0.9],
    631 => ["Graphics/Pictures/", "80_alice8thx01_st06",0,0,-20,0.9],
    632 => ["Graphics/Pictures/", "80_azidahaka_st01",0,0,-20,0.9],
    633 => ["Graphics/Pictures/", "80_alice8thx01_st08",0,0,-20,0.9],
    634 => ["Graphics/Pictures/", "80_alice8thx01_st09",0,0,-20,0.9],
    635 => ["Graphics/Pictures/", "80_alice8thx01_st10",0,0,-20,0.9],
    636 => ["Graphics/Pictures/", "80_tukumokomati_st01",0,0,-20,0.9],
    637 => ["Graphics/Pictures/", "80_alice8thx01_st07",0,0,-20,0.9],
    638 => ["Graphics/Pictures/", "80_alice8thx01_st11",0,0,-20,0.9],
    639 => ["Graphics/Pictures/", "80_alice8thx01_st13",0,0,-20,0.9],
    640 => ["Graphics/Pictures/", "80_alice8thx01_st14",0,0,-20,0.9],
    641 => ["Graphics/Pictures/", "80_izanami_st01",0,0,-20,0.9],
    642 => ["Graphics/Pictures/", "80_alice8th5_st01",0,0,-20,0.9],
    643 => ["Graphics/Pictures/", "80_alice8thx01_st12",0,0,-20,0.9],
    644 => ["Graphics/Pictures/", "80_alice8thx01_st15",0,0,-20,0.9],
    645 => ["Graphics/Pictures/", "80_heinrich_st01",0,0,-20,0.9],
    646 => ["Graphics/Pictures/", "80_heinrich_st21",0,0,-20,0.9],
    647 => ["Graphics/Pictures/", "80_marcellus_st01",0,0,-20,0.9],
    648 => ["Graphics/Pictures/", "80_alice8th6_st01",0,0,-20,0.9],
    649 => ["Graphics/Pictures/", "80_arcen_st01",0,0,-20,0.9],
    650 => ["Graphics/Pictures/", "80_yomotu_st01",0,0,-20,0.9],
    651 => ["Graphics/Pictures/", "80_fermesara_st01",0,0,-20,0.9],
    652 => ["Graphics/Pictures/", "80_angelghoul_st01",0,0,-20,0.8],
    653 => ["Graphics/Pictures/", "80_dragonzonbe_st21",0,100,-20,0.9],
    654 => ["Graphics/Pictures/", "80_sigurd_st11",0,0,-50,1.0],
    655 => ["Graphics/Pictures/", "80_doppeleb_st01",0,0,-20,0.9],
    656 => ["Graphics/Pictures/", "80_sarlacc_st01",0,0,-20,0.9],
    657 => ["Graphics/Pictures/", "80_doppele_st01",0,0,-20,0.9],
    658 => ["Graphics/Pictures/", "80_doppele_st11",0,0,-20,0.9],
    659 => ["Graphics/Pictures/", "80_doppele_st21",0,0,-20,0.9],
    660 => ["Graphics/Pictures/", "80_doppele_st31",0,0,-20,0.9],
    661 => ["Graphics/Pictures/", "80_rucyfina_st21",0,0,-20,0.9],
    662 => ["Graphics/Pictures/", "80_siriel_st01",0,0,-20,0.9],
    663 => ["Graphics/Pictures/", "80_eggel_st01",0,0,-20,0.9],
    664 => ["Graphics/Pictures/", "80_c_chariot_st01",0,0,-20,0.9],
    665 => ["Graphics/Pictures/", "80_knightloid_st01",0,-40,-20,0.9],
    666 => ["Graphics/Pictures/", "80_assassinloid_st01",0,0,-20,0.9],
    667 => ["Graphics/Pictures/", "80_eden_st01",0,0,-20,0.9],
    668 => ["Graphics/Pictures/", "80_yuriel_st01",0,0,-20,0.9],
    669 => ["Graphics/Pictures/", "80_merusiel_st01",0,0,-20,0.9],
    670 => ["Graphics/Pictures/", "80_sebasiel_st01",0,0,-20,0.9],
    671 => ["Graphics/Pictures/", "80_rapun_st01",0,0,-20,0.9],
    672 => ["Graphics/Pictures/", "80_hainu_st01",0,0,-20,0.9],
    673 => ["Graphics/Pictures/", "80_amphis_st01",0,0,-20,0.9],
    674 => ["Graphics/Pictures/", "80_tukuyomi_st01",0,0,-20,0.9],
    675 => ["Graphics/Pictures/", "80_arcen_st01",0,0,-20,0.9],
    676 => ["Graphics/Pictures/", "80_holmiel_st01",0,0,20,0.9],
    677 => ["Graphics/Pictures/", "80_aptiel_st01",0,0,-20,0.9],
    678 => ["Graphics/Pictures/", "80_clionera_st01",0,0,-20,0.9],
    679 => ["Graphics/Pictures/", "80_roseniel_st11",0,0,-20,0.8],
    680 => ["Graphics/Pictures/", "80_cubiel_st01",0,0,-20,0.9],
    681 => ["Graphics/Pictures/", "80_wormiel_st01",0,0,-20,0.9],
    682 => ["Graphics/Pictures/", "80_zylphe_st01",0,0,-20,0.9],
    683 => ["Graphics/Pictures/", "80_gnomaren_st01",0,0,-20,0.9],
    684 => ["Graphics/Pictures/", "80_grandine_st01",0,0,-20,0.9],
    685 => ["Graphics/Pictures/", "80_gigamander_st01",0,0,-20,0.9],
    686 => ["Graphics/Pictures/", "80_micaela_st31",0,0,-20,0.9],
    687 => ["Graphics/Pictures/", "80_iriasu_st41",0,0,-20,0.9],
    688 => ["Graphics/Pictures/", "80_iriasu3_st01",0,0,-20,1.0],
    689 => ["Graphics/Pictures/", "80_iriasu3_st01",0,0,-20,1.0],
    690 => ["Graphics/Pictures/", "80_rafaera_st31",0,30,-20,0.9],
    691 => ["Graphics/Pictures/", "80_fenrir_st01",0,0,-20,0.9],
    692 => ["Graphics/Pictures/", "80_garukimasera_st01",0,0,-20,0.9],
    693 => ["Graphics/Pictures/", "80_greatorc_st01",0,0,-20,0.9],
    694 => ["Graphics/Pictures/", "80_ranccubus_st01",0,0,-20,0.9],
    695 => ["Graphics/Pictures/", "80_leeccubus_st01",0,0,-20,0.9],
    696 => ["Graphics/Pictures/", "80_evaq_st01",0,0,-20,0.9],
    697 => ["Graphics/Pictures/", "80_baphomet_st01",0,0,-20,0.9],
    698 => ["Graphics/Pictures/", "80_kudan_st01",0,0,-20,0.9],
    699 => ["Graphics/Pictures/", "80_vellraune_st01",0,0,-20,0.9],
    700 => ["Graphics/Pictures/", "80_nependeath_st01",0,0,0,0.8],
    701 => ["Graphics/Pictures/", "80_barakizoku_st01",0,0,-20,0.9],
    702 => ["Graphics/Pictures/", "80_moruboru_st01",0,0,-20,0.9],
    703 => ["Graphics/Pictures/", "80_kanon_st12",0,0,-20,0.9],
    704 => ["Graphics/Pictures/", "80_kanon_st11",0,0,00,0.8],
    705 => ["Graphics/Pictures/", "80_kanon_st01",0,0,0,0.9],
    706 => ["Graphics/Pictures/", "80_bombslime_st01",0,0,-20,0.9],
    707 => ["Graphics/Pictures/", "80_liqurslime_st01",0,0,-20,0.9],
    708 => ["Graphics/Pictures/", "80_slimeprin_st01",0,0,-20,0.9],
    709 => ["Graphics/Pictures/", "80_asura_st01",0,0,-20,0.9],
    710 => ["Graphics/Pictures/", "80_gigaslime_st01",0,0,-20,0.9],
    711 => ["Graphics/Pictures/", "80_kanade_st01",0,0,-20,0.9],
    712 => ["Graphics/Pictures/", "80_kanade_st01",0,0,-20,0.9],
    713 => ["Graphics/Pictures/", "80_lamia_n_st01",0,0,-20,0.8],
    714 => ["Graphics/Pictures/", "80_l_medusa_st01",0,0,-20,0.9],
    715 => ["Graphics/Pictures/", "80_pandora_st01",0,0,-20,0.9],
    716 => ["Graphics/Pictures/", "80_cirquec_st31",0,0,-20,0.9],
    717 => ["Graphics/Pictures/", "80_grimoire_st01",0,0,-20,0.9],
    718 => ["Graphics/Pictures/", "80_utubom_st01",0,0,-20,0.9],
    719 => ["Graphics/Pictures/", "80_ancientscylla_st01",0,0,-20,0.8],
    720 => ["Graphics/Pictures/", "80_cirquec_st51",0,70,-20,0.8],
    721 => ["Graphics/Pictures/", "80_ghatanothoa_st01",0,0,20,0.9],
    722 => ["Graphics/Pictures/", "80_asmodeus_st01",0,0,-20,0.9],
    723 => ["Graphics/Pictures/", "80_jormungand_st01",0,0,-20,0.9],
    724 => ["Graphics/Pictures/", "80_s_akaname_st01",0,0,-20,0.9],
    725 => ["Graphics/Pictures/", "80_nekogami_st01",0,0,-20,0.9],
    726 => ["Graphics/Pictures/", "80_kizin_st01",0,0,-20,0.9],
    727 => ["Graphics/Pictures/", "80_onmyosasori_st01",0,-50,-20,0.9],
    728 => ["Graphics/Pictures/", "80_tamamo_st01",0,0,-20,0.9],
    729 => ["Graphics/Pictures/", "80_caitsith_st01",0,0,-20,0.9],
    730 => ["Graphics/Pictures/", "80_galfox_st01",0,0,-20,0.9],
    731 => ["Graphics/Pictures/", "80_tamamo_st61",0,0,-20,0.9],
    732 => ["Graphics/Pictures/", "80_juraabis_st01",0,0,-20,0.9],
    733 => ["Graphics/Pictures/", "80_marchosias_st01",0,0,-20,0.9],
    734 => ["Graphics/Pictures/", "80_a_pterix_st01",0,0,-20,0.8],
    735 => ["Graphics/Pictures/", "80_cirquec_st41",0,0,-20,0.8],
    736 => ["Graphics/Pictures/", "80_loccubus_st01",0,0,-20,0.9],
    737 => ["Graphics/Pictures/", "80_testarossa_st01",0,0,-20,0.9],
    738 => ["Graphics/Pictures/", "80_ek_mermaid_st01",0,0,-20,0.9],
    739 => ["Graphics/Pictures/", "80_greatmarman_st01",0,0,-20,0.9],
    740 => ["Graphics/Pictures/", "80_cirquec_st21",0,0,-20,0.8],
    741 => ["Graphics/Pictures/", "80_cirquec_st21",0,0,-20,0.8],
    742 => ["Graphics/Pictures/", "80_gigadryad_st01",0,0,-20,0.9],
    743 => ["Graphics/Pictures/", "80_ambrosia_st01",0,0,-20,0.9],
    744 => ["Graphics/Pictures/", "80_siva_st01",0,0,-20,0.9],
    745 => ["Graphics/Pictures/", "80_arucubuss_st01",0,0,-20,0.9],
    746 => ["Graphics/Pictures/", "80_lesscubuss_st01",0,0,-20,0.9],
    747 => ["Graphics/Pictures/", "80_granabass_st01",0,0,-20,0.9],
    748 => ["Graphics/Pictures/", "80_chrom_st51",0,-30,-40,1.0],
    749 => ["Graphics/Pictures/", "80_chromg_st01",0,0,0,0.8],
    750 => ["Graphics/Pictures/", "80_chromg_st11",0,0,-20,0.8],
    751 => ["Graphics/Pictures/", "80_minagi_st01",0,0,-20,0.9],
    752 => ["Graphics/Pictures/", "80_alice10th_st01",0,0,-20,0.9],
    753 => ["Graphics/Pictures/", "80_hargenbeck_st21",0,0,-20,0.9],
    754 => ["Graphics/Pictures/", "80_hargenbeck_st01",0,0,-20,0.9],
    755 => ["Graphics/Pictures/", "80_santamaria_st11",0,0,-20,0.9],
    756 => ["Graphics/Pictures/", "80_santamaria_st01",0,0,-20,0.9],
    757 => ["Graphics/Pictures/", "80_elis_st01",0,0,-20,0.9],
    758 => ["Graphics/Pictures/", "80_alice7th_st01",0,0,-20,0.9],
    759 => ["Graphics/Pictures/", "80_shoutmata_st01",0,0,-20,0.9],
    760 => ["Graphics/Pictures/", "80_giantsarah_st01",0,0,-20,0.9],
    761 => ["Graphics/Pictures/", "80_alice11th12th_st01",0,0,-20,0.9],
    762 => ["Graphics/Pictures/", "80_paizuridoll2_st01",0,0,-20,0.8],
    763 => ["Graphics/Pictures/", "80_lovemata_st01",0,0,-20,0.8],
    764 => ["Graphics/Pictures/", "80_alice9th_st01",0,0,-20,0.9],
    765 => ["Graphics/Pictures/", "80_blavatsky_st01",0,0,-20,0.9],
    766 => ["Graphics/Pictures/", "80_alice6th_st01",0,0,-20,0.9],
    767 => ["Graphics/Pictures/", "80_aguni_st01",0,-30,-20,0.8],
    768 => ["Graphics/Pictures/", "80_miyabihime_st01",0,30,-20,0.8],
    769 => ["Graphics/Pictures/", "80_kagetumugi_st01",0,0,-20,0.9],
    770 => ["Graphics/Pictures/", "80_kagetumugi_st11",0,0,-20,0.9],
    771 => ["Graphics/Pictures/", "80_kagetumugi_st21",0,0,-20,0.9],
    772 => ["Graphics/Pictures/", "80_kagetumugi_st31",0,0,-20,0.9],
    773 => ["Graphics/Pictures/", "80_nanccubus_st01",0,0,-20,0.9],
    774 => ["Graphics/Pictures/", "80_pabilsag_st01",0,0,-20,0.9],
    775 => ["Graphics/Pictures/", "80_maneater_st01",0,0,-20,0.9],
    776 => ["Graphics/Pictures/", "80_kodairyu_st01",0,0,-20,0.9],
    777 => ["Graphics/Pictures/", "80_evaq_st01",0,0,-20,0.9],
    778 => ["Graphics/Pictures/", "80_loa_st01",0,0,-20,0.9],
    779 => ["Graphics/Pictures/", "80_hiruko_st01",0,0,-20,0.9],
    780 => ["Graphics/Pictures/", "80_mefist_st31",0,0,-20,0.9],
    781 => ["Graphics/Pictures/", "80_niprell_st01",0,40,-20,0.9],
    782 => ["Graphics/Pictures/", "80_high_baphomet_st01",0,0,-20,0.9],
    783 => ["Graphics/Pictures/", "80_rogueelf_st01",0,0,-20,0.9],
    784 => ["Graphics/Pictures/", "80_hiruko_st01",0,0,-20,0.9],
    785 => ["Graphics/Pictures/", "80_alice3th_st01",0,0,-20,0.9],
    786 => ["Graphics/Pictures/", "80_alice4th_st01",0,0,-20,0.9],
    787 => ["Graphics/Pictures/", "80_alice5th_st01",0,0,-20,0.9],
    788 => ["Graphics/Pictures/", "80_alice6th_st01",0,0,-20,0.9],
    789 => ["Graphics/Pictures/", "80_alice7th_st01",0,0,-20,0.9],
    790 => ["Graphics/Pictures/", "80_alice9th_st01",0,0,-20,0.9],
    791 => ["Graphics/Pictures/", "80_alice10th_st01",0,0,-20,0.9],
    792 => ["Graphics/Pictures/", "80_alice11th12th_st01",0,0,-20,0.9],
    793 => ["Graphics/Pictures/", "80_alice13th_st01",0,0,-20,0.9],
    794 => ["Graphics/Pictures/", "80_alice14th_st01",0,0,-20,0.9],
    795 => ["Graphics/Pictures/", "80_kagetumugi2_st01",0,0,-20,0.9],
    796 => ["Graphics/Pictures/", "80_kagetumugi2_st11",0,40,-20,0.8],
    797 => ["Graphics/Pictures/", "80_alice8th6_st01",0,0,-20,0.9],
    798 => ["Graphics/Pictures/", "80_sirousagi_st21",0,0,-20,0.9],
    799 => ["Graphics/Pictures/", "80_sirousagi_st22",0,0,-20,0.9],
    800 => ["Graphics/Pictures/", "80_sirousagi_st23",0,0,-20,0.9],
    801 => ["Graphics/Pictures/", "80_sinigami_st11",0,0,-20,0.9],
    802 => ["Graphics/Pictures/", "80_sinigami_st12",0,0,-20,0.9],
    803 => ["Graphics/Pictures/", "80_sinigami_st13",0,0,-20,0.9],
    804 => ["Graphics/Pictures/", "80_siniusagi_st01",0,0,-20,0.9],
    805 => ["Graphics/Pictures/", "80_sonia_m1_st21",0,0,-20,0.9],
    806 => ["Graphics/Pictures/", "80_soniaapoto_m1_st27",0,0,-20,0.9],
    807 => ["Graphics/Pictures/", "80_gargoyle_st01",0,0,-20,0.9],
    808 => ["Graphics/Pictures/", "80_athena_st01",0,0,-20,0.9],
    809 => ["Graphics/Pictures/", "80_lilith2_st11",0,0,-20,0.9],
    810 => ["Graphics/Pictures/", "80_erbetie_st01",0,0,-20,0.9],
    811 => ["Graphics/Pictures/", "80_erbetie_st14",0,0,-20,0.9],
    812 => ["Graphics/Pictures/", "80_aun_st01",0,0,-20,0.9],
    813 => ["Graphics/Pictures/", "80_dragonhead_st01",0,-40,20,0.8],
    814 => ["Graphics/Pictures/", "80_monstruo_st01",0,-100,-20,0.9],
    815 => ["Graphics/Pictures/", "80_siva_st01",0,0,-20,0.9],
    816 => ["Graphics/Pictures/", "80_mefist_st41",0,0,-20,0.9],
    817 => ["Graphics/Pictures/", "80_neptune_st01",0,0,-20,0.9],
    818 => ["Graphics/Pictures/", "80_tao_st01",0,0,-20,0.9],
    819 => ["Graphics/Pictures/", "80_moruboru_st01",0,0,-20,0.9],
    820 => ["Graphics/Pictures/", "80_a_pterix_st01",0,0,-20,0.8],
    821 => ["Graphics/Pictures/", "80_asmodeus_st01",0,0,-20,0.9],
    822 => ["Graphics/Pictures/", "80_jormungand_st01",0,0,-20,0.9],
    823 => ["Graphics/Pictures/", "80_alice_st01",0,0,-20,0.9],
    824 => ["Graphics/Pictures/", "80_sazya_st01",0,0,-20,0.9],
    825 => ["Graphics/Pictures/", "80_alice0_st01",0,-40,-20,0.9],
    826 => ["Graphics/Pictures/", "80_alice0_st11",0,0,-20,0.9],
    827 => ["Graphics/Pictures/", "80_alice0_st11",0,0,-20,0.9],
    828 => ["Graphics/Pictures/", "80_zenki_st01",0,0,-20,0.9],
    829 => ["Graphics/Pictures/", "80_kouki_st01",0,0,-20,0.9],
    830 => ["Graphics/Pictures/", "80_heinrich_st51",0,0,-20,0.9],
    832 => ["Graphics/Pictures/", "80_s_gyokuza_st01",0,0,-20,0.9],
    833 => ["Graphics/Pictures/", "80_doubleundead_st01",0,0,-20,0.9],
    834 => ["Graphics/Pictures/", "80_izun_st01",0,0,-20,0.9],
    835 => ["Graphics/Pictures/", "80_carthangels_st01",0,0,-20,0.9],
    836 => ["Graphics/Pictures/", "80_carthangels_st02",0,0,-20,0.9],
    837 => ["Graphics/Pictures/", "80_carthangels_st03",0,0,-20,0.9],
    838 => ["Graphics/Pictures/", "80_algemini_st01",0,0,-20,0.9],
    839 => ["Graphics/Pictures/", "80_elgemini_st01",0,0,-20,1.0],
    840 => ["Graphics/Pictures/", "80_nero_st11",0,0,0,0.8],
    841 => ["Graphics/Pictures/", "80_neris_st11",0,0,-20,0.9],
    842 => ["Graphics/Pictures/", "80_apiro_ragos_st01",0,0,-20,0.9],
    843 => ["Graphics/Pictures/", "80_shemhaza_st01",0,0,-20,0.9],
    844 => ["Graphics/Pictures/", "80_agrave_st01",0,0,-20,0.9],
    845 => ["Graphics/Pictures/", "80_adramelek_st31",0,0,-20,0.9],
    846 => ["Graphics/Pictures/", "80_ex_sonia_st01",0,0,-20,0.9],
    847 => ["Graphics/Pictures/", "80_angolmois_st01",0,0,-20,0.9],
    848 => ["Graphics/Pictures/", "80_starma_st01",0,0,-20,0.9],
    849 => ["Graphics/Pictures/", "80_rajara_st01",0,0,-20,0.9],
    850 => ["Graphics/Pictures/", "80_aptiel_st11",0,0,-20,0.9],
    851 => ["Graphics/Pictures/", "80_megidryad_st01",0,0,-20,0.9],
    852 => ["Graphics/Pictures/", "80_exsera_st01",0,0,-20,0.9],
    853 => ["Graphics/Pictures/", "80_apsaras_st01",0,0,-20,0.9],
    854 => ["Graphics/Pictures/", "80_azazel_st01",0,0,-20,0.9],
    855 => ["Graphics/Pictures/", "80_grigori_st01",0,0,-20,0.9],
    856 => ["Graphics/Pictures/", "80_hiruko_st01",0,0,-20,0.9],
    857 => ["Graphics/Pictures/", "80_kureo_adora_st01",0,0,-20,0.9],
    858 => ["Graphics/Pictures/", "80_apiro_ragos_st01",0,0,-20,0.9],
    859 => ["Graphics/Pictures/", "80_apiro_ragos_st01",0,0,-20,0.9],
    860 => ["Graphics/Pictures/", "80_magatuomikami_st01",0,0,-20,0.9],
    861 => ["Graphics/Pictures/", "80_magatuomikami_st01",0,0,-20,0.9],
    862 => ["Graphics/Pictures/", "80_zoloct_st01",0,0,-20,0.9],
    863 => ["Graphics/Pictures/", "80_tiamat_st01",0,0,-20,0.9],
    864 => ["Graphics/Pictures/", "80_singularity_st21",0,0,-20,0.9],
    865 => ["Graphics/Pictures/", "80_houshi_st01",0,0,20,0.8],
    866 => ["Graphics/Pictures/", "80_spawn_st01",0,0,-20,0.9],
    867 => ["Graphics/Pictures/", "80_sisel_st01",0,0,-20,0.9],
    868 => ["Graphics/Pictures/", "80_exkyubi_st01",0,0,-20,0.9],
    869 => ["Graphics/Pictures/", "80_ozum_st01",0,0,-20,0.9],
    870 => ["Graphics/Pictures/", "80_bloddydragon_st01",0,0,-20,0.9],
    871 => ["Graphics/Pictures/", "80_aptiel_st11",0,0,-20,0.9],
    872 => ["Graphics/Pictures/", "80_amnario_st01",0,0,-20,0.9],
    873 => ["Graphics/Pictures/", "80_samael_st01",0,0,20,0.8],
    874 => ["Graphics/Pictures/", "80_shadowassassin_st01",0,40,20,0.8],
    875 => ["Graphics/Pictures/", "80_unknown1_st01",0,0,20,0.8],
    876 => ["Graphics/Pictures/", "80_unknown2_st01",0,0,20,0.8],
    877 => ["Graphics/Pictures/", "80_unknown3_st01",0,0,20,0.8],
    878 => ["Graphics/Pictures/", "80_unknown4_st01",0,0,20,0.8],
    879 => ["Graphics/Pictures/", "80_unknown5_st01",0,0,20,0.8],
    880 => ["Graphics/Pictures/", "80_dragonp_st31",0,0,-20,0.9],
    881 => ["Graphics/Pictures/", "80_curseloreley_st01",0,0,-40,1.0],
    882 => ["Graphics/Pictures/", "80_voremermaid_st01",0,0,-20,0.9],
    883 => ["Graphics/Pictures/", "80_worlddrown_st01",0,0,-20,0.9],
    884 => ["Graphics/Pictures/", "80_pazuzu_st01",0,0,0,0.9],
    885 => ["Graphics/Pictures/", "80_masutema_st01",0,0,-20,0.9],
    886 => ["Graphics/Pictures/", "80_queenmoss_st21",0,0,-20,0.9],
    887 => ["Graphics/Pictures/", "80_dragonbone_st01",0,-40,20,0.8],
    888 => ["Graphics/Pictures/", "80_amenohaduti_st01",0,0,-20,0.9],
    889 => ["Graphics/Pictures/", "80_hasyakusama_st01",0,0,-20,0.9],
    890 => ["Graphics/Pictures/", "80_nihuta_telos_st01",0,0,-20,0.9],
    891 => ["Graphics/Pictures/", "80_dragonbone_st01",0,-40,20,0.8],
    892 => ["Graphics/Pictures/", "80_angolmois_st01",0,0,-20,0.9],
    893 => ["Graphics/Pictures/", "80_magatuomikami_st01",0,0,-20,0.9],
    894 => ["Graphics/Pictures/", "80_alice3th_st11",0,0,20,0.8],
    895 => ["Graphics/Pictures/", "80_alice4th_st11",0,0,20,0.8],
    896 => ["Graphics/Pictures/", "80_alice5th_st11",0,0,20,0.8],
    897 => ["Graphics/Pictures/", "80_alice6th_st11",0,0,20,0.8],
    898 => ["Graphics/Pictures/", "80_alice7th_st11",0,0,20,0.8],
    899 => ["Graphics/Pictures/", "80_alice9th_st11",0,0,20,0.8],
    900 => ["Graphics/Pictures/", "80_alice10th_st11",0,-50,20,0.8],
    901 => ["Graphics/Pictures/", "80_alice11th_st01",0,50,20,0.8],
    902 => ["Graphics/Pictures/", "80_alice12th_st01",0,-30,20,0.8],
    903 => ["Graphics/Pictures/", "80_alice13th_st11",0,0,20,0.8],
    904 => ["Graphics/Pictures/", "80_alice14th_st11",0,0,20,0.8],
    905 => ["Graphics/Pictures/", "80_kanade_st01",0,0,-20,0.9],
    906 => ["Graphics/Pictures/", "80_hiruko_st01",0,0,-20,0.9],
    907 => ["Graphics/Pictures/", "80_gestalt_st01",0,0,-20,0.9],
    908 => ["Graphics/Pictures/", "80_hivemind_st01",0,0,-20,0.9],
    909 => ["Graphics/Pictures/", "80_baal_zebub_st01",0,0,-20,0.9],
    910 => ["Graphics/Pictures/", "80_gob_st31",0,0,-20,0.9],
    911 => ["Graphics/Pictures/", "80_pramia_st21",0,0,0,0.9],
    912 => ["Graphics/Pictures/", "80_vgirl_st31",0,0,0,0.9],
    913 => ["Graphics/Pictures/", "80_madamlamia_st01",0,0,-20,0.9],
    914 => ["Graphics/Pictures/", "80_lily_st21",0,0,-20,0.9],
    915 => ["Graphics/Pictures/", "80_nyumaou_st11",0,20,0,0.9],
    916 => ["Graphics/Pictures/", "80_cassandra_st61",0,0,-20,0.9],
    917 => ["Graphics/Pictures/", "80_lilith_st01",0,0,-20,0.9],
    918 => ["Graphics/Pictures/", "80_witchs_st21",0,0,-20,0.9],
    919 => ["Graphics/Pictures/", "80_carmilla_st01",0,0,-20,0.9],
    920 => ["Graphics/Pictures/", "80_elisabeth_st01",0,0,-20,0.9],
    921 => ["Graphics/Pictures/", "80_queenvanpire_st31",0,0,-20,0.9],
    922 => ["Graphics/Pictures/", "80_satanachia_st01",0,0,-50,1.0],
    923 => ["Graphics/Pictures/", "80_bloddydragon_st01",0,0,-20,0.9],
    924 => ["Graphics/Pictures/", "80_evaq_st01",0,0,-20,0.9],
    925 => ["Graphics/Pictures/", "80_evaq_st01",0,0,-20,0.9],
    926 => ["Graphics/Pictures/", "80_evaq_st01",0,0,-20,0.9],
    927 => ["Graphics/Pictures/", "80_satan_st01",0,-50,-20,0.9],
    928 => ["Graphics/Pictures/", "80_paizuridoll3_st01",0,0,0,0.8],
    929 => ["Graphics/Pictures/", "80_ironmaiden_s_st01",0,0,-20,0.9],
    930 => ["Graphics/Pictures/", "80_doll_itai_st01",0,0,-20,0.9],
    931 => ["Graphics/Pictures/", "80_kagetumugi_st01",0,0,-20,0.9],
    932 => ["Graphics/Pictures/", "80_magda_st01",0,0,-20,0.9],
    933 => ["Graphics/Pictures/", "80_sisel_st01",0,0,-20,0.9],
    934 => ["Graphics/Pictures/", "80_azazel_st01",0,0,-20,0.9],
    935 => ["Graphics/Pictures/", "80_grigori_st01",0,0,-20,0.9],
    936 => ["Graphics/Pictures/", "80_hakutenko_st01",0,0,-20,0.9],
    937 => ["Graphics/Pictures/", "80_myouhouzyorougumo_st01",0,0,-20,0.9],
    938 => ["Graphics/Pictures/", "80_skyuba_st01",0,0,-20,0.9],
    939 => ["Graphics/Pictures/", "80_morrigan_st01",0,0,-20,0.9],
    940 => ["Graphics/Pictures/", "80_astaroth_st01",0,0,-20,0.9],
    941 => ["Graphics/Pictures/", "80_lilith2_st01",0,0,-20,0.9],
    942 => ["Graphics/Pictures/", "80_echidna_st01",0,0,-20,0.9],
    943 => ["Graphics/Pictures/", "80_echidna_st01",0,0,-20,0.9],
    944 => ["Graphics/Pictures/", "80_houshi_st01",0,0,20,0.8],
    945 => ["Graphics/Pictures/", "80_spawn_st01",0,0,-20,0.9],
    946 => ["Graphics/Pictures/", "80_cthulhu_st01b",0,0,0,0.9],
    947 => ["Graphics/Pictures/", "80_zigen_kenzoku_st01",0,0,-30,0.9],
    948 => ["Graphics/Pictures/", "80_zigen_kenzoku2_st01",0,0,-40,0.8],
    949 => ["Graphics/Pictures/", "80_outerjelly_st01",0,0,-20,0.9],
    950 => ["Graphics/Pictures/", "80_outerworm_st01",0,0,-40,0.9],
    951 => ["Graphics/Pictures/", "80_zigen_boss_st11",0,0,-20,1.0],
    952 => ["Graphics/Pictures/", "80_phoenixb_st01",0,0,-20,0.9],
    953 => ["Graphics/Pictures/", "80_darkphenix_st01",0,30,-40,1.0],
    954 => ["Graphics/Pictures/", "80_hosikui_st11",0,0,-20,0.9],
    955 => ["Graphics/Pictures/", "80_hosikui_st01",0,0,-20,0.9],
    956 => ["Graphics/Pictures/", "80_null_kenzoku_st01",0,0,-20,0.8],
    957 => ["Graphics/Pictures/", "80_null_kenzoku_st02",0,0,-20,0.8],
    958 => ["Graphics/Pictures/", "80_null_kenzoku_st03",0,0,-20,0.8],
    959 => ["Graphics/Pictures/", "80_TT_st01",0,0,-20,0.8],
    960 => ["Graphics/Pictures/", "80_QQ_st01",0,0,-20,0.9],
    961 => ["Graphics/Pictures/", "80_nurukox_st11",0,0,-20,0.9],
    962 => ["Graphics/Pictures/", "80_gran_arachne_st01",0,0,-20,0.9],
    963 => ["Graphics/Pictures/", "80_sirousagi_st25",0,0,-20,0.9],
    964 => ["Graphics/Pictures/", "80_sinigami_doro0",0,0,-20,0.9],
    965 => ["Graphics/Pictures/", "80_sirousagi_st24",0,0,-20,0.9],
    966 => ["Graphics/Pictures/", "80_sinigami_st14",0,0,-20,0.9],
    967 => ["Graphics/Pictures/", "80_ex_sonia_st21",0,0,-20,0.9],
    968 => ["Graphics/Pictures/", "80_berial_st01b",0,0,-20,0.9],
    969 => ["Graphics/Pictures/", "80_koron_st01",0,0,-20,0.8],
    970 => ["Graphics/Pictures/", "80_koron_st01",0,0,-20,0.8],
    971 => ["Graphics/Pictures/", "80_apiro_ragos_st01",0,0,-20,0.9],
    972 => ["Graphics/Pictures/", "80_gazer_st01",0,0,-20,0.9],
    973 => ["Graphics/Pictures/", "80_indora_st01",0,0,-20,0.9],
    974 => ["Graphics/Pictures/", "80_tonberi_st01",0,0,-20,0.9],
    975 => ["Graphics/Pictures/", "80_tonberi_st01",0,0,-20,0.9],
    976 => ["Graphics/Pictures/", "80_abaddon_st01",0,0,-20,0.9],
    977 => ["Graphics/Pictures/", "80_exkyubi_st01",0,0,-20,0.9],
    978 => ["Graphics/Pictures/", "80_dolladolla_st01",0,-30,10,0.9],
    979 => ["Graphics/Pictures/", "80_beelzebub_s_st01",0,0,-20,0.9],
    980 => ["Graphics/Pictures/", "80_merkava_st01",0,0,-20,0.9],
    981 => ["Graphics/Pictures/", "80_ozum_st01",0,0,-20,0.9],
    982 => ["Graphics/Pictures/", "80_agaliarept_st01b",0,0,-20,0.9],
    983 => ["Graphics/Pictures/", "80_gazer_st01",0,0,-20,0.9],
    984 => ["Graphics/Pictures/", "80_berial_st01b",0,0,-20,0.9],
    985 => ["Graphics/Pictures/", "80_mazin_st01b",0,0,-20,0.9],
    986 => ["Graphics/Pictures/", "80_megami_st01b",0,0,-20,0.9],
    987 => ["Graphics/Pictures/", "80_kizin2_st01b",0,0,-20,0.9],
    988 => ["Graphics/Pictures/", "80_worldbreaker_st01",0,0,-20,0.9],
    989 => ["Graphics/Pictures/", "80_judgement_st01",0,0,-20,0.9],
    990 => ["Graphics/Pictures/", "80_deusex_st01",0,0,-20,0.9],
    991 => ["Graphics/Pictures/", "80_chaos_st01",0,0,-20,0.9],
    992 => ["Graphics/Pictures/", "80_chaos_st01",0,0,-20,0.9],
    993 => ["Graphics/Pictures/", "80_chaos_st01",0,0,-20,0.9],
    994 => ["Graphics/Pictures/", "80_hiruko_st01",0,0,-20,0.9],
    995 => ["Graphics/Pictures/", "80_kanon_st01",0,0,0,0.9],
    996 => ["Graphics/Pictures/", "80_kanade_st01",0,0,-20,0.9],
    997 => ["Graphics/Pictures/", "80_idea_rukas_st01",0,0,-20,0.9],
    998 => ["Graphics/Pictures/", "80_agaliarept_st01b",0,0,-20,0.9],

  }
  
  # 敵遭遇場所
  # 文字列はシンボルで統一してください
  ENCOUNTER_ENEMY_PLACE = {
    1  => [:"Iliasville Mountains", :Around Iliasville, :Cave of Trials],
    2  => [:"Iliasville Mountains"],
    3  => [:Around Iliasville],
    4  => [:Around Iliasville, :Cave of Trials, :Slug Tower],
    5  => [:Cave of Trials, :Talus Hill, :North Ilina Mountains Cave],
    6  => [:Talus Hill, :Around Iliasburg],
    7  => [:Talus Hill, :Around Iliasburg],
    8  => [:Around Iliasburg, :North Ilina Mountains Cave, :South Ilina Mountains Cave],
    9  => [:North Ilina Mountains Cave],
    10  => [:North Ilina Mountains Cave],
    11  => [:North Ilina Mountains Cave],
    12  => [:North Ilina Mountains Cave],
    13  => [:South Ilina Mountains Cave, :Around Nameless Slums],
    14  => [:South Ilina Mountains Cave, :Around Nameless Slums, :Around Pornof],
    15  => [:Nameless Slums],
    16  => [:Around Pornof, :Pornof Mines, :Around Iliasport],
    17  => [:Around Pornof, :Pornof Mines, :Around Happiness Village],
    18  => [:Pornof Mines, :Around Happiness Village],
    19  => [:Tartarus （Ilias Continent South）],
    20  => [:Tartarus （Ilias Continent South）],
    21  => [:Tartarus （Ilias Continent South）],
    22  => [:Tartarus （Ilias Continent South）],
    23  => [:Around Happiness Village, :Rostrum Mountain Caverns],
    24  => [:Around Happiness Village],
    25  => [:Around Happiness Village, :Harpy Tower],
    26  => [:Harpy Tower],
    27  => [:Harpy Tower],
    28  => [:Harpy Tower],
    29  => [:Slug Tower],
    30  => [:Slug Tower],
    31  => [:Slug Tower],
    32  => [:Midas Abandoned Mines, :Lost Woods],
    33  => [:Midas Abandoned Mines, :Rostrum Mountain Caverns, :Around Iliasport],
    34  => [:Midas Abandoned Mines, :Rostrum Mountain Caverns, :Cave of Treasures],
    35  => [:Rostrum Mountain Caverns],
    36  => [:Tartarus （Ilias Continent East）],
    37  => [:Tartarus （Ilias Continent East）],
    38  => [:Tartarus （Ilias Continent East）],
    39  => [:Lost Woods, :Lemuse Beach],
    40  => [:Lost Woods, :Lemuse Beach],
    41  => [:Lost Woods],
    42  => [:Lemuse Beach, :Eastern Natalia Region],
    43  => [:Lemuse Beach],
    44  => [:Around Iliasport],
    45  => [:Around Iliasport, :Eastern Natalia Region],
    46  => [:Cave of Treasures],
    47  => [:Cave of Treasures],
    48  => [:Cave of Treasures],
    49  => [:Various Places],
    50  => [:Cave of Treasures],
    51  => [:Eastern Natalia Region],
    52  => [:Eastern Natalia Region, :Natalia Coast],
    53  => [:Eastern Natalia Region, :Natalia Coast],
    54  => [:Eastern Natalia Region, :Natalia Coast],
    55  => [:Eastern Natalia Region],
    56  => [:Eastern Natalia Region],
    57  => [:Eastern Natalia Region],
    58  => [:Eastern Natalia Region, :Mount Saint Amos],
    59  => [:Natalia Coast, :Southern Undersea Temple],
    60  => [:Southern Undersea Temple],
    61  => [:Southern Undersea Temple],
    62  => [:Southern Undersea Temple],
    63  => [:Southern Undersea Temple],
    64  => [:Underground Library],
    65  => [:Underground Library],
    66  => [:Underground Library],
    67  => [:Mount Saint Amos],
    68  => [:Mount Saint Amos],
    69  => [:Mount Saint Amos],
    70  => [:Mount Saint Amos],
    71  => [:Ancient Temple Ruins],
    72  => [:Ancient Temple Ruins],
    73  => [:Ancient Temple Ruins],
    74  => [:Ancient Temple Ruins],
    75  => [:Haunted Mansion],
    76  => [:Haunted Mansion],
    77  => [:Haunted Mansion],
    78  => [:Haunted Mansion],
    79  => [:Haunted Mansion],
    80  => [:Haunted Mansion],
    81  => [:Haunted Mansion],
    82  => [:Haunted Mansion],
    83  => [:Haunted Mansion],
    84  => [:Forest of Spirits],
    85  => [:Forest of Spirits],
    86  => [:Forest of Spirits],
    87  => [:Forest of Spirits],
    88  => [:Forest of Spirits],
    89  => [:Forest of Spirits],
    90  => [:Forest of Spirits],
    91  => [:Forest of Spirits],
    92  => [:Forest of Spirits],
    93  => [:Forest of Spirits],
    94  => [:Forest of Spirits],
    95  => [:Western Natalia Region, :Carlos Hill],
    96  => [:Western Natalia Region, :"Seeker's Cave", :"Minotauros' Labyrinth"],
    97  => [:Western Natalia Region, :Carlos Hill],
    98  => [:Carlos Hill],
    99  => [:Carlos Hill, :"Seeker's Cave"],
    100  => [:"Seeker's Cave"],
    101  => [:Southern Sabasa Desert, :Pyramid],
    102  => [:Southern Sabasa Desert, :Oasis of Blessings, :Northern Sabasa Desert],
    103  => [:Southern Sabasa Desert, :Oasis of Blessings, :Northern Sabasa Desert],
    104  => [:Southern Sabasa Desert, :Northern Sabasa Desert],
    105  => [:Pyramid],
    106  => [:Pyramid, :Northern Sabasa Desert],
    107  => [:Pyramid],
    108  => [:Pyramid],
    109  => [:Sabasa],
    110  => [:Sabasa],
    111  => [:Northern Sabasa Desert, :Oasis of Blessings, :Around Magistea Village],
    112  => [:Grandeur],
    113  => [:Around Magistea Village, :Saloon Hill],
    114  => [:Around Magistea Village, :Saloon Hill],
    115  => [:"Lily's Mansion"],
    116  => [:"Lily's Mansion", :Tower of Magic],
    117  => [:"Lily's Mansion", :Tower of Magic],
    118  => [:"Lily's Mansion"],
    119  => [:Various Places],
    120  => [:"Lily's Mansion"],
    121  => [:Tower of Magic, :Saloon Abandoned Mines],
    122  => [:Tower of Magic],
    123  => [:Tower of Magic],
    124  => [:Tower of Magic],
    125  => [:Saloon Hill, :Great Marle Corridor],
    126  => [:Saloon Abandoned Mines],
    127  => [:Saloon Abandoned Mines],
    128  => [:Saloon Abandoned Mines],
    129  => [:Safar Ruins],
    130  => [:Safar Ruins],
    131  => [:Safar Ruins],
    132  => [:Safar Ruins],
    133  => [:Safar Ruins],
    134  => [:Tartarus （Sabasa Continent North）],
    135  => [:Tartarus （Sabasa Continent North）],
    136  => [:Tartarus （Sabasa Continent North）],
    137  => [:Tartarus （Sabasa Continent North）],
    138  => [:"Administrator's Tower"],
    139  => [:"Administrator's Tower"],
    140  => [:"Administrator's Tower"],
    141  => [:"Administrator's Tower"],
    142  => [:"Administrator's Tower"],
    143  => [:"Administrator's Tower"],
    144  => [:Hades],
    145  => [:Hades],
    146  => [:Around Iliasville （Alt）],
    147  => [:Around Iliasville （Alt）],
    151  => [:Great Marle Corridor],
    152  => [:Great Marle Corridor, :Around Port Marle],
    153  => [:Great Marle Corridor, :Around Port Marle],
    154  => [:Around Port Marle, :Inland Sea],
    155  => [:Inland Sea],
    156  => [:Inland Sea, :MS Fish, :"Grand Pirate's Cave"],
    157  => [:Inland Sea, :MS Fish, :"Grand Pirate's Cave"],
    158  => [:Inland Sea],
    159  => [:Inland Sea],
    160  => [:Inland Sea],
    161  => [:"Grand Pirate's Cave"],
    162  => [:"Grand Pirate's Cave"],
    163  => [:"Grand Pirate's Cave"],
    164  => [:"Grand Pirate's Cave"],
    165  => [:"Grand Pirate's Cave", :Navy Headquarters, :Lyra Falls],
    166  => [:"Grand Pirate's Cave", :Navy Headquarters, :Lyra Falls],
    167  => [:Navy Headquarters],
    168  => [:Around Grand Noah, :Fossil Mines],
    169  => [:Around Grand Noah, :Fossil Mines],
    170  => [:Around Grand Noah],
    171  => [:Around Grand Noah],
    172  => [:Fossil Mines, :Labyrinth Caverns],
    173  => [:Fossil Mines, :Labyrinth Caverns],
    174  => [:Various Places],
    175  => [:Grand Noah],
    176  => [:Grand Noah],
    177  => [:Grand Noah],
    178  => [:Grand Noah],
    179  => [:Labyrinth Caverns, :Yamatai Cave],
    180  => [:"Minotauros' Labyrinth"],
    181  => [:"Minotauros' Labyrinth"],
    182  => [:"Minotauros' Labyrinth"],
    183  => [:"Minotauros' Labyrinth"],
    184  => [:"Minotauros' Labyrinth"],
    185  => [:Yamatai Cave],
    186  => [:Yamatai Cave],
    187  => [:Yamatai Cave],
    188  => [:Around Yamatai, :Around Esta],
    189  => [:Around Yamatai, :"Orochi's Cave"],
    190  => [:Around Yamatai, :Around Esta],
    191  => [:Around Yamatai, :Around Esta],
    192  => [:Yamatai Village],
    193  => [:"Orochi's Cave"],
    194  => [:"Orochi's Cave"],
    195  => [:"Orochi's Cave"],
    196  => [:"Orochi's Cave"],
    197  => [:Magical Academy],
    198  => [:Magical Academy],
    199  => [:Magical Academy],
    200  => [:Magical Academy],
    201  => [:Magical Academy],
    202  => [:Magical Academy],
    203  => [:Magical Academy],
    204  => [:Around Esta, :Red Mountain],
    205  => [:Around Esta, :Red Mountain],
    206  => [:Plansect Village],
    207  => [:Plansect Village],
    208  => [:Plansect Village],
    209  => [:Plansect Village],
    210  => [:Plansect Village],
    211  => [:Plansect Village],
    212  => [:Plansect Village],
    213  => [:Plansect Village],
    214  => [:Plansect Village],
    215  => [:Plansect Village],
    216  => [:Red Mountain],
    217  => [:Red Mountain],
    218  => [:Red Mountain],
    219  => [:Red Mountain],
    220  => [:Red Mountain],
    221  => [:Plansect Village],
    222  => [:Red Mountain],
    223  => [:Esta],
    224  => [:Esta],
    225  => [:"Undine's Spring"],
    226  => [:"Undine's Spring"],
    227  => [:"Undine's Spring"],
    228  => [:"Undine's Spring"],
    229  => [:"Undine's Spring"],
    230  => [:"Undine's Spring"],
    231  => [:"Undine's Spring"],
    232  => [:"Undine's Spring"],
    233  => [:Lima Village Ruins, :Gold Fort, :Around Goddard, :March Hills, :Grangold],
    234  => [:Lima Village Ruins, :Gold Fort, :March Hills, :Grangold],
    235  => [:Gold Fort, :March Hills, :Grangold],
    236  => [:Around Goddard, :Gold Coast],
    237  => [:Around Goddard, :Gold Coast],
    238  => [:Around Goddard],
    239  => [:Eastern Gold Toxic Swamp],
    240  => [:Eastern Gold Toxic Swamp],
    241  => [:Eastern Gold Toxic Swamp],
    242  => [:Eastern Gold Toxic Swamp],
    243  => [:Eastern Gold Toxic Swamp],
    244  => [:Gold Coast],
    245  => [:March Hills, :Around Grangold],
    246  => [:March Hills, :Around Grangold],
    247  => [:March Hills, :Around Grangold],
    248  => [:March Hills],
    249  => [:Around Grangold],
    250  => [:Grangold],
    251  => [:Grangold],
    252  => [:Grangold],
    253  => [:Grangold],
    254  => [:Grangold],
    255  => [:Grangold],
    256  => [:Lava Mines, :Gold Volcano],
    257  => [:Lava Mines, :Gold Volcano],
    258  => [:Lava Mines, :Gold Volcano],
    259  => [:Ghost Ship, :Open Sea],
    260  => [:Ghost Ship, :Northern Undersea Temple],
    261  => [:Ghost Ship, :Northern Undersea Temple],
    262  => [:Ghost Ship],
    263  => [:Ghost Ship],
    264  => [:Ghost Ship],
    265  => [:Northern Undersea Temple, :Open Sea],
    266  => [:Northern Undersea Temple, :Open Sea],
    267  => [:Northern Undersea Temple],
    268  => [:Succubus Village],
    269  => [:Succubus Village],
    270  => [:Succubus Village],
    271  => [:Succubus Village],
    272  => [:Succubus Village],
    273  => [:Succubus Village],
    274  => [:Succubus Village],
    275  => [:Succubus Village],
    275  => [:Succubus Village],
    276  => [:Succubus Village],
    277  => [:Succubus Village],
    278  => [:"Lady's Village"],
    279  => [:Scenic Hill],
    280  => [:Scenic Hill],
    281  => [:Scenic Hill],
    282  => [:Scenic Hill],
    283  => [:Gold Volcano],
    284  => [:Gold Volcano],
    285  => [:Gold Volcano],
    286  => [:Gold Volcano],
    287  => [:Nightmare Wastes],
    288  => [:Nightmare Wastes, :Around Devastated Plains],
    289  => [:Nightmare Wastes, :Around Devastated Plains],
    290  => [:Around Devastated Plains, :Vampire Castle],
    291  => [:Tartarus （Gold Continent West）],
    292  => [:Tartarus （Gold Continent West）],
    293  => [:Tartarus （Gold Continent West）],
    294  => [:Tartarus （Gold Continent West）],
    295  => [:Succubus Village （Alt）],
    296  => [:Eastern Gold Toxic Swamp],
    297  => [:Eastern Gold Toxic Swamp],
    298  => [:Eastern Gold Toxic Swamp],
    299  => [:Open Sea],
    300  => [:Open Sea],
    301  => [:Open Sea],
    302  => [:Open Sea],
    303  => [:"Fairy's Island"],
    304  => [:"Fairy's Island"],
    305  => [:"Fairy's Island"],
    306  => [:"Fairy's Island"],
    307  => [:"Fairy's Island"],
    308  => [:"Fairy's Island"],
    309  => [:The World Tree],
    310  => [:The World Tree],
    311  => [:The World Tree],
    312  => [:The World Tree],
    313  => [:The World Tree],
    314  => [:The World Tree],
    315  => [:The World Tree],
    316  => [:Lyra Falls],
    317  => [:Lyra Falls],
    318  => [:Lyra Falls],
    319  => [:Lyra Falls],
    320  => [:Lyra Falls],
    321  => [:The Secluded Lands],
    322  => [:The Secluded Lands],
    323  => [:The Secluded Lands],
    324  => [:The Secluded Lands],
    325  => [:The Secluded Lands],
    326  => [:The Secluded Lands],
    327  => [:The Secluded Lands],
    328  => [:Vampire Castle],
    329  => [:Vampire Castle],
    330  => [:Vampire Castle],
    331  => [:Vampire Castle],
    332  => [:Vampire Castle],
    333  => [:Vampire Castle],
    334  => [:Hellgondo Cave （Alt）],
    335  => [:Hellgondo Cave （Alt）],
    336  => [:Hellgondo Cave （Alt）, :Hellgondo Continent （Alt）],
    337  => [:Hellgondo Cave （Alt）, :Hellgondo Continent （Alt）],
    338  => [:Hellgondo Continent （Alt）, :"Monster Lord's Castle （Alt）"],
    339  => [:Hellgondo Continent （Alt）, :"Monster Lord's Castle （Alt）"],
    340  => [:Hellgondo Continent （Alt）],
    341  => [:"Monster Lord's Castle （Alt）"],
    342  => [:"Monster Lord's Castle （Alt）"],
    343  => [:"Monster Lord's Castle （Alt）"],
    344  => [:"Monster Lord's Castle （Alt）"],
    345  => [:"Monster Lord's Castle （Alt）"],
    346  => [:"Monster Lord's Castle （Alt）"],
    347  => [:"Monster Lord's Castle （Alt）"],
    348  => [:"Monster Lord's Castle （Alt）"],
    349  => [:"Monster Lord's Castle （Alt）"],
    350  => [:"Monster Lord's Castle （Alt）"],
    351  => [:Snow Cave],
    352  => [:Snow Cave, :Around Snow Heaven],
    353  => [:Snow Cave, :Around Snow Heaven],
    354  => [:Snow Cave, :Around Snow Heaven],
    355  => [:Snow Cave, :Around Snow Heaven],
    356  => [:Snow Cave, :Around Snow Heaven],
    357  => [:Snow Cave, :Around Snow Heaven],
    358  => [:Around Snow Heaven],
    359  => [:Around Snow Heaven],
    360  => [:Around Snow Heaven],
    361  => [:Around Snow Heaven, :Snow Shrine],
    362  => [:Around Snow Heaven, :Snow Shrine],
    363  => [:Snow Shrine, :Ilias Temple Ruins],
    364  => [:Snow Shrine, :Ilias Temple Ruins],
    365  => [:Snow Shrine],
    366  => [:Ilias Temple Ruins],
    367  => [:Ilias Temple Ruins],
    368  => [:Ilias Temple Ruins],
    369  => [:Ilias Temple Ruins],
    370  => [:Ilias Temple Ruins],
    373  => [:Ilias Temple Ruins, :Devastated Plains],
    374  => [:Ilias Temple Ruins, :Devastated Plains],
    375  => [:Ilias Temple Ruins, :Devastated Plains],
    376  => [:Ilias Temple Ruins, :Devastated Plains],
    377  => [:Ilias Temple Ruins, :Devastated Plains],
    378  => [:Devastated Plains],
    379  => [:Devastated Plains],
    380  => [:Devastated Plains],
    381  => [:Devastated Plains],
    382  => [:Devastated Plains],
    383  => [:Devastated Plains],
    384  => [:Grangold],
    385  => [:Ancient Temple Ruins],
    455  => [:Collab Scenario],
    456  => [:Collab Scenario],
    457  => [:Collab Scenario],
    460  => [:Collab Scenario],
    462  => [:Collab Scenario],
    470  => [:Collab Scenario],
    471  => [:Collab Scenario],
    472  => [:Collab Scenario],
    473  => [:Collab Scenario],
    474  => [:Collab Scenario],
    475  => [:Collab Scenario],
    476  => [:Collab Scenario],
    477  => [:Collab Scenario],
    478  => [:Collab Scenario],
    479  => [:Collab Scenario],
    480  => [:Collab Scenario],
    481  => [:Collab Scenario],
    482  => [:Collab Scenario],
    483  => [:Collab Scenario],
    484  => [:Collab Scenario],
    485  => [:Collab Scenario],
    486  => [:Collab Scenario],
    487  => [:Collab Scenario],
    488  => [:Collab Scenario],
    489  => [:Collab Scenario],
    490  => [:Collab Scenario],
    491  => [:Collab Scenario],
    492  => [:Collab Scenario],
    494  => [:Collab Scenario],
    498  => [:Eastern Gold Toxic Swamp],
499 => [:Pocket Castle],
501 => [:Mount Saint Amos],
502 => [:Forgotten Tower],
503 => [:Forgotten Tower],
504 => [:Forgotten Tower],
505 => [:Forgotten Tower],
506 => [:Forgotten Tower],
507 => [:Various Places],
508 => [:Kitsune Village, :Tanuki Village],
509 => [:Kitsune Village, :Tanuki Village],
510 => [:Kitsune Village, :Tanuki Village],
511 => [:Kitsune Village, :Tanuki Village],
512 => [:Tanuki Village],
513 => [:Tanuki Village],
514 => [:Tanuki Village],
515 => [:Mount Horai, :Elf Village],
516 => [:Mount Horai, :Elf Village],
517 => [:Mount Horai, :Elf Village],
518 => [:Mount Horai, :Elf Village],
519 => [:Mount Horai, :Elf Village],
520 => [:Mount Horai, :Elf Village],
521 => [:Mount Horai, :Elf Village],
522 => [:Elf Village],
523 => [:Elf Village],
524 => [:Hellgondo Continent],
525 => [:"Monster Lord's Castle"],
526 => [:"Monster Lord's Castle"],
527 => [:"Monster Lord's Castle"],
528 => [:"Monster Lord's Castle"],
529 => [:"Monster Lord's Castle"],
530 => [:"Monster Lord's Castle"],
531 => [:"Monster Lord's Castle"],
532 => [:"Monster Lord's Castle"],
533 => [:"Monster Lord's Castle"],
534 => [:"Monster Lord's Castle"],
535 => [:"Monster Lord's Castle"],
536 => [:"Monster Lord's Castle"],
537 => [:"Monster Lord's Castle"],
538 => [:"Monster Lord's Castle"],
539 => [:"Monster Lord's Castle"],
540 => [:"Monster Lord's Castle"],
541 => [:"Monster Lord's Castle"],
542 => [:"Monster Lord's Castle"],
543 => [:"Monster Lord's Castle"],
544 => [:Tartarus （Esta）, :Tartarus （West Hellgondo）],
545 => [:Tartarus （Esta）, :Tartarus （West Hellgondo）],
546 => [:Tartarus （Esta）, :Tartarus （West Hellgondo）],
547 => [:Tartarus （Esta）, :Tartarus （West Hellgondo）],
548 => [:Tartarus （Esta）, :Tartarus （West Hellgondo）],
549 => [:Tartarus （Esta）, :Tartarus （West Hellgondo）],
550 => [:Tartarus （Esta）],
551 => [:Tartarus （West Hellgondo）, :Ilias Temple （Chaos）],
552 => [:Tartarus （Esta）, :"Dark Goddess' Castle （Chaos）"],
554 => [:Around Esta （AD）, :"Administrator's Tower （AD）", :"Water Spirit's Spring （AD）"],
555 => [:Around Esta （AD）, :"Administrator's Tower （AD）", :"Water Spirit's Spring （AD）"],
556 => [:"Administrator's Tower （AD）", :Around Sabasa （AD）, :"Water Spirit's Spring （AD）", :Safar Ruins （AD）],
557 => [:"Water Spirit's Spring （AD）"],
558 => [:"Administrator's Tower （AD）", :Around Sabasa （AD）, :Safar Ruins （AD）],
559 => [:"Administrator's Tower （AD）", :Around Sabasa （AD）, :Safar Ruins （AD）, :Sabasa （AD）],
560 => [:"Administrator's Tower （AD）"],
561 => [:"Administrator's Tower （AD）"],
562 => [:Around Sabasa （AD）, :Safar Ruins （AD）, :Sabasa （AD）],
563 => [:Safar Ruins （AD）, :Sabasa （AD）],
564 => [:Safar Ruins （AD）],
565 => [:Sabasa （AD）, :Around Grand Noah （AD）],
566 => [:Sabasa （AD）, :Around Grand Noah （AD）],
567 => [:Sabasa （AD）],
568 => [:Around Grand Noah （AD）, :Grand Noah （AD）, :Grangold （AD）],
569 => [:Grand Noah （AD）, :Grangold （AD）, :Around Grangold （AD）, :Gold Volcano （AD）],
570 => [:Grand Noah （AD）],
571 => [:Grand Noah （AD）, :Gold Volcano （AD）],
572 => [:Grand Noah （AD）],
573 => [:Grand Noah （AD）],
574 => [:Grangold （AD）, :Around Grangold （AD）],
575 => [:Grangold （AD）, :Around Grangold （AD）],
576 => [:Grangold （AD）],
577 => [:Grangold （AD）, :Around Grangold （AD）, :Gold Volcano （AD）],
578 => [:Around Grangold （AD）, :Gold Volcano （AD）],
579 => [:Gold Volcano （AD）],
580 => [:Gold Volcano （AD）],
581 => [:Goddard （AD）],
582 => [:Goddard （AD）],
583 => [:Goddard （AD）],
584 => [:Hellgondo Continent （AD）, :"Monster Lord's Castle Ruins （AD）"],
585 => [:Hellgondo Continent （AD）, :"Monster Lord's Castle Ruins （AD）"],
586 => [:Hellgondo Continent （AD）, :"Monster Lord's Castle Ruins （AD）", :Remina Research Institute （AD）],
587 => [:Hellgondo Continent （AD）, :"Monster Lord's Castle Ruins （AD）", :Remina Research Institute （AD）],
588 => [:Hellgondo Continent （AD）],
589 => [:"Monster Lord's Castle Ruins （AD）"],
590 => [:"Monster Lord's Castle Ruins （AD）"],
591 => [:"Monster Lord's Castle Ruins （AD）"],
592 => [:"Monster Lord's Castle Ruins （AD）"],
593 => [:Remina Research Institute （AD）],
594 => [:Remina Research Institute （AD）],
595 => [:Remina Research Institute （AD）],
596 => [:Remina Research Institute （AD）],
597 => [:Remina Research Institute （AD）],
598 => [:Remina Research Institute （AD）],
599 => [:Remina Research Institute （AD）],
600 => [:Remina Research Institute （AD）],
601 => [:"Monster Lord's Castle （Angel Occupation）", :Forest of Spirits （AD）],
602 => [:"Monster Lord's Castle （Angel Occupation）", :Forest of Spirits （AD）],
603 => [:"Monster Lord's Castle （Angel Occupation）", :Around San Ilia （AD）, :Port Natalia （AD）],
604 => [:"Monster Lord's Castle （Angel Occupation）", :Around San Ilia （AD）, :Port Natalia （AD）],
605 => [:"Monster Lord's Castle （Angel Occupation）"],
606 => [:"Monster Lord's Castle （Angel Occupation）"],
607 => [:"Monster Lord's Castle （Angel Occupation）"],
608 => [:"Monster Lord's Castle （Angel Occupation）"],
609 => [:"Monster Lord's Castle （Angel Occupation）"],
610 => [:"Monster Lord's Castle （Angel Occupation）"],
611 => [:Around San Ilia （AD）, :Forest of Spirits （AD）],
612 => [:Port Natalia （AD）],
613 => [:Luddite Village （AD）],
614 => [:Luddite Village （AD）],
615 => [:Luddite Village （AD）],
616 => [:Forest of Spirits （AD）],
617 => [:Forest of Spirits （AD）],
618 => [:San Ilia （AD）],
619 => [:"Fairy‘s Island （AD）", :Forest of Spirits （MR）],
620 => [:"Fairy‘s Island （AD）", :Forest of Spirits （MR）],
621 => [:"Fairy‘s Island （AD）", :Forest of Spirits （MR）],
622 => [:"Fairy‘s Island （AD）", :Forest of Spirits （MR）],
623 => [:"Fairy‘s Island （AD）"],
624 => [:"Fairy‘s Island （AD）"],
625 => [:"Fairy‘s Island （AD）"],
626 => [:San Ilia （AD）, :Grand Noah （AD）, :Sabasa （AD）, :Black Mansion],
627 => [:San Ilia （AD）, :Grand Noah （AD）, :Sabasa （AD）, :Black Mansion],
628 => [:San Ilia （AD）, :Grand Noah （AD）, :Sabasa （AD）, :Black Mansion],
629 => [:San Ilia （AD）, :Grand Noah （AD）, :Sabasa （AD）, :Black Mansion],
630 => [:San Ilia （AD）, :Grand Noah （AD）, :Sabasa （AD）, :Black Mansion],
631 => [:San Ilia （AD）, :Grand Noah （AD）, :Sabasa （AD）, :Black Mansion],
632 => [:San Ilia （AD）],
633 => [:Grand Noah （AD）, :Black Mansion],
634 => [:Grand Noah （AD）, :Black Mansion],
635 => [:Grand Noah （AD）, :Black Mansion],
636 => [:Grand Noah （AD）],
637 => [:Sabasa （AD）, :Black Mansion],
638 => [:Sabasa （AD）, :Black Mansion],
639 => [:Sabasa （AD）, :Black Mansion],
640 => [:Sabasa （AD）, :Black Mansion],
641 => [:Sabasa （AD）],
642 => [:"Sealed Sinner's Prison （AD）"],
643 => [:Black Mansion],
644 => [:Black Mansion],
645 => [:Black Mansion],
646 => [:Black Mansion],
647 => [:Black Mansion],
648 => [:Black Mansion],
649 => [:"Administrator's Tower （AD）"],
650 => [:Alliance of Wisdom Laboratory （AD）, :Alliance of Wisdom Laboratory],
651 => [:Alliance of Wisdom Laboratory （AD）, :Alliance of Wisdom Laboratory],
652 => [:Alliance of Wisdom Laboratory （AD）, :Alliance of Wisdom Laboratory],
653 => [:Alliance of Wisdom Laboratory （AD）, :Alliance of Wisdom Laboratory],
654 => [:Alliance of Wisdom Laboratory （AD）],
655 => [:The Moon],
656 => [:The Moon],
657 => [:The Moon],
658 => [:The Moon],
659 => [:The Moon],
660 => [:The Moon],
661 => [:The Moon],
662 => [:Mount Saint Amos（AD）, :Ilias Continent （AD）],
663 => [:Mount Saint Amos（AD）],
664 => [:Mount Saint Amos（AD）],
665 => [:Mount Saint Amos（AD）],
666 => [:Mount Saint Amos（AD）],
667 => [:Mount Saint Amos（AD）],
668 => [:Ilias Continent （AD）],
669 => [:Ilias Continent （AD）, :Ilias Temple （AD）],
670 => [:Ilias Continent （AD）, :Ilias Temple （AD）],
671 => [:Sealed Castle Mithra （AD）, :Ilias Temple （AD）],
672 => [:Sealed Castle Mithra （AD）, :Ilias Temple （AD）],
673 => [:Sealed Castle Mithra （AD）, :Ilias Temple （AD）],
674 => [:Sealed Castle Mithra （AD）, :Ilias Temple （AD）],
675 => [:Sealed Castle Mithra （AD）, :Ilias Temple （AD）],
676 => [:Ilias Temple （AD）],
677 => [:Ilias Temple （AD）],
678 => [:Ilias Temple （AD）],
679 => [:Ilias Temple （AD）],
680 => [:Ilias Temple （AD）],
681 => [:Ilias Temple （AD）],
682 => [:Ilias Temple （AD）],
683 => [:Ilias Temple （AD）],
684 => [:Ilias Temple （AD）],
685 => [:Ilias Temple （AD）],
686 => [:Ilias Temple （AD）],
687 => [:Ilias Temple （AD）],
688 => [:Ilias Temple （AD）],
689 => [:Ilias Temple （AD）],
691 => [:Hellgondo Continent （MR）, :Around Succubus Village （MR）],
692 => [:Hellgondo Continent （MR）, :Around Succubus Village （MR）, :Around Grangold （MR）],
693 => [:Hellgondo Continent （MR）, :Around Succubus Village （MR）],
694 => [:Around Succubus Village （MR）, :Succubus Village （MR）, :Around Grangold （MR）, :San Ilia （MR）],
695 => [:Around Succubus Village （MR）, :Succubus Village （MR）, :Around Grangold （MR）, :San Ilia （MR）],
696 => [:Succubus Village （MR）],
697 => [:Around Grangold （MR）, :Gold Volcano （MR）],
698 => [:Around Grangold （MR）, :Gold Volcano （MR）],
699 => [:Grangold （MR）, :Gold Fort （MR）],
700 => [:Grangold （MR）, :Gold Fort （MR）],
701 => [:Grangold （MR）, :Gold Fort （MR）],
702 => [:Grangold （MR）],
703 => [:Grangold （MR）],
704 => [:Grangold （MR）],
705 => [:Grangold （MR）],
706 => [:Gold Fort （MR）, :Around Grand Noah （MR）, :Grand Noah （MR）],
707 => [:Gold Fort （MR）, :Around Grand Noah （MR）, :Grand Noah （MR）],
708 => [:Around Grand Noah （MR）, :Grand Noah （MR）, :"Water Spirit's Spring （MR）"],
709 => [:Grand Noah （MR）, :Gold Volcano （MR）, :"Water Spirit's Spring （MR）"],
710 => [:Grand Noah （MR）, :"Water Spirit's Spring （MR）"],
711 => [:Grand Noah （MR）],
712 => [:Grand Noah （MR）],
713 => [:Gold Volcano （MR）],
714 => [:Gold Volcano （MR）],
715 => [:Various Places],
716 => [:Gold Volcano （MR）],
717 => [:Gold Volcano （MR）],
718 => [:"Water Spirit's Spring （MR）"],
719 => [:"Water Spirit's Spring （MR）"],
720 => [:"Water Spirit's Spring （MR）"],
721 => [:"Water Spirit's Spring （MR）"],
722 => [:Grand Noah （MR）],
723 => [:Grand Noah （MR）],
724 => [:Around Yamatai （MR）],
725 => [:Around Yamatai （MR）, :Mount Horai （MR）, :Yamatai Village （MR）],
726 => [:Around Yamatai （MR）, :Mount Horai （MR）, :Yamatai Village （MR）],
727 => [:Mount Horai （MR）, :Yamatai Village （MR）],
728 => [:Mount Horai （MR）],
729 => [:Yamatai Village （MR）, :Around San Ilia （MR）],
730 => [:Yamatai Village （MR）, :Around San Ilia （MR）],
731 => [:Yamatai Village （MR）],
732 => [:Finoa （MR）, :Forest of Spirits （MR）],
733 => [:Finoa （MR）, :Forest of Spirits （MR）],
734 => [:Finoa （MR）],
735 => [:Finoa （MR）],
736 => [:Around San Ilia （MR）],
737 => [:Around San Ilia （MR）],
738 => [:Port Natalia （MR）, :"Grand Pirate's Cave （MR）"],
739 => [:Port Natalia （MR）, :"Grand Pirate's Cave （MR）"],
740 => [:Port Natalia （MR）],
741 => [:Port Natalia （MR）],
742 => [:Forest of Spirits （MR）],
743 => [:Forest of Spirits （MR）],
744 => [:San Ilia （MR）],
745 => [:San Ilia （MR）, :Around Sabasa （MR）],
746 => [:San Ilia （MR）, :Around Sabasa （MR）],
747 => [:San Ilia （MR）, :Around Sabasa （MR）, :Ilias Continent （MR）],
748 => [:San Ilia （MR）],
749 => [:San Ilia （MR）],
750 => [:San Ilia （MR）],
751 => [:San Ilia （MR）],
752 => [:San Ilia （MR）],
753 => [:San Ilia （MR）, :Grand Noah （MR）, :Grangold （MR）, :Yamatai Village （MR）, :"Puppeteer's Tower"],
754 => [:San Ilia （MR）, :Grand Noah （MR）, :Grangold （MR）, :Yamatai Village （MR）, :"Puppeteer's Tower"],
755 => [:San Ilia （MR）, :Grand Noah （MR）, :Grangold （MR）, :Yamatai Village （MR）, :"Puppeteer's Tower"],
756 => [:San Ilia （MR）, :Grand Noah （MR）, :Grangold （MR）, :Yamatai Village （MR）, :"Puppeteer's Tower"],
757 => [:San Ilia （MR）, :Grand Noah （MR）, :Grangold （MR）, :Yamatai Village （MR）, :"Puppeteer's Tower"],
758 => [:San Ilia （MR）],
759 => [:Grand Noah （MR）, :"Puppeteer's Tower"],
760 => [:Grand Noah （MR）, :"Puppeteer's Tower"],
761 => [:Grand Noah （MR）],
762 => [:Grangold （MR）, :"Puppeteer's Tower"],
763 => [:Grangold （MR）, :"Puppeteer's Tower"],
764 => [:Grangold （MR）],
765 => [:Yamatai Village （MR）, :"Puppeteer's Tower"],
766 => [:Yamatai Village （MR）],
767 => [:"Puppeteer's Tower", :Alliance of Wisdom Laboratory],
768 => [:"Puppeteer's Tower", :Alliance of Wisdom Laboratory],
769 => [:"Puppeteer's Tower"],
770 => [:"Puppeteer's Tower"],
771 => [:"Puppeteer's Tower"],
772 => [:"Puppeteer's Tower"],
773 => [:Around Sabasa （MR）, :Safar Ruins （MR）],
774 => [:Around Sabasa （MR）, :Safar Ruins （MR）],
775 => [:Around Sabasa （MR）, :Safar Ruins （MR）],
776 => [:Safar Ruins （MR）, :Ilias Continent （MR）],
777 => [:Safar Ruins （MR）],
778 => [:Safar Ruins （MR）],
779 => [:Sabasa （MR）],
780 => [:Sabasa （MR）],
781 => [:Ilias Continent （MR）],
782 => [:Ilias Continent （MR）, :Calamity Star Demiurge （MR）],
783 => [:Ilias Continent （MR）, :Calamity Star Demiurge （MR）],
784 => [:Enrika （MR）],
785 => [:Black Mansion, :Sealed Castle Mithra （MR）],
786 => [:Black Mansion, :Sealed Castle Mithra （MR）],
787 => [:Black Mansion, :Sealed Castle Mithra （MR）],
788 => [:Black Mansion, :Sealed Castle Mithra （MR）],
789 => [:Black Mansion, :Sealed Castle Mithra （MR）],
790 => [:Black Mansion, :Sealed Castle Mithra （MR）],
791 => [:Black Mansion, :Sealed Castle Mithra （MR）],
792 => [:Black Mansion, :Sealed Castle Mithra （MR）],
793 => [:Black Mansion, :Sealed Castle Mithra （MR）],
794 => [:Black Mansion, :Sealed Castle Mithra （MR）],
795 => [:Black Mansion, :Sealed Castle Mithra （MR）],
796 => [:Black Mansion, :Sealed Castle Mithra （MR）],
797 => [:Black Mansion, :Sealed Castle Mithra （MR）],
798 => [:Place of Memory],
799 => [:Place of Memory],
800 => [:Place of Memory],
801 => [:Place of Memory],
802 => [:Place of Memory],
803 => [:Place of Memory],
804 => [:Place of Memory],
805 => [:Place of Memory],
806 => [:Place of Memory],
807 => [:Calamity Star Demiurge （MR）, :Hellgondo Continent （MR）],
808 => [:Calamity Star Demiurge （MR）, :Hellgondo Continent （MR）],
809 => [:Calamity Star Demiurge （MR）],
810 => [:Calamity Star Demiurge （MR）],
811 => [:Calamity Star Demiurge （MR）],
812 => [:Hellgondo Continent （MR）, :"Sealed Sinner's Prison （MR）", :"Dark Goddess' Castle （MR）"],
813 => [:Hellgondo Continent （MR）, :"Sealed Sinner's Prison （MR）", :"Dark Goddess' Castle （MR）"],
814 => [:Hellgondo Continent （MR）],
815 => [:"Sealed Sinner's Prison （MR）", :"Dark Goddess' Castle （MR）"],
816 => [:"Sealed Sinner's Prison （MR）"],
817 => [:"Dark Goddess' Castle （MR）"],
818 => [:"Dark Goddess' Castle （MR）"],
819 => [:"Dark Goddess' Castle （MR）"],
820 => [:"Dark Goddess' Castle （MR）"],
821 => [:"Dark Goddess' Castle （MR）"],
822 => [:"Dark Goddess' Castle （MR）"],
823 => [:"Dark Goddess' Castle （MR）"],
824 => [:"Dark Goddess' Castle （MR）"],
825 => [:"Dark Goddess' Castle （MR）"],
826 => [:"Dark Goddess' Castle （MR）"],
827 => [:"Dark Goddess' Castle （MR）"],
828 => [:"Monster Lord's Castle"],
829 => [:"Monster Lord's Castle"],
830 => [:Black Mansion],
832 => [:Alliance of Wisdom Laboratory],
833 => [:Alliance of Wisdom Laboratory],
834 => [:Central Tartarus, :Deep Chaos （Chaos）],
835 => [:Central Tartarus, :Deep Chaos （Chaos）],
836 => [:Central Tartarus, :Deep Chaos （Chaos）],
837 => [:Central Tartarus, :Deep Chaos （Chaos）],
838 => [:Central Tartarus, :Deep Chaos （Chaos）],
839 => [:Central Tartarus, :Deep Chaos （Chaos）],
840 => [:Central Tartarus],
841 => [:Central Tartarus],
842 => [:Collapsed Pocket Castle],
843 => [:Deep Chaos （Chaos）],
844 => [:Deep Chaos （Chaos）],
845 => [:Deep Chaos （Chaos）],
846 => [:Enrika （Chaos）],
847 => [:Iliasville Mountains （Chaos）],
848 => [:Ilias Temple （Chaos）, :Grand Noah （Chaos）],
849 => [:Ilias Temple （Chaos）, :Grand Noah （Chaos）],
850 => [:Mount Saint Amos （Chaos）],
851 => [:Grangold （Chaos）],
852 => [:Grand Noah （Chaos）, :"Water Spirit's Spring （Chaos）"],
853 => [:Magical Academy （Chaos）],
854 => [:Magical Academy （Chaos）],
855 => [:Magical Academy （Chaos）],
856 => [:Sabasa （Chaos）],
857 => [:Sabasa （Chaos）],
858 => [:San Ilia （Chaos）],
859 => [:San Ilia （Chaos）],
860 => [:Yamatai Village （Chaos）],
861 => [:Kitsune Village （Chaos）],
862 => [:Lunar Mechanical Fortress （Chaos）, :Remina Research Institute （Chaos）],
863 => [:Lunar Mechanical Fortress （Chaos）, :Alliance of Wisdom Laboratory （Chaos）],
864 => [:Lunar Mechanical Fortress （Chaos）],
865 => [:Harpy Village （Chaos）],
866 => [:Harpy Village （Chaos）],
867 => [:Forest of Spirits （Chaos）],
868 => [:Safar Ruins （Chaos）],
869 => [:"Water Spirit's Spring （Chaos）"],
870 => [:Gold Volcano （Chaos）],
871 => [:Ilias Temple （Chaos）],
872 => [:Ilias Temple （Chaos）],
873 => [:"Dark Goddess' Castle （Chaos）"],
874 => [:"Dark Goddess' Castle （Chaos）"],
875 => [:"Sealed Monster's Cave （Chaos）"],
876 => [:"Sealed Monster's Cave （Chaos）"],
877 => [:"Sealed Monster's Cave （Chaos）"],
878 => [:"Sealed Monster's Cave （Chaos）"],
879 => [:"Sealed Monster's Cave （Chaos）"],
880 => [:Saloon Abandoned Mines （Chaos）],
881 => [:Cursed Undersea Temple （Chaos）],
882 => [:Cursed Undersea Temple （Chaos）],
883 => [:Cursed Undersea Temple （Chaos）],
884 => [:Core of the Star （Chaos）],
885 => [:Core of the Star （Chaos）],
886 => [:Core of the Star （Chaos）],
887 => [:Haunted Mansion （Chaos）],
888 => [:Road to the Underworld （Chaos）],
889 => [:Road to the Underworld （Chaos）],
890 => [:Road to the Underworld （Chaos）],
891 => [:Haunted Mansion （Chaos）],
892 => [:Grand Noah （Chaos）],
893 => [:"Orochi's Cave （Chaos）"],
894 => [:Devastated Plains （Chaos）],
895 => [:"Dark Goddess' Castle （Chaos）"],
896 => [:Cave to Yamatai （Chaos）],
897 => [:Mount Horai （Chaos）],
898 => [:Gold Fort （Chaos）],
899 => [:Black Mansion （Chaos）],
900 => [:Ghost Ship （Chaos）],
901 => [:"Seeker's Cave （Chaos）"],
902 => [:"Seeker's Cave （Chaos）"],
903 => [:Snow Cave （Chaos）],
904 => [:Hellgondo Shrine （Chaos）],
905 => [:Calamity Star Demiurge （Chaos）],
906 => [:Calamity Star Demiurge （Chaos）],
907 => [:Gestalt Hivemind （Chaos）],
908 => [:Gestalt Hivemind （Chaos）],
909 => [:Gestalt Hivemind （Chaos）],
910 => [:Hall of Greed （Chaos）],
911 => [:Hall of Greed （Chaos）],
912 => [:Hall of Greed （Chaos）],
913 => [:Hall of Envy （Chaos）],
914 => [:Hall of Envy （Chaos）],
915 => [:Hall of Wrath （Chaos）],
916 => [:Hall of Gluttony （Chaos）],
917 => [:Hall of Lust （Chaos）],
918 => [:Hall of Lust （Chaos）],
919 => [:Hall of Pride （Chaos）],
920 => [:Hall of Pride （Chaos）],
921 => [:Hall of Pride （Chaos）],
922 => [:Palace of the Deadly Sins （Chaos）],
923 => [:Palace of the Deadly Sins （Chaos）],
924 => [:Palace of the Deadly Sins （Chaos）],
925 => [:Palace of the Deadly Sins （Chaos）],
926 => [:Palace of the Deadly Sins （Chaos）],
927 => [:Palace of the Deadly Sins （Chaos）],
928 => [:"Puppeteer's Tower （Chaos）"],
929 => [:"Puppeteer's Tower （Chaos）"],
930 => [:"Puppeteer's Tower （Chaos）"],
931 => [:"Puppeteer's Tower （Chaos）"],
932 => [:Towers of Light and Darkness （Chaos）],
933 => [:Towers of Light and Darkness （Chaos）],
934 => [:Towers of Light and Darkness （Chaos）],
935 => [:Towers of Light and Darkness （Chaos）],
936 => [:Towers of Light and Darkness （Chaos）],
937 => [:Towers of Light and Darkness （Chaos）],
938 => [:Towers of Light and Darkness （Chaos）],
939 => [:Luddite Village （Chaos）],
940 => [:Luddite Village （Chaos）],
941 => [:Luddite Village （Chaos）],
942 => [:"Inside Lilith's Body（Chaos）"],
943 => [:"Inside Lilith's Body（Chaos）"],
944 => [:Port Natalia （Chaos）, :"Road to R'lyeh （Chaos）", :"R'lyeh （Chaos）"],
945 => [:Port Natalia （Chaos）, :"Road to R'lyeh （Chaos）", :"R'lyeh （Chaos）"],
946 => [:"R'lyeh （Chaos）"],
947 => [:Calamity Star Demiurge （Chaos）],
948 => [:Calamity Star Demiurge （Chaos）],
949 => [:Calamity Star Demiurge （Chaos）],
950 => [:Calamity Star Demiurge （Chaos）],
951 => [:Calamity Star Demiurge （Chaos）],
952 => [:Sky （Chaos）],
953 => [:Gold Volcano （Chaos）],
954 => [:Lunar Mechanical Fortress （Chaos）],
955 => [:Lunar Mechanical Fortress （Chaos）],
956 => [:"Administrator's Tower （Chaos）"],
957 => [:"Administrator's Tower （Chaos）"],
958 => [:"Administrator's Tower （Chaos）"],
959 => [:"Administrator's Tower （Chaos）"],
960 => [:"Administrator's Tower （Chaos）"],
961 => [:"Administrator's Tower （Chaos）"],
962 => [:Black Mansion （Chaos）],
963 => [:Place of Memory （Chaos）],
964 => [:Place of Memory （Chaos）],
965 => [:Place of Memory （Chaos）],
966 => [:Place of Memory （Chaos）],
967 => [:Place of Memory （Chaos）],
968 => [:Ilias Temple Ruins （Chaos）],
969 => [:Mount Horai （Chaos）],
970 => [:Mount Horai （Chaos）],
971 => [:Snow Shrine （Chaos）],
972 => [:Chaos Domain （Chaos）],
973 => [:Chaos Domain （Chaos）],
974 => [:Ilias Temple Ruins （Chaos）, :Black Mansion （Chaos）, :Chaos Domain （Chaos）],
975 => [:Chaos Domain （Chaos）],
976 => [:Chaos Domain （Chaos）],
977 => [:Chaos Domain （Chaos）],
978 => [:Chaos Domain （Chaos）],
979 => [:Chaos Domain （Chaos）],
980 => [:Chaos Domain （Chaos）],
981 => [:Chaos Domain （Chaos）],
982 => [:Chaos Domain （Chaos）],
983 => [:Chaos Domain （Chaos）],
984 => [:Chaos Domain （Chaos）],
985 => [:Chaos Domain （Chaos）],
986 => [:Chaos Domain （Chaos）],
987 => [:Chaos Domain （Chaos）],
988 => [:Chaos Domain （Chaos）],
989 => [:Chaos Domain （Chaos）],
990 => [:Chaos Domain （Chaos）],
991 => [:Chaos Domain （Chaos）],
992 => [:Chaos Domain （Chaos）],
993 => [:Chaos Domain （Chaos）],
994 => [:Calamity Star Demiurge （Chaos）],
995 => [:Calamity Star Demiurge （Chaos）],
996 => [:Calamity Star Demiurge （Chaos）],
997 => [:Black Mansion （Chaos）],
998 => [:"Granberia's Nightmare （Chaos）"],
2001 => [:Around Iliasville （Chaos）, :Iliasville Mountains （Chaos）, :Cave of Trials （Chaos）],
2003 => [:Around Iliasville （Chaos）, :Iliasville Mountains （Chaos）],
2004 => [:Around Iliasville （Chaos）, :Cave of Trials （Chaos）, :Slug Tower（Chaos）],
2005 => [:Cave of Trials （Chaos）, :Talus Hill （Chaos）, :Hall of Greed （Chaos）],
2006 => [:Around Iliasville （Chaos）, :Talus Hill （Chaos）],
2007 => [:Around Iliasville （Chaos）, :Talus Hill （Chaos）],
2008 => [:Around Iliasville （Chaos）, :Hall of Greed （Chaos）],
2013 => [:Hall of Greed （Chaos）],
2014 => [:Around Happiness Village （Chaos）, :Hall of Greed （Chaos）],
2016 => [:Around Happiness Village （Chaos）, :Around Iliasport （Chaos）, :Pornof Mines （Chaos）],
2017 => [:Around Happiness Village （Chaos）, :Pornof Mines （Chaos）],
2018 => [:Around Happiness Village （Chaos）, :Pornof Mines （Chaos）],
2019 => [:Chaos Domain （Chaos）],
2020 => [:Chaos Domain （Chaos）],
2021 => [:Chaos Domain （Chaos）],
2022 => [:"Administrator's Tower （Chaos）"],
2023 => [:Around Happiness Village （Chaos）, :Rostrum Mountain Caverns （Chaos）],
2024 => [:Around Happiness Village （Chaos）],
2025 => [:Around Happiness Village （Chaos）, :Harpy Tower（Chaos）],
2026 => [:Harpy Tower（Chaos）],
2027 => [:Harpy Tower（Chaos）],
2028 => [:Harpy Tower（Chaos）],
2029 => [:Slug Tower（Chaos）],
2030 => [:Slug Tower（Chaos）],
2031 => [:Slug Tower（Chaos）],
2032 => [:Lost Woods （Chaos）, :Midas Abandoned Mines （Chaos）],
2033 => [:Around Iliasport （Chaos）, :Midas Abandoned Mines （Chaos）],
2034 => [:Rostrum Mountain Caverns （Chaos）, :Midas Abandoned Mines （Chaos）, :Cave of Treasures （Chaos）],
2035 => [:Rostrum Mountain Caverns （Chaos）],
2036 => [:Chaos Domain （Chaos）],
2037 => [:Chaos Domain （Chaos）],
2038 => [:Chaos Domain （Chaos）],
2039 => [:Lost Woods （Chaos）, :Lemuse Beach （Chaos）],
2040 => [:Lost Woods （Chaos）, :Lemuse Beach （Chaos）],
2041 => [:Lost Woods （Chaos）],
2042 => [:Around Port Natalia Beach （Chaos）, :Lemuse Beach （Chaos）],
2043 => [:Lemuse Beach （Chaos）],
2044 => [:Around Iliasport （Chaos）],
2045 => [:Around Iliasport （Chaos）, :Around Port Natalia （Chaos）],
2046 => [:Cave of Treasures （Chaos）],
2047 => [:Cave of Treasures （Chaos）],
2048 => [:Cave of Treasures （Chaos）],
2049 => [:Various Places （Chaos）],
2050 => [:Cave of Treasures （Chaos）],
2052 => [:Around Port Natalia Beach （Chaos）, :Natalia Coast （Chaos）],
2053 => [:Around Port Natalia Beach （Chaos）, :Natalia Coast （Chaos）],
2054 => [:Around Port Natalia Beach （Chaos）, :Natalia Coast （Chaos）],
2055 => [:Around Port Natalia （Chaos）],
2056 => [:Around Port Natalia （Chaos）],
2057 => [:Around Port Natalia （Chaos）],
2058 => [:Around Port Natalia （Chaos）, :Mount Saint Amos （Chaos）],
2059 => [:Natalia Coast （Chaos）, :Southern Undersea Temple （Chaos）],
2060 => [:Southern Undersea Temple （Chaos）],
2061 => [:Southern Undersea Temple （Chaos）],
2062 => [:Southern Undersea Temple （Chaos）],
2063 => [:Southern Undersea Temple （Chaos）],
2064 => [:Magical Academy （Chaos）],
2065 => [:Magical Academy （Chaos）],
2066 => [:Magical Academy （Chaos）],
2067 => [:Mount Saint Amos （Chaos）],
2068 => [:Mount Saint Amos （Chaos）],
2069 => [:Mount Saint Amos （Chaos）],
2070 => [:Mount Saint Amos （Chaos）],
2071 => [:Lunar Mechanical Fortress （Chaos）],
2072 => [:Alliance of Wisdom Laboratory （Chaos）],
2073 => [:Lunar Mechanical Fortress （Chaos）],
2074 => [:Chaos Domain （Chaos）],
2075 => [:Haunted Mansion （Chaos）],
2076 => [:Haunted Mansion （Chaos）],
2077 => [:Haunted Mansion （Chaos）],
2078 => [:Haunted Mansion （Chaos）],
2079 => [:Haunted Mansion （Chaos）],
2080 => [:Haunted Mansion （Chaos）],
2081 => [:Haunted Mansion （Chaos）],
2084 => [:Forest of Spirits （Chaos）],
2085 => [:Forest of Spirits （Chaos）],
2086 => [:Forest of Spirits （Chaos）],
2087 => [:Forest of Spirits （Chaos）],
2088 => [:Forest of Spirits （Chaos）],
2089 => [:Forest of Spirits （Chaos）],
2090 => [:Forest of Spirits （Chaos）],
2091 => [:Forest of Spirits （Chaos）],
2092 => [:Forest of Spirits （Chaos）],
2093 => [:Towers of Light and Darkness （Chaos）],
2095 => [:Around Monte Carlo （Chaos）, :Carlos Hill （Chaos）],
2096 => [:Around Monte Carlo （Chaos）, :"Seeker's Cave （Chaos）", :Hall of Wrath （Chaos）],
2097 => [:Around Monte Carlo （Chaos）, :Carlos Hill （Chaos）],
2098 => [:Carlos Hill （Chaos）],
2099 => [:Carlos Hill （Chaos）, :"Seeker's Cave （Chaos）"],
2100 => [:"Seeker's Cave （Chaos）"],
2101 => [:Sabasa Desert （Chaos）, :Pyramid （Chaos）],
2102 => [:Sabasa Desert （Chaos）, :Oasis of Blessings （Chaos）],
2103 => [:Sabasa Desert （Chaos）, :Oasis of Blessings （Chaos）],
2104 => [:Sabasa Desert （Chaos）],
2105 => [:Pyramid （Chaos）],
2106 => [:Sabasa Desert （Chaos）, :Pyramid （Chaos）],
2107 => [:Pyramid （Chaos）],
2108 => [:Road to the Underworld （Chaos）],
2109 => [:Pyramid （Chaos）],
2111 => [:Sabasa Desert （Chaos）, :Sabasa Desert （Chaos）, :Oasis of Blessings （Chaos）],
2112 => [:Oasis of Blessings （Chaos）],
2113 => [:Around Magistea Village （Chaos）, :Saloon Hill （Chaos）],
2114 => [:Around Magistea Village （Chaos）, :Saloon Hill （Chaos）],
2115 => [:Hall of Envy （Chaos）],
2116 => [:Hall of Envy （Chaos）],
2117 => [:Hall of Envy （Chaos）],
2118 => [:Hall of Envy （Chaos）],
2119 => [:Various Places （Chaos）],
2121 => [:Saloon Abandoned Mines （Chaos）, :Hall of Envy （Chaos）],
2122 => [:Hall of Envy （Chaos）],
2123 => [:Hall of Envy （Chaos）],
2125 => [:Saloon Hill （Chaos）],
2126 => [:Saloon Abandoned Mines （Chaos）],
2127 => [:Saloon Abandoned Mines （Chaos）],
2128 => [:Saloon Abandoned Mines （Chaos）],
2129 => [:Safar Ruins （Chaos）],
2130 => [:Safar Ruins （Chaos）],
2131 => [:Safar Ruins （Chaos）],
2132 => [:Safar Ruins （Chaos）],
2133 => [:Towers of Light and Darkness （Chaos）],
2134 => [:Chaos Domain （Chaos）],
2135 => [:Chaos Domain （Chaos）],
2136 => [:Chaos Domain （Chaos）],
2137 => [:Chaos Domain （Chaos）],
2138 => [:Alliance of Wisdom Laboratory （Chaos）],
2139 => [:Alliance of Wisdom Laboratory （Chaos）],
2140 => [:Alliance of Wisdom Laboratory （Chaos）],
2141 => [:Alliance of Wisdom Laboratory （Chaos）],
2142 => [:Alliance of Wisdom Laboratory （Chaos）],
2143 => [:Chaos Domain （Chaos）],
2148 => [:Palace of the Deadly Sins （Chaos）],
2151 => [:Great Marle Corridor （Chaos）],
2152 => [:Great Marle Corridor （Chaos）],
2153 => [:Great Marle Corridor （Chaos）],
2154 => [:Sea （Chaos）],
2155 => [:Sea （Chaos）],
2156 => [:Sea （Chaos）, :"Grand Pirate's Cave （Chaos）"],
2157 => [:Sea （Chaos）, :"Grand Pirate's Cave （Chaos）"],
2158 => [:Sea （Chaos）],
2159 => [:Sea （Chaos）],
2160 => [:Sea （Chaos）],
2161 => [:"Grand Pirate's Cave （Chaos）"],
2162 => [:"Grand Pirate's Cave （Chaos）"],
2165 => [:"Grand Pirate's Cave （Chaos）"],
2166 => [:"Grand Pirate's Cave （Chaos）"],
2167 => [:Cursed Undersea Temple （Chaos）],
2168 => [:Around Grand Noah （Chaos）, :Fossil Mines （Chaos）],
2169 => [:Around Grand Noah （Chaos）, :Fossil Mines （Chaos）],
2170 => [:Around Grand Noah （Chaos）],
2171 => [:Around Grand Noah （Chaos）],
2172 => [:Fossil Mines （Chaos）, :Labyrinth Caverns （Chaos）],
2173 => [:Fossil Mines （Chaos）, :Labyrinth Caverns （Chaos）],
2174 => [:Various Places （Chaos）],
2175 => [:Around Grand Noah （Chaos）],
2176 => [:Around Grand Noah （Chaos）],
2179 => [:Labyrinth Caverns （Chaos）, :Cave to Yamatai （Chaos）],
2180 => [:Hall of Wrath （Chaos）],
2181 => [:Hall of Wrath （Chaos）],
2182 => [:Hall of Wrath （Chaos）],
2183 => [:Sealed Castle Mithra （Chaos）],
2185 => [:Cave to Yamatai （Chaos）],
2186 => [:Cave to Yamatai （Chaos）],
2187 => [:Cave to Yamatai （Chaos）],
2188 => [:Around Yamatai （Chaos）],
2189 => [:Around Yamatai （Chaos）, :"Orochi's Cave （Chaos）"],
2190 => [:Around Yamatai （Chaos）],
2191 => [:Around Yamatai （Chaos）],
2192 => [:"Orochi's Cave （Chaos）"],
2193 => [:"Orochi's Cave （Chaos）"],
2194 => [:"Orochi's Cave （Chaos）"],
2195 => [:"Orochi's Cave （Chaos）"],
2196 => [:"Orochi's Cave （Chaos）"],
2197 => [:Magical Academy （Chaos）],
2198 => [:Magical Academy （Chaos）],
2199 => [:Magical Academy （Chaos）],
2200 => [:Magical Academy （Chaos）],
2201 => [:Magical Academy （Chaos）],
2202 => [:Magical Academy （Chaos）],
2204 => [:Around Esta （Chaos）, :Gestalt Hivemind （Chaos）],
2205 => [:Around Esta （Chaos）, :Gestalt Hivemind （Chaos）],
2206 => [:Plansect Village （Chaos）],
2207 => [:Plansect Village （Chaos）],
2208 => [:Plansect Village （Chaos）],
2209 => [:Plansect Village （Chaos）],
2210 => [:Plansect Village （Chaos）],
2211 => [:Plansect Village （Chaos）],
2212 => [:The World Tree （Chaos）],
2213 => [:The World Tree （Chaos）],
2214 => [:The World Tree （Chaos）],
2216 => [:Gestalt Hivemind （Chaos）],
2217 => [:Gestalt Hivemind （Chaos）],
2218 => [:Gestalt Hivemind （Chaos）],
2219 => [:Gestalt Hivemind （Chaos）],
2220 => [:Gestalt Hivemind （Chaos）],
2221 => [:Sealed Castle Mithra （Chaos）],
2222 => [:Sealed Castle Mithra （Chaos）],
2224 => [:Remina Research Institute （Chaos）],
2225 => [:"Water Spirit's Spring （Chaos）"],
2226 => [:"Water Spirit's Spring （Chaos）"],
2227 => [:"Water Spirit's Spring （Chaos）"],
2228 => [:"Water Spirit's Spring （Chaos）"],
2229 => [:"Water Spirit's Spring （Chaos）"],
2230 => [:"Water Spirit's Spring （Chaos）"],
2231 => [:Towers of Light and Darkness （Chaos）],
2233 => [:Around Goddard （Chaos）, :Lima Village Ruins （Chaos）, :Gold Fort （Chaos）, :Gestalt Hivemind （Chaos）],
2234 => [:Lima Village Ruins （Chaos）, :Gold Fort （Chaos）],
2235 => [:Gold Fort （Chaos）],
2236 => [:Around Goddard （Chaos）, :Gold Coast （Chaos）],
2237 => [:Around Goddard （Chaos）, :Gold Coast （Chaos）],
2238 => [:Around Goddard （Chaos）],
2239 => [:Eastern Gold Toxic Swamp （Chaos）],
2240 => [:Eastern Gold Toxic Swamp （Chaos）],
2241 => [:Eastern Gold Toxic Swamp （Chaos）],
2242 => [:Eastern Gold Toxic Swamp （Chaos）],
2243 => [:Eastern Gold Toxic Swamp （Chaos）],
2244 => [:Gold Coast （Chaos）],
2245 => [:Around Grangold （Chaos）],
2246 => [:Around Grangold （Chaos）],
2247 => [:Around Grangold （Chaos）],
2248 => [:Lima Village Ruins （Chaos）],
2249 => [:Around Grangold （Chaos）],
2250 => [:Grangold （Chaos）],
2251 => [:Grangold （Chaos）],
2252 => [:Grangold （Chaos）],
2253 => [:Grangold （Chaos）],
2254 => [:Gestalt Hivemind （Chaos）],
2256 => [:Gold Volcano （Chaos）, :Lava Mines （Chaos）],
2257 => [:Gold Volcano （Chaos）, :Lava Mines （Chaos）],
2258 => [:Gold Volcano （Chaos）, :Lava Mines （Chaos）],
2259 => [:Sea （Chaos）, :Ghost Ship （Chaos）],
2260 => [:Northern Undersea Temple （Chaos）, :Ghost Ship （Chaos）],
2261 => [:Northern Undersea Temple （Chaos）, :Ghost Ship （Chaos）],
2262 => [:Plansect Village （Chaos）],
2263 => [:Plansect Village （Chaos）],
2264 => [:Plansect Village （Chaos）],
2265 => [:Sea （Chaos）, :Northern Undersea Temple （Chaos）],
2266 => [:Sea （Chaos）, :Northern Undersea Temple （Chaos）],
2267 => [:Cursed Undersea Temple （Chaos）],
2268 => [:Hall of Lust （Chaos）],
2269 => [:Hall of Lust （Chaos）],
2270 => [:Hall of Lust （Chaos）],
2271 => [:Hall of Lust （Chaos）],
2272 => [:Hall of Lust （Chaos）],
2273 => [:Hall of Lust （Chaos）],
2274 => [:Hall of Lust （Chaos）],
2275 => [:Hall of Lust （Chaos）],
2278 => [:Hall of Gluttony （Chaos）],
2279 => [:Hall of Gluttony （Chaos）],
2280 => [:Hall of Gluttony （Chaos）],
2281 => [:Hall of Gluttony （Chaos）],
2282 => [:Palace of the Deadly Sins （Chaos）],
2283 => [:Gold Volcano （Chaos）],
2284 => [:Gold Volcano （Chaos）],
2285 => [:Towers of Light and Darkness （Chaos）],
2287 => [:Western Gold Region （Chaos）],
2288 => [:Western Gold Region （Chaos）],
2289 => [:Western Gold Region （Chaos）],
2290 => [:Western Gold Region （Chaos）, :Hall of Pride （Chaos）],
2291 => [:Chaos Domain （Chaos）],
2292 => [:Chaos Domain （Chaos）],
2293 => [:Chaos Domain （Chaos）],
2294 => [:Chaos Domain （Chaos）],
2296 => [:Hall of Gluttony （Chaos）],
2299 => [:Sea （Chaos）],
2300 => [:Sea （Chaos）],
2301 => [:Sea （Chaos）],
2302 => [:Sea （Chaos）],
2303 => [:"Fairy's Island （Chaos）"],
2304 => [:"Fairy's Island （Chaos）"],
2305 => [:"Fairy's Island （Chaos）"],
2306 => [:"Fairy's Island （Chaos）"],
2307 => [:Core of the Star （Chaos）],
2308 => [:Core of the Star （Chaos）],
2309 => [:The World Tree （Chaos）],
2310 => [:The World Tree （Chaos）],
2311 => [:The World Tree （Chaos）],
2312 => [:The World Tree （Chaos）],
2313 => [:The World Tree （Chaos）],
2314 => [:Core of the Star （Chaos）],
2315 => [:Sealed Castle Mithra （Chaos）],
2316 => [:Lyra Falls （Chaos）],
2317 => [:Lyra Falls （Chaos）],
2318 => [:Lyra Falls （Chaos）],
2319 => [:Lyra Falls （Chaos）],
2320 => [:Lyra Falls （Chaos）],
2321 => [:Gestalt Hivemind （Chaos）],
2322 => [:Gestalt Hivemind （Chaos）],
2323 => [:Gestalt Hivemind （Chaos）],
2324 => [:Gestalt Hivemind （Chaos）],
2325 => [:Gestalt Hivemind （Chaos）],
2326 => [:Gestalt Hivemind （Chaos）],
2327 => [:Gestalt Hivemind （Chaos）],
2328 => [:Hall of Pride （Chaos）],
2329 => [:Hall of Pride （Chaos）],
2330 => [:Hall of Pride （Chaos）],
2331 => [:Hall of Pride （Chaos）],
2332 => [:Hall of Pride （Chaos）],
2334 => [:Hellgondo Cave （Chaos）],
2335 => [:Hellgondo Cave （Chaos）],
2336 => [:Hellgondo Continent （Chaos）, :Hellgondo Cave （Chaos）],
2337 => [:Hellgondo Continent （Chaos）, :Hellgondo Cave （Chaos）],
2338 => [:Hellgondo Continent （Chaos）, :"Dark Goddess' Castle （Chaos）"],
2339 => [:Hellgondo Continent （Chaos）, :"Dark Goddess' Castle （Chaos）"],
2340 => [:Hellgondo Continent （Chaos）],
2341 => [:"Dark Goddess' Castle （Chaos）"],
2342 => [:"Dark Goddess' Castle （Chaos）"],
2343 => [:"Dark Goddess' Castle （Chaos）"],
2344 => [:"Dark Goddess' Castle （Chaos）"],
2351 => [:Snow Cave （Chaos）],
2352 => [:Around Snow Heaven （Chaos）, :Snow Cave （Chaos）, :Snow Cave （Chaos）],
2353 => [:Around Snow Heaven （Chaos）, :Ilias Temple （Chaos）, :Snow Cave （Chaos）],
2354 => [:Around Snow Heaven （Chaos）, :Ilias Temple （Chaos）, :Snow Cave （Chaos）],
2355 => [:Around Snow Heaven （Chaos）, :Ilias Temple （Chaos）, :Snow Cave （Chaos）],
2356 => [:Around Snow Heaven （Chaos）, :Ilias Temple （Chaos）, :Snow Cave （Chaos）],
2357 => [:Around Snow Heaven （Chaos）, :Ilias Temple （Chaos）, :Snow Cave （Chaos）],
2358 => [:Around Snow Heaven （Chaos）],
2359 => [:Around Snow Heaven （Chaos）],
2360 => [:Around Snow Heaven （Chaos）],
2361 => [:Around Esta （Chaos）, :Around Snow Heaven （Chaos）, :Snow Shrine （Chaos）, :Hall of Creation （Chaos）],
2362 => [:Around Esta （Chaos）, :Around Snow Heaven （Chaos）, :Snow Shrine （Chaos）, :Hall of Creation （Chaos）],
2363 => [:Around Esta （Chaos）, :Ilias Temple （Chaos）, :Snow Shrine （Chaos）, :Hall of Creation （Chaos）],
2364 => [:Around Esta （Chaos）, :Ilias Temple （Chaos）, :Snow Shrine （Chaos）, :Hall of Creation （Chaos）],
2366 => [:Ilias Temple Ruins （Chaos）],
2367 => [:Ilias Temple Ruins （Chaos）],
2368 => [:Chaos Domain （Chaos）],
2369 => [:Chaos Domain （Chaos）],
2370 => [:Chaos Domain （Chaos）],
2373 => [:Devastated Plains （Chaos）],
2374 => [:Devastated Plains （Chaos）],
2375 => [:Devastated Plains （Chaos）],
2376 => [:Devastated Plains （Chaos）],
2377 => [:Devastated Plains （Chaos）],
2378 => [:Ilias Temple Ruins （Chaos）],
2379 => [:Ilias Temple Ruins （Chaos）],
2380 => [:Ilias Temple Ruins （Chaos）],
2381 => [:Ilias Temple Ruins （Chaos）],
2382 => [:Ilias Temple Ruins （Chaos）],
2383 => [:Ilias Temple Ruins （Chaos）],
2385 => [:Chaos Domain （Chaos）],
2396 => [:Palace of the Deadly Sins （Chaos）],
2501 => [:Towers of Light and Darkness （Chaos）],
2502 => [:Gestalt Hivemind （Chaos）],
2503 => [:Gestalt Hivemind （Chaos）],
2504 => [:Gestalt Hivemind （Chaos）],
2507 => [:Various Places （Chaos）],
2508 => [:Around Kitsune and Tanuki Village （Chaos）],
2509 => [:Around Kitsune and Tanuki Village （Chaos）],
2510 => [:Around Kitsune and Tanuki Village （Chaos）],
2511 => [:Around Kitsune and Tanuki Village （Chaos）],
2512 => [:Around Kitsune and Tanuki Village （Chaos）],
2513 => [:Around Kitsune and Tanuki Village （Chaos）],
2514 => [:Sealed Castle Mithra （Chaos）],
2515 => [:Mount Horai （Chaos）],
2516 => [:Mount Horai （Chaos）],
2517 => [:Mount Horai （Chaos）],
2518 => [:Mount Horai （Chaos）],
2519 => [:Mount Horai （Chaos）],
2520 => [:Mount Horai （Chaos）],
2521 => [:Mount Horai （Chaos）],
2522 => [:Mount Horai （Chaos）],
2523 => [:Sealed Castle Mithra （Chaos）],
2524 => [:Black Mansion （Chaos）],
2525 => [:"Dark Goddess' Castle （Chaos）"],
2526 => [:"Dark Goddess' Castle （Chaos）"],
2527 => [:"Dark Goddess' Castle （Chaos）"],
2528 => [:"Dark Goddess' Castle （Chaos）"],
2529 => [:"Dark Goddess' Castle （Chaos）"],
2530 => [:"Dark Goddess' Castle （Chaos）"],
2531 => [:"Dark Goddess' Castle （Chaos）"],
2532 => [:"Dark Goddess' Castle （Chaos）"],
2533 => [:"Dark Goddess' Castle （Chaos）"],
2534 => [:Chaos Domain （Chaos）],
2535 => [:Chaos Domain （Chaos）],
2536 => [:Chaos Domain （Chaos）],
2538 => [:Chaos Domain （Chaos）],
2539 => [:Chaos Domain （Chaos）],
2544 => [:Pyramid （Chaos）],
2545 => [:Chaos Domain （Chaos）],
2546 => [:Chaos Domain （Chaos）],
2547 => [:Chaos Domain （Chaos）],
2548 => [:Chaos Domain （Chaos）],
2549 => [:Chaos Domain （Chaos）],
2550 => [:Chaos Domain （Chaos）],
2551 => [:Chaos Domain （Chaos）],
2552 => [:Chaos Domain （Chaos）],
2554 => [:Around Esta （Chaos）, :"Water Spirit's Spring （Chaos）"],
2555 => [:Around Esta （Chaos）, :"Water Spirit's Spring （Chaos）"],
2556 => [:Sabasa Desert （Chaos）, :"Water Spirit's Spring （Chaos）", :Safar Ruins （Chaos）],
2558 => [:Sabasa Desert （Chaos）, :Safar Ruins （Chaos）],
2559 => [:Sabasa Desert （Chaos）, :Safar Ruins （Chaos）, :Snow Shrine （Chaos）, :Hall of Creation （Chaos）],
2562 => [:Sabasa Desert （Chaos）, :Safar Ruins （Chaos）, :Snow Shrine （Chaos）, :Hall of Creation （Chaos）],
2563 => [:Safar Ruins （Chaos）],
2565 => [:Around Grand Noah （Chaos）, :Grangold （Chaos）],
2566 => [:Around Grand Noah （Chaos）, :Grangold （Chaos）],
2567 => [:Grangold （Chaos）],
2568 => [:Around Grand Noah （Chaos）, :Grand Noah （Chaos）],
2569 => [:Around Goddard （Chaos）, :Western Gold Region （Chaos）, :Grand Noah （Chaos）, :Gold Volcano （Chaos）],
2571 => [:Grand Noah （Chaos）, :Gold Volcano （Chaos）],
2572 => [:Safar Ruins （Chaos）],
2573 => [:Grand Noah （Chaos）],
2574 => [:Around Goddard （Chaos）, :Around Grangold （Chaos）, :Western Gold Region （Chaos）, :Grand Noah （Chaos）],
2575 => [:Around Goddard （Chaos）, :Around Grangold （Chaos）, :Western Gold Region （Chaos）, :Grand Noah （Chaos）],
2576 => [:"Granberia's Nightmare （Chaos）"],
2577 => [:Around Goddard （Chaos）, :Around Grangold （Chaos）, :Western Gold Region （Chaos）, :Gold Volcano （Chaos）],
2578 => [:Around Goddard （Chaos）, :Around Grangold （Chaos）, :Western Gold Region （Chaos）, :Gold Volcano （Chaos）],
2579 => [:Gold Volcano （Chaos）],
2584 => [:Hellgondo Continent （Chaos）, :Remina Research Institute （Chaos）],
2585 => [:Hellgondo Continent （Chaos）, :Remina Research Institute （Chaos）],
2586 => [:Hellgondo Continent （Chaos）, :Remina Research Institute （Chaos）],
2587 => [:Hellgondo Continent （Chaos）, :Remina Research Institute （Chaos）],
2589 => [:Remina Research Institute （Chaos）],
2590 => [:Remina Research Institute （Chaos）],
2592 => [:Remina Research Institute （Chaos）],
2593 => [:Remina Research Institute （Chaos）],
2595 => [:Ilias Temple （Chaos）],
2596 => [:Remina Research Institute （Chaos）],
2597 => [:Lunar Mechanical Fortress （Chaos）],
2598 => [:Lunar Mechanical Fortress （Chaos）],
2599 => [:Lunar Mechanical Fortress （Chaos）],
2600 => [:Lunar Mechanical Fortress （Chaos）],
2601 => [:Ilias Temple （Chaos）],
2602 => [:Ilias Temple （Chaos）],
2603 => [:Around Port Natalia （Chaos）, :Around Monte Carlo （Chaos）, :Ilias Temple （Chaos）],
2604 => [:Around Port Natalia （Chaos）, :Around Monte Carlo （Chaos）, :Lunar Mechanical Fortress （Chaos）],
2611 => [:Around Port Natalia （Chaos）, :Around Monte Carlo （Chaos）],
2613 => [:Alliance of Wisdom Laboratory （Chaos）],
2616 => [:Forest of Spirits （Chaos）],
2618 => [:Core of the Star （Chaos）],
2619 => [:"Fairy's Island （Chaos）"],
2620 => [:"Fairy's Island （Chaos）"],
2621 => [:"Fairy's Island （Chaos）"],
2622 => [:"Fairy's Island （Chaos）"],
2623 => [:"Fairy's Island （Chaos）"],
2626 => [:Black Mansion （Chaos）],
2627 => [:Black Mansion （Chaos）],
2628 => [:Black Mansion （Chaos）],
2629 => [:Black Mansion （Chaos）],
2630 => [:Black Mansion （Chaos）],
2631 => [:Black Mansion （Chaos）],
2632 => [:Grandeur （Chaos）],
2633 => [:Black Mansion （Chaos）],
2634 => [:Black Mansion （Chaos）],
2635 => [:Black Mansion （Chaos）],
2637 => [:Black Mansion （Chaos）],
2638 => [:Black Mansion （Chaos）],
2639 => [:Black Mansion （Chaos）],
2640 => [:Black Mansion （Chaos）],
2642 => [:Black Mansion （Chaos）],
2643 => [:Black Mansion （Chaos）],
2644 => [:Black Mansion （Chaos）],
2645 => [:Black Mansion （Chaos）],
2646 => [:Black Mansion （Chaos）],
2647 => [:Chaos Domain （Chaos）],
2648 => [:Black Mansion （Chaos）],
2650 => [:Road to the Underworld （Chaos）],
2651 => [:Road to the Underworld （Chaos）],
2652 => [:Road to the Underworld （Chaos）],
2653 => [:Road to the Underworld （Chaos）],
2654 => [:Alliance of Wisdom Laboratory （Chaos）],
2655 => [:The Moon （Chaos）],
2656 => [:The Moon （Chaos）],
2657 => [:The Moon （Chaos）],
2658 => [:The Moon （Chaos）],
2659 => [:The Moon （Chaos）],
2660 => [:The Moon （Chaos）],
2662 => [:Mount Saint Amos （Chaos）, :Towers of Light and Darkness （Chaos）],
2663 => [:Mount Saint Amos （Chaos）],
2664 => [:Mount Saint Amos （Chaos）],
2665 => [:Mount Saint Amos （Chaos）],
2666 => [:Mount Saint Amos （Chaos）],
2667 => [:Chaos Domain （Chaos）],
2668 => [:Towers of Light and Darkness （Chaos）],
2669 => [:Towers of Light and Darkness （Chaos）],
2670 => [:Towers of Light and Darkness （Chaos）],
2671 => [:Sealed Castle Mithra （Chaos）],
2672 => [:Sealed Castle Mithra （Chaos）],
2673 => [:Sealed Castle Mithra （Chaos）],
2674 => [:Sealed Castle Mithra （Chaos）],
2675 => [:Sealed Castle Mithra （Chaos）],
2676 => [:Chaos Domain （Chaos）],
2677 => [:Chaos Domain （Chaos）],
2678 => [:Chaos Domain （Chaos）],
2679 => [:Chaos Domain （Chaos）],
2680 => [:Chaos Domain （Chaos）],
2681 => [:Chaos Domain （Chaos）],
2682 => [:Sealed Castle Mithra （Chaos）],
2683 => [:Sealed Castle Mithra （Chaos）],
2684 => [:Sealed Castle Mithra （Chaos）],
2685 => [:Sealed Castle Mithra （Chaos）],
2686 => [:Ilias Temple （Chaos）],
2690 => [:"Granberia's Nightmare （Chaos）"],
2691 => [:Western Gold Region （Chaos）],
2692 => [:Around Goddard （Chaos）, :Around Grangold （Chaos）, :Western Gold Region （Chaos）],
2693 => [:Western Gold Region （Chaos）],
2694 => [:Hall of Lust （Chaos）],
2695 => [:Hall of Lust （Chaos）],
2697 => [:Around Goddard （Chaos）, :Around Grangold （Chaos）, :Gold Volcano （Chaos）],
2698 => [:Around Goddard （Chaos）, :Around Grangold （Chaos）, :Gold Volcano （Chaos）],
2699 => [:Grangold （Chaos）, :Gold Fort （Chaos）],
2700 => [:Grangold （Chaos）, :Gold Fort （Chaos）],
2701 => [:Grangold （Chaos）, :Gold Fort （Chaos）],
2703 => [:Grangold （Chaos）],
2704 => [:Grangold （Chaos）],
2705 => [:Grangold （Chaos）],
2706 => [:Around Grand Noah （Chaos）, :Around Esta （Chaos）, :Grand Noah （Chaos）, :Gold Fort （Chaos）],
2707 => [:Around Grand Noah （Chaos）, :Around Esta （Chaos）, :Grand Noah （Chaos）, :Gold Fort （Chaos）],
2708 => [:Around Grand Noah （Chaos）, :Around Esta （Chaos）, :Grand Noah （Chaos）, :"Water Spirit's Spring （Chaos）"],
2709 => [:"Water Spirit's Spring （Chaos）"],
2710 => [:Grand Noah （Chaos）, :"Water Spirit's Spring （Chaos）"],
2712 => [:"Water Spirit's Spring （Chaos）"],
2713 => [:Gold Volcano （Chaos）],
2714 => [:Gold Volcano （Chaos）],
2715 => [:Various Places （Chaos）],
2716 => [:Gold Volcano （Chaos）],
2717 => [:Towers of Light and Darkness （Chaos）],
2718 => [:"Water Spirit's Spring （Chaos）"],
2719 => [:"Water Spirit's Spring （Chaos）"],
2720 => [:"Water Spirit's Spring （Chaos）"],
2721 => [:Towers of Light and Darkness （Chaos）],
2724 => [:Around Yamatai （Chaos）],
2725 => [:Around Yamatai （Chaos）, :Mount Horai （Chaos）],
2726 => [:Around Yamatai （Chaos）, :Mount Horai （Chaos）],
2727 => [:Around Yamatai （Chaos）, :Mount Horai （Chaos）],
2729 => [:Around Port Natalia （Chaos）, :Around Monte Carlo （Chaos）, :Around Yamatai （Chaos）],
2730 => [:Around Port Natalia （Chaos）, :Around Monte Carlo （Chaos）, :Around Yamatai （Chaos）],
2731 => [:"Granberia's Nightmare （Chaos）"],
2732 => [:Forest of Spirits （Chaos）],
2733 => [:Forest of Spirits （Chaos）],
2735 => [:Forest of Spirits （Chaos）],
2736 => [:Around Port Natalia （Chaos）, :Around Monte Carlo （Chaos）],
2737 => [:Around Port Natalia （Chaos）, :Around Monte Carlo （Chaos）],
2738 => [:Lyra Falls （Chaos）],
2739 => [:Lyra Falls （Chaos）],
2741 => [:Cursed Undersea Temple （Chaos）],
2742 => [:"Fairy's Island （Chaos）"],
2743 => [:Towers of Light and Darkness （Chaos）],
2745 => [:Hall of Lust （Chaos）],
2746 => [:Hall of Lust （Chaos）],
2747 => [:Hall of Lust （Chaos）, :Towers of Light and Darkness （Chaos）],
2751 => [:"Granberia's Nightmare （Chaos）"],
2753 => [:"Puppeteer's Tower （Chaos）"],
2754 => [:"Puppeteer's Tower （Chaos）"],
2755 => [:"Puppeteer's Tower （Chaos）"],
2756 => [:"Puppeteer's Tower （Chaos）"],
2757 => [:"Puppeteer's Tower （Chaos）"],
2759 => [:"Puppeteer's Tower （Chaos）"],
2760 => [:"Puppeteer's Tower （Chaos）"],
2762 => [:"Puppeteer's Tower （Chaos）"],
2763 => [:"Puppeteer's Tower （Chaos）"],
2765 => [:"Puppeteer's Tower （Chaos）"],
2767 => [:"Puppeteer's Tower （Chaos）"],
2768 => [:"Puppeteer's Tower （Chaos）"],
2769 => [:Alliance of Wisdom Laboratory],
2770 => [:Alliance of Wisdom Laboratory],
2771 => [:Alliance of Wisdom Laboratory],
2772 => [:Alliance of Wisdom Laboratory],
2773 => [:Sabasa Desert （Chaos）, :Sabasa Desert （Chaos）, :Safar Ruins （Chaos）],
2774 => [:Sabasa Desert （Chaos）, :Sabasa Desert （Chaos）, :Safar Ruins （Chaos）],
2775 => [:Sabasa Desert （Chaos）, :Sabasa Desert （Chaos）, :Safar Ruins （Chaos）],
2776 => [:Towers of Light and Darkness （Chaos）],
2778 => [:Towers of Light and Darkness （Chaos）],
2781 => [:Calamity Star Demiurge （Chaos）, :Devastated Plains （Chaos）],
2782 => [:Calamity Star Demiurge （Chaos）, :Devastated Plains （Chaos）],
2783 => [:Calamity Star Demiurge （Chaos）, :Devastated Plains （Chaos）],
2784 => [:Sabasa （Chaos）],
2785 => [:Ilias Temple Ruins （Chaos）],
2786 => [:Ilias Temple Ruins （Chaos）],
2787 => [:Ilias Temple Ruins （Chaos）],
2788 => [:Ilias Temple Ruins （Chaos）],
2789 => [:Ilias Temple Ruins （Chaos）],
2790 => [:Ilias Temple Ruins （Chaos）],
2791 => [:Ilias Temple Ruins （Chaos）],
2792 => [:Ilias Temple Ruins （Chaos）],
2793 => [:Ilias Temple Ruins （Chaos）],
2794 => [:Ilias Temple Ruins （Chaos）],
2798 => [:Place of Memory （Chaos）],
2799 => [:Place of Memory （Chaos）],
2800 => [:Place of Memory （Chaos）],
2801 => [:Place of Memory （Chaos）],
2802 => [:Place of Memory （Chaos）],
2803 => [:Place of Memory （Chaos）],
2804 => [:Place of Memory （Chaos）],
2805 => [:Place of Memory （Chaos）],
2806 => [:Place of Memory （Chaos）],
2807 => [:Hellgondo Continent （Chaos）, :Calamity Star Demiurge （Chaos）],
2808 => [:Hellgondo Continent （Chaos）, :Calamity Star Demiurge （Chaos）],
2809 => [:Chaos Domain （Chaos）],
2811 => [:Grand Noah （Chaos）],
2812 => [:Hellgondo Continent （Chaos）, :Towers of Light and Darkness （Chaos）],
2813 => [:Hellgondo Continent （Chaos）, :Towers of Light and Darkness （Chaos）],
2814 => [:Hellgondo Continent （Chaos）],
2815 => [:Towers of Light and Darkness （Chaos）],
2816 => [:Towers of Light and Darkness （Chaos）],
2817 => [:Chaos Domain （Chaos）],
2818 => [:Chaos Domain （Chaos）],
2819 => [:Chaos Domain （Chaos）],
2820 => [:Chaos Domain （Chaos）],
2821 => [:Chaos Domain （Chaos）],
2822 => [:Chaos Domain （Chaos）],
2824 => [:"Dark Goddess' Castle （Chaos）"],
2828 => [:"Dark Goddess' Castle （Chaos）"],
2829 => [:"Dark Goddess' Castle （Chaos）"],
2832 => [:Alliance of Wisdom Laboratory （Chaos）],
2833 => [:Alliance of Wisdom Laboratory （Chaos）],
2880 => [:Palace of the Deadly Sins （Chaos）],
2910 => [:Palace of the Deadly Sins （Chaos）],
2911 => [:Palace of the Deadly Sins （Chaos）],
2912 => [:Palace of the Deadly Sins （Chaos）],
2914 => [:Palace of the Deadly Sins （Chaos）],
2915 => [:Palace of the Deadly Sins （Chaos）],
2916 => [:Palace of the Deadly Sins （Chaos）],
2917 => [:Palace of the Deadly Sins （Chaos）],
2918 => [:Palace of the Deadly Sins （Chaos）],
2921 => [:Palace of the Deadly Sins （Chaos）],
2965 => [:Chaos Domain （Chaos）],
2966 => [:Chaos Domain （Chaos）],

  }

  ENEMY_DESCRIPTION = {
    1 => [
      "The Slime Girl is often considered",
      "a weak monster, but the ability to",
      "freely control the shape of her body",
      "can make her a threatening foe.",
      "Weak adventurers are sure to",
      "struggle against her.",
      "",
      "They are usually happy",
      "and friendly towards humans.",
      "However, they feed mainly on",
      "semen so they regularly seek out",
      "weak men to attack. They pleasure",
      "them by wrapping up the man's body",
      "in their slime to extract their semen.",
      "With the prey stuck in their body",
      "they are able to feed ten or more",
      "times on a single man. For the most",
      "part, the Slime Girl will release",
      "her catch after feeding. However,",
      "there are uncommon reports of males",
      "getting snatched away should their",
      "semen happen to be especially tasty.",
      "",
      "Incidentally, semen is required for",
      "Slime Girls to divide into new",
      "Slime Girls.",
      "",
      "Artist: Kenkō Cross",
    ],
    2 => [
      "A slime-based monster comprised of",
      "pink liquid. Wanting to be a rabbit,",
      "she insists that she is one and",
      "cries when you point out that she is",
      "not a rabbit.",
      "",
      "Although she is known among slime",
      "monsters for causing trouble, it is",
      "difficult to say if she is truly",
      "hostile towards humans. She is quite",
      "greedy, however, and captures human",
      "men in her sticky body to squeeze",
      "out their semen.",
      "",
      "As for why her body is pink, she",
      "claims it was because she ate a lot",
      "of humans, but it is actually from",
      "eating too many carrots.",
      "",
      "Artist: Arekishi",
    ],
    3 => [
      "A slime-based monster comprised of",
      "pink liquid. Wanting to be a rabbit,",
      "she insists that she is one and",
      "cries when you point out that she is",
      "not a rabbit.",
      "",
      "Although she is known among slime",
      "monsters for causing trouble, it is",
      "difficult to say if she is truly",
      "hostile towards humans. She is quite",
      "greedy, however, and captures human",
      "men in her sticky body to squeeze",
      "out their semen.",
      "",
      "As for why her body is pink, she",
      "claims it was because she ate a lot",
      "of humans, but it is actually from",
      "eating too many carrots.",
      "",
      "Artist: Arekishi",
      ],
    4 => [
      "With her body that of a soft slug,",
	  "weak attacks will get stuck in her",
      "mucus-covered membrane. The Slug Girl's",
	  "behavior is to take walks at night",
      "and attack any men she encounters.",
	  "Like most monsters, her staple food",
      "is semen. Using the lower half of",
	  "her body, she carefully stimulates",
      "her catch to feed.",
      "",
      "Once she catches a male in her slimy",
	  "mucus membrane, they are forced to",
      "ejaculate with surprising ease.",
      "With that, she is able to feed.",
	  "",
      "In addition, if the Slug Girl",
	  "particularly likes her catch, she will",
      "use the genitals in the slug half of",
	  "her body to mate with her prey. Using",
      "the same techniques as feeding, she",
	  "will force the male to release just",
	  "enough semen for breeding.",
      "",
      "Once a suitable male has been found to",
	  "copulate with, the Slug Girl will",
	  "continue to use him as both a mate",
      "and a source of food for the rest of",
      "his life.",
      "",
      "Artist: UN_DO",
    ],
    5 => [
      "A common variety juvenile succubus",
      "that's just barely proficient in black",
      "magic. A novice Hero may have some",
      "trouble fighting her but a seasoned",
	  "warrior can defeat one with little",
	  "issue.",
      "",
      "That being said, it's easy to make",
      "light of her low-class status and mess",
      "around. Weak though she may be, it's",
      "dangerous to let any succubus play",
      "with you sexually. If she manages to",
      "make the man come, he will be left",
      "powerless. If that were to happen,",
      "even a powerful human would be",
      "subjected to a humiliating fate by",
      "this otherwise weak Imp.",
	  "",
	  "Though she's an incredibly low-grade",
	  "monster, you must never forget that",
	  "she is still a monster.",
      "",
      "Artist: Arekishi",
    ],
    6 => [
      "A monster born from human blood and",
      "semen. Usually buried underground, she",
      "is able to sleep for decades at a time.",
      "Normally the photosynthesis from their",
      "leaves above ground is enough to",
	  "sustain them.",
      "",
      "Mandragoras are mostly harmless,",
      "staying underground. However, if they",
      "are forced out against their will,",
      "they will let loose a powerful shriek",
      "that paralyzes all living beings that",
      "hear it. Left in a bad mood, they will",
      "attack whoever pulled them out. If",
	  "it's a man they are sure to supplement",
	  "their diet with his semen.",
      "",
      "As a plant that's close to being human,",
      "Mandragora have female genitals that",
      "can be used for both feeding and",
      "reproduction. In addition, they are",
      "known to use their mouths and breasts",
      "to wring semen from their prey.",
	  "",
      "As they are generally harmless to",	  
	  "humans, it's wise to be wary of",
	  "pulling them from the ground.",
      "",
      "Artist: Setouchi",
    ],
    7 => [
      "A beast-type monster that strongly",
      "expresses human characteristics,",
      "also known as a beastman. Though she",
      "is similar to a human, her strength",
      "and agility when using fang and claw",
      "attacks cannot be matched by",
      "ordinary people. She is mild-",
      "mannered and well-acquainted with",
      "humans. Many have settled in towns,",
      "and they are quite fond of human",
      "society.",
      "",
      "There have been rare cases where",
      "they have attacked humans to steal",
      "from them, or forced themselves upon",
      "men to mate with them. Mating done",
      "while they're in heat is",
      "particularly intense, as they",
      "instinctively shake their waists to",
      "wring out semen. However, there have",
      "been no instances of them taking",
      "lives. Basically, she is a friendly",
      "and peaceful monster.",
      "",
      "Artist: Uminoyama",
      ],
    8 => [
      "Similar to a normal earthworm, her",
      "entire body is slimy. Though she",
      "usually lives underground,",
      "Earthworm Girls are known to come",
	  "above ground to attack men when",
	  "they're hungry.",
      "",
      "Feeding primarily on semen, they are",
      "able to both absorb it through their",
      "skin and to directly suck it out",
      "with their tails. Their basic attack",
      "pattern is to wrap their bodies",
      "around their catch and seal off",
      "their movements as they feed. If",
      "their prey is combative, they can",
      "use their tails to forcefully suck",
	  "out their food by forcing pleasure",
	  "onto their catch.",
      "",
      "As with feeding, when they wish to",
      "mate they use their tails. When they",
      "are finished feeding, in most cases",
      "they release their catch. However,",
      "cases have been reported of men being",
      "brought back to the Earthworm Girl's",
      "underground nest to be kept as a mate",
	  "if the male catches her interest.",
      "",
      "Artist: Setouchi",
    ],
    9 => [
      "A monster, albeit a young girl.",
      "Even so, she holds insane strength",
      "that shouldn't be underestimated.",
      "This Goblin Girl appears to be a",
      "thief, stealing from travelers and",
	  "merchants. In addition, she has been",
	  "known to attack and rape young men.",
      "",
      "Her diet is similar to humans, so",
      "she only attacks young men for fun.",
      "With her already tight vagina, the",
      "Goblin Girl also has muscles that",
      "she can control at will to adjust",
      "her own tightness. Her ultimate",
      "attack is the [Super Tightening],",
      "in which she uses all of her muscles",
      "at the same time to force the person",
	  "she's raping to orgasm instantly.",
      "",
      "After raping her targets for fun,",
      "she releases them. However, it seems",
      "she is looking for someone she",
      "really likes to take back to her",
	  "hideout to keep for fun.",
      "",
      "Artist: frfr",
    ],
    10 => [
      "A young Lamia that is still immature",
      "in both power and body. One of the",
      "four bandits, she too steals from",
      "travelers and merchants. If a weak",
      "man is among her usual targets, she",
	  "tries to wrap her small tail around",
	  "them.",
	  "",
      "Following her Lamia instincts in",
      "wanting to coil around men, her weak",
      "tail is barely able to cause pain.",
      "However, her tight and tiny vagina",
      "is more than enough to force a man",
      "to submit to her. If she manages to",
      "take a man into her, they are sure",
      "to be squeezed dry.",
      "",
      "Her only purpose in attacking men is",
      "from instinct and desire to feed.",
	  "She is unable to rape for",
	  "reproductive purposes yet.",
      "",
      "Artist: Jingai Modoki",
    ],
    11 => [
      "Another young monster of the",
      "Four Bandits. Even though she is a",
      "young vampire, she already possesses",
      "some of the powerful abilities of",
      "adult vampires, such as the ability",
	  "to transform into a bat and to use",
	  "her eyes to control her target's",
	  "mind.",
	  "",
      "Like an adult vampire, she is able",
      "to suck the energy from her prey,",
      "especially from a man's penis.",
      "Most men would be quick to give in",
      "to her energy sucking, gladly",
      "offering both their energy and semen",
      "to her mouth. In addition, she is",
      "capable of sucking energy from her",
      "target with her vagina. Squeezing",
      "the man as if she was milking him,",
      "she can extract his energy. She",
      "enjoys playing with men like toys",
	  "until they faint.",
	  "",
	  "She may look young and immature,",
      "but one must not forget that she is",
	  "still a powerful vampire.",
	  "",
      "Artist: Jingai Modoki",
    ],
    12 => [
      "An energetic girl from the Dragon",
      "race. Able to eat anything, she can",
      "live just like a human. Liking meat",
      "more than anything, they aren't",
      "known for attacking men for semen.",
      "Even though she's young, she still",
      "retains characteristics of matured",
	  "Dragons.",
      "",
      "However, when her opponent is a",
      "young man it seems as though she",
      "can't help but rape him. Like others",
      "of the Dragon race, her body",
      "temperature is naturally high, which",
      "causes her vagina to be abnormally",
      "hot. Most men are forced to quickly",
      "submit to the combined tightness and",
	  "heat of the Dragon Pup.",
	  "",
      "After a particularly fierce battle,",
      "she is not satisfied with just",
      "raping her opponent once. Submitting",
      "to her reproductive instincts, she",
      "will continue to rape her opponent",
	  "over and over repeatedly. She may",
	  "look like a young girl, but even a",
      "'pup' is still a member of the",
	  "dangerous dragon race.",
	  "",
      "Artist: Jingai Modoki",
    ],
    13 => [
      "A Beastman monster resembling a",
      "rat that prefers to live in dark",
      "places. While her heart is often",
      "troubled from such a dank life, she",
      "is very down-to-earth. Her body",
      "carries toxins, and she can",
      "sometimes infect others with her",
      "fangs and claws.",
      "",
      "Living in close proximity to human",
      "society, they are typical urban",
      "monsters who become more active",
      "following disasters. Every day, they",
      "enter town to sneak into houses and",
      "steal food. Food is usually stolen",
      "while people are away; cheese in",
      "particular is said to be their",
      "favorite.",
      "",
      "When they're in heat, they attack",
      "humans and force them to mate for",
      "reproduction. She will then bring",
      "the man back to her nest, where",
      "he may be gang-raped by other Rat",
      "Girls. The man will be violated by",
      "them for semen until he's on the",
      "verge of death, but they will not",
      "deprive him of his life.",
      "",
      "Artist: Uminoyama",
    ],
    14 => [
      "A Beast-type monster resembling a",
      "wolf. With their incredible agility,",
      "they swiftly hunt prey using their",
      "fangs and claws. Their hunting",
      "targets are limited to large mammals",
      "such as wild boars, and they almost",
      "never target humans. They are",
      "surprisingly sociable, operating in",
      "the manner of a tribal system, and",
      "adhere to a law of not preying upon",
      "those who can speak.",
      "",
      "While they do not prey upon humans,",
      "they may attack and use them as",
      "mating partners when they're in",
      "heat. She will search for a high-",
      "quality male, ambush him and force",
      "him to mate with her. The vagina of",
      "her trained body is very tight, and",
      "will leave the man with no choice",
      "but to release all of his semen into",
      "her womb.",
      "",
      "In addition, the Wolf Girls worship",
      "their ancestral god named Fenrir.",
      "According to legend, she lived on",
      "the moon and led a war tribe that",
      "was defeated in ancient times, but",
      "the truth remains unknown.",
      "",
      "Artist: Neko Manma",
    ],
    15 => [
      "A Phoenix Girl who is regarded as a",
      "sacred bird of immortality. She is",
      "said to repeatedly reincarnate in",
      "flames and, due to being reborn just",
      "recently, bears the appearance of an",
      "innocent girl. While she was taking",
      "a stroll outside of the volcano she",
      "met Don Dahlia, who persuaded her to",
      "be exploited. Because she has never",
      "had contact with other humans",
      "before, and Don Dahlia constantly",
      "admonishes her about human malice,",
      "she has begun to fear them.",
      "",
      "She always has a high fever from her",
      "body heat, and struggles with it",
      "herself. This heat appears to",
      "subside while mating, but she",
      "maintains a high body temperature",
      "inside her vagina, resulting in",
      "increased pleasure. A man who has",
      "inserted his penis into her vagina",
      "will experience repeated",
      "ejaculations while melting in the",
      "unexpected warmth.",
      "",
      "Artist: Jingai Modoki",
    ],
    16 => [
      "A Land-Dweller type with the lower",
      "body of a giant Leech. Though she",
      "can feed on all of a human's bodily",
      "fluids, they will only catch men.",
      "Once the Leech Girl sets her sights",
      "on a healthy-looking male, she will",
      "suck his entire body into her mouth",
	  "as she wrings out all of his body",
	  "fluids.",
	  "",
      "Able to feast on more than semen,",
      "the Leech Girl will force the man to",
      "both sweat and urinate as she sucks",
      "out everything out of her catch.",
      "Equipped with thousands of tongues",
      "inside her mouth, she is able to",
      "force pleasure into the man. With",
      "his body stuck in her mouth, there",
      "is no escape as he is forced to",
      "constantly ejaculate. In addition,",
      "by tickling, her prey she can force",
	  "him to incontinence on demand.",
	  "",
      "Continuing her feast for multiple",
      "days, there are many men who are",
      "weakened so much that they die. If",
      "she finds a high-quality catch, she",
      "can direct the semen discharge to",
	  "her genitals for reproductive",
	  "purposes.",
	  "",
      "Artist: Setouchi",
    ],
    17 => [
      "A rabbit-type beastman monster who",
      "is quite fond of humans. Though she",
      "is not as powerful as other beasts",
      "she has superior dexterity and",
      "reflexes, and her skills as a hunter",
      "are sharp. They blend into human",
      "society without discomfort, and many",
      "live as residents among them.",
      "",
      "Their staple diet is vegetables, and",
      "they never eat meat. Hunting is",
      "usually done at the request of",
      "humans, targeting pests and hostile",
      "monsters. There are many of them",
      "traveling, and are said to be the",
      "closest monsters to human society",
      "alongside Dog Girls. However, there",
      "appear to be some who target humans",
      "as lone hunters.",
      "",
      "They are always in heat however, and",
      "are considered to be very lewd",
      "monsters. Many of them will invite",
      "human men into taverns, and if you",
      "carelessly give in to their",
      "temptations, they will mate with you",
      "an extraordinary number of times.",
      "The man will not be deprived of his",
      "life, but he likely won't be able to",
      "stand on his legs for several days.",
      "",
      "They seem to get along with the",
      "Sheep Girls, whose habitat overlaps",
      "with theirs and have a similar",
      "ecology. One can often be seen",
      "looking after a drunken Sheep Girl.",
      "",
      "Artist: Neko Manma",
    ],
    18 => [
      "A sheep-type beastman monster that",
      "loves alcohol. She does not have",
      "sharp fangs or claws, but her legs",
      "are strong, and she can deliver a",
      "powerful impact with a body rush.",
      "She is always drinking, and it is",
      "unusual to see her sober. She rarely",
      "harms anyone directly, but she can",
      "be dangerous if you are in the path",
      "of her drunken stupor.",
      "",
      "There have been cases where her",
      "drunken aggression has led her to",
      "rape men. Her vaginal folds are",
      "very pleasurable, and will force the",
      "violated man to ejaculate in rapid",
      "succession. The man will not get",
      "squeezed to death, as the Sheep Girl",
      "gets too drunk and falls asleep",
      "before that happens.",
      "",
      "She is very close to the Rabbit",
      "Girl, and they can often be seen",
      "drinking together at a bar. The",
      "Rabbit Girl carries out the Sheep",
      "Girl after she has fallen asleep.",
      "",
      "Artist: Uminoyama",
    ],
    19 => [
      "A mysterious being known as an",
      "Apoptosis, which resides in",
      "Tartarus. They are organisms",
      "resembling monsters, but no one",
      "knows what they are. Moreover, she",
      "appears to instinctively attack",
      "intruders as if programmed into her",
      "mind.",
      "",
      "Sully is similar to a sea-dweller,",
      "and has an innocent personality. She",
      "is curious about the outside world,",
      "and is particularly interested in",
      "food.",
      "",
      "She is also capable of performing",
      "sexual intercourse and is able to",
      "produce offspring. Her instincts are",
      "like those of a crab monster,",
      "secreting bubbles to wash her",
      "victim's genitals. After that, she",
      "will insert his penis into her",
      "vagina to squeeze out his semen.",
      "",
      "Artist: xelvy",
    ],
    20 => [
      "A mysterious being known as an",
      "Apoptosis, which resides in",
      "Tartarus. They are organisms",
      "resembling monsters, but no one",
      "knows what they are. Moreover, she",
      "appears to instinctively attack",
      "intruders as if programmed into her",
      "mind.",
      "",
      "Jaide's lower body is primarily",
      "composed of machinery, with her legs",
      "in particular providing a mechanism",
      "for gripping and fixing the lower",
      "half of a human body to her. She",
      "will then insert the man into her",
      "vagina and thoroughly suck up his",
      "semen.",
      "",
      "Moreover, her body is highly fused",
      "with the machinery, as seen with her",
      "ability to emit lasers from her",
      "eyes. Even her decision-making is",
      "done very mechanically. Yet she",
      "still bears many elements of living",
      "organisms, making her a very",
      "mysterious being.",
      "",
      "Artist: xelvy",
    ],
    21 => [
      "A mysterious being known as an",
      "Apoptosis, which resides in",
      "Tartarus. They are organisms",
      "resembling monsters, but no one",
      "knows what they are. Moreover, she",
      "appears to instinctively attack",
      "intruders as if programmed into her",
      "mind.",
      "",
      "Shesta's lower body is that of a",
      "large insect, and she uses her tough",
      "legs to hold her prey as their semen",
      "is squeezed. It is also possible for",
      "her to mate like this. In most cases",
      "she will squeeze her prey until it is",
      "exhausted, then abandon their",
      "miserable corpse once it has been",
      "drained of semen.",
      "",
      "She appears to have fragments of a",
      "human memory, sometimes experiencing",
      "flashbacks to life in a town. It can",
      "be inferred that she used to be a",
      "human being in the past, but the",
      "circumstances of her transformation",
      "are unknown.",
      "",
      "Artist: xelvy",
    ],
    22 => [
      "A mysterious, tentacled being",
      "inhabiting Tartarus. She appears to",
      "be an Apoptosis, but details are",
      "unknown. She likes fruit,",
      "particularly apples which seem to be",
      "her favorite, and never eats",
      "human-sized prey. However, if she",
      "suddenly encounters a threat, she",
      "will promptly go on the offensive.",
      "",
      "She is normally friendly with a",
      "temperate nature. She has a tendency",
      "to develop an emotional attachment",
      "towards her opponents, and follows",
      "them around. Although she can only",
      "say \"kyuu\", she appears to",
      "understand human language.",
      "",
      "Her tentacles are equipped with an",
      "extracting function, which open up",
      "like mouths at the tip to suck semen",
      "from the penis. She will release you",
      "once she is satisfied, but she will",
      "be able to force several",
      "ejaculations before then. However,",
      "nothing is known about her",
      "reproductive capability.",
      "",
      "Artist: Arekishi",
    ],
    23 => [
      "A powerful pig-like monster who",
      "lives like a bandit and raids human",
      "villages with a club in one hand.",
      "She doesn't just plunder goods, but",
      "kidnaps men of age as well, and",
      "brings them back to her den to",
      "rape them. Sometimes violent",
      "gangbangs are done to acquire",
      "semen. Surprisingly, she rarely",
      "ever kills humans, and only uses",
      "violence for intimidation.",
      "",
      "Her vagina contains spiral-shaped",
      "folds which cause most men to",
      "ejaculate right after inserting.",
      "Her muscular lower body also",
      "contributes to her vagina's",
      "tightness, giving it one of the best",
      "among the Beast race. Many kidnapped",
      "men become captivated by their",
      "renowned genitals.",
      "",
      "They usually act in a group, but",
      "when they are alone, their",
      "personality becomes quiet and they",
      "will even show a playful side.",
      "Although they have a ferocious group",
      "mentality, they appear to be a",
      "gentle and honest species at their",
      "core.",
      "",
      "Artist: SugaMon",
    ],
    24 => [
      "An Insect monster that resembles a",
      "bee. She carries a large source of",
      "honey with her at all times, but",
      "that alone is not enough to feed",
      "her. The Bee Girl's favorite food is",
      "to mix their honey with male semen.",
      "To create this mixture, she will",
      "aggressively attack travelers.",
      "She will first cover her target with",
      "honey and then slowly lick it of as",
      "it mixes with his sweat.",
      "Due to the combination of her",
      "incredibly long tongue and her",
      "sticky honey, she is able to easily",
	  "force men to ejaculate. Forcing her",
	  "prey to ejaculate continuously, she",
	  "will feast on her mixture.",
      "",
      "The Bee Girl is particularly fickle,",
      "and will generally get tired of the",
      "taste of their catch after around",
      "five ejaculations. After that, they",
      "are known to release their prey.",
      "However, if they find a rare taste",
	  "that they really enjoy, they may",
	  "keep their prey forever.",
      "",
      "Artist: Setouchi",
    ],
    25 => [
      "A weak bird monster that is a",
      "variant of the Harpy race. Modest",
      "and quiet, their physical abilities",
      "are weaker compared to the average",
      "Harpy. Since their bodies are small,",
      "however, they have excellent",
      "maneuverability.",
      "",
      "She is a monster who announces the",
      "arrival of dawn, and her Sparrow",
      "Dance has the effect of waking",
      "people from their slumber. The",
      "Sparrow Girl herself is very",
      "meticulous, and does not go to sleep",
      "accidentally.",
      "",
      "Reproduction is done by politely",
      "asking a human male to mate with",
      "them. However, they have been known",
      "to attack and force men to mate with",
      "them if they step into their",
      "territory. Although they are a",
      "quiet species, it is unwise to",
      "disturb them.",
      "",
      "Artist: Neko Manma",
    ],
    26 => [
      "A typical bird monster. Though there",
      "are some slight differences between",
      "Harpies, they generally have the",
      "same behaviors. Primarily",
      "herbivores, they generally feed on",
      "nuts, vegetables and bread. Though",
      "they don't feed on semen, many",
	  "Harpies are eager to mate with",
	  "humans.",
      "",
      "To show their dominance,",
      "they will force men to mate with",
      "them for reproductive purposes.",
      "Forcing men into their soft vagina,",
      "their feathers tickle the male's",
      "body as the Harpies wildly shake",
      "their hips. The unique and",
      "forceful nature of this mating",
	  "ritual usually forces men to climax",
	  "within a single minute.",
      "",
      "If their partner has high-quality",
      "sperm, the Harpy will force them to",
      "ejaculate many times to ensure",
      "fertilization. It's not uncommon for",
      "the mating to continue uninterrupted",
	  "for multiple days in a row.",
	  "",
	  "If the Harpy really enjoys her mate,",
      "she will keep having sex just for",
	  "the fun of it. A man forced to marry",
	  "a Harpy will seldom have a moment's",
	  "rest, and will spend nearly all",
	  "his time locked in intercourse with",
	  "the Harpy.",
	  "Artist: frfr",
    ],
    27 => [
      "Close sisters that live in Harpy",
      "Village. Not limited to Harpies,",
      "twins and sisters are actually quite",
      "common among various monster types.",
	  "This phenomenon is especially",
	  "prevalent in Harpy Village, no doubt",
	  "because of their great love for sex.",
      "",
      "Living in close quarters in",
      "the village, Harpies have a strong",
      "sense of community. The bond between",
      "sisters is especially strong. It",
      "isn't unheard of for them to share a",
      "sex friend or even a husband. In",
      "either case, the elder sister is",
      "able to assist the less experienced",
      "younger sister. However, in these",
	  "cases the man is exhausted twice as",
	  "fast.",
	  "",
      "Luckily, there is a method handed",
      "down in the Harpy Village that is",
      "able to rejuvenate exhausted men",
	  "through a combination of diet and",
	  "other treatments.",
      "",
      "Artist: frfr",
    ],
    28 => [
      "Reigning over the other Harpies as",
	  "their Queen, her dignity and power",
      "cannot be matched by other Harpies.",
      "Not only does she excel in physical",
      "and magical strength, but also in",
      "her ability to reproduce. Like many",
      "Queens, in order to have as many",
	  "children as possible, her sexual",
	  "organs are specialized to wring out",
	  "a large amount of semen as quickly",
	  "as possible.",
      "",
      "Her specialized vagina has bump-like",
      "projections covering her soft walls.",
      "The stimulation will quickly force",
      "her partner to inseminate her.",
      "Continuous ejaculations aren't rare,",
      "either. Once a man has a taste of",
      "the Queen's vagina, it's likely they",
      "will be made a prisoner of the",
      "pleasure it can bring. When the",
	  "Queen picks a mating partner, it is",
	  "said that the mating will continue",
	  "for three full days. Forcing 100",
	  "ejaculations at a minimum in this",
	  "time, she is able to conceive over a",
	  "dozen children.",
      "",
      "Due to her addled state, the",
      "otherwise formidable queen is only",
      "using half her power. Most Heroes",
	  "normally wouldn't stand a chance",
	  "against her.",
      "",
      "Artist: frfr",
    ],
    29 => [
      "A greater species of Slug Girl that",
      "secretes very acidic mucus and preys",
      "upon humans. She is a very dangerous",
      "monster with a ferocious and cruel",
      "nature fitting for a carnivore.",
      "However it is very rare for one to",
      "appear near human settlements, so",
      "most victims are adventurers who",
      "wander into her territory. In the",
      "few cases where they do appear in",
      "town, they are quietly shopping and",
      "then return home, posing little",
      "danger.",
      "",
      "Prey caught by the High Slug Girl is",
      "enveloped by wrapping her lower body",
      "around them. Digestion begins after",
      "she squeezes the semen out of her",
      "prey by stimulating it with a melty",
      "massage, then inserting his penis",
      "into her mouth. The slug part of her",
      "body works like a digestive organ,",
      "secreting digestive fluid to",
      "dissolve her prey and absorb them",
      "while they're wrapped inside it.",
      "",
      "Artist: UN_DO",
    ],
    30 => [
      "A Slug Girl who worships the Goddess",
      "Ilias and serves as a nun. She has a",
      "calm personality, but is highly",
      "territorial, and will attack those",
      "who carelessly enter her territory.",
      "While she is usually chaste, her",
      "sexual deprivation causes her to",
      "greedily suck up men's semen",
      "whenever she attacks them. In",
      "addition to using her tongue to",
      "slurp semen, she may also use the",
      "opening on her lower body to squeeze",
      "it out. In following the teachings",
      "of Ilias, however, she will almost",
      "never kill men.",
      "",
      "The idea of worshiping Ilias is",
      "normally considered a heresy among",
      "monsters, but because the recovery",
      "magic she uses is useful, other",
      "slugs seem to be accepting of her.",
      "Faith in Ilias within human society",
      "has been in steady decline, while a",
      "reversal phenomena has been taking",
      "place in which monsters, after",
      "entering into human society, become",
      "committed to the teachings of Ilias.",
      "Even among monsters, who consider",
      "these teachings antithetical, the",
      "number of them who believe in Ilias",
      "is on the rise.",
      "",
      "Artist: Irodori",
    ],
    31 => [
      "Three sisters who are considered to",
      "be the leaders of the slugs. Slugs",
      "are generally limited in their",
      "potential and they are not very",
      "powerful individually, but their",
      "combined strength and high",
      "reproductive capability make them a",
      "threat. They see humans as mating",
      "partners and are not hostile towards",
      "them. However, they almost never",
      "leave their habitat in the Slug",
      "Tower, and are always mating at the",
      "\"Tree of Reproduction\" on the top",
      "floor.",
      "",
      "Mating partners are brought to them",
      "by the slugs under their command,",
      "and they intersect by entangling the",
      "man with their three bodies. They",
      "can also drain the man by drawing",
      "out their reproductive organs and",
      "wrapping them around him. Because",
      "this resembles a huge flower, it is",
      "also called the \"Flower of",
      "Reproduction.\" The way this \"flower\"",
      "shines in a rainbow of colors is",
      "very mysterious, and is said to have",
      "been displayed as a gift to the",
      "Monster Lord a long time ago.",
      "",
      "Artist: D_AM",
    ],
    32 => [
      "A fairy monster wearing a pumpkin on",
      "her head. She appears to have carved",
      "the face out herself, and is always",
      "concerned about the workmanship of",
      "her carving. Although she is",
      "incredibly timid, she is also very",
      "curious, and will attempt to touch",
      "humans while staring frightened at",
      "them. Sometimes she will attack in",
      "self-defense, but if she does not",
      "sense any hostility, she won't cause",
      "any harm. On rare occasions, their",
      "curiosity leads them to wander",
      "around villages and towns.",
      "",
      "She is also curious about sex, and",
      "will play around with male genitalia",
      "and even attempt sexual intercourse.",
      "These activities are not life-",
      "threatening and she will usually",
      "release the man soon afterwards.",
      "She is generally friendly to humans",
      "despite being an outwardly spooky",
      "monster.",
      "",
      "Artist: UN_DO",
    ],
    33 => [
      "A meat eating monster that prefers",
      "to live in caves and tropical areas.",
      "An extremely cruel monster, it sees",
      "humans as nothing but food. Even",
      "among other man-eating monsters, it",
	  "is known for its cruelty.",
      "",
      "The Roper Girl uses its countless",
      "tentacles to wrap around her prey,",
      "and pulls them to her sticky body.",
      "Stuck to her body, she secretes",
      "digestive juices over the catch.",
      "To prevent men from struggling, she",
      "will force their penis into her",
      "genitals to calm them with pleasure.",
      "In that way the prey cannot escape",
      "once caught, doomed to be slowly",
      "digested as they are stuck to her",
	  "body.",
	  "",
      "Oddly enough, the Roper Girl does",
      "not feed on semen. She only uses",
      "pleasure to weaken her prey as she",
      "digests them.",
      "",
      "Artist: Setouchi",
    ],
    34 => [
      "An insect-based monster, they are",
      "known to only live in dark caves.",
      "Though their eyesight is poor, their",
	  "hearing and sense of smell are very",
	  "strong.",
      "",
      "They feed on body fluids of other",
      "living beings, but prefer semen.",
      "As soon as a man enters a cave, they",
      "use their hearing to detect where",
      "they are in the cave. Using an",
      "opening in the lower half of their",
      "body that's filled with tentacles,",
      "they can easily force a man to",
      "ejaculate against their will. They",
      "do not release their prey after",
      "feeding once and instead choose to",
	  "continually squeeze out everything",
	  "with their small tentacles.",
      "",
      "In addition to feeding, her lower",
      "opening is used for reproduction.",
      "",
      "Artist: Setouchi",
    ],
    35 => [
      "An undead ghost monster possessing a",
      "worn-out candle. Her body is made of",
      "wax, and it is possible for her to",
      "light up of her own will. Despite",
      "lurking in the gloomy darkness of",
      "locations like caves, she has an",
      "affinity towards humans due to",
      "formerly being a candle and does not",
      "express hostility beyond warding off",
      "intruders. In fact, she tries to",
      "attract sympathy by expressing she",
      "has a short-lived existence, but",
      "since she is an undead monster, this",
      "is actually a lie.",
      "",
      "Because she is an undead monster she",
      "cannot reproduce, but it is",
      "necessary for her to absorb semen in",
      "order to maintain and rebuild her",
      "body, so she captures adventurers",
      "who enter her territory. When she",
      "does, her wax body takes a semi-",
      "viscous form and wraps around the",
      "man's body to squeeze out semen.",
      "This act is accompanied by immense",
      "pleasure, and can lead anyone",
      "regardless of gender to climax",
      "repeatedly. Since they usually",
      "aren't hostile towards humans,",
      "they will usually release their",
      "catch after squeezing out semen",
      "without depriving him of life.",
      "",
      "Artist: Kusakabe",
    ],
    36 => [
      "A mysterious being known as an",
      "Apoptosis, which resides in",
      "Tartarus. They are organisms",
      "resembling monsters, but no one",
      "knows what they are. Moreover, she",
      "appears to instinctively attack",
      "intruders as if programmed into her",
      "mind.",
      "",
      "Eater is an organism with a body",
      "composition similar to an animal's,",
      "but structured like a plant. and has",
      "the ability to devour prey using her",
      "meat flower. The ivy of her lower",
      "body is also extendable, and she",
      "swings it like a whip to attack and",
      "tangle prey to pull them into her",
      "meat flower.",
      "",
      "She has an innocent appearance, but",
      "is also cruel, and seems to",
      "recognize other beings as only",
      "being food. She is a very dangerous",
      "organism, but very little is known",
      "about her.",
      "",
      "Artist: xelvy",
    ],
    37 => [
      "A mysterious being known as an",
      "Apoptosis, which resides in",
      "Tartarus. They are organisms",
      "resembling monsters, but no one",
      "knows what they are. Moreover, she",
      "appears to instinctively attack",
      "intruders as if programmed into her",
      "mind.",
      "",
      "Riot bears characteristics similar to",
      "beast monsters, but because she has",
      "mechanical parts fused all over her",
      "body, it is uncertain whether she is",
      "a natural being at all. Very",
      "prideful and ferocious, she will",
      "stop any intruders with her",
      "overwhelming physical abilities.",
      "",
      "She also has a powerful mating",
      "instinct, and she has many ways",
      "of forcing her prey into her. Her",
      "trained body has an incredibly tight",
      "vagina, and she can force men to",
      "release semen with little effort. It",
      "is unknown, however, what kind of",
      "offspring would be born due to her",
      "mysterious nature.",
      "",
      "Artist: xelvy",
    ],
    38 => [
      "A mysterious being known as an",
      "Apoptosis, which resides in",
      "Tartarus. They are organisms",
      "resembling monsters, but no one",
      "knows what they are. Moreover, she",
      "appears to instinctively attack",
      "intruders as if programmed into her",
      "mind.",
      "",
      "Luxuru has a body fused with a chair-",
      "shaped extracting machine, but she",
      "appears to be an organism with a",
      "will of her own. She retains a human",
      "memory of having been a self-",
      "proclaimed researcher, but it is",
      "uncertain if this is true. Her",
      "emotions also appear to be abnormal,",
      "and she has difficulty understanding",
      "others.",
      "",
      "When she discovers an intruder, she",
      "binds her opponent to her extraction",
      "chair, which gives compulsive",
      "pleasure regardless of gender. In",
      "the case of men, an extracting",
      "instrument is attached to the penis,",
      "which will squeeze out his semen",
      "until his death. The extracted semen",
      "seems to be used as a power source,",
      "but there are still many mysteries",
      "surrounding her ecology and",
      "behavioral principle.",
      "",
      "Artist: Delphinus",
    ],
    39 => [
      "An Elf who has fallen to corruption",
      "is normally labeled a Dark Elf.",
      "Giving into the darkness and",
      "degeneration of mind and spirit,",
	  "their bodies turn black.",
      "",
      "Though able to live as herbivores,",
      "Dark Elves prefer to have sex with",
      "humans and feed on their semen. With",
      "magical power flowing through their",
      "sexual organs, they will violate men",
      "and corrupt them. As soon as the",
      "male ejaculates inside of them, they",
      "will fall into darkness. Once that",
      "happens, the male forgets about",
      "everything but pleasure. Like that,",
      "they will single-mindedly have sex",
	  "with the Dark Elf until they waste",
	  "away.",
      "",
      "Once the Dark Elf is corrupted, they",
      "lose their reproductive ability.",
      "Their only purpose in attacking men",
	  "is to sate their appetite lust.",
      "",
      "Artist: Iwashi no Atama",
    ],
    40 => [
      "An Elf who has fallen to corruption.",
      "She uses her power to summon",
      "tentacles and fuses them with her",
      "own body in order to feed on her",
      "prey.",
      "",
      "When she finds a man she likes, she",
      "will use her summoned tentacles to",
      "wrap around his body and seal his",
      "movement. Like that, she will wrap",
      "her tentacles around his genitals",
      "and suck out his semen, it is not",
      "possible to resist her. The",
      "tentacles secrete a special mucus as",
      "it completely wraps around the",
	  "male's penis, forcing her prey to",
	  "ejaculate many times.",
      "",
      "Once caught, there is no chance to",
      "escape. Her prey's semen will be",
      "sucked until his death.",
      "",
      "Artist: Delphinus",
    ],
    41 => [
      "A generic name for the different",
      "types of fairies all over the world.",
      "Extremely curious and optimistic,",
      "they live a carefree life. They love",
      "being mischievous and playing pranks",
      "to the point of venturing into human",
      "villages to play tricks on them.",
	  "",
      "They're very curious about males,",
      "and love to play with a man's",
      "genitals. The act of ejaculation is",
      "especially amusing to them, so they",
      "are known to use various plants and",
      "their own tiny bodies to force men",
	  "to climax for their amusement. They",
	  "will drink the semen to quench their",
	  "thirst, but the majority of their",
	  "nutrition comes from the various",
	  "nectar and honey found in flowers.",
      "",
      "It's said that many men can't even",
      "see fairies, let alone hear them.",
      "Devout believers in Ilias are said",
      "to be included among those who",
      "cannot see fairies. Due to that,",
      "fairies are assumed to only be",
	  "seen by those with weak faith.",
      "",
      "Artist: Delphinus",
    ],
    42 => [
      "A young girl belonging to the crab",
      "family of monsters. Born separated",
      "from her parents, she lives on the",
      "coast of the peaceful Ilias",
      "Continent. She does not dislike",
      "humans, but if an enemy steps into",
      "her territory, she will attack",
      "without hesitation and play with",
      "them using her bubbles.",
      "",
      "She instinctively dislikes filth,",
      "and will thoroughly wash the body of",
      "the captured opponent regardless of",
      "their gender. The pleasure felt at",
      "this moment is incredible and the",
      "pleasant sensation from washing the",
      "genitals is said to make men climax",
      "many times in succession. She seems",
      "to think her sexual organs are not",
      "ready for reproduction yet, so she",
      "does not engage in mating.",
      "",
      "Once she grows old enough to become",
      "a parent, she will move north across",
      "the sea to live on the Sentora",
      "Continent. There, she will give",
      "birth to her daughters and release",
      "the eggs into the ocean current",
      "leading to the Ilias Continent,",
      "where the growth cycle of the Crab",
      "Girl begins anew.",
      "",
      "Artist: kupala",
    ],
    43 => [
      "A catfish monster which is a",
      "subspecies of the mermaid race. Able",
      "to thrive in saltwater, they can",
      "also live for a very long time.",
      "Although she is relatively mild-",
      "mannered, she will mercilessly",
      "assault anyone who steps into her",
      "territory. In addition to having",
      "the ability to discharge lightning",
      "from her body, she can also sense",
      "the earth with her magical power and",
      "can even cause earthquakes.",
      "",
      "If a man catches her attention, she",
      "will forcibly press down on him with",
      "her mucus-covered lower body and",
      "bring him to mate with her. The",
      "mermaid vagina with its many",
      "peculiar folds is also shared by the",
      "Catfish Girl, and any man inserted",
      "into it will inevitably release",
      "their semen into her while tasting",
      "sweet pleasure.",
      "",
      "Although she is a mermaid, she is",
      "not a good swimmer and usually lives",
      "on the seafloor, though there are",
      "times when they feel like coming up",
      "to the beaches. In many ways, their",
      "lifestyle differs from the typical",
      "mermaid.",
      "",
      "Artist: Uminoyama",
    ],
    44 => [
      "A plant-type monster that lives",
      "primarily in tropical forests.",
      "Though it appears to have two",
      "separate bodies, it is in fact a",
	  "single being. She is able to provide",
	  "her own food via photosynthesis, but",
	  "requires men to breed.",
      "",
      "To assist with this, the Rafflesia",
      "Girl has a special aroma she can",
      "discharge to put her partner in a",
      "trance. In this state, she can force",
      "him into her flower before he is",
      "able to run away. First, she will",
      "use her stamen to spread pollen over",
      "the man. Next, she will use her",
	  "pistil to force him to ejaculate. As",
	  "soon as her pistil is covered in",
	  "semen, she will be fertilized.",
      "",
      "In most cases, she releases the man",
      "after being pollinated. However, if",
      "they determine that their catch is",
      "of exceptionally high quality, they",
	  "are known to keep the man as a",
	  "reproductive slave.",
      "",
      "Artist: Setouchi",
    ],
    45 => [
      "A low-level Centaur monster with the",
      "lower body of a horse. With her",
      "excellent leg strength, she is proud",
      "to be one of the fastest monster",
      "species. Even among Centaurs this",
      "one is exceptionally prideful, and",
      "will not attack humans unless she",
      "wants to challenge a skilled",
      "adventurer. In such a case, she will",
      "draw her spear and show off her",
      "fighting abilities, which take",
      "advantage of her speed.",
      "",
      "During her mating period however,",
      "she will indiscriminately attack",
      "men. The vagina located in her horse",
      "body provides incredible tightening",
      "thanks to her lower body strength.",
      "If raped by a Centaur, she will",
      "force the man to inseminate her",
      "under the weight of her horse body",
      "until his breathing goes faint.",
      "",
      "Artist: SugaMon",
    ],
    46 => [
      "A foxy variant of the Beast type,",
      "Kitsune are known to have the",
      "highest potential magical power",
      "among animal-type monsters. That",
      "cannot be said for this particular",
	  "two-tailed monster, who tries to",
	  "cover her mediocrity at Taoism with",
	  "her resourcefulness in Ninjutsu.",
      "",
      "Fascinated by male genitals, they",
      "will use any chance they can take to",
      "play with them with either their",
      "hands or tails. When played with by",
      "their soft tails, most men are",
      "unable to resist giving into the",
      "Kitsune. Furthermore, her vagina is",
      "many times more pleasurable than a",
	  "human female's. Able to skillfully",
	  "control every muscle inside of them,",
	  "they can adjust the tightness to",
	  "whichever level they wish.",
      "",
      "Artist: Jingai Modoki",
    ],
    47 => [
      "A foxy variant of the Beast type,",
      "Kitsune are known to have the",
      "highest potential magical power",
      "among animal-type monsters. This one",
      "has a more serious personality than",
      "the silver kitsune and although she",
      "is enthusiastic about training, she",
      "often experiences failure due to her",
      "stubbornness. Thus, she admires the",
      "silver kitsune for her free-spirited",
      "and flexible lifestyle, and respects",
      "her as her senior. Her skill at",
      "Taoism surpasses that of her senior,",
      "and she shows great promise as an",
      "aspiring Taoist.",
      "",
      "She is also keen on practicing",
      "sexcraft, and appears to be learning",
      "various techniques at the fox",
      "village. Her knowledge bias is",
      "undeniable however, and due to her",
      "lack of flexibility, she has no",
      "confidence at all.",
      "",
      "Artist: Jingai Modoki",
    ],
    48 => [
      "An insect-based monster from the",
      "spider family. Primarily living in",
      "caves, they create giant webs to",
      "catch prey. An exceptionally cruel",
      "predator, they eat man and monster",
	  "alike.",
      "",
      "Though they are carnivorous, they",
      "treat semen as a rare treat. Once",
      "they catch a man, they will wrap",
      "them up in their webbing to seal off",
      "their movement. After that, they use",
      "their spinneret to squeeze out semen",
      "from their catch. Due to the complex",
      "nature of their spinneret, they are",
      "able to use both their muscles and",
      "the webbing itself to force the man",
      "to continually ejaculate.",
	  "",
      "After sucking out all of the man's",
      "semen, the Spider Girl will use",
      "external digestion to eat them.",
	  "After creating a cocoon with the man",
	  "inside, she injects her digestive",
	  "juices directly into them by biting",
	  "their neck. Like that, the man will",
	  "slowly be digested from inside his",
	  "own body as the Spider Girl sucks up",
	  "the melted meat. It's said that her",
	  "juices are designed to bring insane",
	  "levels of pleasure to her prey to",
	  "prevent them from struggling while",
	  "being eaten.",
      "",
      "Artist: UN_DO",
    ],
    49 => [
      "A monster that hides in a treasure",
      "chest, it appears to be a part of",
      "the Ghost family. Their body is",
      "composed of the chest and their",
      "digestive juices contained inside.",
      "When an adventurer opens the chest,",
	  "the Mimic will drag them inside and",
	  "slam the lid shut, bathing them in",
	  "digestive juices.",
      "",
      "A very timid monster, it spends",
      "almost its entire life shut inside",
      "the box but once she catches her",
      "prey, her attitude completely",
      "changes as she enjoys dominating",
      "them. Dragging her prey inside of",
      "her, she enjoys watching their",
      "despair as they are slowly eaten.",
      "Moreover, Mimics will be sure to",
      "cover the male's genitals with her",
      "digestive juices first, cruelly",
      "watching their reactions. A man",
	  "captured by a Mimic can only look",
	  "forward to a disgraceful, miserable",
	  "death.",
      "",
      "There have been cases where the",
      "Mimic really enjoys the reactions of",
      "her catch and chooses to instead",
	  "torment them for the rest of their",
	  "life, or until they become bored.",
	  "When this occurs, they will then eat",
	  "their prey.",
      "",
      "Artist: Setouchi",
    ],
    50 => [
      "A senior member of the Kitsune race",
      "and fiercely loyal to its Queen,",
      "Tamamo.",
      "",
      "Though she can eat anything, she",
      "prefers semen above anything else.",
      "Using all seven of her tails, she",
      "holds down the male as she forces",
      "him to ejaculate. In addition, she",
      "is able to turn her tails into",
      "semen-sucking tentacles, sucking in",
      "the male's penis and using them to",
	  "milk the man.",
      "",
      "Though she normally just feeds, if",
      "she finds a male she likes, she will",
      "make him her mating partner. Using",
      "her amazing vagina, she will force",
      "the male to mate with her",
      "continually until she conceives.",
      "",
      "Artist: Setouchi",
    ],
    51 => [
      "The youngest of the three Lilith",
      "Sisters, who serve the legendary",
      "Great Whore of Babylon. She wields",
      "magical power that is beyond the",
      "compare of monsters in this world,",
      "but its nature is unknown. She is",
      "powerful enough to drain men into",
      "dried fish, but refrains from",
      "actively doing so for some reason.",
      "",
      "Her intentions are unknown, and it",
      "is uncertain why she even appeared",
      "in this world. The only thing that",
      "is certain is that her presence is",
      "affecting the world from behind the",
      "scenes.",
      "",
      "Artist: Shiki",
    ],
    52 => [
      "An extremely greedy monster, they",
      "infest the shorelines. They feed",
      "mainly on semen. When they find a",
      "healthy male, they attack and suck",
      "his body into her mouth. Looking",
      "like a huge female genital, she is",
      "able to control every muscle inside",
      "of her to force the man to climax.",
      "Able to shrink her inner wall, the",
      "Sea Cucumber Girl is able to give an",
      "amazingly pleasurable squeezing",
      "stimulation. Like that, she can",
      "force her catch to ejaculate until",
      "they are sucked dry. Greedily",
	  "sucking up everything, she is a very",
	  "dangerous monster.",
      "",
      "Unable to differentiate between",
      "feeding and reproduction, the semen",
      "she squeezes is used for conceiving",
      "children. In addition, there have",
      "been cases of Sea Cucumbers",
	  "attacking human females and other",
	  "monsters. Holding them in their",
	  "mouth, she will squeeze out all of",
	  "their bodily fluids.",
      "",
      "Artist: Setouchi",
    ],
    53 => [
      "An aquatic monster that often",
      "infests beaches. Able to catch men",
      "off guard by her human female form,",
      "she catches men in her shell and",
      "squeezes out their semen. Since they",
      "do not generally eat too much, the",
      "Shellfish Girl doesn't kill her",
      "catch by sucking out too much. For",
      "love very quickly, claiming that",
      "they have met their soul mate. Once",
      "they fall in love, they will confine",
      "him in her shell and forcibly mate.",
      "They mate by wrapping the man's",
      "penis directly in her fallopian",
      "tube. Unfortunately for the male,",
      "once the mating finishes, he and the",
      "sea-dweller are bound for life.",
      "They will live out the rest of their",
      "lives together as a married couple.",
      "Though the Shellfish Girl doesn't",
      "intend harm, they are a rather",
      "troublesome monster.",
      "",
      "In addition, Shellfish Girls are",
      "usually friends with Sea Cucumber",
      "Girls. It isn't unusual to see them",
      "play together around Port Natalia.",
      "",
      "Artist: Setouchi",
    ],
    54 => [
      "An aquatic-based monster often found",
      "near beaches. Protected by her",
      "powerful shell, she uses her claws",
      "to hold down her prey. An extreme",
      "neat freak, she has a fanatical",
      "obsession with keeping her catch",
      "clean. Therefore, after catching a",
      "man, she will carefully clean him.",
      "Carefully scrubbing and cleaning the",
      "man's genitals, it's said that the",
      "pleasure is addictive. After each",
      "ejaculation, the Crab Girl starts",
      "the washing process all over again,",
      "causing an almost endless loop. In",
      "addition, the semen that covers her",
      "hands is used for food. Moreover,",
      "if her catch is of high quality,",
      "it's said that she will mate after",
	  "after the cleaning is done. Even",
	  "through the washing brings the male",
	  "close to death, the Crab Girl will",
	  "release her catch.",
	  "",
	  "She is known to be extremely",
	  "vengeful if made into an enemy.",
      "",
      "Artist: Setouchi",
    ],
    55 => [
      "A low-class, carnivorous slime. An",
      "extremely self-centered monster",
      "among slimes, she believes that",
      "other creatures exist only for her",
	  "own simple-minded enjoyment.",
      "",
      "Though she can easily survive on any",
      "sort of meat, she finds devouring",
      "humans to be the most fun. Covering",
      "her prey with her entire body, the",
	  "digesting slime paralyzes them with",
	  "extreme pleasure as she preys on",
	  "them.",
      "",
      "Artist: frfr",
    ],
    56 => [
      "A type of Alraune monster shaped",
      "like a watermelon. The huge",
      "watermelon appears to be part of",
      "her body. It gives off a sweet",
      "scent that makes her enemies fall",
      "asleep, and she is able to attack",
      "using the mouth of the watermelon.",
      "",
      "She is quite gentle not unlike most",
      "alraunes, and will not harm the",
      "weak. Strangely, she will also",
      "encourage you to eat watermelons,",
      "but this does not appear to be a",
      "trick; it seems that she just wants",
      "you to like watermelons.",
      "",
      "Her best nourishment comes from",
      "the collection of semen, which she",
      "squeezes out of men by holding onto",
      "their lower body with the mouth of",
      "her watermelon. The fruit's",
      "interior is similar to a female",
      "vagina, and is able to provide",
      "superior stimulation to male",
      "genitals. After sucking up semen",
      "several times, she will release the",
      "man without causing further harm.",
      "Sometimes she will give you",
      "watermelons as souvenirs.",
      "",
      "Artist: Kusakabe",
    ],
    57 => [
      "A carnivorous plant monster of the",
      "Alraune family with the",
      "characteristics of a pitcher plant.",
      "Her vase-like leaves are filled with",
      "digestive juices, and consume prey",
      "that fall into them after a long",
      "time. She usually feasts upon large",
      "wild mammals, but her favorite meal",
      "seems to be humans.",
      "",
      "Although she looks and speaks in a",
      "friendly manner, she is an extremely",
      "dangerous monster who preys upon",
      "humans. She winds up her prey with",
      "vines and draws them into her",
      "pitcher. Once immersed inside the",
      "pitcher, the person will be affected",
      "by a sweet ecstasy and lose their",
      "will to resist. After that, they",
      "will be melted into nutrients for",
      "the pitcher until only bone remains.",
      "If her prey is a man, the pleasant",
      "sensation will cause him to",
      "repeatedly ejaculate, providing her",
      "semen for additional nourishment.",
      "",
      "Artist: Neko Manma",
    ],
    58 => [
      "A very famous monster with the lower",
      "body of a snake. There are varying",
      "power gaps across this race's many",
	  "offshoots. Even so, older Lamias are",
	  "assumed to have extremely powerful",
	  "magic.",
      "",
      "This particular Lamia has average",
      "power, but is extremely cruel. She",
      "enjoys coiling around her catch and",
      "hurting them. After weakening a man",
      "enough she enjoys swallowing them",
      "whole. If she finds a high-quality",
      "male, it's possible that she will",
      "mate with them before eating. Like",
      "other Lamias, she has complete",
      "control over the muscles inside her",
      "vagina, allowing her to adjust the",
      "tightness to force men to ejaculate",
	  "when she chooses. This is a very",
	  "dangerous monster to run into as a",
	  "man.",
      "",
      "There have been instances of Lamias",
      "falling in love with men. Once they",
      "fall in love, they are extremely",
      "relentless in making the man hers.",
      "It's said that they get so jealous",
	  "that they will stay coiled around",
	  "the man for the rest of his life,",
	  "never allowing him to escape.",
      "",
      "Artist: frfr",
    ],
    59 => [
      "A seaweed monster that is a",
      "subspecies of the Alraune family.",
      "She usually sways while clinging to",
      "rocks in the sea, but sometimes she",
      "comes up to the sandy beach. Her",
      "exterior is covered in slimy mucus,",
      "and it is possible for her to",
      "stretch her seaweed like a tentacle",
      "to bind prey. She has a relaxed",
      "personality and loves to dance. When",
      "rocked by the waves, she appears to",
      "be dancing as her swaying figure is",
      "witnessed.",
      "",
      "When she sees humans she will",
      "entangle them, but she is not",
      "hostile. If her catch is a man, she",
      "will stretch her seaweed to wind it",
      "around his penis, caressing it until",
      "he ejaculates, and soaking up his",
      "semen. She will usually be satisfied",
      "with several ejaculations and then",
      "release him, so there is very little",
      "chance of a life-threatening",
      "situation. Most of the time, she is",
      "just a quiet and harmless monster.",
      "",
      "Artist: Kusakabe",
    ],
    60 => [
      "An aquatic monster that lives in the",
      "sea. The Jellyfish Girl usually",
      "feeds by grabbing men off of boats",
      "with her tentacle. She will also",
      "capture men who have fallen into the",
      "sea. Her venomous tentacles are able",
      "to paralyze her prey, sealing their",
      "movements as they are eaten.",
	  "",
      "Though she is able to feed by using",
      "her elastic tentacles, the Jellyfish",
      "Girl is also known to force her prey",
      "into her umbrella. Once her prey is",
      "inside her umbrella, she will",
      "squeeze his entire body and force",
      "them to ejaculate. After ensuring",
      "she has squeezed out all of his",
	  "semen, she will then eat the man.",
	  "With her stomach located in her",
	  "umbrella, she is able to digest him",
	  "as is.",
      "",
      "Her digestive juices have extremely",
      "powerful aphrodisiac effects. She",
      "uses her juices to ensure that her",
      "prey doesn't struggle while inside",
	  "her soft body.",
      "",
      "Artist: Setouchi",
    ],
    61 => [
      "An aquatic monster that lives on the",
      "bottom of the sea. Like the",
      "Jellyfish Girl, she uses her",
      "tentacles to catch men off of boats",
      "and beaches, drawing them to her.",
      "Unlike the Jellyfish Girl, she uses",
      "her tentacles to hurt and torture",
      "her prey to weaken them, instead of",
	  "pleasuring them. Once weakened, she",
	  "uses her tentacles to force him to",
	  "ejaculate continuously so she can",
	  "feed on his semen.",
      "",
      "After humiliating her prey, she will",
      "draw him into her. Once inside, she",
      "will start to digest him at the same",
      "time she squeezes the rest of his",
      "semen out. Extremely cruel and",
      "almost impossible to escape from",
      "once caught. Luckily, they are few",
      "in number.",
      "",
      "Artist: Setouchi",
    ],
    62 => [
      "A large fish monster, she is a",
      "distant cousin of the Mermaid race.",
      "However, since she lives in the deep",
      "sea her face and behavior are much",
      "different. Unable to see due to",
      "living in the darkness of the deep",
      "sea, she uses temperature to detect",
      "her prey. Her abdomen has a mouth",
      "that is not seen in other monsters.",
      "As if a digestive organ, her flesh",
      "is able to suck in and assimilate",
      "her prey. Once her prey gets stuck",
      "in her flesh, they are slowly",
      "dragged into the Anglerfish Girl's",
      "body. Even after being assimilated,",
	  "it appears as though the man's",
	  "consciousness remains. Like that,",
	  "the man will remain aware of being",
	  "one with the Anglerfish Girl, but",
	  "unable to speak or do anything.",
      "",
      "Her digestive organ is able to bring",
      "extreme pleasure to the man as it",
      "fuses him with her. Like that, when",
      "her catch is a man, she can obtain",
	  "additional food.",
      "",
      "Artist: Setouchi",
    ],
    63 => [
      "A mermaid who originally lived",
      "peacefully at Port Natalia, but was",
      "brainwashed by Astaroth to believe",
      "she was the Queen of the Southern",
      "Seas. Although her magical power is",
      "considerable for a mermaid, it is",
      "still far from the power wielded by",
      "the Queen of the Southern Seas.",
      "Because her misdeeds were rather",
      "small, the damage did not spread",
      "far. She went as far as kidnapping",
      "most of the people in town, but it",
      "seems that everyone is safely",
      "protected now.",
      "",
      "She was originally a very sincere",
      "mermaid, and deeply fond of human",
      "society. She dreams of one day",
      "meeting an ideal husband and",
      "marrying him to live a quiet life.",
      "",
      "Artist: Iwashi no Atama",
    ],
    64 => [
      "A very unusual monster that lives in",
      "a book. As soon as a man opens the",
      "book she's hiding in, she will pop",
      "out and attack them. If defeated by",
      "her, she will draw the man into her",
      "book and continually violate them.",
      "Since these types of monsters have",
      "very few chances to catch prey, they",
      "will draw them into their universe",
      "and squeeze semen from them for the",
      "rest of their lives. Since the flow",
      "of time inside their universe is",
	  "different, it will feel like around",
	  "1,000 years for a human. Once the",
	  "life of her prey is exhausted, she",
	  "will wait for the next catch.",
      "",
      "Her strange name comes from the page",
      "number in the book she's possessing.",
      "Since they don't usually come in",
      "contact with other monsters, it",
	  "holds no special meaning.",
      "",
      "Artist: Setouchi",
    ],
    65 => [
      "A monster that lurks in books. Since",
      "these types rarely come in contact",
      "with humans, it's not rare to find",
      "one that has never seen a human male",
      "before. This particular monster has",
      "never had contact with a man, and",
      "only has information on them she has",
      "gleaned from books. Therefore, she",
      "is very curious to find out more. If",
      "caught by her, it's likely the man",
      "will be played and experimented on",
	  "until she's satisfied. Since she",
	  "enjoys the taste of semen, it's easy",
	  "to believe the experiments would",
	  "continue until the man's death.",
      "",
      "It seems as though she has been",
      "waiting for a catch ever since being",
      "born. When not moving from the book,",
	  "she's able to go around 100 years",
	  "before dying of hunger.",
      "",
      "Artist: Setouchi",
    ],
    66 => [
      "A Queen-like monster that possesses",
      "a book. Having possessed many books",
      "up until now, her name is derived",
      "from how many different pages she",
      "has possessed. Boasting very",
      "powerful magic, any man who opens",
      "the book she is in will be quickly",
      "dragged into her world. Dragging",
      "them into her body, she is able to",
      "force any man to ejaculate. Any man",
      "caught by her will be forced to",
	  "continuously ejaculate until nothing",
	  "is left. Unusual among other",
	  "monsters that possess books, she",
	  "prefers to quickly squeeze her",
	  "catches to death instead of keeping",
	  "them alive.",
      "",
      "In addition, it is extremely",
      "difficult to seal her. It appears as",
      "though someone created her with this",
      "particular characteristic, but the",
      "details are not known. It appears as",
      "though Page 65537 is on a quest to",
      "learn more about the meaning and",
	  "purpose of her existence.",
      "",
      "Artist: Setouchi",
    ],
    67 => [
      "An extremely rare monster that is",
      "a pious believer of Ilias, despite",
      "her teachings against monsters.",
      "Following the Great Disaster,",
      "contact between humans and",
      "monsters had increased, and thus",
      "the teachings of Ilias have begun",
      "to flow into monsters.",
      "Although they are few, the number of",
      "monsters that devote themselves to",
      "the teachings of Ilias has begun to",
      "increase. Meanwhile, there has been",
      "a reversal phenomenon of the faith",
      "in Ilias among humans, which has",
      "been shrinking.",
      "",
      "Although she follows the teachings",
      "of the goddess Ilias, she cannot",
      "suppress her instincts as a Lamia",
      "and sometimes attacks travelers out",
      "of frustration. If she wraps around",
      "you with her tough snake body, she",
      "will not let go until you pass out.",
      "While gently hugging her prey, she",
      "will also force them to mate with",
      "her, mercilessly squeezing their",
      "semen as she brings them closer to",
      "ascension.",
      "",
      "Artist: frfr",
    ],
    68 => [
      "An extremely rare succubus who is",
      "devoted to the teachings of the",
      "goddess Ilias. While she is lewd at",
      "heart, she eagerly spreads the",
      "teachings of Ilias. Many weaker",
      "monsters have grown weary of survival",
      "of the fittest, and the number of",
      "monsters drawn to the teachings of",
      "equality by Ilias are increasing.",
      "",
      "The instincts of a succubus are",
      "difficult to suppress however, and",
      "her repressed urges sometimes",
      "overflow all at once. A man who",
      "becomes her prey at such a time will",
      "be mercilessly raped to such a",
      "degree that even their life will be",
      "endangered. She is an ironic",
      "succubus whose strong faith is what",
      "makes her so dangerous.",
      "",
      "Artist: Neko Manma",
    ],
    69 => [
      "A beast-type monster with the",
      "characteristics of an anteater.",
      "She is armed with sharp claws and a",
      "long tongue which is extendable.",
      "Wielding it like a whip, she can",
      "wrap her tongue around her prey to",
      "bind them. She is not very fierce,",
      "and emphasizes speed over power.",
      "Most Anteater Girls are not hostile,",
      "and many are wearing clothes.",
      "",
      "Their diet mainly consists of small",
      "animals and they never consume human",
      "flesh. However, semen is their",
      "favorite food, and whenever one",
      "catches a man, she will wrap her",
      "tongue around his penis and lick up",
      "the semen he releases. The feel of",
      "her tongue is amazing and if you",
      "become the prey of an Anteater Girl,",
      "you will be forced to ejaculate",
      "until you can't stand on your legs.",
      "",
      "Artist: Setouchi",
    ],
    70 => [
      "A beast-type monster with the",
      "characteristics of a grizzly.",
      "She has a violent temper, and uses",
      "her sharp fangs and claws as weapons",
      "to attack prey. Although she is a",
      "top predator who is frightening",
      "enough to scare away the surrounding",
      "monsters, she is quite docile when",
      "she isn't hungry.",
      "",
      "During her mating period, she will",
      "attack a man and push him down to",
      "forcibly violate him. Her wild",
      "mating will cause the man to",
      "repeatedly ejaculate semen into her",
      "womb. The man being raped by her",
      "will not be released, and will be",
      "made responsible for rearing the",
      "newborn child.",
      "",
      "Artist: SugaMon",
    ],
    71 => [
      "A Chimeric Monster created in a",
      "laboratory somewhere. A fusion",
      "of monster and angel, the primary",
      "focus of her creation was on the",
      "use of mechanical organs. Although",
      "she was beneficial for improving",
      "basic technology, she wasn't",
      "particularly powerful. She",
      "currently resides in the temple",
      "ruins, but the reason for this is",
      "unknown.",
      "",
      "Due to her multiple mechanical",
      "organs, she is able to squeeze",
      "multiple prey dry very quickly. This",
      "technique of being able to process",
      "multiple men at once was put to use",
      "in later research and development.",
      "",
      "Artist: Setouchi",
    ],
    72 => [
      "A Chimeric Monster created in a",
      "laboratory somewhere. She appears to",
      "have been created to test the",
      "breeding potential of Insect",
      "monsters and was made using the",
      "cells of Beelzebub, which are said",
      "to have been extinct since ancient",
      "times. As a result, she has a high",
      "reproductive ability and is capable",
      "of explosive growth in a short",
      "period of time. Her small body also",
      "helps reduce the calories she",
      "expends. She currently resides in",
      "the temple ruins, but the reason for",
      "this is unknown.",
      "",
      "If she spots a man, she will attack",
      "and attempt to mate with him by",
      "force. Although her body is small,",
      "her reproductive organs were",
      "designed so she can suck the penis",
      "from its base and pump up semen from",
      "the source for breeding. Even though",
      "the Little Bug is not malicious, the",
      "man who was forced to mate with her",
      "often dies from weakness. She is an",
      "innocuous, yet dangerous monster.",
      "",
      "Artist: xelvy",
    ],
    73 => [
      "A Chimeric Monster created in a",
      "laboratory somewhere. She appears",
      "to be a prototype model for all",
      "mechanical monsters because the",
      "proportion of machines making up her",
      "body is very high.",
      "",
      "An artificial stomach is attached to",
      "her abdomen, which has the ability",
      "to digest and absorb any opponent",
      "swallowed by its mouth. People",
      "captured this way are preyed upon",
      "and disposed of without mercy.",
      "",
      "Although she is infertile, her",
      "combat abilities are high. There",
      "appear to be a few of them",
      "wandering around the ruins, but it",
      "is completely unknown who created",
      "them.",
      "",
      "Artist: Silk",
    ],
    74 => [
      "A mysterious humanoid machine that",
      "had been preserved in the depths of",
      "the underground ruins. Most of her",
      "body is mechanical and she uses an",
      "unidentifiable power. She boasts",
      "very high combat abilities, and in",
      "addition to the mechanical weapons",
      "her entire body is equipped with,",
      "she appears to have mastery over an",
      "unknown phenomenon known as",
      "\"Chaos.\"",
      "",
      "While she is a machine, she has a",
      "will of her own and is pure and",
      "innocent, trying to learn many",
      "things. There are many unknown",
      "factors regarding her, such as who",
      "created her and for what purpose,",
      "shrouding her existence in mystery.",
      "",
      "Artist: xelvy",
    ],
    75 => [
      "A collection of human souls that was",
      "infused with magic. It prefers dark,",
      "damp places and avoids sunlight at",
      "all costs. Although her face",
      "resembles the face of one of the",
      "souls, she has no memory of any",
	  "previous life. Desiring nothing but",
	  "the energy of living beings, it's",
	  "difficult for her to communicate.",
      "",
      "She needs male energy to maintain",
      "her form, so she will go to any",
      "length to get it. Her vagina has",
      "been changed to be as close to",
      "perfection as possible, as her",
      "continued existence depends on",
	  "forcing the man to ejaculate. Unable",
      "to control herself once catching a",
	  "man, she will continue squeezing",
	  "him until his death.",
	  "",
      "Artist: Setouchi",
    ],
    76 => [
      "When the soul of the previous owner",
      "of this worn-out doll combined with",
      "magic after her death, she was",
      "forced to possess the doll and",
      "became a monster. Because of that,",
      "she can technically be classified as",
	  "an undead type despite being a Doll.",
	  "Though the memory from her human",
	  "life has vanished, she retained her",
	  "innocent, playful demeanor.",
      "",
      "Like most undead types, she requires",
      "male energy to maintain her life. In",
      "addition to using her genitals to",
      "suck out energy, the Cursed Doll is",
      "able to use her magical hair to wrap",
      "around the man's penis and directly",
      "suck out his energy. Like this, it's",
      "said that she can steal the very",
      "soul of the man. Due to her innocent",
      "and playful behavior, she gets so",
      "caught up in the act that she",
      "doesn't realize that her excessive",
	  "playing is killing the man. An",
	  "extremely dangerous monster, not to",
	  "be underestimated by her young",
	  "appearance.",
	  "",
      "Artist: UN_DO",
    ],
    77 => [
      "An undead monster 'born' from magic",
      "fusing into a corpse. Due to the",
      "brain rotting away, the Zombie Girl",
      "has almost no intellect, and barely",
      "any memory of her previous life.",
      "Cold and craving warmth, they",
      "desperately attack and rape men",
      "trying to claim the faint memories",
      "of their old bodies. Though they are",
      "very slow, their stamina is very",
      "high. Once they mount a man, it's",
      "not possible to get them off no",
	  "matter how much you attack them. The",
      "strange feeling of her rotting",
      "genitals is able to force men to",
      "ejaculate.",
	  "",
      "Since the Zombie Girl will never",
	  "reclaim what she has lost, she will",
	  "continue raping the man until he",
	  "dies. In some rare cases, the magic",
	  "sustaining the Zombie Girl will flow",
	  "into the man and turn him into a",
	  "Zombie. Like that, he will be raped",
	  "for an eternity.",
      "",
      "Artist: UN_DO",
    ],
    78 => [
      "Since Zombie Girls have no",
      "intelligence, they have no sense of",
      "companionship, not even recognizing",
      "other Zombie Girls. The only",
      "exception to this is when they",
      "attack a man in a group. Once they",
      "defeat him, they will take turns",
      "raping him. Whichever Zombie Girl is",
      "strongest will go first as the rest",
      "of them lick and bite at him. It's",
      "said that as soon as a man's semen",
      "touches a Zombie Girl, they will",
      "momentarily weaken as they",
      "experience the faint warmth. As soon",
      "as they weaken, the next Zombie Girl",
	  "will take the chance to force her",
	  "off the man so that she can take",
	  "over the rape. This pattern will",
	  "continue endlessly.",
      "",
      "In addition, the specially created",
      "Zombie Girls in the Haunted Mansion",
      "have no infectious diseases or",
      "hygiene issues due to the care of",
	  "their creator.",
      "",
      "Artist: UN_DO",
    ],
    79 => [
      "Since Zombie Girls have no",
      "intelligence, they have no sense of",
      "companionship, not even recognizing",
      "other Zombie Girls. The only",
      "exception to this is when they",
      "attack a man in a group. Once they",
      "defeat him, they will take turns",
      "raping him. Whichever Zombie Girl is",
      "strongest will go first as the rest",
      "of them lick and bite at him. It's",
      "said that as soon as a man's semen",
      "touches a Zombie Girl, they will",
      "momentarily weaken as they",
      "experience the faint warmth. As soon",
      "as they weaken, the next Zombie Girl",
	  "will take the chance to force her",
	  "off the man so that she can take",
	  "over the rape. This pattern will",
	  "continue endlessly.",
      "",
      "In addition, the specially created",
      "Zombie Girls in the Haunted Mansion",
      "have no infectious diseases or",
      "hygiene issues due to the care of",
	  "their creator.",
      "",
      "Artist: UN_DO",
    ],
    80 => [
      "Since Zombie Girls have no",
      "intelligence, they have no sense of",
      "companionship, not even recognizing",
      "other Zombie Girls. The only",
      "exception to this is when they",
      "attack a man in a group. Once they",
      "defeat him, they will take turns",
      "raping him. Whichever Zombie Girl is",
      "strongest will go first as the rest",
      "of them lick and bite at him. It's",
      "said that as soon as a man's semen",
      "touches a Zombie Girl, they will",
      "momentarily weaken as they",
      "experience the faint warmth. As soon",
      "as they weaken, the next Zombie Girl",
	  "will take the chance to force her",
	  "off the man so that she can take",
	  "over the rape. This pattern will",
	  "continue endlessly.",
      "",
      "In addition, the specially created",
      "Zombie Girls in the Haunted Mansion",
      "have no infectious diseases or",
      "hygiene issues due to the care of",
	  "their creator.",
      "",
      "Artist: UN_DO",
    ],
    81 => [
      "Since Zombie Girls have no",
      "intelligence, they have no sense of",
      "companionship, not even recognizing",
      "other Zombie Girls. The only",
      "exception to this is when they",
      "attack a man in a group. Once they",
      "defeat him, they will take turns",
      "raping him. Whichever Zombie Girl is",
      "strongest will go first as the rest",
      "of them lick and bite at him. It's",
      "said that as soon as a man's semen",
      "touches a Zombie Girl, they will",
      "momentarily weaken as they",
      "experience the faint warmth. As soon",
      "as they weaken, the next Zombie Girl",
	  "will take the chance to force her",
	  "off the man so that she can take",
	  "over the rape. This pattern will",
	  "continue endlessly.",
      "",
      "In addition, the specially created",
      "Zombie Girls in the Haunted Mansion",
      "have no infectious diseases or",
      "hygiene issues due to the care of",
	  "their creator.",
      "",
      "Artist: UN_DO",
    ],
    82 => [
      "The ultimate zombie of the",
      "necromancer Chrome. With her core",
      "body based off a human named",
      "Frederica, Chrome used multiple",
      "parts of other corpses to improve",
      "her body. Because of all the",
	  "additions, her body became almost",
      "that of a giant. She has incredible",
      "physical power, and enough",
      "intelligence to follow any order",
      "Chrome gives her. Though Chrome",
      "takes great pride in Frederica, she",
      "still wishes to improve her even",
      "more.",
	  "",
      "Taking great pains to improve",
      "Frederica, Chrome meticulously",
      "constructed her vagina to near",
      "perfection. Any man forced into her",
      "will be forced to ejaculate",
	  "continuously. Under Chrome's orders,",
	  "it's believed the amount of men",
	  "raped to death by Frederica is quite",
	  "high.",
	  "",
      "Chrome had nothing to do with",
      "Frederica's natural death.",
      "Frederica's natural affinity for",
	  "magic caused her to be susceptible",
	  "to a deadly disease, which brought",
	  "her death.",
      "",
      "Artist: UN_DO",
    ],
    83 => [
      "A monster with top-notch necromantic",
      "abilities. Chrome is a type of",
      "succubus, but due to her focus on",
      "necromancy, her powers of seduction",
      "are at an Imp's level. She's",
      "obsessed with satisfying her",
      "curiosity and is going to extreme",
      "lengths to create the perfect",
      "zombie. Chrome believes that",
      "Frederica, her ultimate creation,",
      "still holds room for improvement.",
	  "Her minuscule sex skills may not get",
	  "her far in battle, but her ability",
	  "to summon zombies is very dangerous.",
	  "Even a skilled adventurer can",
	  "quickly be overwhelmed by the",
	  "zombies she summons.",
      "",
      "Artist: UN_DO",
    ],
    84 => [
      "The Guardians of the Forest, Elves",
      "are Demi-Human offshoots that live",
      "in the woods. They like to take the",
      "role of parent for the innocent",
      "fairies. Due to their role of",
      "defending the forests, skirmishes",
      "between Elves and humans are common.",
      "That being said, their actions are",
      "purely defensive and only attack",
      "human trespassers; they never attack",
      "a human settlement unprovoked.",
	  "",
      "To punish the trespassers, they will",
      "rape and discipline them. Though",
	  "they use the pretext of punishment,",
	  "in most cases it's done for their",
	  "own pleasure and enjoyment, or even",
	  "for reproduction.",
      "",
      "Primarily vegetarians, they normally",
      "don't eat semen. If they develop a",
      "taste for semen, it begins to affect",
      "both their mind and body. This",
      "process is called [Degeneration],",
      "and will slowly corrupt the Elf into",
	  "a new type called a [Dark Elf].",
      "",
      "Artist: Iwashi no Atama",
    ],
    85 => [
      "Sisters of the Fairy race who live",
      "in the Forest of Spirits. They are",
      "known as earth spirits, which are",
      "different from a typical wind",
      "spirit in how they are strong and",
      "dexterous despite being small.",
      "Their magical power appears to be",
      "weaker compared to the wind spirits,",
      "however. They are generally",
      "favorable towards humans, and there",
      "are even folk legends about them",
      "helping human blacksmiths.",
      "",
      "However, they are hostile towards",
      "those who intrude upon the Forest of",
      "Spirits, and will aggressively",
      "attack them. Once overwhelmed by",
      "their strength, they will be made",
      "into their toys. They will play",
      "around with a man's penis out of",
      "curiosity until they see him",
      "ejaculate. Although they will not",
      "take your life, vigilance is",
      "necessary as their mischief can be",
      "exhausting.",
      "",
      "Artist: Uminoyama",
    ],
    86 => [
      "Fairies generally live and play in",
      "groups. If a man is caught by a",
      "group of fairies, they will work",
      "together to play with him. Very",
      "eager for interesting things to play",
      "with, it's said that if a man is",
      "captured by multiple fairies, he",
      "will be forced to remain their",
      "plaything for a long time. Once made",
      "into a toy, the fairies will care",
      "for him like a pet. Even though they",
      "aren't hostile towards men, their",
	  "innocence and desire to play are just",
	  "as dangerous.",
      "",
      "Artist: Delphinus",
    ],
    87 => [
      "When a large group of fairies come",
      "together, they usually have a",
      "leader. If someone antagonizes the",
      "fairies, the leader is said to",
      "instruct the others in how to attack",
      "and defend themselves. Their attacks",
      "generally involve playing tricks and",
      "tormenting the antagonist. While a",
      "single fairy isn't too dangerous, a",
      "large group cannot be taken lightly.",
	  "",
      "Palm-sized fairies are difficult to",
      "catch or hit. If a large amount of",
      "fairies are able to cover your body,",
      "there is little you can do to get",
      "them off. Once caught, there is",
	  "nothing that awaits you but",
	  "miserable days of being played with",
	  "by the group. It's very dangerous to",
	  "antagonize fairies, so be sure not",
	  "to anger them.",
      "",
      "Artist: UN_DO",
    ],
    88 => [
      "When a large group of fairies come",
      "together, they usually have a",
      "leader. If someone antagonizes the",
      "fairies, the leader is said to",
      "instruct the others in how to attack",
      "and defend themselves. Their attacks",
      "generally involve playing tricks and",
      "tormenting the antagonist. While a",
      "single fairy isn't too dangerous, a",
      "large group cannot be taken lightly.",
	  "",
      "Palm-sized fairies are difficult to",
      "catch or hit. If a large amount of",
      "fairies are able to cover your body,",
      "there is little you can do to get",
      "them off. Once caught, there is",
	  "nothing that awaits you but",
	  "miserable days of being played with",
	  "by the group. It's very dangerous to",
	  "antagonize fairies, so be sure not",
	  "to anger them.",
      "",
      "Artist: UN_DO",
    ],
    89 => [
      "When a large group of fairies come",
      "together, they usually have a",
      "leader. If someone antagonizes the",
      "fairies, the leader is said to",
      "instruct the others in how to attack",
      "and defend themselves. Their attacks",
      "generally involve playing tricks and",
      "tormenting the antagonist. While a",
      "single fairy isn't too dangerous, a",
      "large group cannot be taken lightly.",
	  "",
      "Palm-sized fairies are difficult to",
      "catch or hit. If a large amount of",
      "fairies are able to cover your body,",
      "there is little you can do to get",
      "them off. Once caught, there is",
	  "nothing that awaits you but",
	  "miserable days of being played with",
	  "by the group. It's very dangerous to",
	  "antagonize fairies, so be sure not",
	  "to anger them.",
      "",
      "Artist: UN_DO",
    ],
    90 => [
      "When a large group of fairies come",
      "together, they usually have a",
      "leader. If someone antagonizes the",
      "fairies, the leader is said to",
      "instruct the others in how to attack",
      "and defend themselves. Their attacks",
      "generally involve playing tricks and",
      "tormenting the antagonist. While a",
      "single fairy isn't too dangerous, a",
      "large group cannot be taken lightly.",
	  "",
      "Palm-sized fairies are difficult to",
      "catch or hit. If a large amount of",
      "fairies are able to cover your body,",
      "there is little you can do to get",
      "them off. Once caught, there is",
	  "nothing that awaits you but",
	  "miserable days of being played with",
	  "by the group. It's very dangerous to",
	  "antagonize fairies, so be sure not",
	  "to anger them.",
      "",
      "Artist: UN_DO",
    ],
    91 => [
      "When a large group of fairies come",
      "together, they usually have a",
      "leader. If someone antagonizes the",
      "fairies, the leader is said to",
      "instruct the others in how to attack",
      "and defend themselves. Their attacks",
      "generally involve playing tricks and",
      "tormenting the antagonist. While a",
      "single fairy isn't too dangerous, a",
      "large group cannot be taken lightly.",
	  "",
      "Palm-sized fairies are difficult to",
      "catch or hit. If a large amount of",
      "fairies are able to cover your body,",
      "there is little you can do to get",
      "them off. Once caught, there is",
	  "nothing that awaits you but",
	  "miserable days of being played with",
	  "by the group. It's very dangerous to",
	  "antagonize fairies, so be sure not",
	  "to anger them.",
      "",
      "Artist: UN_DO",
    ],
    92 => [
      "When a large group of fairies come",
      "together, they usually have a",
      "leader. If someone antagonizes the",
      "fairies, the leader is said to",
      "instruct the others in how to attack",
      "and defend themselves. Their attacks",
      "generally involve playing tricks and",
      "tormenting the antagonist. While a",
      "single fairy isn't too dangerous, a",
      "large group cannot be taken lightly.",
	  "",
      "Palm-sized fairies are difficult to",
      "catch or hit. If a large amount of",
      "fairies are able to cover your body,",
      "there is little you can do to get",
      "them off. Once caught, there is",
	  "nothing that awaits you but",
	  "miserable days of being played with",
	  "by the group. It's very dangerous to",
	  "antagonize fairies, so be sure not",
	  "to anger them.",
      "",
      "Artist: UN_DO",
    ],
    93 => [
      "One of the four great spirits, Sylph",
      "rules over the wind. Though she's a",
      "type of fairy, her magic far",
      "surpasses a normal one. Since she is",
      "averse to battle, Sylph is unable to",
      "properly use her powerful magic in a",
	  "fight. Even so, she isn't an",
	  "opponent that a normal adventurer",
	  "can handle.",
      "",
      "Due to her fairy nature, she loves",
      "playing tricks on people. Interested",
      "in male genitalia, she will use her",
      "wind to play with men until they",
      "ejaculate. In addition, she absorbs",
	  "male semen to replenish her magic.",
      "",
      "Though she has a physical body, she",
      "is able to turn into a spirit body.",
      "Using her spirit body, she can",
      "possess a man and allow him to use",
      "her powers. However, the man needs",
      "to be very skilled to manage the",
      "enormous magic Sylph holds. For that",
	  "reason, the spirits will only give",
	  "their assistance to those they deem",
	  "worthy.",
      "",
      "Artist: frfr",
    ],
    94 => [
      "A mysterious swordsman that appears",
      "in spiritual locations, like the",
      "Forest of Spirits. It is covered in",
      "a bizarre substance that has",
      "solidified its whole body like",
      "armor. It seems to have completely",
      "lost its reason, making communication",
      "with it impossible. Its purpose and",
      "identity are unknown, but it appears",
      "to relentlessly target angels and",
      "wields extraordinary power.",
      "",
      "Artist: Setouchi",
    ],
    95 => [
      "An insect-based monster. Though she",
      "holds the ability to create webs,",
      "she chooses instead to attack her",
      "prey directly and use her silk to",
      "deprive them of freedom. She usually",
      "sucks out all of the body fluid of",
      "her prey, but if she particularly",
      "likes the man, she will mate with",
      "him instead.",
	  "",
      "The peculiar structure of her",
      "spinneret is able to act as both a",
      "normal spider's spinneret and as a",
      "female vagina that can force men to",
      "ejaculate with surprising ease. She",
      "is able to manipulate her spider",
	  "silk inside her own body as she uses",
	  "it to stimulate the man. Even after",
	  "mating with a man for reproductive",
	  "purposes, she will almost always eat",
	  "him anyway. Nevertheless, there have",
	  "been cases of a Tarantula Girl",
	  "keeping a man as a partner for life.",
      "",
      "Artist: Setouchi",
    ],
    96 => [
      "A monster that resembles a cow, she",
      "has a surprisingly human appearance.",
      "There is no human soldier that can",
      "match her in brute strength, though.",
      "Able to knock down any man, she will",
      "then take that opening to rape them.",
      "In most cases the goal is to feed",
      "instead of reproduction. With strong",
      "muscles in her vagina, she is able",
      "to freely tighten and control every",
      "movement inside of her. When a man",
      "is caught inside of her, it's said",
      "that she holds him like a vise as",
      "she uses her muscles to squeeze",
	  "everything out of him. For your own",
	  "safety, you should never make a",
	  "Minotauros angry when she's raping",
	  "you.",
      "",
      "In almost every case, the man will",
      "be released after the Minotauros has",
      "finished raping him but when the",
      "Minotauros really likes a man, she",
	  "may carry him back to her home and",
	  "force him to be her husband.",
      "",
      "Artist: frfr",
    ],
    97 => [
      "A large-armed monster of unknown",
      "lineage living in the wilderness.",
      "In addition to the enormous strength",
      "within her huge left arm, magical",
      "power is also hidden within it. She",
      "is able to absorb the energy of her",
      "opponent once she has them in her",
      "grip, and add their strength to her",
      "own.",
      "",
      "She is a monster whose existence has",
      "only been confirmed recently, thus",
      "there are many unknown factors",
      "regarding her ecology. It has been",
      "confirmed that she aggressively",
      "attacks humans, gripping them with",
      "her big arm and squeezing out their",
      "energy. This draining is accompanied",
      "by a sensation of pleasure, and it",
      "typically leads men to ejaculate in",
      "her grip. It is common for her to",
      "drain energy until the person dies",
      "from weakness, making her an",
      "undoubtedly dangerous monster.",
      "",
      "Artist: Cool-kyou Shinja",
    ],
    98 => [
      "A lowly Succubus lurking in the town",
      "of Monte Carlo. She appears to have",
      "endured hardships wandering through",
      "many towns and villages, disguising",
      "herself as a nun and a prostitute in",
      "order to feed on human semen. She is",
      "not a powerful succubus, but she has",
      "a deep obsession with wealth and",
      "fame.",
      "",
      "Suffering from an inferiority",
      "complex due to her hard life, she",
      "greedily covets men without holding",
      "back. If she catches you, relentless",
      "torture is sure to follow. She will",
      "slowly draw out the man's semen,",
      "insulting them as they dry out and",
      "perish.",
      "",
      "Artist: Iwashi no Atama",
    ],
    99 => [
      "A subspecies of Scylla whose strange",
      "lower body resembles a demonic",
      "beast. Instead of tentacles, she has",
      "insect-like legs, and can extend",
      "countless tongues from the mouth of",
      "her lower body. Although she has a",
      "monster's body, she has a surprising",
      "fondness of humans, and will not",
      "attack unless you enter her",
      "territory.",
      "",
      "She can acquire nutrition from the",
      "same diet as humans, but she still",
      "prefers human semen the most, and",
      "will cleverly invite men to be",
      "sucked by her. Her lower mouth",
      "doubles as an extracting organ,",
      "which sucks semen from the penis",
      "once it is inside. Skillfully",
      "entwining the penis with her",
      "tongues, the man is eventually",
      "released after many ejaculations.",
      "By that time, he will be left too",
      "weak to stand on his feet.",
      "",
      "Artist: SugaMon",
    ],
    100 => [
      "An insect monster that's closely",
      "related to a centipede. Boasting a",
      "durable carapace, her combat ability",
      "is high.",
	  "",
      "Feeding on human bodily fluids, her",
      "preferred feed is human semen. After",
      "restraining her catch, she will wrap",
      "her legs around him and use her many",
      "feet to stimulate him. Using those",
      "many feet to force him to ejaculate,",
	  "she will squeeze him dry. In most",
	  "cases, she will continue until her",
	  "prey dies.",
      "",
      "In some cases, she will mate with",
      "her catch through a gap in her",
      "carapace. Tiny projections that are",
      "capable of moving like feet provide",
      "unbearable stimulation to the man.",
      "Restrained, the man is forced to",
      "ejaculate dozens of times. Here,",
      "too, the man is usually forced to",
      "mate until his death of exhaustion.",
	  "Overall, she's an extremely",
	  "dangerous monster, as most",
	  "encounters lead to death.",
      "",
      "Artist: Setouchi",
    ],
    101 => [
      "An insect-based monster that lives",
      "in the desert. Designed to live in",
      "arid regions, her shell is very",
      "durable. Equipped with powerful",
      "scissors, it's very difficult to run",
      "away once held down. In addition,",
      "her tail contains a very powerful",
      "venom that can kill her prey with",
      "ease, but since dead prey cannot",
      "ejaculate, she instead uses a small",
      "amount to simply paralyze her prey.",
	  "",
      "The tip of her tail is able to open",
	  "to enable a man's penis to fit",
	  "inside. She is able to manipulate",
	  "the flesh inside of her tail, and",
	  "quickly pump him with her strong",
	  "tail muscles to force a man to",
	  "ejaculate. She will continue to feed",
	  "on the man until he dies, making her",
	  "one of the most feared desert",
	  "monsters.",
      "",
      "Unique among other insect-based",
      "monsters, she reproduces by taking",
      "the semen squeezed out into her tail",
      "and injecting it directly into her",
	  "oviduct using the tip of her tail.",
      "",
      "Artist: Setouchi",
    ],
    102 => [
      "A cactus monster that is a",
      "subspecies of the Alraune family.",
      "She is very well-mannered, with a",
      "soft and elegant character. But",
      "contrary to her personality, she is",
      "quite sadistic, and enjoys seeing",
      "the distorted face of pleasure on",
      "her prey as she embraces them with",
      "her thorny body.",
      "",
      "To supplement her nutrition, she",
      "will insert the man's penis into",
      "the mouth of the cactus as she hugs",
      "them to extract their bodily fluids.",
      "The inside of the cactus mouth is a",
      "structure filled with many swelling",
      "pulps that will bring any man to a",
      "quick climax. Men who fall prey to",
      "a Cactus Girl will have all of their",
      "fluids drawn out and left dried up",
      "in her embrace.",
      "",
      "Artist: Setouchi",
    ],
    103 => [
      "An ostrich monster that is a variant",
      "of the Harpy race. She cannot fly in",
      "the sky, but she takes pride in her",
      "great physical abilities and excels",
      "in combat through the use of her",
      "strong legs. Although she runs",
      "around hastily, her personality is",
      "calm, and she is friendly towards",
      "humans. Many people run businesses",
      "that make use of her leg strength,",
      "such as delivering fresh water from",
      "the oasis to the town and back.",
      "",
      "During her mating period, however,",
      "she will aggressively assault men",
      "and forcibly bring them inside her",
      "to mate. In addition to the soft",
      "vaginal protrusions common among",
      "the Harpy race, her tough legs",
      "give her such an incredible",
      "tightness that no ordinary man",
      "would last a minute inside her. If",
      "violated by this vagina, any man",
      "would miserably release their semen",
      "and impregnate the Ostrich Girl.",
      "After mating, the man is almost",
      "always released without any harm.",
      "",
      "Artist: Stealth Changing Line",
    ],
    104 => [
      "A half-human half-monster that",
      "possesses an antique lamp. She is",
      "only able to leave her dimension",
      "when a man rubs the lamp and summons",
      "her into his dimension. Using the",
      "guise of granting wishes, she",
      "skillfully seduces men. Most men are",
      "unable to resist and make a wish of",
      "lust. Extremely skilled at sexual",
	  "techniques, she can fulfill that",
	  "wish and leave the man satisfied.",
	  "After the man is exhausted, she will",
	  "show her true nature and devour him.",
      "",
      "If the man wishes instead for",
      "[Wealth and Fame], or any variation",
      "thereof, she will show him an",
      "illusion with her magic. Like that,",
      "she will again swallow him. It's",
      "believed that any strong-minded man",
      "who holds no selfish desires will",
	  "actually have their wish granted by",
	  "her.",
      "",
      "Artist: Setouchi",
    ],
    105 => [
      "An undead monster that lurks in the",
      "Pyramid. Originally she just",
      "wandered through the Pyramid looking",
      "for energy, but she was later tasked",
      "by Sphinx to be the first challenge",
      "of those undergoing the",
      "[Dragon Seal Trial], though this",
      "hasn't changed the way she treats",
      "the men she catches.",
	  "",
      "Able to freely control her bandages,",
      "she uses them to bind her catch. She",
      "infuses the bandages with magic that",
      "is able to suck energy and uses that",
	  "to suck out everything. If she wraps",
	  "those bandages around a man's penis,",
	  "she can suck energy at the same time",
	  "as she wrings out his semen.",
      "",
      "For hundreds of years, there has yet",
      "to be a challenger that has gotten",
      "past the Mummy Girl. Only a few",
      "people have ever managed to escape",
	  "her once stepping inside the Pyramid",
	  "as well.",
      "",
      "Artist: Setouchi",
    ],
    106 => [
      "A subspecies of Lamia, she lives",
      "primarily in arid regions. A minion",
      "of Sphinx, she was given the role of",
      "testing those who would attempt the",
      "[Dragon Seal Trial]. Very cruel, and",
      "just as intelligent, she takes",
      "pleasure in tormenting those she",
	  "deems unqualified.",
      "",
      "Like most Lamias, she coils around",
      "her catch as she rapes them. Once",
      "the man's genitalia are strangled",
      "inside her tight vagina, most men",
      "will surrender with surprising",
      "quickness. In addition, there is a",
      "very powerful poison inside of her",
      "body that paralyzes her catch. Once",
	  "she rapes you, it is not possible to",
	  "return alive.",
      "",
      "Artist: Setouchi",
    ],
    107 => [
      "Four sisters of the same mother that",
      "serve Sphinx. Just like most Lamias,",
      "they coil around their catch as they",
      "play with him.",
      "",
      "Given the role of testing challengers",
      "of the trial, they play with anyone",
      "deemed unqualified as a group. With",
      "all four of them coiling around the",
      "man, they will take turns raping",
      "him, forcing him to ejaculate",
      "repeatedly. They will also mate for",
      "reproduction if they like the man,",
      "and will continue to take turns",
      "raping him. If the man is too weak,",
      "he will die from the gang-rape. If",
	  "he is strong enough to survive, he",
	  "will spend the rest of his life",
	  "shared by the four Lamias as a group",
	  "sex slave.",
      "",
      "Artist: UN_DO",
    ],
    108 => [
      "A mixed beast monster that guards",
      "the Pyramid, believed to be older",
      "than 1,000 years old. Through her",
      "long life, she has come to wield",
      "powerful magic. Through various",
      "circumstances, she has become the",
      "judge presiding over the [Dragon",
      "Seal Trial]. However, it seems she",
      "despairs at her role and lives her",
	  "life immersed in hopelessness.",
      "",
      "Those who fail the trial are",
      "violently raped, then eaten. She",
      "forces her prey to be entranced by",
      "pleasure as she swallows them whole",
	  "and slowly digests them inside her",
	  "gigantic stomach.",
      "",
      "Her enormous magic, built up over",
      "hundreds of years, renders her all",
      "but immune to any type of sealing",
	  "magic.",
      "",
      "Artist: Setouchi",
    ],
    109 => [
      "The princess of Sabasa, whose lewd",
      "personality has been drawn out by",
      "Astaroth. In addition to the power",
      "of a Succubus, she also awoke the",
      "Sphinx's blood that still ran",
      "through her veins.",
      "",
      "Her human memory has all remained,",
      "but her thoughts and desires have",
      "become confused due to the sudden",
      "drastic increase in power. Overcome",
      "by her own desires, she has turned",
      "into an incredibly dangerous",
      "monster. At the mere sight of a man,",
      "the desire to drain him dry takes",
      "over her human thoughts.",
      "",
      "Artist: Épée",
    ],
    110 => [
      "The middle sister of the three",
      "Lilith Sisters, who serve the",
      "legendary Great Whore of Babylon.",
      "She wields magical power that is",
      "beyond the compare of monsters in",
      "this world, but its nature is",
      "unknown. She is powerful enough",
      "to drain men into dried fish, but",
      "refrains from actively doing so for",
      "some reason.",
      "",
      "Her intentions are unknown, and it",
      "is uncertain why she even appeared",
      "in this world. The only thing that",
      "is certain is that her presence is",
      "affecting the world from behind the",
      "scenes.",
      "",
      "Artist: Shiki",
    ],
    111 => [
      "A land-dweller monster with",
      "alligator characteristics. She",
      "appears calm at a glance, but she is",
      "carnivorous and expresses her",
      "ferocity when she attacks prey. The",
      "alligator mouth on her abdomen is",
      "very powerful, and poses the threat",
      "of swallowing anyone caught in the",
      "strong bite of her jaws. However,",
      "she only hunts when she is hungry,",
      "and is usually seen relaxing by the",
      "waterside.",
      "",
      "During her mating period, she will",
      "capture a man and forcefully",
      "intersect with him. Because there",
      "is a chance of being preyed upon",
      "after mating, she is extremely",
      "dangerous.",
      "",
      "Artist: Uminoyama",
    ],
    112 => [
      "A Succubus idol performing at",
      "Grandeur's Grand Theater. She is",
      "great at song and dance and has",
      "captivated the hearts of many humans",
      "and monsters. Her ambition is to",
      "become world-famous and reign as the",
      "top idol.",
      "",
      "She acquires meals from her fans by",
      "inviting them into her room and",
      "squeezing out their semen. To",
      "protect her idol image, she erases",
      "the memory of her opponents to make",
      "them believe it was just a dream.",
      "",
      "She is not very good at combat, and",
      "her sexual skills pale in comparison",
      "to other succubi. It is for that",
      "reason she polished her singing and",
      "dancing and dreamed of rising to the",
      "top.",
      "",
      "Artist: UN_DO",
    ],
    113 => [
      "A seasoned yoma warrior armed with",
      "a large sword and light armor. She",
      "belongs to a clan of venerable",
      "warriors, and her skill with a blade",
      "is top-notch. She always looks",
      "nervous because she finds the battle",
      "attire of her clan to be embarrassing",
      "due to how revealing it is.",
      "Moreover, because she was trained as",
      "a warrior, she is unfamiliar with",
      "sexual techniques and keeps her hips",
      "closed. One must be careful however,",
      "as her high combat ability",
      "contradicts her demeanor.",
      "",
      "To replenish her energy, she will",
      "violate her defeated opponent if it",
      "was a man. Although she is",
      "inexperienced, most men will be",
      "unable to endure her if she",
      "passionately shakes her waist.",
      "Because of her inexperience, she",
      "also has a tendency to push her",
      "victims into a state of debilitating",
      "weakness from trying sexual skills",
      "that are not safe. She is a very",
      "dangerous yoma swordsman that you",
      "should never be careless around.",
      "",
      "Artist: Neko Manma",
    ],
    114 => [
      "A huge spider-type monster that is a",
      "subspecies of Arachne. Most of her",
      "body is that of a spider, and the",
      "strength and agility from utilizing",
      "her eight legs make her a threat.",
      "The thread she spews is strongly",
      "adhesive, and quickly entwines",
      "around her prey's entire body. In",
      "addition, she is able to use basic",
      "time magic similar to other members",
      "of the Arachne race.",
      "",
      "She is very ferocious, and will prey",
      "upon anyone captured by her sticky",
      "threads. If her prey is a lively man",
      "however, she will stretch out her",
      "fallopian tube to latch onto his",
      "penis and squeeze out semen. After",
      "sucking his penis until he dries up,",
      "she will hang him from her viscous",
      "thread and prey upon him like any",
      "other catch. She is a very dangerous",
      "monster that will greedily exhaust",
      "anyone.",
      "",
      "Artist: SugaMon",
    ],
    115 => [
      "A low-grade organism created from a",
      "female villager by Lily's",
      "experiments. Her intelligence and",
      "reason has been completely erased",
      "and the Suck Vore's only function is",
      "to catch men and suck out their",
      "semen. It isn't even capable of",
      "reproduction. When it catches a man,",
      "it draws it into its body and uses",
      "its tentacles to force him to",
      "ejaculate. Due to the large amount",
      "of slimy tentacles, it's able to",
      "force a man to orgasm surprisingly",
      "quick. As soon as he ejaculates, the",
	  "Suck Vore can absorb the semen into",
	  "its flesh.",
      "",
      "Once it catches a man, it will",
      "continue to suck out his semen until",
      "he dies. Since it's unable to think",
      "or communicate, there is no escape",
      "once caught, making this a very",
      "dangerous monster. This was one of",
	  "the first creations of Lily.",
      "",
      "Artist: Setouchi",
    ],
    116 => [
      "The result of another of Lily's",
      "experiments in transforming a",
      "villager into a torture device, it",
      "locks a man inside its body and uses",
      "every aspect of her interior to",
      "stimulate the man. Filled with",
      "tentacles inside of her body as he's",
      "left unable to move.",
	  "",
      "Once locked inside, the amount of",
      "force needed to open her back up is",
      "greater than the power of 20 men.",
      "If caught inside, there's no escape.",
      "The Iron Maiden will force the man",
      "to orgasm repeatedly until their",
	  "death. Lily uses the device to both", 
      "collect a large amount of semen",
	  "quickly and to dispose of men that",
	  "have lost their use.",
	  "",
      "The Iron Maiden takes considerable",
      "magic to create, so only a few exist",
      "inside Lily's mansion. It's also",
      "believed that one escaped her",
	  "dungeon into the wild.",
      "",
      "Artist: Setouchi",
    ],
    117 => [
      "With a tentacle for an arm, she was",
      "driven mad by Lily's magic. Though",
      "her personality has been twisted,",
      "she retains the intelligence and",
      "memories she had from before she was",
      "transformed, but due to Lily's",
      "corruption, she can't stop herself",
      "from craving semen. Crushed by the",
      "desire, she uses her tentacle to",
      "force men to sate her thirst. Since",
      "her tentacle was designed primarily",
      "to force men to ejaculate, the",
      "pleasure is extremely potent.",
	  "",
      "No matter how much semen she",
      "consumes, she will never feel sated.",
      "Forced to desire evermore, she",
      "can't do anything but endlessly",
	  "squeeze men. Intelligent enough to",
	  "not kill her source of semen, she",
	  "will carefully keep the man on the",
	  "brink of death, ensuring he remains",
	  "alive so she can continue to milk",
	  "him. If a man is caught by her,",
	  "they will spend the rest of their",
	  "life weakened and unable to do",
	  "anything but feed her.",
      "",
      "Artist: Setouchi",
    ],
    118 => [
      "A Scylla whose lower body tentacles",
      "have been transformed by cutting-",
      "edge magic techniques. Each of her",
      "tentacles has become a mouth capable",
      "of performing a strong biting",
      "attack. In addition, they can",
      "stretch out their tongues, giving",
      "her lower body a wide variety of",
      "abilities.",
      "",
      "The magic tentacles of her lower",
      "body can also be used as squeezing",
      "organs by latching onto a man's",
      "penis and sucking it. The tongue",
      "inside the mouth moves so that it",
      "twines around in addition to the",
      "undulating feeling, causing her prey",
      "to climax in succession many times.",
      "Ustrel only thinks of human men as a",
      "food source, and will mercilessly",
      "squeeze out their semen until they",
      "are exhausted. She is a very",
      "dangerous monster despite her soft",
      "demeanor.",
      "",
      "Artist: SugaMon",
    ],
    119 => [
      "An undead monster, this variant of",
      "mimic lurks inside of a pot waiting",
      "for her prey. Anyone who peers into",
      "her pot will be pulled in by her",
      "tentacles and made into her prey.",
      "",
      "In addition to tentacles, she also",
      "controls slime, which her pot is",
      "filled with. Prey which has been",
      "drawn into the pot will be",
      "overwhelmed by this combination of",
      "tentacles and viscous slime. Once",
      "this happens, the prey will be",
      "unable to move, and will repeatedly",
      "climax while in a state of agonizing",
      "pleasure. She will then continue to",
      "squeeze out semen over a long period",
      "of time. Since any man who becomes",
      "her prey will never be released",
      "alive, one must exercise great",
      "caution when examining jars.",
      "",
      "Artist: Setouchi",
    ],
    120 => [
      "A powerful magic user that took over",
      "lordship of Witch Hunt Village. The",
      "illegitimate daughter of the",
      "previous lord, she studied magic",
      "from forbidden books. Using that",
      "power, she killed her father and",
      "brothers.",
      "",
      "After becoming Lord, Lily increased",
      "the witch hunts in order to capture",
      "the villagers for experiments. She",
      "used the females to create new",
      "twisted monsters or transformed",
      "humans, and would wring the semen",
      "from the males for use in testing.",
      "If the man held weak latent magic",
      "power inside, she would quickly",
      "dispose of him. Weak women, unable",
      "to completely change their body,",
      "would end up with tentacles for",
      "various body parts.",
      "",
      "After experimenting on villagers for",
      "years, she remodeled her own body by",
      "implanting two tentacles in her",
      "arms. Using those tentacles, she",
      "would harvest hundreds of men's",
      "semen for use in her testing. A",
      "significant number of villagers and",
      "travelers have been killed by her",
      "hand.",
      "",
      "Artist: Setouchi",
    ],
    121 => [
      "A demi-human monster also known as an",
      "Oni in the Yamatai region. She",
      "boasts extraordinary strength",
      "despite her small size, and a blow",
      "from her club is able to shatter",
      "large boulders.",
      "",
      "Her character is naïve and innocent,",
      "but she is also simple and",
      "shortsighted. Since she is from",
      "Yamatai, she is very friendly",
      "towards humans. Because they almost",
      "look the same as humans, they can",
      "wander around towns and villages",
      "normally without drawing attention.",
      "",
      "She is curious about sex, and when",
      "she finds a man that interests her,",
      "she will knock him down and play",
      "around with his groin. Sometimes she",
      "becomes committed to her sexual",
      "play, in which case she will engage",
      "in intercourse and violently shake",
      "her waist as if to beat the man up.",
      "As a result, even if her intentions",
      "were not malicious, the man she",
      "rapes will be left physically and",
      "mentally exhausted. Although she",
      "will never deprive anyone of their",
      "life, you should still be careful as",
      "she can render you bedridden for a",
      "while.",
      "",
      "Artist: Neko Manma",
    ],
    122 => [
      "A slime-based homunculus refined by",
      "Lucia's magic techniques. She has a",
      "semi-viscous elastic body, and her",
      "fingers are equipped with male sex",
      "processing instruments called",
      "onaholes. Since she was good at",
      "using them to stimulate male",
      "genitals and extract semen, Lucia",
      "gave her the name Onahole Girl.",
      "",
      "Moreover, she is also able to change",
      "her appearance freely by making full",
      "use of her slime body. Her personality",
      "is mellow, and she seems favorable",
      "towards humans who enjoy a little",
      "mischief.",
      "",
      "Under Lucia she was assigned to",
      "collect semen, skillfully",
      "stimulating the penises of the men",
      "she gathered. By making them",
      "ejaculate in a flowing manner, she",
      "is able to collect semen for",
      "experiments efficiently. She also",
      "has a function for semen storage,",
      "making her a very capable entity",
      "as a living extraction tool.",
      "",
      "Artist: kupala",
    ],
    123 => [
      "A low-class, wandering Succubus. She",
      "hid her true nature, and worked at",
      "the town Church, learning basic",
      "medicine. She led a hungry life,",
      "only feeding on the occasional",
      "patient in secret. She joined the",
	  "resistance group led by Lucia to put",
	  "a stop to Lily's tyranny.",
      "",
      "Due to her position in the medical",
      "field in disguise, she developed",
      "extensive skills in making patients",
      "'accidentally' ejaculate during",
      "medical examinations.",
      "",
      "Artist: frfr",
    ],
    124 => [
      "A woman born in Witch Hunt Village,",
      "who studied at the national",
      "University in Sabasa. She returned",
      "to her hometown after reaching the",
      "top of her class in Magical Science",
      "studies, but was caught by Lily.",
      "She lost her sanity once Lily",
      "implanted a worm inside her body,",
      "but regained her senses after",
      "draining a lot of semen. She then",
      "rebelled against Lily and started a",
      "resistance group based in a nearby",
      "tower.",
      "",
      "The magical power she was born with",
      "is extraordinary, and her experience",
      "in magical science has allowed her",
      "to refine a large number of",
      "homunculi. She has gathered comrades",
      "and mercenaries, and has become a",
      "force comparable to Lily in a short",
      "amount of time.",
      "",
      "Artist: Setouchi",
    ],
    125 => [
      "An ancient monster who is a kind of",
      "Youkai with countless eyes all over",
      "her body. Her magical power is very",
      "high and she specializes in demonic",
      "eye techniques. She has traveled to",
      "many countries with her friends and",
      "whenever she runs short on funds,",
      "she takes up mercenary work.",
      "",
      "To maintain her high magical power,",
      "she needs to consume a large amount",
      "of semen. She will use her eyes to",
      "seduce a man so that he will",
      "surrender his semen to her. Like",
      "this, she will relentlessly slurp",
      "out his semen, and it is not unusual",
      "for her to suck him until he is dry.",
      "",
      "Artist: SugaMon",
    ],
    126 => [
      "A thief from the Dragon race who",
      "makes a living as a bandit.",
      "Possessing high attack power and",
      "speed, her skills are unmatched by",
      "human thieves. Her stealing skills",
      "are top-notch and she is extremely",
      "proficient with dagger techniques.",
      "",
      "She belongs to the Scale Bandits,",
      "who operate from the cave near",
      "Saloon. She is extremely loyal to",
      "her leader, and engages in banditry",
      "every day.",
      "",
      "If a man is caught by her, she will",
      "drag him back to where her fellow",
      "bandits are waiting to gang-rape",
      "him. Even after being mentally and",
      "physically trampled by them to the",
      "point of exhaustion, they will not",
      "release him. Because they are a very",
      "dangerous bandit group, one should",
      "avoid carelessly approaching them.",
      "",
      "Artist: Stealth Changing Line",
    ],
    127 => [
      "A thief from the Dragon race who",
      "makes a living as a bandit. She has",
      "an excellent sword arm and wields",
      "peerless skills when compared to the",
      "average warrior. Of course, her",
      "skill as a thief is also great, and",
      "her stealing skills are top-notch.",
      "",
      "She belongs to the Scale Bandits,",
      "who operate from the cave near",
      "Saloon. She is extremely loyal to",
      "her leader, and engages in banditry",
      "every day.",
      "",
      "If a man is caught by her, she will",
      "drag him back to where her fellow",
      "bandits are waiting to gang-rape",
      "him. Even after being mentally and",
      "physically trampled by them to the",
      "point of exhaustion, they will not",
      "release him. Because they are a very",
      "dangerous bandit group, one should",
      "avoid carelessly approaching them.",
      "",
      "Artist: Stealth Changing Line",
    ],
    128 => [
      "A Dragonkin swordsman who is the",
      "reigning boss of the Scale Bandits.",
      "She appears to be respectable among",
      "the Dragonkin race, and has acquired",
      "powerful sword techniques unique to",
      "her kind. Of course, she also has",
      "excellent skills as a thief, and she",
      "is quite boastful of her unrivaled",
      "influence around the Saloon region.",
      "",
      "If a man is caught by her, she will",
      "drag him back to where her",
      "subordinates are waiting to gang-",
      "rape him. Even after being mentally",
      "and physically trampled by them to",
      "the point of exhaustion, they will",
      "not release him. Because they are a",
      "very dangerous bandit group, one",
      "should avoid carelessly approaching",
      "them.",
      "",
      "Artist: Stealth Changing Line",
    ],
    129 => [
      "A ghost-type monster that appears in",
      "the desert. Unlike most ghosts,",
      "she is unusually friendly with a",
      "bright personality, and is active",
      "even in the daytime. However, her",
      "thirst for human semen is no",
      "different, and she often attacks",
      "travelers who are wandering in the",
      "desert.",
      "",
      "Her lower body is intangible and",
      "cannot interact with humans, but she",
      "can still use her mouth, hands, and",
      "breasts to extract semen. By caress-",
      "ing a man's genitals, she can",
      "cause ejaculations that force out a",
      "large amount of semen. She usually",
      "won't try to take away your life,",
      "but if you are weakened in the",
      "desert, encountering her may prove",
      "to be a dangerous situation.",
      "",
      "Artist: Stealth Changing Line",
    ],
    130 => [
      "An insect-based monster that lives",
      "mainly in the desert, she creates a",
      "cone-shaped nest in the ground to",
      "catch unsuspecting travelers in",
      "order to squeeze out their bodily",
      "fluids. Preferring semen, she will",
      "use her massive scissors to lock the",
      "man's waist in place as she sucks",
      "everything out. Once her catch has",
      "been completely sucked dry, she will",
      "dispose of their dried corpse in the",
	  "desert. Although her trap is",
	  "extremely dangerous, her body is",
	  "very fragile. The only way to escape",
	  "is to quickly defeat her before",
	  "you're brought too far in.",
      "",
      "Though it's called an Antlion Girl,",
      "it looks like a doodlebug. However,",
      "for the monster Antlion Girl, this",
	  "is her adult form.",
      "",
      "Artist: Setouchi",
    ],
    131 => [
      "A huge monster that lives in arid",
      "regions. It usually hides under the",
      "sand, but when it senses the",
      "vibrations of a moving human, it",
      "will attack them. Forcing the man",
      "into her mouth, she will suck on",
      "them like a piece of candy. Her",
      "giant tongue can quickly force a",
      "man to orgasm. Once the man has",
      "reached orgasm, she will begin to",
      "use her tongue to suck and lick up",
      "all the semen, forcing the man to",
      "continually ejaculate. Once she",
      "sucks out everything from the man,",
	  "she will burrow back under the sand",
	  "to await her next meal. Though she",
	  "is very slow and absentminded, you",
	  "cannot be careless around her.",
      "",
      "Most desert monsters greedily suck",
      "up men's fluids to slake their",
      "thirst. Great care needs to be",
      "taken when traveling through the",
	  "desert, since being caught by a",
	  "monster usually entails certain",
	  "death.",
      "",
      "Artist: Setouchi",
    ],
    132 => [
      "A subspecies of Scylla adapted to",
      "the desert. She is able to swim",
      "freely in the shifting sands, and",
      "can make the sands flow at her whim.",
      "Due to living in the harsh desert",
      "she always needs moisture, which she",
      "acquires by capturing human prey",
      "with her tentacles as the person is",
      "unable to move in the flowing sand.",
      "Prey is scarce in the desert, so",
      "every drop of fluid from their catch",
      "will be squeezed out.",
      "",
      "If her prey happens to be a strong",
      "man, she may engage in intercourse",
      "with him. She will hold her opponent",
      "down with her tentacles and pull him",
      "towards the reproductive hole in the",
      "center of her lower body. The inner",
      "walls of her reproductive hole move",
      "like they're massaging the penis,",
      "encouraging the release of semen.",
      "This does not stop until all of his",
      "semen has been extracted, leaving",
      "the pitiful prey dry and exhausted",
      "in the Desert Scylla's embrace.",
      "",
      "Artist: xelvy",
    ],
    133 => [
      "Holding huge magic, the Earth Spirit",
      "Gnome can freely manipulate the",
      "Earth itself. However, she has very",
      "little combat experience, so she",
      "doesn't know how to effectively use",
      "her magic in a fight. Gnome usually",
      "spends her time in the desert",
	  "playing with the sand and mud. When",
	  "she senses a human approaching, she",
	  "will usually hide and silently",
	  "observe them.",
      "",
      "Due to her curious nature, if Gnome",
      "catches a man, she will take her",
      "time to play and inspect him. To",
      "replenish her magic, she will use",
	  "her mud dolls to collect semen.",
      "",
      "If you defeat Gnome, she will lend",
      "you her power. When she possesses",
      "you with her spirit body, you can",
	  "use her Earth magic.",
      "",
      "Though it looks like she bullies",
      "Sylph, it may just be because she",
      "doesn't know how to express her",
	  "feelings.",
      "",
      "Artist: frfr",
    ],
    134 => [
      "A mysterious being known as an",
      "Apoptosis, which resides in",
      "Tartarus. They are organisms",
      "resembling monsters, but no one",
      "knows what they are. Moreover, she",
      "appears to instinctively attack",
      "intruders as if programmed into her",
      "mind.",
      "",
      "Vitae is a slime organism and the",
      "female part is a mechanical unit.",
      "The slime enters this unit to",
      "operate it from within, simulating a",
      "female body. This union of slime and",
      "machine appears to be highly",
      "advanced technology, but its origins",
      "are unknown.",
      "",
      "She requires an immense amount of",
      "semen in order to function, which",
      "she squeezes out of the living",
      "creatures she captures. Simply",
      "touching her viscous slime can bring",
      "about vigorous ejaculations, as if",
      "your life itself were being consumed",
      "by the slime.",
      "",
      "Artist: Delphinus",
    ],
    135 => [
      "A mysterious being known as an",
      "Apoptosis, which resides in",
      "Tartarus. They are organisms",
      "resembling monsters, but no one",
      "knows what they are. Moreover, she",
      "appears to instinctively attack",
      "intruders as if programmed into her",
      "mind.",
      "",
      "Vetala is an unknown humanoid",
      "monster, who uses the gaping mouth",
      "on the center of her body to devour",
      "humans. Sometimes she will swallow",
      "the person slowly as she enjoys",
      "watching them struggle. Her combat",
      "ability is also very high; in",
      "addition to the fangs lining her",
      "huge mouth, her large tongue also",
      "possesses extraordinary strength.",
      "",
      "Her huge mouth also serves as a",
      "reproductive organ, and if it",
      "receives your sperm, is capable of",
      "producing offspring. She is a",
      "mysterious creature that is",
      "extremely unusual in her ecology.",
      "",
      "Artist: xelvy",
    ],
    136 => [
      "A mysterious being known as an",
      "Apoptosis, which resides in",
      "Tartarus. They are organisms",
      "resembling monsters, but no one",
      "knows what they are. Moreover, she",
      "appears to instinctively attack",
      "intruders as if programmed into her",
      "mind.",
      "",
      "Valto is an organism whose entire",
      "body is comprised of machinery. She",
      "can expand each part of her body to",
      "envelop her prey like a cage to",
      "forcibly squeeze out their fluids.",
      "Her behavior is mechanical, and it",
      "is uncertain whether or not she has",
      "a will of her own.",
      "",
      "Her combat ability is also very",
      "high; her fist unit can exert",
      "extreme heat or cold upon impact,",
      "and weapons like gatling guns are",
      "built into her body. Her purpose,",
      "along with her very existence, are",
      "shrouded in mystery.",
      "",
      "Artist: xelvy",
    ],
    137 => [
      "A mysterious being known as an",
      "Apoptosis, which resides in",
      "Tartarus. They are organisms",
      "resembling monsters, but no one",
      "knows what they are. Moreover, she",
      "appears to instinctively attack",
      "intruders as if programmed into her",
      "mind.",
      "",
      "Shinifa is a mysterious creature",
      "that floats in the air, cackling",
      "with a bizarre laughter. She appears",
      "to be devoid of reason, as she will",
      "not speak any words other than",
      "laughing.",
      "",
      "Her body appears to be composed of",
      "sticky flesh that, if touched",
      "carelessly, one can be drawn into",
      "her interior. It seems that she",
      "digests and absorbs the prey that was",
      "pulled inside as it is, but the",
      "details of this process are unknown.",
      "In addition, her body is covered in",
      "poison, and she is capable of",
      "scattering it around. Even among the",
      "enigmatic Apoptosis, Shinifa is a",
      "very mysterious type.",
      "",
      "Artist: xelvy",
    ],
    138 => [
      "A shadow monster of unknown lineage",
      "living inside the tower of another",
      "world. She appears to have been",
      "birthed from the residual magic",
      "leftover from nearby studies of",
      "magic such as necromancy. Her body",
      "itself is comprised of countless",
      "souls of other beings. She continues",
      "to grow her body by taking in the",
      "souls of other beings into herself.",
      "Although she was an unintentionally",
      "born monster, she was kept in the",
      "tower in order to stave off the",
      "invading forces, even if just a",
      "little.",
      "",
      "Of course, above all, male semen is",
      "still her primary source of power,",
      "and she will seek out human men to",
      "acquire it. She will give genital",
      "stimulation to encourage",
      "ejaculations in order to extract his",
      "semen. But in the end, she will",
      "incorporate their body and soul into",
      "her own. In her current environment,",
      "however, there is almost no",
      "possibility of encountering humans,",
      "so her extinction seems inevitable.",
      "",
      "Artist: frfr",
    ],
    139 => [
      "A monster with powerful magic and",
      "a refined lady's soul transferred",
      "into a painting through a special",
      "technique. Because she is relatively",
      "easy to create, she was mass-",
      "produced in order to fend off the",
      "invading forces.",
      "",
      "Basically harmless, she only tries",
      "to drag in men when they interest",
      "her. If drawn inside the painting as",
      "her prey, there is no escape, and",
      "she is free to continue toying with",
      "the man forever. Since the flow of",
      "time inside the painting world is",
      "different from the real world, this",
      "rape will continue for eternity. In",
      "her current environment, however,",
      "there is almost no possibility of",
      "encountering humans, so she has few",
      "opportunities to acquire semen.",
      "",
      "Artist: frfr",
    ],
    140 => [
      "Based on Promestein's research, this",
      "monster was created by Lucia. This",
      "Chimera is a mix of state-of-the-art",
      "biological sciences and old-",
      "fashioned alchemy. Her ability and",
      "intelligence are drastically",
      "improved from a normal homunculus,",
      "and her power rivals that of top-",
      "class monsters. A few of them seem",
      "to be defending the tower under a",
      "new master.",
      "",
      "She submits completely to the orders",
      "of her master, but there are no",
      "linked ethical standards seen. Her",
      "tentacles are able to wrap around",
      "her prey and directly suck out semen",
      "to feed on. Due to the pleasure",
      "that's given to the male, they will",
      "be forced to ejaculate one way or",
      "another. She doesn't have any",
      "hesitation in killing her prey, but",
      "because there is almost no",
      "possibility of encountering humans",
      "in her current environment, she will",
      "take any opportunity to extract as",
      "much semen as possible.",
      "",
      "Artist: Setouchi",
    ],
    141 => [
      "Originally a homunculus created by",
      "Lily, she escaped from the mansion",
      "during the confusion and started",
      "attacking travelers. Those that had",
      "been captured and improved upon by",
      "Lucia are now currently in the hands",
      "of a new master.",
      "",
      "After attacking many humans and",
      "absorbing their semen, she has",
      "gained a simple intelligence.",
      "Accepting her existence as a tool",
      "for torture, she derives meaning",
      "from her life in squeezing criminals",
      "to death. If caught by the Neo Iron",
      "Maiden, your semen will be squeezed",
      "until your death as a sinner.",
      "However, since there is almost no",
      "possibility of encountering humans",
      "in her current environment, there",
      "aren't many opportunities to",
      "acquire semen.",
      "",
      "Artist: Setouchi",
    ],
    142 => [
      "An amalgamation Doll monster created",
      "by combining various doll parts that",
      "had become junk. The regrets from",
      "those dolls have caused her to",
      "develop a very brutal personality.",
      "",
      "She acts on a principle of",
      "destruction, and any creature caught",
      "by her will be killed by having",
      "their energy sucked out. However,",
      "she is only obeying the will of her",
      "master who is shut away in the tower",
      "of this other world, carrying out",
      "orders to suppress the invading",
      "forces.",
      "",
      "Each doll appears to possess an",
      "individual will, and they express",
      "multiple personalities. However,",
      "this notion of individuality is very",
      "flimsy, as the limbs, torsos, and",
      "even heads can be replaced with",
      "those from other Doll monsters.",
      "Since she has never left the tower",
      "before, she expresses a longing to",
      "see the outside world.",
      "",
      "Artist: UN_DO",
    ],
    143 => [
      "A very powerful, high-class",
      "Apoptosis. Her nature and purpose",
      "are shrouded in mystery, and she",
      "does not appear to understand human",
      "language, making communication",
      "impossible. She has characteristics",
      "of both monsters and angels at the",
      "same time, and by wielding the",
      "mysterious power known as Chaos, her",
      "combat abilities are extraordinary.",
      "She is an organism whose very",
      "existence is an enigma, and it is",
      "uncertain whether she was really",
      "destroyed or not. There is also a",
      "theory that she becomes more",
      "powerful each time she appears...",
      "",
      "Artist: xelvy",
    ],
    144 => [
      "A mysterious monster only matched by",
      "her mysterious power. With her",
      "identity unknown, it's unsure if",
      "there are even any monsters who can",
      "match her strength. Though it",
      "appears she means no harm to humans,",
      "she is merciless if one dares to",
	  "challenge her. The price for",
	  "challenging her is pricey, indeed.",
      "",
      "Artist: Kenkō Cross",
    ],
    145 => [
      "The ruler of the Netherworld, she is",
      "an administrator who controls death.",
      "Her power reaches into the realm of",
      "godhood, and although her existence",
      "is certainly beyond the scope of",
      "humanity, her identity and purpose",
      "are unknown.",
      "",
      "Artist: Silk",
    ],
    146 => [
      "An angel of the eighth circle",
      "(Archangel), her role is executing",
      "Heaven's divine punishment. Having a",
      "very harsh nature, she cruelly kills",
      "her opponents with her various body",
      "parts.",
      "",
      "Though she has various biological",
      "and plant parts, they are a result",
      "of her divine aura assimilating",
      "surrounding beings with her, and not",
      "an artificial construct. Although",
      "despite being able to assimilate",
      "with other beings, the most",
      "effective way of regaining her",
      "energy is through male semen.",
      "Therefore when she executes her",
      "punishment on human males, she",
      "always makes sure to squeeze them",
      "dry first.",
      "",
      "Artist: Setouchi",
    ],
    147 => [
      "An angel of punishment and judgment",
      "accompanied by her sacred snakes,",
      "she falls in the seventh circle",
      "(Principalities). Usually enshrined",
      "in the court of Heavens, her normal",
      "role is to judge the souls of humans",
      "after their death depending on how",
      "they lived their lives. Those found",
	  "guilty of crimes are punished by her",
	  "sacred snakes. Tightly coiling",
	  "around them, they punish the",
	  "criminal with agonized ecstasy until",
	  "they repent their sins.",
      "",
      "Though in times of great peril, she",
      "will come down to the surface world",
      "herself. In those times, she will",
      "use her sacred snakes to exact",
      "punishment and judgment directly on",
      "the surface world. But those who are",
      "judged by Nagael on the ground are",
      "not brought up to the Heavens. After",
	  "reaching their death while being",
	  "punished on the surface world, their",
	  "soul is again set for judgment in",
	  "the Heavens.",
      "",
      "Artist: Setouchi",
    ],
    151 => [
      "A mushroom girl who is always",
      "dressed in black clothes. She",
      "typically lives in forests and",
      "caves, but on rare occasions she",
      "will appear at a village. She",
      "always appears to be in love with",
      "humans, and will skillfully invite",
      "adventurers to her. Although she has",
      "a habit of marrying the first man",
      "she meets, due to their difference",
      "in lifespans, the man usually dies",
      "first in most cases. Inevitably, she",
      "will become a widow and seek new",
      "warmth.",
      "",
      "She will never kill men, but she may",
      "force one to spend their life",
      "together with her. She is a strong",
      "and dangerous monster who gets very",
      "possessive, no matter the kind of",
      "man.",
      "",
      "Artist: Silk",
    ],
    152 => [
      "Insect-based monsters who act in a",
      "group. They will climb onto a man and",
      "push their plump breasts against his",
      "penis until he ejaculates. The",
      "released semen is ingested as",
      "nourishment and is supposedly a",
      "nutrient for further growth.",
      "However, there has been no",
      "confirmation of a Novistador Girl",
      "who has developed into an advanced",
      "form. In fact, there are many",
      "mysteries surrounding their origins",
      "that have not been confirmed, such",
      "as the theory that they are",
      "distant descendants of an ancient",
      "monster fly, or that they are a",
      "surviving experimental organism.",
      "",
      "They typically do not deprive the",
      "man of his life, but because they",
      "milk out his semen in groups, he",
      "will be left in a weakened state.",
      "Because it can be dangerous to be",
      "left in such a weakened state, one",
      "should not abandon caution around",
      "them.",
      "",
      "Artist: Cool-kyou Shinja",
    ],
    153 => [
      "A subspecies of Scylla whose lower",
      "body consists of multiple wolf heads",
      "and tentacles. They are regarded as",
      "the oldest species among the Scylla",
      "race, and take pride in the notion",
      "that they are the rightful Scylla.",
      "Thus, they are sometimes hostile",
      "towards other types of Scylla (who",
      "are now the common tentacle type).",
      "Of course, the wolves of her lower",
      "body are also a part of her.",
      "",
      "Although they are not cruel, they",
      "possess a strong curiosity and when",
      "one catches a man, she will thoroughly",
      "toy with his body. If she takes a",
      "liking to him, she will bring the",
      "man back to her nest. Since she",
      "often appears around watersides and",
      "in caves, one should be careful at",
      "such places.",
      "",
      "Artist: Uminoyama",
    ],
    154 => [
      "A type of Youkai wearing a",
      "carnivorous bolt of cotton that",
      "drifts and floats in the air.",
      "Her cloth is a part of her body, and",
      "is capable of stretching freely to",
      "wrap around prey and take away their",
      "freedom. She then secretes digestive",
      "juices from her body, melting her",
      "prey while it is restrained.",
      "",
      "She may sometimes feel compelled to",
      "perform sexual intercourse when",
      "capturing prey, of which she enjoys",
      "violating men as she digests them.",
      "Her attitude and behavior may appear",
      "friendly, but she is a cruel and",
      "dangerous Youkai.",
      "",
      "Artist: Shimpi",
    ],
    155 => [
      "A common mermaid inhabiting oceans",
      "around the world. They have tough",
      "bodies that can withstand the water",
      "pressure of the deep sea and are",
      "proficient in healing magic. Their",
      "beautiful singing voice also",
      "attracts many people.",
      "",
      "They are generally friendly",
      "individuals who actively interact",
      "with humans. Many live in human",
      "towns and villages, and their values",
      "are similar to those of humans.",
      "There are also many mermaids who",
      "formally marry humans, and are said",
      "to be the most homely among all",
      "monsters.",
      "",
      "Of course, they are also very good",
      "at sex, and their genitals are",
      "wonderful. Any man who intersects",
      "with them will be given the finest",
      "pleasure as he becomes captivated by",
      "them.",
      "",
      "Artist: Yukimura Shinji",
    ],
    156 => [
      "Even among mermaids, there are",
      "those who actively engage in",
      "trading. Taking advantage of the",
      "maritime network, their trade has",
      "spread throughout the world.",
      "They are typically friendly towards",
      "humans, but there are some who",
      "attack travelers and merchant ships",
      "to rob them of goods and valuables.",
      "",
      "Their magical power is weaker than a",
      "typical mermaid's, but their",
      "physical strength is quite high.",
      "They are also very calculating and",
      "dexterous.",
      "",
      "They speak with strangely accented",
      "words, but it is not known what this",
      "local accent is. Some linguists",
      "speculate that it is derived from",
      "western Yamatai, which is no longer",
      "in use, but the origin of this",
      "accent, including its principles, is",
      "unknown.",
      "",
      "Artist: Arekishi",
    ],
    157 => [
      "A corsair who engages in piracy on",
      "the high seas. Today, many races,",
      "including humans, make up the",
      "pirates roaming the seas. Ever",
      "since the navy had dismantled the",
      "largest pirate groups, they have",
      "lost a lot of power and",
      "organization, but their distribution",
      "is still quite remarkable.",
      "",
      "Mermaids who engage in piracy are",
      "generally violent and magically",
      "weak, consisting of mostly younger",
      "individuals. They will occasionally",
      "attack merchant ships in groups and,",
      "in addition to plundering goods and",
      "riches, will also capture the men of",
      "among the crew. Captured men are",
      "trafficked and sometimes even used",
      "by the pirates as sex slaves aboard",
      "their ship. No matter how pretty",
      "they may look, you must never forget",
      "they are still dangerous pirates.",
      "",
      "Artist: Arekishi",
    ],
    158 => [
      "A Youkai that dances in the sky",
      "with a flapping white cloth, which",
      "is part of her body. Acting in",
      "groups, they seek out human men to",
      "catch and squeeze out their energy.",
      "Because their flight ability is",
      "poor, they are often witnessed being",
      "carried by the wind towards the",
      "inner sea. Due to these",
      "circumstances, they often appear at",
      "sea and attack ships.",
      "",
      "They have an innocent and friendly",
      "personality, and do not kill human",
      "beings. Because they attack in",
      "groups, however, they will often",
      "squeeze men to the brink of death",
      "by weakness.",
      "",
      "Artist: Silk",
    ],
    159 => [
      "A Youkai that dances in the sky",
      "with a flapping white cloth, which",
      "is part of her body. Acting in",
      "groups, they seek out human men to",
      "catch and squeeze out their energy.",
      "Because their flight ability is",
      "poor, they are often witnessed being",
      "carried by the wind towards the",
      "inner sea. Due to these",
      "circumstances, they often appear at",
      "sea and attack ships.",
      "",
      "They have an innocent and friendly",
      "personality, and do not kill human",
      "beings. Because they attack in",
      "groups, however, they will often",
      "squeeze men to the brink of death",
      "by weakness.",
      "",
      "Artist: Silk",
    ],
    160 => [
      "A Youkai that dances in the sky",
      "with a flapping white cloth, which",
      "is part of her body. Acting in",
      "groups, they seek out human men to",
      "catch and squeeze out their energy.",
      "Because their flight ability is",
      "poor, they are often witnessed being",
      "carried by the wind towards the",
      "inner sea. Due to these",
      "circumstances, they often appear at",
      "sea and attack ships.",
      "",
      "They have an innocent and friendly",
      "personality, and do not kill human",
      "beings. Because they attack in",
      "groups, however, they will often",
      "squeeze men to the brink of death",
      "by weakness.",
      "",
      "Artist: Silk",
    ],
    161 => [
      "A monster that lives in the sea.",
      "Posing as a mermaid, she catches",
      "careless men who dare to get too",
      "close to her. Her mimicry isn't that",
      "great, but due to the obfuscation of",
      "the seawater, some men have been",
      "known to be tricked. Normally found",
	  "further Northward, it appears to",
	  "have migrated to the inland sea due",
	  "to the Great Disaster.",
      "",
      "Once she catches a man, she uses her",
      "lower body to wrap around him,",
      "squeezing out his semen. An overly",
      "happy, innocent monster, she has",
      "been known to squeeze men to death",
      "with a carefree smile on her face.",
      "",
      "Artist: Setouchi",
    ],
    162 => [
      "A Hitodama is a spiritual monster,",
      "much like a ghost. Their existence",
      "is said to be closer to a soul than",
      "a typical ghost, thus they have a",
      "pure personality and do not harbor",
      "grudges like common ghosts. Although",
      "she has a fluffy spirit body, there",
      "are parts that are materialized,",
      "making her less stable than a ghost.",
      "As an elemental she has a high",
      "sensitivity to nature, but there is",
      "still a lot of mystery surrounding",
      "her race.",
      "",
      "Human energy is necessary for her to",
      "maintain her body, and she will",
      "attack men in order to squeeze it",
      "out. Although she does not intend to",
      "squeeze men to death, contact with",
      "her spiritual form places a burden",
      "upon the man's body. Caution is",
      "advised as they can significantly",
      "deprive a man of his energy.",
      "",
      "Artist: Kusakabe",
    ],
    163 => [
      "A mermaid who serves as the First",
      "Mate of the Fishy Pirates. In",
      "addition to giving commands in the",
      "place of her captain, she serves as",
      "the helmsman and handles navigation.",
      "She is also in charge of cooking and",
      "cleaning within the ship. Without",
      "her, the Fishy Pirates would not be",
      "able to function. Her combat prowess",
      "is also outstanding and she has",
      "taken credit for numerous",
      "engagements against marines, earning",
      "her notoriety among the Navy.",
      "",
      "She seems to have a deep respect for",
      "the captain of the previous",
      "generation of pirates and faithfully",
      "assists Bonnie, the current captain",
      "of the Fishy Pirates, who is",
      "supposedly the daughter of the",
      "previous captain. She is striving to",
      "be a respectable leader by",
      "instructing and training every day.",
      "",
      "Arekishi: Arekishi",
    ],
    164 => [
      "A mermaid who heads the Fishy",
      "Pirates and proclaims herself to be",
      "the descendant of Pirate Queen Roza.",
      "Although she isn't good with magic",
      "and is rather clumsy and lacking in",
      "leadership ability, she is a very",
      "capable fighter. She also has strong",
      "will, and will not back down in the",
      "face of adversity. It is for this",
      "reason alone that she is respected",
      "by her crew and trusted as their",
      "captain.",
      "",
      "Incidentally, she suffers from a",
      "complex with her inability to swim,",
      "and has always been inept in water.",
      "Although she has been trained to",
      "swim by Ashel for quite a while, she",
      "still can't keep her head underwater",
      "for more than ten seconds. While she",
      "insists her floatation ring is just",
      "a fashion statement, it is actually",
      "a lifeline for her.",
      "",
      "Artist: Arekishi",
    ],
    165 => [
      "A seahorse girl who serves as a",
      "marine in the Navy. Despite her cute",
      "and immature appearance, she is a",
      "member of the Dragon race and is",
      "quite strong in battle. They are",
      "particularly skilled in group combat",
      "to such an extent that they have",
      "become the mascot of the navy for",
      "their battle contribution.",
      "",
      "They have an innocent personality,",
      "but are rather gluttonous and quick",
      "to treat themselves to food. They",
      "have been frequently sighted",
      "skipping duty for meals, and are",
      "rather unreliable as marines",
      "outside of their combat abilities.",
      "There are also rumors that all of",
      "the Seahorse Marines are sisters due",
      "to how all of them look extremely",
      "similar to one another.",
      "",
      "Artist: Arekishi",
    ],
    166 => [
      "A sea slug girl who serves as a",
      "marine in the Navy. Although her race",
      "is not known for its power, she has",
      "undergone rigorous training and her",
      "battle skills are sharp. Her mucus-",
      "covered body is very troublesome for",
      "pirates due to its ability to soften",
      "blows and slashes.",
      "",
      "When she is attacking men, she will",
      "cover them with her lower body and",
      "squeeze out their semen. Since she",
      "can absorb semen from any part of",
      "her mucus-covered body, she simply",
      "wraps the penis with her body and",
      "stimulates it to force an",
      "ejaculation. If she wants to, she",
      "may even force the man to mate with",
      "her. Since she serves the navy, she",
      "usually won't squeeze men",
      "excessively. She is a friendly and",
      "harmless monster to anyone other",
      "than pirates.",
      "",
      "Artist: Arekishi",
    ],
    167 => [
      "A huge sea dragon standing as the",
      "Admiral of the Navy. She is among",
      "the strongest of the sea monsters",
      "and her power is said to rival both",
      "the Queen of the Southern Seas,",
      "Kraken, and the Queen of the",
      "Northern Seas, Poseidoness. She is",
      "extremely harsh towards those who",
      "disturb the order of the sea, and",
      "will mercilessly crush them using",
      "her spear and serpentine body.",
      "",
      "She will not attack men unless she",
      "is challenged, in which case she",
      "will unleash her fury and thoroughly",
      "humiliate her challenger. Her vagina",
      "can wrap around a man's entire body",
      "to squeeze out his semen, and draw",
      "him inside once he has been sucked",
      "dry. She is a very formidable and",
      "strict monster, but will not harm",
      "those who lead an honest life.",
      "",
      "Artist: Setouchi",
    ],
    168 => [
      "An amphibious monster, they infest",
      "streams and wetlands.",
      "They prefer feeding on humans, and",
      "will generally attack them in",
      "swarms. Once the man is caught, they",
      "will use their tongues to lick them",
      "to ejaculation. Their skillful use",
      "of their long tongues can easily",
      "lick their prey dry. Since there are",
      "usually many of them, their feeding",
	  "never stops with a single",
	  "ejaculation.",
      "",
      "If they find a particularly good",
      "male, they will sometimes mate with",
      "him as a group. The Frog Girls will",
      "take turns raping him, and will",
      "switch after every orgasm. Easily",
      "overpowered by their sheer numbers,",
      "the man will have no choice but to",
      "mate with every single one of them.",
      "After the mating is finished, the",
	  "man will be completely exhausted.",
	  "Exploiting that weakness, they will",
	  "usually be taken to the Frog Girls'",
	  "home and kept as a shared mate.",
      "",
      "Artist: UN_DO",
    ],
    169 => [
      "An amphibious monster, they infest",
      "streams and wetlands.",
      "They prefer feeding on humans, and",
      "will generally attack them in",
      "swarms. Once the man is caught, they",
      "will use their tongues to lick them",
      "to ejaculation. Their skillful use",
      "of their long tongues can easily",
      "lick their prey dry. Since there are",
      "usually many of them, their feeding",
	  "never stops with a single",
	  "ejaculation.",
      "",
      "If they find a particularly good",
      "male, they will sometimes mate with",
      "him as a group. The Frog Girls will",
      "take turns raping him, and will",
      "switch after every orgasm. Easily",
      "overpowered by their sheer numbers,",
      "the man will have no choice but to",
      "mate with every single one of them.",
      "After the mating is finished, the",
	  "man will be completely exhausted.",
	  "Exploiting that weakness, they will",
	  "usually be taken to the Frog Girls'",
	  "home and kept as a shared mate.",
      "",
      "Artist: UN_DO",
    ],
    170 => [
      "A very famous, half-horse half-human",
      "monster. Proud of their heritage,",
      "they are quite aloof from other",
      "monsters. But once a year, they go",
      "into a breeding frenzy, and will",
      "attack any man they see in order to",
      "satisfy their urges. Once she",
      "captures a mate, she will rape them",
      "without rest. Despite her horse-like",
      "pussy being loose, she can control",
      "it with such skill that no man can",
	  "resist it. After a man is raped by",
	  "her, the Kentauros will continue to",
	  "use him as her personal stallion.",
      "",
      "Furthermore, Kentauros generally",
      "take one man per breeding season.",
      "But if they particularly like the",
      "man they captured, they are known to",
	  "keep them as their personal stallion",
	  "for life.",
      "",
      "Artist: frfr",
    ],
    171 => [
      "A famous plant-type monster. There",
      "are many kinds of Alraunes, and",
      "their personality and appearance",
      "vary wildly depending on the type.",
      "This Alraune is of a very pure type,",
      "and has an upper body very similar",
      "to a human's.",
      "They can live off photosynthesis",
      "alone, but they prefer male semen.",
      "Their bodies all contain an intake",
      "for semen, and will carefully",
      "extract it from any captured male.",
      "Since it's designed to feed, the",
	  "hole is quite capable of forcing any",
	  "man to come quickly.",
      "",
      "Alraunes generally have a gentle",
      "personality and will not suck a man",
      "dry. Always optimistic, they live a",
      "mostly carefree life.",
      "",
      "Artist: masha",
    ],
    172 => [
      "A caterpillar girl who dwells in",
      "caves around the Yamatai region.",
      "They are innocent in nature, but",
      "require a lot of nutrition to grow",
      "into an adult, and will tie up men",
      "with a viscous thread to drink their",
      "semen. In addition to wrapping their",
      "penis with sticky thread to force",
      "ejaculations, they will sometimes",
      "suck up semen directly using her",
      "mouth. They can even insert the",
      "penis into their abdominal tip and",
      "squeeze out semen like that. They",
      "typically aren't hostile to humans,",
      "but they may greedily suck their",
      "semen and push him into a weakened",
      "state. Caution is advised in case",
      "they forget to restrain themselves.",
      "",
      "She also has youkai attributes and",
      "possesses a good amount of magical",
      "ability. Combined with her high",
      "vitality, she is not an opponent to",
      "be careless around just because she",
      "is immature.",
      "",
      "Artist: rai-rai chika sa",
    ],
    173 => [
      "A ghost who bears a grudge and",
      "wanders around this world. Unlike",
      "typical ghosts, this one has youkai",
      "attributes. Thus, she has great",
      "magical power and there are many",
      "powerful individuals among them.",
      "Many of them express a clear",
      "resentment as they rampage around",
      "this world, but not all of them are",
      "hostile towards humans.",
      "",
      "When the color of their spirit body",
      "turns dark, they will assault men",
      "to drain their energy. Contact with",
      "her body gives men a feeling of",
      "ecstasy, draining their energy even",
      "when she isn't doing anything. If",
      "the man intersects with the ghost,",
      "she will deprive him of energy and,",
      "if she does not restrain herself,",
      "will quickly dry him up. During that",
      "time, the man will taste an untold",
      "degree of intense pleasure.",
      "",
      "Artist: SugaMon",
    ],
    174 => [
      "A variant of mimic lurking in a",
      "treasure box. As her species name",
      "suggests, she does not like to come",
      "out of her box, and prefers to draw",
      "things in. She is well-mannered and",
      "appears to be good at housework.",
      "",
      "Her lower body is made of soft",
      "organs, which fill the inside of her",
      "treasure box. In the place where the",
      "keyhole would be located is a",
      "squeezing cavity, which she invites",
      "men to stick their penis inside of.",
      "Once inserted, the man will",
      "experience melting pleasure and",
      "ejaculate instantly. She can be",
      "rather cruel and greedy, and may",
      "squeeze him repeatedly until he is",
      "on the verge of dying from weakness.",
      "",
      "Although there is a treasure in her",
      "box, this is used as an excuse to",
      "encourage the man to insert his",
      "penis into the keyhole, as it is",
      "actually some mundane thing she",
      "picked up. Because she is a monster",
      "who deceives adventurers in various",
      "ways, one should pay close attention",
      "to treasure chests in the dungeons.",
      "",
      "Artist: xelvy",
    ],
    175 => [
      "Filled with powerful magic, she is",
      "able to separate her head from her",
      "body. Many Dark Elves train to",
      "acquire the power needed to become a",
      "Dullahan. Boasting powerful physical",
      "skills, their fighting ability is",
      "extremely high. With the ability for",
      "the body and head to operate",
      "independently of each other, the",
	  "hair on her head can take advantage",
	  "of any openings the body creates.",
	  "She's easily a match for any warrior",
	  "who dares to challenge her.",
      "",
      "Once the Dullahan defeats her",
      "challenger, she will force them to",
      "surrender fully to her. Using her",
      "magical hair and flexible tongue, no",
	  "man can resist her.",
      "",
      "Many of them are interested in",
      "fencing and chivalry. Some of them",
      "even enjoy participating in the",
	  "Colosseum, testing their strength",
	  "against worthy challengers.",
      "",
      "Artist: masha",
    ],
    176 => [
      "A beast famous as the 'Hellhound'.",
      "Three heads attached to one body,",
      "each able to think for itself. Her",
      "agility is very high, and it's",
      "difficult to get an opening on her",
	  "due to her three sets of eyes. A",
	  "very dangerous monster to cross",
	  "swords with.",
      "",
      "A sexually greedy beast they will",
      "take any chance to rape a man given",
      "to them. Once she mounts her mate",
      "there is nothing they can do. Giving",
      "in to her beast instincts, she will",
      "thrash and wildly pump her mate",
      "quickly forcing them to orgasm.",
	  "Raping her catch without mercy, they",
	  "are even known to go until he dies.",
      "",
      "Artist: Thomas",
    ],
    177 => [
      "Called the Queen Succubus, she is",
      "the most powerful of the succubi.",
      "One of the Four Heavenly Knights,",
      "she is a master of Wind magic. In",
      "addition, her flexible body makes",
      "her the most powerful hand-to-hand",
      "fighter of the Four Heavenly",
      "Knights. A moody woman, she is easy",
      "to hate. Living in the moment, all",
      "she cares about is her own pleasure.",
	  "Though she has no sense of loyalty,",
	  "she acknowledges the Monster Lord's",
	  "power, and follows her instructions.",
      "",
      "A lewd Monster, her only enjoyment",
      "in life is playing with men. Once",
      "she catches a man, she tries to",
      "finish him off using a wide variety",
      "of methods.",
      "Using her tail, it's said that the",
      "man will faint after tasting the",
      "overwhelming pleasure. After",
      "squeezing every drop of semen out of",
      "the man, she will usually eat them.",
      "In addition to being able to eat",
      "semen with her tail, she can expand",
	  "it to swallow men whole. Alma Elma",
	  "prefers powerful warriors who",
	  "challenge her instead of",
	  "weak ordinary men.",
      "",
      "Artist: Akazawa RED",
    ],
    178 => [
      "A powerful monster of the dragon",
      "race, she is one of the Four",
      "Heavenly Knights. Devoting herself",
      "to the sword, there is nobody in the",
      "world who can match her flaming",
      "sword. Swearing loyalty to the",
	  "Monster Lord, she takes great pride",
	  "in her position. With a chivalrous",
	  "spirit, she avoids useless violence",
	  "against the weak.",
      "",
      "Those of the Dragon race have an",
      "omnivorous diet like humans, but",
      "prefer semen. Even though Granberia",
      "generally doesn't feed on semen,",
      "unlike fellow members of her tribe,",
	  "she sometimes cannot help herself",
	  "playing with defeated men in the",
	  "rush of battle.",
      "",
      "Believing strongly in her chivalry,",
      "she only chooses to associate with",
      "the strong. With an unmatched",
      "swordswoman like Granberia, it's",
	  "hard for her to acknowledge someone.",
      "",
      "Artist: Akazawa RED",
    ],
    179 => [
      "A lamia-based Youkai that lives in a",
      "swamp. Her name originates from the",
      "fact her body is always coated with",
      "a slimy mucus. Using her serpentine",
      "body, she wraps around her prey to",
      "exhaust them as they receive",
      "pleasure at the same time.",
      "",
      "Because she is a Youkai, she is",
      "resistant to cold despite also being",
      "a lamia. She prefers damp places",
      "like swamps, but she sometimes",
      "appears around villages too.",
      "",
      "She is very cruel-natured and, in",
      "addition to mercilessly squeezing",
      "her prey for semen, she will some-",
      "times swallow them whole using the",
      "mouth on her lower body once they",
      "have been thoroughly squeezed.",
      "Because she preys on humans without",
      "mercy, she is a very dangerous",
      "monster.",
      "",
      "Artist: Silk",
    ],
    180 => [
      "A greater species of warrior",
      "Minotaur. In addition to having a",
      "tougher body and more polished",
      "fighting skills than the average",
      "Minotauros, she is also gentler",
      "and better-natured. She is friendly",
      "towards humans and unless they",
      "trespass on her territory, she",
      "won't attack them.",
      "",
      "She will call out to men in towns",
      "and invite them to her home to have",
      "sex with them. The man will become",
      "exhausted by the intense affair, but",
      "because of her consensual approach,",
      "there is no chance of it being life-",
      "threatening. She typically prefers",
      "muscular men, but will also commit",
      "herself to more delicate men too.",
      "Boys who appeal to her maternal",
      "instinct appear to be her favorite.",
      "",
      "Artist: Neko Manma",
    ],
    181 => [
      "A motherly Minotaur who was wed to a",
      "man and had retired from the front",
      "lines. For some reason, her husband",
      "passed away early, and she has been",
      "sexually deprived. Longing for young",
      "men, she skillfully invites them to",
      "her home, tempting them with",
      "pleasure. Her sex is incredibly",
      "rigorous, and the man will ejaculate",
      "until he is exhausted. Incidentally,",
      "it is rumored this was the reason",
      "for her former husband's short life.",
      "",
      "Although she is not as strong as a",
      "minotaur on active duty, she is very",
      "dexterous and has a strong sexual",
      "desire. She is also very good at",
      "housework, and she can be frequently",
      "seen cleaning the city downtown in",
      "her search for a new husband.",
      "",
      "Artist: xelvy",
    ],
    182 => [
      "A rarity among her tribe, she is an",
      "intelligent Minotaur adept with",
      "technology. In the past she was",
      "responsible for the maintenance of",
      "weapons and, in dealing with other",
      "minotaurs, had polished her smithing",
      "skills. With the recent advent of",
      "Makina technology, she has also",
      "acquired advanced mechanical",
      "technology. Her dexterity and",
      "intelligence are superior to other",
      "minotaurs, but she is physically",
      "weaker by comparison, resulting in",
      "an inferiority complex.",
      "",
      "Even when she is raping men her",
      "complex manifests, causing her to",
      "sadistically blame the man for being",
      "weak more than herself for being",
      "strong. She will thoroughly trample",
      "the pride of any man she catches.",
      "",
      "Artist: Stealth Changing Line",
    ],
    183 => [
      "A legendary monster that existed in",
      "ancient times. Proud of her",
      "exceptional combat abilities, she",
      "supposedly fought alongside humans",
      "on occasions, but her legends have",
      "been forgotten. There used to be an",
      "adventure story where she was the",
      "main character, but ever since it",
      "was forbidden by the Goddess Ilias,",
      "the book upon which it was written",
      "has also been erased from this",
      "world.",
      "",
      "While she has a rough personality,",
      "she is not cruel. She has a strong",
      "chivalrous spirit, and enjoys both",
      "adventure and combat. In addition to",
      "being a master of martial arts, she",
      "can also use a variety of magic.",
      "While she is currently fulfilling",
      "her obligation to Black Alice for",
      "resurrecting her, she prefers to act",
      "of her own free will and is not",
      "totally obedient to her.",
      "",
      "Artist: makiya",
    ],
    184 => [
      "A descendant of the first Cow Demon",
      "Queen, who was slain by Sun Wukong",
      "during ancient times. Although she",
      "boasts a massive body and incredible",
      "strength even among monsters, she is",
      "not very intelligent. Ever since the",
      "first Cow Demon Queen was slain, her",
      "tribe has suffered misfortune for a",
      "long time. She is currently aiming",
      "for the seat of Queen Beast to",
      "uphold her legacy.",
      "",
      "She has a violent temper, but",
      "because she is simple-minded, she is",
      "not capable of diabolical scheming.",
      "She enjoys human semen and will",
      "greedily squeeze it out of any man",
      "she catches. While she does not",
      "squeeze men to death, one should",
      "beware as she may accidentally crush",
      "them.",
      "",
      "Artist: makiya",
    ],
    185 => [
      "An elf native to the Yamatai Region",
      "that has been trained in the arts of",
      "ninjutsu. In addition, she is also",
      "trained in sexual skills, capable of",
      "showing men either heaven or hell",
	  "through pleasure. If caught by a",
	  "Kunoichi Elf, the man can easily be",
	  "squeezed dry.",
      "",
      "Wanting to defend her home area, she",
      "faithfully defends Yamatai Village.",
      "If an outsider enters without",
      "permission, she will prey on them",
      "with her Kunoichi skills. Due to her",
	  "duty, she gets along well with the",
	  "Samurai Elf.",
      "",
      "Artist: Thomas",
    ],
    186 => [
      "An elf native to the Yamatai Region,",
      "she follows the bushido code.",
      "Originating in Yamatai Village, the",
      "bushido code had a profound",
	  "influence on the nearby elven",
	  "village.",
      "",
      "The Samurai Elf is on a mission to",
      "preserve the peace and order in the",
      "area, removing outsiders by force.",
      "Since she is both an elf and a",
      "trained warrior, a human warrior",
      "would struggle to match her in",
      "combat.",
	  "",
      "When her opponent is a man, she",
      "prefers using pin techniques. After",
	  "defeating him, she will rape him.",
	  "Despite the bushido code, this act",
	  "is triggered by her monster",
	  "instincts.",
      "",
      "She gets along well with the",
      "Kunoichi Elf, and pairs of them are",
	  "frequently seen patrolling the area.",
      "",
      "Artist: Thomas",
    ],
    187 => [
      "An extremely rare monster that only",
      "lives in the mountains of the",
      "Yamatai Region. Able to chill the",
	  "air at will, it's said she is able",
	  "to create blizzards.",
	  "",
      "When a man of her liking enters her",
      "territory, she creates a snowstorm",
      "to weaken him. Embracing the",
      "weakened man, she steals his energy",
      "and body heat. Her chilling embrace",
      "causes ecstasy for the man as he",
      "breathes his last breath buried in",
      "her bountiful chest. In some cases,",
      "she may even have sex with the man.",
      "With their body heat and semen sucked",
      "out by her cold vagina, the man dies",
	  "while shivering in ecstasy.",
      "",
      "In the rare case that she falls in",
      "love with a man, it's said she will",
      "take the form of a human woman and",
      "press him into marriage. This",
	  "marriage belief is mostly handed",
	  "down through stories of the Yamatai",
	  "Region.",
      "",
      "Artist: Setouchi",
    ],
    188 => [
      "A friendly monster towards humans.",
      "They rarely attack humans, but may",
      "if they are starving. At times they",
      "may forcefully mate with a human, so",
      "care is still required. They are",
      "surprisingly agile and quick-footed,",
	  "so they should not be underestimated",
	  "despite their friendly appearance.",
      "",
      "Unique to her race of monster, the",
      "Nekomata's vagina has a rough",
      "sensation to it. Easily capable of",
      "overpowering their partner with",
      "pleasure, men will ejaculate quickly",
	  "after being inserted in their high-",
	  "quality genitals.",
      "",
      "Other than human semen, they love",
      "dried bonito. Like a normal cat,",
      "they love walking around, basking in",
      "the sun and living selfish lives.",
      "",
      "Artist: frfr",
    ],
    189 => [
      "A monster indigenous to the Yamatai",
      "Region. Apart from their extremely",
      "long tongues, they are very",
      "human-like with strong physical and",
      "magical power. By no means stupid,",
      "they are sometimes teased and",
	  "ridiculed for their happy-go-lucky",
	  "attitude when it comes to licking",
	  "any man they can.",
      "",
      "Loving human sweat, semen, and any",
      "dirt on a human's body, when they",
      "find suitable prey they will",
      "continue licking them clean. Their",
      "long tongues are quickly able to",
      "send any man into the throes of",
      "agonized pleasure. They won't ever",
      "lick their prey to death, but the",
      "intense sessions can leave men",
	  "unable to stand for days. If",
	  "attacked by a group of Akaname, they",
	  "will take turns licking their prey",
	  "until he is completely dry.",
      "",
      "Artist: Irodori",
    ],
    190 => [
      "A Youkai living in a river near",
      "Yamatai. Humans have been familiar",
      "with them since ancient times and",
      "they frequently appear in the",
      "village. She is a friendly monster",
      "that enjoys mischief, but rarely",
      "harms anyone. She also is unrivaled",
      "at sumo wrestling, and has a habit",
      "of challenging adventurers to sumo",
      "wrestling upon seeing them. To the",
      "adventurers, this is no different",
      "from being attacked by hostile",
      "monsters, often leading to a fight.",
      "",
      "For some reason she is fascinated",
      "with the human anus, and tackles",
      "them persistently. If you lose to a",
      "Kappa at sumo wrestling, she will",
      "thoroughly finger you anally until",
      "you're left unable to stand on your",
      "legs. Incidentally, most of the boys",
      "in Yamatai Village have experienced",
      "ejaculation by the Kappa's anal",
      "torture, and many juveniles have",
      "become familiar with it.",
      "",
      "Artist: kupala",
    ],
    191 => [
      "A very friendly Youkai girl who",
      "frequently visits Yamatai Village.",
      "Behind her head is another mouth,",
      "which is very gluttonous. She has a",
      "gentle personality, but when she gets",
      "hungry, her back mouth may go into a",
      "frenzy and ignore her will, eating",
      "anything nearby. Contrary to her weak",
      "appearance, she is a youkai and has",
      "both great physical and magical",
      "strength, and if she goes on a",
      "rampage, no human will prove a match",
      "for her.",
      "",
      "If she finds a human while on an",
      "empty stomach, her back mouth will",
      "seize that person. While she does",
      "not eat humans, she will use her",
      "tongues to suck out bodily fluids",
      "and semen. Men in particular will",
      "have their semen squeezed out many",
      "times, and will be left exhausted by",
      "the time she spits them out.",
      "",
      "While many people blame her back",
      "mouth for her gluttony, she is also",
      "a big eater with her front mouth as",
      "well. She is feared among restaurant",
      "employees since food is consumed",
      "very rapidly if several Futakuchi",
      "Girls show up.",
      "",
      "Artist: rai-rai chika sa",
    ],
    192 => [
      "A white snake lamia who is the head",
      "of the snake shrine and the older of",
      "the two sisters. Wielding incredible",
      "power among lamias, she is regarded",
      "as a leader to whom other snake",
      "monsters in the area follow.",
      "Compared to her mild-mannered",
      "younger sister, she is much more",
      "ambitious and plots to rule over",
      "all youkai in the region.",
      "",
      "Both sisters seem to be related to",
      "the late Queen Lamia. Directly",
      "following the Queen Lamia's",
      "unexpected death, though her name",
      "was originally put forward as a",
      "successor, a large fight broke out",
      "over who would claim the seat. Due",
      "to this repeated rivalry for the",
      "position, the seat of Queen Lamia is",
      "still vacant.",
      "",
      "Artist: Jingai Modoki",
    ],
    193 => [
      "A young, neat Lamia that acts as a",
      "Shrine Maiden in Yamatai Village.",
      "Though she is known and accepted in",
      "the village, she harbored a secret",
      "desire to rape men whenever she",
      "wanted. Though she showed a face of",
	  "purity, she hid dark sexual desires.",
      "",
      "Her sexual torture is very intense,",
      "toying with men after completely",
      "winding around them with her snake",
      "lower body. She will squeeze both",
      "her vagina and her tail around her",
	  "prey, forcing them to come over and",
	  "over until she is satisfied.",
      "",
      "Artist: Yukimura Shinji",
    ],
    194 => [
      "A spider monster who has trained",
      "herself as a shrine maiden at",
      "Yamatai. She served as the miko to",
      "the spider shrine back when one",
      "existed in Yamatai, but has been",
      "lurking in Orochi's cave ever since",
      "the spider shrine collapsed. Despite",
      "being a member of the brutal Arachne",
      "race she is warm and friendly, but",
      "her greed is no different.",
      "",
      "When she catches a man, she winds",
      "her thread around to restrain him",
      "before violating him. While she",
      "will not squeeze her prey to death,",
      "if a high-quality man falls into her",
      "nest, she will never release him.",
      "She appears to have a delicate yet",
      "friendly relationship with the Miko",
      "Lamia, and they actively compete for",
      "prey.",
      "",
      "Artist: Neko Manma",
    ],
    195 => [
      "A long-haired monster from Yamatai.",
      "A malicious, stubborn monster, she",
      "enjoys toying with men using her",
      "sexual hair skills. Though she does",
      "dislike killing, so she doesn't play",
      "with them until they die. After",
	  "finishing with the man, she usually",
	  "leaves them abandoned on the",
	  "roadside.",
      "",
      "She sometimes disguises herself as a",
      "prostitute to seduce men. In the",
      "middle of intercourse, she finds",
      "great humor in revealing her true",
	  "monster character.",
      "",
      "Artist: Jingai Modoki",
    ],
    196 => [
      "An ancient monster who has eight",
      "independent heads. She was sealed",
      "for 100 years but seems to have",
      "awoken recently. Boasting extremely",
	  "high magical power, she seems to be",
	  "the most powerful monster in the",
	  "region.",
      "",
      "Though she has sexual organs, she is",
      "unable to have children. Though she",
      "can't reproduce, she is very",
      "lustful. Located in the Yamatai",
      "Region, she requires a sacrifice",
      "every year. As the sacrifices will",
      "be licked dry by her eight heads for",
      "a full year, the sacrifices happily",
      "volunteer for the role.",
	  "",
      "After the year is up, the sacrifice",
      "will be sent back to the village and",
      "a new one will take his place. The",
      "man that returns comes back disabled",
	  "and exhausted, but is not killed.",
      "",
      "Artist: Setouchi",
    ],
    197 => [
      "A butterfly monster who attends the",
      "Magic Academy. She is learning magic",
      "every day and has high magical power",
      "for an insect monster. Her magical",
      "skills are unrefined however, and",
      "are still in the process of",
      "developing. She admires Mephisto,",
      "the head of the Magic Academy, and",
      "shares a strong bond with the rest",
      "of her classmates.",
      "",
      "She usually never leaves the",
      "academy, so she looks forward to",
      "playing with any men who are",
      "brought in as lesson materials or",
      "food. When men are made into",
      "lesson materials, they are",
      "thoroughly toyed with until their",
      "semen runs dry. Men who are brought",
      "to the academy usually don't get",
      "squeezed to death and are released",
      "as soon as mealtime and lessons are",
      "over. However, men who trespass upon",
      "the academy grounds may be kept as",
      "prisoners.",
      "",
      "Artist: Shimpi",
    ],
    198 => [
      "A dragonfly monster who attends the",
      "Magic Academy. She is learning magic",
      "every day and has high magical power",
      "for an insect monster. Her magical",
      "skills are unrefined however, and",
      "are still in the process of",
      "developing. She admires Mephisto,",
      "the head of the Magic Academy, and",
      "shares a strong bond with the rest",
      "of her classmates.",
      "",
      "She usually never leaves the",
      "academy, so she looks forward to",
      "playing with any men who are",
      "brought in as lesson materials or",
      "food. When men are made into",
      "lesson materials, they are",
      "thoroughly toyed with until their",
      "semen runs dry. Men who are brought",
      "to the academy usually don't get",
      "squeezed to death and are released",
      "as soon as mealtime and lessons are",
      "over. However, men who trespass upon",
      "the academy grounds may be kept as",
      "prisoners.",
      "",
      "Artist: Shimpi",
    ],
    199 => [
      "A ladybug monster who attends the",
      "Magic Academy. She is learning magic",
      "every day and has high magical power",
      "for an insect monster. Her magical",
      "skills are unrefined however, and",
      "are still in the process of",
      "developing. She admires Mephisto,",
      "the head of the Magic Academy, and",
      "shares a strong bond with the rest",
      "of her classmates.",
      "",
      "She usually never leaves the",
      "academy, so she looks forward to",
      "playing with any men who are",
      "brought in as lesson materials or",
      "food. When men are made into",
      "lesson materials, they are",
      "thoroughly toyed with until their",
      "semen runs dry. Men who are brought",
      "to the academy usually don't get",
      "squeezed to death and are released",
      "as soon as mealtime and lessons are",
      "over. However, men who trespass upon",
      "the academy grounds may be kept as",
      "prisoners.",
      "",
      "Artist: Shimpi",
    ],
    200 => [
      "A fairy who attends the Magic",
      "Academy. She is a senior student",
      "whose magical power is greater than",
      "the insects in the lower class. In",
      "addition she is much more skilled",
      "with magic and is close to",
      "graduating. She admires Mephisto,",
      "the head of the Magic Academy, and",
      "shares a strong bond with the rest",
      "of her classmates.",
      "",
      "She usually never leaves the",
      "academy, so she looks forward to",
      "playing with any men who are",
      "brought in as lesson materials or",
      "food. When men are made into",
      "lesson materials, they are",
      "thoroughly toyed with until their",
      "semen runs dry. Men who are brought",
      "to the academy usually don't get",
      "squeezed to death and are released",
      "as soon as mealtime and lessons are",
      "over. However, men who trespass upon",
      "the academy grounds may be kept as",
      "prisoners.",
      "",
      "Artist: Shimpi",
    ],
    201 => [
      "An elf who attends the Magic",
      "Academy. She is a senior student",
      "whose magical power is greater than",
      "the insects in the lower class. In",
      "addition she is much more skilled",
      "with magic and is close to",
      "graduating. She admires Mephisto,",
      "the head of the Magic Academy, and",
      "shares a strong bond with the rest",
      "of her classmates.",
      "",
      "She usually never leaves the",
      "academy, so she looks forward to",
      "playing with any men who are",
      "brought in as lesson materials or",
      "food. When men are made into",
      "lesson materials, they are",
      "thoroughly toyed with until their",
      "semen runs dry. Men who are brought",
      "to the academy usually don't get",
      "squeezed to death and are released",
      "as soon as mealtime and lessons are",
      "over. However, men who trespass upon",
      "the academy grounds may be kept as",
      "prisoners.",
      "",
      "Artist: Shimpi",
    ],
    202 => [
      "A succubus who attends the Magic",
      "Academy. She is a senior student",
      "whose magical power is greater than",
      "the insects in the lower class. In",
      "addition she is much more skilled",
      "with magic and is close to",
      "graduating. She admires Mephisto,",
      "the head of the Magic Academy, and",
      "shares a strong bond with the rest",
      "of her classmates.",
      "",
      "She usually never leaves the",
      "academy, so she looks forward to",
      "playing with any men who are",
      "brought in as lesson materials or",
      "food. When men are made into",
      "lesson materials, they are",
      "thoroughly toyed with until their",
      "semen runs dry. Men who are brought",
      "to the academy usually don't get",
      "squeezed to death and are released",
      "as soon as mealtime and lessons are",
      "over. However, men who trespass upon",
      "the academy grounds may be kept as",
      "prisoners.",
      "",
      "Artist: Shimpi",
    ],
    203 => [
      "A confidant of Alipheese the",
      "Fifteenth who is also serving as",
      "Grand Noah's magic advisor. Wielding",
      "very powerful magic, she knows",
      "spells from all eras and regions.",
      "Her true form is that of an evil",
      "serpent, and is extremely formidable",
      "in combat. She is also very cruel",
      "and will swallow her prey alive.",
      "Anyone who angers her will have",
      "their semen squeezed as she preys",
      "upon them.",
      "",
      "She is very cunning and methodical,",
      "but there is one aspect of her that",
      "deeply values ancient Yoma",
      "traditions, and she is very",
      "respectful of contracts and",
      "commitments. It appears Mephisto's",
      "devotion to a contract sometimes",
      "exceeds even her own loyalties.",
      "",
      "Artist: Shimpi",
    ],
    204 => [
      "An insect monster strongly",
      "resembling a praying mantis. A",
      "carnivorous monster that eats not",
      "only other monsters, but human",
      "beings as well. Their favorite food",
      "however is male semen, and will both",
      "use them for reproduction and",
      "feeding. Due to their unique insect-",
      "based vagina, any male caught by",
      "them will be enraptured in the",
      "unique sensations. After forcing her",
      "prey to multiple ejaculations and",
      "weakening them, they will then",
      "usually eat their mate.",
	  "",
      "However, when the mantis chooses a",
      "mate for reproductive purposes, she",
      "won't eat them. After she has been",
      "inseminated, she will lay her eggs",
      "on the male's body. The eggs will in",
	  "turn stimulate the man, forcing him",
	  "to multiple ejaculations, providing",
	  "nourishment for the newborns. Like",
	  "this, the male is used as a tool for",
	  "reproduction all the way until their",
	  "birth. Once captured, the male will",
	  "be kept as a reproductive tool for",
	  "the rest of his life.",
      "",
      "Artist: Setouchi",
    ],
    205 => [
      "An insect monster with the",
      "characteristics of a silkworm.",
      "Capable of spraying sticky silk from",
      "her abdomen, she rolls up her prey",
      "in a cocoon. As her silk is able to",
      "infuse the prey with sexual pleasure",
      "by mere contact, they will be",
      "brought to climax over and over.",
      "Capable of absorbing semen through",
      "the silk itself, the Silkworm Girl",
      "is able to obtain nourishment.",
	  "",
      "Wrapped in the cocoon and in a",
      "trance of ecstasy, the man is made",
      "to be both incontinent and forced to",
	  "ejaculate over and over. Every fluid",
	  "forced out by the cocoon is able to",
	  "be turned into nutrients by the",
	  "Silkworm Girl. In addition, the",
	  "cocoon is capable of keeping the",
	  "prey inside alive, making it an",
	  "effective, long-lasting source of",
	  "nourishment.",
      "",
      "Artist: Setouchi",
    ],
    206 => [
      "A plant monster of the Alraune",
      "species. Though capable of living",
      "through photosynthesis, she prefers",
      "to consume male semen. Using her",
      "soft petals to embrace the man, she",
      "is able to suck out his energy. As",
      "their energy is sucked, most men",
      "also ejaculate. In that way, they",
      "can suck out semen as nourishment.",
      "Kept in place by both her embrace",
      "and her ivy, the man is forced",
      "to orgasm over and over.",
      "",
      "Though she appears kind, many often",
      "suck men to death. A particularly",
      "greedy monster, they are dangerous",
	  "due to the chance of death.",
      "",
      "Artist: Delphinus",
    ],
    207 => [
      "A plant monster of the Alraune",
      "species. With a small amount of",
      "dryad blood in her, she has taken a",
	  "unique appearance.",
	  "",
      "She obtains her nourishment through",
      "the roots on the plant part of her",
      "body. As the roots wrap around a",
      "man's genitals, the stimulation",
      "forces them to ejaculate. In this",
	  "method, many men are sucked",
	  "completely dry.",
      "",
      "In addition, if they particularly",
      "like their prey, she is known to",
      "forcibly assimilate with him.",
      "Leaving the man's will and",
      "consciousness intact, their bodies",
      "unify as one. The body is completely",
	  "under Alra Rooty's control, and is",
	  "used as little more than a source of",
	  "semen.",
      "",
      "Artist: Delphinus",
    ],
    208 => [
      "A plant monster of the Alraune",
      "species. An unusual plant that only",
      "eats meat, she uses the mouth's on",
      "the end of her ivy to devour her",
      "prey. She is capable of",
	  "photosynthesis, but the energy",
	  "obtained is inefficient.",
      "",
      "If her prey is a man, she doesn't",
      "neglect to milk his semen first. Her",
      "mouth is capable of stimulating the",
      "man's penis, forcing him to come",
      "inside her predation organ. While",
      "forcing him to ejaculate, she will",
	  "swallow him alive.",
      "",
      "A cold-blooded monster, she enjoys",
      "watching her prey's agonized face as",
      "she eats him alive. She will",
      "sometimes very slowly swallow the",
      "man, harshly playing with her food",
	  "more than is necessary.",
      "",
      "Artist: Delphinus",
    ],
    209 => [
      "A plant monster that has many",
      "characteristics similar to a",
      "mushroom. Though it appears as",
      "though she's wearing clothes, it is",
      "in fact just her fungal body. Her",
	  "used to shield her from direct",
	  "sunlight.",
      "",
      "Since her staple food is semen, she",
      "will use her fungi to cover the",
      "man's penis to extract it. If she",
      "particularly likes the man, she will",
      "draw his body into her own, and add",
      "him to her seedbed. The man is",
      "forced to ejaculate over and over,",
      "fertilizing her fungal body. Since",
	  "his body is made into part of Alra",
	  "Parasol's, he won't die until the",
	  "host body dies.",
      "",
      "In addition, Alra Parasol's body is",
      "constantly changing due to the",
      "mushrooms grown from her seedbed.",
      "This makes her method of",
	  "reproduction different from other",
	  "monsters.",
      "",
      "Artist: Delphinus",
    ],
    210 => [
      "A plant monster that has a huge",
      "flower as part of her body. She can",
      "freely control the flower attached to",
      "her body, and uses it as a cage to",
      "keep her prey locked inside, thus",
      "gaining her name. Locked inside her",
      "prison, the man will be attacked by",
      "countless branches of ivy. With all",
      "four limbs bound, the man is",
      "helplessly milked inside her prison.",
	  "",
      "Like this, she can trap the man",
      "inside of her forever, using him to",
      "supply her with semen. Essentially",
      "becoming a part of her body, he is",
	  "kept inside of her until his natural",
	  "lifespan is over. Until then, he",
	  "will be bound and squeezed for his",
	  "semen by the ivy continuously.",
      "",
      "Artist: Delphinus",
    ],
    211 => [
      "An Alraune that has many",
      "characteristics similar to a",
      "mushroom. She grows from spores and",
      "is able to expand her body",
      "endlessly. Communicating with her is",
      "very difficult due to her strange",
      "voice and laughter. However, she",
      "appears to be very joyful.",
      "",
      "When she captures a healthy man, she",
      "will wrap her body around him and",
      "use him as her seedbed. In exchange",
      "for pleasure, he will be used to",
      "continue supplying her with",
      "nourishment. People who become",
      "seedbeds are sucked endlessly for",
      "nourishment until they eventually",
      "perish and decay, in which case",
      "Alra Shroom will search for a new",
      "seedbed.",
      "",
      "Artist: Delphinus",
    ],
    212 => [
      "A plant monster, she is also the",
      "youngest Canaan Sister. Taking after",
      "a venus flytrap, she is quite",
      "partial to the taste of meat. She",
      "particularly enjoys playing with",
      "human males as she slowly digests",
      "them, taunting and forcing them to",
      "ejaculate all the while. The sticky",
      "juices around her body allow her to",
      "start digesting her prey before she",
      "even swallows him. The pleasure",
      "received when dissolved by her",
      "juices is unbearable, forcing men to",
	  "numerous orgasms as they begin to be",
	  "digested. Due to her cruelty, she",
	  "has eaten many men this way.",
      "",
      "In addition to humans, she also eats",
      "insect monsters in the same way.",
      "During the war in Plansect Village,",
      "she is feared by the insects due to",
	  "the amount of their brethren she has",
	  "eaten.",
      "",
      "Artist: Setouchi",
    ],
    213 => [
      "A plant monster resembling a pitcher",
      "plant, she is also the middle Canaan",
      "Sister. She drops her prey into her",
      "large pitcher, filled with digestive",
      "juices, and slowly dissolves them.",
      "The lukewarm juices overpower the",
      "prey with ecstasy, forcing them to",
      "even begin to desire being dissolved",
      "inside her pitcher. Most men are",
      "also forced to orgasm inside her",
      "pitcher, providing her with even",
      "more nutrients. Sometimes Raffia will",
      "even use a small pitcher to squeeze",
      "semen from the prey currently being",
      "dissolved.",
	  "",
	  "Eating both man and insect alike,",
	  "she is a very dangerous monster.",
      "",
      "Artist: Setouchi",
    ],
    214 => [
      "A plant monster, she is also the",
      "oldest Canaan Sister. Her hair is a",
      "predation organ capable of",
      "dissolving both humans and insect",
      "monsters. She eats her prey in an",
      "almost businesslike manner, quickly",
      "eating them so she can return to",
      "more important tasks. Looking at the",
	  "prey with bored eyes, she will watch",
	  "them slowly dissolve in her organ.",
      "",
      "The Canaan Sisters constantly roam",
      "about, looking for fights to take",
      "part in so that they can feed. Due",
      "to their mercenary lifestyle, they",
      "are more powerful than normal plant",
      "monsters. Traveling to Plansect",
	  "Village, they volunteered to assist",
	  "the plant monsters in the war.",
      "",
      "Artist: Setouchi",
    ],
    215 => [
      "A plant monster that's also the",
      "leader of the Plantforest plant",
      "race. Though she is powerful enough",
      "to be called leader, she is not as",
	  "strong as the mercenary Canaan",
	  "Sisters.",
      "",
      "Though she speaks politely, she is",
      "extremely prideful, and considers",
      "herself above touching men. When",
      "squeezing men for semen, she prefers",
	  "using either her feet or ivy, so as",
	  "not to dirty herself.",
      "",
      "In addition, she is heartless",
      "towards those she considers enemies.",
      "If the enemy is a human male, she",
      "will squeeze out his semen until he",
      "dies. Despite her appearance as a",
	  "little girl, she is quite brutal.",
      "",
      "Artist: Delphinus",
    ],
    216 => [
      "A monster living in Plansect",
      "Village. Though they are mostly",
      "nocturnal, they are sometimes active",
      "as early as noon. However, most of",
      "them attack men at night to suck",
      "their semen. Holding powerful",
      "pheromones in her scales, once a man",
      "breathes them in, he gladly becomes",
      "the Moth Girl's captive. Once",
      "entranced, the Moth Girl will insert",
      "the man's penis into her lower mouth",
      "and suck out his semen.",
	  "",
      "Like other monsters of the insect",
      "types, the Moth Girl's vaginas are",
      "very unique in structure. Tiny hairs",
      "line her warm vagina, along with",
      "unique creases and bends, capable of",
	  "forcing men to orgasm nearly",
	  "instantly. She generally uses the",
	  "semen as food, but will use the",
	  "semen for reproductive purposes in",
	  "the breeding season.",
      "",
      "Artist: Delphinus",
    ],
    217 => [
      "An insect monster that lives in",
      "Plansect Village. She sucks human",
      "blood, but her favorite food is",
	  "human semen.",
	  "",
      "Her straw-like tongue can slip into",
      "a man's urethra and directly suck",
      "out his semen. In addition, she can",
      "also use the vagina at the end of",
      "her abdomen to mate with the man",
	  "normally. Her unique sucking",
	  "abilities give the man an",
	  "unparalleled sense of release.",
      "",
      "Considering men to be nothing but",
      "simple prey, they are known to suck",
      "men to death. Due to her",
	  "cold-blooded nature, she is",
	  "considered a very dangerous monster.",
      "",
      "Artist: Delphinus",
    ],
    218 => [
      "An insect monster that resembles a",
      "green caterpillar. Her primary",
      "method of feeding is to immobilize",
      "her prey with her sticky silk, and",
      "then sucking out his semen. She can",
      "absorb the semen through her silk,",
      "or use her mouth to suck out his",
      "semen.",
	  "",
      "Once she has enough nourishment, she",
      "can go into the pupa stage. Since",
      "she sucks out semen for the purpose",
      "of storing nourishment for this",
	  "stage, it's rare for her to suck a",
	  "man to his death. It is unknown what",
	  "kind of insect she will become until",
	  "she grows bigger...",
      "",
      "Artist: Delphinus",
    ],
    219 => [
      "An insect monster of the bee type.",
      "With the Queen at the top of their",
      "social structure, she is part of the",
      "lowly soldier class. With her body",
      "made for combat, her durable",
      "exoskeleton and powerful muscles",
      "make her a formidable foe. Though",
	  "she's primarily a meat-eater, she",
	  "is also able to live off honey.",
      "",
      "As the Queen is the only fertile",
      "member of the group, the worker and",
      "soldier types cannot breed. Because",
      "of that, all captured men are handed",
      "over to the Queen. If the man does",
      "not satisfy the Queen, he is made",
      "into a sex slave for the rest of the",
      "hive. Though she's barren, she still",
      "has a powerful sexual drive. Any",
      "captured man will be gladly raped",
      "to satisfy their desire. Used as an",
      "outlet for their sexual desire, the",
      "man will be kept as a sex slave for",
	  "the hive until his death.",
      "",
      "Artist: Thomas",
    ],
    220 => [
      "Queen of the hive, she is also the",
      "leader of the insect race in",
      "Sectforest. Entrusting all other",
      "tasks to the other bees in the hive,",
      "she focuses mainly on breeding. If",
      "the hive was a single organism, she",
      "would be equivalent to the genitals.",
	  "",
      "All men captured by any of the",
      "worker or soldier bees are handed",
      "over to the Queen. If she likes him,",
      "then he becomes a tool used in her",
      "breeding. Forced to continually mate",
      "with her, the exquisite genitals",
      "held by the Queen force him to",
	  "repeated ejaculations. Treated as",
	  "little more than a tool to breed",
	  "with, the forced mating can continue",
	  "for days without rest. Like this,",
	  "the Queen can be fully inseminated.",
      "",
      "After the forced mating has",
      "finished, the man is not freed.",
      "Forcibly fed special honey produced",
      "by the bees, he is kept alive for",
	  "many future breeding sessions.",
      "",
      "Artist: Thomas",
    ],
    221 => [
      "A jaguar monster that existed in",
      "ancient times. She boasts a tough",
      "body and enormous magical power,",
      "and was once revered as a god by",
      "the people of the ancient jungle.",
      "She was sealed away by angels under",
      "the command of Ilias and her",
      "traditions were buried from history.",
      "",
      "Carefree and tomboyish, people find",
      "her personality charming. When she",
      "finds a man, she assaults him in a",
      "sexual frenzy. If she likes the man,",
      "she will force him to mate with her.",
      "",
      "She engages in a rivalry with",
      "Quetzalcoatl, who was also",
      "worshiped in the same region, and",
      "are always in conflict regardless of",
      "the situation. The day when the two",
      "reconcile will never come.",
      "",
      "Artist: UN_DO",
    ],
    222 => [
      "A giant serpentine monster that",
      "existed in ancient times. She is of",
      "an ancient species similar to snake",
      "and dragon monsters, and is also the",
      "ancestor to bird monsters. With her",
      "divine appearance and tremendous",
      "power, she was once revered as a god",
      "by the people of the ancient jungle.",
      "She was sealed away by angels under",
      "the command of Ilias and her",
      "traditions were buried from history.",
      "",
      "She combines bravery and maternity",
      "at the same time, for while she will",
      "mercilessly defeat any man who",
      "challenges her, she will also spoil",
      "the defeated man with compassion.",
      "She will mate with the men she",
      "considers her favorite and force",
      "them to dedicate their semen to her",
      "vagina.",
      "",
      "She engages in a rivalry with",
      "Tezcatlipoca, who was also",
      "worshipped in the same region, and",
      "are always in conflict regardless of",
      "the situation. The day when the two",
      "reconcile will never come.",
      "",
      "Artist: UN_DO",
    ],
    223 => [
      "An unknown Seraphim whose existence",
      "has not been recorded. Equipped with",
      "mechanical weapons throughout her",
      "entire body, she specializes in",
      "annihilating foreign enemies. She",
      "appears to be a mechanical being,",
      "but further details are unknown.",
      "",
      "Artist: xelvy",
    ],
    224 => [
      "An unknown Seraphim whose existence",
      "has not been recorded. Expressing a",
      "firm and aggressive personality, her",
      "fighting capabilities are extremely",
      "high. She seems to be hostile",
      "towards the three Lilith Sisters,",
      "but further details are unknown.",
      "",
      "Artist: UN_DO",
    ],
    225 => [
      "A sticky monster of the slime race.",
      "But due to her high elasticity, her",
      "body is almost more jelly-like than",
      "slime-like. She has a calm",
      "personality, and is simple-minded.",
      "But due to her sticky body, a common",
      "warrior would be unable to escape her",
	  "grasp if caught. If that happens, he",
	  "has no choice but to helplessly let",
	  "her prey on him.",
      "",
      "She enjoys human semen as much as",
      "other slimes. Able to control her",
      "sticky body at will, no man can resist",
      "an orgasm if she wants him to.",
      "Unexpectedly greedy, she will never",
      "allow her prey to escape once caught.",
      "Due to the ease of being caught in her",
	  "sticky body until death, great care",
	  "should be taken around her.",
      "",
      "Artist: Setouchi",
    ],
    226 => [
      "A carnivorous monster of the slime",
      "race. The Blob Girl herself is made up",
      "of digestive juices. Any prey who's",
      "taken into her body will never escape.",
      "As the man is stuck inside of her",
      "body, his semen is squeezed out while",
      "he's slowly digested.",
      "",
      "Her tone is light and friendly, but",
      "she's extremely brutal. She seems to",
      "get sadistic pleasure from dissolving",
      "and feeding on men. She rarely wanders",
      "outside of her habitat, but is",
	  "extremely dangerous.",
      "",
      "Artist: Setouchi",
    ],
    227 => [
      "A slime monster composed of a green",
      "liquid. Though she has no special",
      "characteristics, her magic power",
      "allows her to spread out her body",
      "to encompass a huge area. Though her",
      "body is stickier than other slimes,",
      "her personality is similar.",
	  "",
      "Feeding on the same staple food as",
      "other slimes, semen, she will wrap up",
      "the man in her sticky slime, and",
      "force him to ejaculate to feed on",
      "it. She will not squeeze him to his",
	  "death, but will keep the man as her",
	  "possession for exclusive use.",
      "",
      "In the slime race, there are those who",
      "wish to remain alone, and those who",
      "prefer to be in groups. The Green",
      "Slime is of the latter group. Due to",
	  "this, she is a troublesome foe due to",
	  "her likelihood of calling friends to",
	  "assist her if things aren't going her",
	  "way.",
      "",
      "Artist: UN_DO",
    ],
    228 => [
      "A slime monster with a red body. She",
      "has a lively personality, and hates to",
      "lose. She loves everything to do with",
      "anal sex, but is quite timid when it",
	  "comes to more simple things.",
      "",
      "Her body is much warmer than other",
      "slimes, bringing men an incredibly",
      "relaxing sensation when inside her.",
      "Due to her overconfident personality,",
      "she is known to squeeze semen from men",
	  "until they're almost dead from",
	  "exhaustion.",
      "",
      "Artist: UN_DO",
    ],
    229 => [
      "A slime monster with a quiet",
      "personality. Very elastic and sticky,",
      "her blue body has a unique feel to it.",
	  "",
      "She prefers to attack men in groups",
      "instead of being alone. The Blue Slime",
      "is the type to join in when other",
      "slimes are attacking a man, unwilling",
      "to be the one to initiate. But that's",
      "just a quirk of her personality, and",
      "not due to being any less powerful",
      "than other slimes.",
      "",
	  "While other slimes prefer to focus on",
	  "the man's groin area, she seems oddly",
	  "fixated on nipples.",
	  "",
      "Artist: UN_DO",
    ],
    230 => [
      "Formed out of purple slime, she's a",
      "leader-like slime that lives in",
      "Undine's Spring. With the ability to",
      "communicate with Erubetie, she leads",
      "the slime girls when Erubetie is",
	  "absent.",
      "",
      "Her staple food is male semen, and she",
      "prefers to attack in a group. In",
      "addition to her body being extremely",
      "sticky, she is able to jiggle her body",
      "with great intensity. Using those two",
	  "properties, she is able to skillfully",
	  "use her body to force men to ejaculate.",
      "",
      "Prey caught by her will not be allowed",
      "to die. She, along with her group,",
      "will keep them captive, squeezing out",
      "his semen until the end of his natural",
      "life.",
      "",
      "Artist: UN_DO",
    ],
    231 => [
      "A spirit who resides in a cave under",
      "Undine's Spring, out of view of the",
      "rest of the world. A long time ago it",
      "seems as though she appeared before",
	  "humans, but now she's a shut-in.",
	  "",
      "Hating the humans who pollute the",
      "waters of the world, she mercilessly",
      "preys on any who dare enter her",
      "terrain. Absorbing them into her body,",
      "she assimilates their body to become",
	  "one with hers.",
      "",
      "Though she dislikes humans, she seems",
      "to hold regrets that humans and",
      "monsters aren't existing in peace as",
      "they did in the past. A close friend",
      "of the Queen Slime, Erubetie, they",
	  "treat each other as equals. They also",
	  "seem not to interfere with each",
	  "other's dealings.",
      "",
      "Artist: frfr",
    ],
    232 => [
      "The Queen Slime and one of the Four",
      "Heavenly Knights of the Monster Lord's",
      "army, she boasts top-class vitality",
      "among all monsters. In actuality, she",
      "is a colony lifeform with a single",
      "will, comprised of over 10,000 slimes,",
      "spirits, and other monsters. Most of",
      "them fused with Erubetie willingly, but",
      "some were attacked and taken in against",
      "their will. She has become a collective",
      "entity that no longer falls under the",
      "categorization of slime-type monsters.",
      "That Erubetie is able to maintain a",
      "firm will under those circumstances is",
      "solely due to her own high aptitude for",
      "group control.",
      "With that said, she only takes the",
      "wills of females into her colony. Male",
      "wills are apparently incompatible with",
      "her, and she will only absorb and",
      "dissolve their flesh.",
      "",
      "She can divide and expand herself",
      "freely, and the attacks from her",
      "viscous body are unpredictable. She is",
      "also able to freely wield the power of",
      "water. It's even possible for her to",
      "expand her own body all at once and",
      "create a gigantic tsunami of slime.",
      "",
      "Artist: Kenkō Cross",
    ],
    233 => [
      "An insect monster taking after an ant.",
      "Very closely related to the Hornet",
      "Girl, they share many characteristics.",
      "Part of a class-based society, they",
      "are servants to their Queen. All men",
      "they capture are offered to their",
      "Queen first. Any man rejected by her",
      "is handed over to be used as the Ant",
	  "Girls group sex slave. Of course since",
      "they are not fertile, they only rape",
	  "the man for their own pleasure.",
      "",
      "Artist: Thomas",
    ],
    234 => [
      "An artificial monster created by magic",
      "science with no will of its own, used",
      "for sexual play. Her thought circuits",
      "are vastly superior to other",
      "artificially created monsters, but she",
      "still has no individual will.",
      "Programmed with expert-level sexual",
      "techniques, her sexual skills far",
      "surpass any prostitute's. However due",
	  "to the high cost of production, there",
	  "exist only a few located in luxury",
	  "hotels.",
      "",
      "With her vagina specially created by",
      "the most advanced magic science",
      "available, the texture and sensations",
      "are at a level impossible for a normal",
      "human to compare to. In addition, the",
	  "special material will never stretch or",
	  "be damaged no matter how much it's",
	  "used. In addition, both her hand and",
	  "mouth are able to bring any man to a",
	  "quick and powerful orgasm.",
      "",
      "Of course, her source of power is",
      "semen. Due to her role, energy is",
      "never in short supply.",
      "",
      "Artist: UN_DO",
    ],
    235 => [
      "An inexpensive type of automatic",
      "doll for sexual service, designed",
      "exclusively for paizuri. She is",
      "equipped with a rather minimal self-",
      "defense function and has built-in",
      "firearms to protect herself. Her",
      "thought patterns are very simple and",
      "she cannot speak, but she appears to",
      "be capable of communicating with her",
      "own will.",
      "",
      "In her abnormal state, she is",
      "pressing her plump breasts against",
      "things regardless of what they are.",
      "When a male penis is confirmed",
      "between them, she will commence the",
      "paizuri. No matter how many times",
      "you ejaculate, she will not stop,",
      "squeezing away endlessly. Since she",
      "is out of control, she will not",
      "release the man, making her",
      "extremely dangerous. In addition, it",
      "seems sales to general households at",
      "a low price are almost here.",
      "",
      "Artist: Cool-kyou Shinja",
    ],
    236 => [
      "A very famous monster whose lower body",
      "is comprised of multiple tentacles.",
      "Various types exist, but this specific",
      "one's tentacles resemble an octopus's.",
      "with her multiple tentacles, she can",
      "both bind the male's body and squeeze",
      "his semen at the same time.",
	  "",
      "She generally only uses her tentacles",
      "to force men to cum. Able to",
      "skillfully coil her tentacles around",
	  "his penis, the Scylla can easily force",
	  "any man to ejaculate. Due to the soft,",
	  "elastic sensations of her tentacles,",
	  "there has been no case of a man being",
	  "able to resist her once captured.",
      "",
      "If a male with high-quality genes is",
      "found, they are known to force them",
      "to mate. Using her tentacles, she can",
      "manipulate the man's body to insert",
      "himself into her, and keep him from",
      "escaping. With additional tiny",
      "tentacles in her vagina designed for",
	  "mating, the intense pleasure allows",
	  "her to easily breed with her captured",
	  "male.",
      "",
      "Artist: masha",
    ],
    237 => [
      "A famous monster with snakes for hair.",
      "A gaze from her magic eyes can also",
      "turn anyone to stone. Using this",
      "power, they are known for playing with",
      "men as they slowly turn them to stone.",
      "Since they have to both feed their",
      "snake hair and maintain their own high",
      "magic power, they require lots of",
      "semen. Due to that, they are always",
      "hungry for more men to play with.",
	  "Utilizing both her own body and her",
	  "snake hair, she will do everything she",
	  "can to force the male to feed her.",
      "",
      "In addition, if she finds a man she",
      "likes she may just rape him for fun.",
      "With tiny feelers inside her vagina",
      "that are similar to her snake hair,",
	  "no man is able to resist her for long.",
      "",
      "Artist: masha",
    ],
    238 => [
      "A giant butterfly youkai living in",
      "the Noah region. Although she looks",
      "like a delicate girl, she has a",
      "tough body typical among most insect",
      "monsters, and is also versed in",
      "Taoism. She is generally friendly",
      "towards humans and frequently goes",
      "in and out of towns and villages.",
      "",
      "She usually collects honey by",
      "sucking it with a proboscis, but",
      "occasionally she will suck a human's",
      "semen for a meal. She attracts men",
      "using her vibrant wings and",
      "glittering kimono to lure them",
      "close enough for her to suck them.",
      "Despite her gentle personality, she",
      "is quite greedy and often sucks men",
      "to exhaustion.",
      "",
      "Artist: Irodori",
    ],
    239 => [
      "A subspecies of slime whose entire",
      "body is composed of poison. Living",
      "in a poisonous swamp for a long time",
      "has caused her body to incorporate",
      "its toxins, giving her a viscous",
      "body of poison. Naturally, due to",
      "the poison spreading around her,",
      "only zombies and poison-resistant",
      "monsters can approach her. She tends",
      "to be isolated because of this,",
      "which has caused her personality to",
      "become warped.",
      "",
      "When she finds a man, she wraps him",
      "up to immobilize him with her",
      "poison. The man's body will quickly",
      "become paralyzed once covered in her",
      "poisonous slime as she proceeds to",
      "squeeze out his semen. She will",
      "sometimes squeeze her prey until",
      "he dies from weakness, making her a",
      "very dangerous monster.",
      "",
      "Artist: SugaMon",
    ],
    240 => [
      "A type of zombie that lives in a",
      "poisonous swamp. The surface of her",
      "body is covered in a sticky mucus",
      "membrane that drips off of her body.",
      "Since her mucus contains toxic",
      "elements, it has the effect of",
      "weakening those who touch it.",
      "While she is slow, she is incredibly",
      "strong, and if she presses down on",
      "someone, it is impossible to escape",
      "from her with human strength alone.",
      "",
      "Her staple diet is human semen, and",
      "when she sees a man, she will push",
      "him down and force him into her.",
      "Those who connect with a Warmer get",
      "covered with her sticky, poisonous",
      "mucus, causing them to writhe in",
      "agonizing pleasure. In most cases,",
      "the Warmer will continue to violate",
      "the man until he is exhausted. She",
      "is a very dangerous monster who",
      "thinks of humans as just food.",
      "",
      "Artist: Shimpi",
    ],
    241 => [
      "Corpses of women reanimated and",
      "given a will by the accumulation",
      "of magic. While they appear to have",
      "lost most of their reason, they are",
      "able to act in a group. They move",
      "very slowly, but are quite powerful",
      "and crowd around men to attack them.",
      "",
      "A man attacked by a group of Ghouls",
      "will get piled on and raped by them",
      "with no chance of escape. The Ghouls",
      "will take turns gang-raping the man,",
      "mercilessly violating him until he",
      "is completely exhausted.",
      "",
      "Artist: Shimpi",
    ],
    242 => [
      "Corpses of women reanimated and",
      "given a will by the accumulation",
      "of magic. While they appear to have",
      "lost most of their reason, they are",
      "able to act in a group. They move",
      "very slowly, but are quite powerful",
      "and crowd around men to attack them.",
      "",
      "A man attacked by a group of Ghouls",
      "will get piled on and raped by them",
      "with no chance of escape. The Ghouls",
      "will take turns gang-raping the man,",
      "mercilessly violating him until he",
      "is completely exhausted.",
      "",
      "Artist: Shimpi",
    ],
    243 => [
      "Corpses of women reanimated and",
      "given a will by the accumulation",
      "of magic. While they appear to have",
      "lost most of their reason, they are",
      "able to act in a group. They move",
      "very slowly, but are quite powerful",
      "and crowd around men to attack them.",
      "",
      "A man attacked by a group of Ghouls",
      "will get piled on and raped by them",
      "with no chance of escape. The Ghouls",
      "will take turns gang-raping the man,",
      "mercilessly violating him until he",
      "is completely exhausted.",
      "",
      "Artist: Shimpi",
    ],
    244 => [
      "A jellyfish monster that imitates",
      "humans for fun. She usually wanders",
      "around the sandy beaches, but",
      "occasionally shows up in human",
      "cities as well.	They are mostly",
      "friendly, and the clothes they wear",
      "are purchased in towns. Due to her",
      "yearning for the life and culture",
      "of humans, she started to dress",
      "like them.",
      "",
      "While she is walking around the",
      "beach, she may catch men if they",
      "approach her inadvertently.",
      "Restraining him with her hidden",
      "tentacles, she will squeeze out",
      "semen through cohesion with her",
      "soft body. However, because she is",
      "typically friendly, she won't",
      "deprive him of his life. The man",
      "she caught will be safely released",
      "after she has squeezed out all of",
      "his semen.",
      "",
      "Artist: Irodori",
    ],
    245 => [
      "A greater harpy species that is",
      "stronger than the average, her large",
      "wings enable her to fly at high",
      "speeds over long distances. Like",
      "most other members of the harpy",
      "race, she is generally friendly",
      "towards humans. Although the Wing",
      "Harpy is quiet and gives the",
      "impression of being unsociable,",
      "she isn't hostile and seems to treat",
      "the people she is intimate with",
      "gently.",
      "",
      "Like most other harpies, she enjoys",
      "mating with humans and will",
      "forcibly violate any man she",
      "captures. Using her renowned vagina",
      "filled with many creases and folds,",
      "men inserted into her will ejaculate",
      "many times while tasting exquisite",
      "pleasure. In most cases she will",
      "release the man after some brief",
      "enjoyment, but she may make him her",
      "husband if she takes a liking to",
      "him.",
      "",
      "Artist: frfr",
    ],
    246 => [
      "A knight-type harpy that wears light",
      "armor and wields combat skills. Rare",
      "among her race, she has a serious",
      "and straight-laced personality. Her",
      "strength makes up for her inferior",
      "speed compared to other harpies, and",
      "the power of her spear techniques",
      "rival the skills used by warriors of",
      "many races. In her search for strong",
      "opponents, she frequently competes",
      "against warriors from the mermaid",
      "race.",
      "",
      "Despite her stern personality, she",
      "still enjoys having sex with men as",
      "other harpies do. After defeating",
      "a human warrior in combat, she will",
      "forcibly violate him. Her renowned",
      "harpy vagina, with its many folds",
      "and creases, can squeeze the man's",
      "semen until he runs dry. She will",
      "never squeeze men to death, but she",
      "may force the man into marriage if",
      "she likes him.",
      "",
      "Artist: Irodori",
    ],
    247 => [
      "An artificial monster created by the",
      "latest magic science. It does not",
      "have a will of its own and only obeys",
      "the commands given by others. It",
      "appears to assist mainly with",
      "engineering projects within",
      "Grangold.",
      "",
      "Using semen for energy, this",
      "artificial monster will return to a",
      "simple puddle of mud when it runs",
      "out. Resupplying is performed by",
      "wrapping a male's body in her mud,",
      "and stimulating him until his",
      "orgasm. She then absorbs the",
      "ejaculated semen and uses it as a",
      "power source. As the man is never",
      "killed in the process, energy is",
      "resupplied to the Mud Golems on a",
      "volunteer basis.",
      "",
      "A while ago an error was discovered",
      "in her thought circuit that caused",
      "her to go berserk, squeezing random",
      "men's semen to the brink of death.",
      "However she was redesigned, and a",
      "similar incident hasn't happened",
      "since. However, because her thought",
      "circuits are very simple, anyone",
      "possessing high magical power can",
      "interfere with them and cause her",
      "to lose control.",
      "",
      "Artist: Thomas",
    ],
    248 => [
      "An artificial monster created by the",
      "latest magic science. It does not",
      "have a will of its own, and only",
      "obeys her command to protect her set",
      "area and drive out intruders. It was",
      "once used to defend the castle, but",
      "is now being mass-produced and",
      "deployed to defend important bases.",
      "",
      "Where her genitals would be, she is",
      "equipped with a special hole",
      "designed to process male semen. Any",
      "male inserted into her to be used as",
      "a power source will be quickly",
      "drained and left weak. Condemned",
      "prisoners were once used as a power",
      "source for the Golem Girl until",
      "their deaths. However, due to",
      "advancements in magic science,",
      "energy can be supplied by magicians",
      "channeling their own magic directly",
      "into her.",
      "",
      "Artist: frfr",
    ],
    249 => [
      "A variant of the Mantis Girl wearing",
      "a gorgeous flower kimono. She has a",
      "calmer temperament than the typical",
      "Mantis Girl and is friendly towards",
      "humans. She also likes to dance and",
      "her splendid dancing figure has been",
      "frequently sighted. However, her",
      "physical abilities are greater than",
      "a typical Mantis Girl, and she",
      "wields greater magical power than",
      "most members of the insect race.",
      "",
      "While she is friendly towards",
      "humans, if she gets hungry she will",
      "invite a man towards her and assault",
      "him to suck his semen. Sometimes she",
      "will even mate with him using her",
      "fallopian tube and force the man to",
      "impregnate her. She will not eat the",
      "man after mating and in most cases",
      "will let him go, but if she likes",
      "the man, she may force him to marry",
      "her.",
      "",
      "Artist: UN_DO",
    ],
    250 => [
      "A jet-black golem mass-produced by",
      "the latest magic science. She has",
      "high magical power and can be",
      "considered a magician-type golem.",
      "Although the strength of one unit",
      "is inferior to that of the Golem",
      "Girl, she was just as expensive as",
      "she was powerful, so Black Golems",
      "were mass-produced under the orders",
      "of the queen. Her personality is",
      "also very stable, and appears to be",
      "inhabited by the personality of a",
      "somewhat frivolous woman.",
      "",
      "Her energy source is human semen,",
      "and she will bring any intruders she",
      "finds into her body. She absorbs the",
      "semen as it is ejaculated and once",
      "the man has been squeezed dry, she",
      "will effectively carry out predation",
      "by absorbing his body into her own.",
      "Because she is an artificial being,",
      "she has no sense of guilt, and it",
      "has been reported that she has",
      "absorbed many soldiers on the",
      "battlefield.",
      "",
      "Artist: SugaMon",
    ],
    251 => [
      "A type of kitsune who strongly",
      "expresses attributes of the beast",
      "race. While she only has three",
      "tails, she is an honor student from",
      "the fox school who is close to",
      "graduating, and boasts greater",
      "combat ability than the two-tailed",
      "kitsune. Because she is still a",
      "student however, she is socially",
      "inexperienced. She appears to be",
      "going along with the dubious task of",
      "\"the defense of Grangold Castle.\"",
      "",
      "She is very possessive when it comes",
      "to love, and upon seeing a man she",
      "likes, she will forcefully mate with",
      "him. If he ejaculates into her",
      "vagina three times, following the",
      "laws of her family, he must become",
      "married to the Feral Kitsune.",
      "",
      "Artist: Setouchi",
    ],
    252 => [
      "A senior kitsune with three tails",
      "who has mastered ninjutsu and is",
      "working as a kunoichi. Most kitsune",
      "are two-tailed, with three- and",
      "four-tailed being considered elites",
      "among their race. However, the",
      "difference between three tails and",
      "four is small compared to the large",
      "wall separating two tails and three,",
      "so their power is considered to be",
      "almost equal. The same is true for",
      "five- and six-tails, who are said to",
      "be in contact with Nanabi and Yao.",
      "",
      "In addition to her combat expertise",
      "as a ninja, she is also trained in",
      "sexual arts to subdue men. Any man",
      "who tastes the three-tailed",
      "kunoichi's sexual techniques will",
      "be brought to a quick climax and",
      "have their semen squeezed out",
      "rapidly.",
      "",
      "Furthermore, she is only working as",
      "a mercenary to defend Grangold",
      "Castle as her latest job, and is not",
      "a direct subordinate of the queen.",
      "",
      "Artist: Jingai Modoki",
    ],
    253 => [
      "A senior kitsune with four tails who",
      "pursues the art of bushido and is",
      "earnestly training herself. Most",
      "kitsune are two-tailed, with three-",
      "and four-tailed being considered",
      "elites among their race. However,",
      "the difference between three tails",
      "and four is small compared to the",
      "large wall separating two tails and",
      "three, so their power is considered",
      "to be almost equal. The same is true",
      "for five- and six-tails, who are",
      "said to be in contact with Nanabi",
      "and Yao.",
      "",
      "She is proud of her great combat",
      "skills as a samurai, and has also",
      "learned some basic sexual skills.",
      "She will force herself upon any man",
      "she defeats and squeeze out their",
      "semen in the blink of an eye with",
      "her vagina. If she finds the man",
      "suitable for her, she may make him",
      "into her bridegroom.",
      "",
      "She is also learning taoism and is",
      "followed by a kudagitsune.",
      "However, she appears to be more of a",
      "conversation partner and is not very",
      "useful in combat.",
      "",
      "Artist: Jingai Modoki",
    ],
    254 => [
      "A powerful monster that is Queen of",
      "the Ant Girls, she also boasts the",
      "most powerful magic of the insect",
      "monsters. She usually orders her Ant",
      "Girls to do her bidding, and remains",
      "in one place breeding. After finding",
      "a male with high-quality genes, she",
      "will continue to reproduce with him",
      "for a very long time. With her body",
	  "specialized in reproducing, the Queen",
	  "Ant spends three-fourths of her day",
	  "copulating with the man. The other",
	  "fourth is used for sleeping and",
	  "eating. Since breeding is a biological",
	  "imperative for her, she never wants to",
	  "stop.",
      "",
      "Due to her specialization in breeding,",
      "her sexual organs are highly developed",
      "and efficient at extracting semen from",
      "her mate. In addition, she is able to",
      "become pregnant using the semen of any",
      "male creature to ensure the continuity",
      "of her line. But breeding with other",
      "creatures is used only in an",
	  "emergency, as humans produce the",
	  "highest quality offspring.",
      "",
      "Artist: Thomas",
    ],
    255 => [
      "The eldest of the three Lilith",
      "Sisters, who serve the legendary",
      "Great Whore of Babylon. She wields",
      "magical power that is beyond the",
      "compare of monsters in this world,",
      "but its nature is unknown. She is",
      "powerful enough to drain men into",
      "dried fish, but refrains from",
      "actively doing so for some reason.",
      "",
      "Her intentions are unknown, and it",
      "is uncertain why she even appeared",
      "in this world. The only thing that",
      "is certain is that her presence is",
      "affecting the world from behind the",
      "scenes.",
      "",
      "Artist: Shiki",
    ],
    256 => [
      "A monster who lives in a volcano, with",
      "her body comprised mainly of magma. A",
      "subspecies of the Slime family, she is",
      "able to freely manipulate her body.",
	  "",
      "With semen as her energy source, she",
      "wraps the male's body in her magma when",
      "she locates them. Naturally, she",
      "lowers her body temperature so as not",
      "to kill the male. The preferred",
      "temperature is the same as a human",
      "female's vagina. Holding her prey like",
	  "that, she will spin her magma around",
	  "his penis, forcing him to multiple",
	  "orgasms.",
      "",
      "There are very few adventurers who",
      "travel near the volcano, so prey is",
      "extremely precious. Due to that, the",
      "Lava Girl is very careful not to let",
	  "any precious prey die. She will hold",
	  "him inside her body in an area",
	  "equivalent to her womb, and ensure",
	  "he's perfectly safe until his natural",
	  "lifespan runs out.",
      "",
      "Artist: Setouchi",
    ],
    257 => [
      "A greater Lamia who also carries the",
      "power of a Yoma. They rarely appear",
      "around humans and tend to live in",
      "harsh environments like volcanic",
      "caves. In addition to her excellent",
      "physical and magical power, she can",
      "also use demon eye techniques.",
      "",
      "She is surprisingly friendly for a",
      "monster that rarely sees human",
      "visitors, but she has a cruel side",
      "to her and will toy with any men she",
      "captures until they are exhausted.",
      "If she finds his semen to be of high",
      "quality, she will use the rare",
      "opportunity to forcefully mate with",
      "him. If this happens, the man will",
      "never be allowed to escape, and be",
      "forced to endlessly endure the harsh",
      "union.",
      "",
      "Artist: SugaMon",
    ],
    258 => [
      "A greater Scylla who also carries",
      "the power of a Yoma. They rarely",
      "appear around humans and tend to",
      "live in harsh environments like",
      "volcanic caves. Because the Yoma",
      "blood runs deep through her, she",
      "boasts greater physical abilities",
      "than the average Scylla.",
      "",
      "She is surprisingly friendly for a",
      "monster that rarely sees human",
      "visitors, but she has a cruel side",
      "to her and will use her tentacles",
      "to thoroughly play with the genitals",
      "of captured men. In addition to",
      "making them repeatedly ejaculate,",
      "she may force a man to mate with her",
      "if she likes him. The Demon Scylla",
      "will not pass up this opportunity",
      "and will never allow that man to",
      "escape after catching him, forcing",
      "the pitiful man to taste a hell of",
      "tentacles.",
      "",
      "Artist: SugaMon",
    ],
    259 => [
      "A powerful bird monster that roams the",
      "Northern Sea. Using her seductive",
      "voice, she tempts sailors to her, and",
      "then extracts all of their semen. Due",
      "to the potential for loss of life,",
	  "experienced sailors usually travel",
	  "with earplugs.",
      "",
      "Though they usually act alone, Sirens",
      "have been known to wait in groups on",
      "rocks to attack gigantic ships. With",
      "her high-quality vagina and seductive",
      "voice, the Siren can easily overpower",
      "a man in ecstasy in mere moments. In",
	  "trade for this pleasure, the man is",
	  "milked until his death.",
      "",
      "Artist: Thomas",
    ],
    260 => [
      "A coral monster living in the sea.",
      "Although she lives on the seafloor,",
      "she sometimes appears on drifting",
      "ships and the like. Normally she",
      "hardly ever moves from her spot,",
      "extending her tentacles to capture",
      "prey. She will prey upon any male",
      "organism, squeezing out semen from",
      "their genitals for nourishment.",
      "",
      "Human men are no exception of",
      "course, and she will catch them as",
      "her favorite treats. Prey that she",
      "squeezes for a long time will be",
      "converted into coral and incorporated",
      "into her body so she can continue to",
      "suck them endlessly. The prey will",
      "be supplied nutrients in this state",
      "and be unable to die as he continues",
      "to be sucked until his body decays.",
      "",
      "Communicating intentions to her",
      "appears to be impossible, but she",
      "does have emotions. She rarely",
      "responds to questions however, and",
      "is very difficult to get through to.",
      "",
      "Artist: Setouchi",
    ],
    261 => [
      "A monster that resides in the Northern",
      "Sea. Due to living so close to the",
      "northern continent, they are quite",
	  "powerful.",
      "",
      "Her staple food is male semen and",
      "flesh. Once caught in her body, there",
      "are very few men capable of escaping.",
      "With her back foot, she tickles the",
      "man's body to stimulate him as she",
      "forces his penis into her. After",
      "sucking up his semen, she brings her",
      "stomach out of her own body to begin",
      "digesting her catch's body. As he",
      "weakens from the digestion process,",
      "the Starfish Girl slowly brings him",
	  "inside her.",
      "",
      "Artist: Setouchi",
    ],
    262 => [
      "An insect-type monster that was sealed",
      "in ancient times by the first Monster",
      "Lord. An ancient monster that belongs",
      "to a different evolutionary tree of",
      "monsters, different from the current",
      "generation. An incredibly powerful",
      "monster, she was revered as a God in",
      "ancient times. Many were sealed at",
	  "first, but the vast majority have died",
	  "over the years. Only three of the",
	  "strongest have managed to survive to",
	  "the present day.",
      "",
      "Their strength is formidable, but it's",
      "their reproductive ability that is",
      "truly terrifying. Mating with a single",
      "man for a year straight, they can give",
      "birth to 10,000 daughters. Keeping the",
      "man as a reproductive tool, she keeps",
      "his penis in her abdomen, keeping them",
      "in a trance of pleasure to ensure",
	  "continual insemination. Inserting the",
	  "eggs into the man's rectum after",
	  "fertilization, he is treated as",
	  "nothing but a reproductive tool.",
      "",
      "Artist: Setouchi",
    ],
    263 => [
      "An insect-type monster that was sealed",
      "in ancient times by the first Monster",
      "Lord. An ancient monster that belongs",
      "to a different evolutionary tree of",
      "monsters, different from the current",
      "generation. An incredibly powerful",
      "monster, she was revered as a God in",
      "ancient times. Many were sealed at",
	  "first, but the vast majority have died",
	  "over the years. Only three of the",
	  "strongest have managed to survive to",
	  "the present day.",
      "",
      "Their strength is formidable, but it's",
      "their reproductive ability that is",
      "truly terrifying. Mating with a single",
      "man for a year straight, they can give",
      "birth to 10,000 daughters. Keeping the",
      "man as a reproductive tool, she keeps",
      "his penis in her abdomen, keeping them",
      "in a trance of pleasure to ensure",
	  "continual insemination. Inserting the",
	  "eggs into the man's rectum after",
	  "fertilization, he is treated as",
	  "nothing but a reproductive tool.",
      "",
      "Artist: Setouchi",
    ],
    264 => [
      "An insect-type monster that was sealed",
      "in ancient times by the first Monster",
      "Lord. An ancient monster that belongs",
      "to a different evolutionary tree of",
      "monsters, different from the current",
      "generation. An incredibly powerful",
      "monster, she was revered as a God in",
      "ancient times. Many were sealed at",
	  "first, but the vast majority have died",
	  "over the years. Only three of the",
	  "strongest have managed to survive to",
	  "the present day.",
      "",
      "Their strength is formidable, but it's",
      "their reproductive ability that is",
      "truly terrifying. Mating with a single",
      "man for a year straight, they can give",
      "birth to 10,000 daughters. Keeping the",
      "man as a reproductive tool, she keeps",
      "his penis in her abdomen, keeping them",
      "in a trance of pleasure to ensure",
	  "continual insemination. Inserting the",
	  "eggs into the man's rectum after",
	  "fertilization, he is treated as",
	  "nothing but a reproductive tool.",
      "",
      "Artist: Setouchi",
    ],
    265 => [
      "A jellyfish monster drifting along",
      "the waves. In addition to living in",
      "the open seas, she also lives in the",
      "northern undersea temple. Most of",
      "the time she lets the waves carry",
      "her, drifting with the flow. Her",
      "physical body has been toughened by",
      "her activity in the open seas and",
      "she is considered to be the",
      "strongest among jellyfish monsters.",
      "",
      "She has a hazy personality but a",
      "strong appetite, and when she finds",
      "a ship, she looks inside from the",
      "waves. When she finds a human male,",
      "she captures him with a tentacle and",
      "brings him into her umbrella. The",
      "inside of her umbrella folds and",
      "contracts, giving pleasure to the",
      "entire body of her captured prey and",
      "forcing him to ejaculate numerous",
      "times. The released semen is",
      "absorbed as nutrition for the Arch",
      "Jelly. After being completely",
      "squeezed of semen, her prey is",
      "melted and finally digested.",
      "",
      "Artist: UN_DO",
    ],
    266 => [
      "A greater species of Scylla that",
      "roams the open seas. Her physical",
      "abilities are so great that pirates",
      "and marines alike are no match for",
      "her strength. She is very malicious",
      "and will immediately attack any",
      "ships she encounters on the open",
      "seas. The man she finds most to her",
      "liking will be bound by her",
      "tentacles and dragged into the sea",
      "with her.",
      "",
      "A hell of tentacles awaits any man",
      "who gets captured by the Elder",
      "Scylla. His whole body will be",
      "assaulted by slimy tentacles, with",
      "his penis being thoroughly caressed",
      "by them. Since she will sometimes",
      "toy with the man until he has been",
      "squeezed to death, she is an",
      "extremely cruel and dangerous",
      "monster.",
      "",
      "Artist: UN_DO",
    ],
    267 => [
      "The Queen over the Northern Sea. Proud",
      "of her physical and magical abilities,",
      "she is even stronger than the Kraken",
      "Queen of the Southern Seas. Though she",
      "is strict, she holds no cruelty or",
      "malice. Ruling over the northern half",
      "of the seas, she metes out suitable",
	  "punishments to those that disturb the",
	  "peace.",
      "",
      "Though she's able to live on fish and",
      "seaweed, she enjoys the taste of human",
      "semen. On the occasions when she can",
      "enjoy some, she skillfully uses her",
      "tentacles to squeeze it out. She does",
      "not attack men, however. Her milking",
	  "is reserved for criminals of the sea,",
	  "and those who challenge her and lose.",
      "",
      "Artist: Setouchi",
    ],
    268 => [
      "Succubi who are following Natasha in",
      "her attack on Succubus Village. From",
      "those who were naturally born as",
      "succubi to those like Natasha from",
      "Luddite Village who were turned into",
      "succubi by Lilith, a variety of them",
      "have gathered. All of them derive",
      "pleasure from toying with men, and",
      "have joined the attack under the",
      "notion they would get to enjoy the",
      "men living in Succubus Village.",
      "",
      "Naturally, their staple diet is",
      "human semen, and any man they",
      "attack, regardless of their age and",
      "appearance, will have their semen",
      "drained in exchange for sweet",
      "pleasure. Most succubi are lewd but",
      "not particularly cruel, so unless",
      "one has a harsh personality, they",
      "usually won't drain men to death.",
      "Still, it is terrifying to be",
      "assaulted by a group of succubi, and",
      "it is not unusual for a man to be",
      "drained to the brink of death.",
      "",
      "Artist: D_AM",
    ],
    269 => [
      "Succubi who are following Natasha in",
      "her attack on Succubus Village. From",
      "those who were naturally born as",
      "succubi to those like Natasha from",
      "Luddite Village who were turned into",
      "succubi by Lilith, a variety of them",
      "have gathered. All of them derive",
      "pleasure from toying with men, and",
      "have joined the attack under the",
      "notion they would get to enjoy the",
      "men living in Succubus Village.",
      "",
      "Naturally, their staple diet is",
      "human semen, and any man they",
      "attack, regardless of their age and",
      "appearance, will have their semen",
      "drained in exchange for sweet",
      "pleasure. Most succubi are lewd but",
      "not particularly cruel, so unless",
      "one has a harsh personality, they",
      "usually won't drain men to death.",
      "Still, it is terrifying to be",
      "assaulted by a group of succubi, and",
      "it is not unusual for a man to be",
      "drained to the brink of death.",
      "",
      "Artist: D_AM",
    ],
    270 => [
      "Succubi who are following Natasha in",
      "her attack on Succubus Village. From",
      "those who were naturally born as",
      "succubi to those like Natasha from",
      "Luddite Village who were turned into",
      "succubi by Lilith, a variety of them",
      "have gathered. All of them derive",
      "pleasure from toying with men, and",
      "have joined the attack under the",
      "notion they would get to enjoy the",
      "men living in Succubus Village.",
      "",
      "Naturally, their staple diet is",
      "human semen, and any man they",
      "attack, regardless of their age and",
      "appearance, will have their semen",
      "drained in exchange for sweet",
      "pleasure. Most succubi are lewd but",
      "not particularly cruel, so unless",
      "one has a harsh personality, they",
      "usually won't drain men to death.",
      "Still, it is terrifying to be",
      "assaulted by a group of succubi, and",
      "it is not unusual for a man to be",
      "drained to the brink of death.",
      "",
      "Artist: D_AM",
    ],
    271 => [
      "Succubi who are following Natasha in",
      "her attack on Succubus Village. From",
      "those who were naturally born as",
      "succubi to those like Natasha from",
      "Luddite Village who were turned into",
      "succubi by Lilith, a variety of them",
      "have gathered. All of them derive",
      "pleasure from toying with men, and",
      "have joined the attack under the",
      "notion they would get to enjoy the",
      "men living in Succubus Village.",
      "",
      "Naturally, their staple diet is",
      "human semen, and any man they",
      "attack, regardless of their age and",
      "appearance, will have their semen",
      "drained in exchange for sweet",
      "pleasure. Most succubi are lewd but",
      "not particularly cruel, so unless",
      "one has a harsh personality, they",
      "usually won't drain men to death.",
      "Still, it is terrifying to be",
      "assaulted by a group of succubi, and",
      "it is not unusual for a man to be",
      "drained to the brink of death.",
      "",
      "Artist: D_AM",
    ],
    272 => [
      "A Succubus possessing the skills of",
      "a maid. Equipped with a cleaning",
      "makina, she performs general",
      "housework. She is also skilled at",
      "self-defense, and appears to have",
      "considerable fighting capability.",
      "Invited to the attack plan by",
      "Natasha, many Maidcubi participated",
      "with the promise of exceptional",
      "rewards and men's semen.",
      "",
      "She is also good at serving men, and",
      "will use her sexual services to",
      "weaken men and make them feel",
      "pleasure from depending on her.",
      "While receiving the Maidcubus'",
      "service, the man will ejaculate",
      "repeatedly and become her captive.",
      "While the Maidcubus acts like she is",
      "serving her master, the master-",
      "servant relationship is actually",
      "reversed in this case as the man",
      "continues to offer his semen to the",
      "maid.",
      "",
      "Artist: Cool-kyou Shinja",
    ],
    273 => [
      "A prostitute that lived in the",
      "Succubus Village before being turned",
      "into a Succubus. Succubus is the name",
      "given to monsters who have all the",
      "traits and qualities befitting one of",
      "their family of monster. Maccubus is",
      "a special name given to Succubi who",
	  "already have expert-level sexual",
	  "skills before their transformation.",
      "",
      "Already quite skilled in pleasing men,",
      "her Succubus transformation",
      "drastically increased the quality of",
      "the pleasure she is able to bring. In",
      "addition, she is now able to employ",
      "the famous Energy Drain move to suck",
      "the energy from men. She's one who is",
      "already more powerful than many",
	  "Succubi, even though just being",
	  "transformed into one herself.",
      "",
      "Artist: Irodori",
    ],
    274 => [
      "A young girl that lived in the",
      "Succubus Village before being turned",
      "into a Succubus. She is given the name",
	  "Mincubus due to her young age.",
      "",
      "Although her sexual techniques are",
      "lacking, her childlike curiosity in",
      "how she plays with men makes her",
      "irresistible. Many men willingly",
      "sacrifice themselves to her, drained",
      "of all energy as she satisfies her",
	  "sexual curiosity. Though she is a",
	  "young girl, it would be dangerous to",
	  "underestimate her.",
      "",
      "Artist: Irodori",
    ],
    275 => [
      "A girl who lives in the Succubus",
      "Village. Due to the erotic power, she",
      "was turned into a Succubus. Why is she",
      "called Lencubus? Because she can use",
      "the unusual move [Level Drain].",
	  "",
      "Though her normal abilities are pretty",
      "poor, her innate talent for",
      "Level Drain is formidable. It's a",
      "powerful technique that even few",
      "mature Succubi are able to master. It",
      "takes the power level of her prey",
      "and makes it her own. She does this by",
      "converting the prey's power into",
      "energy form, and sucking it in so that",
      "it combines with her own. Though it",
      "may look like an ejaculation when the",
	  "prey's power is being sucked, it is",
	  "not semen. The cloudy liquid is",
	  "actually a very condensed form of",
	  "biological energy. Though it may feel",
	  "like an ejaculation, the exhaustion or",
	  "weakness that would not usually",
	  "accompany it is not present when",
	  "afflicted by this technique. However,",
	  "when the prey becomes weaker and the",
	  "Lencubus becomes stronger, it can",
	  "quickly become a dangerous situation.",
      "",
      "There is a limit to the levels that",
      "can be absorbed by [Level Drain], so",
      "the user cannot become infinitely",
	  "strong.",
      "",
      "Artist: Irodori",
    ],
    276 => [
      "A very powerful Succubus serving as",
      "the mayor of Succubus Village. She",
      "conceals her identity and governs",
      "the village under the guise of a",
      "human. Boasting exceptional",
      "abilities compared to the average",
      "succubus, every part of her body is",
      "a weapon capable of draining semen",
      "from men. If she is angered, she",
      "will squeeze her opponent dry using",
      "her overwhelming sexual skills.",
      "",
      "The mayor of Succubus Village has",
      "been serving her tribe for",
      "generations. Her leadership ability",
      "is great and she is revered by the",
      "villagers, but her encouragement of",
      "growing potatoes as a staple crop",
      "appears to be unpopular.",
      "",
      "Artist: frfr",
    ],
    277 => [
      "A girl who was sexually abused in",
      "Luddite Village and transformed into",
      "a Succubus by the three Lilith",
      "Sisters. Her talents have yet to",
      "mature completely, but she already",
      "wields incredible magical power.",
      "In addition to her talent, the power",
      "given to her by the Lilith Sisters",
      "is immense, and she is more than",
      "capable of fighting the mayor of",
      "Succubus Village on equal footing.",
      "",
      "Embracing a deep hatred for the men",
      "from her village who carried out",
      "the abuses, she has extended this",
      "hatred to all men. If she catches",
      "one, she will thoroughly humiliate",
      "the man and crush his dignity before",
      "killing him. Without the opportunity",
      "to reform herself, there is no doubt",
      "she would become a very heinous",
      "Yoma.",
      "",
      "Artist: Irodori",
    ],
    278 => [
      "A type of Scylla, she is the acting",
      "maid at Cassandra's mansion. She has",
      "multiple tentacles that sprout from",
      "her lower body, and has a giant mouth",
      "located underneath her that she uses",
      "for predatory purposes.",
	  "",
      "An extremely sadistic monster that",
      "disguises her cruel treatment as",
      "service for the male. Ignoring",
      "anything her guest tells her, she",
      "uses her tentacles to torture them as",
      "she looks on in joy. After breaking",
      "her catch's spirit, she will force",
      "him to orgasm a couple times before",
	  "finally preying on them. At times she",
	  "is known to force the catch to",
	  "ejaculate inside her mouth, just to",
	  "get a final laugh at their pathetic",
	  "display before eating them whole.",
      "",
      "Artist: Setouchi",
    ],
    279 => [
      "An insect monster that usually takes",
      "the form of a human noblewoman. Living",
      "in Lady's Village, she attacks male",
      "travelers and sucks out their bodily",
	  "fluids until they die.",
      "",
      "When preying on a male, she forces",
      "their penis into a mouth located in",
      "her lower body. Stimulating it, she",
      "forces them to ejaculate directly into",
      "her, feeding her. Sucking out all of",
      "their body fluids, she continues this",
      "until the male is dead.",
	  "",
      "An extremely sadistic monster, she",
      "derives great pleasure from watching",
      "the struggling male slowly weaken as",
	  "he ejaculates into her. Contrary to",
	  "her refined look, she is extremely",
	  "dangerous.",
      "",
      "Artist: Setouchi",
    ],
    280 => [
      "A monster with a soft body of the",
      "Scylla type, she usually keeps herself",
      "disguised as a human. A mix between",
      "jellyfish and squid, she uses her",
	  "tentacles to squeeze her prey of",
	  "semen.",
      "",
      "When transformed, her Umbrella is",
      "actually part of her body. Any man",
      "that strays too close is grabbed by",
      "tentacles that sprout from there.",
      "Proud of the control she can exert",
      "over her catch, she enjoys forcing men",
      "to ejaculate from stimulations other",
	  "than just their penis. After toying",
	  "with her catch for a while, she will",
	  "continue on with every available",
	  "stimulation source until they are",
	  "squeezed to death.",
      "",
      "Artist: Setouchi",
    ],
    281 => [
      "A witch living in Lady's Village.",
      "She is very good at sexcraft and is",
      "able to summon multiple breasts.",
      "Inviting travelers who visit the",
      "village to her home, she surrounds",
      "them with a myriad of breasts to",
      "squeeze out their semen and fuel her",
      "magical power.",
      "",
      "Ever since Candy's rebellion, she",
      "has been hiding in Scenic Mountain,",
      "inviting any travelers who pass by.",
      "She brings her prey into another",
      "space using her magic power, where",
      "their whole body will be crushed by",
      "a myriad of breasts. Their semen",
      "will be milked dry as they drown in",
      "the melting pleasure. Men caught by",
      "Aradia will have their semen",
      "squeezed until their deaths with",
      "almost no exception. She is both an",
      "infamous witch and a powerful Yoma.",
      "",
      "Artist: UN_DO",
    ],
    282 => [
      "A greedy, candy-loving witch living",
      "in Lady's Village. Her appetite is",
      "insatiable, and in addition to",
      "eating ordinary meals and sweets,",
      "she will also devour humans. Even",
      "her fellow monsters are no",
      "exception, and she has the ability",
      "to turn her opponents into sweets",
      "using her magical power.",
      "",
      "When Lord Cassandra was defeated by",
      "Alipheese the Seventeenth, she",
      "raided her home while she was",
      "weakened, turned her into candy with",
      "her magical power and escaped.",
      "Although it was a short-sighted crime",
      "brought on by Candy's hunger, it",
      "turned into a full-scale revolt when",
      "the village's many monsters showed",
      "sympathy for her.",
      "",
      "Men captured by Candy will have",
      "their whole body sucked on,",
      "releasing semen in the comfort of",
      "her mouth. After sucking him dry,",
      "she will greedily swallow his",
      "exhausted body. She is an innocent-",
      "looking but extremely dangerous Yoma",
      "who will not hesitate to satisfy",
      "her own appetite.",
      "",
      "Artist: UN_DO",
    ],
    283 => [
      "A powerful monster that is able to",
      "petrify, with a mix of reptile and",
      "bird characteristics. They are almost",
      "never seen around human towns, and",
      "prefer volcanoes or mountains. In",
	  "addition, they are unable to fly in",
	  "the sky.",
      "",
      "They are able to not only petrify",
      "humans with their magical eyes, but",
      "through their saliva. It is very",
      "dangerous to let them either lick you",
      "or have sex with you. They are known",
      "to be very cruel, and sometimes turn",
	  "humans to stone for fun. Notably, they",
	  "are known to petrify the male's penis",
	  "and rape him, enjoying the permanent",
	  "rock-hard sensations.",
	  "",
      "They use the semen they squeeze out",
      "for both feeding and reproductive",
      "purposes. However their main purpose",
	  "in raping males seems to be simply for",
	  "their own enjoyment.",
      "",
      "Artist: Thomas",
    ],
    284 => [
      "One of the most famous monsters in the",
      "world, Dragons are top of the list",
      "when it comes to being inherently",
      "powerful. However very few adventurers",
      "ever meet one, due to their preference",
      "for very secluded areas. There are",
      "many different types of Dragon",
      "monsters. This specific one has her",
	  "human part protected inside her large",
	  "mouth. As a family of Dragons breeds",
	  "more with humans, their children",
	  "slowly begin to look more humanoid.",
	  "Those more human-like Dragons are",
	  "known as Dragonkin.",
      "",
      "Their scales are tough, and their",
      "fangs and horns are sharp. Their base",
      "offensive ability is far higher than",
      "any other monster type. In addition,",
      "their intelligence seems to be higher",
      "than average, too.",
	  "",
      "Any prey they catch will be used to",
      "satisfy both their sexual appetite and",
	  "their hunger. Due to their seclusion,",
	  "they prefer to savor the prey as they",
	  "slowly eat them.",
      "",
      "Artist: Setouchi",
    ],
    285 => [
      "The spirit of flame has a very",
      "prideful and wild disposition. Living",
      "quietly in the Gold Region volcano,",
      "she doesn't interact much with the",
      "outside world. However she's famous in",
      "the monster world, and many come to",
      "her hoping to be made into her",
	  "apprentice. Salamander seems to mostly",
	  "decline, though.",
      "",
      "Anyone who dares challenge her is",
      "relentlessly attacked without a shred",
      "of mercy. If the challenger is a man,",
      "she also enjoys humiliating them",
      "afterwards. Able to control her body",
      "heat at will, she creates relaxing",
      "warmth forcing the man to ejaculate",
      "whether he wants to or not. Not fond",
	  "of killing, she usually leaves the men",
	  "on the brink of death outside of the",
	  "volcano after she finishes humiliating",
	  "them.",
      "",
      "She seems willing to promise her",
      "undying loyalty to someone worthy. But",
      "getting the prideful Salamander to",
	  "acknowledge you is no easy task.",
      "",
      "Artist: frfr",
    ],
    286 => [
      "A powerful monster of the dragon",
      "race, she is one of the Four",
      "Heavenly Knights. Devoting herself",
      "to the sword, there is nobody in the",
      "world who can match her flaming",
      "sword. Swearing loyalty to the",
	  "Monster Lord, she takes great pride",
	  "in her position. With a chivalrous",
	  "spirit, she avoids useless violence",
	  "against the weak.",
      "",
      "Those of the Dragon race have an",
      "omnivorous diet like humans, but",
      "prefer semen. Even though Granberia",
      "generally doesn't feed on semen,",
      "unlike fellow members of her tribe,",
	  "she sometimes cannot help herself",
	  "playing with defeated men in the",
	  "rush of battle.",
      "",
      "Believing strongly in her chivalry,",
      "she only chooses to associate with",
      "the strong. With an unmatched",
      "swordswoman like Granberia, it's",
	  "hard for her to acknowledge someone.",
      "",
      "Artist: Akazawa RED",
    ],
    287 => [
      "A slime monster that rides around on",
      "a cube composed of viscous liquid.",
      "This huge cube is also a part of her",
      "body, and she can extend sticky",
      "tentacles from it. She is among the",
      "strongest of the slime race, with",
      "very high power and vitality. In",
      "addition, because she stores",
      "moisture in her cube, she is able to",
      "live in dry environments that",
      "normally aren't suitable for slimes.",
      "",
      "When she finds a human male, she",
      "will bind him with her viscous",
      "tentacles and pull him into her",
      "cube. Her prey will taste a hell of",
      "pleasure while wrapped in her",
      "viscous body and be forced to",
      "ejaculate endlessly for a long time",
      "as he supplies her with nutrition.",
      "Once all of his semen has been",
      "ejaculated, his body will be melted",
      "into her cube and taken in as",
      "nourishment. Contrary to her",
      "friendly attitude, she is a very",
      "dangerous monster who sees humans",
      "as just food.",
      "",
      "Artist: Cool-kyou Shinja",
    ],
    288 => [
      "A monster who boasts incredible",
      "strength and is among the strongest",
      "of Youkai. Her body is one of the",
      "toughest among monsters and she is",
      "feared among adventurers and",
      "warriors alike for her strength. She",
      "usually has a rough personality and",
      "a violent temperament, but her mood",
      "varies wildly and she has been known",
      "to occasionally help humans.",
      "However, she is usually targeting",
      "humans to steal their goods and",
      "semen, and is no different from",
      "other dangerous monsters.",
      "",
      "In addition to assaulting humans as",
      "a bandit, if her victim is a young",
      "man, she will rape him. Men who are",
      "violated by Youki will have their",
      "semen wrung from them until they are",
      "completely exhausted. Although she",
      "rarely kills her victims, she often",
      "leaves them abandoned on the verge",
      "of death, making encounters with her",
      "extremely dangerous.",
      "",
      "Artist: kupala",
    ],
    289 => [
      "A tiger monster that is believed to",
      "have originated from Yamatai. With",
      "her samurai swordsmanship coupled",
      "with the physical strength of a",
      "tiger, she boasts tremendous",
      "fighting capabilities. While she is",
      "very ferocious in battle, she is",
      "surprisingly peaceful most other",
      "times and is actually a civil",
      "monster. She does not prey upon",
      "humans, instead filling her stomach",
      "with the same meals that humans eat.",
      "",
      "She typically lives in rugged",
      "environments far away from",
      "settlements and almost never",
      "encounters humans. She rarely harms",
      "civilians and travelers, but if she",
      "suspects you to be a trained",
      "warrior, she may challenge you to a",
      "battle. If you are defeated by her,",
      "she will proceed to rape you as is",
      "the fate of the defeated. The Tiger",
      "Girl's mating is very intense and",
      "will break the endurance of any man,",
      "forcing him to dedicate his semen to",
      "her. After mating, the man is",
      "usually released with his life",
      "intact, but sometimes she may force",
      "him to become her husband if she",
      "likes him.",
      "",
      "Artist: Setouchi",
    ],
    290 => [
      "A high-level Vampire who wields",
      "powerful magic and resupplies her own",
      "energy through human semen and blood.",
      "She usually resides in the northern",
      "continent, but is known to travel",
      "south and attack the Gold Region when",
      "she gets hungry. When she goes south,",
      "nearly 100 humans end up attacked by",
      "her. If she attacks a female, she",
      "sucks their blood and makes them her",
	  "servant. If it's a man, she rapes him",
	  "as she sucks out his blood. In",
	  "addition, her mantle is an extension",
	  "of her body, able to squeeze out and",
	  "absorb semen.",
	  "",
      "With no human soldier able to stand",
      "against her, she's treated almost as a",
      "natural disaster. When the Vampire",
      "appears, the nearby humans can only",
	  "pray to Ilias until she's finished.",
      "",
      "Artist: masha",
    ],
    291 => [
      "A mysterious being known as an",
      "Apoptosis, which resides in",
      "Tartarus. They are organisms",
      "resembling monsters, but no one",
      "knows what they are. Moreover, she",
      "appears to instinctively attack",
      "intruders as if programmed into her",
      "mind.",
      "",
      "Jellaila has been fused with a giant",
      "harp which is capable of producing",
      "both beautiful music and destructive",
      "sound waves. She can also stretch",
      "the harp strings like tentacles,",
      "making it possible for her to bind",
      "and restrain intruders. If she",
      "produces pleasurable sound waves,",
      "her prey will immediately be",
      "overcome with ecstasy.",
      "",
      "She appears gentle, but is very",
      "ruthless and will humiliate her",
      "prey. After being completely",
      "entangled by her strings, he will be",
      "relentlessly drowned in her pleasure",
      "sound waves, causing him to",
      "repeatedly ejaculate in the",
      "maddening ecstasy. The pitiful man",
      "will continue to release semen until",
      "he dies.",
      "",
      "Artist: Delphinus",
    ],
    292 => [
      "A mysterious being known as an",
      "Apoptosis, which resides in",
      "Tartarus. They are organisms",
      "resembling monsters, but no one",
      "knows what they are. Moreover, she",
      "appears to instinctively attack",
      "intruders as if programmed into her",
      "mind.",
      "",
      "Ribo-Ribo is an unidentified",
      "organism residing in a capsule",
      "mechanism, who is programmed to",
      "isolate intruders by bringing them",
      "into it. Her body is also equipped",
      "with powerful mechanical weapons for",
      "combat.",
      "",
      "Any man who gets trapped inside her",
      "capsule will be forced to give her",
      "a sample of his semen. If his semen",
      "is of a high quality, he will then",
      "be forced to inseminate her strange",
      "fleshy surface. The purpose for",
      "which she collects these samples is",
      "unknown, and no one knows what",
      "happens after her flesh surface has",
      "been inseminated.",
      "",
      "Artist: Delphinus",
    ],
    293 => [
      "A mysterious being known as an",
      "Apoptosis, which resides in",
      "Tartarus. They are organisms",
      "resembling monsters, but no one",
      "knows what they are. Moreover, she",
      "appears to instinctively attack",
      "intruders as if programmed into her",
      "mind.",
      "",
      "Amphil appears to be an apoptosized",
      "parasitic tapeworm, but the details",
      "are unknown. Her body is highly",
      "flexible, and she is able to make",
      "her head and other organs appear",
      "anywhere. The mind of a human woman",
      "also appears to be mixed into her",
      "personality, making her true",
      "identity a mystery.",
      "",
      "She requires human semen for",
      "nourishment, and will wrap herself",
      "around an intruder's body to",
      "forcefully squeeze it out of them.",
      "Sometimes she will form a womb out",
      "of her body to imitate vaginal",
      "intercourse. It is unknown if she is",
      "even capable of reproduction or if",
      "the same species would be born of",
      "such a union, raising many questions",
      "about her mysterious existence.",
      "",
      "Artist: xelvy",
    ],
    294 => [
      "A mysterious being known as an",
      "Apoptosis, which resides in",
      "Tartarus. They are organisms",
      "resembling monsters, but no one",
      "knows what they are. Moreover, she",
      "appears to instinctively attack",
      "intruders as if programmed into her",
      "mind.",
      "",
      "Twinkell has the appearance of two",
      "women combined into an irregular",
      "body. both of whom have a different",
      "will and personality. The",
      "relationship between the two is",
      "unknown, but they do not appear to",
      "be friendly. Whenever she finds",
      "intruders, she will force them",
      "between her bodies and violate",
      "them. She alternates between the",
      "vaginas of the two bodies, raping",
      "their prey until they are exhausted.",
      "",
      "Artist: xelvy",
    ],
    295 => [
      "Legendary Succubus Sisters that were",
      "sealed 500 years ago by a Hero.",
      "Incredibly strong Succubi, they are",
	  "among Black Alice's most loyal",
	  "subordinates.",
      "",
      "Top-class Succubi, they work together",
      "to indulge a man in ecstasy.",
      "Entangling their bodies together with",
      "the man's, they take turns mating with",
      "him all while rubbing their bodies",
	  "against his.",
      "",
      "To tell them apart, the older sister",
      "with smaller breasts is Lilith, and",
      "the younger sister with larger breasts",
	  "is Lilim. The two consider themselves",
	  "of the same flesh, and cannot bear",
	  "to part with the other for longer than",
	  "a few moments.",
      "",
      "Artist: masha",
    ],
    296 => [
      "Daughter to Cassandra, she's a monster",
      "from the Scylla line. Though she is",
      "still a young girl, she boasts both",
      "powerful magical and physical ability.",
      "",
      "Despite her carefree manner, she is",
      "surprisingly cruel. She loves to use",
      "her tentacles to play with men until",
      "they die. It's unknown how many have",
      "been killed by Emily. Using her",
      "tentacles to bind the male, she enjoys",
      "playing with them as she watches their",
      "agonized expressions. This will",
	  "continue until Emily grows bored of",
	  "them, where she will then quickly",
	  "finish them off.",
      "",
      "Her mother; Cassandra, has the genes",
      "of many different families of monsters",
      "within her. The Scylla genes took",
      "dominant control in Emily during",
	  "Cassandra's pregnancy.",
      "",
      "Artist: Setouchi",
    ],
    297 => [
      "The Lord of Lady's Village, she also",
      "competed against Alipheese the 15th",
      "for the Monster Lord's throne.",
      "Extremely strong, she is one of the",
      "most powerful monsters in the world.",
      "It appears as though she can trace",
      "her lineage far down the line to the",
      "Fateburn family.",
      "",
      "Holding the genes of many different",
      "monster lines in her, it seems as",
      "though she can produce offspring of",
      "many different types. In addition,",
      "she is able to control her flesh",
      "freely. Using that, she can form her",
      "digestive organ outside of her own",
      "body, and watch her prey be digested",
      "with her own eyes. Wrapping up her",
      "prey in her organ, Cassandra usually",
      "forces them to have multiple",
      "orgasms, until they have no semen",
      "left. After that, she enjoys",
      "watching them as they slowly",
      "dissolve away.",
      "",
      "Now weakened, she only has about as",
      "much strength as her daughter Emily.",
      "However, she appears to be enjoying",
      "her rejuvenated younger body, and",
      "does not appear to be bothered so",
      "much by this.",
      "",
      "Artist: Setouchi",
    ],
    298 => [
      "A powerful Succubus who, while not",
      "holding too much erotic power,",
      "boasts very high magical power. She",
      "has a deep knowledge of magic and",
      "serves as the assistant to the mayor",
      "of Succubus Village.",
      "",
      "A rather troublesome opponent, she",
      "infuses her gloves and hat with her",
      "magical energy, and lets them",
      "operate as if they had their own",
      "will. Because of her high magical",
      "potential, she is a voracious eater,",
      "and will squeeze out lots of semen",
      "when she catches a man. Along with",
      "her seemingly bottomless appetite is",
      "her thirst for knowledge, which",
      "causes her to experiment with the",
      "man as she feasts. She is not cold-",
      "blooded, but is considered very",
      "dangerous.",
      "",
      "Artist: frfr",
    ],
    299 => [
      "A sea-dweller monster inhabiting the",
      "open seas. She is said to be a",
      "subspecies of the sea anemone, but",
      "her exact origins are unknown, and",
      "seems to bear traits of other",
      "species such as starfish. Her lower",
      "body has a peculiar structure for",
      "catching prey, and is not good for",
      "moving on land. However, by",
      "skillfully using her hair and",
      "tentacles, she can propel herself",
      "quickly through the sea. In",
      "addition, the tentacles on both",
      "sides of her lower body are",
      "retractable and can be used like a",
      "whip.",
      "",
      "When she finds a man, she will pull",
      "him into her lower body. By",
      "thoroughly caressing the entire",
      "body of her prey using innumerable",
      "wriggling appendages and soft",
      "protrusions, particularly focusing",
      "around the genitals, he will",
      "repeatedly ejaculate semen. The",
      "released semen is absorbed by her",
      "slimy membrane and becomes",
      "nourishment for the Sea Anemone",
      "Girl. She usually does not release",
      "her prey until he is exhausted, and",
      "will often squeeze him until his",
      "death.",
      "",
      "Artist: Setouchi",
    ],
    300 => [
      "A sea dragon living in the open sea.",
      "Although she is very young for a",
      "dragon, she is already quite",
      "powerful, with no ordinary human",
      "being able to match her toughness.",
      "She rarely encounters humans out in",
      "the open seas she resides in, so she",
      "is very curious about them.",
      "",
      "Upon discovering humans, she will",
      "challenge them and, upon defeating",
      "them, try to communicate with them.",
      "If that person is a young man, she",
      "will force him to mate with her.",
      "Because the Sea Dragon Girl has no",
      "sexual experience, her techniques",
      "are childish. However, no man can",
      "endure her renowned vagina, and",
      "will end up dedicating all of their",
      "semen to her. If she likes the man,",
      "she may marry him and bring him back",
      "to her nest.",
      "",
      "Artist: Uminoyama",
    ],
    301 => [
      "Possessing the characteristics of a",
      "large manta ray, she is a monster of",
      "the Mermaid race living in the open",
      "seas. Proclaiming herself to be the",
      "Lord of the Ocean, she boasts",
      "incredible power. Along with the",
      "Narwhal Girl, she is one of the two",
      "most powerful monsters roaming the",
      "open seas. Always acting alone, she",
      "searches for ships on the open seas",
      "to raid and assaults their crew.",
      "",
      "A seafaring man captured by the",
      "Manta Girl will be exhaustively",
      "humiliated by her. In addition to",
      "squeezing his penis with her plump",
      "breasts, she may also mate with the",
      "man to force out the rest of his",
      "semen. After being thoroughly",
      "violated by her, the man is usually",
      "released with his life intact.",
      "",
      "Artist: Arekishi",
    ],
    302 => [
      "A huge sea serpent roaming the open",
      "seas. Regular narwhals are mammals,",
      "but this monster also has traits of",
      "a gigantic serpent. Her body is",
      "larger than a ship and she has a",
      "ferocious nature. She attacks ships",
      "to capture men and exhaustively",
      "squeezes their semen. She is proud",
      "of the tremendous power that comes",
      "with her huge body, and she becomes",
      "more intelligent when she goes",
      "berserk. Along with the Manta Girl,",
      "she is one of the most famous and",
      "powerful monsters of the open seas.",
      "",
      "Sailors taken away by the Narwhal",
      "Girl will be extensively violated by",
      "her gigantic body. Although she",
      "tries not to kill her catch, the",
      "fact that he usually won't be able",
      "to stand after being squeezed",
      "single-mindedly by her does not",
      "make her any less dangerous.",
      "",
      "Artist: Setouchi",
    ],
    303 => [
      "A powerful, high-ranking fairy.",
      "However, like other fairies, she still",
      "retains her mischievous innocent",
	  "nature.",
	  "",
      "Very curious about sex, she wants to",
      "try having sex with a human, despite",
      "her small size. Though her body is",
      "barely larger than a penis, her",
      "stretchy vagina is able to take and",
      "clamp down around a man. After shaking",
      "her body as hard as she can to make",
      "him come, the semen largely spills out",
	  "of her due to her tiny body.",
      "",
      "In addition, she's very possessive,",
      "making the possibility of the man",
      "being kept very high. Though she",
      "appears innocent and friendly, do not",
	  "underestimate this dangerous monster.",
      "",
      "Artist: masha",
    ],
    304 => [
      "Robust elves who live in a tribal",
      "group and engage in a hunter",
      "lifestyle. Martial arts are valued",
      "in their society, and they are",
      "expected to become strong women.",
      "Thus, they are more physically",
      "trained than other elves and boast",
      "incredible strength. Of course,",
      "their skill with a bow is also",
      "refined, and they are highly adept",
      "at combat.",
      "",
      "Men are typically not permitted into",
      "their society, but on rare occasions",
      "they will bring a captured man into",
      "their village to use him as a",
      "stallion. The pitiful man who was",
      "captured by the Amazoness Elves will",
      "be gang-raped relentlessly and",
      "forced to give up his seed to them.",
      "Once the man has been completely",
      "exhausted, he will be thrown out of",
      "their village.",
      "",
      "Artist: makiya",

    ],
    305 => [
      "A strange monster whose lineage is",
      "mixed with the fairy race. Although",
      "she is a beast type, she possesses",
      "both high magical power and great",
      "intelligence. Her most unique trait",
      "of all is her ability to reflect",
      "magic. Her body is protected by a",
      "Magical Mirror, and if she is struck",
      "with attack magic, it will be",
      "reflected back to its caster.",
      "",
      "While she is very calm and",
      "intelligent for a beast monster, she",
      "greedily ingests semen using the",
      "squeezing hole of her tail to suck",
      "it out of the man's penis. The soft",
      "flesh wrapped around the penis rubs",
      "and contracts to pump out semen. The",
      "man she squeezes will be released,",
      "but he will be weakened so much that",
      "he won't be able to stand for a few",
      "days.",
      "",
      "Artist: Setouchi",
    ],
    306 => [
      "A giant that is quite a spectacle",
      "to behold. She boasts incredible",
      "strength, but her personality is",
      "simple and brutish. She appears to",
      "be related to the elf race, and",
      "seems to get along with elves",
      "and fairies.",
      "",
      "She typically does not leave the",
      "island she resides on, but she will",
      "occasionally capture travelers and",
      "play with them. She has a strong",
      "sexual curiosity, and any man",
      "caught by the Gigantic Girl will be",
      "thoroughly exhausted. Sometimes she",
      "will mate with the man by screwing",
      "him into her huge vagina, placing an",
      "intense burden upon the man's body",
      "and mind. A man who is squeezed by",
      "her is likely to be left on the",
      "brink of death.",
      "",
      "Artist: Cool-kyou Shinja",
    ],
    307 => [
      "The most powerful Fairy in the world,",
      "both her magical power and synergy",
      "with nature is very high. Able to use",
      "plants as if they were her own hands,",
      "the Queen Fairy uses the forest as her",
      "own sexual organ. Originally she did",
      "not attack humans, but her anger has",
      "brought her to the point where she's",
      "now antagonistic. Unlike her carefree",
	  "Fairy brethren, she appears to have a",
	  "strong sense of responsibility as",
	  "their Queen.",
      "",
      "Any human captured by her is forced",
      "to experience the anger of the forest",
      "through her. Any semen squeezed out",
      "from a man is treated as nourishment",
      "for the forest. In addition, she seems",
      "to be good friends with the Queen Elf.",
      "",
      "Artist: Thomas",
    ],
    308 => [
      "The Queen of all the world's Elves.",
      "Though she doesn't enjoy fighting,",
      "her physical and magical abilities",
      "are top class. She originally avoided",
      "fighting, but has started to deeply",
      "hate humans. Due to that fact, she",
	  "fights against humans without any",
	  "mercy.",
      "",
      "Her sexual skills are extremely",
      "powerful, and are believed to be on",
      "the same level as a high-class",
      "succubus'. With her extensive",
      "knowledge and abilities, she is widely",
      "known as an expert in vaginal skills",
      "among the monster races. Any man",
	  "caught by her will have their semen",
	  "squeezed without exception.",
      "",
      "Artist: Thomas",
    ],
    309 => [
      "A greater species of alraune that",
      "lives in a forest full of spiritual",
      "power and holds stronger powers.",
      "They live in the World Tree on the",
      "Fairy Island and rarely ever appear",
      "before humans.",
      "",
      "When they do encounter humans, they",
      "tie them up with ivy and restrain",
      "them. After captivating them with",
      "honey and fragrance, they extract",
      "their semen. The man will release",
      "all of his semen into her flowers",
      "while immersed in ecstasy.",
      "",
      "In addition, they may use the semen",
      "they extract for breeding purposes",
      "and perform pollination using it.",
      "After having his semen sucked by",
      "them, the man will be left abandoned",
      "outside of the forest. He will not",
      "be deprived of his life, but he will",
      "be endangered by the weakened state",
      "he's left in.",
      "",
      "Artist: Uminoyama",
    ],
    310 => [
      "A greater species of dryad that",
      "lives in a forest full of spiritual",
      "power and holds stronger powers.",
      "They live in the World Tree on the",
      "Fairy Island and rarely ever appear",
      "before humans.",
      "",
      "When they do encounter humans, they",
      "tie them up with tree roots and",
      "restrain them. After completely",
      "restricting movement, she will suck",
      "up his semen thoroughly using an ivy",
      "that has a mouth attached. There is",
      "nothing the man can do but accept",
      "his fate to dedicate all of his",
      "semen to the Forest Dryad.",
      "",
      "In most cases his semen is sucked",
      "until he is on the verge of an",
      "exhausting death, after which she",
      "will provide him nourishment so",
      "as to keep him alive for further",
      "exploitation. He will not be",
      "released until his semen is",
      "completely exhausted, and it is",
      "possible he may live his remaining",
      "years as livestock for semen",
      "collection. Despite her soft",
      "demeanor, men should beware as she",
      "will never let them escape.",
      "",
      "Artist: Uminoyama",
    ],
    311 => [
      "Originally a peace-loving Alraune,",
      "her personality turned cruel and",
      "greedy after she was brainwashed.",
      "She seems to have captured numerous",
      "plant and insect monsters, and",
      "sucked on their nutrients.",
      "",
      "Also loving human semen, she will",
      "gladly take any chance she can get",
      "to treat herself on their fluids.",
      "She will mercilessly extract their",
      "semen with her petals, until they",
      "are left withered. As she absorbs",
      "their semen until her petals turn",
      "white, men are left exhausted with",
      "expressions of joy.",
      "",
      "Artist: Yukimura Shinji",
    ],
    312 => [
      "A normally temperate and kind-",
      "hearted tree monster. She was slow",
      "to be affected by the brainwashing",
      "magic due to individual differences",
      "(dimwitted?), and looked on in",
      "confusion at the sudden change among",
      "her kin. It appears that she is",
      "reluctantly following the queen's",
      "orders.",
      "",
      "When she catches a man, she uses her",
      "roots to draw out his semen while",
      "keeping him close to her. To avoid",
      "straining her catch, she will absorb",
      "it slowly over time, giving him",
      "intense pleasure in the process. In",
      "most cases she will release her",
      "catch after draining his semen once,",
      "but if it is of a high quality, she",
      "will not let him go and continue to",
      "carefully draw out his semen for a",
      "very long time. In this case, her",
      "catch will taste her sap of ecstasy,",
      "melting his heart as he entrusts his",
      "body to her sweet extract.",
      "",
      "Artist: frfr",
    ],
    313 => [
      "A tree monster that has fallen under",
      "the influence of brainwashing magic.",
      "Nevertheless, her ecology is exactly",
      "the same as a typical dryad's, and",
      "she uses the same methods for",
      "capturing intruders and drawing",
      "semen for nourishment.",
      "",
      "She is able to trail her roots over",
      "an organism, and suck them dry very",
      "quickly. Since this process is quick",
      "and merciless, she generally doesn't",
      "do it. But when her personality",
      "changes, she uses it without",
      "hesitation. Having their energy",
      "quickly drained like this brings men",
      "and women alike fast orgasms.",
      "If she's draining a man, they will",
      "ejaculate one time after another",
      "while writhing in ecstasy.",
      "",
      "Artist: frfr",
    ],
    314 => [
      "The Queen Alraune, reigning over all",
      "plant monsters. With powerful magic",
      "and vitality, she is known to be able",
      "to completely cover large areas with",
      "ivy. Though originally friendly and",
      "mild, the brainwashing technique",
	  "turned her cruel and heartless.",
      "",
      "Her huge body is centered by a pistil",
      "that takes the form of a human female.",
      "Using this body, she drastically",
      "increases her ability to fertilize",
      "herself with men. Her pistil is",
      "complete with large breasts, and an",
      "entrance similar to a female vagina.",
      "In other words, her female pistil",
	  "evolved as a sort of lure, seen in",
	  "many other non-monster plants.",
      "",
      "Artist: UN_DO",
    ],
    315 => [
      "A legendary evil dragon that",
      "existed in ancient times. The",
      "strength of snake and dragon",
      "monsters flows through her body,",
      "granting her tremendous power. She",
      "also has excellent magical power and",
      "is particularly skilled with demon",
      "eye techniques. With the help of",
      "Black Alice, she has been returned",
      "to this world for the first time in",
      "hundreds of years. Following her",
      "orders, she has brainwashed Queen",
      "Alraune and the plant monsters in",
      "the World Tree.",
      "",
      "She has a brutal personality, and",
      "enjoys tormenting defeated",
      "challengers. In addition to using",
      "the snakes on her body to caress the",
      "man's penis, she may force him into",
      "the vagina of her large body. Once",
      "inserted into Aži Dahāka, the man",
      "will taste intense pleasure as his",
      "semen is drained by her vagina. This",
      "harsh mating will continue until the",
      "man is exhausted.",
      "",
      "Artist: UN_DO",
    ],
    316 => [
      "A mermaid warrior who has trained",
      "herself in the sword arts. She has",
      "an unyielding personality and is",
      "always polishing her skills as she",
      "seeks strong opponents to challenge.",
      "She seems to be the rival of the",
      "Harpy Knight, and they frequently",
      "engage in friendly sparring matches",
      "to test their skills.",
      "",
      "While she is a warrior in mind, she",
      "will also give sexual pleasure to",
      "the men who challenge her. If she",
      "defeats a man, she will thoroughly",
      "play with his genitals before raping",
      "him. Her renowned vagina will fill",
      "the man with exquisite pleasure,",
      "forcing him to dedicate lots of",
      "semen to her. Men who are humiliated",
      "in this way are then left abandoned",
      "on the beach in a state of weakness.",
      "",
      "Artist: Uminoyama",
    ],
    317 => [
      "A Mermaid Warrior who assists the",
      "Queen Mermaid. Her loyalty to the",
      "Queen is so great, she would never",
	  "dare disobey an order from her.",
      "",
      "Though proud of her skilled offensive",
      "power, she will use pleasure attacks",
      "on someone she is unsure she can beat.",
      "Her pleasure techniques are just as",
      "polished, and it is said she can water",
      "down any man in moments. If that",
	  "happens, the man will quickly become a",
	  "slave to her fine techniques as she",
	  "violates him.",
      "",
      "Artist: frfr",
    ],
    318 => [
      "A mermaid of the highest class",
      "living beyond the great waterfall.",
      "Her lineage is closely linked to the",
      "ancient progenitor species, and",
      "their numbers are very few. In",
      "addition to boasting a strong body",
      "and great magical power, her singing",
      "voice can water down any man who",
      "hears it.",
      "",
      "Her ability to express emotion is",
      "poor, but she has a deep obsession",
      "with men and if she sees one, she",
      "will take him by force to become her",
      "husband. In addition to whispering",
      "her song of seduction into the man's",
      "ear as she hugs him, she will also",
      "thoroughly wash his body with the",
      "soapy bubbles that seep out of her",
      "skin, immersing him in ecstasy. Once",
      "he has been watered down, she will",
      "intersect with him. Of course,",
      "Lorelei's vagina is also amazing,",
      "and any man who tastes it will never",
      "want to leave her side again.",
      "",
      "Artist: frfr",
    ],
    319 => [
      "A young mermaid who is the Queen",
      "Mermaid's daughter. Having never left",
      "her mother's side, it seems as though",
      "she has never before appeared before a",
      "human that her mother hates so much.",
      "Due to her frequent swims in rough",
      "seas, her small body is surprisingly",
	  "strong. Although her direct sexual",
	  "experience is almost nothing, she has",
	  "received lots of instructions from her",
	  "mother.",
      "",
      "Though she is interested in humans,",
      "she also wants to catch a human and",
      "toy with them like other mermaids. But",
      "since human contact was forbidden to",
	  "her by her mother, she hasn't been",
	  "able to act on those desires.",
      "",
      "In addition, the starfish on her",
      "waist is an accessory bag. It contains",
      "pretty coral, shiny marbles, shells",
	  "and other treasures. Also assorted",
	  "candies to snack on.",
      "",
      "Artist: frfr",
    ],
    320 => [
      "The Queen Mermaid over all other",
      "Mermaids. She wields intense magical",
      "ability, and skilled sexual",
	  "techniques.",
	  "",
      "Ever since losing her lover due to a",
      "tragedy, she has hated humans. As",
      "other Mermaids have deepened their",
      "relationship with humans in recent",
      "years, she has only been associating",
      "with her own subordinates. However in",
      "recent years she has used the stored",
	  "semen from her lover to give birth to",
	  "a daughter, leading some to believe",
	  "she is fluctuating in her beliefs.",
      "",
      "Artist: frfr",
    ],
    321 => [
      "A monster belonging to the Arachne",
      "family that acts in a group. They",
      "attack men in swarms and cover them",
      "in viscous thread. Men who are",
      "caught by the group become their",
      "prey.",
      "",
      "Once caught in their web, the man's",
      "entire body will be entangled in",
      "sticky thread. His penis will also",
      "be covered with sticky thread,",
      "causing repeated ejaculations from",
      "the sticky feeling. Sometimes they",
      "will even force his penis into their",
      "spinnerets and make him ejaculate",
      "into it. They do not eat large prey,",
      "so there is no danger of the man",
      "being eaten by them. However, there",
      "is no escape from them, and a fate",
      "of being squeezed endlessly is all",
      "that awaits.",
      "",
      "Artist: D_AM",
    ],
    322 => [
      "A monster belonging to the Arachne",
      "family that acts in a group. They",
      "attack men in swarms and cover them",
      "in viscous thread. Men who are",
      "caught by the group become their",
      "prey.",
      "",
      "Once caught in their web, the man's",
      "entire body will be entangled in",
      "sticky thread. His penis will also",
      "be covered with sticky thread,",
      "causing repeated ejaculations from",
      "the sticky feeling. Sometimes they",
      "will even force his penis into their",
      "spinnerets and make him ejaculate",
      "into it. They do not eat large prey,",
      "so there is no danger of the man",
      "being eaten by them. However, there",
      "is no escape from them, and a fate",
      "of being squeezed endlessly is all",
      "that awaits.",
      "",
      "Artist: D_AM",
    ],
    323 => [
      "A monster belonging to the Arachne",
      "family that acts in a group. They",
      "attack men in swarms and cover them",
      "in viscous thread. Men who are",
      "caught by the group become their",
      "prey.",
      "",
      "Once caught in their web, the man's",
      "entire body will be entangled in",
      "sticky thread. His penis will also",
      "be covered with sticky thread,",
      "causing repeated ejaculations from",
      "the sticky feeling. Sometimes they",
      "will even force his penis into their",
      "spinnerets and make him ejaculate",
      "into it. They do not eat large prey,",
      "so there is no danger of the man",
      "being eaten by them. However, there",
      "is no escape from them, and a fate",
      "of being squeezed endlessly is all",
      "that awaits.",
      "",
      "Artist: D_AM",
    ],
    324 => [
      "A spider monster from the Yamatai Region.",
      "Following the Spider Princess's call,",
      "she joined in the attack on Grangold.",
      "Though her demeanor is soft, her heart",
      "is brutal and cold-blooded. If caught",
	  "in her webs, you can expect to be",
	  "sucked dry.",
      "",
      "Wielding high magic ability among",
      "insect monsters, she is even able to",
      "create a sort of alternate dimension,",
      "trapping prey in her own private",
      "space. The only way out is to either",
	  "defeat her, or be preyed on.",
      "",
      "Artist: UN_DO",
    ],
    325 => [
      "A spider monster serving the Spider",
      "Princess. One of the most influential",
      "of the Arachne family, her ability was",
      "on full display in the assault on",
      "Grangold. Using her superior physical",
	  "agility, she defeated swarms of",
	  "enemies in one fell swoop.",
      "",
      "Without exception, members of the",
      "Arachne family are cold-blooded and",
      "ruthless. Regardless of race and",
      "gender, she will forcefully entrap",
      "them in her web, and suck her prey",
	  "dry. Other monsters greatly dislike",
	  "members of the Arachne family for",
	  "their indiscriminate feeding habits.",
      "",
      "Artist: frfr",
    ],
    326 => [
      "An Arachne of the highest class,",
      "which boasts tremendous power. Very",
      "few of them exist, and it is said",
      "the blood of their ancient progenitor",
      "flows through them. Many of them",
      "follow the Spider Princess and are",
      "serving as her bodyguards.",
      "",
      "When capturing a man, she covers his",
      "entire body in threads that induce",
      "ecstasy. While he is immersed in the",
      "ecstasy of being wrapped in her",
      "cocoon, she will violate him. The",
      "man will be preserved in the cocoon",
      "and she will suck him whenever she",
      "feels like it. However, Atlach-Nacha",
      "can be very brutal, and will devour",
      "the man if she gets bored of him.",
      "With a brutal nature hidden under a",
      "polite attitude, she is an",
      "incredibly dangerous monster.",
      "",
      "Artist: frfr",
    ],
    327 => [
      "The new Queen of Spiders, reigning",
      "over all other spider monsters. Proud",
      "of her incredible physical and magical",
      "prowess, she is also a user of Yamatai",
	  "native Taoism.",
      "",
      "A brutal character, she will merci-",
      "lessly devour anyone she deems prey",
      "regardless of race or gender.",
      "Especially brutal towards men, she",
      "will first rape them until",
      "exhaustion, then feed on them",
      "without ever disguising her",
      "intentions. Due to her incredible",
      "power, she is regarded as an",
      "extremely dangerous monster that will",
      "never stop preying on others.",
      "",
      "A member of the Arachne family, she",
      "too is detested by other monsters of",
      "all types. As a result, the only ones",
      "who follow her act as she does,",
      "further ostracizing her group from the",
	  "rest of the monsters.",
      "",
      "Artist: Jingai Modoki",
    ],
    328 => [
      "A high-level vampire who, despite",
      "having a student's body, is skilled",
      "in combat. Having mastered various",
      "sword skills, she is prideful of her",
      "strong fighting abilities. She",
      "usually lives in the Vampire Queen's",
      "Castle and rarely ever leaves except",
      "on special occasions.",
      "",
      "Any prey she captures will have both",
      "their blood and semen thoroughly",
      "sucked. Men who are sucked by",
      "Conquista will shoot out semen as",
      "they soak in ecstasy. Blood, of",
      "course, is her nourishment, as well",
      "as the released semen. In addition,",
      "if she deems the man's semen to be",
      "of high quality, she may also rape",
      "him. The utmost pleasure is",
      "experienced during intercourse with",
      "a vampire as her vagina sucks in all",
      "of the man's semen and leaves him",
      "dry.",
      "",
      "Artist: UN_DO",
    ],
    329 => [
      "A high-level vampire who is skilled",
      "with magic. She has mastered several",
      "advanced spells and her overall",
      "combat ability is superb. She",
      "usually lives in the Vampire Queen's",
      "Castle and rarely ever goes outside.",
      "",
      "Always searching for magical power,",
      "she feeds upon the men she captures",
      "without exception. In addition to",
      "completely wrapping the man in her",
      "cloak to absorb his blood and semen,",
      "she may also drain semen by",
      "intersecting with her vagina. Men",
      "who are raped by Vendetta will taste",
      "the utmost pleasure as they dedicate",
      "all of their semen to her and dry",
      "up.",
      "",
      "Artist: UN_DO",
    ],
    330 => [
      "A vampire belonging to the highest",
      "species among her race. She has",
      "leech-shaped sucking tentacles",
      "attached to her body, which bear the",
      "characteristics of an ancient blood-",
      "sucking species. They number in the",
      "few, but their physical and magical",
      "capabilities are extremely high.",
      "She only lives in the Vampire",
      "Queen's Castle and almost never goes",
      "outside.",
      "",
      "Men caught by an Elder Vampire will",
      "have their necks pierced by her",
      "fangs and their blood sucked out",
      "rapidly. If she likes the man, she",
      "will squeeze him with the huge",
      "sucking tentacles on her lower body.",
      "She will squeeze his entire body to",
      "suck out semen until he is dried up.",
      "",
      "Artist: Setouchi",
    ],
    331 => [
      "A high-ranking Vampire that is one of",
      "the two aides to the Queen Vampire.",
      "Proud of her magical power, equivalent",
      "to a Queen's, she assists the Queen",
	  "Vampire as her right hand.",
      "",
      "Though she seems calm and gentle on",
      "the outside, she is merciless against",
      "those who would challenge her or the",
      "Queen. It is said that she will",
      "cold-heartedly suck out both the semen",
      "and energy from those who challenged",
	  "her. Though if her opponents aren't",
	  "hostile to her, she won't kill them.",
	  "If a submissive attitude is shown, she",
	  "will simply capture the male as feed.",
      "",
      "A high-ranking Vampire's cloak is a",
      "part of their body, and can be freely",
      "manipulated like other Monster's",
      "tentacles. In addition, she is able to",
	  "infuse it with magic to suck her",
	  "prey's blood. If wrapped up in her",
	  "cloak, both the male's semen and blood",
	  "can be drawn out with ease.",
      "",
      "Artist: Silk",
    ],
    332 => [
      "A high-ranking Vampire that is one of",
      "the two aides to the Queen Vampire.",
      "Along with Carmilla, they are known as",
	  "the Queen's Royal Guards.",
      "",
      "Despite her appearance, she is several",
      "hundred years old, and very arrogant.",
      "But considering herself a noble, she",
      "doesn't torment the weak and powerless",
      "for no reason. But opponents who",
      "challenge her, prepared for the",
      "outcome, are shown no mercy as she",
	  "sucks them dry.",
      "",
      "Like other high-ranking vampires, she",
      "can control her cloak freely. Infusing",
      "her cloak with magic, she can use it",
      "to absorb semen and energy from her",
	  "prey just as easily as if it was her",
	  "mouth.",
      "",
      "Artist: Silk",
    ],
    333 => [
      "The Queen of all Vampires, ruling over",
      "the night world. Wielding powerful",
      "magic and great majesty about her, the",
      "Queen's subordinates all kneel before",
      "her. In addition, it seems her biggest",
	  "ambition is to build a Kingdom of",
	  "Vampires.",
      "",
      "She will not raise her hand towards",
      "those who follow her, but will",
      "mercilessly kill those who resist.",
      "Raping her opponent, she will suck out",
      "their blood and semen until they are",
      "exhausted. One who is sucked dry by",
	  "the Queen herself will feel the finest",
	  "of pleasures as they die.",
      "",
      "Artist: Silk",
    ],
    334 => [
      "An advanced variant of the Ghost",
      "race, she wields powerful magic and",
      "a terrible grudge. A large amount of",
      "ectoplasm drips from her form,",
      "giving her a viscous body. Such",
      "ghosts are said to only inhabit",
      "places with high spiritual energy,",
      "and these places only seem to exist",
      "around the continent of Hellgondo.",
      "",
      "When she discovers a man, she will",
      "use her sticky ectoplasm to drain",
      "his energy. Being drained through",
      "contact with her spiritual body is",
      "accompanied by a melty pleasure and",
      "will cause the man to repeatedly",
      "climax, shooting semen all over.",
      "Like this, her pitiful prey will be",
      "sucked dry up while covered in",
      "ectoplasm.",
      "",
      "Artist: Setouchi",
    ],
    335 => [
      "A Youkai who can turn her body into",
      "smoke, she appears to be a variant",
      "of the Ghost race. She is among the",
      "strongest of the Youkai species,",
      "with immense spiritual powers that",
      "she demonstrates in combat by",
      "exerting intense pressure. She is a",
      "very rare species that only lives",
      "around Hellgondo. Moreover, she also",
      "appears to be on good terms with the",
      "Kirins, who inhabit the same area.",
      "",
      "Replenishing her spiritual power is",
      "done by intersecting with men and",
      "feeding upon their semen after",
      "restraining them. The man captured",
      "by her will be forced to embrace",
      "the smoke wrapping around him as it",
      "squeezes his semen until he is on",
      "the verge of dying from exhaustion.",
      "It appears she does not intend to",
      "take away his life, so after",
      "draining his semen, she will send",
      "him to a safe place.",
      "",
      "Artist: rai-rai chika sa",
    ],
    336 => [
      "An advanced Youkai species only",
      "found on the Hellgondo continent.",
      "Despite her young appearance, she",
      "is actually hundreds of years old",
      "and is said the be the oldest among",
      "the Youkai race, which consists of",
      "many ancient species. The blood of",
      "dragons also flows through her",
      "veins, granting her immense power.",
      "Her ability to manipulate lightning",
      "is outstanding, and she was once",
      "believed to be the incarnation of",
      "thunder in Yamatai's past. Since she",
      "is not unique but an individual",
      "within a species, there are several",
      "Kirins, but the actual number of",
      "them is very small.",
      "",
      "She has a sadistic side to her as",
      "well, and will torture the men she",
      "captures with electric shocks.",
      "If she directs these shocks to the",
      "penis, the man will be forced to",
      "ejaculate against his will. If she",
      "considers the man to possess high-",
      "quality genes, she may choose to",
      "mate with him. Men who mate with her",
      "will dedicate lots of semen to her",
      "narrow vagina to contribute to the",
      "procreation of the oldest Youkai",
      "species.",
      "",
      "Artist: rai-rai chika sa",
    ],
    337 => [
      "A very powerful Youkai with snakes",
      "around her body. In addition to",
      "having incredible vitality and",
      "magical power, she is also very",
      "brutal and sadistic, giving her a",
      "reputation for being extremely",
      "dangerous among Youkai. However,",
      "because she only inhabits the",
      "continent of Hellgondo, ordinary",
      "people will never encounter her.",
      "",
      "If you are caught by the Jakotsu",
      "Girl, she will coil her snakes",
      "around you and violate you with",
      "them. Sometimes she will rape you",
      "as you're bound, wringing out semen",
      "until your death. In addition, she",
      "may also swallow you whole while",
      "you are still alive, making her an",
      "extremely brutal and dangerous",
      "monster.",
      "",
      "Artist: Setouchi",
    ],
    338 => [
      "A huge, famous monster. Though she's",
      "famous, there are almost no humans who",
      "have actually seen her due to her",
      "reclusive habitat on the northern",
      "continent. An incredibly powerful",
      "monster, even the most experienced",
      "soldiers can't stand against her in a",
      "match of physical prowess. Besides her",
      "incredible physical strength, she can",
      "also bind her catch with her tail, and",
      "slowly violates them as she pleases.",
	  "",
	  "When catching a man, she will rape him",
	  "without mercy. If she likes him, she",
	  "will even mate with him for",
      "reproductive purposes. In that case,",
	  "she will bring him back to her den and",
	  "keep him as her personal sex slave.",
      "",
      "Artist: Thomas",
    ],
    339 => [
      "A subspecies of the Dragon race, she",
      "is almost unmatched in aerial combat.",
      "Due to her known superiority in the",
      "sky, she was enlisted as an aerial",
      "defense soldier, to take down anyone",
      "attempting to enter the northern",
      "continent from the sky.",
	  "",
      "A ferocious monster, she will squeeze",
      "the semen out of her prey without any",
      "mercy. Raping the man as she flies",
      "through the air, her catch is left",
      "completely at her mercy due to the",
      "inevitable death from the fall. In",
	  "addition, it appears as though she",
	  "prefers to mate for reproductive",
	  "purposes while flying through the",
	  "clear sky. In most cases, the man is",
	  "raped until his death.",
      "",
      "Artist: Thomas",
    ],
    340 => [
      "A subspecies of the Dragon race with a",
      "gigantic body. Her movements are slow,",
      "and her intelligence is low, but her",
      "power is incredible. A common human",
	  "being cannot hope to fight against",
	  "her.",
      "",
      "When fortunate enough to find a human",
      "male, she will suck on him in her",
      "giant mouth, extracting his semen.",
      "Though her tongue is gigantic, she can",
      "skillfully control it to easily make",
      "the man ejaculate inside her mouth.",
	  "",
      "Though she is surprisingly gentle and",
      "quiet, she is still a carnivorous",
      "monster. She's a dangerous monster,",
	  "but is only known to inhabit the",
	  "northern continent.",
      "",
      "Artist: Setouchi",
    ],
    341 => [
      "A succubus who has trained herself",
      "in martial arts. Thanks to her",
      "training, her combat abilities are",
      "extremely high and comparable to",
      "seasoned demons. Her martial arts and",
      "highly agile body more than make up",
      "for the inherently poor strength of",
      "the Succubus race. She engages in a",
      "friendly rivalry with the Demon",
      "Monk, and the two often have fist-",
      "fighting contests within the castle.",
      "",
      "Since she is a Succubus, she still",
      "takes the most pleasure in capturing",
      "men. Any warrior she defeats will",
      "be thoroughly violated by her thick,",
      "refined body. The man will be",
      "forcibly held down and rendered",
      "powerless to resist her squeezing.",
      "He will be forced to come repeatedly",
      "to satisfy the taste and appetite of",
      "the Succubus Monk.",
      "",
      "Artist: makiya",
    ],
    342 => [
      "A veteran demon who pursues martial",
      "arts. She uses her robust body and",
      "high magical power for her martial",
      "arts and is skilled with magical",
      "fist techniques. With her extremely",
      "high combat abilities, she is a",
      "monster who is allowed to live in",
      "the Monster Lord's Castle. She",
      "engages in a friendly rivalry with",
      "the Succubus Monk, and the two often",
      "have fist-fighting contests within",
      "the castle.",
      "",
      "Men who challenge her and lose are",
      "forcefully violated by her. The",
      "Demon Monk uses her powerful vaginal",
      "muscles to violently squeeze the",
      "man, causing him to writhe in",
      "agonizing pleasure. After having his",
      "semen wrung out, the man is left",
      "abandoned and exhausted.",
      "",
      "Artist: makiya",
    ],
    343 => [
      "An advanced Scylla serving at the",
      "Monster Lord's Castle. In addition",
      "to her skills as a maid, she is",
      "highly proficient in combat and is",
      "also responsible for guarding the",
      "castle. Her cooking skills are",
      "excellent, and her sexual techniques",
      "are top-notch. She is a master maid",
      "with all of the skills necessary for",
      "working in the Monster Lord's",
      "Castle.",
      "",
      "She is very ruthless underneath her",
      "polite attitude, and will completely",
      "humiliate intruders using her",
      "tentacles. In addition to",
      "mercilessly playing with the man's",
      "genitals with her tentacles to force",
      "repeated ejaculations, she may",
      "sometimes rape the man to suck up",
      "his semen. In most cases the man is",
      "exhausted by the time she intersects",
      "with him. If the Scylla Servant",
      "likes the man, she may keep him as a",
      "prisoner. In this case he will",
      "continue to receive endless pleasure",
      "service as he is quickly deprived of",
      "his sanity.",
      "",
      "Artist: xelvy",
    ],
    344 => [
      "A mutated Yoma that wields both holy",
      "and dark power. Although she has",
      "very strong magical powers, she is",
      "just an unusual monster who can use",
      "holy powers, and is unable to",
      "perform the holy-dark fusion of",
      "chaos. She generally resides in the",
      "Monster Lord's Castle and rarely",
      "goes outside.",
      "",
      "She requires human semen to supply",
      "her magical power, and will give",
      "pleasure to any man she captures to",
      "make him ejaculate many times to",
      "feed on them. If she likes a man,",
      "she will use her vagina to",
      "thoroughly squeeze out his semen.",
      "Her vagina has both divine and",
      "demonic properties at the same time,",
      "and can alternate between giving",
      "heavenly pleasure or hellish",
      "stimulation. No man raped by her",
      "vagina will be able to hold onto",
      "their sanity.",
      "",
      "Artist: Neko Manma",
    ],
    345 => [
      "One of the famous Three Nobles of",
      "Black, who directly serve as Black",
      "Alice's confidants. They are",
      "extremely powerful and are the",
      "highest-ranking lieutenants among",
      "Black Alice's subordinates.",
      "",
      "Black Dahlia is a succubus of the",
      "highest class, but she also",
      "possesses great fighting talent and",
      "excels at combat. Naturally, her",
      "power as a succubus is also top-",
      "notch and she is able to drain a",
      "man's very soul with her skills.",
      "Men who become her prey will be",
      "squeezed dry as they become",
      "intoxicated by the dreamlike",
      "pleasure.",
      "",
      "Artist: D_AM",
    ],
    346 => [
      "One of the famous Three Nobles of",
      "Black, who directly serve as Black",
      "Alice's confidants. They are",
      "extremely powerful and are the",
      "highest-ranking lieutenants among",
      "Black Alice's subordinates.",
      "",
      "Black Mamba is one of the strongest",
      "lamias, and her skills as a warrior",
      "were the greatest in the world five-",
      "hundred years ago. Her spear has a",
      "reputation for being able to pierce",
      "anything, but because she prefers",
      "not to end battles quickly, she",
      "fights rather cautiously. Any man",
      "she defeats will become her prey",
      "and have their semen squeezed.",
      "She isn't very brutal for a lamia,",
      "and rarely kills men with pleasure.",
      "",
      "Artist: D_AM",
    ],
    347 => [
      "One of the famous Three Nobles of",
      "Black, who directly serve as Black",
      "Alice's confidants. They are",
      "extremely powerful and are the",
      "highest-ranking lieutenants among",
      "Black Alice's subordinates.",
      "",
      "Black Rose is a supreme vampire who",
      "boasted the strongest magical power",
      "in the world five hundred years ago.",
      "She is polite but cruel, and anyone",
      "she catches will become her",
      "nourishment as she sucks their blood",
      "and semen dry.",
      "",
      "Artist: D_AM",
    ],
    348 => [
      "A legendary warmongering Monster Lord",
      "that was struck down by Heinrich. She",
      "was said to wield incredibly high-",
	  "powered magic, and greedy ambitions.",
      "",
      "Artist: Setouchi",
    ],
    349 => [
      "Black Alice, a former Monster Lord in",
      "her stronger form. Numerous monster",
      "organs cover her body, enabling her to",
      "devour men in countless ways.",
      "",
      "Even in this form, it doesn't seem",
      "as if she's truly showing all of her",
      "power. If defeated, expect to be",
      "preyed on in a horrible way...",
      "",
      "Artist: Setouchi",
    ],
    350 => [
      "Black Alice, a former Monster Lord,",
      "now unleashing her true power.",
      "Comprised of the genes of seemingly",
      "every monster that has ever existed,",
	  "her tremendous power is on full",
	  "display",
      "",
      "Artist: Setouchi",
    ],
    351 => [
      "A high-level witch wielding the",
      "power of ice. In order to constantly",
      "harness the ice element, she lives",
      "in cold regions. Proud of her",
      "enormous magical power, she is an",
      "exceptional witch capable of",
      "freezing her entire surroundings.",
      "",
      "Human semen is also an important",
      "energy source for her, and if her",
      "opponent is a man, she will",
      "replenish her magical power through",
      "sexual intercourse. Any man who",
      "tastes the cold flesh of the Ice",
      "Witch's vagina will dedicate all of",
      "his semen to her while experiencing",
      "the finest pleasure. After his semen",
      "is drained by the witch, he will",
      "meet a cold end underneath her.",
      "",
      "Artist: Stealth Changing Line",
    ],
    352 => [
      "A polar bear monster that inhabits",
      "cold regions. Despite living in a",
      "cold region, she still feels cold,",
      "so she is dressed in cold-weather",
      "clothes she obtained from somewhere.",
      "Her staple food is fish and while",
      "she usually plays around calmly, she",
      "reveals a ferocious side towards",
      "people who step into her territory.",
      "Her power is unmatched among beast",
      "monsters, toppling her enemies with",
      "overwhelming strength and ice",
      "breath.",
      "",
      "Despite being lonely, she has a",
      "friendly personality and sometimes",
      "stays close to humans and other",
      "monsters in search of warmth. If the",
      "other person is a human male, she",
      "is likely to push him down and bring",
      "him to mate with her. The Polar Bear",
      "Girl's vagina is hot enough to melt",
      "away the cold and lead the man to",
      "immediately release his semen into",
      "her flesh hole within moments. If",
      "the Polar Bear Girl becomes friendly",
      "towards him, she'll never let him",
      "go. Feeling sentimental, she will",
      "bring the man back to her den and",
      "live together with him.",
      "",
      "Artist: Setouchi",
    ],
    353 => [
      "Angels belonging to the lowest circle,",
      "their main role lies in subjugating",
      "criminals and carrying out the wrath",
      "of the Heavens. Though their combat",
      "abilities are each equal to a high-",
      "ranking monster, their power goes way",
	  "up when they combine together. They",
	  "have been known to destroy extremely",
	  "powerful enemies with their powerful",
	  "combination attacks.",
      "",
      "The items they carry are mainly used",
      "on human men who break one of the five",
      "commandments of Ilias. Though their",
      "individual personalities are slightly",
	  "different, they are all similar in",
	  "their strictness with sinners.",
      "",
      "However, due to Heaven's",
      "disappearance, they reside on the",
      "surface world and as a result, their",
	  "power has greatly diminished. Even so,",
	  "they can still handle the odd Yoma or",
	  "two.",
      "",
      "Artist: Arekishi",
    ],
    354 => [
      "Angels belonging to the lowest circle,",
      "their main role lies in subjugating",
      "criminals and carrying out the wrath",
      "of the Heavens. Though their combat",
      "abilities are each equal to a high-",
      "ranking monster, their power goes way",
	  "up when they combine together. They",
	  "have been known to destroy extremely",
	  "powerful enemies with their powerful",
	  "combination attacks.",
      "",
      "The items they carry are mainly used",
      "on human men who break one of the five",
      "commandments of Ilias. Though their",
      "individual personalities are slightly",
	  "different, they are all similar in",
	  "their strictness with sinners.",
      "",
      "However, due to Heaven's",
      "disappearance, they reside on the",
      "surface world and as a result, their",
	  "power has greatly diminished. Even so,",
	  "they can still handle the odd Yoma or",
	  "two.",
      "",
      "Artist: Arekishi",
    ],
    355 => [
      "Angels belonging to the lowest circle,",
      "their main role lies in subjugating",
      "criminals and carrying out the wrath",
      "of the Heavens. Though their combat",
      "abilities are each equal to a high-",
      "ranking monster, their power goes way",
	  "up when they combine together. They",
	  "have been known to destroy extremely",
	  "powerful enemies with their powerful",
	  "combination attacks.",
      "",
      "The items they carry are mainly used",
      "on human men who break one of the five",
      "commandments of Ilias. Though their",
      "individual personalities are slightly",
	  "different, they are all similar in",
	  "their strictness with sinners.",
      "",
      "However, due to Heaven's",
      "disappearance, they reside on the",
      "surface world and as a result, their",
	  "power has greatly diminished. Even so,",
	  "they can still handle the odd Yoma or",
	  "two.",
      "",
      "Artist: Arekishi",
    ],
    356 => [
      "Angels belonging to the lowest circle,",
      "their main role lies in subjugating",
      "criminals and carrying out the wrath",
      "of the Heavens. Though their combat",
      "abilities are each equal to a high-",
      "ranking monster, their power goes way",
	  "up when they combine together. They",
	  "have been known to destroy extremely",
	  "powerful enemies with their powerful",
	  "combination attacks.",
      "",
      "The items they carry are mainly used",
      "on human men who break one of the five",
      "commandments of Ilias. Though their",
      "individual personalities are slightly",
	  "different, they are all similar in",
	  "their strictness with sinners.",
      "",
      "However, due to Heaven's",
      "disappearance, they reside on the",
      "surface world and as a result, their",
	  "power has greatly diminished. Even so,",
	  "they can still handle the odd Yoma or",
	  "two.",
      "",
      "Artist: Arekishi",
    ],
    357 => [
      "Angels belonging to the lowest circle,",
      "their main role lies in subjugating",
      "criminals and carrying out the wrath",
      "of the Heavens. Though their combat",
      "abilities are each equal to a high-",
      "ranking monster, their power goes way",
	  "up when they combine together. They",
	  "have been known to destroy extremely",
	  "powerful enemies with their powerful",
	  "combination attacks.",
      "",
      "The items they carry are mainly used",
      "on human men who break one of the five",
      "commandments of Ilias. Though their",
      "individual personalities are slightly",
	  "different, they are all similar in",
	  "their strictness with sinners.",
      "",
      "However, due to Heaven's",
      "disappearance, they reside on the",
      "surface world and as a result, their",
	  "power has greatly diminished. Even so,",
	  "they can still handle the odd Yoma or",
	  "two.",
      "",
      "Artist: Arekishi",
    ],
    358 => [
      "A special group of angels that belong",
      "to the lowest circle. Their battle",
      "abilities are similar to a normal",
      "angel when by themselves, but when",
      "together their power rivals that of",
      "Archangels. But offensive combat is",
      "not their primary role. Their",
	  "special duty is to brainwash and",
	  "punish sinners.",
      "",
      "Though their characters are kind and",
      "gentle, like other angels they show no",
      "mercy to sinners. Specializing in a",
      "technique called the",
      "Cross of Pleasure, they punish a",
      "sinner with pleasure as a group. No",
	  "matter the sinner, they eventually",
	  "drown in pleasure and end up devoting",
	  "themselves fully to the angels and",
	  "Goddess.",
      "",
      "However, due to Heaven's",
      "disappearance, they reside on the",
      "surface world and as a result, their",
	  "power has greatly diminished. Even so,",
	  "they can still handle the odd Yoma or",
	  "two.",
      "",
      "Artist: D_AM",
    ],
    359 => [
      "A special group of angels that belong",
      "to the lowest circle. Their battle",
      "abilities are similar to a normal",
      "angel when by themselves, but when",
      "together their power rivals that of",
      "Archangels. But offensive combat is",
      "not their primary role. Their",
	  "special duty is to brainwash and",
	  "punish sinners.",
      "",
      "Though their characters are kind and",
      "gentle, like other angels they show no",
      "mercy to sinners. Specializing in a",
      "technique called the",
      "Cross of Pleasure, they punish a",
      "sinner with pleasure as a group. No",
	  "matter the sinner, they eventually",
	  "drown in pleasure and end up devoting",
	  "themselves fully to the angels and",
	  "Goddess.",
      "",
      "However, due to Heaven's",
      "disappearance, they reside on the",
      "surface world and as a result, their",
	  "power has greatly diminished. Even so,",
	  "they can still handle the odd Yoma or",
	  "two.",
      "",
      "Artist: D_AM",
    ],
    360 => [
      "A special group of angels that belong",
      "to the lowest circle. Their battle",
      "abilities are similar to a normal",
      "angel when by themselves, but when",
      "together their power rivals that of",
      "Archangels. But offensive combat is",
      "not their primary role. Their",
	  "special duty is to brainwash and",
	  "punish sinners.",
      "",
      "Though their characters are kind and",
      "gentle, like other angels they show no",
      "mercy to sinners. Specializing in a",
      "technique called the",
      "Cross of Pleasure, they punish a",
      "sinner with pleasure as a group. No",
	  "matter the sinner, they eventually",
	  "drown in pleasure and end up devoting",
	  "themselves fully to the angels and",
	  "Goddess.",
      "",
      "However, due to Heaven's",
      "disappearance, they reside on the",
      "surface world and as a result, their",
	  "power has greatly diminished. Even so,",
	  "they can still handle the odd Yoma or",
	  "two.",
      "",
      "Artist: D_AM",
    ],
    361 => [
      "An angel belonging to the ninth",
      "circle of the angel hierarchy, she",
      "is a beast carrying holy power. Uranus,",
      "also known as the Holy Beast, gives",
      "protection to people on the surface,",
      "and is sometimes even revered as a",
      "messenger of the Goddess. She also",
      "excels in her ability to hunt",
      "sinners, and whenever she senses",
      "blasphemers, she attacks then",
      "greedily devours them in the",
      "name of the Goddess.",
      "",
      "Her abdomen is comprised of",
      "undulating thick flesh and is",
      "Uranus' predation organ, which draws",
      "humans into her flesh pool and melts",
      "them. It induces a great amount of",
      "pleasure, so if the sinner is a man,",
      "he will gush out semen as the Holy",
      "Beast devours him.",
      "",
      "However, due to Heaven's",
      "disappearance, she resides on the",
      "surface world and as a result, her",
      "power has greatly diminished. Even so,",
      "she can still handle the odd Yoma or",
      "two.",
      "",
      "Artist: Delphinus",
    ],
    362 => [
      "An angel belonging to the ninth",
      "circle of the angel hierarchy, her",
      "role is the fertilization of the",
      "earth. Using her plant attributes,",
      "she is able to produce ripe fruits",
      "from her body.",
      "",
      "Normally her mission is to give",
      "blessings to humans on the surface,",
      "but in the event she finds a sinner,",
      "she will forcibly bind and take him",
      "into her body where countless fruits",
      "will rape him. The pathetic sinner",
      "will ascend to heaven as he tastes",
      "the pleasure of the fruit, and be",
      "reborn as a new fruit produced by",
      "Eliciel.",
      "",
      "However, due to Heaven's",
      "disappearance, she resides on the",
      "surface world and as a result, her",
      "power has greatly diminished. Even so,",
      "she can still handle the odd Yoma or",
      "two.",
      "",
      "Artist: Delphinus",
    ],
    363 => [
      "An angel controlling love, she is in",
      "the ninth and lowest hierarchy in the",
      "classification of angels. Cupid uses",
      "her bow and arrows to disturb the",
      "heart of her target. Her duty was to",
      "ensure that descendants were left by",
      "joining together men and women. Though",
      "combat is not her primary role, she",
	  "sometimes plays support by using her",
	  "bow and arrow from range.",
      "",
      "Incredibly debauched, she considers",
      "raping human men to be the ultimate of",
      "pleasures. However, since contact with",
      "humans outside of her normal duties is",
      "forbidden, she takes it upon herself",
	  "to look for sinners to personally",
	  "punish. Giving into her carnal lust,",
	  "she rapes the sinner until he breaks",
	  "apart.",
      "",
      "However, due to Heaven's",
      "disappearance, she resides on the",
      "surface world and as a result, her",
	  "power has greatly diminished. Even so,",
	  "she can still handle the odd Yoma or",
	  "two.",
      "",
      "Artist: frfr",
    ],
    364 => [
      "An angel proud of her combat ability,",
      "she rates among the highest of the",
      "angels usually tasked with going to",
      "the surface world. She is usually the",
      "head of the subjugation forces",
      "assigned to eliminate high-ranking",
	  "monsters or groups of monsters. She",
	  "belongs to the lowest of the nine",
	  "circles of angels (known simply as",
	  "Angels), but it has been said her",
	  "promotion to Archangel class is close.",
      "",
      "Valkyrie is known for being very",
      "faithful to her mission, almost seeming",
      "indifferent as she carries out her",
      "duties. She is usually paired with",
      "Cupid. During operations where she has",
      "taken out powerful monsters, she has",
      "punished the human men enraptured by",
      "them with rape. Wielding powerful",
	  "sexual skills, she rapes the sinners",
	  "with that same look of indifference on",
	  "her face. No matter the reason,",
	  "Valkyrie will never forgive a man who",
	  "mates with a monster.",
      "",
      "However, due to Heaven's",
      "disappearance, she resides on the",
      "surface world and as a result, her",
	  "power has greatly diminished. Even so,",
	  "she can still handle the odd Yoma or",
	  "two.",
      "",
      "Artist: frfr",
    ],
    365 => [
      "The highest and only member of the",
      "Seraphim class of angels.",
      "Effectively Ilias' second in",
      "command, she is in charge of all",
      "other angels. Completely loyal to",
      "Ilias, she will obey any command",
      "given, no matter what. Due to her",
      "extreme faith, she cannot tolerate",
      "anything negative said against",
      "Ilias.",
      "",
      "After falling to the surface world,",
      "she proceeded to create a barrier",
      "around the Ilias Temple, which was",
      "the main source of the dimensional",
      "anomaly, as she prayed to the",
      "Goddess Ilias. Maintaining a barrier",
      "which stopped the flow of time for",
      "decades has taken a serious toll on",
      "her body, and Eden's tremendous",
      "power, also known as the Garden of",
      "Paradise itself, has been lost now.",
      "",
      "Artist: Setouchi",
    ],
    366 => [
      "An apoptosized angel from the ruined",
      "Ilias Temple. She used to be just an",
      "ordinary angel, but her hair had",
      "been transformed by the anomaly,",
      "and she is able to control it as a",
      "weapon. Her magical power is also",
      "immense, and she uses a powerful",
      "combination of black magic and holy",
      "techniques.",
      "",
      "Because she was sealed in the Ilias",
      "Temple of another world, she did",
      "not encounter anyone. Following her",
      "Apoptosis instincts, she mercilessly",
      "eliminates intruders and uses her",
      "hair to thoroughly extract semen.",
      "She is an extremely dangerous entity",
      "who will drain humans without",
      "hesitation.",
      "",
      "Artist: Delphinus",
    ],
    367 => [
      "An apoptosized angel from the ruined",
      "Ilias Temple. She used to be just an",
      "ordinary angel, but has been fused",
      "with other angels by the anomaly.",
      "Her power is tremendous, and her",
      "holy waves will annihilate all of",
      "her enemies.",
      "",
      "Because she was sealed in the Ilias",
      "Temple of another world, she did",
      "not encounter anyone. Following her",
      "Apoptosis instincts, she mercilessly",
      "eliminates intruders and uses her",
      "multiple female bodies to thoroughly",
      "extract semen. She is an extremely",
      "dangerous entity who will drain",
      "humans without hesitation.",
      "",
      "Artist: Delphinus",
    ],
    368 => [
      "Sonya after awakening as a XX-type",
      "Apoptosis, her absorption of holy",
      "energy has changed her into this",
      "form. Although she boasts tremendous",
      "power, there are many uncertainties",
      "surrounding her existence, most of",
      "which are shrouded in mystery.",
      "",
      "Artist: xelvy",
    ],
    369 => [
      "Sonya after awakening as a XX-type",
      "Apoptosis, her absorption of dark",
      "energy has changed her into this",
      "form. Although she boasts tremendous",
      "power, there are many uncertainties",
      "surrounding her existence, most of",
      "which are shrouded in mystery.",
      "",
      "Artist: xelvy",
    ],
    370 => [
      "Sonya after awakening as a XX-type",
      "Apoptosis, her absorption of holy",
      "and dark energy has changed her into",
      "this form. This fusion of holy and",
      "dark energy exerts a tremendous",
      "force that, if left unchecked,",
      "threatens to destroy the world.",
      "There are many uncertainties",
      "surrounding her existence, most of",
      "which are shrouded in mystery.",
      "",
      "Artist: xelvy",
    ],
    373 => [
      "A Chimeric Monster created in",
      "Promestein's laboratory, she is a",
      "beast that was given a variety of",
      "enhancements from different",
      "monsters. Though she appears to have",
      "no thoughts or feelings, the Chimera",
      "Beast is still just as agile and",
      "instinctual as a hunting beast may",
      "be. Though it speaks in an",
      "intelligible language, her speech",
      "pattern is unnatural.",
      "",
      "After catching her prey, she uses",
      "her long tongue and sexual skills to",
      "extract his semen. In addition, she",
      "is able to force him to the ground",
      "and forcibly rape him.",
      "",
      "In addition, the ones currently",
      "wandering around the Temple of Ilias",
      "appear to have been samples that",
      "were kept there. It seems",
      "chaosization has been slow to affect",
      "her due to her artificial body and",
      "thus the apoptosis effect has been",
      "diminished compared to other",
      "organisms.",
      "",
      "Artist: Setouchi",
    ],
    374 => [
      "An early experimental organism",
      "created in Promestein's laboratory",
      "that is a mix of human, slime and",
      "tentacle monster embryos. Though",
      "there was no issue with her ability",
      "to survive, her combat capabilities",
      "were not as high as desired, so she",
      "was considered a failure.",
      "",
      "Still, if her opponent is a male",
      "soldier, she is still able to",
      "overcome and greedily feast on his",
      "semen. She is able to control both",
      "her slimy lower body and tentacles",
      "to give excellent pleasure to the",
      "male target. Using those organs,",
      "experiments have shown that she will",
      "continue to squeeze the man until",
      "his death. She can't match up to",
      "higher-ranking monsters, but she can",
      "still be quite dangerous to a man.",
      "",
      "In addition, the ones currently",
      "wandering around the Temple of Ilias",
      "appear to have been samples that",
      "were kept there. It seems",
      "chaosization has been slow to affect",
      "her due to her artificial body and",
      "thus the apoptosis effect has been",
      "diminished compared to other",
      "organisms.",
      "",
      "Artist: Setouchi",
    ],
    375 => [
      "A Chimeric Monster created in",
      "Promestein's laboratory, composed of",
      "a variety of organs from monsters",
      "and an angel's body. She was the",
      "result of early experiments in the",
      "direct transplantation of monster",
      "organs into the body of an angel. No",
      "good practical use was found for her,",
      "and she was simply kept in the tanks",
      "until now. Due to the primitive",
      "nature of the transplantation, it",
      "seems to have deeply impacted her",
      "memories and emotions. Her entire",
      "being seems to have degraded, and",
      "seeks to greedily devour male semen",
      "like a common monster.",
      "",
      "In addition, the ones currently",
      "wandering around the Temple of Ilias",
      "appear to have been samples that",
      "were kept there. It seems",
      "chaosization has been slow to affect",
      "her due to her artificial body and",
      "thus the apoptosis effect has been",
      "diminished compared to other",
      "organisms.",
      "",
      "Artist: Setouchi",
    ],
    376 => [
      "A Chimeric Monster created in",
      "Promestein's laboratory, she is a",
      "zombie created out of the corpse of",
      "an angel. Created at the very start",
      "of her research into using angels",
      "and zombies, she is technically",
      "incomplete in many regards. Her body",
      "is covered in bandages and charms in",
      "order to stop the rapid degradation",
      "of her body. She is regularly being",
      "fed a constant diet of human semen",
      "so that changes in her mental and",
      "physical state can be recorded.",
      "",
      "Since she was an early creation,",
      "both her physical and mental power",
      "are low. But data obtained from her",
      "experiments have led to improvements",
      "in later development.",
      "",
      "In addition, the ones currently",
      "wandering around the Temple of Ilias",
      "appear to have been samples that",
      "were kept there. It seems",
      "chaosization has been slow to affect",
      "her due to her artificial body and",
      "thus the apoptosis effect has been",
      "diminished compared to other",
      "organisms.",
      "",
      "Artist: Setouchi",
    ],
    377 => [
      "A Chimeric Monster created in",
      "Promestein's laboratory, she was an",
      "attempt to restore a species that",
      "inhabited the ancient ocean.",
      "Expressing the genes of tentacled",
      "sea-dwellers, she has a mucosal",
      "body and countless tentacles. In",
      "addition, her outer shell is very",
      "solid, and her survivability is",
      "extremely high.",
      "",
      "She feeds on semen, and when she",
      "spots a human male, she will extend",
      "her tentacles to restrain him. She",
      "will then stimulate his penis with",
      "her tentacles until he ejaculates,",
      "and feast on the released semen.",
      "",
      "In addition, the ones currently",
      "wandering around the Temple of Ilias",
      "appear to have been samples that",
      "were kept there. It seems",
      "chaosization has been slow to affect",
      "her due to her artificial body and",
      "thus the apoptosis effect has been",
      "diminished compared to other",
      "organisms.",
      "",
      "Artist: Setouchi",
    ],
    378 => [
      "La Croix's masterpiece creation,",
      "consisting of seven zombies. The six",
      "main Cirque du Croix members were",
      "all obtained by assassination or",
      "murder. All of them have undergone",
      "intense magical treatments, and have",
	  "become powerful undead monsters.",
      "",
      "A famous Monster Swordswoman,",
      "Fernandez. Even though she is from the",
      "normally physically weak Elf race, she",
      "developed her own sword techniques",
      "that revolved around her light, small",
      "frame. It was believed she secluded",
      "herself in intense training for the",
	  "remainder of her life, but in truth",
	  "she was killed by La Croix.",
      "",
      "Artist: UN_DO",
    ],
    379 => [
      "La Croix's masterpiece creation,",
      "consisting of seven zombies. The six",
      "main Cirque du Croix members were",
      "all obtained by assassination or",
      "murder. All of them have undergone",
      "intense magical treatments, and have",
	  "become powerful undead monsters.",
      "",
      "Titania was a mutation of a normal",
      "Fairy. Born with incredible magical",
      "power, it was said that she was in",
      "tune with nature as much as an actual",
      "spirit, and able to control the",
      "weather. As a result of her powerful",
      "magical mayhem, she got on the wrong",
      "side of the current Fairy Queen. She",
	  "went missing one day when she was out",
	  "playing. It was believed the Queen",
	  "Fairy had done something with her, but",
	  "in truth she was killed by La Croix.",
      "",
      "Artist: UN_DO",
    ],
    380 => [
      "La Croix's masterpiece creation,",
      "consisting of seven zombies. The six",
      "main Cirque du Croix members were",
      "all obtained by assassination or",
      "murder. All of them have undergone",
      "intense magical treatments, and have",
	  "become powerful undead monsters.",
      "",
      "Pirate Queen Roza was once known all",
      "across the seven seas. She lived in a",
      "different era than Selene, but the two",
      "of them are part of the Big Three of",
      "pirates. Her ship vanished in the",
      "middle of a voyage, and reappeared",
      "later as an empty ghost ship. In",
	  "truth, La Croix used chemical weapons",
	  "to kill everyone on board.",
      "",
      "Artist: UN_DO",
    ],
    381 => [
      "La Croix's masterpiece creation,",
      "consisting of seven zombies. The six",
      "main Cirque du Croix members were",
      "all obtained by assassination or",
      "murder. All of them have undergone",
      "intense magical treatments, and have",
	  "become powerful undead monsters.",
      "",
      "The calm Queen Lamia was known as the",
      "Lamia of Love due to her unusual",
      "gentle nature for a Lamia. During her",
      "reign, the frequent infighting among",
      "Lamias for the Queen's seat was",
      "finally stopped. But she was poisoned",
      "along with Queen Scylla at a banquet.",
      "Ever since, the internal infighting",
	  "has resumed, causing the current seat",
	  "of Queen Lamia to remain vacant.",
      "",
      "Artist: UN_DO",
    ],
    382 => [
      "La Croix's masterpiece creation,",
      "consisting of seven zombies. The six",
      "main Cirque du Croix members were",
      "all obtained by assassination or",
      "murder. All of them have undergone",
      "intense magical treatments, and have",
	  "become powerful undead monsters.",
      "",
      "The previous Queen Harpy waged war on",
      "the Ilias Continent with her mighty",
      "military. Holding an intense desire to",
      "expand her power, she waged war after",
      "war with the surrounding cities,",
      "nearly killing off the Harpy race as a",
      "result. She was believed to have been",
	  "killed in a battle, but in truth was",
	  "assassinated by a poison dart fired by",
	  "La Croix.",
      "",
      "Artist: UN_DO",
    ],
    383 => [
      "La Croix's masterpiece creation,",
      "consisting of seven zombies. The six",
      "main Cirque du Croix members were",
      "all obtained by assassination or",
      "murder. All of them have undergone",
      "intense magical treatments, and have",
	  "become powerful undead monsters.",
      "",
      "Queen Scylla was the Queen over all",
      "tentacle monsters. She was an",
      "incredibly powerful monster,",
      "especially for her race, but was",
      "killed by poison along with Queen",
      "Lamia. With their corpses taken soon",
	  "after their death, many were accused",
	  "of the crime, but none conclusively.",
      "",
      "Artist: UN_DO",
    ],
    384 => [
      "One of the Six Ancestors, who are",
      "regarded as the progenitors to all",
      "monsters, and confidant to the Dark",
      "Goddess Alipheese. With her nine tails,",
      "she is the leader of the Kitsune,",
      "who boasts tremendous magical power",
      "and cunning. She is said to have",
      "corrupted many countries, but little",
      "else is known about her.",
      "",
      "Artist: Shiki",
    ],
    385 => [
	  "Called the Queen Succubus, she is",
      "the most powerful of the succubi.",
      "One of the Four Heavenly Knights,",
      "she is a master of Wind magic. In",
      "addition, her flexible body makes",
      "her the most powerful hand to hand",
      "fighter of the Four Heavenly",
      "Knights. A moody woman, she is easy",
      "to hate. Living in the moment, all",
      "she cares about is her own pleasure.",
	  "Though she has no sense of loyalty,",
	  "she acknowledges the Monster Lord's",
	  "power, and follows her instructions.",
      "",
      "A lewd Monster, her only enjoyment",
      "in life is playing with men. Once",
      "she catches a man, she tries to",
      "finish him off using a wide variety",
      "of methods.",
      "Using her tail, it's said that the",
      "man will faint after tasting the",
      "overwhelming pleasure. After",
      "squeezing every drop of semen out of",
      "the man, she will usually eat them.",
      "In addition to being able to eat",
      "semen with her tail, she can expand",
	  "it to swallow men whole. Alma Elma",
	  "prefers powerful warriors who",
	  "challenge her instead of",
	  "weak ordinary men.",
      "",
      "Artist: Akazawa RED",
    ],
    455 => [
      "A being who arrived from another world.",
      "Further details are unknown.",
      "",
      "Artist: Nekomatakyo Alan",
    ],
    456 => [
      "A being who arrived from another world.",
      "Further details are unknown.",
      "",
      "Artist: Minwa",
    ],
    457 => [
      "A being who arrived from another world.",
      "Further details are unknown.",
      "",
      "Artist: Nekomatakyo Alan",
    ],
    460 => [
      "A being who arrived from another world.",
      "Further details are unknown.",
      "",
      "Artist: wiz",
      "H-scenes: Usuki",
    ],
    462 => [
      "A being who arrived from another world.",
      "Further details are unknown.",
      "",
      "Artist: Usuki",
    ],
    470 => [
      "A being who arrived from another world.",
      "Further details are unknown.",
      "",
      "Artist: Name John",
    ],
    471 => [
      "A being who arrived from another world.",
      "Further details are unknown.",
      "",
      "Artist: Name John",
    ],
    472 => [
      "A being who arrived from another world.",
      "Further details are unknown.",
      "",
      "Artist: Name John",
    ],
    473 => [
      "A being who arrived from another world.",
      "Further details are unknown.",
      "",
      "Artist: wiz",
      "H-Scenes: Usuki",
    ],
    474 => [
      "A being who arrived from another world.",
      "Further details are unknown.",
      "",
      "Artist: Nekomatakyo Alan",
    ],
    475 => [
      "A being who arrived from another world.",
      "Further details are unknown.",
      "",
      "Artist: sion",
      "H-Scenes: Usuki",
    ],
    476 => [
      "A being who arrived from another world.",
      "Further details are unknown.",
      "",
      "Artist: sion",
      "H-Scenes: Usuki",
    ],
    477 => [
      "A being who arrived from another world.",
      "Further details are unknown.",
      "",
      "Artist: Kage Neko",
    ],
    478 => [
      "A being who arrived from another world.",
      "Further details are unknown.",
      "",
      "Artist: Kage Neko",
    ],
    479 => [
      "A being who arrived from another world.",
      "Further details are unknown.",
      "",
      "Artist: Kage Neko",
    ],
    480 => [
      "A being who arrived from another world.",
      "Further details are unknown.",
      "",
      "Artist: Shiki",
    ],
    481 => [
      "A being who arrived from another world.",
      "Further details are unknown.",
      "",
      "Artist: Toki",
    ],
    482 => [
      "A being who arrived from another world.",
      "Further details are unknown.",
      "",
      "Artist: Jingai Modoki",
    ],
    483 => [
      "A being who arrived from another world.",
      "Further details are unknown.",
      "",
      "Artist: Name John",
    ],
    484 => [
      "A being who arrived from another world.",
      "Further details are unknown.",
      "",
      "Artist: Name John",
    ],
    485 => [
      "A being who arrived from another world.",
      "Further details are unknown.",
      "",
      "Artist: Name John",
    ],
    486 => [
      "A being who arrived from another world.",
      "Further details are unknown.",
      "",
      "Artist: wiz",
      "H scene: Usuki",
    ],
    487 => [
      "A being who arrived from another world.",
      "Further details are unknown.",
      "",
      "Artist: wiz",
      "H scene: Usuki",
    ],
    488 => [
      "A being who arrived from another world.",
      "Further details are unknown.",
      "",
      "Artist: Minwa",
    ],
    489 => [
      "A being who arrived from another world.",
      "Further details are unknown.",
      "",
      "Artist: Kage Neko",
    ],
    490 => [
      "A being who arrived from another world.",
      "Further details are unknown.",
      "",
      "Artist: Nekomatakyo Alan",
    ],
    491 => [
      "A being who arrived from another world.",
      "Further details are unknown.",
      "",
      "Artist: sion",
      "H-Scenes: Usuki",
    ],
    492 => [
      "A being who arrived from another world.",
      "Further details are unknown.",
      "",
      "Artist: raichi",
    ],
    494 => [
      "A being who arrived from another world.",
      "Further details are unknown.",
      "",
      "Artist: raichi",
    ],
    498 => [
      "The Lord of Lady's Village, she also",
      "competed against Alipheese the 15th",
      "for the Monster Lord's throne.",
      "Extremely strong, she is one of the",
      "most powerful monsters in the world.",
      "It appears as though she can trace",
      "her lineage far down the line to the",
      "Fateburn family.",
      "",
      "Holding the genes of many different",
      "monster lines in her, it seems as",
      "though she can produce offspring of",
      "many different types. In addition,",
      "she is able to control her flesh",
      "freely. Using that, she can form her",
      "digestive organ outside of her own",
      "body, and watch her prey be digested",
      "with her own eyes. Wrapping up her",
      "prey in her organ, Cassandra usually",
      "forces them to have multiple",
      "orgasms, until they have no semen",
      "left. After that, she enjoys",
      "watching them as they slowly",
      "dissolve away.",
      "",
      "Artist: Setouchi",
    ],
    501 => [
      "A great bird monster from an ancient",
      "tribe, revered as the Divine Bird.",
      "They are among the highest class of",
      "the Harpy race, and were worshipped as",
      "Earth Mothers in ancient times, but",
      "their numbers had fallen drastically",
      "during the Great Monster Wars. To this",
      "day, there is only a single individual",
      "in existence in any era, of whom only",
      "a few know it even exists. They are",
      "said to only lay a single egg at the",
      "Holy Wings Shrine in their lifetime,",
      "ensuring only a single descendant for",
      "the next generation.",
      "",
      "They are gentle-natured, but also very",
      "prideful, and will never bond with",
      "anyone they consider to be inferior to",
      "themselves. However, they are loyal to",
      "anyone who they recognize as their",
      "master, and will allow them to ride on",
      "their back as they soar across the",
      "skies with their majestic wings.",
      "",
      "They prefer a diet of meat, but they",
      "do not appear to attack humans or",
      "other monsters. Although they are",
      "incapable of uttering human speech due",
      "to problems with their vocal organs,",
      "they possess fairly high intelligence",
      "and appear to understand language.",
      "Because of their gentle nature, they",
      "will not harm others without reason,",
      "but one should still be cautious as",
      "they may attack if provoked.",
      "",
      "Artist: Setouchi",
    ],
    502 => [
      "The most common member of the Roach",
      "Clan. They are incredibly numerous,",
      "and each one of them possesses high",
      "reproductive capabilities. Unless",
      "the queen of their colony keeps",
      "them under control, they may",
      "reproduce endlessly.",
      "",
      "They have a mixed diet and will",
      "consume anything, whether it's meat",
      "or vegetables. They also enjoy human",
      "bodily fluids, and will be",
      "especially delighted to slurp up",
      "male semen in particular. Thus, they",
      "are dangerous for men to encounter,",
      "and if attacked by one, she will",
      "greedily devour his fluids until he",
      "is exhausted, though they usually",
      "won't end the man's life.",
      "",
      "Although they are just common",
      "members of their clan, they are",
      "sturdy, possess great vitality, and",
      "are incredibly agile, so their",
      "combat capabilities are extremely",
      "high even when compared to other",
      "insect-type monsters. However, they",
      "are also hedonistic by nature and",
      "don't really enjoy fighting, so the",
      "overall threat they pose isn't very",
      "high.",
      "",
      "Artist: xelvy",
    ],
    503 => [
      "A member of the Roach Clan, they",
      "are a subspecies that is",
      "exceptionally agile. Although they",
      "are sometimes mistaken for young",
      "Roach Girls, they are undeniably",
      "matured individuals. While their",
      "basic characteristics are no",
      "different from normal Roach Girls,",
      "they appear to be trusted more by",
      "the queen than the other Roach",
      "Girls due to their calm and",
      "unperturbed nature.",
      "",
      "Their physical characteristics and",
      "diet are similar to the common ",
      "Roach Girls, but they possess a",
      "smaller build and are even more",
      "agile. As a result, they burn lots",
      "of calories and are even more",
      "gluttonous than the other species.",
      "They also have a powerful sex drive,",
      "and will immediately rape men on",
      "sight unless forbidden by their",
      "queen. Apart from that, they aren't",
      "hostile towards humans, and typically",
      "won't cause them much harm.",
      "Additionally, their cloak-like",
      "appendages are actually a membrane",
      "that further improves their mobility",
      "",
      "Artist: xelvy",
    ],
    504 => [
      "The queen of the Roach Clan, who",
      "boasts exceptional vitality and",
      "reproductive capabilities even among",
      "insect monsters. She does not possess",
      "great aspirations, and so long as her",
      "clan's prosperity is maintained, she",
      "sees no reason to expand their",
      "habitat excessively. Thus unlike",
      "ordinary insect cockroaches, the",
      "Roach Girls' habitats are limited to",
      "remote regions and other unique",
      "environments.",
      "",
      "Her reproductive abilities are",
      "extremely high, and she will have sex",
      "all night with any man presented to",
      "her by her subordinates as a one-night",
      "husband, squeezing out as much seed as",
      "she can to conceive a great number of",
      "offspring. In actuality however, she",
      "restricts the excessive proliferation",
      "of her clan, and has established",
      "reproduction limits upon not just",
      "herself, but her entire clan so as not",
      "to cross that line. In the past, other",
      "insect monsters that proliferated had",
      "repeatedly fought wars for survival,",
      "so it would appear she is trying to",
      "keep her clan from getting embroiled",
      "in the flames of war by inhibiting",
      "them. Because of this, she rarely",
      "takes the center stage of politics,",
      "and her clan exists in the background",
      "compared to the top three insect clans",
      "of the ants, bees, and arachne.",
      "However, in addition to her great",
      "vitality, she is also an expert in the",
      "sword arts, and her combat abilities",
      "are in no way inferior to the other",
      "insect queens.",
      "",
      "Artist: xelvy",
    ],
    505 => [
      "An individual split from Erubetie,",
      "one of the Four Heavenly Knights of the",
      "Monster Lord's Army. Naturally, their",
      "power is inferior compared to the main",
      "body, but they still boast power equal",
      "to or greater than high-ranking slimes.",
      "Since Erubetie is an aggregation of",
      "over 10,000 wills, she is able to",
      "create several hundreds--even thousands",
      "of split bodies with this level of",
      "power.",
      "",
      "Artist: Kenkō Cross",
    ],
    506 => [
      "The Queen Slime and one of the Four",
      "Heavenly Knights of the Monster Lord's",
      "army, she boasts top-class vitality",
      "among all monsters. In actuality, she",
      "is a colony lifeform with a single",
      "will, comprised of over 10,000 slimes,",
      "spirits, and other monsters. Most of",
      "them fused with Erubetie willingly, but",
      "some were attacked and taken in against",
      "their will. She has become a collective",
      "entity that no longer falls under the",
      "categorization of slime-type monsters.",
      "That Erubetie is able to maintain a",
      "firm will under those circumstances is",
      "solely due to her own high aptitude for",
      "group control.",
      "With that said, she only takes the",
      "wills of females into her colony. Male",
      "wills are apparently incompatible with",
      "her, and she will only absorb and",
      "dissolve their flesh.",
      "",
      "She can divide and expand herself",
      "freely, and the attacks from her",
      "viscous body are unpredictable. She is",
      "also able to freely wield the power of",
      "water. It's even possible for her to",
      "expand her own body all at once and",
      "create a gigantic tsunami of slime.",
      "",
      "Artist: Kenkō Cross",
    ],
    507 => [
      "A type of magical-being monster that",
      "hides in a pot, their species has very",
      "similar characteristics to undead-type", 
      "monsters. They possess incredibly high",
      "magical strength and can cast a variety",
      "of powerful spells. Part of their body",
      "is also a viscous fluid, and they are",
      "able to use it for sticky slime",
      "techniques. While they are extremely",
      "powerful monsters, they are also very",
      "timid, and rarely emerge from their",
      "pots. On the other hand, they have an",
      "extremely two-sided personality and",
      "behave surprisingly affably towards",
      "those they consider friends.",
      "",
      "They do not attack humans on their own",
      "and are generally harmless to people",
      "and animals. However, accidents tend to",
      "occur in the places they inhabit",
      "because whenever someone carelessly",
      "peeks into a pot containing one, they",
      "attack fiercely out of panic. They also",
      "show an unusual obsession with elixirs",
      "and will frequently beg for them,",
      "though the reason why is a mystery.",
      "",
      "Artist: Jingai Modoki",
    ],
    508 => [
      "A majority of the Tanuki clan are",
      "generally known to be travelling",
      "merchants. These girls travel all",
      "across the land on their own trade",
      "routes and support the economy of the",
      "Tanuki Village. Since traveling",
      "involves danger, tanuki merchants",
      "appear to have acquired some fighting",
      "skills.",
      "",
      "Because they are very simple-natured,",
      "they are often tricked by malicious",
      "people, but this quality also makes",
      "them highly trusted by customers and",
      "fellow traders alike. Since they're",
      "said to deal in a variety of special",
      "items as well, their sales are bound",
      "to be good eventually. They are also",
      "a valuable source of news about the",
      "outside world in the village since",
      "they travel around to various",
      "countries. While the Tanuki and",
      "Kitsune clans are known to have a",
      "poor relationship, there are many",
      "tanuki who are said to be on good",
      "terms with the Kitsune clan.",
      "",
      "Artist: Jingai Modoki",
    ],
    509 => [
      "A high-ranking tanuki monster who",
      "has enhanced her magical power",
      "through training. However, they do",
      "not share the hard-working character",
      "of the rest of their clan, and even",
      "claim themselves that their training",
      "is nothing special. Additionally, the",
      "techniques they themselves call",
      "Tanuki Arts or Tanuki Magic are",
      "actually said to be no different from",
      "common taoism techniques.",
      "",
      "She has a gentle disposition like",
      "most of the Tanuki clan, but is also",
      "very hedonistic. She only thinks",
      "about having fun every day, and",
      "greatly enjoys playing pranks.",
      "Because she almost never leaves the",
      "village, she is rarely seen by humans",
      "or other monsters. They do however,",
      "occasionally visit neighboring",
      "Yamatai, where they will often use",
      "the occasions to play with the adult",
      "men and engage in sex with them.",
      "Naturally, the men will be released",
      "immediately afterwards, so no real",
      "harm comes from her interactions, and",
      "she is considered to be an unexpected",
      "blessing for the men.",
      "",
      "Artist: frfr",
    ],
    510 => [
      "A tanuki monster that has learned",
      "ninjutsu through training. Since",
      "tanuki are racially compatible with",
      "taoism and ninjutsu, many of them are",
      "able to learn advanced techniques",
      "without needing to undergo rigorous",
      "training, leading to spare-time ninjas",
      "being commonplace in the village.",
      "It seems, however, that they mostly",
      "use ninjutsu for mischief.",
      "",
      "She has an active personality and",
      "frequently appears in neighboring",
      "Yamatai, where she plays pranks on",
      "men as she eludes them. Because she",
      "is simple, honest, and good-natured",
      "however, she rarely ever causes any",
      "serious trouble.",
      "",
      "She is actually a raccoon who is",
      "misrepresenting her species.",
      "",
      "Artist: frfr",
    ],
    511 => [
      "A high-ranking tanuki monster whose",
      "bestial characteristics are greatly",
      "expressed. Her ferocity is suppressed",
      "however, and contrary to her",
      "appearance, she is actually more",
      "gentle and intelligent than the",
      "other types of tanuki.",
      "Nonetheless, she possesses great",
      "magical power on top of excellent",
      "physical strength, and her combat",
      "abilities are considered to be",
      "exceptional among the clan. Because",
      "of her high intelligence and combat",
      "prowess, her opinions hold a powerful",
      "sway in the village.",
      "",
      "She has very strong maternal",
      "instincts, and will protect and",
      "return lost human children she finds",
      "to their homes. She is also said to",
      "fascinate men in the nearby villages,",
      "gratuitously pampering them like a",
      "mother as she receives their seed.",
      "Because they rarely cause mischief,",
      "they are known to be the friendliest",
      "of the tanuki among humans.",
      "",
      "Artist: Jingai Modoki",
    ],
    512 => [
      "A top-ranking tanuki monster",
      "possessing the most powerful",
      "abilities within the village,",
      "she has mastered superior sword arts",
      "and advanced taoism techniques. She",
      "is well-known in the village as an",
      "assistant to the village head, Black",
      "Tanuki, but she has only ever been",
      "seen drinking alcohol on a regular",
      "basis, as opposed to serving as a",
      "proper assistant. She appears to",
      "have a clear mind when she is silent,",
      "which is why she is believed to be a",
      "genius by people outside of the",
      "village. Her actual intelligence",
      "however, is completely dissolved in",
      "alcohol. She can also be a violent",
      "drunk sometimes, causing her",
      "excellent sword skills to end up",
      "becoming a nuisance instead.",
      "",
      "No matter how much she tries to pay",
      "heed to Black Tanuki, she can't stop",
      "drinking, and she drinks the night",
      "away almost daily. She has been found",
      "floating in the pond at least a couple",
      "times. She sometimes even assaults",
      "men while she is drunk, though she",
      "sobers up a little for some reason",
      "during sex. While this tanuki can",
      "definitely be a nuisance to others,",
      "she is still a beloved and well-known",
      "figure of the village.",
      "",
      "Artist: Jingai Modoki",
    ],
    513 => [
      "The leader and most powerful person",
      "in the Tanuki Village. A master of",
      "both ninjutsu and taoist techniques,",
      "she is one of the strongest Queens",
      "out there. However, she lacks any",
      "and all political skill. Due to",
      "Inugami-Gyobu also being unreliable,",
      "everything is left up to their",
      "Junior Tanuki subordinates.",
      "Despite the lacking leadership,",
      "the hard work of the Junior Tanukis",
      "has led to the Tanuki Village being",
      "a happy place. Her high skills at",
      "communicating and unwavering",
      "decisiveness allows her to be deeply",
      "trusted by everyone.",
      "",
      "Seeing Tamamo as her rival, she",
      "keeps getting more and more",
      "dissatisfied with how none of the",
      "pranks she tries to play end up",
      "working. She has an arrogant",
      "personality, but due to her being a",
      "fundamentally good person, she has",
      "not caused any major incidents.",
      "",
      "Artist: Jingai Modoki",
    ],
    514 => [
      "A mighty yoma from ancient times who",
      "was revered as an Earth Mother in",
      "Yamatai, she is the daughter of",
      "Izanami, who prides herself as being",
      "the ruler of the underworld.",
      "In addition to possessing tremendous",
      "magical power and a nimble body, she",
      "is also skilled in a variety of",
      "techniques, including dancing and",
      "singing. She was better known in",
      "Yamatai by her other name, Amaterasu,",
      "and became associated with the sun",
      "due to a mixing of legends, though",
      "she herself does not use that name,",
      "nor is she related to the sun.",
      "",
      "She has a cruel disposition and will",
      "not hesitate to kill men as she toys", 
      "with them for pleasure. She delights",
      "in vulgar acts such as seducing",
      "scores of men to ascend them all at",
      "once, and her sexual appetite is",
      "believed to be bottomless.",
      "However, she also has an exceptional",
      "attachment to her homeland of",
      "Yamatai, and she will sometimes",
      "protect the people of her land",
      "instead of oppressing them.",
      "",
      "She had received a seal that was no",
      "different from death, but has been",
      "revived through Black Alice's power.",
      "To repay her debt of gratitude to",
      "Black Alice, she is lending a hand to",
      "her schemes. Because of her immense",
      "haughtiness, however, she does not",
      "acknowledge this as a master-servant",
      "relationship.",
      "",
      "Artist: xelvy",
    ],
    515 => [
      "An elf living in the Elf Village",
      "that has mastered ninjutsu through",
      "rigorous training. While she belongs",
      "to a middle-rank race, her ninjutsu",
      "allows her to hold her own against",
      "high-rank monsters. She is",
      "especially skilled at group combat,",
      "with her and her companion's",
      "combination techniques overwhelming",
      "most opponents.",
      "",
      "Due to most of the elves in the Elf",
      "Village being combatants who have",
      "mastered ninjutsu, the village's",
      "military might is top-class. This",
      "has led to the village almost never",
      "being invaded in its long history.",
      "While the Kunoichi Elves do not",
      "stand out on an individual basis,",
      "they are the hidden backbone of the",
      "village.",
      "",
      "Artist: D_AM",
    ],
    516 => [
      "An elf living in the Elf Village",
      "that has mastered ninjutsu through",
      "rigorous training. While she belongs",
      "to a middle-rank race, her ninjutsu",
      "allows her to hold her own against",
      "high-rank monsters. She is",
      "especially skilled at group combat,",
      "with her and her companion's",
      "combination techniques overwhelming",
      "most opponents.",
      "",
      "Due to most of the elves in the Elf",
      "Village being combatants who have",
      "mastered ninjutsu, the village's",
      "military might is top-class. This",
      "has led to the village almost never",
      "being invaded in its long history.",
      "While the Kunoichi Elves do not",
      "stand out on an individual basis,",
      "they are the hidden backbone of the",
      "village.",
      "",
      "Artist: D_AM",
    ],
    517 => [
      "An elf living in the Elf Village",
      "that has mastered ninjutsu through",
      "rigorous training. While she belongs",
      "to a middle-rank race, her ninjutsu",
      "allows her to hold her own against",
      "high-rank monsters. She is",
      "especially skilled at group combat,",
      "with her and her companion's",
      "combination techniques overwhelming",
      "most opponents.",
      "",
      "Due to most of the elves in the Elf",
      "Village being combatants who have",
      "mastered ninjutsu, the village's",
      "military might is top-class. This",
      "has led to the village almost never",
      "being invaded in its long history.",
      "While the Kunoichi Elves do not",
      "stand out on an individual basis,",
      "they are the hidden backbone of the",
      "village.",
      "",
      "Artist: D_AM",
    ],
    518 => [
      "A succubus who has mastered ninjutsu",
      "through rigorous training at the",
      "Elf Village. While her nature as a",
      "succubus had led to her focusing on",
      "learning pleasure-based ninjutsu,",
      "she has also learned basic combat",
      "ninjutsu. Thus, her combat abilities",
      "are greater than the average",
      "succubus. Becoming a kunoichi has",
      "not managed to rein in her",
      "whimsical and hedonistic personality.",
      "",
      "She occasionally leaves the village",
      "to enjoy using her pleasure ninjutsu",
      "on men that she catches. She rarely",
      "milks men to the point of exhaustion",
      "unless they make her extremely angry.",
      "When she has free time, it is said",
      "that she takes trips back to",
      "Succubus Village so that she can",
      "hold ninjutsu classes.",
      "",
      "Artist: kupala",
    ],
    519 => [
      "A Harpy who has mastered ninjutsu",
      "through rigorous training at the Elf",
      "Village. Due to her nature she does",
      "not like fighting, but she has still",
      "acquired advanced combat skills. Her",
      "abilities as a kunoichi are enhanced",
      "greatly by her natural agility as a",
      "harpy, with her being particularly",
      "skilled at close combat.",
      "",
      "Even becoming a kunoichi has not",
      "changed her easy-going personality.",
      "She can often be seen skipping her",
      "training to have fun both inside and",
      "outside of the village. She also",
      "loves playing about with men.",
      "When she finds a man that suits her,",
      "she'll swoop down and rape him over",
      "and over again, only to fly away",
      "once she's done. However, due to her",
      "quickly releasing her prey, she does",
      "not cause them any permanent harm.",
      "",
      "Artist: kupala",
    ],
    520 => [
      "A Scylla who has mastered ninjutsu",
      "through rigorous training at the Elf",
      "Village. She has greatly increased",
      "her strength by devising a unique",
      "ninjutsu that makes use of her many",
      "tentacles. Having also learned",
      "multiple shadow-focused skills, she",
      "is skilled at stealth missions.",
      "",
      "Her calm personality and history of",
      "dutifully carrying out her job as a",
      "kunoichi have led to the higher-ups",
      "trusting her more than the",
      "unreliable Kunoichi Succubus and",
      "Kunoichi Harpy. However, she does",
      "have a habit of sometimes playing",
      "around with men too much. Anyone",
      "unlucky enough to be dragged into",
      "the shadows by her will be milked",
      "dry for multiple days by her",
      "tentacles. Although she very rarely",
      "kills anyone, she has been",
      "recognized as a very dangerous",
      "monster.",
      "",
      "Artist: kupala",
    ],
    521 => [
      "An Arachne who has mastered",
      "ninjutsu through rigorous training",
      "at the Elf Village. In addition to",
      "learning basic ninjutsu, she has",
      "devised unique ninjutsu that make",
      "use of her sticky threads. Having",
      "already been a strong monster before",
      "coming to the village, her improved",
      "combat abilities make her one of the",
      "strongest kunoichis in the village.",
      "",
      "Her personality is as clingy as her",
      "threads. She likes to thoroughly",
      "play around with any man she",
      "captures until their testicles are",
      "empty. Due to her sometimes draining",
      "men until they are nearly dead, she is",
      "considered particularly dangerous",
      "even amongst the kunoichi. However,",
      "her nature as a professional means she",
      "refuses to kill without a reason.",
      "This has led to the consensus that",
      "she is less dangerous than the rest",
      "of her race, who enjoy milking men",
      "to death for fun.",
      "",
      "Artist: kupala",
    ],
    522 => [
      "The princess of the Elf Village who is",
      "incredibly reclusive and leaves all",
      "governing affairs to her subordinates,",
      "despite being its ruler. She also has",
      "severe social phobia, and seems",
      "limited in the number of people she is",
      "able to speak with. On the other hand,",
      "her combat prowess is extremely high,",
      "and she is an expert with the katana,",
      "bow, spear, and various martial arts.",
      "Boasting fighting abilities that",
      "surpass even Queen-class monsters of",
      "other races, she is renowned in some",
      "circles as \"the world's strongest",
      "shut-in\". Nevertheless, the Elf",
      "Village itself is an isolated and",
      "neutral power with very little",
      "influence on world affairs.",
      "",
      "Although Queen Elf is a blood relative",
      "of hers, she has a volatile",
      "relationship with the Princess as a",
      "consequence of caring too much and",
      "frequently admonishing her. The Elf",
      "Princess especially seems to hate",
      "Queen Elf. In addition, she was left",
      "in the care of the Amazoness tribe",
      "when she was a child, and while she",
      "had become unparalleled in martial",
      "arts, at the same time a deep-seated",
      "opposition towards spiritualism and",
      "force of will grew within her, and she",
      "had eventually become a shut-in. It is",
      "said that even the village authorities",
      "had tried to drag the princess out of",
      "her room at first, but had given up",
      "after scores of the village's elite",
      "had been defeated by her.",
      "",
      "Artist: D_AM",
    ],
    523 => [
      "A mighty yoma from ancient times who",
      "was revered as an Earth Mother in",
      "Yamatai, she is an undead who prides",
      "herself as being the ruler of the",
      "underworld. She possesses tremendous",
      "magical power, proficiency in",
      "various taoism skills, and extremely",
      "high physical ability. It is said",
      "that she had wreaked havoc upon the",
      "angel army during the Great Monster",
      "Wars two thousand years ago. Her",
      "daughter, Himiko, is also a famous",
      "Earth Mother of Yamatai.",
      "",
      "She is extremely ruthless and kills",
      "humans as if to increase her number",
      "of brethren in the underworld. If",
      "her opponent is a man, she is said",
      "to thoroughly ravish him and squeeze",
      "out all of his energy before",
      "ascending him to heaven. However,",
      "she also has an exceptional",
      "attachment to her homeland of",
      "Yamatai, and she will sometimes",
      "protect the people of her land",
      "instead of oppressing them.",
      "",
      "She was sealed away in the",
      "underworld, but has been revived",
      "through Black Alice's power. To",
      "repay her debt of gratitude to Black",
      "Alice, she is lending a hand to her",
      "schemes. Because of her immense",
      "haughtiness, however, she does not",
      "acknowledge this as a master-servant",
      "relationship.",
      "",
      "Artist: Setouchi",
    ],
    524 => [
      "A mysterious swordsman that appears",
      "in spiritual locations, like the",
      "Forest of Spirits. It is covered in",
      "a bizarre substance that has",
      "solidified its whole body like",
      "armor. It seems to have completely",
      "lost its reason, making communication",
      "with it impossible. Its purpose and",
      "identity are unknown, but it appears",
      "to relentlessly target angels and",
      "wields extraordinary power.",
      "",
      "Artist: Setouchi",
    ],
    525 => [
      "A monster ranked among the highest",
      "class of the Kitsune race who boasts",
      "both powerful physical and magical",
      "abilities. She assists Tamamo along",
      "with Nanabi, and is considered to be",
      "her right hand.",
      "",
      "She enjoys playing with men, and will",
      "use her eight tails to frolic with",
      "her catch. Additionally, she can",
      "extend her tongue and use her soft",
      "furry paws to please men. She is",
      "incredibly prideful however, and will",
      "never use her vagina when mating with",
      "men. She will always use her anus to",
      "rape men, toying with them by making",
      "them have sex with her excretory",
      "organ. While she is sadistic when it",
      "comes to sex, she is not inherently",
      "cruel and will not torture her catch",
      "until they die. However, she will not",
      "release her catch so easily, which",
      "inevitably leads to her playing with",
      "him endlessly.",
      "",
      "Artist: Jingai Modoki",
    ],
    526 => [
      "An extremely powerful monster that",
      "is among the highest class of the",
      "succubus race. Her magical power and",
      "energy-draining abilities are so",
      "tremendous, that ordinary humans",
      "struggle to maintain their sanity in",
      "her presence. Simply gazing into her",
      "eyes is enough to make someone lose",
      "their mind and become a prisoner",
      "to lust.",
      "",
      "When it comes to the Elder Succubus,",
      "every part of her body is a weapon",
      "for squeezing energy out of her prey.",
      "She is able to suck energy not just",
      "through her mouth and genitals, but",
      "also with her hands, feet, and tail,",
      "and even her wings and navel. Being",
      "drained through her navel in",
      "particular feels like being sucked,",
      "and is capable of sucking a man's",
      "semen endlessly. It is so well-",
      "trained that it can be considered a",
      "second sex organ. She is extremely",
      "prideful and cruel towards her prey.",
      "If she rapes someone, she will",
      "squeeze them completely dry as she",
      "feeds upon them.",
      "",
      "Artist: masha",
    ],
    527 => [
      "A Centaur of the highest rank that has",
      "trained earnestly, and was granted the",
      "greatest honor among monsters of",
      "residing within the Monster Lord's",
      "Castle. With her strong legs that",
      "can support her heavy equipment and",
      "honed skills with the sword and spear,",
      "she is an extremely capable fighter.",
      "However, her single-minded focus on",
      "combat training has left her in-",
      "experienced in sexcraft, and she is",
      "often made fun of by her Elder",
      "Succubus peers among others. Thus,",
      "whenever she has sex with men, she",
      "sometimes overexerts herself and",
      "quickly exhausts him despite harboring",
      "no ill intent.",
      "",
      "Because she is deeply trusted by her",
      "superiors for her serious and upright",
      "personality, she is often forced to do",
      "many tasks other high-ranking monsters",
      "find boring and avoid, such as",
      "patrolling and guarding important",
      "facilities. She also has a bad",
      "tendency of becoming timid when things",
      "don't go well for her.",
      "",
      "Artist: UN_DO",
    ],
    528 => [
      "A very peculiar monster with a",
      "serpentine body that is a subspecies",
      "of the Harpy race. They possess",
      "characteristics of not just birds and",
      "snakes, but even dragons, and their",
      "species is said to be very similar to",
      "the original ancestor of those races.",
      "Although they are incredibly",
      "ferocious, they are also highly",
      "intelligent and have excellent combat",
      "capabilities, so many of them serve as",
      "royal guards at the Monster Lord's",
      "Castle.",
      "",
      "They are also highly covetous towards",
      "men, and will engage in sex by",
      "wrapping their serpentine bodies",
      "around them. Many men die from",
      "exhaustion after being squeezed dry by",
      "them, making these monsters extremely",
      "dangerous. Since most of them live on",
      "the Monster Continent however, humans",
      "very rarely come into contact with",
      "them to begin with.",
      "",
      "Many people struggle to identify what",
      "they are because they aren't sure",
      "whether they are birds or snakes or",
      "dragons, leading to a surprising",
      "number of complaints among Aevis",
      "Girls. Those working at the Monster",
      "Lord's Castle have mentioned Aevis",
      "Girls confiding to them about their",
      "identity concerns at least once.",
      "",
      "Artist: Setouchi",
    ],
    529 => [
      "A kitsune from the highest ranks",
      "hand-picked by Tamamo of the Four",
      "Heavenly Knights to be her elite",
      "guard. She is an extraordinarily",
      "accomplished taoist who has not only",
      "mastered many techniques, but is",
      "also said to be able to command",
      "powerful shikigami such as Zenki and",
      "Kouki at will. In addition to",
      "possessing tremendous magical power,",
      "she is also remarkably intelligent,",
      "so many of them hold important posts",
      "within the Monster Lord's Castle.",
      "Furthermore, they view their fellow",
      "Six-Taileds to be their rivals,",
      "proclaiming \"There is no difference",
      "in power between five and six tails\"",
      "almost daily, to the point where the",
      "residents of the castle claim to have",
      "calluses in their ears from hearing",
      "it so much.",
      "Similar claims have been advocated by",
      "Nanabi and the Three-Taileds, which",
      "have occasionally developed into",
      "quarrels.",
      "",
      "She is extremely clingy by nature,",
      "and will make sure to play with men",
      "as much as she can while squeezing",
      "them of their semen. While she",
      "typically won't kill her partner,",
      "she has a tendency to leave them",
      "completely exhausted, both mentally",
      "and physically.",
      "",
      "Artist: Jingai Modoki",
    ],
    530 => [
      "A kitsune from the highest ranks",
      "hand-picked by Tamamo of the Four",
      "Heavenly Knights to be her elite",
      "guard. Having mastered the skills",
      "of a courtesan, she excels at",
      "providing support with her songs and",
      "dances. She also has high levels of",
      "physical and magical power, and",
      "possesses considerable fighting",
      "capability despite her supportive",
      "role. She is even well-versed in",
      "coordination and political affairs,",
      "and many of them seem to hold",
      "important posts within the Monster",
      "Lord's Castle. She is said to be on",
      "poor terms with the Five-Tailed",
      "Taoist who shares a similar position",
      "to hers, and is often seen",
      "antagonizing her in the castle.",
      "",
      "Since she is also an expert in",
      "sexcraft, any man who serves as her",
      "partner will taste heavenly pleasure",
      "as she brings them to repeated",
      "climax. She won't endanger his life",
      "however, and there is no risk of",
      "being left debilitated afterwards.",
      "She is known to be a friendly monster",
      "who rarely causes harm to humans,",
      "instead offering them the ultimate",
      "pleasure.",
      "",
      "Artist: Jingai Modoki",
    ],
    531 => [
      "One of the famous Three Nobles of",
      "Black, who directly serve as Black",
      "Alice's confidants. They are",
      "extremely powerful and are the",
      "highest-ranking lieutenants among",
      "Black Alice's subordinates.",
      "",
      "Black Dahlia is a succubus of the",
      "highest class, but she also",
      "possesses great fighting talent and",
      "excels at combat. Naturally, her",
      "power as a succubus is also top-",
      "notch and she is able to drain a",
      "man's very soul with her skills.",
      "Men who become her prey will be",
      "squeezed dry as they become",
      "intoxicated by the dreamlike",
      "pleasure.",
      "",
      "She had originally lost her life in",
      "the Black Alice Rebellion, but has",
      "survived to the present era along",
      "with the other Nobles due to the",
      "effects of the world line's",
      "disruption. For some reason, they",
      "seem to be staying in the treasure",
      "gallery of the Monster Lord's",
      "Castle.",
      "",
      "Artist: D_AM",
    ],
    532 => [
      "One of the famous Three Nobles of",
      "Black, who directly serve as Black",
      "Alice's confidants. They are",
      "extremely powerful and are the",
      "highest-ranking lieutenants among",
      "Black Alice's subordinates.",
      "",
      "Black Mamba is one of the strongest",
      "lamias, and her skills as a warrior",
      "were the greatest in the world five-",
      "hundred years ago. Her spear has a",
      "reputation for being able to pierce",
      "anything, but because she prefers",
      "not to end battles quickly, she",
      "fights rather cautiously. Any man",
      "she defeats will become her prey",
      "and have their semen squeezed.",
      "She isn't very brutal for a lamia,",
      "and rarely kills men with pleasure.",
      "",
      "She had originally lost her life in",
      "the Black Alice Rebellion, but has",
      "survived to the present era along",
      "with the other Nobles due to the",
      "effects of the world line's",
      "disruption. For some reason, they",
      "seem to be staying in the treasure",
      "gallery of the Monster Lord's",
      "Castle.",
      "",
      "Artist: D_AM",
    ],
    533 => [
      "One of the famous Three Nobles of",
      "Black, who directly serve as Black",
      "Alice's confidants. They are",
      "extremely powerful and are the",
      "highest-ranking lieutenants among",
      "Black Alice's subordinates.",
      "",
      "Black Rose is a supreme vampire who",
      "boasted the strongest magical power",
      "in the world five hundred years ago.",
      "She is polite but cruel, and anyone",
      "she catches will become her",
      "nourishment as she sucks their blood",
      "and semen dry.",
      "",
      "She had originally lost her life in",
      "the Black Alice Rebellion, but has",
      "survived to the present era along",
      "with the other Nobles due to the",
      "effects of the world line's",
      "disruption. For some reason, they",
      "seem to be staying in the treasure",
      "gallery of the Monster Lord's",
      "Castle.",
      "",
      "Artist: D_AM",
    ],
    534 => [
      "The leader of the Kitsune clan and",
      "the strongest individual among beast",
      "monsters. She is one of the Four",
      "Heavenly Knights of the Monster",
      "Lord's Army, whose superhuman",
      "strength and defense from the power",
      "of the earth hidden in her body are",
      "unmatched among monsters.",
      "Additionally, she is also the most",
      "powerful monster spellcaster, capable",
      "of using a variety of magical arts.",
      "",
      "She has a calm disposition and won't",
      "fight humans unless challenged.",
      "Sometimes she appears to be working",
      "to resolve troubles between humans",
      "and monsters.",
      "",
      "Her exact age is unknown, but she",
      "appears to have been in charge of",
      "educating successive generations of",
      "Monster Lords. At the very least, her",
      "present appearance hasn't changed",
      "since the previous Monster Lord,",
      "Alipheese the 15th was a child.",
      "She was requested to be a guardian",
      "to the current Monster Lord,",
      "Alipheese the 16th, by her",
      "predecessor, and has a special",
      "attachment to her. The Alipheese in",
      "question may appear to dislike her",
      "for her nagging manner of education,",
      "but she also harbors genuine",
      "gratitude towards her, and their",
      "relationship appears to be closer to",
      "that of mother and daughter than of",
      "master and student.",
      "",
      "Artist: Jingai Modoki",
    ],
    535 => [
      "The Queen Slime and one of the Four",
      "Heavenly Knights of the Monster Lord's",
      "army, she boasts top-class vitality",
      "among all monsters. In actuality, she",
      "is a colony lifeform with a single",
      "will, comprised of over 10,000 slimes,",
      "spirits, and other monsters. Most of",
      "them fused with Erubetie willingly, but",
      "some were attacked and taken in against",
      "their will. She has become a collective",
      "entity that no longer falls under the",
      "categorization of slime-type monsters.",
      "That Erubetie is able to maintain a",
      "firm will under those circumstances is",
      "solely due to her own high aptitude for",
      "group control.",
      "With that said, she only takes the",
      "wills of females into her colony. Male",
      "wills are apparently incompatible with",
      "her, and she will only absorb and",
      "dissolve their flesh.",
      "",
      "She can divide and expand herself",
      "freely, and the attacks from her",
      "viscous body are unpredictable. She is",
      "also able to freely wield the power of",
      "water. It's even possible for her to",
      "expand her own body all at once and",
      "create a gigantic tsunami of slime.",
      "",
      "Artist: Kenkō Cross",
    ],
    536 => [
      "One of the Four Heavenly Knights and",
      "a Monster Swordsman of the dragonkin",
      "race. She is an aloof fighter who has",
      "dedicated her life to the sword, and",
      "her swordsmanship which utilizes the",
      "power of fire is without equal in the",
      "world. She swears absolute loyalty to",
      "the Monster Lord, and takes pride in",
      "being the strongest in the Monster",
      "Lord's Army. However, she also values",
      "chivalry, and dislikes needless",
      "slaughter and violence against the",
      "weak.",
      "",
      "Dragonkin eat an omnivorous diet",
      "similar to humans, and while they do",
      "like male semen, they rarely eat it",
      "as a staple food. Granberia also",
      "appears to get by eating normal meals",
      "every day. But sometimes after a",
      "battle, she will toy with defeated",
      "men after getting into a combat high.",
      "",
      "Additionally, the dragonkin race",
      "holds to an extremely strong concept",
      "of chastity, and only seems to mate",
      "with those they personally recognize",
      "as warriors. For someone like",
      "Granberia who has been honing her",
      "swordsmanship her whole life, finding",
      "a partner she deems acceptable will",
      "prove to be a challenge.",
      "",
      "Artist: Akazawa RED",
    ],
    537 => [
      "One of the Seven Archangels created",
      "by the Angelic Dominion's Ilias",
      "during the Great Monster Wars. She",
      "is known as the \"Guardian of the",
      "Law\". Her outstanding intelligence",
      "and vast magical powers are",
      "top-class amongst the Archangels.",
      "Excluding Micaela, she is the one",
      "who most often takes up the role of",
      "leader amongst the Archangels due to",
      "her high leadership skills. She can",
      "use a variety of magic, but her",
      "specialties lie in using holy light",
      "and lightning.",
      "",
      "Her calm, warm personality allows",
      "her to keep her cool under any",
      "circumstances. Entrusted with",
      "governing the holy city of San Ilia,",
      "she is considered the purest of the",
      "seven Archangels. However, there are",
      "rumors that she is secretly a huge",
      "lecher. The rumors also claim that",
      "she lures devout believers,",
      "especially young men and teenagers,",
      "into her room at night.",
      "",
      "Artist: xelvy",
    ],
    538 => [
      "A high-ranking angel prototype",
      "created after the Great Monster Wars,",
      "she was developed as a trial run in",
      "anticipation of a mass production of",
      "mechanical angels. She is also a",
      "simplified production model of Uriela",
      "who shares many of the same",
      "mechanisms, but her entire body is",
      "far more mechanized. It is possible",
      "to further mechanize her organic",
      "parts using techno-organic",
      "engineering, though there is always",
      "the risk of her mechanical cells",
      "eroding out of control. Combined with",
      "increasing development costs, the",
      "project was discontinued after the",
      "completion of Gnosis.",
      "",
      "Her fighting capabilities are at the",
      "highest among existing angels, and",
      "while she is not as powerful as the",
      "Seven Archangels that Ilias herself",
      "had personally worked on, her",
      "abilities are on par with Seraph",
      "Eden's. Because she was created to be",
      "a fighting machine, she has a very",
      "rough temper and is simplistic in",
      "her thinking. On the other hand, she",
      "is fiercely loyal to the Goddess",
      "Ilias, and she is used for many",
      "missions as an angel under the direct",
      "command of the Goddess. She also",
      "seems to hold a deep respect for",
      "Uriela, who is an exceptional leader",
      "and a mighty warrior.",
      "",
      "Artist: UN_DO",
    ],
    539 => [
      "A high-ranking angel prototype",
      "created after the Great Monster Wars,",
      "she was a model developed in secret",
      "using Apoptosis genes. Thus, she has",
      "exceedingly high amounts of holy",
      "energy, and is an idealized battle",
      "angel armed with an assortment of",
      "mechanical weapons. However, her",
      "Apoptosis attributes are unstable,",
      "and her body is constantly mutating.",
      "Further development on her has been",
      "discontinued due to the high risk",
      "that she could go berserk.",
      "",
      "Her fighting capabilities are on par",
      "with Seraph Eden's, and she is",
      "intelligent and rational when she is",
      "stable. However, she has difficulty",
      "controlling her emotions, and often",
      "gets agitated over trivial things.",
      "She is fiercely loyal to the Goddess",
      "Ilias, and she is very likely to fly",
      "into a rage if she sees or hears",
      "anyone disrespecting the Goddess.",
      "She frequently works in tandem with",
      "Zion, and while their personalities",
      "are contradictory, they appear to get",
      "along well. She also seems to have a",
      "mutual affinity with Sariela for some",
      "reason.",
      "",
      "Artist: xelvy",
    ],
    540 => [
      "An angel belonging to the first",
      "circle (Seraphim), the highest",
      "position of the angel hierarchy. Her",
      "presence was similar to a supreme",
      "commander who rallied all of the",
      "angels together, but following the",
      "Great Monster Wars, the angel",
      "hierarchy of the Angelic Dominion",
      "was reorganized, and rule over each",
      "continent was divided amongst the",
      "Seven Archangels. As a Seraph under",
      "Ilias' direct command, Eden is her",
      "most trusted confidant, despite not",
      "ruling over any territory. Eden",
      "herself is uninterested in territory,",
      "and finds unparalleled gratification",
      "in serving at Ilias' side.",
      "",
      "Following the reorganization of the",
      "Angelic Dominion's hierarchy, Zion",
      "and Gnosis were assigned as new",
      "Seraphim and Eden's associates,",
      "though they get along well because",
      "all three are all incredibly loyal to",
      "Ilias. Zion often teases Eden for her",
      "stubbornness, but she is said to",
      "precisely carry out any task assigned",
      "to her by Ilias without breaking her",
      "pace.",
      "",
      "Artist: Setouchi",
    ],
    541 => [
      "Alice's mother, and the previous",
      "Monster Lord. However, because she",
      "expelled Alice and seized command",
      "over the Monster Lord's army, the",
      "current legitimacy of the Monster",
      "Lord's throne remains ambiguous.",
      "She has secretly entered into an",
      "alliance with the Dark Goddess and",
      "her forces from the Monster Realm,",
      "and only a handful of people",
      "within the highest ranks of the",
      "Monster Lord's Army even know",
      "about it.",
      "",
      "Her physical strength ranks among the",
      "highest of all the Monster Lords",
      "throughout the generations, and the",
      "incredible power brought forth from",
      "her outstanding body can overwhelm",
      "any foe. While she is said to boast",
      "incredible combat abilities, her",
      "intellect and magical power are",
      "average compared to other Monster",
      "Lords. She is also greedy when it",
      "comes to sex, and will typically",
      "wring out semen from any man",
      "presented to her until he can no",
      "longer stand on his feet. Because of",
      "her beliefs in coexistence between",
      "humans and monsters however, it",
      "appears she will not take their",
      "lives.",
      "",
      "Artist: UN_DO",
    ],
    542 => [
      "The youngest of the three Lilith",
      "Sisters, who serve the legendary",
      "Great Whore of Babylon. She wields",
      "magical power that is beyond the",
      "compare of monsters in this world,",
      "and works with her sisters in",
      "secrecy within the shadows of the",
      "world. Her ability to manipulate",
      "psychic auras is top-class among",
      "all monsters, and she can freely",
      "wield it as a weapon for offense,",
      "defense, and even pleasure.",
      "",
      "She is violent, rash, and cruel",
      "enough to turn men into dried fish",
      "without batting an eye, but she",
      "restrains herself from killing or",
      "harming them under orders from the",
      "Monster Realm. She also expresses a",
      "very amiable and easygoing side",
      "towards anyone she approves of as",
      "a friend.",
      "",
      "Artist: Shiki",
    ],
    543 => [
      "The middle sister of the three",
      "Lilith Sisters, who serve the",
      "legendary Great Whore of Babylon.",
      "She wields magical power that is",
      "beyond the compare of monsters in",
      "this world, and works with her",
      "sisters in secrecy within the shadows",
      "of the world. Extremely skilled and",
      "versatile, she has learned all of",
      "the techniques of a high-level",
      "succubus, though she has no",
      "outstanding abilities compared to her",
      "sisters, and feels concerned over",
      "being a jack of all skills and a",
      "master of none. Thus, whenever all",
      "three sisters engage in battle, she",
      "often plays the support role.",
      "",
      "She dedicates herself to support not",
      "just in battles, but also her",
      "missions in general, and even her",
      "relationship with her sisters. She",
      "has repeatedly undergone a great",
      "amount of hardship being situated",
      "between her cool-headed leader of an",
      "older sister and her reckless younger",
      "sister. Thus, she is extremely",
      "capable as a supporter/coordinator,",
      "and is a common sense person who",
      "excels in clerical work. She also",
      "gambles as a hobby, but is not very",
      "good at making bets.",
      "",
      "Artist: Shiki",
    ],
    544 => [
      "A fragment of the soul of King Sabasa,",
      "wandering in Tartarus.",
      "Having fallen into the chaotic void,",
      "King Sabasa's existence was fractured.",
      "His body and soul split into three parts,",
      "with two of them drifting into other worlds.",
      "In Tartarus, only a shadow-like fragment,",
      "of his soul remained.",
      "His martial prowess,",
      "which he possessed as a human,",
      "was amplified by his transformation,",
      "into a chaotic entity,",
      "granting him fearsome combat abilities.",
      "He operates purely on instinct,",
      "devoid of reason,",
      "driven solely by the urge to fight.",
      "It seems",
      "he had been wandering through Tartarus,",
      "annihilating the approaching Apoptosis,",
      "but upon encountering Luka and the others,",
      "he entered a temporary state of calm.",
      "",
      "If remaining fragments of his soul",
      "are recovered,",
      "he may regain his original form.",
      "However, it is uncertain whether King Sabasa,",
      "having been exposed to such profound Chaos,",
      "can truly reclaim his human body.",
      "",
      "Artist: Setouchi",
    ],
    545 => [
      "A command type appointment that supervises puppet-type apoptosis.",
      "Toshis himself is made up of countless doll parts.",
      "It is. Manipulate puppet-shaped apoptosis to carry out attacks.",
      "In addition to hanging them, she also incorporates doll parts into her own body.",
      "It will also carry out attacks. I also wanted to control the doll using wires.",
      "The metal wire can also be used as a weapon for slashing and tightening.",
      "It seems possible. Furthermore, wire the living body",
      "It is also possible to erode it and convert it into doll apoptosis.",
      "It is said to be Noh.",
      "",
      "After all, the greatest source of active energy is human semen.",
      "She uses a puppet to suck up the semen of an incapacitated man.",
      "Ru. Men are seen as nothing more than energy tanks;",
      "As it is, the spirit is sucked to death as the doll's energy source.",
      "It is said that this is always the case. There are almost no emotions,",
      "He seems to have an obsession with the puppets he controls and destroys them.",
      "When this happens, they may show emotions such as anger.",
      "cormorant.",
      "",
      "Artist: Delphinus",
    ],
    546 => [
      "A doll controlled by Amor Doll, yet",
      "possessing a will of her own. She is",
      "a type specialized in physical",
      "attacks, equipped with sharp claws",
      "and drill-like crushing weapons",
      "mounted on various parts of her",
      "body. She also carries a plasma",
      "generation device, further",
      "enhancing the power of her physical",
      "assaults.",
      "",
      "Amor Doll can reproduce her at will,",
      "and it is said she can even absorb",
      "humans as parts. Amor Doll seems to",
      "dote on her, often seen walking",
      "her around Tartarus as if on a",
      "leisurely stroll. Amor Rahm also",
      "appears to adore her master, which",
      "is likely why she doesn't get along",
      "well with other dolls.",
      "",
      "Artist: Delphinus",
    ],
    547 => [
      "A doll controlled by Amor Doll, yet",
      "possessing her own will. She is a",
      "type specialized in magical attacks,",
      "equipped with a small magical reactor",
      "within her body. She is programmed to",
      "activate multiple powerful spells.",
      "",
      "Amor Doll can reproduce her at will,",
      "and it is said she can even assimilate",
      "humans as parts. Amor Doll seems to",
      "dote on her, often seen walking her",
      "around Tartarus as if on a leisurely",
      "stroll. Amor Rihm also appears to",
      "adore her master, which seems to cause",
      "tensions with other dolls under",
      "Amor Doll's control.",
      "",
      "Artist: Delphinus",
    ],
    548 => [
      "A high-ranking Apoptosis said to bear",
      "the name of an otherworldly grim",
      "reaper. Her body is split into left",
      "and right halves, each said to be",
      "connected to a different world.",
      "Some speculate that the two halves",
      "are separate entities, but details",
      "remain unclear.",
      "",
      "Though she behaves as if she has",
      "emotions, her true nature is cruel.",
      "While she speaks in a charming",
      "manner, she mercilessly eliminates",
      "anything foreign. Those caught",
      "between her left and right bodies",
      "are said to experience supreme",
      "pleasure, only to be rendered",
      "powerless in an instant. Once this",
      "happens, they are dissolved by",
      "digestive fluids seeping from her",
      "body. Feeling no pain whatsoever,",
      "they are absorbed into Persephone's",
      "body while immersed in a heavenly",
      "ecstasy.",
      "",
      "Artist: xelvy",
    ],
    549 => [
      "A peculiar high-ranking Apoptosis",
      "with a shape formed by three",
      "female bodies fused together.",
      "Her base type is classified as",
      "plant-based. Equipped with a",
      "massive mouth at her center,",
      "she devours everything in her",
      "path, consuming not only intruders",
      "but even other Apoptosis. This",
      "behavior suggests a deviation from",
      "the original purpose of Apoptosis,",
      "possibly due to a bug or malfunction.",
      "",
      "Her combat abilities are extremely",
      "high, with powerful vine attacks",
      "and dark miasma assaults unleashed",
      "from her massive body. She ranks",
      "among the highest-tier Apoptosis",
      "residing in the Abyss of Chaos,",
      "possessing near-top-level abilities.",
      "",
      "The semen of human males is her",
      "greatest nutrient source. When she",
      "captures a man, she eagerly extracts",
      "his essence. Before swallowing him",
      "whole, she drains every last drop",
      "of his semen, leaving nothing behind.",
      "",
      "Artist: xelvy",
    ],
    550 => [
      "The guardian of the heavenly gates,",
      "and a massive holy beast that",
      "could be considered the gate",
      "itself. Originally a Cherub,",
      "she was fused with the gate by",
      "Ilias's special decree, tasked",
      "with managing those who pass",
      "through. Her purpose leans more",
      "toward preventing escapes from",
      "heaven to the mortal world,",
      "rather than stopping intrusions",
      "from below. Even angels require",
      "Ilias's permission to pass.",
      "However, during the Second",
      "Great Monster War, she was stationed",
      "at Tartarus, the gateway to",
      "heavens, tasked with eliminating",
      "vanguard forces from other worlds.",
      "Naturally, she was seen as an",
      "anomaly by Apoptosis and faced",
      "numerous attacks.",
      "",
      "Heaven's Gate is granted the",
      "discretion to either devour or",
      "capture and toy with those who",
      "attempt to force their way through",
      "the gates. Those who try to pass",
      "without permission will face",
      "merciless judgment. Due to the",
      "tedium of her long-standing duty,",
      "she has ample time to subject",
      "intruders to endless torment,",
      "lasting for what feels like an",
      "eternity.",
      "",
      "Artist: Setouchi",
    ],
    551 => [
      "Ancient artificial monster",
      "created by the Goddess",
      "during the Great Monster Wars",
      "also referred to as",
      "the Weapon. Crafted using many",
      "angels as materials and the most",
      "advanced technology, she is a",
      "chimera monster. Her appearance",
      "is modeled after a powerful",
      "galactic entity the Goddess once",
      "fought.",
      "",
      "Due to her overwhelming power,",
      "she went out of control and was",
      "discarded by the Goddess into a",
      "separate dimension. Now, having",
      "lost her purpose, she wanders",
      "Tartarus, continuously annihilating",
      "the approaching Apoptosis.",
      "Unintentionally, she shares the",
      "same fate as the Weapon",
      "developed by the Dark Goddess, but",
      "a clash between the Holy and",
      "Dark Weapons never occurred.",
      "",
      "Artist: Setouchi",
    ],
    552 => [
      "Artificial Monster Beast",
      "created by the evil gods",
      "during the Great Monster Wars,",
      "also referred to",
      "as the Weapon. She was crafted by",
      "combining the superior traits of",
      "various monsters and advanced",
      "magic, making her a chimera",
      "monster. While she technically",
      "obeys the commands of her",
      "registered master, her destructive",
      "impulses are extremely strong,",
      "often leading to instability and",
      "rampages. Ultimately, she proved",
      "too difficult to control and was",
      "discarded by the Dark Goddes into a",
      "separate dimension. Now, having",
      "lost her purpose, she wanders",
      "Tartarus, continuously annihilating",
      "the approaching Apoptosis.",
      "Unintentionally, she shares the",
      "same fate as the Weapon developed",
      "by the goddess, but a clash",
      "between the Holy and Dark",
      "Weapons never occurred.",
      "",
      "Her tail's sperm extraction tool,",
      "Priestra, envelops males of any",
      "species, draining their essence to",
      "use as an energy source. However,",
      "the most efficient energy supply",
      "remains the semen of human males.",
      "",
      "Artist: Setouchi",
    ],
    554 => [
      "A prodigy among angels, she became",
      "the youngest Archangel in history,",
      "achieving the Eighth Order of the",
      "Hierarchy of Angels. Despite her",
      "youth, her innate magical power",
      "overwhelms even the mightiest of",
      "divine foes. Though her appearance",
      "is innocent, her abilities are",
      "highly combative. She excels at",
      "using swift movements to confound",
      "enemies while exploiting their",
      "weaknesses with precision.",
      "",
      "Due to her lack of experience,",
      "she often takes pride and pleasure",
      "in subduing her foes. The humiliation",
      "and punishment she inflicts as",
      "divine retribution are filled with",
      "shame and depravity, making them",
      "exceptionally brutal. It is said",
      "that she once violated a man guilty",
      "of a minor crime until he perished,",
      "nearly facing judgment for her",
      "actions.",
      "",
      "Artist: Nonhuman Modoki",
    ],
    555 => [
      "Archangel (8th Order), specialized in",
      "close combat. Created to lead a",
      "squad of angel soldiers,",
      "she was mass-produced during",
      "the GreatMonster Wars.",
      "She possesses unique",
      "traits, such as a peculiar accent",
      "and enormous breasts, with rumors",
      "suggesting the use of some monster",
      "genes in her creation.",
      "",
      "Despite her seemingly unbalanced",
      "physique with massive breasts, her",
      "combat performance is not hindered.",
      "Instead, she uses her breasts as",
      "blunt weapons, showcasing superior",
      "fighting skills. As an angel, she",
      "has a hedonistic and lighthearted",
      "personality, getting along well",
      "with Cupid. Many of her kind excel",
      "in specialized skills like",
      "blacksmithing or cooking, giving",
      "them a unique status among angels.",
      "",
      "She is known to enjoy sexual",
      "relations with men without",
      "exception. If she takes an interest",
      "in a man, he can expect a",
      "pleasurable experience making full",
      "use of her enormous breasts. She",
      "actively seeks out men, often",
      "venturing into town during her",
      "leisure time to invite handsome",
      "men to her bed.",
      "",
      "Artist: Cool Cultist",
    ],
    556 => [
      "A chimera monster created through",
      "Promestein's research. The primary",
      "focus of the experiment was to",
      "achieve complete control of multiple",
      "tentacles via a single brain, with",
      "synaptic communication enhanced to",
      "its utmost limits. While it appears",
      "similar to the Scylla species in",
      "having countless tentacles, their",
      "strength and agility far surpass",
      "those of ordinary monsters. The",
      "ultra-fast synaptic conduction",
      "technology established with this",
      "experimental subject has been",
      "applied to more combat-oriented",
      "chimera monsters. Originally an",
      "experimental subject, her exceptional",
      "abilities led to her mass production",
      "as a military asset in the heavens.",
      "",
      "However, the ultra-fast synaptic",
      "conduction that grants her abnormal",
      "agility comes at a significant cost.",
      "Her stamina and magical energy are",
      "severely drained, requiring her to",
      "consume twice the amount of food as",
      "a monster of similar size. She is",
      "also extremely voracious for human",
      "male essence, skillfully using her",
      "tentacles to extract semen from",
      "captured men. Once she captures her",
      "prey, it is said she will continue",
      "to drain their essence until they",
      "perish.",
      "",
      "Artist: Setouchi",
    ],
    557 => [
      "A artificial pseudo-spirit created",
      "through mechanical technology,",
      "endowed with the power to control",
      "water. She is stationed at the",
      "Water Spirit Spring in the Noah",
      "region, ruled by Uriela, and is",
      "said to oversee the flow of water",
      "across the world. Her abilities",
      "are on par with those of an",
      "Undine, but maintaining them",
      "requires an enormous amount of",
      "spiritual energy. As a result,",
      "many second-class citizens and",
      "male political prisoners are",
      "brought to the Water Spirit Spring",
      "to replenish her energy through",
      "sexual intercourse. This fact is",
      "considered a top-secret within",
      "the Angelic Dominion.",
      "",
      "She is extremely taciturn and",
      "possesses a ruthless personality,",
      "mercilessly draining the life",
      "force of the men provided to her",
      "as sustenance. Though effectively",
      "a prisoner herself, she harbors",
      "no particular resentment toward",
      "the angels, as the supply of",
      "spiritual energy never falters.",
      "However, it is said that deep",
      "down, she harbors a faint hope",
      "for someone who can fully harness",
      "her power.",
      "",
      "Artist: UN_DO",
    ],
    558 => [
      "A high-ranking Archangel of the",
      "eighth Order among the nine",
      "hierarchies of angels, she is",
      "an executor of",
      "divine punishment with combat",
      "prowess surpassing even that of",
      "the Valkyries. In the past, she",
      "played an active role in the",
      "Great Monster Wars a thousand",
      "years ago and has been stationed",
      "at key locations in preparation",
      "for the coming great conflict.",
      "",
      "Her combat abilities far exceed",
      "those of high-ranking demons in",
      "the mortal world, to the point",
      "where she can single-handedly",
      "exterminate thousands of monsters.",
      "Her severity toward sinners is",
      "also unparalleled, and she",
      "metes out merciless divine",
      "punishment to those who stray",
      "from the path of righteousness.",
      "",
      "It should be noted that angels",
      "of higher ranks than Archangels",
      "are mostly engaged in managerial",
      "duties beyond combat, such as",
      "soul management and maintaining",
      "order. Thus, it cannot be said",
      "that higher ranks necessarily",
      "mean greater combat prowess.",
      "In particular, Archangels, due",
      "to their role as special forces,",
      "are said to include many warriors",
      "rivaling even higher-ranking",
      "angels in strength.",
      "",
      "Artist: Shinji Yukimura",
    ],
    559 => [
      "An executor of divine punishment,",
      "Ranael holds the rank of the Eighth",
      "Order Archangel among the nine",
      "angelic hierarchies. She boasts",
      "immense combat prowess, often",
      "leading annihilation missions in",
      "enemy strongholds. Her nature is",
      "ferocious, and she takes cruel",
      "delight in tormenting and killing",
      "those she deems evil.",
      "",
      "Her body harbors various plants",
      "and biological organs, a result of",
      "assimilation with natural elements",
      "through holy energy. This is",
      "distinct from the organs of demons.",
      "However, maintaining her body is",
      "most efficient through the intake",
      "of male semen. Thus, when carrying",
      "out punishments on male sinners,",
      "she never forgets to extract their",
      "essence as part of the process.",
      "",
      "Artist: Setouchi",
    ],
    560 => [
      "Created as a symbol to strengthen",
      "the faith of the devotees,",
      "she is a Virtue, the fifth order",
      "in the angelic hierarchy. Though",
      "designed with a divine appearance,",
      "she is far from just a pretty face.",
      "Her power far surpasses that of",
      "ordinary angel soldiers.",
      "",
      "During the desolate period after",
      "the Great Monster Wars, she acted as",
      "a radiant symbol across the lands,",
      "ensuring people's faith",
      "in the Goddess.",
      "After Ilias' rule was fully",
      "established, she took on the role",
      "of governor in various administrative",
      "regions. She is often dispatched",
      "to Sabasa, a major agricultural",
      "nation responsible for food production",
      "in the heavens, where she faithfully",
      "fulfills her bureaucratic duties.",
      "",
      "Despite her immense power, she is",
      "notoriously greedy. When men are",
      "offered to her, she thoroughly",
      "drains them of their essence. She",
      "views humans, and indeed the entire",
      "heavens, as the property of the",
      "Goddess, so she avoids unnecessary",
      "killing. However, men who fall prey",
      "to her insatiable appetite are left",
      "unable to stand for several days.",
      "",
      "Artist: Delphinus",
    ],
    561 => [
      "A chimera monster of the highest",
      "caliber, created by Promestein,",
      "and one of the Next Dolls. Unlike",
      "the Four Heavenly Knights type,",
      "she was developed as a base model",
      "for creating the other four,",
      " making her a plain-type prototype.",
      "",
      "As one of the earliest Next Dolls",
      "developed, Rapunzel is a",
      "reproduction-specialized type.",
      "The other four were created by",
      "improving upon multiple base",
      "forms she produced. Initially,",
      "she functioned solely as a",
      "reproductive organ, essentially",
      "a 'egg-laying machine,' before",
      "being completed as a self-aware",
      "monster.",
      "",
      "Despite being a reproduction-",
      "specialized type, she possesses",
      "exceptionally high base abilities",
      "to pass on superior genes to",
      "the other four. While she lacks",
      "outstanding traits in any single",
      "area, her overall capabilities",
      "are remarkably high. Compared to",
      "the other four, who are more",
      "specialized, she boasts greater",
      "versatility. With no noticeable",
      "weaknesses, she excels in",
      "adapting to any situation, making",
      "her the most well-rounded of the",
      "five.",
      "",
      "Artist: Tomasu",
    ],
    562 => [
      "An angel belonging to the seventh",
      "rank of the Angelic Hierarchy,",
      "the Principality, she is a",
      "judgment and punishment angel",
      "accompanied by a sacred snake.",
      "She usually resides in the",
      "courthouses of various towns,",
      "where her primary duty is to",
      "judge deceased humans based on",
      "their actions in life. Those",
      "deemed guilty are punished by",
      "the sacred snake under her",
      "command. Through harsh",
      "constriction or licking the",
      "entire body, the snake inflicts",
      "severe torment, forcing the",
      "guilty to repent for their sins.",
      "",
      "While she typically serves as a",
      "judge and punisher in cities",
      "during peacetime, she may also",
      "descend to the mortal world in",
      "times of crisis to vanquish evil.",
      "In such cases, she unleashes her",
      "tamed sacred snake to directly",
      "deliver judgment on the battlefield.",
      "No one has ever survived being",
      "judged by Nagael while still alive.",
      "After enduring her brutal",
      "punishment, they meet a agonizing",
      "death, and their soul is judged",
      "anew. However, with the recent",
      "decline in criminals, she has been",
      "increasingly assigned as an on-site",
      "commander for pioneering projects.",
      "Even in these new territories, her",
      "harsh judgment is feared by all.",
      "",
      "Artist: Setouchi",
    ],
    563 => [
      "A chimera created through",
      "Promestein's research. A hybrid",
      "type of artificial monster made",
      "by combining two different",
      "monsters: a Dullahan and a",
      "Medusa. While most primitive",
      "experiments of this kind failed,",
      "this individual one miraculously",
      "achieved compatibility, resulting",
      "in an exceptional physical form.",
      "The magical power of the two",
      "monsters was not merely added",
      "but multiplied, far surpassing",
      "the strength of naturally",
      "occurring monsters.",
      "",
      "However, the extreme metabolic",
      "activation has not resolved the",
      "issue of high energy consumption.",
      "It requires far more essence",
      "than ordinary monsters, actively",
      "preying on human males and",
      "ruthlessly draining their semen",
      "using her hair snakes and female",
      "genitals. Additionally, the Medusa",
      "traits have amplified her cruelty,",
      "as she is known to petrify her",
      "terrified prey before violating",
      "them.",
      "",
      "Artist: Setouchi",
    ],
    564 => [
      "An artificial spirit created through",
      "mechanical technology, possessing",
      "the power to manipulate earth.",
      "She is stationed at the Safar Ruins",
      "in the Sabasa region, ruled by",
      "Gabriela, and is tasked with",
      "maintaining the earth's balance.",
      "Her abilities rival those of Gnome,",
      "but require an enormous amount of",
      "spiritual energy to sustain. Thus,",
      "many second-class citizens and",
      "political prisoners are brought to",
      "the Safar Ruins, where their",
      "energy is relinqushed to Gnomaren",
      "through sexual intercourse.",
      "This fact is considered a top-secret",
      "within the Angelic Dominion.",
      "",
      "Though not cruel, she is highly",
      "voracious, often draining men",
      "until they are completely spent.",
      "At her core, she is lonely, but",
      "she cannot befriend the angels",
      "who manage her, leaving her in a",
      "constant state of solitude.",
      "",
      "Artist: UN_DO",
    ],
    565 => [
      "Archangel of 8th Order, created at",
      "Gabriela's request. She oversees",
      "the management of the Grand Farm",
      "and possesses healing abilities",
      "for the laborers, making her a",
      "simplified, mass-produced version",
      "of Gabriela. Naturally, her combat",
      "abilities are also formidable,",
      "equipped to handle large-scale",
      "rebellions with ease.",
      "",
      "She has an extremely obedient",
      "personality, silently carrying",
      "out orders from above. However,",
      "her ability to handle unexpected",
      "situations is notably poor, and",
      "she rarely acts on her own",
      "judgment. Though she seems to hold",
      "significant dissatisfaction",
      "toward Gabriela, she never voices",
      "it, keeping it buried deep within",
      "her heart.",
      "",
      "She can obtain nutrients through",
      "photosynthesis, making meals",
      "almost unnecessary. Although",
      "collecting human semen is",
      "prohibited by regulations, on the",
      "rare occasion she obtains it,",
      "she thoroughly milks it dry,",
      "treating it as a rare delicacy.",
      "",
      "Artist: Raichi",
    ],
    566 => [
      "Created as a symbol to strengthen",
      "the faith of the devotees,",
      "she is a Virtue, the fifth order",
      "in the angelic hierarchy. Though",
      "designed with a divine appearance,",
      "she is far from just a pretty face.",
      "Her power far surpasses that of",
      "ordinary angel soldiers.",
      "",
      "During the desolate period after",
      "the Great Monster Wars, she acted as",
      "a radiant symbol across the lands,",
      "ensuring people's faith",
      "in the Goddess.",
      "After Ilias' rule was fully",
      "established, she took on the role",
      "of governor in various administrative",
      "regions. She is often dispatched",
      "to Sabasa, a major agricultural",
      "nation responsible for food production",
      "in the heavens, where she faithfully",
      "fulfills her bureaucratic duties.",
      "",
      "Despite her immense power, she is",
      "notoriously greedy. When men are",
      "offered to her, she thoroughly",
      "drains them of their essence. She",
      "views humans, and indeed the entire",
      "heavens, as the property of the",
      "Goddess, so she avoids unnecessary",
      "killing. However, men who fall prey",
      "to her insatiable appetite are left",
      "unable to stand for several days.",
      "",
      "Artist: Delphinus",
    ],
    567 => [
      "One of the Seven Archangels",
      "created by the Goddess Ilias from",
      "the Angelic Dominion during the",
      "Great Monster Wars, she is known",
      "by the epithet Holy Lily of",
      "Compassion. Renowned as the",
      "Dominion's most skilled healer,",
      "her mastery over support and",
      "enhancement magic is unparalleled.",
      "Additionally, she excels in",
      "whip-based combat techniques,",
      "making her a formidable force",
      "among the Dominion's elite. She",
      "oversees Sabasa, a vast agrarian",
      "state responsible for the realm's",
      "food production. She pioneered the",
      "large-scale farming system that",
      "employs clone workers and has",
      "garnered immense praise from the",
      "Goddess Ilias herself for this",
      "achievement. Her ambition extends",
      "even further, with plans to",
      "selectively clone elite citizens",
      "for broader applications.",
      "",
      "Contrary to her epithet, she is",
      "ruthlessly ambitious and",
      "exceedingly cruel. She views",
      "others merely as tools to further",
      "her own success. Her hunger",
      "extends to men, whom she handpicks",
      "and brings to her bedroom,",
      "draining them of their semen until",
      "death, indulging in the pleasure",
      "it brings her.",
      "",
      "Artist: xelvy",
    ],
    568 => [
      "A mass-produced close-combat specialized",
      "Archangel (8th Order). She belongs to",
      "the highest class of soldier types,",
      "possessing combat power far beyond",
      "that of ordinary angel soldiers.",
      "Fierce and highly skilled in battle,",
      "her ability to manipulate holy energy",
      "is inferior compared to other",
      "Archangels, and she dislikes complex",
      "thoughts, tending to charge recklessly",
      "into battle. However, her production",
      "cost is about half that of a typical",
      "Archangel, leading to mass production",
      "in preparation for the Second Holy",
      "War. She is deployed widely across",
      "cities as advanced guards, serving as",
      "a key defensive force.",
      "",
      "Due to her extremely high combat",
      "instincts, her sexual desires are",
      "equally intense. She takes pleasure",
      "in sexually tormenting subdued men,",
      "and at times, she may even violate",
      "and kill them in a fit of sadism.",
      "Her personality, which values power",
      "above all, leads her to deeply respect",
      "Uriela, one of the Seven Archangels.",
      "Being stationed in Grand Noah is said",
      "to be the dream of Giriel and her",
      "kind. On the other hand, she seems",
      "to clash with the more strategic",
      "types like Raphaela and Gabriela.",
      "",
      "Artist: Raichi",
    ],
    569 => [
      "A chimera soldier mass-produced for the",
      "purpose of forcefully subduing human",
      "towns. Abundant mechanical technology",
      "is used, with over 80% of her body",
      "mechanized. Her personality is cruel",
      "and merciless, finding the greatest",
      "joy in oppressing others. The Angelic",
      "Dominion received design data from the",
      "Alliance of Wisdom and mass-produced",
      "them. Originally designed for invasion,",
      "they are now deployed in large numbers",
      "around Grand Noah, near Esta, as a",
      "defensive force against attacks from",
      "other worlds. A significant number",
      "have also been assigned to the Grangold",
      "Maximum Security Prison.",
      "",
      "The special unit integrated with her",
      "right arm can emit electric shocks and",
      "also function as a semen extraction",
      "device using its vacuum capability.",
      "It is said that one of her tasks is to",
      "collect and store extracted semen in",
      "special tanks for retrieval.",
      "",
      "Once captured by her, there is no",
      "escape. Every last drop of semen will",
      "be ruthlessly extracted. Surrender is",
      "not an option, and most are drained",
      "to death. Even if taken as a prisoner,",
      "it can hardly be called fortunate.",
      "In that case, a living hell of",
      "semen extraction undoubtedly awaits.",
      "",
      "Artist: xelvy",
    ],
    570 => [
      "An angel belonging to the seventh",
      "rank of the Angelic Hierarchy,",
      "the Principalities (Principality),",
      "skilled in swordsmanship and",
      "combat. She possesses immense",
      "martial prowess and a fiery",
      "instinct for battle, yet maintains",
      "strict self-discipline, never",
      "succumbing to vulgarity. Originally",
      "organized as part of the Seven",
      "Archangels Uriela's personal guard,",
      "her excellence led to numerous",
      "requests for her deployment from",
      "various nations. Currently, she is",
      "stationed at key locations across",
      "the land. The Sabiriels, having",
      "endured Uriela's harsh military",
      "training, are highly valued as",
      "essential to urban defense.",
      "",
      "Many of them also thrive as",
      "gladiators in the colosseum,",
      "entertaining the crowds as stars",
      "of the arena.",
      "",
      "When violating men, she pins them",
      "down as if extending a grappling",
      "technique, then humiliates them.",
      "No man can resist her muscular",
      "strength, and they are helplessly",
      "pinned down, their essence drained.",
      "In the colosseum, many gladiators",
      "are publicly humiliated by Sabiriel,",
      "and there are numerous men who",
      "willingly seek to be violated by",
      "her and her kind.",
      "",
      "Artist: Makiya",
    ],
    571 => [
      "An angel belonging to the seventh",
      "rank of the Angelic Hierarchy,",
      "the Principalities (Principality),",
      "skilled in swordsmanship and",
      "combat. She possesses immense",
      "martial prowess and a fiery",
      "instinct for battle, yet maintains",
      "strict self-discipline, never",
      "succumbing to vulgarity. Originally",
      "organized as part of the Seven",
      "Archangels Uriela's personal guard,",
      "her excellence led to numerous",
      "requests for her deployment from",
      "various nations. Currently, she is",
      "stationed at key locations across",
      "the land. The Sabiriels, having",
      "endured Uriela's harsh military",
      "training, are highly valued as",
      "essential to urban defense.",
      "",
      "Many of them also thrive as",
      "gladiators in the colosseum,",
      "entertaining the crowds as stars",
      "of the arena.",
      "",
      "When violating men, she pins them",
      "down as if extending a grappling",
      "technique, then humiliates them.",
      "No man can resist her muscular",
      "strength, and they are helplessly",
      "pinned down, their essence drained.",
      "In the colosseum, many gladiators",
      "are publicly humiliated by Sabiriel,",
      "and there are numerous men who",
      "willingly seek to be violated by",
      "her and her kind.",
      "",
      "Artist: Makiya",
    ],
    572 => [
      "A renowned elven magic swordsman",
      "known as the strongest swordsman",
      "under the heavens. Her sword flashes",
      "surpass even combat-specialized",
      "angels like Sabiriel, and her fame",
      "resounds across the entire Angelic",
      "Dominion, despite being a monster.",
      "Having obtained citizenship in",
      "Grand Noah, a city that encourages",
      "martial prowess, she relentlessly",
      "seeks out battles with the strong.",
      "She seems to distance herself from",
      "movements like monster liberation.",
      "At her core lies the belief that",
      "the weak deserve to be oppressed,",
      "and the world is ultimately ruled",
      "by the strong. Her homeland appears",
      "to be the island of fairies, but",
      "her origins and how she became a",
      "magic swordsman remain entirely",
      "unknown.",
      "",
      "She is a regular at the colosseum,",
      "having swiftly defeated countless",
      "combatants. Following the colosseum's",
      "customs, she has violated defeated",
      "men. Her signature moves, such as",
      "face-crushing with her large butt",
      "or riding atop her opponents, are",
      "feared by men. Whispers of awe and",
      "admiration speak of being 'crushed",
      "by Fernandez's huge ass.'",
      "",
      "Artist: UN_DO",
    ],
    573 => [
      "One of the Seven Archangels",
      "created by the Goddess Ilias from",
      "the Angelic Dominion during the",
      "Great Monster Wars, she is a",
      "living embodiment of combat, her",
      "entire body equipped with",
      "devastating weaponry. Her",
      "overwhelming prowess in battle is",
      "legendary, said to rival even",
      "Micaela, the strongest in the",
      "Dominion, when it comes to sheer",
      "physical might. Her strength",
      "resonates across all of the",
      "Dominion, inspiring warriors far",
      "and wide to revere her as an ideal",
      "to strive toward.",
      "Tasked with governing Grand Noah,",
      "she delegates administrative",
      "duties to her highly competent",
      "subordinates, trusting their",
      "judgment. Her sharp eye for talent",
      "ensures that politics in Grand",
      "Noah flow smoothly under her rule.",
      "She promotes martial strength",
      "above all else, respecting even",
      "monsters if they prove themselves",
      "strong. Conversely, she has no",
      "regard for the weak, dismissing",
      "them entirely. This philosophy",
      "makes the region's development",
      "especially harsh, with",
      "second-class citizens reportedly",
      "treated worse than slaves.",
      "",
      "When it comes to violating men,",
      "Uriela is as relentless and brutal",
      "as she is in battle. However, she",
      "only targets men of exceptional",
      "fortitude, ensuring she never",
      "unintentionally kills them through",
      "overexertion. That said, no matter",
      "how resilient a man may be,",
      "enduring Uriela's rape will",
      "inevitably leave him completely",
      "drained, unable to stand or move",
      "for some time.",
      "",
      "Artist: xelvy",
    ],
    574 => [
      "Belonging to the sixth rank of the",
      "nine angelic Orders, Powers, she",
      "oversees the ecology of insects",
      "in the Dominion, with her primary",
      "duty being to regulate the",
      "population of various species.",
      "She possesses the genes of all",
      "insects existing across the world",
      "and, when the balance of",
      "individual species is greatly",
      "disrupted, she can fertilize",
      "male sperm to produce numerous",
      "insects herself. To fulfill this",
      "task of ecological preservation,",
      "she must always secure men for",
      "breeding purposes.",
      "",
      "The genes of various insects",
      "manifest in her body, giving her",
      "a monstrous appearance that can",
      "be mistaken for a monster. These",
      "insect traits grant her high",
      "combat abilities, and during",
      "times of great chaos, she is",
      "sometimes deployed as a military",
      "asset. Even then, if she spots",
      "a criminal who seems suitable for",
      "reproduction, she swiftly secures",
      "and captures them.",
      "",
      "Artist: Setouchi",
    ],
    575 => [
      "Belonging to the fifth rank of the",
      "nine angelic Orders, Virtue,",
      "Her primary duty is",
      "to wrap the souls of the deceased",
      "with bodies (souls unable to leave",
      "their bodies due to certain",
      "circumstances) in threads, encase",
      "them in cocoons, and guide them",
      "to ascension. Due to her duties,",
      "she often descends to the mortal",
      "world, despite being a higher",
      "angel.",
      "",
      "The 'Threads of Eternity' emitted",
      "from her body are imbued with",
      "sacred energy, granting ecstasy",
      "to the souls they envelop as they",
      "ascend. If a living human were to",
      "be wrapped in these threads,",
      "they would experience such bliss",
      "that their body would relax",
      "completely. A woman would",
      "repeatedly climax, while a man",
      "would spill his seed until his",
      "life was drained away. Of course,",
      "such acts are forbidden, but if",
      "the target is a sinner, it's a",
      "different story. Though she has",
      "had few opportunities to enact",
      "divine punishment due to",
      "jurisdictional constraints, she",
      "harbors a desire to one day",
      "subdue a sinner, wrap them in the",
      "'Threads of Eternity' while still",
      "alive, and guide them to ascension.",
      "",
      "Artist: Delphinus",
    ],
    576 => [
      "One of the Seven Archangels",
      "created by the Goddess Ilias from",
      "the Angelic Dominion during the",
      "Great Monster Wars and overseer of",
      "the Grangold Maximum Security",
      "Prison, where notorious criminals",
      "and political prisoners are",
      "confined. Designed with undead",
      "traits, her body possesses an",
      "extraordinary regenerative",
      "ability, making her nearly",
      "immortal. While her usual focus is",
      "on managing the prison, she wields",
      "exceptional skill in scythe",
      "techniques and magical power,",
      "ranking among the Dominion's most",
      "formidable fighters. As a warden,",
      "she also carries out torture and",
      "executions, not out of cruelty,",
      "but simply as part of her duties.",
      "She strictly adheres to rules and",
      "regulations, maintaining a",
      "serious, no-nonsense demeanor with",
      "zero tolerance for leniency.",
      "Despite her stern nature, both",
      "toward herself and her",
      "subordinates, she commands a",
      "surprising level of respect from",
      "those who serve under her, as she",
      "is fair and refrains from imposing",
      "unreasonable demands.",
      "",
      "Her genitals are equipped with",
      "multiple biological torture",
      "mechanisms designed to inflict",
      "intense torment on the genitals of",
      "male prisoners. She administers",
      "severe punishments and, at times,",
      "even executes prisoners using this",
      "torturous physiology. It's said",
      "that when a man finally succumbs,",
      "Sariela's vagina is left",
      "overflowing with his dying sperm.",
      "",
      "Artist: xelvy",
    ],
    577 => [
      "Belonging to the sixth rank of the",
      "nine angelic Orders, Power",
      "Berryelle is tasked with judging",
      "sinners in the Dominion. She",
      "specializes in punishing the sin",
      "of gluttony. To test the souls of",
      "sinners sent to the heavens, she",
      "takes the form of a fruit and",
      "devours those who attempt to eat",
      "her. After the Great Monster Wars and",
      "the transformation of the world",
      "into a heavenly realm, she became",
      "a warden in the prison city of",
      "Grangold. She oversees prisoners",
      "and carries out devouring",
      "punishments, maintaining a deep",
      "connection with sinners even now.",
      "",
      "In times of crisis, she is also",
      "deployed as a combatant, using",
      "her devouring abilities to",
      "mercilessly consume both the",
      "bodies and souls of the enemies",
      "of the Goddess. She is an extremely",
      "cruel and greedy angel, to the",
      "point that other angels mock her",
      "for committing the sin of",
      "gluttony herself.",
      "",
      "Artist: Delphinus",
    ],
    578 => [
      "A chimera monster created by the Dominion",
      "to cultivate experimental subjects.",
      "Developed at the Remina Research Institute",
      "using data provided by the Alliance of Wisdom",
      "and advanced Dominion technology.",
      "Its body can cultivate various life forms",
      "in optimal conditions, making it highly",
      "valuable for research and production.",
      "It is said that the Chimera Plant's existence",
      "enabled the mass production of various",
      "chimera monsters, whose data was also",
      "provided by the Alliance of Wisdom.",
      "",
      "Though not originally designed for combat,",
      "its capture capabilities and durability",
      "are exceptional. Reserve units are sometimes",
      "deployed to capture intruders. Additionally,",
      "it possesses the ability to extract semen",
      "from male subjects it captures, draining them",
      "of their sperm until they are completely",
      "exhausted.",
      "",
      "Artist: Setouchi",
    ],
    579 => [
      "Revel belongs to the fifth rank of",
      "the nine angelic Orders, Virtue",
      "She possesses the ability",
      "to reincarnate the souls",
      "of the dead or living into new",
      "existences. She can reincarnate",
      "individuals favored by the Goddess",
      "while preserving their genetic",
      "information, or transform the souls",
      "of those deemed undesirable into",
      "entirely different beings. Due to",
      "this unique trait, she often",
      "receives direct orders from Ilias",
      "herself.",
      "",
      "When reincarnating a living being,",
      "their body is dissolved within",
      "Revel's own. The pleasure during",
      "this process is said to be immense,",
      "leaving them trembling with the",
      "ecstasy of rebirth.",
      "",
      "Artist: Delphinus",
    ],
    580 => [
      "A artificial pseudo-spirit created",
      "through mechanical technology,",
      "endowed with the power to control",
      "flames. She is stationed in the",
      "Gold Volcano Cave of the Gold",
      "Region, ruled by Sariela, and is",
      "responsible for managing the flow",
      "of fire. Her abilities rival those",
      "of a Salamander, but maintaining",
      "them requires an enormous amount",
      "of energy. As a result, many",
      "criminals are brought to the Gold",
      "Volcano Cave, where their energy",
      "is relinkquishe to Gigamander",
      "through sexual intercourse.",
      "This fact is widely",
      "known within the Grangold Prison",
      "as 'being used as fuel for the",
      "Gigamander.'",
      "",
      "She is highly combative, violent,",
      "and possesses extreme sadistic",
      "tendencies. It is common for her",
      "to drain men of their energy until",
      "they collapse, and she often uses",
      "ejaculation as a form of execution.",
      "Although she is not the type to",
      "resign herself to being a captive,",
      "she seems to adore the lava-filled",
      "environment more than any other",
      "place in the world and has never",
      "attempted to escape.",
      "",
      "Artist: UN_DO",
    ],
    581 => [
      "A top-tier chimera monster created",
      "by Promestein, and one of the",
      "Next Dolls. Designed as a combat",
      "force against Alma Elma, one of",
      "the Four Heavenly Knights of the",
      "Monster Lord's Army, she boasts",
      "overwhelming speed. She can freely",
      "manipulate wind, allowing her to",
      "counter Alma Elma's wind magic.",
      "Additionally, her pleasure nerves",
      "have been removed, rendering her",
      "immune to succubus pleasure",
      "attacks.",
      "",
      "However, the removal of her",
      "pleasure nerves has severely",
      "impacted her emotions, leaving her",
      "mentally unstable. Her extreme",
      "cruelty and the joy she derives",
      "from inflicting suffering on",
      "others are also consequences of",
      "this emotional disorder. Her body",
      "has been lightweighted in exchange",
      "for her speed, resulting in a",
      "significant sacrifice to her",
      "defensive capabilities. While she",
      "can overwhelm other speed-focused",
      "opponents, she struggles against",
      "highly skilled warrior types.",
      "",
      "That said, it is nearly impossible",
      "to match Hainuwele's speed, and",
      "only a warrior who has mastered",
      "both speed and technique can hope",
      "to withstand her overwhelming",
      "pace.",
      "",
      "",
      "Artist: Tomasu",
    ],
    582 => [
      "They are a mysterious group known as",
      "the 'Moon People', with all",
      "members, except their commander",
      "class, sharing the same face and",
      "appearance. Each of them is a",
      "skilled swordsman, possessing",
      "combat abilities far surpassing",
      "those of angel soldiers. They",
      "descend from the moon in groups",
      "using unknown landing craft, often",
      "causing significant damage to towns",
      "and villages under angel rule.",
      "While their primary targets are",
      "angels, they do not harm the",
      "inhabitants. However, they neither",
      "cooperate nor align with any",
      "ground-based rebel organizations,",
      "operating instead as an independent",
      "combat group that repeatedly",
      "launches assaults.",
      "",
      "Their true nature is believed to be",
      "that of clones, but why they are",
      "based on the moon remains a complete",
      "mystery. Although a gag order has",
      "been placed on information about",
      "the 'Moon People', their",
      "existence has become a topic of",
      "whispers among the populace.",
      "",
      "Artist: frfr",
    ],
    583 => [
      "A female warrior believed to be",
      "of captain rank among the",
      "'People of the Moon'. She shares",
      "the same face as others of her",
      "kind, but her hairstyle and",
      "armaments differ, suggesting",
      "a higher rank than ordinary",
      "soldiers. Her combat abilities",
      "far surpass those of regular",
      "troops, to the point where even",
      "mid-tier angels stand no chance",
      "against her. She also excels in",
      "tactical insight and judgment,",
      "which is why, despite repeated",
      "raids, no 'Moon People'",
      "has ever been captured.",
      "",
      "Three other commander-class",
      "individuals have been confirmed,",
      "but they have never been deployed",
      "to the same battlefield at once.",
      "An attack on the Moon has been",
      "planned, but with at least four",
      "such warriors in existence, the",
      "deployment of the Seven Archangels",
      "would be necessary, causing the",
      "plan to be postponed.",
      "",
      "Artist: frfr",
    ],
    584 => [
      "A chimera monster created through",
      "Promestein's research. By",
      "manipulating the embryo of a",
      "slug-type mollusk monster, she",
      "has successfully developed",
      "tongue-like organs across her",
      "entire body. Each tongue on her",
      "body possesses taste buds and",
      "can secrete saliva. They can",
      "also extend and retract to some",
      "degree. Her vitality and physical",
      "abilities have significantly",
      "improved, and aside from an",
      "increased greed for food, no",
      "mental issues have been observed.",
      "Though an early-stage embryo-",
      "manipulated chimera monster, her",
      "simplicity in design results in",
      "a high level of completion.",
      "",
      "She favors the bodily fluids of",
      "humans or monsters, licking the",
      "entire bodies of both men and",
      "women to absorb sweat and saliva.",
      "However, her favorite delicacy is",
      "the semen of human males. If her",
      "prey is male, she thoroughly",
      "licks his crotch, extracting and",
      "absorbing his semen through her",
      "tongue's mucous membrane. Her",
      "exceptional tongue skills make it",
      "easy to bring her prey to orgasm",
      "multiple times. While she usually",
      "licks her prey until they are",
      "exhausted, if the male possesses",
      "exceptionally high-quality semen,",
      "she may capture and keep him",
      "alive for further use.",
      "",
      "Artist: Setouchi",
    ],
    585 => [
      "A chimera monster created through",
      "Promestein's research. Designed as",
      "an early model focused on enhancing",
      "reproductive capabilities, it was",
      "intended as an experimental subject",
      "for the future mass production of",
      "chimera monsters. It incorporates",
      "cells from the ancient insect monster",
      "Beelzebub, now believed to be",
      "extinct, granting it a terrifyingly",
      "high reproductive capacity.",
      "",
      "Though its primary purpose was to",
      "experiment with reproductive",
      "enhancement, it also possesses an",
      "insect-like exoskeleton and agility,",
      "making it highly effective. With the",
      "Second Great Monster War in mind,",
      "many have been mass-produced",
      "as easily deployable combat units.",
      "",
      "Its reproductive instincts are",
      "extremely strong, and it will",
      "forcefully mate with any human male",
      "it encounters, compelling him to",
      "impregnate it. Sperm released into",
      "its oviducts is immediately used for",
      "reproduction, fertilizing the eggs",
      "stored within its abdomen. Once a man",
      "has been drained of his essence, he",
      "is discarded as no longer useful.",
      "However, males of high-quality seed",
      "may be captured and kept as breeding",
      "partners.",
      "",
      "Artist: xelvy",
    ],
    586 => [
      "One of the earliest chimera monsters",
      "created through Promestein's research.",
      "A proof-of-concept type using embryo",
      "manipulation, it maximizes slug traits",
      "to greatly enhance basic abilities",
      "such as vitality and burst strength.",
      "It became the foundation for various",
      "chimera monsters that followed. Due",
      "to its technical simplicity, it was",
      "easy to mass-produce, leading Dominion",
      "to create multiple Chimera Slugs.",
      "They are deployed as defensive forces",
      "in critical areas like research labs,",
      "places beyond the sight of the Goddess.",
      "",
      "However, it has the drawback of poor",
      "energy efficiency, requiring vast",
      "amounts of semen to survive. It uses",
      "its two semen-draining tentacles to",
      "extract semen from multiple men until",
      "they are drained of life. Fortunately,",
      "Dominion has no shortage of those who",
      "defy teachings, resist authority, or",
      "are no longer able to work, ensuring",
      "the Chimera Slugs won't go hungry",
      "for the foreseeable future.",
      "",
      "Artist: Setouchi",
    ],
    587 => [
      "A plant-type chimera monster created",
      "through Promestein's research. It",
      "was designed by manifesting plant",
      "organs on a humanoid female body.",
      "The plant parts possess a high",
      "regenerative ability, allowing",
      "them to quickly regrow even after",
      "being severed. Additionally, it has",
      "a nature to attack intruders who",
      "enter its territory, which led to",
      "its mass production as a defensive",
      "force for celestial research labs.",
      "",
      "It shows no signs of intelligence",
      "and attacks prey to quench its",
      "thirst. It indiscriminately targets",
      "both men and women, and sometimes",
      "even other monsters. However, when",
      "attacking human males, it subjects",
      "them to particularly cruel torment.",
      "The lewd flowers and vines on its",
      "body are designed to absorb semen.",
      "They envelop the male's genitals,",
      "forcing him to ejaculate and drain",
      "every last drop of his essence.",
      "After completely draining the prey,",
      "the plant parts envelop the entire",
      "body, absorbing it whole.",
      "",
      "Artist: Delphinus",
    ],
    588 => [
      "A berserker formed from the resentment",
      "of Heinrich, sealed in the sinner's",
      "prison, reacting with the sacred",
      "elements in the atmosphere. It",
      "possesses almost no will of its own,",
      "driven solely by hatred toward",
      "angels. As long as Heinrich's soul",
      "exists, it is inexhaustible, and no",
      "matter how many times it is defeated,",
      "it will never perish. It wields",
      "extraordinary power relentlessly,",
      "a collective that continues to",
      "slaughter angels without end.",
      "",
      "It is drawn to places of high",
      "spiritual energy, such as the",
      "Forest of Spirits, and is said to react",
      "to beings closely related to itself.",
      "However, the exact logic behind its",
      "actions remains shrouded in mystery.",
      "",
      "Artist: Setouchi",
    ],
    589 => [
      "A chimera monster created through",
      "Promestein's research. It was",
      "designed in an attempt to recreate",
      "the ancient bio-weapon",
      "Giganto Weapon,",
      "though its power falls",
      "far short of the original.",
      "Nevertheless, it boasts combat",
      "abilities surpassing those of",
      "ordinary monsters, and a small",
      "number have been produced to",
      "guard key locations.",
      "",
      "Maintaining its massive body",
      "requires vast amounts of essence,",
      "and it devours humans indiscriminately,",
      "regardless of gender. Of course,",
      "it prefers the essence of human",
      "males above all else. A highly",
      "dangerous monster, it also possesses",
      "the ability to petrify its prey.",
      "",
      "Artist: Setouchi",
    ],
    590 => [
      "A chimera monster created through",
      "Promestein's research. Born from",
      "an attempt to recreate the ancient",
      "bio-weapon, Giganto Weapon, its",
      "power ultimately fell short of the",
      "original. As a result, it was",
      "deemed more practical, both in",
      "terms of combat effectiveness and",
      "cost, to mass-produce versatile",
      "bio-weapons rather than pursue",
      "the ultimate single combat unit.",
      "With the decision to mass-produce",
      "the Chimera Beast, a simplified",
      "and easily replicable model, the",
      "Giganto Weapon recreation project",
      "was brought to a close.",
      "",
      "Although the project itself was",
      "abandoned, Typhon's combat",
      "capabilities remain formidable.",
      "A small number were produced and",
      "deployed to key locations such as",
      "research facilities. However,",
      "maintaining her massive body",
      "requires vast amounts of semen,",
      "and it appears many humans have",
      "been sacrificed as sustenance.",
      "",
      "Artist: Setouchi",
    ],
    591 => [
      "A chimera monster of the highest",
      "caliber, created by Promestein,",
      "and one of the Next Dolls. She",
      "was designed as a counterforce",
      "against Erubeite, one of the",
      "Four Heavenly Knights of the",
      "Monster Lord's Army. To combat",
      "Erubetie unique abilities,",
      "she is equipped with various",
      "specialized armaments across",
      "her body. These include a",
      "super-vibration blade capable",
      "of severing and destroying",
      "slime bodies at the cellular",
      "level, vibration armor to",
      "destroy adhesive slime tissue,",
      "and a plasma field that uses",
      "microwave principles to",
      "evaporate wide areas. She is",
      "loaded with anti-slime",
      "equipment. Her basic combat",
      "abilities are also high, and",
      "her main weapon, the super-",
      "vibration blade, demonstrates",
      "immense power even against",
      "physical armor.",
      "",
      "However, due to the various",
      "mechanical systems equipped,",
      "she has a vulnerability to",
      "shocks and impacts in chaotic",
      "battles. Additionally, the",
      "operation of her equipment",
      "consumes a significant amount",
      "of energy, making her",
      "unsuitable for prolonged",
      "combat. While her versatility",
      "is limited, and she is overly",
      "specialized as a counter to",
      "Erubetie, these weaknesses",
      "are unlikely to surface unless",
      "she faces an opponent of",
      "similar caliber. In most cases,",
      "the battle would be decided",
      "before these flaws become",
      "apparent.",
      "",
      "Artist: Tomasu",
    ],
    592 => [
      "A fully autonomous mechanical",
      "lifeform created by Promestein.",
      "Her entire body is mechanical,",
      "with no biological organs used,",
      "making her a complete mechanical",
      "lifeform. With the completion of",
      "Laplace's development, Promestein",
      "concluded that the lineage of",
      "Roids had reached a temporary",
      "state of completion.",
      "",
      "After the Alliance of Wisdom and",
      "the Angelic Dominion formed an",
      "alliance, Laplace was dispatched",
      "to the Dominion. She was invited to",
      "the Remina Research Institute",
      "to support research,",
      "but in times of crisis, she is",
      "called upon as a combat asset.",
      "Her power achieves theoretical",
      "maximum values, and she can",
      "operate multiple extraction",
      "machines. In combat, her",
      "abilities are exceptionally",
      "outstanding. Enemies who face",
      "her are mercilessly crushed and",
      "likely turned into experimental",
      "samples at the Research Institute.",
      "",
      "Artist: xelvy",
    ],
    593 => [
      "A trap statue deployed at key points",
      "in the Heavenly Realm. When a human",
      "male approaches a restricted area,",
      "it emits an aphrodisiac gas that",
      "disrupts the man's mind. If he then",
      "inserts himself into the female",
      "genitals equipped between the",
      "statue's legs, a petrification",
      "spell activates, turning his body",
      "into part of the statue. This is",
      "the trap's mechanism. Additionally,",
      "in anticipation of the Second Monster",
      "War, it has been given the ability",
      "to patrol specific routes. It acts",
      "as a semi-autonomous defensive",
      "force, deployed in multiples at",
      "key strategic locations.",
      "",
      "Men who have been petrified while",
      "engaged with the statue are left",
      "on display as a warning. However,",
      "this has the unintended effect of",
      "arousing some men's desires, and",
      "there is no end to those who",
      "willingly offer themselves to the",
      "Themis Trap. In particular, many",
      "second-class citizens, exhausted",
      "from labor, have been known to",
      "dedicate themselves to the Themis",
      "Trap. In some areas, the traps",
      "have even been removed from",
      "workplaces as a result.",
      "",
      "Artist: frfr",
    ],
    594 => [
      "A top-tier chimera monster created",
      "by Promestein, and one of the",
      "Next Dolls. She was designed as",
      "a countermeasure against Tamamo,",
      "one of the Four Heavenly Knights",
      "of the Monster Lord's Army, and her",
      "body incorporates tissue samples",
      "taken from Tamamo's tail fur.",
      "Essentially, she is a clone of",
      "Tamamo, but modified to the point",
      "where her resemblance is nearly",
      "erased through extensive biological",
      "and mechanical enhancements.",
      "",
      "Her body was designed with a focus",
      "on bolstering her defensive",
      "capabilities to withstand Tamamo's",
      "immense earth-manipulating strength.",
      "Additionally, anti-magic seals are",
      "woven throughout her body to nullify",
      "a wide range of magical attacks.",
      "By incorporating Tamamo's cellular",
      "tissue, she can utilize various",
      "forms of magic, including Taoism.",
      "She can even harness the power of",
      "the earth itself, making her overall",
      "combat prowess exceptionally high.",
      "Though her heavy armor slightly",
      "reduces her speed compared to other",
      "Next Dolls, this is hardly a",
      "significant drawback.",
      "",
      "Artist: Tomasu",
    ],
    595 => [
      "An angel belonging to the ninth Order",
      "of the angelic hierarchy,",
      "Furiel is a specialized brainworker",
      "created for research and development.",
      "Compared to other angels, she possesses",
      "exceptionally high intelligence, but",
      "this also makes her skeptical of the",
      "Goddess's absolute dominion and far",
      "from deeply loyal. That said, without",
      "her research role, she would have no",
      "purpose, so most Furiels obediently",
      "engage in cutting-edge scientific work",
      "as commanded by their superiors.",
      "",
      "Originally, her focus was on brainwork,",
      "and no combat ability was expected of",
      "her. However, her exceptional logical",
      "processing skills allowed her to develop",
      "unique techniques beyond traditional",
      "holy energy manipulation. By applying",
      "knowledge of physics and chemistry, her",
      "techniques boast remarkably high attack",
      "power. Additionally, her body, enhanced",
      "to endure long hours of labor, is also",
      "incredibly resilient, resulting in",
      "unexpectedly high combat prowess.",
      "Though not inherently combative, she is",
      "often mobilized as a combat asset in",
      "times of crisis.",
      "",
      "Artist: Shiruku",
    ],
    596 => [
      "A chimera designed to contain human",
      "males, maintaining their lives while",
      "endlessly extracting their semen.",
      "Developed as a semen-draining plant,",
      "it is a type of chimera monster.",
      "Created accidentally during angel",
      "hybrid experiments, it is based on",
      "a uterine hypertrophy model and",
      "mass-produced. Possessing its own",
      "will and high intelligence, it",
      "manages the samples within the",
      "plant. It is said to capture and",
      "pull back any samples attempting",
      "to escape into the plant.",
      "",
      "The plant itself is an uterus, and",
      "males submerged within are kept",
      "alive like a fetus in the womb.",
      "In this state, they are repeatedly",
      "forced to ejaculate, and their",
      "semen is collected. Once immersed",
      "in this plant, most men succumb",
      "to a sweet ecstasy, becoming",
      "nothing more than mindless husks",
      "dripping with semen.",
      "",
      "It is also used for reproductive",
      "experiments, as eggs can be",
      "introduced into the suction tubes,",
      "allowing for efficient fertilization.",
      "",
      "Artist: Delphinus",
    ],
    597 => [
      "A chimera monster of the Roid type",
      "created by Promestein. Designed to",
      "efficiently collect semen from",
      "multiple targets, it is equipped",
      "with forty-eight extraction units",
      "across its body, capable of",
      "operating simultaneously. Developed",
      "in anticipation of the Rebirth",
      "Plan, which would gather captives",
      "from around the world, its purpose",
      "was to systematically extract",
      "semen from numerous men in an",
      "assembly-line fashion. Even after",
      "the Rebirth Plan vanished due to",
      "the Chaos Crisis, a small number",
      "of these Roids were mass-produced",
      "for semen collection purposes.",
      "",
      "The proportion of mechanical",
      "tissue in its body is extremely",
      "high, with most parts, except for",
      "the brain, head, and spinal cord,",
      "replaced by machinery. Although",
      "not designed for combat, its",
      "physical abilities are remarkable,",
      "and the high performance of its",
      "extraction units contributes to its",
      "exceptionally high combat",
      "capabilities. When switched to",
      "self-defense mode, even monsters",
      "of the demon class would find it",
      "difficult to oppose.",
      "",
      "Artist: xelvy",
    ],
    598 => [
      "A type of Drainroid developed by the",
      "Alliance of Wisdom, simplified and",
      "mass-produced using Dominion's unique",
      "technology. While its performance",
      "is inferior to the original,",
      "the excessive production costs",
      "have been significantly reduced.",
      "As a result, it achieves better",
      "semen extraction efficiency than",
      "mass-producing Drainroids. Plans",
      "were made to deploy them in areas",
      "like second-class citizen settlements",
      "for purposes such as semen collection,",
      "disposal of laborers, or as rewards.",
      "",
      "A single unit can extract semen from",
      "twelve men simultaneously, with very",
      "low operational costs. It also has",
      "the ability to forcibly restrain",
      "resisting targets, making it suitable",
      "for combat use. Its self-defense",
      "armaments are powerful, and it is",
      "programmed to handle attacks on",
      "research facilities. Enemies captured",
      "by a Handyroid can expect a merciless",
      "semen extraction hell without a doubt.",
      "",
      "Artist: xelvy",
    ],
    599 => [
      "One of the Seven Archangels",
      "created by the Goddess Ilias from",
      "the Angelic Dominion during the",
      "Great Monster Wars and designed as",
      "the eldest of the Twin Angels with",
      "nuclear fusion reactors embedded",
      "within their bodies. They boast",
      "boundless energy reserves,",
      "allowing them to unleash",
      "devastating attacks rapidly. Their",
      "signature move, Atomic Heaven,",
      "performed by directly linking",
      "reactors with her little sister,",
      "Sandalphone, rivals even the Sword",
      "of the Heavens of Micaela, which",
      "was considered the strongest",
      "attack in the Dominion, and they",
      "can even fire it consecutively.",
      "However, despite their seemingly",
      "infinite energy, prolonged",
      "high-output operations cause their",
      "reactors to overheat,",
      "necessitating cooling periods.",
      "Still, they are undoubtedly",
      "unparalleled in raw firepower",
      "among the Seven Archangels, so",
      "while this may appear to be a",
      "weakness, only an opponent of",
      "significantly higher power could",
      "exploit such a vulnerability",
      "before they recover.",
      "",
      "Regular maintenance requirements",
      "tether her and her sister to the",
      "Remina Research Facility, where",
      "they also oversee its management.",
      "Though equipped with advanced",
      "technical knowledge due to this",
      "role, Metatronne finds such duties",
      "irksome and unsuited to her",
      "nature. Her fiery and confident",
      "personality contrasts sharply with",
      "Sandalphone's reserved and timid",
      "demeanor. Deeply protective of her",
      "sister, Metatronne will readily",
      "endure personal loss or discomfort",
      "for Sandalphone's sake, a",
      "testament to their unshakable",
      "bond.",
      "",
      "Artist: xelvy",
    ],
    600 => [
      "One of the Seven Archangels",
      "created by the Goddess Ilias from",
      "the Angelic Dominion during the",
      "Great Monster Wars and designed as",
      "the youngest of the Twin Angels",
      "with nuclear fusion reactors",
      "embedded within their bodies. They",
      "boast boundless energy reserves,",
      "allowing them to unleash",
      "devastating attacks rapidly. Their",
      "signature move, Atomic Heaven,",
      "performed by directly linking",
      "reactors with her big sister,",
      "Metatronne, rivals even the Sword",
      "of the Heavens of Micaela, which",
      "was considered the strongest",
      "attack in the Dominion, and they",
      "can even fire it consecutively.",
      "However, despite their seemingly",
      "infinite energy, prolonged",
      "high-output operations cause their",
      "reactors to overheat,",
      "necessitating cooling periods.",
      "Still, they are undoubtedly",
      "unparalleled in raw firepower",
      "among the Seven Archangels, so",
      "while this may appear to be a",
      "weakness, only an opponent of",
      "significantly higher power could",
      "exploit such a vulnerability",
      "before they recover.",
      "",
      "Regular maintenance requirements",
      "tether her and her sister to the",
      "Remina Research Facility, where",
      "she also oversees its management.",
      "Though equipped with advanced",
      "technical knowledge due to this",
      "role, Sandalphone finds such",
      "duties irksome and unsuited to her",
      "nature. Reserved and timid by",
      "nature, she places absolute trust",
      "in her older sister. Her status as",
      "a created being fosters a deep",
      "compassion for experimental",
      "subjects and others like her.",
      "",
      "Artist: xelvy",
    ],
    601 => [
      "An angel belonging to the",
      "ninth Order(rank) of the angelic",
      "hierarchies, a non-combatant tasked",
      "with chores like cleaning and",
      "laundry. Originally meant to be",
      "just that, her appearance caught",
      "the attention of Ilias, who granted",
      "her power, allowing her to surpass",
      "her intended role. As a result,",
      "all her abilities have been",
      "greatly enhanced, making her",
      "stronger than combat-specialized",
      "angels of the same rank.",
      "",
      "She has a gentle and devoted",
      "personality but intensely dislikes",
      "having her daily routines disrupted.",
      "Intruders or others who interfere",
      "will face merciless punishment.",
      "Her ample breasts, in particular,",
      "can be used to first grant men the",
      "pleasures of heaven, and if the",
      "service continues endlessly, they",
      "will eventually experience the",
      "torments of hell.",
      "",
      "Artist: Alexi",
    ],
    602 => [
      "An angel belonging to the",
      "ninth Order(rank) of the angelic",
      "hierarchies, tasked with culinary duties",
      "as a non-combatant. Originally meant",
      "to be just that, her appearance",
      "caught the eye of Ilias, who granted",
      "her power, allowing her to surpass",
      "her intended role. Her abilities",
      "have vastly improved, making her",
      "stronger than even combat-specialized",
      "angels.",
      "",
      "Traditionally, angels had little need",
      "for food, leading to the concept of",
      "'eating' being undervalued. However,",
      "as part of Ilias's national strength",
      "enhancement plan, the goal of",
      "improving physical and mental health",
      "through 'food' emerged. Thus, angels",
      "specializing in 'food' were created.",
      "As a result, the number of angels",
      "interested in food has been slowly",
      "increasing.",
      "",
      "Her mind is solely focused on cooking,",
      "and she tirelessly researches new",
      "dishes and ingredients, embodying a",
      "true artisan spirit. However, she",
      "shows intense anger toward those who",
      "disrespect cooking or interfere with",
      "her work, attacking them with a",
      "frying pan in hand. Those who are",
      "beaten down will likely face pleasure",
      "torture using her voluptuous breasts,",
      "which are too distracting for cooking.",
      "",
      "Artist: Alexi",
    ],
    603 => [
      "A petite angel corresponding to",
      "the 8th Order of the",
      "angelic hierarchies, archangel.",
      "Originally created as a messenger",
      "for important missions, her",
      "adorable appearance caught the",
      "favor of Goddess Ilias, who",
      "granted her power far exceeding",
      "her role. Despite being a lower",
      "angel, her abilities surpass",
      "those of mid-tier angels, and",
      "her combat prowess outshines even",
      "those specialized in battle.",
      "",
      "Her charming appearance has led",
      "her to take on many roles that",
      "involve direct interaction with",
      "the devout citizens. As a result,",
      "she has become the most beloved",
      "angel in the Dominion. However,",
      "her favoritism has drawn",
      "resentment from deformed angels who",
      "are forbidden from appearing",
      "before the devout citizens.",
      "",
      "She is of a serious and earnest",
      "disposition, faithfully carrying",
      "out her assigned duties. Highly",
      "diligent, she spends her free",
      "time studying and improving",
      "herself. When punishing sinners,",
      "she uses her ample bosom to",
      "torment them slowly and thoroughly.",
      "",
      "Artist: Alexi",
    ],
    604 => [
      "A chimera monster created by Promestein,",
      "of the type known as 'Roid,' which",
      "utilizes numerous biomechanical",
      "components. Based on a lamia, she",
      "has undergone various modifications,",
      "granting her exceptional physical",
      "abilities.",
      "",
      "To test how much a biological brain",
      "can control mechanical organs, her",
      "body is equipped with forty-eight",
      "semen extraction devices. However,",
      "even she does not fully understand",
      "their detailed usage, and typically",
      "relies on about five main types of",
      "extraction tools. Naturally, their",
      "effectiveness is overwhelming, and",
      "she can extract semen from multiple",
      "men simultaneously.",
      "",
      "Though experimental, after gathering",
      "basic data, she was deployed to",
      "combat units and sent as part of a",
      "dispatch force to the heavens. She",
      "was used in attacks on rebel groups",
      "and riot suppression, but her actions",
      "were often tactically meaningless,",
      "and she contributed little as a",
      "combat asset.",
      "",
      "Artist: xelvy",
    ],
    605 => [
      "A prototype high-ranking angel created",
      "after the Great Monster Wars, developed",
      "as a test unit in anticipation of",
      "mass-producing mechanical angels.",
      "Though her exterior has sustained",
      "damage, rapid regeneration occurs",
      "via techno-organic means. While",
      "her attack and defense power",
      "increase based on the situation,",
      "her agility has decreased due to",
      "heavy armor. Energy consumption",
      "has also drastically increased,",
      "making this state closer to a",
      "rampant form rather than a true",
      "enhancement.",
      "",
      "Artist: UN_DO",
    ],
    606 => [
      "A prototype high-ranking angel created",
      "after the Great Monster Wars, developed",
      "as a test unit in anticipation of",
      "mass-producing mechanical angels.",
      "The techno-organic system has",
      "overreacted to accumulated damage,",
      "causing mechanical cells to spread",
      "across her entire body. This results",
      "in excessive output increases and",
      "armor reinforcement. However, the",
      "strain on her body is far from",
      "ordinary, and it seems she can no",
      "longer fully maintain her rationality.",
      "",
      "",
      "Artist: UN_DO",
    ],
    607 => [
      "A prototype high-ranking angel created",
      "after the Great Monster Wars, developed",
      "as a test unit in anticipation of",
      "mass-producing mechanical angels.",
      "The damage she sustained exceeded",
      "acceptable levels, causing the",
      "techno-organic system to go haywire.",
      "Her entire body has been rebuilt",
      "as a weapon, granting her",
      "extraordinary firepower and",
      "fortress-like defensive capabilities.",
      "However, as a consequence, her body",
      "has already begun to collapse, and",
      "self-destruction after a short period",
      "of operation was likely unavoidable.",
      "",
      "",
      "Artist: UN_DO",
    ],
    608 => [
      "The Goddess of Creation, cast down",
      "to the ground. Though greatly weakened,",
      "she wandered the land, engaging in",
      "battles and gradually regaining power",
      "on par with high-ranking angels.",
      "Now allied with Ilias of the Dominion,",
      "she appears to oversee the Monster Lord's",
      "Castle in the singularity world,",
      "leading three Seraphs. Always by her",
      "side are a slime girl and a dog girl,",
      "who have been her companions since",
      "the early days of her journey.",
      "",
      "Artist: Akazawa RED",
    ],
    609 => [
      "A slime girl who serves as an attendant",
      "to the Goddess Ilias. She holds a deep",
      "affection for Ilias and has gained",
      "considerable combat experience during",
      "their long journey together. To support",
      "Ilias, she has learned skills such as",
      "dancing and singing, which aid in battle.",
      "However, she remains unreliable when it",
      "comes to fighting on the front lines.",
      "",
      "Artist: Health cross",
    ],
    610 => [
      "A dog girl who serves the Goddess Ilias.",
      "She deeply admires Ilias and has gained",
      "considerable combat experience during",
      "their long journey. To support Ilias,",
      "she has learned healing and support",
      "white magic, but she is still far from",
      "being reliable on the frontlines.",
      "",
      "Artist: Sea mountain",
    ],
    611 => [
      "A Dominion, belonging to the fourth",
      "rank of the nine angelic Orders.",
      "She descends upon saints and heroes",
      "who have devoted themselves to Goddess",
      "upon their death, granting them",
      "pleasure as a reward while guiding",
      "their souls to ascend to heaven.",
      "This role has earned her the",
      "derogatory nickname 'Heaven's Harlot,'",
      "though she seems to take",
      "it in stride with a positive",
      "attitude.",
      "",
      "Due to her duties, her sexual",
      "techniques are considered among",
      "the finest in heaven, capable of",
      "making even the most stoic souls",
      "writhe in ecstasy. At times, the",
      "intensity of pleasure has driven",
      "souls to the point of ruin,",
      "hindering their reincarnation.",
      "Since the souls of saints and",
      "heroes are not exclusively male,",
      "she has also mastered techniques",
      "to please women.",
      "",
      "Traditionally, the souls of heroes",
      "devoted to Goddess were invited to",
      "heaven by Valkyries. However, the",
      "overly serious and rigid nature of",
      "Valkyries made their duties seem",
      "cold and impersonal, leading to",
      "discontent. This role was thus",
      "established several hundred years",
      "ago to address such issues.",
      "",
      "Artist: Delphinus",
    ],
    612 => [
      "A Cherub belonging to the second",
      "rank of the nine angelic Orders.",
      "Blessed by Ilias, Whiteyel's power",
      "was greatly enhanced, leading to",
      "the creation of combat-oriented",
      "angels of the same type. Thus,",
      "Holmiel was born, a humanoid",
      "figure with no monstrous traits,",
      "equipped with the highest level of",
      "combat prowess in the Dominion.",
      "Excelling in hand-to-hand combat",
      "and wielding holy energy with",
      "mastery, she also possesses",
      "exceptional leadership skills.",
      "As a pure combat type, she is an",
      "incredibly reliable presence.",
      "Many of her kind serve as direct",
      "guards to the Goddess in the",
      "Ilias Temple, while some are",
      "promoted to division commanders.",
      "",
      "Compared to the serious and",
      "gentle Whiteyel, Holmiel is fierce",
      "and competitive in nature. She",
      "will thoroughly crush her enemies",
      "and deliver merciless punishment",
      "to those who oppose the Goddess.",
      "",
      "Artist: Alexi",
    ],
    613 => [
      "A new generation of humans developed",
      "as post-Rebirth beings. Goddess",
      "Ilias listed the undesirable traits",
      "of current humans, and Promestein",
      "incorporated these as improvements",
      "into the design, resulting in this",
      "form. Though their appearance is",
      "grotesque, they are undeniably",
      "human. Their physical abilities",
      "and intelligence far surpass those",
      "of current humans, and their",
      "biological organs are all designed",
      "with perfect efficiency. They can",
      "survive on water alone and seem",
      "to require no oxygen for breathing.",
      "",
      "Reproduction occurs when a female",
      "consumes a male through her genital",
      "organs. By absorbing the male, the",
      "female acquires new genetic material",
      "and is essentially reborn. It is said",
      "that as the male is devoured, he",
      "experiences a lifetime's worth of",
      "pleasure before his life ends, thus",
      "offering his existence to the next",
      "generation.",
      "",
      "Artist: frfr",
    ],
    614 => [
      "A clone of the hero Luka, created",
      "through Promestein's genetic",
      "engineering. Originally, the clone",
      "was androgynous, capable of freely",
      "changing genders at will. However,",
      "when mass-produced based on data",
      "provided to the Dominin, it became",
      "fixed as female. The clone was",
      "intended to utilize Luka's ability",
      "to interfere with other dimensions,",
      "but it fell far short of the",
      "original's power. To compensate,",
      "multiple brains were operated in",
      "parallel, aiming to approach the",
      "original's strength through mass",
      "production. However, Lucifina's",
      "attack left the laboratory in ruins.",
      "At that time, all existing Doppels",
      "were said to have been taken to",
      "the moon.",
      "",
      "The Doppel, now fixed as female,",
      "retains some of Luka's traits but",
      "lacks the original's full potential.",
      "Despite this, the mass-produced",
      "clones were designed to function",
      "as a collective, their parallel",
      "brains working in unison to mimic",
      "Luka's abilities. The destruction",
      "of the lab and the disappearance",
      "of the Doppels to the moon remain",
      "a mystery, leaving their ultimate",
      "fate uncertain.",
      "",
      "Artist: frfr",
    ],
    615 => [
      "A female warrior believed to be",
      "a commander-class among the",
      "Moon People. She shares the",
      "same face as others of her kind,",
      "but her hairstyle and armaments",
      "differ, suggesting a higher rank",
      "than the common soldiers. Her",
      "combat prowess far surpasses",
      "that of regular troops, to the",
      "point where even mid-tier angels",
      "stand no chance against her.",
      "Additionally, her tactical acumen",
      "and decision-making skills are",
      "exceptional, which is why, despite",
      "numerous assaults, not a single",
      "Moon Person has ever been",
      "captured.",
      "",
      "This individual, called Luka",
      "Kyrie, boasts masterful spear",
      "techniques and possesses qualities",
      "akin to a war maiden. Among the",
      "four commander-class individuals,",
      "she is reported to be the most",
      "composed and level-headed, making",
      "her an extremely formidable foe,",
      "according to field reports.",
      "",
      "Artist: frfr",
    ],
    616 => [
      "A chimera monster created through",
      "Promestein's genetic engineering",
      "technology. Born as a prototype",
      "for capture purposes, it remained",
      "largely unnoticed within the",
      "Alliance of Wisdom. However, when",
      "designs for various chimera",
      "monsters were handed over to",
      "the Angelic Dominion, mass production",
      "was immediately approved. Large-scale",
      "manufacturing began at the Dominion's",
      "research facilities, and",
      "many were sent to various frontier",
      "regions. Due to harsh working",
      "conditions, second-class citizens",
      "often fled, making this chimera type",
      "highly valued for its ability to",
      "automatically capture targets.",
      "",
      "However, the Chimera Prison itself,",
      "exhausted from repeated escapee",
      "capture missions, began to flee in",
      "large numbers. Many became feral,",
      "and this has now become a societal",
      "issue. As a result, the official",
      "who approved the mass production",
      "plans for Chimera Prison was",
      "demoted to laborer, sent to the",
      "frontier, and subsequently fled,",
      "disappearing without a trace.",
      "",
      "Artist: Setouchi",
    ],
    617 => [
      "A artificial pseudo-spirit created",
      "through mechanical technology,",
      "endowed with the power to control",
      "the wind. She is stationed in the",
      "Forest of Spirits of the Natalia region,",
      "ruled by Raphaela, and tasked with",
      "managing the flow of the wind.",
      "Her abilities rival those of a Sylph,",
      "but maintaining her requires an",
      "enormous amount of spiritual energy.",
      "As a result, many second-class",
      "citizens and male political prisoners",
      "are brought to the Spirit Forest,",
      "where their energy is relinquished",
      "to Zylphe through intercourse.",
      "This fact is",
      "considered a top-secret in the Dominion.",
      "",
      "Though not cruel, she is highly",
      "voracious and often drains men until",
      "they are completely exhausted.",
      "She harbors dissatisfaction with",
      "being confined to the forest and",
      "longs to roam freely and unleash",
      "her winds upon the outside world.",
      "",
      "Artist: UN_DO",
    ],
    618 => [
      "A mutation born among the fairy tribe.",
      "Possessing natural sensitivity rivaling",
      "that of spirits, she can even manipulate",
      "weather and climate at will. Free-spirited",
      "and eccentric, she left her homeland,",
      "the fairy island, to wander endlessly,",
      "stirring up trouble wherever she goes.",
      "In the Angelic Dominion, most devotee citizens",
      "mistakenly believe fairies are the larval",
      "forms of angels. However, when her homeland",
      "faces crisis, she shows a proactive side,",
      "taking decisive action to protect it.",
      "",
      "True to her fairy nature, she loves mischief",
      "and often latches onto humans who catch her",
      "eye. Particularly, she has been observed",
      "repeatedly targeting timid men with relentless",
      "sexual pranks, showcasing her more malicious",
      "tendencies.",
      "",
      "Artist: UN_DO",
    ],
    619 => [
      "A monster that lurked hidden in the forest",
      "and underwent a sudden mutation. The cause",
      "of the mutation appears to be Chaos Erosion,",
      "though the details remain unclear. Originally,",
      "she seemed to be a mushroom girl, but her",
      "reason was lost, and her reproduction rate",
      "increased dramatically. Her physical abilities",
      "and the toxicity of her spores also improved",
      "significantly, making her an extremely dangerous",
      "entity. The angels have relentlessly carried",
      "out extermination operations, and in forests",
      "near inhabited areas, she has been completely",
      "eradicated. However, the fairy forest is",
      "vast, making complete extermination impossible,",
      "and a containment strategy has been adopted.",
      "",
      "She uses the bodies of living creatures as",
      "breeding grounds, proliferating explosively.",
      "Victims have their vitality drained completely,",
      "quickly withering away. If the host is male,",
      "she gathers around the groin, extracting",
      "sperm while the victim drifts into ecstasy,",
      "only to wither and perish in the end.",
      "",
      "Artist: frfr",
    ],
    620 => [
      "The Mycronid is said to be a collective",
      "entity formed by the gathering of",
      "individuals who have acquired a",
      "certain level of intelligence, though",
      "the specifics remain unclear. The",
      "female forms that overflow from the",
      "main body are highly variable, with",
      "intelligence levels ranging widely.",
      "Some individuals are even capable of",
      "normal conversation. The reason they",
      "can use Time Magic remains a mystery,",
      "but it is certain they possess a",
      "light degree of spacetime interference",
      "ability. They are highly voracious by",
      "nature, yet they never seem to leave",
      "their forest territory. At this level,",
      "the cost of extermination outweighs",
      "the benefits, so even angel soldiers",
      "avoid engaging with them, and strict",
      "geographical isolation from the Fairy",
      "Island is maintained.",
      "",
      "They attack indiscriminately, regardless",
      "of the species or gender of their prey,",
      "greedily assimilating them into their",
      "bodies. During this process, the prey",
      "is put into a euphoric state by spores,",
      "repeatedly experiencing ecstasy as they",
      "merge with the Matango. If the prey is",
      "male, it will result in the release of",
      "all their semen.",
      "",
      "Artist: Setouchi",
    ],
    621 => [
      "A monster that had been hiding",
      "in the forest underwent a sudden",
      "mutation. The cause of the mutation",
      "appears to be Chaos Erosion, but",
      "the details remain unclear. Parts",
      "of its genetic information match",
      "that of Little Bugs and Chimera",
      "Bugs, leading to speculation that",
      "there may have been a cellular",
      "leak. Its nature is similar to",
      "typical insect-type monsters, but",
      "its physical abilities have greatly",
      "improved. Its vitality has also",
      "significantly increased, making it",
      "a formidable opponent that even",
      "angel soldiers struggle to defeat.",
      "",
      "It attacks those who intrude into",
      "its territory, and if the intruder",
      "is male, it forcibly mates with",
      "them. Fortunately, its reproductive",
      "capacity is not as high as other",
      "insect-type monsters, so it does",
      "not seem to proliferate explosively.",
      "",
      "Artist: frfr",
    ],
    622 => [
      "A monster that had been hiding",
      "in the forest underwent a sudden",
      "mutation. The cause of the mutation",
      "appears to be chaotic erosion, but",
      "the details remain unclear. Though",
      "plant-based, part of its genetic",
      "information matches that of a",
      "Chimera Tongue, leading to speculation",
      "about cellular leakage. Its entire",
      "body is covered in tongue-like",
      "organs, which can extend and retract",
      "freely and seem to possess a sense",
      "of taste. It is said to capture",
      "prey by enveloping them with these",
      "tongues, licking them clean to savor",
      "their flavor.",
      "",
      "If the captured prey is male, its",
      "genitals are meticulously licked",
      "clean, regardless of species. Humans,",
      "being rare prey, are particularly",
      "prized, and a male captive may have",
      "his member licked for three days and",
      "nights. Most victims succumb to",
      "exhaustion, making caution essential.",
      "",
      "Artist: Setouchi",
    ],
    623 => [
      "A plant-type chimera monster created",
      "through Promestein's research. It",
      "was designed by manifesting",
      "carnivorous plant organs on a",
      "humanoid female body. The human",
      "will seems to have been overtaken",
      "by the parasitic plant, leaving",
      "no trace of its former self.",
      "Created alongside the Chimera",
      "Dryad, this variant exhibits",
      "extreme ferocity, preventing any",
      "plans for mass production. However,",
      "records indicate that a few test",
      "subjects escaped the laboratory",
      "and fled through a gate to the",
      "fairy island. (The responsible",
      "official became food for the",
      "chimera monsters.)",
      "",
      "Driven purely by hunger, it hunts",
      "and devours any living creature",
      "it encounters using its carnivorous",
      "plant organs. It preys on humans",
      "and angels alike, and if the victim",
      "is male, it extracts their essence",
      "as nourishment before digestion.",
      "Escape is impossible once captured.",
      "After being drained of all semen",
      "by her various plant organs, the",
      "victim is dissolved by her",
      "carnivorous plants, meeting a",
      "gruesome fate.",
      "",
      "Artist: Delphinus",
    ],
    624 => [
      "The Star-Guarding Butterfly, slumbering",
      "deep within the Fairy Islan. A being",
      "akin to the spirit of the world",
      "itself, harboring the immense energy",
      "of the world within her form. Even",
      "the Goddess Ilias could not remove",
      "or replace her, as her influence on",
      "the planet is far too great. Thus,",
      "she was sealed away in a restricted",
      "zone on the Fairy Isle, left to",
      "sleep eternally. To the fairies and",
      "elves, she is revered as a guardian",
      "deity of the stars.",
      "",
      "She remains in a chrysalis state,",
      "never emerging as an adult to soar",
      "the skies. While she contributes to",
      "the stability of nature and poses no",
      "harm, those who carelessly approach",
      "her chrysalis may be captured by",
      "tentacles and drained of their",
      "nutrients. This is not an act of",
      "malice from Cosmos, but rather a",
      "reflexive response. Cosmos herself",
      "simply continues to slumber in",
      "peaceful stillness.",
      "",
      "Artist: UN_DO",
    ],
    625 => [
      "The guardian deity butterfly Cosmos,",
      "once slumbering on the Fairy Island,",
      "mutated after absorbing chaotic",
      "energy. Though never meant to emerge",
      "as an adult, she underwent explosive",
      "growth, breaking free from her",
      "chrysalis. The planetary energy she",
      "harbored was further amplified by",
      "the corruption of Chaos, transforming",
      "her into an avatar of destruction",
      "with overwhelming power. No longer a",
      "guardian of the stars, she has",
      "become a monster driven by chaotic",
      "impulses, seeking only ruin.",
      "",
      "Artist: UN_DO",
    ],
    626 => [
      "A disguise playfully worn by the",
      "Black Alice of another world.",
      "Having accepted the invitation",
      "of the Black Alice who became",
      "the Third Goddess, she joined",
      "the ranks of her army, which",
      "exceeds a hundred thousand.",
      "She boasts the most formidable",
      "magical power among all past",
      "Monster Lords, wreaking",
      "devastation across the realms",
      "of the Dominion.",
      "",
      "Artist: Setouchi",
    ],
    627 => [
      "A disguise playfully worn by the",
      "Black Alice of another world.",
      "Having accepted the invitation",
      "of the Black Alice who became",
      "the Third Goddess, she joined",
      "the ranks of her army, which",
      "exceeds a hundred thousand.",
      "She boasts the most formidable",
      "magical power among all past",
      "Monster Lords, wreaking",
      "devastation across the realms",
      "of the Dominion.",
      "",
      "Artist: Setouchi",
    ],
    628 => [
      "A disguise playfully worn by the",
      "Black Alice of another world.",
      "Having accepted the invitation",
      "of the Black Alice who became",
      "the Third Goddess, she joined",
      "the ranks of her army, which",
      "exceeds a hundred thousand.",
      "She boasts the most formidable",
      "magical power among all past",
      "Monster Lords, wreaking",
      "devastation across the realms",
      "of the Dominion.",
      "",
      "Artist: Setouchi",
    ],
    629 => [
      "A disguise playfully worn by the",
      "Black Alice of another world.",
      "Having accepted the invitation",
      "of the Black Alice who became",
      "the Third Goddess, she joined",
      "the ranks of her army, which",
      "exceeds a hundred thousand.",
      "She boasts the most formidable",
      "magical power among all past",
      "Monster Lords, wreaking",
      "devastation across the realms",
      "of the Dominion.",
      "",
      "Artist: Setouchi",
    ],
    630 => [
      "A disguise playfully worn by the",
      "Black Alice of another world.",
      "Having accepted the invitation",
      "of the Black Alice who became",
      "the Third Goddess, she joined",
      "the ranks of her army, which",
      "exceeds a hundred thousand.",
      "She boasts the most formidable",
      "magical power among all past",
      "Monster Lords, wreaking",
      "devastation across the realms",
      "of the Dominion.",
      "",
      "Artist: Setouchi",
    ],
    631 => [
      "A disguise playfully worn by the",
      "Black Alice of another world.",
      "Having accepted the invitation",
      "of the Black Alice who became",
      "the Third Goddess, she joined",
      "the ranks of her army, which",
      "exceeds a hundred thousand.",
      "She boasts the most formidable",
      "magical power among all past",
      "Monster Lords, wreaking",
      "devastation across the realms",
      "of the Dominion.",
      "",
      "Artist: Setouchi",
    ],
    632 => [
      "A legendary evil dragon said to have",
      "existed in ancient times. She",
      "possesses the power of both snakes",
      "and dragons, and is said to wield",
      "immense strength. She is also",
      "highly skilled in magic, with a",
      "particular talent for mystic eyes.",
      "Revived after centuries by the",
      "power of Black Alice, she has",
      "returned to the world. However,",
      "as her peers, like Son Goku,",
      "desert her one by one, she seems",
      "to grow weary of following Black",
      "Alice's reckless acts of",
      "destruction.",
      "",
      "Her nature is cruel, and she",
      "delights in tormenting those she",
      "defeats. Using the snakes that are",
      "part of her body, she toys with",
      "male genitals, and her massive",
      "form also allows her to forcefully",
      "violate others with her own",
      "female anatomy. Should one engage",
      "with Azi Dahaka, they will",
      "experience overwhelming pleasure",
      "while being drained of all their",
      "essence within her depths. The",
      "grueling act will continue until",
      "the man is utterly exhausted.",
      "",
      "Artist: UN_DO",
    ],
    633 => [
      "A disguise playfully worn by the",
      "Black Alice of another world.",
      "Having accepted the invitation",
      "of the Black Alice who became",
      "the Third Goddess, she joined",
      "the ranks of her army, which",
      "exceeds a hundred thousand.",
      "She boasts the most formidable",
      "magical power among all past",
      "Monster Lords, wreaking",
      "devastation across the realms",
      "of the Dominion.",
      "",
      "Artist: Setouchi",
    ],
    634 => [
      "A disguise playfully worn by the",
      "Black Alice of another world.",
      "Having accepted the invitation",
      "of the Black Alice who became",
      "the Third Goddess, she joined",
      "the ranks of her army, which",
      "exceeds a hundred thousand.",
      "She boasts the most formidable",
      "magical power among all past",
      "Monster Lords, wreaking",
      "devastation across the realms",
      "of the Dominion.",
      "",
      "Artist: Setouchi",
    ],
    635 => [
      "A disguise playfully worn by the",
      "Black Alice of another world.",
      "Having accepted the invitation",
      "of the Black Alice who became",
      "the Third Goddess, she joined",
      "the ranks of her army, which",
      "exceeds a hundred thousand.",
      "She boasts the most formidable",
      "magical power among all past",
      "Monster Lords, wreaking",
      "devastation across the realms",
      "of the Dominion.",
      "",
      "Artist: Setouchi",
    ],
    636 => [
      "A mighty yoma from ancient times who",
      "was revered as an Earth Mother in",
      "Yamatai, she is the daughter of",
      "Izanami, who prides herself as being",
      "the ruler of the underworld.",
      "In addition to possessing tremendous",
      "magical power and a nimble body, she",
      "is also skilled in a variety of",
      "techniques, including dancing and",
      "singing. She was better known in",
      "Yamatai by her other name, Amaterasu,",
      "and became associated with the sun",
      "due to a mixing of legends, though",
      "she herself does not use that name,",
      "nor is she related to the sun.",
      "",
      "She has a cruel disposition and will",
      "not hesitate to kill men as she toys", 
      "with them for pleasure. She delights",
      "in vulgar acts such as seducing",
      "scores of men to ascend them all at",
      "once, and her sexual appetite is",
      "believed to be bottomless.",
      "However, she also has an exceptional",
      "attachment to her homeland of",
      "Yamatai, and she will sometimes",
      "protect the people of her land",
      "instead of oppressing them.",
      "",
      "She had received a seal that was no",
      "different from death, but has been",
      "revived through Black Alice's power.",
      "To repay her debt of gratitude to",
      "Black Alice, she is lending a hand to",
      "her schemes. Though she has grown",
      "weary of the seemingly pointless",
      "acts of destruction involved.",
      "",
      "Artist: xelvy",
    ],
    637 => [
      "A disguise playfully worn by the",
      "Black Alice of another world.",
      "Having accepted the invitation",
      "of the Black Alice who became",
      "the Third Goddess, she joined",
      "the ranks of her army, which",
      "exceeds a hundred thousand.",
      "She boasts the most formidable",
      "magical power among all past",
      "Monster Lords, wreaking",
      "devastation across the realms",
      "of the Dominion.",
      "",
      "Artist: Setouchi",
    ],
    638 => [
      "A disguise playfully worn by the",
      "Black Alice of another world.",
      "Having accepted the invitation",
      "of the Black Alice who became",
      "the Third Goddess, she joined",
      "the ranks of her army, which",
      "exceeds a hundred thousand.",
      "She boasts the most formidable",
      "magical power among all past",
      "Monster Lords, wreaking",
      "devastation across the realms",
      "of the Dominion.",
      "",
      "Artist: Setouchi",
    ],
    639 => [
      "A disguise playfully worn by the",
      "Black Alice of another world.",
      "Having accepted the invitation",
      "of the Black Alice who became",
      "the Third Goddess, she joined",
      "the ranks of her army, which",
      "exceeds a hundred thousand.",
      "She boasts the most formidable",
      "magical power among all past",
      "Monster Lords, wreaking",
      "devastation across the realms",
      "of the Dominion.",
      "",
      "Artist: Setouchi",
    ],
    640 => [
      "A disguise playfully worn by the",
      "Black Alice of another world.",
      "Having accepted the invitation",
      "of the Black Alice who became",
      "the Third Goddess, she joined",
      "the ranks of her army, which",
      "exceeds a hundred thousand.",
      "She boasts the most formidable",
      "magical power among all past",
      "Monster Lords, wreaking",
      "devastation across the realms",
      "of the Dominion.",
      "",
      "Artist: Setouchi",
    ],
    641 => [
      "A mighty yoma from ancient times who",
      "was revered as an Earth Mother in",
      "Yamatai, she is an undead who prides",
      "herself as being the ruler of the",
      "underworld. She possesses tremendous",
      "magical power, proficiency in",
      "various taoism skills, and extremely",
      "high physical ability. It is said",
      "that she had wreaked havoc upon the",
      "angel army during the Great Monster",
      "Wars two thousand years ago. Her",
      "daughter, Himiko, is also a famous",
      "Earth Mother of Yamatai.",
      "",
      "She is extremely ruthless and kills",
      "humans as if to increase her number",
      "of brethren in the underworld. If",
      "her opponent is a man, she is said",
      "to thoroughly ravish him and squeeze",
      "out all of his energy before",
      "ascending him to heaven. However,",
      "she also has an exceptional",
      "attachment to her homeland of",
      "Yamatai, and she will sometimes",
      "protect the people of her land",
      "instead of oppressing them.",
      "",
      "She was sealed away in the",
      "underworld, but has been revived",
      "through Black Alice's power. To",
      "repay her debt of gratitude to Black",
      "Alice, she is lending a hand to her",
      "schemes. While she aids",
      "Black Alice's plans to repay the debt,",
      "she has noticed that Black Alice's",
      "will is driven by a chaotic impulse",
      "for destruction, leading her to",
      "consider betraying her.",
      "",
      "Artist: Setouchi",
    ],
    642 => [
      "Black Alice from the singularity",
      "world. A being that could be called",
      "a mutation, possessing the unique",
      "trait of unleashing her full power",
      "even in her first form. Her body is",
      "protected by a dress of slimy flesh",
      "and tentacles, making it impossible",
      "to harm her with ordinary strength.",
      "Her magical power is also unmatched,",
      "said to rival the full might of her",
      "third form. During the Heavenly",
      "Invasion War, she wreaked havoc,",
      "ensnaring and dissolving countless",
      "angels and civilians within her",
      "dress, devouring them in ecstasy.",
      "",
      "Artist: Setouchi",
    ],
    643 => [
      "A disguise playfully worn by the",
      "Black Alice of another world.",
      "Having accepted the invitation",
      "of the Black Alice who became",
      "the Third Goddess, she joined",
      "the ranks of her army, which",
      "exceeds a hundred thousand.",
      "She boasts the most formidable",
      "magical power among all past",
      "Monster Lords, wreaking",
      "devastation across the realms",
      "of the Dominion.",
      "",
      "Artist: Setouchi",
    ],
    644 => [
      "A disguise playfully worn by the",
      "Black Alice of another world.",
      "Having accepted the invitation",
      "of the Black Alice who became",
      "the Third Goddess, she joined",
      "the ranks of her army, which",
      "exceeds a hundred thousand.",
      "She boasts the most formidable",
      "magical power among all past",
      "Monster Lords, wreaking",
      "devastation across the realms",
      "of the Dominion.",
      "",
      "Artist: Setouchi",
    ],
    645 => [
      "Heinrich, summoned from another world",
      "by Black Alice, appears to have had",
      "his will overwritten due to",
      "brainwashing. Though his sword",
      "skills remain undiminished, the",
      "strength born from his own will",
      "has been lost.",
      "",
      "Artist: xelvy",
    ],
    646 => [
      "Heinrich's soul, summoned from",
      "another world by Black Alice,",
      "appears to have had its will",
      "overwritten due to brainwashing.",
      "Though his swordsmanship remains",
      "unmatched, the strength born from",
      "his own will has been lost.",
      "",
      "Artist: frfr",
    ],
    647 => [
      "A hero who traveled across worlds",
      "as a Monster Lord Hunter, and the",
      "father of Luka. He possesses the",
      "ability to move between parallel",
      "worlds and has slain over a",
      "thousand Monster Lords.",
      "",
      "",
      "Artist: xelvy",
    ],
    648 => [
      "The eighth Monster Lord, who became",
      "The Third Goddess.",
      "Her inherent destructive tendencies",
      "were further accelerated by absorbing",
      "Chaos. She has now become a destructive",
      "Transcendent who revels in the ending of",
      "all parallel worlds.",
      "",
      "She wields both holy and dark powers",
      "simultaneously, possessing immense",
      "strength rivaling that of a Goddess. She is",
      "capable of annihilating entire worlds",
      "single-handedly, making her one of the",
      "greatest confirmed threats in existence.",
      "",
      "Artist: Setouchi",
    ],
    649 => [
      "A chimera monster of the highest",
      "caliber created by Promestein, and",
      "one of the Next Dolls. Designed as",
      "a combat force against Granberia,",
      "one of the Four Heavenly Knights",
      "of the Monster Lord's Army, she",
      "boasts overwhelming physical",
      "prowess. Through genetic-level",
      "enhancements, ultra-fast synaptic",
      "conduction, nanocarbon fiber",
      "reinforcement of muscle fibers,",
      "and metabolic overload via magic,",
      "she has undergone the ultimate",
      "physical enhancement, utilizing",
      "genetic engineering, mechanical",
      "engineering, and magical science.",
      "",
      "As a result, her combat abilities,",
      "such as strength, agility, and",
      "defense, have reached theoretical",
      "limits. She also has no noticeable",
      "weaknesses, with the only",
      "operational drawback being her",
      "exceptionally high food intake.",
      "",
      "However, maintaining such an",
      "ultimate physique places an",
      "enormous biological strain on her,",
      "and her usable lifespan is",
      "extremely short. It is estimated",
      "that she has only about five",
      "years left to live.",
      "",
      "Artist: Tomasu",
    ],
    650 => [
      "A chimera monster with an eerie form",
      "resembling countless strands of hair",
      "clustered together. It is created",
      "through a method akin to necromancy,",
      "where young women's hair is exposed",
      "to high concentrations of magical",
      "energy, and the souls of deceased",
      "women are attached to it. This was",
      "merely one project among many",
      "aimed at exploring various chimera",
      "monsters, and it seems no particularly",
      "useful data was obtained.",
      "",
      "That said, as a standalone combatant,",
      "it is highly capable. Its body,",
      "composed of ever-shifting clusters",
      "of hair, poses a significant threat",
      "to its enemies. Once ensnared by",
      "its resilient hair, even the strongest",
      "foe cannot escape. They are doomed",
      "to have their life force drained",
      "and their bodies absorbed entirely.",
      "",
      "It is named Yomotsu Shikome,",
      "after a type of demon, but this is",
      "merely a codename from the development",
      "project. It is unrelated to the",
      "Yomotsu Shikome demonic beings",
      "that inhabit the Yamatai region.",
      "",
      "Artist: frfr",
    ],
    651 => [
      "A mummy-type undead created by La Croix,",
      "assigned the role of a gatekeeper. Far from",
      "an ordinary mummy, her body is crafted from",
      "the stolen remains of the first princess",
      "of the Sabasa family, whose bloodline is",
      "strongly tied to the Sphinx. Possessing",
      "magical power and physical abilities",
      "beyond comparison to typical mummy girls,",
      "her intelligence is also far from low.",
      "However, she appears to have sworn absolute",
      "obedience to La Croix.",
      "",
      "The treatment of intruders she repels is",
      "left entirely to Ferme Sara's discretion.",
      "In the case of men, they are invariably",
      "violated for the purpose of extracting",
      "their essence. The noble corpse maintains",
      "a bewitching flesh vessel, immersing her",
      "male victims in ecstasy. The pitiful prey",
      "is forced to ejaculate repeatedly, soon",
      "reduced to a wretched, desiccated state.",
      "",
      "Artist: frfr",
    ],
    652 => [
      "A zombie created by La Croix, using",
      "the corpse of an angel as its base.",
      "This latest model boasts an",
      "extremely high level of completion,",
      "built upon research data from AD-5.",
      "Her physical abilities and vitality",
      "are remarkably high, far surpassing",
      "those of traditional zombies.",
      "",
      "However, her mind has lost its",
      "balance, leaving her in a constant",
      "state of lust. To satisfy her hunger",
      "and carnal desires, she relentlessly",
      "attacks men without hesitation.",
      "Those who fall prey to her are",
      "ruthlessly violated and subjected",
      "to cruel, torturous treatment,",
      "akin to being played with to death.",
      "",
      "With La Croix now gone, she wanders",
      "the abandoned research facility,",
      "bereft of its manager. On rare",
      "occasions when intruders appear,",
      "she attacks them, giving in to her",
      "instincts and turning them into prey.",
      "",
      "Artist: frfr",
    ],
    653 => [
      "A zombie created by La Croix, with",
      "a ferocious dragon from Gold's",
      "Volcano region as its base form.",
      "Her physical abilities far exceed",
      "those of her former life, granting",
      "her strength enough to overpower",
      "even high-ranking Yoma. Currently,",
      "she is stationed as a gatekeeper",
      "in the underground passages, where",
      "she devours prisoners attempting",
      "to escape (though few humans ever",
      "reach that far, as most are monsters).",
      "",
      "She can invert her stomach and",
      "expel it externally through her",
      "mouth. This trait is similar to",
      "certain creatures like frogs, and",
      "some starfish use this inverted",
      "stomach to envelop and consume prey.",
      "The Dragon Zombie Girl's inverted",
      "stomach takes on a feminine form,",
      "allowing her to ensnare and devour",
      "those who carelessly approach her.",
      "It functions like an anglerfish's",
      "lure, and anyone foolish enough to",
      "fall for it will inevitably become",
      "her next meal.",
      "",
      "Artist: UN_DO",
    ],
    654 => [
      "Developed as the first unit of",
      "Anti-Apoptosis combat machines,",
      "Sigrdrifa is an autonomous android.",
      "Equipped with the highest level of",
      "functionality and powerful armaments",
      "that technology allows, she boasts",
      "combat capabilities worthy of being",
      "called the ultimate mobile weapon.",
      "Her personality was intended to be",
      "brave and proactive, but it has",
      "become overly aggressive and",
      "overconfident. Despite her flawed",
      "personality, there is no doubt she",
      "is a formidable combat machine with",
      "overwhelming power. Nevertheless, she",
      "absolutely obeys the commands of her",
      "master, Promestein.",
      "",
      "Her groin is equipped with an",
      "artificial female organ capable of",
      "simulated intercourse. She views",
      "human men's lust for her as proof",
      "of her superiority as an android.",
      "She believes that her ability to",
      "engage in simulated intercourse with",
      "human men further demonstrates her",
      "excellence. She has developed a",
      "twisted sense of sadism in the act",
      "of extracting human sperm with her",
      "mechanical organ, finding pleasure",
      "in the dominance and control she",
      "exerts over men, reveling in the",
      "delight of her mechanical superiority.",
      "",
      "Artist: Nuppehof",
    ],
    655 => [
      "A clone of the hero Luka, created",
      "through Promestein's genetic",
      "engineering. Originally, the clone",
      "was androgynous, capable of freely",
      "changing gender at will. However,",
      "when mass-produced using data",
      "provided to the Angelic Dominion,",
      "the clones were fixed as females.",
      "They regard Lucifina, who rescued",
      "them, as their mother and have",
      "organized into an armed force on",
      "the moon. Interestingly, even as",
      "clones, they exhibit differences",
      "in personality and abilities.",
      "The stronger Doppels serve as",
      "elite guards, tasked with lunar",
      "security. These individuals are",
      "referred to as the Doppel Elites.",
      "",
      "Artist: frfr",
    ],
    656 => [
      "A giant worm resembling an antlion,",
      "appearing on the lunar surface.",
      "It is a monster that evolved",
      "explosively due to the reaction",
      "of magic energy and cosmic rays",
      "on microorganisms brought to",
      "the moon by the Doppels' migration.",
      "It is not a native space creature",
      "of the moon. Its exact prey on",
      "the lunar surface is unknown,",
      "but it is believed that there are",
      "other organisms evolved from",
      "microbes that serve as its food.",
      "It is also a natural enemy of",
      "the Doppels, who seem to repel",
      "it through group combat.",
      "",
      "Due to being influenced by magic",
      "energy, it has a strong craving",
      "for human semen. However, since",
      "this fluid does not exist on the",
      "moon, it has yet to experience",
      "its sweet taste. If it were to",
      "capture a human male, it would",
      "likely revel in the forbidden",
      "flavor and drain him of all his",
      "bodily fluids with delight.",
      "",
      "Artist: Setouchi",
    ],
    657 => [
      "One of the four Doppel commanders",
      "who possess exceptional power.",
      "With a nimble build, she excels",
      "in speed, yet is not lacking in",
      "strength, and is also skilled in",
      "swordsmanship. Her personality",
      "is carefree, but her flexible",
      "thinking often proves advantageous",
      "on the battlefield. In urban",
      "combat, she specializes in tactics",
      "that use agile movements to",
      "outmaneuver and annihilate enemies.",
      "",
      "These four are the leaders of",
      "the Doppels, and all of them",
      "regard Lucifina as their mother.",
      "Their loyalty is absolute, and",
      "they would not hesitate to give",
      "their lives for her sake.",
      "",
      "Artist: frfr",
    ],
    658 => [
      "One of the four Doppel commanders.",
      "Known for her steadfast and",
      "serious personality, often called",
      "the most rigid among her kind.",
      "Her swordsmanship is exceptional,",
      "and she excels in tactical insight.",
      "With a reliable ability to execute",
      "strategies, she enjoys deep trust",
      "from Lucifina.",
      "",
      "These four are the leaders of",
      "the Doppels, and all of them",
      "regard Lucifina as their mother.",
      "Their loyalty is absolute, and",
      "they would not hesitate to give",
      "their lives for her sake.",
      "",
      "Artist: frfr",
    ],
    659 => [
      "One of the four Doppel commanders.",
      "Despite her small stature, she",
      "boasts the greatest physical",
      "strength of the four. As a result,",
      "she is more skilled with blunt",
      "weapons like axes and clubs",
      "rather than swords. Though her",
      "thinking is simple, she excels in",
      "instinctive crisis detection and",
      "can surprisingly command groups",
      "with ease.",
      "",
      "These four are the leaders of",
      "the Doppels, and all of them",
      "regard Lucifina as their mother.",
      "Their loyalty is absolute, and",
      "they would not hesitate to give",
      "their lives for her sake.",
      "",
      "Artist: frfr",
    ],
    660 => [
      "One of the four Doppel commanders.",
      "She exhibits",
      "strong traits of a Valkyrie, excelling",
      "in spear combat and mastering the",
      "manipulation of holy energy. She can",
      "create aura wings, enabling her to",
      "fly at high speeds. Known for her",
      "calm and composed demeanor, she is",
      "also skilled in leadership, often",
      "chosen as the captain for highly",
      "dangerous missions. Her tactical",
      "prowess and reliability make her a",
      "respected figure among her peers.",
      "",
      "These four are the leaders of",
      "the Doppels, and all of them",
      "regard Lucifina as their mother.",
      "Their loyalty is absolute, and",
      "they would not hesitate to give",
      "their lives for her sake.",
      "",
      "Artist: frfr",
    ],
    661 => [
      "Lucifina, the Morning Star, hailed as",
      "the first of the primordial angels.",
      "Created as a fragment of Ilias,",
      "she boasts power unrivaled in Dominion,",
      "second only to her sister, Michaela.",
      "Her personality is equally chaotic,",
      "unleashing unpredictable calamities",
      "upon her enemies. The Fallen Goddess's",
      "army feared her like a demon, and",
      "some even took their own lives upon",
      "hearing of her arrival on the",
      "battlefield.",
      "",
      "Now, she resides on the Moon,",
      "leading the Doppel army. Should",
      "Lucifina take direct action, it is",
      "certain that calamity would follow.",
      "The forces of Dominion watch the",
      "Moon's movements with trepidation,",
      "fearing what her next move might be.",
      "",
      "Artist: frfr",
    ],
    662 => [
      "Belonging to the third rank of the",
      "nine angelic orders, she is a",
      "Throne Angel. As part of",
      "the Seven Archangels Raphaela's",
      "elite guard, many of them are",
      "stationed in San Ilia. Due to",
      "Raphaela's request, succubus genes",
      "have manifested in her, making",
      "her highly promiscuous. Her body",
      "is also extremely alluring,",
      "constantly stimulating the carnal",
      "desires of San Ilia's devout",
      "citizens. As a high-ranking angel,",
      "she possesses exceptional combat",
      "abilities and high intelligence.",
      "Many of her kind are involved in",
      "administrative duties under",
      "Raphaela's command.",
      "",
      "She is one of the most promiscuous",
      "angels, and her",
      "greatest pleasure is defiling",
      "devout believers. She delights in",
      "deliberately corrupting those she",
      "sets her sights on, drowning them",
      "in her seductive allure. Even her",
      "enemies are not spared, as they",
      "too fall victim to her insatiable",
      "lust and become prey to her",
      "voracious sexual appetite.",
      "",
      "Artist: Saiki",
    ],
    663 => [
      "Eggiel belongs to the third rank",
      "of the nine angelic Orders, known",
      "as the Throne. Her mission is to",
      "care for giant angelic eggs and",
      "fertilize them using the bodies of",
      "chosen humans. It is important to",
      "note that the eggs themselves are",
      "laid by other oviposition angels,",
      "and Eggiel's sole responsibility",
      "is to nurture the eggs and oversee",
      "their fertilization.",
      "",
      "Fertilization occurs by treating",
      "the entire human body as a single",
      "sperm, which is then absorbed into",
      "the egg's internal ovum. During",
      "this process, the human being",
      "fertilized experiences supreme",
      "pleasure, becoming immersed in",
      "ecstasy as they become the sacred",
      "nourishment for a holy life.",
      "Typically, only women are chosen",
      "for fertilization, and the angels",
      "born from this process are also",
      "female. However, in theory, it is",
      "possible to fertilize the egg with",
      "a male, in which case the resulting",
      "angel would be hermaphroditic.",
      "",
      "Artist: Delphinus",
    ],
    664 => [
      "A rare type of chimera monster",
      "that exists as two beings in one.",
      "During an experiment, a giant",
      "face beast was accidentally",
      "created. To control it, an",
      "artificial yokai was made as",
      "a controller and paired with it.",
      "The mounted yokai uses mental",
      "manipulation to control the giant",
      "face beast, allowing them to act",
      "almost as one. This enables them",
      "to rampage in near-perfect sync.",
      "However, the high cost of this",
      "creation prevented mass production.",
      "Only a few were made to serve as",
      "breach units during the invasion",
      "of the demon world. They now wait",
      "at the Mt.Saint Amos.",
      "",
      "The giant face beast is extremely",
      "voracious and will devour any",
      "living thing without discrimination.",
      "However, it has learned that the",
      "semen of human men is particularly",
      "delicious. When it captures a man,",
      "it will suck him dry within its",
      "mouth, extracting all his semen",
      "before swallowing him whole.",
      "",
      "Artist: Setouchi",
    ],
    665 => [
      "A chimera monster of the Roid type",
      "created by Promestein, and a",
      "simplified mass-produced version",
      "of Arc-En-Ciel, the leader of the",
      "Next Dolls. Among chimera monsters,",
      "she boasts exceptional combat",
      "abilities, though still falling",
      "short of Arc-En-Ciel's prowess. Due",
      "to the enormous costs involved in",
      "her production, the plan to mass-",
      "produce Arc-En-Ciel's simplified",
      "versions concluded with the",
      "completion of just one Knightroid.",
      "However, when her data reached",
      "the Dominion, her high performance",
      "caught attention, leading to a",
      "limited production as elite units",
      "for the impending invasion of",
      "the Monster Realm.",
      "",
      "Her primary weapon is a massive",
      "spear, but she also wields a",
      "bio-whip fused with her left hand",
      "with remarkable skill. Additionally,",
      "she is highly adept in sexual",
      "techniques, often using them to",
      "torment male warriors, as if testing",
      "their mental fortitude.",
      "",
      "Due to being crafted from many",
      "warrior-type monsters, she embodies",
      "a chivalric spirit, deeply admiring",
      "and respecting Arc-En-Ciel as her",
      "mentor. However, she also harbors",
      "a contradictory disdain for the weak,",
      "and it is said that those who fall",
      "to her are subjected to thorough",
      "humiliation and degradation.",
      "",
      "Artist: xelvy",
    ],
    666 => [
      "A chimera monster of the Roid type",
      "developed for assassinating key",
      "figures. Capable of eliminating",
      "even queen-class monsters, it is",
      "specialized in stealth, silence,",
      "and lethal striking power. To",
      "avoid detection by monsters that",
      "track body heat, it possesses a",
      "unique drive mechanism that",
      "prevents heat from escaping.",
      "However, this also means it must",
      "vent heat after prolonged",
      "activity, which is a notable",
      "drawback. In addition to normal",
      "genitalia, it also has a second,",
      "tentacle-like set of reproductive",
      "organs, though the purpose of",
      "this feature remains unclear.",
      "Despite its high cost and lack",
      "of mass production, its data",
      "reached the Dominion, where its",
      "exceptional performance caught",
      "attention. As a result, a small",
      "number were produced as elite",
      "units for the impending invasion",
      "of the Monster Realm.",
      "",
      "Its abilities in regular combat",
      "are also extremely high, and it",
      "has mastered various sexual",
      "techniques to disrupt opponents",
      "who excel in frontal combat.",
      "It is particularly harsh toward",
      "the weak, and men who lose in",
      "battle can expect merciless",
      "humiliation.",
      "",
      "Artist: xelvy",
    ],
    667 => [
      "Having absorbed an enormous amount",
      "of holy energy, Eden has transformed",
      "into her final form. Her physical",
      "and magical abilities have grown",
      "immensely, with her body now teeming",
      "with female forms, tentacles, and",
      "sacred trees that seem to overflow",
      "from her being. While she wields",
      "overwhelming power, her once calm",
      "mind has become more aggressive.",
      "Additionally, her energy consumption",
      "is extremely high. Though it may not",
      "be a full runaway state, there is no",
      "doubt that this form carries",
      "significant risks.",
      "",
      "Artist: Setouchi",
    ],
    668 => [
      "Belonging to the third rank of the",
      "nine angelic Orders, she is a",
      "Throne Angel. She holds",
      "a high-ranking position in the",
      "Dominion's administration, handling",
      "numerous classified matters as",
      "one of the highest officials.",
      "Though primarily a non-combatant,",
      "she possesses power befitting her",
      "third rank, far surpassing that",
      "of ordinary combat-specialized",
      "angels. Her workload is immense,",
      "and the weight of her duties",
      "causes significant stress, leaving",
      "her taciturn and pale. It is said",
      "that even Yuriel, who was lively",
      "and vibrant upon her appointment,",
      "becomes quiet and pale within a",
      "year of service.",
      "",
      "Combat is entirely outside her",
      "duties, but when she encounters",
      "enemies, she does not flee — she",
      "attacks. Proficient in radiating",
      "holy energy and magic, she will",
      "silence intruders with overwhelming",
      "force. Afterward, it is said that",
      "captured enemies face brutal",
      "humiliation and torment.",
      "",
      "Artist: Saiki",
    ],
    669 => [
      "Belonging to the third rank of the",
      "nine angelic orders, Melciel is a",
      "Throne angel. She possesses",
      "the ability to purify polluted air",
      "and water, making her an expert in",
      "healing. Due to her duties, she also",
      "has deep knowledge of pollution and",
      "toxins, and can easily manipulate",
      "elements to either decompose or",
      "create pollutants. She appears to",
      "be a relatively new angel, created",
      "to address the pollution caused by",
      "internal combustion engines, which",
      "began to be used in some areas as",
      "the Dominio's population grew.",
      "However, her production cost is",
      "extremely high, and supply has not",
      "kept up with demand, making cost",
      "reduction a significant challenge.",
      "",
      "Though combat is not her primary",
      "duty, her exceptionally high basic",
      "abilities make her a valuable asset",
      "in eliminating external threats.",
      "The highly viscous fluid that drips",
      "from her entire body can be used",
      "for both offense and defense.",
      "Additionally, she can absorb the",
      "essence of those she envelops and",
      "convert it into her own power.",
      "If the target is male, she will",
      "drain every last drop of his semen.",
      "",
      "Artist: Delphinus",
    ],
    670 => [
      "Sebasiel belongs to the third rank",
      "of the nine angelic orders, known",
      "as the Thrones. Designed",
      "for the impending Second Great",
      "Monster War, she was created",
      "with high close-combat abilities",
      "and low-cost mass production in",
      "mind. As a result, her production",
      "cost is roughly half that of other",
      "combat angels of the same rank.",
      "With the clash against the Dark",
      "Goddess approaching, her production",
      "is reportedly progressing at a",
      "furious pace.",
      "",
      "Her body itself is a sword,",
      "combining high durability with",
      "remarkable agility, making her",
      "combat capabilities exceptional.",
      "Additionally, her coordination",
      "skills are superb, allowing her",
      "to fully exploit the strengths of",
      "group combat, posing a significant",
      "threat to enemies. However, as a",
      "trade-off for her low cost, her",
      "ability to absorb holy energy from",
      "the atmosphere is lower compared",
      "to other angels, necessitating",
      "the consumption of meat to",
      "supplement her energy needs.",
      "Defeated enemies are absorbed",
      "into her body, becoming a part of",
      "her while experiencing pleasure.",
      "",
      "Artist: Delphinus",
    ],
    671 => [
      "A plan has emerged to mass-produce",
      "the highly costly Next Dolls in",
      "preparation for the impending",
      "war against the Dark Goddess Army.",
      "By replacing expensive materials",
      "with those derived from Chaos",
      "and applying Dominion's unique",
      "technology, they have achieved",
      "a reduction in costs. Their",
      "combat capabilities remain on par",
      "with the original Next Dolls,",
      "but the bodies, made with Chaos-",
      "derived materials, endure heavy",
      "strain and self-destruct within",
      "half a year. While such a short",
      "lifespan makes them unsuitable",
      "for standard military use, various",
      "plans are being explored, such as",
      "timing their completion to coincide",
      "with the final battle against the",
      "Monster Realm.",
      "",
      "Artist: Tomasu",
    ],
    672 => [
      "A plan has emerged to mass-produce",
      "the highly costly Next Dolls in",
      "preparation for the impending",
      "war against the Dark Goddess Army.",
      "By replacing expensive materials",
      "with those derived from Chaos",
      "and applying Dominion's unique",
      "technology, they have achieved",
      "a reduction in costs. Their",
      "combat capabilities remain on par",
      "with the original Next Dolls,",
      "but the bodies, made with Chaos-",
      "derived materials, endure heavy",
      "strain and self-destruct within",
      "half a year. While such a short",
      "lifespan makes them unsuitable",
      "for standard military use, various",
      "plans are being explored, such as",
      "timing their completion to coincide",
      "with the final battle against the",
      "Monster Realm.",
      "",
      "Artist: Tomasu",
    ],
    673 => [
      "A plan has emerged to mass-produce",
      "the highly costly Next Dolls in",
      "preparation for the impending",
      "war against the Dark Goddess Army.",
      "By replacing expensive materials",
      "with those derived from Chaos",
      "and applying Dominion's unique",
      "technology, they have achieved",
      "a reduction in costs. Their",
      "combat capabilities remain on par",
      "with the original Next Dolls,",
      "but the bodies, made with Chaos-",
      "derived materials, endure heavy",
      "strain and self-destruct within",
      "half a year. While such a short",
      "lifespan makes them unsuitable",
      "for standard military use, various",
      "plans are being explored, such as",
      "timing their completion to coincide",
      "with the final battle against the",
      "Monster Realm.",
      "",
      "Artist: Tomasu",
    ],
    674 => [
      "A plan has emerged to mass-produce",
      "the highly costly Next Dolls in",
      "preparation for the impending",
      "war against the Dark Goddess Army.",
      "By replacing expensive materials",
      "with those derived from Chaos",
      "and applying Dominion's unique",
      "technology, they have achieved",
      "a reduction in costs. Their",
      "combat capabilities remain on par",
      "with the original Next Dolls,",
      "but the bodies, made with Chaos-",
      "derived materials, endure heavy",
      "strain and self-destruct within",
      "half a year. While such a short",
      "lifespan makes them unsuitable",
      "for standard military use, various",
      "plans are being explored, such as",
      "timing their completion to coincide",
      "with the final battle against the",
      "Monster Realm.",
      "",
      "Artist: Tomasu",
    ],
    675 => [
      "A plan has emerged to mass-produce",
      "the highly costly Next Dolls in",
      "preparation for the impending",
      "war against the Dark Goddess Army.",
      "By replacing expensive materials",
      "with those derived from Chaos",
      "and applying Dominion's unique",
      "technology, they have achieved",
      "a reduction in costs. Their",
      "combat capabilities remain on par",
      "with the original Next Dolls,",
      "but the bodies, made with Chaos-",
      "derived materials, endure heavy",
      "strain and self-destruct within",
      "half a year. While such a short",
      "lifespan makes them unsuitable",
      "for standard military use, various",
      "plans are being explored, such as",
      "timing their completion to coincide",
      "with the final battle against the",
      "Monster Realm.",
      "",
      "Artist: Tomasu",
    ],
    676 => [
      "A Cherub belonging to the second",
      "rank of the nine angelic Orders.",
      "Blessed by Ilias, Whiteyel's power",
      "was greatly enhanced, leading to",
      "the creation of combat-oriented",
      "angels of the same type. Thus,",
      "Holmiel was born, a humanoid",
      "figure with no monstrous traits,",
      "equipped with the highest level of",
      "combat prowess in the Dominion.",
      "Excelling in hand-to-hand combat",
      "and wielding holy energy with",
      "mastery, she also possesses",
      "exceptional leadership skills.",
      "As a pure combat type, she is an",
      "incredibly reliable presence.",
      "Many of her kind serve as direct",
      "guards to the Goddess in the",
      "Ilias Temple, while some are",
      "promoted to division commanders.",
      "",
      "Compared to the serious and",
      "gentle Whiteyel, Holmiel is fierce",
      "and competitive in nature. She",
      "will thoroughly crush her enemies",
      "and deliver merciless punishment",
      "to those who oppose the Goddess.",
      "",
      "Artist: Alexi",
    ],
    677 => [
      "Belonging to the third rank of the",
      "nine angelic orders, Aptiel is a",
      "Throne-class angel. In",
      "preparation for the impending",
      "Second Great Monster War,",
      "she was experimentally developed",
      "using Chaos-based materials. While",
      "her base abilities are exceptionally",
      "high, and her combat performance",
      "as a battle-type angel is impeccable,",
      "her unstable personality and tendency",
      "to go berserk make her a risky asset.",
      "Originally intended as a prototype",
      "with no plans for mass production,",
      "she spontaneously multiplied, leading",
      "to a significant number of her kind.",
      "Though incapable of handling complex",
      "tasks, she is deployed as a defensive",
      "force at the Ilias Temple, where she",
      "is left to roam freely, attacking any",
      "unregistered individuals who approach.",
      "",
      "When she detects an unregistered",
      "intruder, she incapacitates them and",
      "absorbs them into her body. The",
      "unfortunate prey is engulfed in a",
      "whirlpool of chaos, seemingly lost",
      "in ecstasy as they are consumed.",
      "It is said that she sometimes attacks",
      "even registered angels, despite their",
      "official clearance.",
      "",
      "Artist: frfr",
    ],
    678 => [
      "Belonging to the third rank of the",
      "nine angelic orders, Clionera is",
      "a Throne angel. In preparation",
      "for the impending Second Great",
      "Monster War, a plan emerged",
      "to mass-produce low-cost combat",
      "angels based on existing",
      "creatures. Several prototypes",
      "were designed, but the beast-type",
      "candidate, initially favored,",
      "was ultimately dropped due to",
      "high costs. Insect-types were",
      "also dismissed for their low",
      "intelligence and lack of",
      "flexibility. Surprisingly, the",
      "Clione-type angel demonstrated",
      "exceptional performance. With",
      "high physical and magical",
      "abilities, and a quiet yet",
      "obedient nature, it proved to",
      "be an excellent combat asset.",
      "Production began, but the",
      "outbreak of the Second Great",
      "Monster War came sooner than",
      "expected, leaving only the",
      "Ilias Temple equipped in time.",
      "",
      "Despite her silence, Clionera",
      "is highly voracious, often",
      "devouring her targets even",
      "during capture missions—a flaw",
      "in her otherwise perfect design.",
      "Like the Clione she is based on,",
      "she extends a buccal cone from",
      "her head to swallow enemies",
      "whole. Her prey is digested",
      "within her body while",
      "experiencing ultimate pleasure.",
      "",
      "Artist: Mizukichi",
    ],
    679 => [
      "Roseniel, a Cherub belonging to",
      "the second rank of the nine",
      "angelic Orders. As Chaos began",
      "to encroach upon various parts",
      "of the heavens, Goddess Ilias",
      "halted time around the affected",
      "areas to prevent further spread.",
      "To support this mission, she",
      "developed a new type of angel.",
      "Thus, Roseniel, a supreme angel",
      "adept at manipulating time, was",
      "created. She possesses time",
      "manipulation abilities far",
      "exceeding those of conventional",
      "angels and is expected to play",
      "a key role in halting the chaos.",
      "However, Roseniel's creation is",
      "merely a stopgap measure, and",
      "it is clear that it only buys",
      "a little time. She gets along",
      "well with Cherub Cubeiel, who",
      "was created for the same purpose,",
      "but her nature is too different",
      "from other angels, leaving her",
      "with almost no interaction.",
      "",
      "Due to her duties, she remains",
      "on standby at the Ilias Temple.",
      "If enemies were to invade the",
      "temple, Roseniel would inevitably",
      "be tasked with intercepting them.",
      "Though not originally a combatant,",
      "her ability to manipulate time",
      "would undoubtedly make her a",
      "formidable force in battle.",
      "",
      "Artist: Delphinus",
    ],
    680 => [
      "A Cherub belonging to the",
      "second rank of the nine angelic",
      "Orders. As Chaos began to spread",
      "across various regions of the Dominion,",
      "Goddess Ilias halted its expansion",
      "by freezing time around the",
      "affected areas. To further support",
      "this mission, she embarked on",
      "creating a new type of angel.",
      "Thus, Cubeiel, the highest-ranking",
      "angel with exceptional spatial",
      "manipulation abilities, was born.",
      "",
      "Cubeiel possesses spatial control",
      "capabilities far surpassing those",
      "of traditional angels, and she is",
      "expected to play a key role in",
      "halting future Chaos incursions.",
      "However, her creation is merely a",
      "stopgap measure, and it is clear",
      "that it only buys a little time.",
      "",
      "She gets along well with Rosniel,",
      "another Cherub created for the",
      "same purpose, but her nature is",
      "too different from other angels,",
      "resulting in little interaction.",
      "",
      "Due to her duties, she remains on",
      "standby at the Ilias Temple at",
      "all times. Should enemies ever",
      "reach the temple, Cubeiel would",
      "inevitably be tasked with",
      "intercepting them. Although not",
      "originally a combatant, her",
      "ability to manipulate space would",
      "undoubtedly make her a formidable",
      "force in battle.",
      "",
      "Artist: Delphinus",
    ],
    681 => [
      "A Cherub belonging to the",
      "second rank of the nine angelic",
      "Orders. She has no specific duties",
      "and is deployed as a reserve force",
      "when cases arise that other angels",
      "cannot handle. She sees humans and",
      "monsters as nothing more than dust",
      "and looks down on all non-angelic",
      "beings, standing out even among",
      "other angels for her exceptional",
      "cruelty.",
      "",
      "Her power surpasses human",
      "understanding, and her mere descent",
      "to the earthly realm causes her",
      "body to erode the surrounding",
      "space. When dealing with enemies",
      "of the gods, she can swallow",
      "thousands of humans and monsters",
      "alive with her worm-like body.",
      "Those sinners who are consumed",
      "face unspeakable humiliation and",
      "are ultimately tormented to death.",
      "Her female form is also a mass of",
      "worms, with every worm being part",
      "of her true body, making her a",
      "being of grotesque and alien form.",
      "",
      "Artist: Delphinus",
    ],
    682 => [
      "A pseudo-spirit created for the purpose",
      "of stabilizing nature. However, due",
      "to its inherently immense magical",
      "power, a mass-production plan was",
      "proposed as a future military asset",
      "in anticipation of the Second Great",
      "Monster War. As a result, a trial",
      "batch of mass-produced types was",
      "created, but the production costs",
      "exceeded expectations. Ultimately,",
      "only a small number were made",
      "before the plan was abandoned.",
      "",
      "The few mass-produced pseudo-spirits",
      "created this way were deployed to",
      "the Ilias Temple, the most crucial",
      "stronghold in the Dominion. Not only",
      "are their production costs high,",
      "but their operational costs are",
      "also significant, requiring vast",
      "amounts of energy to function.",
      "Fortunately, in the Dominion,",
      "sinners are as good as free meal and",
      "exist in endless supply, so it is",
      "believed there will be no issues",
      "for the foreseeable future.",
      "",
      "Artist: UN_DO",
    ],
    683 => [
      "A pseudo-spirit created for the purpose",
      "of stabilizing nature. However, due",
      "to its inherently immense magical",
      "power, a mass-production plan was",
      "proposed as a future military asset",
      "in anticipation of the Second Great",
      "Monster War. As a result, a trial",
      "batch of mass-produced types was",
      "created, but the production costs",
      "exceeded expectations. Ultimately,",
      "only a small number were made",
      "before the plan was abandoned.",
      "",
      "The few mass-produced pseudo-spirits",
      "created this way were deployed to",
      "the Ilias Temple, the most crucial",
      "stronghold in the Dominion. Not only",
      "are their production costs high,",
      "but their operational costs are",
      "also significant, requiring vast",
      "amounts of energy to function.",
      "Fortunately, in the Dominion,",
      "sinners are as good as free meal and",
      "exist in endless supply, so it is",
      "believed there will be no issues",
      "for the foreseeable future.",
      "",
      "Artist: UN_DO",
    ],
    684 => [
      "A pseudo-spirit created for the purpose",
      "of stabilizing nature. However, due",
      "to its inherently immense magical",
      "power, a mass-production plan was",
      "proposed as a future military asset",
      "in anticipation of the Second Great",
      "Monster War. As a result, a trial",
      "batch of mass-produced types was",
      "created, but the production costs",
      "exceeded expectations. Ultimately,",
      "only a small number were made",
      "before the plan was abandoned.",
      "",
      "The few mass-produced pseudo-spirits",
      "created this way were deployed to",
      "the Ilias Temple, the most crucial",
      "stronghold in the Dominion. Not only",
      "are their production costs high,",
      "but their operational costs are",
      "also significant, requiring vast",
      "amounts of energy to function.",
      "Fortunately, in the Dominion,",
      "sinners are as good as free meal and",
      "exist in endless supply, so it is",
      "believed there will be no issues",
      "for the foreseeable future.",
      "",
      "Artist: UN_DO",
    ],
    685 => [
      "A pseudo-spirit created for the purpose",
      "of stabilizing nature. However, due",
      "to its inherently immense magical",
      "power, a mass-production plan was",
      "proposed as a future military asset",
      "in anticipation of the Second Great",
      "Monster War. As a result, a trial",
      "batch of mass-produced types was",
      "created, but the production costs",
      "exceeded expectations. Ultimately,",
      "only a small number were made",
      "before the plan was abandoned.",
      "",
      "The few mass-produced pseudo-spirits",
      "created this way were deployed to",
      "the Ilias Temple, the most crucial",
      "stronghold in the Dominion. Not only",
      "are their production costs high,",
      "but their operational costs are",
      "also significant, requiring vast",
      "amounts of energy to function.",
      "Fortunately, in the Dominion,",
      "sinners are as good as free meal and",
      "exist in endless supply, so it is",
      "believed there will be no issues",
      "for the foreseeable future.",
      "",
      "Artist: UN_DO",
    ],
    686 => [
      "The primordial angel, hailed as the",
      "leader of the Heavenly Army. Created",
      "as a fragment of Ilias, she is",
      "revered and feared as the strongest",
      "combatant in the Dominion. Her skill",
      "in concentrating holy energy",
      "into her technique,",
      "'Sword of Heavenly Army',",
      "is renowned as the heavens'",
      "most powerful secret art, known",
      "even to children.",
      "",
      "Standing at the apex of the Angelic",
      "Army, she has commanded all forces",
      "since the age of myth. Her strategic",
      "insight is said to surpass even",
      "Goddess Ilias, and she tirelessly",
      "studies tactics in anticipation of",
      "battles against the Dark Goddess Army.",
      "",
      "Having long safeguarded the peace",
      "of the heavens, she is truly the",
      "strongest of angels.",
      "",
      "Artist: frfr",
    ],
    687 => [
      "A holy existence paired with the Dark",
      "Goddess Alipheese. The sacred",
      "energy circulating in the world",
      "formed its own ego, reigning over",
      "the world as a higher consciousness.",
      "Unlike the Ilias of the true history,",
      "she achieved complete victory over",
      "the Dark Goddess born from darkness",
      "energy. Afterward, she restored the",
      "devastated land and eventually",
      "succeeded in transforming the entire",
      "world into a heavenly realm. However,",
      "this action greatly deviated from the",
      "main history, and",
      "the establised Angelic Dominion",
      "faced the erosion of Chaos.",
      "",
      "Artist: Akazawa RED",
    ],
    688 => [
      "The chaotic form of Goddess Ilias,",
      "who absorbed the spirit of Chaos,",
      "Nuruko, and achieved the fusion",
      "of Holy and Dark energies.",
      "She harmonized the Holy and",
      "Dark energies within her body,",
      "gaining immense power. However,",
      "the will of Chaos has also mixed",
      "into her mind, driving her with",
      "a desire for destruction. It is",
      "only a matter of time before",
      "she loses her rationality, and",
      "she will undoubtedly become a",
      "catastrophic force destined to",
      "bring ruin to the world.",
      "",
      "Artist: Akazawa RED",
    ],
    689 => [
      "The chaotic form of Goddess Ilias,",
      "who absorbed the spirit of Chaos,",
      "Nuruko, and achieved the fusion",
      "of Holy and Dark energies.",
      "She harmonized the Holy and",
      "Dark energies within her body,",
      "gaining immense power. However,",
      "the will of Chaos has also mixed",
      "into her mind, driving her with",
      "a desire for destruction. It is",
      "only a matter of time before",
      "she loses her rationality, and",
      "she will undoubtedly become a",
      "catastrophic force destined to",
      "bring ruin to the world.",
      "",
      "Artist: Akazawa RED",
    ],
    690 => [
      "Raphaela, having gained the power of",
      "a magical girl, now fully unleashes",
      "her magical abilities. Cursed and",
      "consumed by hatred, her appearance",
      "has become so sinister that she can",
      "now be called a witch. Her form is",
      "drenched in malice and darkness,",
      "a far cry from her former self.",
      "",
      "Artist: xelvy",
    ],
    691 => [
      "A group of werewolves that are an ancient tribe in the demon world. very ferocious",
      "However, his intelligence is not low and he is good at fighting in groups.",
      "shall be. Excellent AGI as well as ATK of claws and fangs",
      "and its combat ability is extremely high. In the northern land",
      "They live in tribes, and are separated from humans and lower-level demon beast tribes.",
      "It seems that it has also become an object of worship.",
      "",
      "They don't fight much with other monsters and share the same habitat.",
      "A group of combing Garchimacera and Great Orcs",
      "We maintain a good relationship with both. Especially Garchimacera",
      "They also frequently engage in commercial transactions such as selling meat and skin.",
      "are.",
      "However, he shows hostility toward unknown intruders and ropes them in.",
      "Actively attacks anyone who violates the tension. The enemy is a young man",
      "If he does, he is brought back to the herd and becomes a shared husband.",
      "If you are taken away by a group of Fenrir, you will end up in a group.",
      "She is raped one after another and forced to inseminate everyone in the herd.",
      "It will be controlled. A man who has finished having children,",
      "As a co-father to all the next generation of daughters, it is",
      "It seems like they are being cared for with great care.",
      "",
      "Artist: Nonhuman Modoki",
    ],
    692 => [
      "Among the demons that inhabit the demon world, it is quite standard.",
      "A terrible race. He moves quickly and is good at magic.",
      "Nono's physical abilities seem to be average. intelligence is high",
      "Easy to adapt to city life. He makes a living as a peddler.",
      "It is said that there are many individuals. He is also a moneylender in the city.",
      "There are also some who are",
      "It doesn't look good.",
      "",
      "The huge ejaculation hole in the tail is also one of its characteristics, and it is said to have malicious intent.",
      "The individual attacks the man and squeezes out his sperm.",
      "Some of them are vicious and suck up the semen until the other person runs out of energy.",
      "There are also prey animals, which is against the rules among monsters.",
      "It is said that they also steal the money. This is also all races",
      "This seems to be one of the reasons people dislike their bodies.",
      "",
      "Artist: Setouchi",
    ],
    693 => [
      "A subspecies of orc with an extremely strong body. the",
      "Its strength is also incomparable to that of normal orcs, and its fighting ability is",
      "is extremely high. Utilizing its innate strength, the demon world",
      "They seem to be working as mercenaries in various places. bad temper",
      "Although he is ferocious, he seems to be honorable when it comes to contracts. However, employment",
      "If the employer violates the contract, we will retaliate mercilessly.",
      "They say they are a terrible bunch.",
      "",
      "She has an extremely strong sexual desire and spends the money she earns on male prostitutes.",
      "Often. Shake your hips violently in cowgirl position",
      "I like sex, and I was raped by my girlfriend, but in the end,",
      "You will hardly be able to stand on your feet. relative as an enemy",
      "If you do so and lose, you will be raped so violently that your life will be in danger.",
      "It is said that it will be done.",
      "",
      "Artist: Makiya",
    ],
    694 => [
      "An intermediate succubus that lives throughout the demon world. physical ability",
      "They are tall, and many of them specialize in spears. of course",
      "He is also good at Sexcraft SKL and can easily charm not only men but also women.",
      "It is called putting away. Although they have a hedonistic personality, many",
      "She respects Minagi, the ancestor of demons, and is a succubus.",
      "The standards seem to be complied with. their",
      "In between, it is possible to live in San Ilia, the capital of infatuated demons.",
      "It is said to be the greatest honor.",
      "",
      "When raping a man, be gentle and gentle so as not to cause fear or pain.",
      "It will be done properly. Of course, squeezing to death",
      "Instead, extract semen according to the succubus norms preached by Minagi.",
      "It seems to do. However, individuals far from the center",
      "Not just those who engage in human trafficking, but also those who casually engage in human trafficking.",
      "exist. Raped by such an outlaw demon",
      "Once it's done, it's rare for it to be squeezed to death.",
      "It would be nice.",
      "",
      "Artist: Raichi",
    ],
    695 => [
      "An intermediate succubus that lives throughout the demon world. Very magical power",
      "Many of them are good at magic. rice cake",
      "He is also good at Sexcraft SKL and easily charms both men and women.",
      "It is said that he will do it. More frivolous and mean than Lancubus.",
      "Although there is a tendency to have a bad attitude, many people still respect Minagi.",
      "I love you, and I am far removed from the norm as a succubus.",
      "He doesn't seem to act out of place. between them",
      "The maximum number of people living in San Ilia, the capital of lewd demons is",
      "It is said to be an honor.",
      "",
      "Even when raping a man, he may play with words, but it is dangerous.",
      "I don't blame you. Of course, squeezing to death",
      "Instead, extract semen according to the succubus norms preached by Minagi.",
      "It seems to do. However, individuals far from the center",
      "Not just those who engage in human trafficking, but also those who casually engage in human trafficking.",
      "exist. Raped by such an outlaw demon",
      "Once done, it is rare for people to be laughed at and killed.",
      "Probably not.",
      "",
      "Artist: Raichi",
    ],
    696 => [
      "The queen who rules the succubus village. Originally a wandering low-class slut",
      "It seems that it was a devil, but the dissatisfaction that was shouted with momentum,",
      "The vandalism that was done as a distraction caused dissatisfaction with the village system.",
      "Receives the support of the succubi who possess it. Suppress as it is",
      "She was celebrated as a symbol of liberation and became the queen.",
      "I'll get a job. In the name of liberation from oppression, village preparations",
      "The economy was thrown into chaos as they distributed their savings to the villagers. As a new business",
      "They started buying and selling slaves, but the trade was rejected from a decent economic zone.",
      "The economy has become even more dire due to the end of financial aid. more people",
      "This will lead to mental devastation and the destruction of decent industries.",
      "It will be. As his incompetence as a ruler was exposed,",
      "He surrounded himself with mercenaries and began suppressing his critics. the current",
      "Even her followers, who earn their money from the slave trade,",
      "Seeing that the rule will not last long, they begin preparations to escape the difficulties.",
      "It is said that there is.",
      "",
      "He works on the village's stockpiles and indulges in luxury, and the man's spirit changes every day.",
      "Because he smoked so much, he is comparable to a high-class nympho.",
      "It seems that he has acquired magical powers. How useless is the inside?",
      "Even if she is a lewd demon, a human male will resist her Sexcraft SKL.",
      "is impossible.",
      "",
      "Artist: kupala",
    ],
    697 => [
      "A half-man, half-beast magician who specializes in dark magic.",
      "He is devoted to researching magic, and has a magic system unique to his family.",
      "It seems that he inherited it. Amount of knowledge about magic",
      "Many are famous in the demon world as magic researchers.",
      "There are also quite a few. On the other hand, despite being a monster type",
      "His movements are slow and his physical abilities are not very high.",
      "",
      "Although she always has a calm and collected demeanor, she is very sensitive to male spirits.",
      "greedy. An accident that dangerously squeezes out the essence.",
      "It is said that there is no shortage of them. much less hostile",
      "If it's my partner, I'll squeeze out all my energy without any hesitation.",
      "It will come.",
      "",
      "Artist: Setouchi",
    ],
    698 => [
      "Originally it was a monster born in Yamatai, but in recent years it has become",
      "Many of them have expanded to foreign countries. For some reason, I was dyed in Western clothes, and Les",
      "He has learned Unarmed from Ipia. Among the person",
      "Chivalry and bushido are intertwined, and he is seen as a strong person.",
      "It looks like he's going to challenge me to a duel. Its AGI is extraordinary",
      "The number of Rapier SKL that are performed from the lunge are extraordinary.",
      "Always strong.",
      "",
      "If the enemy you defeated was a man, calm down his burning body.",
      "Start insulting her as much as possible. Never have a cruel personality",
      "However, he suddenly developed a fever that weakened the man and brought him to the point of death.",
      "It is said that there are many cases where it is pushed to the limit.",
      "",
      "Artist: Setouchi",
    ],
    699 => [
      "A mid-level plant-based demon that lives in the demon world. Many of them are",
      "Near Grangold, ruled by Kanon, one of the six ancestors.",
      "Looks like he lives nearby. Its power is common Allura",
      "It is taller than Une, and uses ivy and pollen to toy with its enemies.",
      "Also, as a plant-type person, they are very good at recovery SKL.",
      "It seems so. He has a hedonistic personality and is reluctant to do evil things.",
      "There is no. In particular, the plant tribe of Grangold is under the protection of Kanon.",
      "The tyranny and outrageous behavior of such people is unacceptable.",
      "It has reached an unstoppable level.",
      "",
      "She loves the semen of human men, and captures the semen of men.",
      "It is often squeezed until it dries up. Kanon's command",
      "Accordingly, openly attacking humans in large cities is prohibited.",
      "However, behind the scenes, a considerable number of people are attacked and the darkness",
      "It seems that he is buried in",
      "",
      "Artist: Raichi",
    ],
    700 => [
      "A mid-level plant monster that lives in the demon world, and is a carnivorous plant monster.",
      "Many elements are expressed in the body. carnivorous plant organs",
      "'s ATK is very high, compared to normal Alraune.",
      "He seems to have excellent fighting ability. Ding like a lady",
      "He hides it with a polite and polite attitude, but his true nature is",
      "Extremely cruel. He has a selfish and hedonistic personality,",
      "Humans only think of things as toys to entertain themselves.",
      "",
      "Securing a hidden hunting ground even in the city",
      "They deliberately bring in men and use them as prey. crying",
      "I ejaculated repeatedly while screaming and watched as I melted.",
      "It seems like protecting them is the greatest joy. basically in the city",
      "The act of squeezing a man to death is prohibited by Kanon.",
      "However, usually by offering money or goods or the captured man,",
      "It is said that he is being given an eyeful.",
      "",
      "Artist: Raichi",
    ],
    701 => [
      "A high-class plant-based demon that lives in the demon world, and the ancestor of the plant tribe.",
      "The clan that was created by Kanon in the earliest period. Yo",
      "He has deep Rikanon blood and is proud of his noble lineage. That power also",
      "It is far superior to other Alraunes. other monsters",
      "They look down on humans as hybrids, and treat humans as food or toys.",
      "It only recognizes its value as Selfish with an arrogant attitude",
      "Acts selfishly and dominates the plant race with a face of ownership.",
      "Even Grangold, who is a member of the",
      "Ru.",
      "",
      "Charming men, raping them and killing them has become a daily routine.",
      "In Grangold, Ma hides the promiscuity of the Noble Roses.",
      "Even the new edition has been arranged. Sudden transfer, other",
      "The whole family flees at night, chased by debts as they move to the town.",
      "In Grangold, there are a lot of people coming and going,",
      "Much of this is said to be a cover-up by the ruling class.",
      "How many inhabitants feed on the Noble Roses and other plant tribes?",
      "No one knows exactly whether it became an eclipse.",
      "",
      "Artist: Raichi",
    ],
    702 => [
      "A giant monster that is said to be a mutation among the plant family.",
      "Tar. Possesses an abnormal level of vitality and extremely strong physical abilities.",
      "Very expensive. It also purifies powerful toxins in the body and breathes",
      "and spread it to the surrounding area. with a strong odor",
      "This breath is considered more dangerous than any poisonous gas.",
      "Ru. A strange odor always wafts from his body, and he avoids other monsters.",
      "Looks like he's being kicked. However, his fighting ability is overwhelming.",
      "Yes, someone who serves as Kanon's bodyguard and the guard of Jashin Castle.",
      "It is said that there are many.",
      "",
      "However, the foul odor emitted by the Malboro girl is a strong pheromonal.",
      "It also contains odors, so if a man smells it,",
      "Although she is writhing in agony from the foul smell, she is sexually aroused. the person's will",
      "The male organ that has become erect while ignoring the",
      "My daughter takes her time to enjoy it. the victim man",
      "Sex repeats ejaculation while writhing in agony due to the foul smell.",
      "It's going to happen. A case where you run out of energy",
      "is by no means small.",
      "",
      "Artist: Mizukichi",
    ],
    703 => [
      "A carnivorous plant organ grown",
      "from Kanon's body, detaching and",
      "moving independently. It doesn't",
      "have its own will but acts",
      "according to Kanon's. Kanon shares",
      "sensory input such as sight and",
      "sound with these extensions,",
      "making them essentially her",
      "clones. She can create countless",
      "numbers of them, and their power",
      "rivals high-level monsters. They",
      "devour prey and even allies",
      "without mercy, digesting them to",
      "nourish Kanon's main body in",
      "return.",
      "",
      "Artist: Setouchi",
    ],
    704 => [
      "A carnivorous plant organ grown",
      "from Kanon's body, detaching and",
      "moving independently. It doesn't",
      "have its own will but acts",
      "according to Kanon's. Kanon shares",
      "sensory input such as sight and",
      "sound with these extensions,",
      "making them essentially her",
      "clones. She can create countless",
      "numbers of them, and their power",
      "rivals high-level monsters. They",
      "devour prey and even allies",
      "without mercy, digesting them to",
      "nourish Kanon's main body in",
      "return.",
      "",
      "Artist: Setouchi",
    ],
    705 => [
      "Kanon is one of the six daughters",
      "created by the Dark Goddess",
      "herself and one of the Six",
      "Ancestors, who are the progenitors",
      "of all monsters in this world. The",
      "Six Ancestors hold the pinnacle of",
      "power and combat ability in the",
      "Monster Realm and are its sole",
      "rulers. Kanon is the Ancestor of",
      "plant monsters and possesses",
      "an inexhaustible ability to",
      "produce plant-like organs,",
      "extraordinary vitality, and",
      "various potent toxins within her",
      "body, making her combat skills",
      "formidable. Her trump card, known",
      "as Green Dragon, is not a skill",
      "but rather an uncontrolled berserk",
      "form.",
      "",
      "Although she governs Grangold, she",
      "is an incompetent ruler. All",
      "political affairs are delegated to",
      "her subordinates, resulting in an",
      "autocratic state led by a small",
      "circle of close relatives. Kanon",
      "relentlessly pursues only her own",
      "pleasure and dismisses everything",
      "else as unimportant. Her greatest",
      "enjoyment comes from toying with",
      "humans, mercilessly violating",
      "their bodies regardless of age or",
      "gender and subjecting them to all",
      "kinds of torment. When the target",
      "is male, she is known to focus",
      "devastatingly intense pleasure on",
      "their sexual organs. Victims who",
      "have been thoroughly tortured are",
      "either digested or displayed as",
      "art pieces, where they are",
      "continually subjected to endless",
      "humiliation.",
      "",
	  "Artist: Shiki",
    ],
    706 => [
      "A slime family with a very high body temperature, their mucus is",
      "It is also possible to heat it to the same temperature as magma. Also",
      "Manipulate molecules to cause an explosion in or near the body surface.",
      "It is also possible to do this, making it one of the most popular slimes among slimes.",
      "They are known as a race that is skilled in combat. Sly",
      "The main force of the army in Grand Noah, the country of the Mu people.",
      "Of course, he is working as a mercenary in another country.",
      "It seems that there are some people. He has an excitable and combative personality, but",
      "It's not that he has low intelligence, but in battle",
      "He is also able to make calm judgments.",
      "",
      "When a man is raped, it is done violently and passionately, leaving the other person with a sticky mess.",
      "Wrapping you in your body and giving it a melting warmth",
      "Stimulates, leads to ejaculation and extracts semen. when wrapping a man",
      "lowers your body temperature, so you don't have to worry about getting burned...",
      "As long as it doesn't offend Muslims.",
      "",
      "Artist: kupala",
    ],
    707 => [
      "A slime race with extremely high intelligence that can control its own body.",
      "Manipulate the formed viscous material at the molecular level to rapidly heat and cool it.",
      "Can cause various physical phenomena such as freezing",
      "It is. Utilizing that body, magic, science, alchemy",
      "Many of them seem to be working in research positions. Also mucus",
      "The ability to manipulate molecules is useful in battle, so",
      "In Grand Noah, they are also used as soldiers.",
      "He is calm and calm and is good at tactics, so he is well-known in the military.",
      "It is said that there are many people living in the world.",
      "",
      "Although he has a gentle personality, he is extremely ruthless towards his enemies.",
      "There is also this aspect. When squeezing semen from a man,",
      "The slime is skillfully transformed to create the finest male genitalia that is wrapped around it.",
      "It gives you a feeling of pleasure. Control the feel and temperature inside",
      "To be transformed and have every drop of semen squeezed out",
      "It will be.",
      "",
      "Artist: kupala",
    ],
    708 => [
      "A daughter of one of the most prestigious families in the slime tribe. deer",
      "However, it has become so divided that it has become more of a species than a clan.",
      "Their numbers have increased to such an extent that they can be called a tribe, and their family status has become",
      "crash. However, due to his charming nature, he is considered a slime.",
      "is loved. For a famous family in the demon world, battle is difficult.",
      "Although she is not good at it, she seems to be good at singing and dancing. Ma",
      "The slime of leeches has a meltingly sweet taste, so",
      "There are also rumors that it is being targeted by insects.",
      "",
      "I try to act proud, but my roots are good.",
      "He is very friendly and lonely. young",
      "I love having sex with good-looking men and am active in it.",
      "It will attack you. A viscous and highly elastic body",
      "Move it around and squeeze out the cum. Relentless even after it's over",
      "Wrap yourself around me and leave me alone until we get married.",
      "He says there is no. And even if we get married, he won't let me go.",
      "",
      "Artist: Alexi",
    ],
    709 => [
      "A type of monster that is an ancient species in the demon world. multi-armed and multiple",
      "He masters weapons and boasts extremely high fighting ability.",
      "He lends his strength to people in need, protects them from bandits, and acts as a god of war.",
      "It is said that he was even worshiped. Even in modern times",
      "Many people take advantage of their military power and work as mercenaries. especially",
      "Many people were employed at Grand Noah, which is close to his hometown of Yamatai.",
      "and maintains its own power among the slime army.",
      "It is said that Grand Noah's Ashura troops are other",
      "Famous in the country, especially skirmishes with Grangold",
      "It seems that he is often called out during competitions. The misfortune is",
      "Because he doesn't want to hurt his fellow slime people, he",
      "It is also speculated that they make heavy use of mercenaries.",
      "",
      "He is also skilled in sexual SKL and uses his many arms to caress the whole body.",
      "Both men and women are so immersed in ecstasy that they reach climax repeatedly.",
      "It is said to be very sweet.",
      "",
      "Artist: Sugamon",
    ],
    710 => [
      "A large colony of multiple slimes fused together. Also attacks life force",
      "His power is also extraordinary, and he is considered the trump card of Grand Noah's army.",
      "It is a powerful being. It happens often",
      "It was also used in the battle against Grangold, and was the only one on the enemy side.",
      "Clashes with Malboro girls who can compete have become a tradition.",
      "There is.",
      "Multiple individuals are mixed not only in body but also in will.",
      "However, all the individuals have similar personalities, so there is a sense of unity.",
      "is extremely strong. The man who was also very greedy and captured",
      "They squeeze out every drop of semen. I was hungry",
      "In that case, the body can be digested and used as nutrients.",
      "It's called mau.",
      "",
      "Artist: Setouchi",
    ],
    711 => [
      "A split body of Kanade, one of the",
      "Six Ancestors. Kanade holds an",
      "immense amount of life force",
      "within her body, allowing her to",
      "divide it and bestow it onto her",
      "split bodies. These can act",
      "completely independently, making",
      "them more akin to daughters than",
      "mere extensions. However, if",
      "defeated, they can be reabsorbed",
      "back into her original body. It is",
      "said that Kanade can produce an",
      "unlimited number of these split",
      "bodies.",
      "",
      "Artist: Shiki",
    ],
    712 => [
      "Kanade is one of the six daughters",
      "created by the Dark Goddess",
      "herself and one of the Six",
      "Ancestors, who are the progenitors",
      "of all monsters in this world. The",
      "Six Ancestors hold the pinnacle of",
      "power and combat ability in the",
      "Monster Realm and are its sole",
      "rulers. Kanade is the Ancestor of",
      "slime monsters and harbors",
      "billions upon trillions of lives",
      "within her body. It is rumored",
      "that life forms of her exist even",
      "at the cellular level, allowing",
      "her to split and merge at will.",
      "Her vitality is extraordinary,",
      "making her the hardest to kill",
      "among the Six Ancestors.",
      "",
      "Kanade can appear in multiple",
      "places simultaneously and split or",
      "expand infinitely, making her an",
      "impossible opponent to deal with.",
      "She has a preference for the flesh",
      "of living beings, engulfing them",
      "with her slimy body to digest",
      "them. In battle, she can swell to",
      "a scale akin to a tsunami,",
      "sweeping across the land and",
      "devouring entire armies numbering",
      "tens of thousands at once. She",
      "also craves male semen, and when",
      "capturing a man, she takes her",
      "time, enveloping him and",
      "extracting his essence while",
      "slowly dissolving him. Using",
      "countless female forms, she",
      "smothers and simulates",
      "intercourse, utterly tormenting",
      "her prey.",
      "",
      "However, after the conclusion of",
      "the Great Monster Wars and upon",
      "being granted her own country by",
      "the Dark Goddess, Kanade ceased",
      "using men as food and has",
      "completely refrained from harming",
      "her own citizens.",
      "",
      "Artist: Shiki",
    ],
    713 => [
      "They are the highest ranking race among the Lamia, and those who meet them are evil.",
      "It got its name because it means dreaming. body",
      "His abilities are outstanding even among his kind, and he even has high magical power.",
      "We are prepared. His personality is also very cruel, and he does it for fun.",
      "It is said that they sometimes torment and kill not only humans but also monsters.",
      "say. Because of his gender, he is hated even by fellow Lamians.",
      "However, due to his extremely high combat ability, Qui",
      "It seems that there are many people who serve as the Royal Guards of Nlamia.",
      "",
      "His pleasure lies in torturing others, but a human man",
      "When it comes to objects, the sadism increases even more. Like playing with a snake body",
      "Rape by tightening up and licking the whole body",
      "After doing the best, he is swallowed whole.",
      "It will probably end up. Of course, before being eaten,",
      "Even she was forced to copulate, and all of her semen was squeezed out.",
      "It is said that",
      "",
      "Artist: frfr",
    ],
    714 => [
      "A fighting tribe known as the strongest among the Medusa tribe. very",
      "Boasting extremely high physical ability, he was a member of the tribe from an early age.",
      "Received advanced combat training. Even higher magical power",
      "It is said that he can use a powerful demonic eye. queenra",
      "There are many people who serve as Mia's close aides, but the fruit is",
      "Due to their power, they are in high demand as mercenaries.",
      "Since the number of individuals in a tribe is never large,",
      "It is said that he is sought after as a mercenary in various places.",
      "cormorant.",
      "",
      "Due to her strong fighting spirit, she is very fierce when raping men.",
      "Retsu. It is rare for a man to insult the other man until he runs out of energy.",
      "Using snake hair and snake body, she can attack multiple men at the same time.",
      "It is said that he may even commit a crime. Even on the battlefield, there is humiliation",
      "It is carried out without any hesitation, and is truly terrifying for the opposing enemy.",
      "It is a scary existence.",
      "",
      "Artist: Setouchi",
    ],
    715 => [
      "A monster that reigns at the top among the Mimic type.",
      "Boasting the strongest power in the demon world, he will defeat the person who opened the treasure chest.",
      "With its overwhelming fighting ability, it beats you down mercilessly. but",
      "Because it is holed up in a treasure chest, it becomes the center stage of history.",
      "never appears in. Notice its strength",
      "Pandora is in the middle of the battlefield.",
      "I pulled out the treasure chest, but it remained hidden.",
      "He does not appear and has no effect on the war situation.",
      "It is said that He is also aware of his own strength.",
      "Even though he is a shut-in, he is very relaxed.",
      "Being in a bold, obviously unnatural place, or looking for treasure.",
      "There are cases of them wandering around in boxes.",
      "say.",
      "",
      "Anyone who accidentally opens Pandora's box",
      "Life ends at that point. Drawn into the box and sticky",
      "After being violently violated while being wrapped in meat, she screams.",
      "It is said that the food is digested without leaving any residue.",
      "",
      "Artist: Setouchi",
    ],
    716 => [
      "The queen who stands at the top of the Lamia tribe and leads the clan. Rami",
      "This is extremely rare for a queen of A, and her origins are from the shrine maiden tribe.",
      "She is a lamia and has a calm and accommodating personality. shaman",
      "Being a female Lamia, she is skilled at recovery SKL and the manipulation of holy energy.",
      "He is well versed in craftsmanship and has extremely high magical power. push the mainstream",
      "His exceptional ascension to the throne is recognized, and",
      "His fighting ability is also said to be very high. But the person in question is fighting",
      "The Scylla tribe, which hates humans and has been an enemy for many years,",
      "We are working hard for reconciliation.",
      "",
      "I don't like violence, but as long as it's a monster, it's human.",
      "Semen is my favorite food. To the man who serves as Yatogi, my mother",
      "Sexually pamper and immerse yourself in ecstasy while milking your semen.",
      "Looks like I'll take it. Because of her benevolent personality, she causes harm to men.",
      "I don't add anything, but I'm drowning in that body.",
      "Many men are said to be ruined.",
      "",
      "Artist: UN_DO",
    ],
    717 => [
      "One of the four great spirits that exist in the demon world, and controls fire.",
      "Spirit. In the depths of Gold Volcano, everything is raging.",
      "It is said to be burning quietly. Originally the body",
      "I'm a spiritual being who doesn't have it, but I wear a blazing flame like a dress.",
      "Clothed in sea urchin, its magical power is extremely high. silent and silent",
      "Emotional, always calm and collected. Great power is silence",
      "It is believed that the wild water spirit Gata dwells within the",
      "He is on very bad terms with Nosoa.",
      "",
      "People who never leave Gold Volcano and step into it",
      "Since there is no time, there is no opportunity to contact men.",
      "It is possible to live without ingesting semen, but when it comes to men",
      "When the prey appears, the spirit will be taken away mercilessly.",
      "It's going to be a problem.",
      "",
      "Artist: frfr",
    ],
    718 => [
      "A very rare moray eel-shaped mermaid. live in fresh water",
      "Breathable and active on land for a considerable length of time",
      "I can do it. He has a lively personality, but he's not quite combative.",
      "There isn't. However, the lower body of the moray eel is extremely ferocious.",
      "It is said that it sometimes goes berserk, ignoring its own will.",
      "For some reason, the moray girls recognize themselves as Scylla.",
      "She has Queen Scylla as her lord. other",
      "Scylla and the others were also obsessed with the fact that the Moray Girl was of a different species.",
      "It seems that they are not aware of this and think that they are compatriots.",
      "stomach.",
      "",
      "When squeezing semen from a man, wrap a moray eel around it and move it.",
      "Seal the situation. Then she sucked the penis with her vagina.",
      "He also shares his semen with moray eels, showing his greediness.",
      "It is said that it will be squeezed to the fullest.",
      "",
      "Artist: Raichi",
    ],
    719 => [
      "It is said to be the oldest species among the Scylla tribe, and is",
      "Its body retains many of its characteristics from when it was undifferentiated from its native species.",
      "are. Originally hidden in the deep sea, they never reach the surface.",
      "It is said that he rarely came. But holy",
      "After the sea was polluted by the Demon War, many individuals died.",
      "A spring or groundwater reservoir that is hydrated and uncontaminated",
      "Expanded to. As a result, the residents who originally lived there",
      "There is a territorial dispute with Cura, and deep-sea species are disliked by their own species.",
      "It has become something that can be ignored.",
      "Its tentacles are extremely strong, and its shell has excellent DEF.",
      "I am doing it. Furthermore, it has the magical power to manipulate water and electricity.",
      "It seems like it is. In some regions, he is worshiped as a sea god.",
      "However, for the Scylla tribe, the deep sea was",
      "Seeds tend to be looked down upon, so their outstanding ability",
      "Despite this, it is a shadowy presence.",
      "",
      "Because they originally lived in the deep sea, they ate very little food.",
      "It has an ecology that allows it to be active for a long time. where the man was captured",
      "In this case, rather than extracting a lot of sperm immediately, it is necessary to raise",
      "By doing so, you can make yourself dependent on yourself and develop it carefully over a long period of time.",
      "and squeezes the semen. In the past, they were just taken away to the deep sea",
      "It is believed that it is the basis of various folk tales.",
      "be exposed.",
      "",
      "Artist: UN_DO",
    ],
    720 => [
      "Queen of Scylla, who recently ascended the throne. inside the clan",
      "She is from a deep-sea species that is looked down upon, and the queen's",
      "It seems that there were many hardships in getting the position, but the effort",
      "It is said that he succeeded in acceding to the throne. There is a certain power",
      "She is a powerful queen, and even her political opponents recognize her ability.",
      "It's so much so. He has a very calm personality, and",
      "They hope to reconcile with the Lamia tribe, who have been hostile to them for a long time.",
      "However, his political enemies, including Asmodeus, a powerful nobleman,",
      "There are many members of the clan, and the main war faction is the mainstream among the clans.",
      "At present, it seems that there is still a long way to go for peace.",
      "",
      "Treat men with compassion and be gentle and pampering.",
      "while squeezing out the semen. A slave man was offered as an offering.",
      "After a night of fun, he was released as a free citizen.",
      "It is said that he is releasing it.",
      "",
      "Artist: UN_DO",
    ],
    721 => [
      "One of the four great spirits that exist in the demon world, and controls water.",
      "Spirit. Surrender yourself to the turbulent water in the depths of the Water Spirit Fountain.",
      "It's said that it's always exciting. with a body of mucus",
      "Formed into the shape of a raging dragon, destroyed by a violent stream of water",
      "The power is overwhelming. Unarmed artists who rarely appear to take on the challenge are immediately defeated.",
      "It is said that he gets beaten up. Power is turbulent",
      "He has the belief that Guri, the spirit of fire,",
      "He is on extremely bad terms with Moir.",
      "",
      "Although they live in environments where humans rarely visit,",
      "Those who worship spirits send a young man as a sacrifice.",
      "There are some things. The sacrificed man is exposed to severe humiliation.",
      "will be done. My body is full of mucus, and I just keep going.",
      "The semen is squeezed out. However, life",
      "It is not that his life is taken away from him, but his wasted life.",
      "The sacrifice is said to be thrown out of the fountain. And the rattle",
      "Nosoa gives benefits such as rain and spring water to those who worship it.",
      "It gives.",
      "",
      "Artist: frfr",
    ],
    722 => [
      "A demon aristocrat belonging to Scylla, with immense power and high",
      "An old breed with a strong family status. Unique among the Scylla tribe",
      "He has built his own faction and has a very vocal voice.",
      "Hardline main faction against moderate Queen Scylla",
      "and is treated like a leader of the anti-Queen faction.",
      "However, he never openly disobeys the queen, and is a dark man.",
      "We are firmly maintaining our number two position. But that",
      "In the shadows, he is plotting a political strategy to oust the queen.",
      "It seems so. Also, in the Dark Goddess Castle, Asu, who has the same bloodline,",
      "It is said that the Modeus family lived there as upper class aristocrats.",
      "cormorant.",
      "",
      "Being an ancient species, its power is tremendous and it is still active.",
      "It's as good as Queen Scylla. Also very",
      "He has a cruel personality and treats others, regardless of race, age, or gender.",
      "I take pleasure in seeing him suffer. Insult to human male",
      "It is also extremely violent, and the man dies from exhaustion of semen.",
      "The blame will not be eased until it is done.",
      "",
      "Artist: xelvy",
    ],
    723 => [
      "Created by Saja at the earliest stage, his family status is demonic.",
      "A lamia-type demon aristocrat who is said to be the highest in the world.",
      "Many of them reside in the Dark Goddess Castle, but they are extremely ambitious.",
      "A person who is highly skilled and plans to rise to the top of the Lamia tribe.",
      "There are some too. Under the moderate Queen Lamia",
      "However, it seems that they are plotting to take that position.",
      "He has an extremely arrogant and bellicose personality, and his strength is unparalleled.",
      "is removed. However, since he is not good at plotting,",
      "Of course, he colludes with Asmodeus, the enemy. both",
      "They planned that their master would fall in war, and there was talk of peace.",
      "When he was brought up, he plotted to poison himself at a banquet. that",
      "But now that Asmodeus and Asmodeus are in prison.",
      "It seems like there is.",
      "",
      "Although not cruel, he is extremely greedy and",
      "She devours every man who comes up to her. Of course",
      "I'll fuck you all before I eat you, so I'll swallow it whole.",
      "It is said that it is not uncommon for the child to die before he can take his last breath.",
      "",
      "Artist: xelvy",
    ],
    724 => [
      "A subspecies of Akaname, a monster that appears near Yamatai.",
      "It is said that In addition to being able to freely extend the tongue, it is also attached to both palms.",
      "A tongue extends from each mouth and licks the prey.",
      "You can use it as you like, such as rolling it up or rolling it up.",
      "I can do that. His magical power is extremely high, and he doesn't even know about the ancient species.",
      "It is said that he can use mysterious and forbidden SKL.",
      "They are actually a race of unknown origin, but they are friends with Akaname and others.",
      "Because he was welcomed as a person, he recognized himself as Akaname.",
      "I am doing it. But in reality, it's even more unknown and abhorrent.",
      "Some people are wondering if this is an ugly race.",
      "Uda.",
      "",
      "She has a friendly personality and loves men's semen. three",
      "After capturing the man with one tongue, he licks the whole body and is spectacular",
      "It gives you a feeling of pleasure. Of course, the male genitals are also thoroughly covered.",
      "He gets licked completely and continues to emit semen while writhing in pleasure.",
      "I'm sure I'll be able to do it. Akane Mikuchi has no malicious intent.",
      "However, it is not uncommon for people to be forced into an excessively weakened state.",
      "I say yes.",
      "",
      "Artist: Irodori",
    ],
    725 => [
      "The highest-ranking cat that lives near Yamatai.",
      "They are very friendly and can even enter human areas and show off their charm.",
      "It seems like it's going around. I consider myself the cutest in the world",
      "I am aware that there are people who do not love me.",
      "I fall into a panic.",
      "He has extremely high agility, and his flexible body allows him to",
      "The Unarmed offered are extremely powerful. have various effects",
      "He is also good at dancing, and although he has a charming appearance, he is also good at fighting.",
      "His ability is extremely high.",
      "Although he is originally from the Yamatai area, his range of activities is unusual.",
      "It is always widespread and sometimes appears in other countries. human village",
      "It's still a monster that sneaks in and begs for food.",
      "I was hungry because I was loved by people, both human and human.",
      "It seems unlikely.",
      "",
      "When she finds a man she likes, she forcibly kidnaps him and makes him her husband.",
      "That's what it means. It also has the power to bring good fortune, so it is considered a cat god.",
      "It is said that a man who marries a man will live happily ever after.",
      "Ru.",
      "",
      "Artist: frfr",
    ],
    726 => [
      "The highest-ranking demon that lives near Yamatai. the",
      "Unparalleled strength is condensed into a small body, overwhelming",
      "Boasts great power. Because of living for so many years, he is very wise.",
      "There is not a trace of the wildness characteristic of young demons.",
      "He has a great deal of experience and knowledge, and is regarded as an elder figure.",
      "It is said that it is also respected by the monsters. Also, young",
      "There seem to be many Silver Onis who travel around the country with their companions.",
      "is.",
      "",
      "Her sexual desire doesn't seem to be that high, and she beats men away.",
      "They also rarely attack by force. The other person has no relatives",
      "If it's a young man, I might take him home and take care of him.",
      "That's what it means. And if a man becomes lustful, he will replace it with food.",
      "It is said that he will perform sexual treatment for her.",
      "",
      "Artist: frfr",
    ],
    727 => [
      "A half-human from Yamatai whose lower body is a scorpion.",
      "Insect monster. Very intelligent and skilled in Taoism SKL.",
      "are. Also, following the development of Yamatai, advanced science",
      "He is also learning SKL. his personality is very cruel",
      "It swallows its prey alive from the scorpion's mouth.",
      "prefer. Also, in Yamatai's underground research facility, Scorpio Taoist",
      "Many of them are said to be engaged in nefarious experiments. One theory",
      "According to him, his fellow demon foxes were not involved in inhumane research.",
      "Tamamo, who doesn't want to let him know, is a Taoism scorpion in his dark research.",
      "It is said that there are whispers that Kari is being selected. deer",
      "The Taoism Scorpios are guaranteed high-paying, important jobs.",
      "He seems to be happy about that.",
      "",
      "She loves men's semen, so she transforms her mouth into a penis.",
      "I like to squeeze it by sucking it in my mouth and slurping it over and over again.",
      "nothing. Also, if you feel like it, after mating, you will be exhausted.",
      "It seems that the prey is swallowed whole.",
      "Digestion also takes time, and the food melts in the stomach.",
      "He says he enjoys watching them.",
      "",
      "Artist: UN_DO",
    ],
    728 => [
      "Tamamo of the singularity world was sealed by the Great Binding Curse of the Sixth Ancestor.",
      "Alice, the 16th Monster Lord, as one of the Four Heavenly Kings.",
      "He works as a close aide to Fizz. Currently the same as the Dark Goddess army",
      "Follow Alipheese, who has formed an alliance, and enter the demon world.",
      "After accomplishing this, he was dispatched to intercept Luka and his group.",
      "When he entered the demon world, he also met with the six ancestors. That vicious",
      "Tamamo's perfectly rounded appearance is a source of great laughter.",
      "It is being done. Furthermore, he was almost eaten by leeches,",
      "It seems like it was a mess.",
      "",
      "Artist: Nonhuman Modoki",
    ],
    729 => [
      "A multifunctional cat-like robot mass-produced in Yamatai.",
      "It is fully autonomous and has a will of its own.",
      "The body is assertive. All kinds of miscellaneous things in Yamatai",
      "I am in charge of everything from infrastructure work to customer service.",
      "Versatile. It also has combat ability, called self-defense.",
      "It is equipped with extremely powerful weapons. Friendliness",
      "His strong and free personality was intentionally programmed into him.",
      "Not things, but automatically learned things. many people",
      "By interacting with people, you can show off your charm while also paying cash.",
      "I have become a self-paced person. Still sex",
      "The performance is good, and the lifestyle and social infrastructure of Yamatai residents are good.",
      "They protect hula and safety. Furthermore, in recent years",
      "Started political advocacy to recognize human rights to robots,",
      "He even went to a demonstration march.",
      "",
      "Semen, which is an energy source, is supplied regularly.",
      "However, on rare occasions, she attacks a man and forcibly squeezes his semen.",
      "There is also. I was forcibly taken away from the shadows, unable to stand on my feet.",
      "It is said that some victims were squeezed until they were dry.",
      "",
      "Artist: xelvy",
    ],
    730 => [
      "A fighting android based on a demon fox, it is a strong",
      "It is equipped with powerful weapons and a small magic furnace. handling of sword",
      "In addition to being skilled in",
      "It is also said that it is possible to activate Taoism. heaven and",
      "It was developed in a hurry in preparation for the battle, and mass production began immediately.",
      "However, the production cost is very high and it is still not available.",
      "The number of production seems to be small. Currently deployed in Yamatai",
      "However, after further strengthening it, it becomes the Dark Goddess Castle.",
      "The goal is to have a large force in place.",
      "",
      "The supply of spirit is carried out regularly, but human males",
      "I prefer interacting with them and exploiting them directly. Yamatai's",
      "In addition to seducing people into sexual intercourse, they also forcibly attacked people.",
      "There have also been incidents of rape. Cait Sith",
      "In collusion with the police, they kidnapped a young resident and gang raped her.",
      "There are some examples. Many such rape cases occur.",
      "It appears that countermeasures are urgently needed.",
      "",
      "Artist: xelvy",
    ],
    731 => [
      "Tamamo is one of the six daughters",
      "created by the Dark Goddess",
      "herself and one of the Six",
      "Ancestors, who are the progenitors",
      "of all monsters in this world. The",
      "Six Ancestors hold the pinnacle of",
      "power and combat ability in the",
      "Monster Realm and are its sole",
      "rulers. Tamamo is an immensely",
      "powerful kitsune with unmatched",
      "magical power and exceptional",
      "intelligence. She is the ancestor",
      "of all beast monsters, with the",
      "kitsune lineage being especially",
      "close to her. After the Great",
      "Monster Wars, Tamamo transformed",
      "Yamatai from a small village into",
      "a modern society through various",
      "social and economic reforms. Her",
      "political prowess is unparalleled",
      "among the Six Ancestors and serves",
      "as a model for many regional",
      "lords.",
      "",
      "Tamamo is ruthless toward her",
      "enemies but shows kindness to",
      "those she considers kin. She has a",
      "particular affection for kitsune",
      "and acts as a protector for the",
      "residents of Yamatai. She often",
      "invites favored men to her",
      "chambers for nights of passion,",
      "but spares their lives afterward.",
      "However, this mercy doesn't extend",
      "to foes, who will find their life",
      "force relentlessly drained to the",
      "last drop.",
      "",
      "Artist: Shiki",
    ],
    732 => [
      "A monster bird monster that exists in the demon world. Possessing the characteristics of a dragon",
      "It boasts an agile yet extremely strong body.",
      "Due to her high fighting power, she is often selected as Queen Harpy.",
      "It seems that they are active as an elite unit. personality",
      "He is also a warrior and values ​​honor on the battlefield. common",
      "A violent and rugged group that does not get along well with the Harpies.",
      "It is said that it is hated as such.",
      "",
      "The idea is martial, but not brutal. breeding season",
      "When this happens, they capture young, healthy men and mate with them.",
      "Never hurt the other person unnecessarily. Seeding is finished",
      "After the death, the man received a souvenir of wings and was released.",
      "It is said that If you keep that feather close to your body,",
      "When a man is faced with a crisis in his life, his grown daughter comes to his rescue.",
      "There is a legend that it will help you, but is it true?",
      "is not certain.",
      "",
      "Artist: Irodori",
    ],
    733 => [
      "A demonic creature with the characteristics of both a dragon and a harpy.",
      "Demon. Dragons and harpies are demons with the same origin.",
      "species, and some intermediate species between the two have also been confirmed.",
      "Ru. Marchosias is the most major species among them.",
      "It seems that they are known as a tribe. Ferocious and high fighting ability",
      "Queens are proud of their power and are often known for their bravery.",
      "- Follows P. Qui with Jura Aevis",
      "Became the main force of the Sky Army led by the Harpies, and",
      "It is said that it supports Hedo.",
      "",
      "When she is in heat, she will attack and forcefully attack any man she sees.",
      "mating occurs. The other man weakens due to intense intercourse",
      "It weakens them, but it doesn't seem to take away their lives. Fatigue",
      "The exhausted man was thrown into a nearby village and released.",
      "It is said that",
      "",
      "Artist: Sea mountain",
    ],
    734 => [
      "A great demon of the demon world, known as a mighty monster bird. old",
      "It is also famous as a species, and has great power hidden within its body.",
      "are. The first monster created by the Sixth Ancestor, Saja, was Yo.",
      "Lumungand and Archaeopteryx, which",
      "Each strongly expresses the characteristics of a snake and a bird, and lamia and hare",
      "It is said that it was differentiated as P. Archeo",
      "Many of the Pteryx live in the Dark Goddess Castle, but there are",
      "There are also a small number of people who have spread their wings across the world. So",
      "One of them is an army led by Queen Harpy.",
      "He is said to be number two.",
      "",
      "Because he is a powerful being, he treats humans as weak.",
      "Pamper her with her big breasts and have sweet dreams during copulation.",
      "It is said that a communion is held that feels like immersion. Arche",
      "A man who is intoxicated by mating with Opteryx,",
      "I can no longer leave my full body, and I become like a corpse.",
      "After all, it's just a rumor.",
      "",
      "Artist: UN_DO",
    ],
    735 => [
      "The queen of the Harpies, who is skilled in military prowess. its strength and bravery",
      "The sound echoes throughout the demon world, and the martial faction of the clan",
      "I am gathering them and advancing on the path of supremacy. Good at spear SKL, same",
      "Arms that can overwhelm even queen level",
      "He says he is proud of it. However, the repeated overseas expeditions",
      "This resulted in a backlash from moderate factions within the country, and in recent years",
      "It is said that the Harpies are in a state of division.",
      "",
      "He has a very belligerent personality, but when interacting with men, he is very aggressive.",
      "I like the pampering way. Enjoy your full pleasure with that plump body.",
      "It is said that it gives pleasure and even spoils the soul. According to rumors",
      "If so, a harem of beautiful boys collected as trophies.",
      "exists, where they can fully heal their battle fatigue.",
      "say. But on the other hand, the Queen is always busy and",
      "There is no such thing as a harem, and there is no such thing as a harem.",
      "It is said to be a rumor, but the truth is unknown.",
      "",
      "Artist: UN_DO",
    ],
    736 => [
      "A high ranking succubus from a very high class family. with an arrogant personality",
      "However, there are times when I have too much free time to wander around the country.",
      "There are many people. The distinctive feature is the sperm extractor on the tail, and the inside",
      "Freely alter the structure of the penis to bring intense pleasure to the male genitals",
      "In addition to feeding, it can expand and contract to swallow the prey's body whole.",
      "It is possible. Because she is a high-ranking succubus, she is also good at magic.",
      "She is strong and possesses powers that set her apart from ordinary succubi.",
      "It is said that there is",
      "",
      "When you're hungry, go to a traveler you meet or a village you stop by.",
      "Inviting a man to milk or have sex with his tail",
      "nothing. Perhaps due to the pride of being from a high-ranking family,",
      "They don't milk their prey unnecessarily, and they don't milk their prey to death.",
      "However, if you are defeated after fighting against the enemy, that is the limit.",
      "Sometimes, the semen is squeezed out until it runs out, and sometimes",
      "Sometimes the body is swallowed whole with its tail and it is preyed upon.",
      "That's what it means.",
      "",
      "Artist: Shiruku",
    ],
    737 => [
      "A demon aristocrat who possesses the characteristics of a demon, a demon, and a vampire.",
      "Boasting extremely high physical ability and magical power, he became a nobleman from an early age.",
      "He continues to train in Unarmed as a hobby. That's it",
      "He has excellent combat ability and defeats his opponents with overwhelming power.",
      "say. His dignity is also very high, and he is involved in conflicts between demon aristocrats and",
      "Horseback riding is not that rare. But against the people",
      "He was surprisingly arrogant, giving alms and oppressing people tyrannically.",
      "It is said that if there is someone who is suffering, he will help them with his own hands.",
      "cormorant. Many people grew tired of the aristocratic life during their long lives, and",
      "The appearance of Testarossa on a journey through the country,",
      "It is seen in many places. For some reason I have trouble everywhere I go",
      "It is said that people tend to get caught up in this.",
      "",
      "They are very picky when it comes to food and only absorb quality energy.",
      "do not have. Good-looking young man with good health and good spirits",
      "If you see it, you will invite it to be your partner for the night. And then I spent the whole night",
      "Take your time and enjoy the spirit. The man who was squeezed is extremely",
      "You will be severely weakened, but your life will not be taken away.",
      "Uda.",
      "",
      "Artist: Shiruku",
    ],
    738 => [
      "An elite pirate member of the Roza Pirates. general",
      "They have better combat SKL than other pirates, and when entering and exiting",
      "serves as the unit commander. Always remain calm and collected.",
      "Once they were on the offensive side, the pirates were defeated by their bold command.",
      "He says he will contribute to victory. And when I see that the enemy is powerful,",
      "If only senior pirate members form a platoon and respond.",
      "He also has a great deal of flexibility.",
      "",
      "After the battle, the looted goods will be distributed. too",
      "Of course, the man who was abducted was also targeted, and sometimes more than one person was abducted.",
      "It seems that gang rape will be carried out by members of the group. Senior member",
      "She uses her plump breasts to squeeze out the man's essence.",
      "There are many. Surrounded by exquisite breasts, she is happy at first",
      "The man who was there also cried out when he ejaculated more than 10 times.",
      "It is said that he began to ask for forgiveness. I thoroughly enjoyed it",
      "Afterwards, the abductor is returned to his hometown in exchange for a ransom.",
      "This is the group's rule. But the ransom was paid",
      "If not, they will be sold as sex slaves.",
      "It is said that there are also.",
      "",
      "Artist: Alexi",
    ],
    739 => [
      "Strong resistance in the sea contaminated by the effects of the Great Monster Wars.",
      "The man-beast type mermaid you acquired. Sturdy and has high vitality, human",
      "Very ferocious for a fish. Inheriting the characteristics of the narwhal",
      "However, the body is smaller. Unknown points about evolutionary lineage",
      "It is said that there are many mutations caused by polluted environments.",
      "There is. Many Great Merman roam freely in the ocean.",
      "However, there are a few people who have joined the pirate group.",
      "There are many. In particular, Ro, the largest pirate group in the demon world.",
      "The Pirates are Great Merman as a cutting force.",
      "It attracts a lot of people. The days of conflict after conflict",
      "It matches his ferocious personality and he enjoys being a pirate.",
      "It seems there is.",
      "",
      "When raping a man, he is very rough and intentionally causes harm.",
      "Even if the man is not in a state of serious deterioration,",
      "I get sucked into it. Kill several men at once at a pirate party",
      "It is said that he is also extremely sexually aggressive.",
      "",
      "Artist: Setouchi",
    ],
    740 => [
      "Roza Pirates, the largest pirate group in the demon world that bears its own name.",
      "The captain who leads the pirate group. The pirate queen's nickname is all over the monster world.",
      "It roars, and its ferocity is unmatched in the sea.",
      "He says there is no. Based on the ocean without following any of the six ancestors.",
      "As a point, they attacked port towns across the country. Repeated looting, small",
      "It is said that they have built up a power as strong as a country. personal valor,",
      "The command of naval battles and the turbulent waters created by the speculations of major powers",
      "He has the cunning to skillfully navigate the ocean.",
      "His ability as a bandit leader is unprecedented in history. Just lo",
      "The Pirates are completely dependent on the individual abilities of the captain.",
      "However, there is a lack of development of future leaders.",
      "He says he is worried.",
      "",
      "After the plunder, the men who were considered the finest prey were grouped together.",
      "It will be long. However, over the course of the night, the man ejaculated.",
      "Once you've squeezed out something, you'll want to let it go immediately.",
      "is. Having a relationship with any man for more than one night",
      "There is no such thing.",
      "",
      "Artist: UN_DO",
    ],
    741 => [
      "Roza Pirates, the largest pirate group in the demon world that bears its own name.",
      "The captain who leads the pirate group. The pirate queen's nickname is all over the monster world.",
      "It roars, and its ferocity is unmatched in the sea.",
      "He says there is no. Based on the ocean without following any of the six ancestors.",
      "As a point, they attacked port towns across the country. Repeated looting, small",
      "It is said that they have built up a power as strong as a country. personal valor,",
      "The command of naval battles and the turbulent waters created by the speculations of major powers",
      "He has the cunning to skillfully navigate the ocean.",
      "His ability as a bandit leader is unprecedented in history. Just lo",
      "The Pirates are completely dependent on the individual abilities of the captain.",
      "However, there is a lack of development of future leaders.",
      "He says he is worried.",
      "",
      "After the plunder, the men who were considered the finest prey were grouped together.",
      "It will be long. However, over the course of the night, the man ejaculated.",
      "Once you've squeezed out something, you'll want to let it go immediately.",
      "is. Having a relationship with any man for more than one night",
      "There is no such thing.",
      "",
      "Artist: UN_DO",
    ],
    742 => [
      "A giant tree monster that appears in the Monster Realm Forest. recent years",
      "It is a new species that has been confirmed, and is an example of a Dryad species.",
      "Some kind of mutation due to its huge size that you can't see it",
      "It is said that In some cases, changes due to the effects of chaos",
      "There seems to be a theory that this is different. overwhelming life",
      "Boasting vitality and regenerative power, it has an unprecedented body for a plant species.",
      "Has the ability. Although she has a calm personality,",
      "With such a huge body, just moving can cause large-scale destruction.",
      "It is caused by Regardless of the person's will, it is extremely dangerous.",
      "It is feared as a dangerous monster. Nao Kanon's subordinate",
      "came to recruit me, but Giga Dryad",
      "He prefers to be absentminded in the forest, so he doesn't lend his ear.",
      "It is said that there was no such thing.",
      "",
      "When she sees a human male, she is lured by the smell of his spirit and captures him.",
      "While taking it into his body as it is, he forces the semen into his body.",
      "suck it up. Although he has no malice at all,",
      "Without exception, men are squeezed out until they take their last breath.",
      "That's what it means.",
      "",
      "Artist: frfr",
    ],
    743 => [
      "One of the four great spirits that exist in the demon world, and controls the wind.",
      "Spirit. A cool breeze blows in the depths of the forest of spirits.",
      "That's what it means. It has the body of an elf wrapped in a gust of wind.",
      "It is said that its combat ability that takes advantage of its speed is extremely high.",
      "say. Basically, they look down on others, but above themselves.",
      "Be obedient to strong or dangerous opponents. Below",
      "I used to be a cynic, but now I realize that silence is the greatest irony.",
      "After realizing this, he almost stopped speaking and became less public.",
      "It is provoked only by emotion. Of course I can't speak",
      "But when we humble ourselves to those who are stronger than us, we are very",
      "Become talkative.",
      "",
      "When humans wander into the forest, they basically blow the wind.",
      "Let it blow and pull it back to the entrance. But he's the man I like",
      "If there is one, I will pull you deep into the forest and have sex with you.",
      "Bring it in. The man ends up being fucked all night, but the next day",
      "Apparently, in the morning, they will be returned to the entrance of the forest and released.",
      "",
      "Artist: frfr",
    ],
    744 => [
      "A high-grade demon who has been worshiped as a fighting god since ancient times, and a member of the demon world.",
      "But he is a warrior who boasts the most power. His combat SKL are extremely high,",
      "Carry weapons in multiple arms and annihilate enemies with overwhelming force.",
      "Ru. In the region, she is worshiped as the mother goddess.",
      "Even in modern times, its name remains unparalleled.",
      "Always famous. Speaking of powerful monsters, most of the demon world",
      "It is said that the people of India mention the name of Shiva. Many are Dark Goddesss",
      "He is said to have served in a prestigious combat position such as the SS.",
      "cormorant.",
      "",
      "Although he is full of energy and sexual desire, he steps into the evil castle.",
      "There are no men out there, so they are always hungry for men. Tama",
      "During her vacation, she goes to a brothel and squeezes out her sperm to the fullest.",
      "It seems like it is. Sometimes they have too much energy and engage in disorderly behavior.",
      "It can sometimes be a problem. Surprisingly, I am devoted to myself.",
      "Rather than making him serve, he uses his arms to tap the prey's erogenous zones.",
      "I like to pull out and make her writhe in agony. and it overflowed",
      "It is said that semen is the best nectar of all.",
      "",
      "Artist: Makiya",
    ],
    745 => [
      "Although she is a high-class succubus, she prefers alchemy rather than lewdness.",
      "A rare race that is fascinated by research. Sex appeal is",
      "Although not as good as his fellow senior succubi,",
      "Their intelligence is extremely high, and many of them are employed in research positions.",
      "Even in battle, he uses alchemy instead of lewd arts.",
      "It seems that there are many cases where this is the case. I don't care much about my appearance",
      "A spectacular social culture in San Ilia",
      "Unrelated. Although he is sometimes considered eccentric,",
      "People are enjoying their research lives to the fullest.",
      "",
      "The act of extracting semen is more like collecting than eating, and requires tools.",
      "Use it to squeeze out the target's semen. Some of it is by myself",
      "Sometimes eaten, but mostly used for alchemy experiments.",
      "It is said that it will be done.",
      "",
      "Artist: kupala",
    ],
    746 => [
      "A senior succubus who lives in San Ilia. lewd",
      "Although he has a standard personality as a demon, he has high magical power.",
      "She has a sex appeal that can steal a man's soul. Whip again",
      "He is skilled at handling the belt, and can also swing the belt attached to his costume like a whip.",
      "It seems possible to do so. mostly in San Ilia",
      "He lives in the royal palace and enjoys the high life.",
      "However, I never forget to improve myself through Minagi's teachings.",
      "If something were to happen, it would quickly transform into a strong defensive force.",
      "say. He has a winning personality and hates losing, but he is also domineering.",
      "That's not to say, there is a good side to people. from the upper class",
      "However, it is not unnecessarily pretentious and is rather approachable.",
      "It seems like a personality.",
      "",
      "When dealing with a man, restrain him tightly with a belt before playing with him.",
      "I like things. I tease you and make you climax all at once.",
      "She continuously shoots the man with a slow and fast attack, such as pushing him into the",
      "It is said to push you to the essence. However, as an upper class",
      "There is a negative side to her, and she won't easily squeeze a man to death.",
      "However, if it is an enemy, there is an exception, and the spirit will be sucked out without mercy.",
      "He says he will do everything he can.",
      "",
      "Artist: kupala",
    ],
    747 => [
      "The oldest and highest class of demons. demon's",
      "It also has special characteristics, and its magical power is extremely high. lewd",
      "His SKL has also reached the highest class, and he usually suppresses it intentionally.",
      "If I don't, the people around me will climax on their own.",
      "be. Belongs to the highest class in San Ilia, and",
      "It is said that he serves as Minagi's aide and bodyguard when she gets drunk.",
      "This class rarely appears in castle towns.",
      "Because there is no such thing, it can cause a commotion if you go out in front of the general public.",
      "It is said that",
      "",
      "When extracting semen, it's not just a meal, it's a relationship with a man.",
      "Enjoy the act itself. Unusual for a succubus,",
      "It is said that she even intentionally makes the man take the blame. deer",
      "But in reality, it was just being rolled around in her palm.",
      "There's no way a human could defeat a demon with sexual SKL. men are limited",
      "He repeatedly climaxed until he reached the limit, and soon he made a loud sound and passed out.",
      "It is said that",
      "",
      "Artist: Saiki",
    ],
    748 => [
      "A demon possessing top-notch magic and skill as a necromancer.",
      "Sang Yi is a talented woman from the famous Artiste family.",
      "Leah is also famous for the necromancy she practices.",
      "The master's mansion never stops attracting celebrities. war",
      "Skillfully uses ghost summoning in battle,",
      "Even very powerful spirits called 'Nameless Sisters'",
      "It is said that he is obeying.",
      "",
      "However, as a succubus, her sperm extraction ability is not very high.",
      "Not. He has a very sloppy personality and low living SKL.",
      "Housework and general accounting are left to the summoned spirits.",
      "say. Among them, the high-ranking maid spirit Flora and the tax accountant spirit Ji.",
      "Yovanni was abused by Chrome and died from overwork even though he was a spirit.",
      "I did it.",
      "",
      "Artist: UN_DO",
    ],
    749 => [
      "A very powerful ghost called the 'Nameless Sisters'",
      "They are sisters and possess inexhaustible magical power. lost demon",
      "It is said that he is from the lineage of the King, but the details are unknown. with my sister",
      "They turned into evil spirits and caused disaster in an old castle in the Gold region.",
      "Many spiritual mediums have fallen prey to this.",
      "However, Chrome, who is famous as a necromancer, follows him.",
      "succeeded in subjugating. Now I'm completely attached to chrome.",
      "It is said that the master's enemies will crush him without mercy.",
      "cormorant. Note that the names Yu and Rei do not have real names.",
      "This is the name given to him by Chrome because of his desire to do so.",
      "",
      "Artist: UN_DO",
    ],
    750 => [
      "A very powerful ghost called the 'Nameless Sisters'",
      "They are sisters and possess inexhaustible magical power. lost demon",
      "It is said that he is from the lineage of the King, but the details are unknown. with my sister",
      "They turned into evil spirits and caused disaster in an old castle in the Gold region.",
      "Many spiritual mediums have fallen prey to this.",
      "However, Chrome, who is famous as a necromancer, follows him.",
      "succeeded in subjugating. Now I'm completely attached to chrome.",
      "It is said that the master's enemies will crush him without mercy.",
      "cormorant. Note that the names Yu and Rei do not have real names.",
      "This is the name given to him by Chrome because of his desire to do so.",
      "",
      "Artist: UN_DO",
    ],
    751 => [
      "Minagi is one of the six daughters",
      "created by the Dark Goddess",
      "herself and one of the Six",
      "Ancestors, who are the progenitors",
      "of all monsters in this world. The",
      "Six Ancestors hold the pinnacle of",
      "power and combat ability in the",
      "Monster Realm and are its sole",
      "rulers. Minagi is the ancestor of",
      "all succubi, possessing immense",
      "magical power and an allure",
      "capable of enthralling nations.",
      "Her skills in the art of seduction",
      "are so potent that she can",
      "instantly brainwash and subdue",
      "even her enemies, turning them",
      "into obedient pawns; only those",
      "with exceptional mental fortitude",
      "can resist her.",
      "",
      "Though lesser known, Minagi's",
      "prowess in martial arts is also",
      "unmatched. She dominates in close",
      "combat and was said to have",
      "defeated numerous angels with her",
      "fists during the Great Monster",
      "Wars. Her ability to milk semen",
      "from men is unparalleled in the",
      "Monster Realm, using not only her",
      "vagina, mouth, and breasts but, if",
      "she wishes, even a single glance",
      "to drain any man dry until he is",
      "left a husk. However, driven by",
      "her pride as a succubus, she does",
      "not take the lives of ordinary",
      "people lightly. But if you stand",
      "against her as an enemy, you must",
      "be prepared to experience ultimate",
      "pleasure before meeting your end.",
      "",
      "Artist: Shiki",
    ],
    752 => [
      "A Monster Lord doll created by Kagetsumugi using the corpses of past Monster Lords.",
      "One of them. The theme is 'erosion of time',",
      "She is intentionally reduced to a girl's appearance. time magic",
      "In addition to dark SKL, attacks that utilize insect demon organs are very effective.",
      "Powerful. In addition, the DEF is high due to the insect shell, and the magician",
      "It is very sturdy for a doll of this type.",
      "",
      "Artist: UN_DO",
    ],
    753 => [
      "A member of the puppet circus led by Kagetsumugi. Youma's Circa",
      "A clan of puppeteers scouted from the Sudan, and a demon beast.",
      "He is also skilled as a messenger. Also a circus group",
      "As a member of the team, his body is well-trained and his movements are supple.",
      "His fighting ability is extremely high due to his sharp and skillful whip handling.",
      "stomach. The show was extremely brutal, with people in front of the audience",
      "The one that makes the man between them the prey of the demon beast doll. The poor man",
      "A ferocious monster doll has been used to the maximum extent of humiliation.",
      "It is said that they are preyed upon by Geku.",
      "",
      "Many are lured to Kagetsumugi's circus in exchange for high pay.",
      "Many of them were hacked, but the people themselves did not know about them.",
      "It is said that she was later turned into a doll.",
      "",
      "Artist: UN_DO",
    ],
    754 => [
      "A magical beast controlled by Hargenbeck, a member of the puppet circus.",
      "type doll. Using the body of a real demonic beast as biological parts",
      "It boasts outstanding AGI and ferocity. Also",
      "Equipped with elaborate breasts and artificial genitalia, she can attack men.",
      "It is also possible to squeeze out semen at the same time. Predation",
      "It is also equipped with a digestive function, and is capable of killing a captured man.",
      "The show where people swallow them alive is especially popular.",
      "It is said to be a performance.",
      "",
      "In addition to living monsters, the materials for this doll include circus",
      "Sometimes members of the group are used. newly delivered",
      "The head of the magical beast doll suddenly went missing.",
      "It is no longer rare to hear that he looked a lot like a member of the group.",
      "It is said that it is not cloudy.",
      "",
      "Artist: UN_DO",
    ],
    755 => [
      "A member of the puppet circus led by Kagetsumugi. otherworldly beliefs",
      "A clan of puppeteers who were scouted from the group, and a sacred",
      "Inquisitions were carried out using dolls shaped like statues of",
      "was. Even if you join Kagetsumugi's circus, the things you do are strange.",
      "However, he manipulated a more strengthened saint form to become a pagan.",
      "Perform sexual torture against others. Inquisition by puppets",
      "It was well received at the show, and while the audience was watching, many people",
      "of sinners are transformed into saints and left to die.",
      "It is said that there is.",
      "",
      "Artist: UN_DO",
    ],
    756 => [
      "Puppet circus member given to Santamaria",
      "Saint form. Based on the dolls they originally used",
      "However, Kagetsumugi has dramatically strengthened her abilities.",
      "Ru. Not only does it have a holy energy release function, but it also has a holy mother part.",
      "semi-autonomous, and more than 100 restraint systems",
      "It is said to have a torture function.",
      "",
      "The Virgin part is made from a young, pious sister.",
      "It is also used as a shadow pongee.",
      "Ru. The body of an angel is also used as a material, albeit partially.",
      "His divinity is comparable to that of the original saint.",
      "Not cloudy. Made using biological parts of sisters and angels.",
      "It seems that there was also Santa Maria who denounced it as blasphemous.",
      "However, it seems that they too have become doll parts.",
      "",
      "Artist: UN_DO",
    ],
    757 => [
      "A semi-autonomous puppet belonging to a puppet circus. infantry role",
      "In order to support the surroundings, low cost and high productivity,",
      "It also achieved good combat ability. but thinking",
      "is very simple, only those who are registered as allies",
      "The main movement pattern is to attack from one side.",
      "There is. Because it is small, it is good at AGI and has various",
      "The battle data of great swordsmen has been downloaded.",
      "He masters a variety of Unarmed.",
      "",
      "Equipped with a female organ-shaped essence collection organ, it is a pseudo",
      "You can replenish your energy through sexual intercourse. movement pattern",
      "Attack a human male as set in the game.",
      "In that case, do not kill them, but incapacitate them and start insulting them.",
      "Suck up the man's semen until he dies, and enjoy the energy.",
      "It is said that it satisfies the rugi.",
      "",
      "Artist: UN_DO",
    ],
    758 => [
      "A Monster Lord doll created by Kagetsumugi using the corpses of past Monster Lords.",
      "One of them. Black Alice's mother whom Kagetsumugi adores",
      "Therefore, special measures have been taken,",
      "Far from losing the venomous nature he possessed during his lifetime,",
      "The workmanship is even more bewitching. expensive",
      "In addition to magical power, attacks with countless fairy flowers are a threat.",
      "He is also very good at using whips and mental attacks using pollen.",
      "She's a troublesome doll.",
      "",
      "Artist: UN_DO",
    ],
    759 => [
      "An autonomous puppet belonging to a puppet circus. huge speed",
      "Prepare a car and play music and announcements",
      "is the role of Speakers as sonic weapons",
      "can also be used to generate destructive sound waves, as well as special",
      "It is also possible to influence the minds of humans and monsters with sound waves.",
      "It is called Kiru. Therefore, even when attacking a town,",
      "Although it is a support mission, it can also be converted into a front-line force.",
      "It becomes.",
      "",
      "Since the power is human semen, an artificial woman for supply",
      "Equipped with utensils. It also allows sound waves and heavy vibrations to pass through it.",
      "It is possible to shake it to the core of the penis inside the mouth.",
      "Provides dynamic stimulation, leads to continuous climax, and squeezes out all the semen",
      "It is said that",
      "",
      "Artist: UN_DO",
    ],
    760 => [
      "A super-large autonomous puppet that belongs to the puppet circus. the girl",
      "She is a model, and her personality is pure innocence.",
      "However, he also has destructive urges and sadism, and has a large body.",
      "Extremely dangerous, who freely destroys the surroundings by swinging",
      "It's a doll. Because it is huge, it is sturdy, and its power is tremendous.",
      "Powerful enough to be used as a siege weapon",
      "Although he has a very fickle personality,",
      "Sometimes I give up my duties and go somewhere else.",
      "That's what it means.",
      "",
      "She loves playing with people like dolls, and her partner is a man.",
      "If it's sex, play a sexual prank out of curiosity.",
      "It's coming. An artificial woman wrapped in giant pants",
      "If a man is screwed into a container, he will lose his breath.",
      "It's going to be. Most of the time, while playing",
      "It is said that the person on the other end will suffocate. True to the person",
      "It's not really malicious, but it's extremely dangerous.",
      "",
      "Artist: UN_DO",
    ],
    761 => [
      "A Monster Lord doll created by Kagetsumugi using the corpses of past Monster Lords.",
      "One of them. The bodies of the 11th and 12th were severely damaged.",
      "Unite the world and decorate the circus",
      "There is. However, most of the characteristics of the 11th and 12th generation during their lifetime were",
      "Can't be inherited, has strong physical performance and two linked attacks",
      "It is a doll that only fights. autonomous drive system",
      "However, the thought link between the two bodies did not go well and he was mentally destroyed.",
      "It has collapsed. Frankly speaking, it was a failure, but the shadow",
      "Tsumugi does not admit failure and says, 'Insanity and imbalance are interwoven.'",
      "He claims that the theme is 'Eggplant Dissonance.'",
      "",
      "Artist: UN_DO",
    ],
    762 => [
      "Eyes on the titty fuck doll developed in Grangold",
      "A doll that Ketakage Tsumugi has strengthened and mass-produced using its own unique technology.",
      "Attacked civilians during urban warfare and gave them titty fucks",
      "It is said that the purpose was to trap her and kidnap her.",
      "Ru. Defensive fire to protect yourself for deployment on the battlefield",
      "It is also equipped with a weapon and has the minimum combat ability.",
      "Uda. The luxurious dress is handmade by Kagetsumugi and is gorgeous.",
      "At the same time, it also has high bulletproof and blade-proof performance. autonomy",
      "Although it is a type and has its own will, its thinking is very simple.",
      "He is simple and basically just carries out his mission faithfully.",
      "It is.",
      "",
      "When a human male is discovered, a large arcade specializing in restraints appears.",
      "Captured in mu. Enlarge the male genitals while hugging him",
      "She pinches it between her breasts and starts titty fuck. yes",
      "Then the man could no longer resist the sweet pleasure and ate it five times.",
      "If you let him ejaculate, he will become completely weak. like this",
      "After incapacitating the man, he takes him back to the doll factory.",
      "It is said that Kagetsumugi does not use men's bodies as doll parts.",
      "Therefore, the captured man faces the fate of being expunged.",
      "It is.",
      "",
      "Artist: Cool Cultist",
    ],
    763 => [
      "A pleasure-type autonomous doll belonging to the puppet circus. ultimate",
      "In order to develop a pleasure doll (later pleasure doll Miyabihime),",
      "A test model prototyped as an experimental machine. thus",
      "The completed Love Mata will provide useful data and stimulate imagination.",
      "Because the performance was better than expected, it was mass produced.",
      "It is said that it became. His outstanding Sexcraft SKL are his opponent",
      "It brings people to climax and makes them powerless, regardless of their race or gender.",
      "I'll let you go. Tai is a warrior who is strong in battle but weak in pleasure.",
      "He achieved great results against the demons of Pu.",
      "That's what it means.",
      "",
      "In particular, her Sexcraft SKL against human men are outstanding, and she is extremely talented.",
      "Use the above SKL to immerse yourself in the pleasures of Peach. deer",
      "The man melts in ecstasy and is abducted, leaving the shadow of Tsumugi.",
      "She ends up dying after being squeezed out of semen in a doll workshop.",
      "The road is waiting.",
      "",
      "Artist: UN_DO",
    ],
    764 => [
      "A Monster Lord doll created by Kagetsumugi using the corpses of past Monster Lords.",
      "One of them. Because she is the younger sister of Black Alice,",
      "The appearance is also finished to resemble Alice in Black. sister",
      "For the person who hated it with all his heart, there was no difference in his dissatisfaction.",
      "do not have. In addition to his outstanding ability to manipulate darkness,",
      "His prowess with the spear, which he had hoped for, is also comparable. Monster Lord doll",
      "Among them, Kagetsumugi is proud of its outstanding cutting ability.",
      "It is one body.",
      "",
      "Artist: UN_DO",
    ],
    765 => [
      "A ghost puppet that belongs to the puppet circus. necromancer",
      "A spiritual medium carefully created by Kagetsumugi, who has the knowledge of",
      "The soul of the famous necromancer Blavatsky from the past in a doll",
      "It is something that is possessed by. Therefore, Blavatsky",
      "He is also capable of necromancy and summons countless ghost dolls.",
      "They come to us and use them. Furthermore, Kagetsumugi is a soul-filled",
      "It appears that they have also succeeded in mass producing Blavatsky dolls.",
      "",
      "Since she's a ghost, she can exploit a man's spirit if she touches him.",
      "Or you can extract the semen through the doll you are using.",
      "Noh. She always keeps a doll for absorbing energy, and",
      "If I ever capture one, I'll let that doll fuck me and cum.",
      "It is said that it will be taken away.",
      "",
      "Artist: UN_DO",
    ],
    766 => [
      "A Monster Lord doll created by Kagetsumugi using the corpses of past Monster Lords.",
      "One of them. He is praised as a Monster Lord who is as beautiful as a celestial maiden.",
      "Kagetsumugi tried to recreate the beauty of her life as much as possible.",
      "It is said that it was finished in a form that makes it appear. Due to the influence of his mother, he has special characteristics as a dragon.",
      "It shows great quality and is physically extremely strong. the",
      "His skilled sword SKL have deteriorated even slightly compared to when he was alive.",
      "He says he's not there.",
      "",
      "Artist: UN_DO",
    ],
    767 => [
      "One of Kagetsumugi's proud masterpieces. Strength as a weapon",
      "It is finished with the theme of",
      "It's more like an android. The best that was built into my whole body",
      "The latest firearms are powerful enough to scorch the battlefield.",
      "Yes, the whole body is protected with composite armor made of new materials. Original setting",
      "It also has extremely high mobility due to its magic furnace. Exactly",
      "It possesses combat capabilities worthy of the name of a decisive battle weapon.",
      "However, even Kagetsumugi has a high cost machine of this level.",
      "Unable to mass produce, participates in circus group",
      "Instead, he is entrusted with the defense of the Doll Tower, which is his base.",
      "",
      "The pseudo-female genitalia for energy supply is also high-performance,",
      "The penis in her mouth gives her extreme pleasure, and she is stunned.",
      "In the meantime, squeeze out the semen. Fully operating sperm extraction function",
      "If you let it, you will be able to suck up all the man's essence in one minute.",
      "He comes, but of course the person who has been squeezed out dies.",
      "It will probably end up.",
      "",
      "Artist: UN_DO",
    ],
    768 => [
      "One of Kagetsumugi's proud masterpieces. The ultimate pleasure doll",
      "This is a supreme doll made without considering the cost.",
      "be. Carefully selected based on the experience of the experimental machine Love Marta.",
      "Its body is made up of the finest living tissues. The elasticity of soft meat",
      "The texture of their skin is said to be more lustrous than that of any living creature.",
      "It has reached the limit. The Sexcraft SKL you have learned are advanced lewd demons.",
      "It is also possible to surpass the crowd and overwhelm the group with pleasure alone.",
      "It is called Noh. However, it is too expensive to mass produce.",
      "A difficult and barely produced few were made by puppeteers.",
      "It is only installed in the tower.",
      "",
      "Naturally, the structure of the pseudo-female genitalia is extremely sophisticated and attracts men.",
      "Variety of things such as making you go crazy and melting in ecstasy.",
      "It is possible to be blamed. The internal pressure and movement can be freely controlled, and the feeling",
      "If it becomes a penis, it will crush the penis wrapped around it, and the folds will be crushed.",
      "It is said that even torture such as wearing down the body through physical exercise is possible.",
      "Many men are held by this pleasure doll and release their semen.",
      "He is now out of breath. By sucking the lives of many people",
      "It is an extremely dangerous doll with enhanced magical properties.",
      "",
      "Artist: UN_DO",
    ],
    769 => [
      "The ultimate puppet created by a certain genius puppeteer.",
      "Taka's puppet. But it was too complete",
      "Because of this, he has a sense of self and recognizes himself as a puppeteer. that",
      "He finally killed the creator who did not recognize him, and created 'Kagetsumugi'.",
      "It takes away its name. From then on, I focused on myself.",
      "He continued to modify his body, and his technical ability was unparalleled in this day and age.",
      "It has reached the point where there is no one left. Became the third god",
      "After his talent was discovered by Black Alice, he became a member of Chaos.",
      "We even use technology to do that. To own ego replication and parallel thinking",
      "It even goes into areas that ignore ethics, such as physical manipulation.",
      "The search is progressing.",
      "",
      "When doll makers create dolls, they always leave imperfections.",
      "He says he will keep it. Once you create a perfect doll,",
      "It is said that it has a soul in it. existence of shadow pongee",
      "This is a tragedy because we created the ultimate doll.",
      "It might be.",
      "",
      "Artist: UN_DO",
    ],
    770 => [
      "A puppet created by Kagetsumugi for her own control.",
      "One of them. During the operation, Yomigumo, Kaiko,",
      "It is made so that you can control all three Rantengu bodies at the same time.",
      "Ru.",
      "The Yomigumo has eight legs, each of which can work independently.",
      "Can be used as a working weapon. Ability to eject more thread",
      "The powerful and agile spider's movements can be fully trained.",
      "available. It is also extremely strong and can be used as a shield.",
      "It is said that it is possible to extremely complex structure",
      "Therefore, it can only be controlled by Kagetsumugi.",
      "Although it does have an autonomous function, it is only an auxiliary function.",
      "Things. Unable to think complexly on his own, always in the shadow of Tsumugi.",
      "I surrender myself to manipulation.",
      "",
      "Artist: UN_DO",
    ],
    771 => [
      "A puppet created by Kagetsumugi for her own control.",
      "One of them. During the operation, Yomigumo, Kaiko,",
      "It is made so that you can control all three Rantengu bodies at the same time.",
      "Ru.",
      "Kaiko Kitsune are dolls made based on the highest-ranking demon foxes.",
      "It has excellent agility as a magical beast. Fang and",
      "The ATK of its claws is high, and its long tail can also be used as a weapon.",
      "Also, using the magical power sent by Kagetsumugi, he activates Taoism.",
      "It is also possible to do so. extremely complex structure",
      "Therefore, it can only be controlled by Kagetsumugi.",
      "Although it does have an autonomous function, it is only an auxiliary function.",
      "Things. Unable to think complexly on his own, always in the shadow of Tsumugi.",
      "I surrender myself to manipulation.",
      "",
      "Artist: UN_DO",
    ],
    772 => [
      "A puppet created by Kagetsumugi for her own control.",
      "One of them. During the operation, Yomigumo, Kaiko,",
      "It is made so that you can control all three Rantengu bodies at the same time.",
      "Ru.",
      "Rantengu is a small tengu person whose main purpose is support and reconnaissance.",
      "shape. Although it is weak, it moves very quickly and uses the magic power of Kagetsumugi.",
      "Through this, various Taoism SKL can be used. Also two other bodies",
      "Compared to other people, they have a higher level of self-esteem and are capable of complex thinking.",
      "Not only can we have a conversation, but we can even joke about it.",
      "say.",
      "",
      "Artist: UN_DO",
    ],
    773 => [
      "A high-ranking succubus who aspires to be a dancer. Gathering in a caravan",
      "He lives in a group and wanders around the demon world. nobility",
      "Many of them were originally from",
      "Many people were seen fleeing the city in search of freedom.",
      "It is said that",
      "As you travel through the demon world, you need to have high combat SKL to protect yourself.",
      "stomach. Suppleness that comes out of a well-trained body",
      "These movements are useful in battle and can produce various effects.",
      "Make fun of your enemies with your dancing. Also use the charm SKL",
      "Since they are eggplants, you can easily repel bandits.",
      "I can do it.",
      "",
      "When she sees a man on a trip, she seduces him and ends up inviting him out.",
      "It mixes with its prey and exploits its spirit. quality prey",
      "takes her back to camp, gang rapes her with all her friends,",
      "It is said that it will satisfy your hunger. The way they behave is emotional.",
      "It's hot and it's time to be squeezed out until morning.",
      "No doubt. However, he dies because he is not an evil demon.",
      "It is said that it will never be squeezed out.",
      "",
      "Artist: Setouchi",
    ],
    774 => [
      "An ancient and highest class insect demon that lives in the demon world. exist in the world",
      "Most of the insect demons are species that diverged from this Pavilsag.",
      "It is said to be a tribe. The genes of various insects are in its body",
      "It is sleeping, and its ATK with sickle and tail is very high. Ma",
      "The shell that covers its entire body is also strong, making it a match for ordinary monsters.",
      "He boasts incredible fighting ability. as an ancient species",
      "Although he is proud and has a high level of dignity, he does not spend much time in the city.",
      "It seems that they do not live there and live freely in the wild.",
      "",
      "There aren't many men who are suitable for those glasses, but when it comes down to it,",
      "If you see someone entering, they will aggressively attack you.",
      "and bring them into mating. Copulation that also serves as ejaculation lasts all night.",
      "It is said that the man's semen is squeezed out. intentional",
      "Although it's not, I can't stand the intense mating and the night is over.",
      "It is said that many men are already dead by the time dawn breaks. like this",
      "Pavilsag, which has been seeded by",
      "Choose freely from among the genes and give birth to countless children.",
      "It comes out.",
      "",
      "Artist: Setouchi",
    ],
    775 => [
      "Using a SKL called eclipse magic, a sperm-squeezing worm is placed on the body.",
      "The girls who stayed there. Many of them have a passion for semen extraction and sadism.",
      "He was robbed and turned into a wandering being in search of a man.",
      "Ru. It uses tentacles that grow from its entire body to torture its enemies with pleasure.",
      "Or you can attack by swinging it like a whip.",
      "",
      "Its sperm-squeezing behavior is very special, and it uses its tentacles to extract male sperm.",
      "It takes away not only the liquid but also the ability to produce sperm.",
      "Tiny tentacles pass through the urethral opening, and the fertilizing organ itself",
      "It is said to be dissolved and absorbed. At that time",
      "The pleasure a man experiences is extraordinary and lasts a lifetime.",
      "You can enjoy the pleasure of ejaculation. But then wait",
      "What we are living is a life without seeds and with no offspring.",
      "Ru.",
      "",
      "Where are the girls called Maneaters?",
      "It is unknown whether the tentacles were planted by Once upon a time",
      "A female magician who is a group of girls who lived in the same village and is said to be the ally.",
      "It seems that there was a master, but the Maneaters in question also have no memories.",
      "It has been lost, and the truth of the matter is unknown.",
      "",
      "Artist: Akazawa RED",
    ],
    776 => [
      "An ancient species of dragon that lives in the demon world. all sorts of demons",
      "He is one of the oldest of all things, and is a master of the demon world at its dawn.",
      "They are said to be people in the know. Its ability is extremely high,",
      "There is no gap at all in both offense and defense. Fire and cold breath are extremely",
      "It is extremely powerful and has the power to summon lightning. weather",
      "It is possible to even manipulate spirits, and their natural sensitivity is similar to that of spirits.",
      "It is said that it is also close. Excellent intelligence, but only in remote areas",
      "They live in the world and often interact with humans as well as other monsters.",
      "It doesn't seem like it.",
      "",
      "I rarely meet humans, but when I see a man",
      "Then, I am driven by a desire for semen. Should I just attack my prey?",
      "It is said that he wraps his long body around her and rapes her. long",
      "Sometimes he is raped for three days and three nights, but the dragon's help",
      "Perhaps because of Mamoru, the man never runs out of energy. Dealing with dragons",
      "After fulfilling his mission, the man was returned to his hometown in a weakened state.",
      "It is said that",
      "In the past, people from nearby villages used to grow to bring rain.",
      "It seems that young men were often sent as sacrifices.",
      "The reason why they started living in remote and remote areas was because of this.",
      "It is also said that he became fed up with it.",
      "",
      "Artist: Setouchi",
    ],
    777 => [
      "Subjugated by Luka's party and expelled from the succubus village.",
      "The Queen Succubus became a wanderer. heaven",
      "In the demon world, which is in turmoil due to the battle with",
      "Everyone, even the people of the succubus village, have completely forgotten.",
      "I was taken away.",
      "Everywhere he went was engulfed in war and he tried to escape, but eventually",
      "They end up in the Safar Desert at the far end of the west.",
      "While living a lonely camp life, I am still trying to find a way to make a comeback.",
      "He is dreaming of an opportunity.",
      "",
      "Artist: kupala",
    ],
    778 => [
      "One of the four great spirits that exist in the demon world, and controls the earth.",
      "Spirit. He lives in the ruins of the Safar Desert and has a conversation partner.",
      "I'm looking forward to it coming. Sly made of mud",
      "It has a mu-like body and can change forms at will. Mud like a tsunami",
      "In addition to being able to handle it like a sea urchin, it also has a DEF if hardened.",
      "His fighting ability is also extremely high, and his combat ability is surprisingly high. very",
      "I like to talk, and if you leave me alone, I can talk for hours.",
      "Continue talking smoothly. However, the land of Sabasa is supported by Hiruko.",
      "This is because no monsters or travelers can set foot there.",
      "So, I have almost no one to talk to and I am at a loss. Na",
      "If Hiruko's sphere of influence was a little wider, Safar",
      "The monsters living in the desert ruins and Loa herself were also preyed upon.",
      "Probably.",
      "",
      "Since no one stops by, there are no opportunities for sperm extraction.",
      "are. Can you live without ingesting semen?",
      "When the time comes to extract the sperm, she wraps it in her muddy body.",
      "It will be crowded and violently squeezed out.",
      "",
      "Artist: frfr",
    ],
    779 => [
      "A fragment of flesh from Hiruko,",
      "one of the Six Ancestors, used to",
      "create a split body. Although its",
      "abilities are inferior to the",
      "original, it still possesses power",
      "surpassing that of high-level",
      "monsters. Its gluttonous nature",
      "remains unchanged, allowing it to",
      "engulf and devour opponents larger",
      "than itself. Hiruko can create",
      "more than ten thousand of these",
      "split bodies at the same time,",
      "showcasing just a fraction of her",
      "immense power.",
      "",
      "Artist: Shiki",
    ],
    780 => [
      "A senior magician who is ranked among the top three in the demon world. scheme",
      "It is also famous as a home where Ilias and his group entered the monster realm.",
      "When it is absorbed, Mephisto of the singularity world",
      "After capturing it, he succeeded in taking his place.",
      "From then on, he not only informed Tamamo of the group's strategy, but also...",
      "Guide the operation itself to suit the Dark Goddess army's convenience.",
      "It's also happening.",
      "",
      "Born in a world more devastated than the singularity world or the monster realm.",
      "Because of his upbringing, his magical power is similar to Mephis in the singularity world.",
      "Much better than strike. Magic that only exists in the monster realm",
      "It is said that he is also familiar with",
      "",
      "Artist: UN_DO",
    ],
    781 => [
      "A train-type artificial demon running in the demon world. Originally a customer",
      "It was a non-combat vehicle used to transport personnel, but it entered the railroad tracks.",
      "Accumulate experience points while bouncing away monsters.",
      "The level has increased considerably, and the combat ability has also increased significantly.",
      "do. Still, it is not only a train robbery, but also a test of skill.",
      "There were also people showing off their strength and trying to stop the train from the front.",
      "It is said that the violence on the tracks is intolerable.",
      "",
      "The power source is human semen, so it is squeezed into one of the vehicles.",
      "Equipped with sophisticated equipment. Pack a man in there.",
      "If he could keep running for half a month until he ran out of energy.",
      "It is calculated that it will be possible. In the demon world where the value of human life is low",
      "transport infrastructure that operates at extremely low costs.",
      "It is of great help.",
      "",
      "Artist: xelvy",
    ],
    782 => [
      "The highest-ranking elders of the Baphomet clan.",
      "Their bodies become rejuvenated and their mental vitality is restored.",
      "are. However, the magical power is very high, and it is normal.",
      "Possessing power incomparable to Baphomet.",
      "It is said that there is Lost magical knowledge and philosophy,",
      "Rui is well versed in natural science and is truly an elder statesman.",
      "He has the wisdom appropriate for his position. Baphomet",
      "He is widely respected not only by To, but also by other monsters.",
      "It is said that there is",
      "",
      "She loves young men, and every man who is dedicated to her by her family is always",
      "Have a taste. If you like it, spend three days and nights studying it.",
      "It seems like you can fully enjoy it. Due to intense ejaculation, the man",
      "It is said that it weakens the body, but does not take away one's life.",
      "",
      "Artist: Alexi",
    ],
    783 => [
      "A young elf who is in the spotlight as a new generation of elves.",
      "A group of Ruffs. Turning away from traditional elf values,",
      "Rather, it is the popular culture of urban people, especially youth literature.",
      "They are a group of people who are committed to becoming called a smartphone",
      "He carries the latest small Machina and speaks with a strange accent.",
      "Compared to the rogue elves, the high-ranking demon aristocrats frowned.",
      "is hidden. their children will not be affected",
      "However, contact is strictly prohibited.",
      "Since there are many daughters of high-ranking elves, their fighting power is also extraordinary.",
      "It is. He even masters the traditional elf archery SKL.",
      "External enemies and old people who try to rehabilitate are ruthlessly beaten down.",
      "It is said that it will be lost. They are understanding and understand their own values.",
      "I am on good terms with the Hibaphomets who respect my values.",
      "seems to be good.",
      "",
      "She loves raping young men and forcibly abducting them is the opposite.",
      "bring it to rape. Sometimes friends join in and we have an orgy",
      "It is not uncommon for the condition to occur. a man is squeezed to death",
      "Although this is not the case, I have ejaculated repeatedly and am unable to stand on my legs.",
      "It will probably be in a state.",
      "",
      "Artist: Usuki",
    ],
    784 => [
      "Hiruko is one of the six daughters",
      "created by the Dark Goddess",
      "herself and one of the Six",
      "Ancestors, who are the progenitors",
      "of all monsters in this world. The",
      "Six Ancestors hold the pinnacle of",
      "power and combat ability in the",
      "Monster Realm and are its sole",
      "rulers. Hiruko is considered the",
      "progenitor of tentacle monsters",
      "and is closely related to the",
      "scylla lineage, although her",
      "nature is so unique that her exact",
      "classification remains unclear.",
      "Her entire body is made up of",
      "tentacles that function as",
      "digestive organs, allowing her to",
      "morph, expand, and split at will.",
      "She boasts overwhelming vitality",
      "and an insatiable appetite, making",
      "her the most feared among the Six",
      "Ancestors.",
      "",
      "After the Great Monster Wars,",
      "Hiruko was entrusted by the Dark",
      "Goddess to govern Sabasa. However,",
      "within a year, she devoured the",
      "residents, the land, and even the",
      "castle itself, unable to control",
      "her hunger. Feeling both ashamed",
      "before the Dark Goddess and",
      "intrigued, she used the genetic",
      "information from those she",
      "consumed to pseudo-recreate the",
      "residents as her split bodies,",
      "reconstructing the castle town of",
      "Sabasa within her own body.",
      "However, this space has",
      "transformed into something clearly",
      "abnormal.",
      "",
      "Artist: Shiki",
    ],
    785 => [
      "A Monster Lord doll created by Kagetsumugi using the corpses of past Monster Lords.",
      "One of them. She is the daughter of Saja and has strong Dark Goddess blood.",
      "Because he is a Monster Lord, he has a chic design and color scheme.",
      "being admired. Highly decorative and yet practical",
      "The combination of left and right wings is the most heart-warming thing for Kagetsumugi.",
      "This seems to be an appealing point.",
      "",
      "The Monster Lord doll was completed in this way, but it was of inferior grade.",
      "By using materials and core duplication technology, a small number of",
      "However, mass production was successful. As a final trump card, my master's",
      "It is deployed at the Black Mansion, which is the base.",
      "",
      "Artist: UN_DO",
    ],
    786 => [
      "A Monster Lord doll created by Kagetsumugi using the corpses of past Monster Lords.",
      "One of them. Insects, snakes, and De as a magician",
      "It fuses Zain. Kagetsumugi completed it first",
      "It is a Monster Lord doll, and although there are still many points that are lacking.",
      "The technology for the subsequent Monster Lord doll series was established.",
      "In that sense, it is of great value.",
      "",
      "The Monster Lord doll was completed in this way, but it was of inferior grade.",
      "By using materials and core duplication technology, a small number of",
      "However, mass production was successful. As a final trump card, my master's",
      "It is deployed at the Black Mansion, which is the base.",
      "",
      "Artist: UN_DO",
    ],
    787 => [
      "A Monster Lord doll created by Kagetsumugi using the corpses of past Monster Lords.",
      "One of them. The body is held in Yamatai as a sacred object.",
      "Because it was enshrined in a village in the region, there was almost no pain.",
      "Obtained without. Fully utilize the power of the dragon that sleeps within you.",
      "It has particularly high fighting ability among the Monster Lord dolls.",
      "It became a masterpiece.",
      "",
      "The Monster Lord doll was completed in this way, but it was of inferior grade.",
      "By using materials and core duplication technology, a small number of",
      "However, mass production was successful. As a final trump card, my master's",
      "It is deployed at the Black Mansion, which is the base.",
      "",
      "Artist: UN_DO",
    ],
    788 => [
      "A Monster Lord doll created by Kagetsumugi using the corpses of past Monster Lords.",
      "One of them. He is praised as a Monster Lord who is as beautiful as a celestial maiden.",
      "Kagetsumugi tried to recreate the beauty of her life as much as possible.",
      "It is said that it was finished in a form that makes it appear. Due to the influence of his mother, he has special characteristics as a dragon.",
      "It shows great quality and is physically extremely strong. the",
      "His skilled sword SKL have deteriorated even slightly compared to when he was alive.",
      "He says he's not there.",
      "",
      "The Monster Lord doll was completed in this way, but it was of inferior grade.",
      "By using materials and core duplication technology, a small number of",
      "However, mass production was successful. As a final trump card, my master's",
      "It is deployed at the Black Mansion, which is the base.",
      "",
      "Artist: UN_DO",
    ],
    789 => [
      "A Monster Lord doll created by Kagetsumugi using the corpses of past Monster Lords.",
      "One of them. Black Alice's mother whom Kagetsumugi adores",
      "Therefore, special measures have been taken,",
      "Far from losing the venomous nature he possessed during his lifetime,",
      "The workmanship is even more bewitching. expensive",
      "In addition to magical power, attacks with countless fairy flowers are a threat.",
      "He is also very good at using whips and mental attacks using pollen.",
      "She's a troublesome doll.",
      "",
      "The Monster Lord doll was completed in this way, but it was of inferior grade.",
      "By using materials and core duplication technology, a small number of",
      "However, mass production was successful. As a final trump card, my master's",
      "It is deployed at the Black Mansion, which is the base.",
      "",
      "Artist: UN_DO",
    ],
    790 => [
      "A Monster Lord doll created by Kagetsumugi using the corpses of past Monster Lords.",
      "One of them. Because she is the younger sister of Black Alice,",
      "The appearance is also finished to resemble Alice in Black. sister",
      "For the person who hated it with all his heart, there was no difference in his dissatisfaction.",
      "do not have. In addition to his outstanding ability to manipulate darkness,",
      "His prowess with the spear, which he had hoped for, is also comparable. Monster Lord doll",
      "Among them, Kagetsumugi is proud of its outstanding cutting ability.",
      "It is one body.",
      "",
      "The Monster Lord doll was completed in this way, but it was of inferior grade.",
      "By using materials and core duplication technology, a small number of",
      "However, mass production was successful. As a final trump card, my master's",
      "It is deployed at the Black Mansion, which is the base.",
      "",
      "Artist: UN_DO",
    ],
    791 => [
      "A Monster Lord doll created by Kagetsumugi using the corpses of past Monster Lords.",
      "One of them. The theme is 'erosion of time',",
      "She is intentionally reduced to a girl's appearance. time magic",
      "In addition to dark SKL, attacks that utilize insect demon organs are very effective.",
      "Powerful. In addition, the DEF is high due to the insect shell, and the magician",
      "It is very sturdy for a doll of this type.",
      "",
      "The Monster Lord doll was completed in this way, but it was of inferior grade.",
      "By using materials and core duplication technology, a small number of",
      "However, mass production was successful. As a final trump card, my master's",
      "It is deployed at the Black Mansion, which is the base.",
      "",
      "Artist: UN_DO",
    ],
    792 => [
      "A Monster Lord doll created by Kagetsumugi using the corpses of past Monster Lords.",
      "One of them. The bodies of the 11th and 12th were severely damaged.",
      "Unite the world and decorate the circus",
      "There is. However, most of the characteristics of the 11th and 12th generation during their lifetime were",
      "Can't be inherited, has strong physical performance and two linked attacks",
      "It is a doll that only fights. autonomous drive system",
      "However, the thought link between the two bodies did not go well and he was mentally destroyed.",
      "It has collapsed. Frankly speaking, it was a failure, but the shadow",
      "Tsumugi does not admit failure and says, 'Insanity and imbalance are interwoven.'",
      "He claims that the theme is 'Eggplant Dissonance.'",
      "",
      "The Monster Lord doll was completed in this way, but it was of inferior grade.",
      "By using materials and core duplication technology, a small number of",
      "However, mass production was successful. As a final trump card, my master's",
      "It is deployed at the Black Mansion, which is the base.",
      "",
      "Artist: UN_DO",
    ],
    793 => [
      "A Monster Lord doll created by Kagetsumugi using the corpses of past Monster Lords.",
      "One of them. Despite being a modern Monster Lord, very",
      "There is little folklore, and Kagetsumugi took a lot of time to search for the body.",
      "say. As a result, he was buried in a certain garden.",
      "discovery. Shadow Tsumugi was inspired by the sight of the garden.",
      "It was finished in this form after receiving a lot of attention.",
      "",
      "The Monster Lord doll was completed in this way, but it was of inferior grade.",
      "By using materials and core duplication technology, a small number of",
      "However, mass production was successful. As a final trump card, my master's",
      "It is deployed at the Black Mansion, which is the base.",
      "",
      "Artist: UN_DO",
    ],
    794 => [
      "A Monster Lord doll created by Kagetsumugi using the corpses of past Monster Lords.",
      "One of them. It is said that he was full of childishness and playfulness.",
      "In keeping with the legend, she is depicted as a girl. magician",
      "type, special to reproduce tremendous magical power.",
      "It is said that it has a built-in magic furnace.",
      "",
      "The Monster Lord doll was completed in this way, but it was of inferior grade.",
      "By using materials and core duplication technology, a small number of",
      "However, mass production was successful. As a final trump card, my master's",
      "It is deployed at the Black Mansion, which is the base.",
      "",
      "Artist: UN_DO",
    ],
    795 => [
      "Kagetsumugi, who lost all her body reserves, is left with the remaining materials.",
      "The final body created by bringing together. destroyed yellow",
      "Parts of Izumigumo and Sakiko are also used, and the battle",
      "The ability itself has greatly improved compared to the previous body.",
      "are. However, her appearance matches Kagetsumugi's aesthetics.",
      "Personally, I think it's a result that leaves me very dissatisfied.",
      "There are no spare parts, and it is completely one-of-a-kind.",
      "It has a custom body.",
      "",
      "Also, the fuel consumption is very bad, and the battle only lasts for an hour.",
      "However, the energy equivalent to the semen of 10 adult men",
      "- is required. In order to operate at full capacity, many people must",
      "A very heinous decision that required a man to be squeezed to death.",
      "It is a war body.",
      "",
      "Artist: UN_DO",
    ],
    796 => [
      "Kagetsumugi's last puppet, the destroyed Yomigumo and Kaiko,",
      "Parts of Rantengu have been inherited. The nature of these three bodies",
      "It surpasses Noh and boasts overwhelming combat ability, but it is used for decisive battles.",
      "As the cost is not considered, the same doll",
      "It is said that it will never be built again. AGI is extremely high",
      "Its armor is strong, and it can use powerful taoism repeatedly.",
      "be. Collaboration with Kagetsumugi final type is also incorporated into the AI.",
      "The two of them will perform a combined attack.",
      "possible. Semi-autonomous, but still complex",
      "I can't seem to think.",
      "",
      "Also, fuel efficiency is extremely poor, and many men are required to operate it.",
      "It takes the spirit of Leaning on the man, like mating",
      "Replenish semen by raping the other person until the other person runs out of energy.",
      "The ejaculation continues mercilessly. A decisive battle with Kagetsumugi",
      "By the time I left, I had absorbed a considerable number of human spirits.",
      "It's like a sinister doll that moves by sucking human life.",
      "It belongs to",
      "",
      "Artist: UN_DO",
    ],
    797 => [
      "The eighth Monster Lord who became the third god. was originally provided",
      "Destructive tendencies become even more so as they incorporate chaos.",
      "Accelerate to. I can no longer enjoy the end of all parallel worlds.",
      "He has become a destructive transcendent.",
      "Can manipulate holy power and dark power at the same time, and is able to interact with God.",
      "It possesses tremendous power that is comparable to that of other people. Alone",
      "It is also possible to destroy the world, and it is currently confirmed that",
      "Of all the threats that exist, it is one of the greatest.",
      "Ru.",
      "",
      "Artist: Setouchi",
    ],
    798 => [
      "To eliminate intruders from the forbidden area of ​​chaos, automatic",
      "Generated removal system. Constructed based on data from Hakuto",
      "Although the ego is not equipped, it is extremely",
      "Boasts high fighting ability. Erase the intruder or",
      "On the other hand, Rui will continue to move automatically until it is destroyed.",
      "say.",
      "",
      "Artist: Shiruku",
    ],
    799 => [
      "To eliminate intruders from the forbidden area of ​​chaos, automatic",
      "Generated removal system. Constructed based on data from Hakuto",
      "Although the ego is not equipped, it is extremely",
      "Boasts high fighting ability. Erase the intruder or",
      "On the other hand, Rui will continue to move automatically until it is destroyed.",
      "say.",
      "",
      "Artist: Shiruku",
    ],
    800 => [
      "To eliminate intruders from the forbidden area of ​​chaos, automatic",
      "Generated removal system. Constructed based on data from Hakuto",
      "Although the ego is not equipped, it is extremely",
      "Boasts high fighting ability. Erase the intruder or",
      "On the other hand, Rui will continue to move automatically until it is destroyed.",
      "say.",
      "",
      "Artist: Shiruku",
    ],
    801 => [
      "To eliminate intruders from the forbidden area of ​​chaos, automatic",
      "Generated removal system. Constructed based on Reaper data",
      "Although the ego is not equipped, it is extremely",
      "Boasts high fighting ability. Erase the intruder or",
      "On the other hand, Rui will continue to move automatically until it is destroyed.",
      "say.",
      "",
      "Artist: Shiruku",
    ],
    802 => [
      "To eliminate intruders from the forbidden area of ​​chaos, automatic",
      "Generated removal system. Constructed based on Reaper data",
      "Although the ego is not equipped, it is extremely",
      "Boasts high fighting ability. Erase the intruder or",
      "On the other hand, Rui will continue to move automatically until it is destroyed.",
      "say.",
      "",
      "Artist: Shiruku",
    ],
    803 => [
      "To eliminate intruders from the forbidden area of ​​chaos, automatic",
      "Generated removal system. Constructed based on Reaper data",
      "Although the ego is not equipped, it is extremely",
      "Boasts high fighting ability. Erase the intruder or",
      "On the other hand, Rui will continue to move automatically until it is destroyed.",
      "say.",
      "",
      "Artist: Shiruku",
    ],
    804 => [
      "To eliminate intruders from the forbidden area of ​​chaos, automatic",
      "Generated removal system. Hakuto and Reaper data?",
      "It has a double construction, and the appearance is a combination of both.",
      "That's what happened. Although the ego is not equipped, the emergency",
      "Boasts high fighting ability. Erase the intruder or",
      "On the other hand, Rui will continue to move automatically until it is destroyed.",
      "say.",
      "",
      "Artist: Shiruku",
    ],
    805 => [
      "To eliminate intruders from the forbidden area of ​​chaos, automatic",
      "Generated removal system. looks like Sonya",
      "The reason is unknown, but an irregular error occurred in the central part of the extermination system.",
      "It is said that there is a possibility that ra has an influence.",
      "",
      "Artist: xelvy",
    ],
    806 => [
      "Appears to eliminate intruders from the Forbidden Realm of Chaos.",
      "Top exterminated individuals. Avatar of the extermination system itself",
      "It is an existence that can be said to be",
      "It is said to be part of the central system, but details are unknown.",
      "It is clear.",
      "",
      "Artist: xelvy",
    ],
    807 => [
      "A top-class demon belonging to an elite unit under direct control of the Dark Goddess,",
      "But an elite of elites. A mighty demon in the body of a stone statue",
      "Powerful and use the highest level of magic to keep enemies at bay.",
      "do not have. It also has the ability to petrify living things.",
      "It has the strength to live up to its name as an elite unit. In addition",
      "During the battle against the demon star Demiurge, the Dark Goddess's orders",
      "It is deployed within the demon planet by Hiruko, and is said to be Hiruko's subordinate.",
      "That's not true.",
      "",
      "Like other monsters, it is extremely greedy for male spirits. Also,",
      "The lack of sense of time that is unique to high-level demons is also extremely dangerous.",
      "Ru. If she sees me for the first time, I'll be petrified while we're together.",
      "He was given the humiliation of thousands of years of hand play.",
      "It will probably continue.",
      "",
      "",
      "Artist: Alexi",
    ],
    808 => [
      "A top-class demon belonging to an elite unit under direct control of the Dark Goddess,",
      "But an elite of elites. Appeared after the Great Monster Wars",
      "A new kind of monster with angel genes mixed in.",
      "It has been confirmed that A new monster as a race",
      "Despite this, it possesses a power that approaches that of the ancient species.",
      "It is said that his fighting ability with spears is extraordinary.",
      "say. Therefore, he was selected to join the elite force under the direct control of the Dark Goddess.",
      "However, the monsters who are jealous of this say that they are mixed with angels.",
      "It is said that he is being criticized behind his back. In addition, the monster Demiu",
      "During the Battle of Lugos, the demon star was destroyed by order of the Dark Goddess.",
      "He is stationed within the country, and is not Hiruko's subordinate.",
      "do not have.",
      "",
      "Due to its large size, the energy balance is large, and it is",
      "Always greedy. When you meet a man, you stay connected for three days and three nights.",
      "I will never let you go. As a result, the opponent is exhausted.",
      "It is said that they often take their last breath. Taketo naturally",
      "Even though he has a great attitude, he can't control his own desires.",
      "It's a dangerous monster.",
      "",
      "Artist: Setouchi",
    ],
    809 => [
      "Lilith, having lost her sisters",
      "Astaroth and Morrigan, has",
      "returned to her original, true",
      "power. Originally, Lilith was an",
      "exceptionally powerful succubus",
      "created from Minagi. However, due",
      "to her immense magical power being",
      "uncontrollable, she was forced to",
      "split into three beings: Lilith,",
      "Astaroth, and Morrigan, forming",
      "the trio of sisters. With the",
      "deaths of Astaroth and Morrigan,",
      "the divided power has returned to",
      "Lilith, reviving her former self",
      "as the great succubus she once",
      "was.",
      "",
      "The previously unstable magical",
      "power has now stabilized, as",
      "Lilith has enhanced her own",
      "capabilities. However, the anger",
      "and sorrow from losing both her",
      "sisters and Minagi have left her",
      "emotionally unstable. Being",
      "violated by Lilith in her",
      "heightened state would mean",
      "certain death. She would drain",
      "one's life force entirely,",
      "consuming it as mere sustenance",
      "while delivering overwhelming",
      "pleasure, leaving her victims to",
      "perish almost instantly.",
      "",
      "Artist: Shiki",
    ],
    810 => [
      "Erubetie, one of the Four Heavenly Knights of the Monster Lord's Army, is divided into pieces.",
      "body. Naturally, the power of the unit is much inferior to that of the main body.",
      "However, it is still equivalent to or better than advanced slime.",
      "Proud of power. Elbe, a collection of more than 10,000 wills",
      "If it's Tie, there will be hundreds and thousands of fragmented bodies of this level.",
      "It is said that it can be created.",
      "",
      "Artist: Health cross",
    ],
    811 => [
      "Erubetie, one of the Four Heavenly Knights of the Monster Lord's Army,",
      "Incorporating the cells of Ganfu, the ancestor of the Im tribe, a great",
      "A figure with increased power. Vitality and division ability",
      "His power increased explosively, and his fighting ability increased dramatically.",
      "There is. However, the purpose of reinforcement is not for combat, but for singularity.",
      "To incorporate and fuse all of the world's living things. that",
      "As a result, he was under a lot of mental pressure and was in an unstable state.",
      "It seems like it's gone. Just slime brothers",
      "Just for the sake of it, I close my eyes to everything else.",
      "and is moving forward toward his goal.",
      "",
      "Artist: Health cross",
    ],
    812 => [
      "A two-in-one guardian dog worshiped in Yamatai.",
      "Star. An ancient species of demonic beasts with overwhelming physical ability.",
      "Proud of power. Equipped with even higher magical power, powerful Taoism",
      "Can use SKL. Basically friendly towards humans.",
      "It protects weak humans. Therefore, ya",
      "People in the villages and villages of the Matai region consider it like a guardian deity.",
      "It seems to be revered. In addition, the person whose mouth is open",
      "Ah is fierce and active, while Un is gentle and motherly.",
      "",
      "In villages under the protection of Aun, a festival is held once a year.",
      "Then, a young man is chosen who will share the bed with Aun. sacrifice and",
      "Unlikely, you will never lose your life, even for a week.",
      "During this period, you can spend your days full of pleasure, so",
      "It is said that it is the object of admiration for the villagers.",
      "",
      "Artist: Nonhuman Modoki",
    ],
    813 => [
      "A dragon's head appeared on its arm, which is extremely rare.",
      "Dragon tribe. In addition to emitting flame and ice breath from the dragon's head,",
      "The bite attack with its fangs is also extremely powerful. Also a magic swordsman",
      "His skill as a swordsman is also outstanding, and he possesses powerful sword SKL and dragon's SKL.",
      "Linked attacks with the head are extremely powerful. Some are mercenaries",
      "Although they are active as",
      "It seems that he is assigned to guard the Demon Continent.",
      "",
      "The dragon's arms are even more gluttonous than its body, and they look at men.",
      "When I put it on, I want semen. Because of the warrior's pride,",
      "Negotiate with non-combatants to let them extract their semen.",
      "That's what I said. Most men don't refuse and give a large amount in return for pleasure.",
      "It seems that it supplies semen. But from the enemy",
      "If you do too much, the punishment will be severe. limit",
      "It is to squeeze out the essence and sometimes even take away the life.",
      "It is said that there is.",
      "",
      "Artist: Cool Cultist",
    ],
    814 => [
      "A gigantic whale monster that reigns over the ocean. Probably belongs to mermaids",
      "However, its gigantic body produces overwhelming destructive power.",
      "Extrude. If that happens, the magical organs degenerate.",
      "Yes. In addition, there are strong people who do not hesitate to deal with the polluted sea.",
      "It has strength and vitality.",
      "",
      "He has an instinct to patrol the coast, and when he sees a port town, he turns his head.",
      "issue. I was satisfied when I received a warm welcome from the residents there.",
      "Then he quietly leaves. At that time, Monstro",
      "They will give you gifts such as large pearls and rare coral.",
      "So, instead of getting the original cost of hospitality, I ended up losing more than enough money.",
      "It is said that Ri is coming. However, ignoring or being rude",
      "If you take it, it will go wild and the ship will sink.",
      "That's what it means. It will be difficult if you respond incorrectly, but please accept it properly.",
      "In fact, it would be a great blessing for the residents if we welcomed them.",
      "It's a sea beast.",
      "Also, for some reason, he landed on the demon continent and is rampaging.",
      "There is. At times like that, I'm nervous, so don't approach me.",
      "It's better not to have it.",
      "",
      "Artist: Cool Cultist",
    ],
    815 => [
      "A high-grade demon who has been worshiped as a fighting god since ancient times, and a member of the demon world.",
      "But he is a warrior who boasts the most power. His combat SKL are extremely high,",
      "Carry weapons in multiple arms and annihilate enemies with overwhelming force.",
      "Ru. In the region, she is worshiped as the mother goddess.",
      "Even in modern times, its name remains unparalleled.",
      "Always famous. Speaking of powerful monsters, most of the demon world",
      "It is said that the people of India mention the name of Shiva. Many are Dark Goddesss",
      "He is said to have served in a prestigious combat position such as the SS.",
      "cormorant.",
      "",
      "Although he is full of energy and sexual desire, he steps into the evil castle.",
      "There are no men out there, so they are always hungry for men. Tama",
      "During her vacation, she goes to a brothel and squeezes out her sperm to the fullest.",
      "It seems like it is. Sometimes they have too much energy and engage in disorderly behavior.",
      "It can sometimes be a problem. Surprisingly, I am devoted to myself.",
      "Rather than making him serve, he uses his arms to tap the prey's erogenous zones.",
      "I like to pull out and make her writhe in agony. and it overflowed",
      "It is said that semen is the best nectar of all.",
      "",
      "Artist: Makiya",
    ],
    816 => [
      "A senior magician who is ranked among the top three in the demon world. scheme",
      "It is also famous as a home where Ilias and his group entered the demon world.",
      "When it is absorbed, Mephisto of the singularity world",
      "After capturing it, he succeeded in taking his place.",
      "However, it was discovered that he was a spy inside the monster, and...",
      "Somehow he managed to escape.",
      "",
      "From then on, the singularity world that is imprisoned in the Sealed Sinner's Prison.",
      "Watch Mephisto. Luka's party will come to help",
      "was plotting revenge. But that also applies to the pattern.",
      "It can be said that this was an act that lacked calmness.",
      "",
      "Artist: UN_DO",
    ],
    817 => [
      "A complex marine demon that lurks in the deep sea. Sturdy body that can withstand water pressure",
      "and the vitality that defies pollution, as well as a large amount of contact.",
      "Equipped with hands and a strong shell, it is an invincible champion in the deep sea.",
      "reigned supreme. And with the Second Great Monster Wars on the horizon",
      "Now, the Dark Goddess Army is recruiting them as a powerful force. accept the invitation",
      "A strong security force emerges from the sea and protects the Dark Goddess Castle.",
      "It became. In addition, the queen of the deep sea in the singularity world",
      "Kraken and Poseidoness are also this Neptune.",
      "He is said to be a descendant of the tribe. Neptune of the singularity world",
      "Although the N tribe has already perished, the goddess Iria",
      "There is a high possibility that it became extinct due to being targeted by Japanese predators.",
      "",
      "If the Dark Goddess Castle is attacked, it will invade with overwhelming ATK.",
      "repel intruders. If the foreign enemy is a man, a violent attack",
      "There is no doubt that he will be exposed to humiliation. Squeeze out all the semen",
      "After that, it was swallowed whole from the huge mouth of the torso.",
      "It will probably end up.",
      "",
      "Artist: Setouchi",
    ],
    818 => [
      "Although he himself is dead, he has countless undead at his side.",
      "Queen of When he was alive, he was a demon aristocrat who was a necromancer.",
      "However, he has discovered a forbidden SKL that allows him to revive as a powerful undead after death.",
      "Exercise on your body. Tao, who was revived in this way, was sent to countless Zons.",
      "He has come to reign as the king who controls Bi and the others. this",
      "Secret arts were popular for a time, and many demon aristocrats",
      "It is said that he turned into an adult, but due to a failed SKL, he was not revived.",
      "It is said that a considerable number of people did not.",
      "",
      "As an undead, he possesses the power of the pinnacle class, and",
      "You can also use powerful magic. And always be energetic",
      "If you are starving and capture a man, you will be thoroughly",
      "Squeeze out that spirit. The prey dies without exception.",
      "It sucks all the essence out of me and dries up miserably.",
      "Dew.",
      "",
      "Artist: UN_DO",
    ],
    819 => [
      "A giant monster that is said to be a mutation among the plant family.",
      "Tar. Possesses an abnormal level of vitality and extremely strong physical abilities.",
      "Very expensive. It also purifies powerful toxins in the body and breathes",
      "and spread it to the surrounding area. with a strong odor",
      "This breath is considered more dangerous than any poisonous gas.",
      "Ru. A strange odor always wafts from his body, and he avoids other monsters.",
      "Looks like he's being kicked. However, his fighting ability is overwhelming.",
      "Yes, someone who serves as Kanon's bodyguard and the guard of Jashin Castle.",
      "It is said that there are many.",
      "",
      "However, the foul odor emitted by the Malboro girl is a strong pheromonal.",
      "It also contains odors, so if a man smells it,",
      "Although she is writhing in agony from the foul smell, she is sexually aroused. the person's will",
      "The male organ that has become erect while ignoring the",
      "My daughter takes her time to enjoy it. the victim man",
      "Sex repeats ejaculation while writhing in agony due to the foul smell.",
      "It's going to happen. A case where you run out of energy",
      "is by no means small.",
      "",
      "Artist: Mizukichi",
    ],
    820 => [
      "A great demon of the demon world, known as a mighty monster bird. old",
      "It is also famous as a species, and has great power hidden within its body.",
      "are. The first monster created by the Sixth Ancestor, Saja, was Yo.",
      "Lumungand and Archaeopteryx, which",
      "Each strongly expresses the characteristics of a snake and a bird, and lamia and hare",
      "It is said that it was differentiated as P. Archeo",
      "Many of the Pteryx live in the Dark Goddess Castle, but there are",
      "There are also a small number of people who have spread their wings across the world. So",
      "One of them is an army led by Queen Harpy.",
      "He is said to be number two.",
      "",
      "Because he is a powerful being, he treats humans as weak.",
      "Pamper her with her big breasts and have sweet dreams during copulation.",
      "It is said that a communion is held that feels like immersion. Arche",
      "A man who is intoxicated by mating with Opteryx,",
      "I can no longer leave my full body, and I become like a corpse.",
      "After all, it's just a rumor.",
      "",
      "Artist: UN_DO",
    ],
    821 => [
      "A demon aristocrat belonging to Scylla, with immense power and high",
      "An old breed with a strong family status. Unique among the Scylla tribe",
      "He has built his own faction and has a very vocal voice.",
      "Hardline main faction against moderate Queen Scylla",
      "and is treated like a leader of the anti-Queen faction.",
      "However, he never openly disobeys the queen, and is a dark man.",
      "We are firmly maintaining our number two position. But that",
      "In the shadows, he is plotting a political strategy to oust the queen.",
      "It seems so. Also, in the Dark Goddess Castle, Asu, who has the same bloodline,",
      "It is said that the Modeus family lived there as upper class aristocrats.",
      "cormorant.",
      "",
      "Being an ancient species, its power is tremendous and it is still active.",
      "It's as good as Queen Scylla. Also very",
      "He has a cruel personality and treats others, regardless of race, age, or gender.",
      "I take pleasure in seeing him suffer. Insult to human male",
      "It is also extremely violent, and the man dies from exhaustion of semen.",
      "The blame will not be eased until it is done.",
      "",
      "Artist: xelvy",
    ],
    822 => [
      "Created by Saja at the earliest stage, his family status is demonic.",
      "A lamia-type demon aristocrat who is said to be the highest in the world.",
      "Many of them reside in the Dark Goddess Castle, but they are extremely ambitious.",
      "A person who is highly skilled and plans to rise to the top of the Lamia tribe.",
      "There are some too. Under the moderate Queen Lamia",
      "However, it seems that they are plotting to take that position.",
      "He has an extremely arrogant and bellicose personality, and his strength is unparalleled.",
      "is removed. However, since he is not good at plotting,",
      "Of course, he colludes with Asmodeus, the enemy. both",
      "They planned that their master would fall in war, and there was talk of peace.",
      "When he was brought up, he plotted to poison himself at a banquet. that",
      "But now that Asmodeus and Asmodeus are in prison.",
      "It seems like there is.",
      "",
      "Although not cruel, he is extremely greedy and",
      "She devours every man who comes up to her. Of course",
      "I'll fuck you all before I eat you, so I'll swallow it whole.",
      "It is said that it is not uncommon for the child to die before he can take his last breath.",
      "",
      "Artist: xelvy",
    ],
    823 => [
      "The 16th Monster Lord, on par with Black Alice, who is famous as the strongest of all time.",
      "It is said that he has great powers. of the demon world as a Monster Lord",
      "Formed an alliance with the Dark Goddess Army and joined forces to avoid the destruction of the world.",
      "Trying to confront the chaos phenomenon. Riding the evil castle",
      "In order to intercept Luka and his group, he stands in front of them.",
      "Chihadaru may have already predicted the ending.",
      "I don't know.",
      "",
      "Artist: Health cross",
    ],
    824 => [
      "Saja is one of the six daughters",
      "created by the Dark Goddess",
      "herself and one of the Six",
      "Ancestors, who are the progenitors",
      "of all monsters in this world. The",
      "Six Ancestors hold the pinnacle of",
      "power and combat ability in the",
      "Monster Realm and are its sole",
      "rulers. Saja is renowned as the",
      "strongest among them, with beliefs",
      "stating that only she can face the",
      "Angelic Dominion's Micaela or",
      "Lucifina head-on. While her",
      "magical power is surpassed by",
      "Tamamo and her sexual arts by",
      "Minagi, her overall combat",
      "abilities are unmatched. Due to",
      "her immense power, she carries the",
      "title of Monster Lord, a name",
      "that, in the correct history,",
      "became synonymous with the ruler",
      "of all monsters.",
      "",
      "After the Great Monster Wars,",
      "while the other Six Ancestors were",
      "given lands by the Dark Goddess,",
      "Saja was entrusted with the",
      "continent of Hellgondo, where the",
      "Dark Goddess' castle stands. Since",
      "the continent has no human",
      "settlements, there was no need for",
      "governance, effectively making",
      "Saja the Dark Goddess' proxy ruler",
      "of the Monster Realm. Yet, as a",
      "devoted shield for the Dark",
      "Goddess, Saja never strays from",
      "her side. Among the Six Ancestors,",
      "her loyalty and devotion to the",
      "Dark Goddess as both mother and",
      "sovereign are unparalleled.",
      "",
      "Artist: Shiki",
    ],
    825 => [
      "An incarnation of darkness that is the counterpart of the goddess Ilias. circulate around the world",
      "The magical essence forms a unique ego and becomes a higher consciousness in the world.",
      "It will rule the world. Similarly born from sacred essence",
      "The goddess was cornered in the Great Monster Wars, and the world was destroyed.",
      "Ignoring Ilias's threat, he attacked.",
      "The Dark Goddess Alipheese successfully defeats Ilias.",
      "became the ruler of the world. From then on, that world became a demon's support.",
      "The world in which it resided came to be called the Monster Realm. but",
      "It is an action that deviates greatly from the official history, and it is",
      "will face the erosion of chaos.",
      "",
      "Artist: Naguru Faru",
    ],
    826 => [
      "Incorporating the goddess Ilias of the heavens into her body, she becomes a holy demon.",
      "The chaotic form of the Dark Goddess Alipheese who has achieved union.",
      "Harmonize the dark energy and holy energy that surround you.",
      "and gained immense power. But in that spirit",
      "Mixed with the will of chaos, ruled by a desire for destruction.",
      "It is. It's only a matter of time before you can stay rational",
      "A calamity that will definitely destroy the world.",
      "it will turn into a",
      "",
      "Artist: Naguru Faru",
    ],
    827 => [
      "Incorporating the goddess Ilias of the heavens into her body, she becomes a holy demon.",
      "The chaotic form of the Dark Goddess Alipheese who has achieved union.",
      "Harmonize the dark energy and holy energy that surround you.",
      "and gained immense power. But in that spirit",
      "Mixed with the will of chaos, ruled by a desire for destruction.",
      "It is. It's only a matter of time before you can stay rational",
      "A calamity that will definitely destroy the world.",
      "it will turn into a",
      "",
      "Artist: Naguru Faru",
    ],
    828 => [
      "A high-ranking shikigami and an oni",
      "possessing tremendous strength. She",
      "was summoned by the Five-Tailed",
      "Taoist to patrol high-security areas",
      "of the Monster Lord's Castle. She has",
      "her own will, but since she is a",
      "shikigami, she appears to be bound to",
      "abide by a magical contract.",
      "Wielding the greatest physical",
      "prowess even among oni, she is said",
      "to beat down intruders with her",
      "overwhelming strength and sturdy",
      "physique.",
      "",
      "Her temper is so violent that even",
      "her summoner has difficulty",
      "controlling her. Whenever she comes",
      "across a man, she will violently",
      "rape him and squeeze him dry of his",
      "semen. While she doesn't intend to",
      "kill men, her semen squeezing is so",
      "intense that the men sometimes lose",
      "their lives; thus she is considered",
      "to be an extremely dangerous oni.",
      "",
      "Artist: Jingai Modoki",
    ],
    829 => [
      "A high-ranking shikigami and an oni",
      "possessing immense magical power. She",
      "was summoned by the Five-Tailed",
      "Taoist to patrol high-security areas",
      "of the Monster Lord's Castle. She has",
      "her own will, but since she is a",
      "shikigami, she appears to be bound to",
      "abide by a magical contract.",
      "Wielding magical abilities that could",
      "be considered unique among oni, she",
      "is said to utilize a variety of",
      "taoism techniques to eliminate",
      "intruders.",
      "",
      "She is highly intelligent for an oni,",
      "and has a deviously obsessive nature.",
      "If she captures a man, she will take",
      "her time torturing him as he is",
      "completely squeezed of semen. While",
      "she does not intend to kill men, she",
      "is inconsiderate of the harsh burden",
      "her torture places on their bodies,",
      "which leaves them with both physical",
      "and mental after-effects. Thus, she",
      "is feared as an incredibly fiendish",
      "oni.",
      "",
      "Artist: Jingai Modoki",
    ],
    830 => [
      "Heinrich's grudge, sealed in the prison of a sinner, becomes great.",
      "A berserker formed by reacting with sacred elements in the air. own",
      "He has almost no will, only a grudge against the angel.",
      "I am driven. Heinrich's soul exists",
      "Existing in inexhaustible quantities, no matter how many times you defeat them, they will cease to exist.",
      "There isn't. Wield your extraordinary power and become an angel.",
      "They are a group that continues to slaughter.",
      "",
      "I gathered too many Heinrichs in one place, so the Black Mansion",
      "also occurs in large quantities. Searching for an angel that shouldn't exist,",
      "It is said that he is wandering below.",
      "",
      "Artist: Setouchi",
    ],
    832 => [
      "A chimera monster developed by the Alliance of Wisdom. Restraint",
      "Built as one of the prototype variations of bundled chimera.",
      "However, because the performance was extremely good,",
      "Mass production after making improvements. I hardly move from that spot.",
      "Although it is not suitable as an invasion force because it is fleeting,",
      "A very effective key if limited to base security only.",
      "It's Mera Monster. Capture an intruder with its tentacles",
      "Then, he was made to sit on a chair and was forcibly restrained. Pleasure as it is",
      "They are free to kill them or torture them at will.",
      "",
      "The 'Alliance of Wisdom' will replace this fallen throne with the alliance partner's heaven.",
      "Rather than being dispatched to the world, he was kept as the main security force at the headquarters research institute.",
      "Exists. If this defense network were to be breached,",
      "In other words, it will be the time of the end of the 'Alliance of Wisdom.'",
      "",
      "Artist: Setouchi",
    ],
    833 => [
      "An undead developed by the Alliance of Wisdom,",
      "-Completed under Croix's leadership. zombie and goth",
      "It is a composite undead that is a fusion of",
      "It is finished using. Outstanding vitality and expansion",
      "It possesses great magical power and its combat ability is extremely high, but",
      "In order to complete it, it is necessary to apply a forbidden SKL to the entire body.",
      "Therefore, mass production is impossible. Therefore, a few",
      "Completed, roams around the 'Wisdom Alliance' research institute and protects it.",
      "I am making them serve.",
      "",
      "It takes a lot of energy to maintain, and usually",
      "obtains semen in the form of a bottle supply. Now it's time",
      "If you attack a male intruder, give in to your cravings.",
      "Her energy is squeezed out and she dries up as she climaxes repeatedly.",
      "It's going to be a lot of fun.",
      "",
      "Artist: Setouchi",
    ],
    834 => [
      "The highest class Apotoshi that appears in the deepest region of chaos.",
      "vinegar. It looks like a girl, but its tentacles can touch all beings.",
      "Leading existence to destruction. Is it an Dark Goddess from outer space that once existed?",
      "It appears that data is being used from",
      "be. Her name was taken from the goddess of the vanished world.",
      "However, in today's world, very few records remain.",
      "Not yet.",
      "",
      "It has a very sadistic nature and smothers intruders with its tentacles.",
      "erect In addition to enjoying the squeezing and writhing face, you can also",
      "If it is a man, he will also perform pleasure torture using tentacles. especially men",
      "The vessel is relentlessly abused and ejaculates repeatedly while being mocked.",
      "I'll have to go back. Finally, the semen is squeezed out with tentacles.",
      "You'll be uprooted and die.",
      "cormorant.",
      "",
      "Artist: Zawa",
    ],
    835 => [
      "The highest class Apotoshi that appears in the deepest region of chaos.",
      "vinegar. It seems like an attempt was made to form an angel type, but an error occurred.",
      "This results in incomplete formation, and the body dissolves into mucus.",
      "It's stored away. But even in that state, it's still very powerful.",
      "Even the melted viscous body can be skillfully used as a weapon.",
      "Looks like it's coming. Also, they always act in groups of three, and",
      "It is also excellent at nation attacks.",
      "",
      "She is always hungry for semen, and when she sees a man, she wraps her body in mucus.",
      "It gives pleasure and stimulation. The ejaculated semen",
      "Everything is absorbed by the body as nutrients and dried up.",
      "It will be sucked away. If attacked by a group",
      "The end is tragic, as she writhes and screams in pleasure inside the mucus.",
      "This means that all the semen will be drained out.",
      "",
      "Artist: Mizukichi",
    ],
    836 => [
      "The highest class Apotoshi that appears in the deepest region of chaos.",
      "vinegar. It seems like an attempt was made to form an angel type, but an error occurred.",
      "This results in incomplete formation, and the body dissolves into mucus.",
      "It's stored away. But even in that state, it's still very powerful.",
      "Even the melted viscous body can be skillfully used as a weapon.",
      "Looks like it's coming. Also, they always act in groups of three, and",
      "It is also excellent at nation attacks.",
      "",
      "She is always hungry for semen, and when she sees a man, she wraps her body in mucus.",
      "It gives pleasure and stimulation. The ejaculated semen",
      "Everything is absorbed by the body as nutrients and dried up.",
      "It will be sucked away. If attacked by a group",
      "The end is tragic, as she writhes and screams in pleasure inside the mucus.",
      "This means that all the semen will be drained out.",
      "",
      "Artist: Mizukichi",
    ],
    837 => [
      "The highest class Apotoshi that appears in the deepest region of chaos.",
      "vinegar. It seems like an attempt was made to form an angel type, but an error occurred.",
      "This results in incomplete formation, and the body dissolves into mucus.",
      "It's stored away. But even in that state, it's still very powerful.",
      "Even the melted viscous body can be skillfully used as a weapon.",
      "Looks like it's coming. Also, they always act in groups of three, and",
      "It is also excellent at nation attacks.",
      "",
      "She is always hungry for semen, and when she sees a man, she wraps her body in mucus.",
      "It gives pleasure and stimulation. The ejaculated semen",
      "Everything is absorbed by the body as nutrients and dried up.",
      "It will be sucked away. If attacked by a group",
      "The end is tragic, as she writhes and screams in pleasure inside the mucus.",
      "This means that all the semen will be drained out.",
      "",
      "Artist: Mizukichi",
    ],
    838 => [
      "The highest class Apotoshi that appears in the deepest region of chaos.",
      "vinegar. It is said to be the strongest combat type multi-production type.",
      "We are proud of our ability to attack and attack, and our attack and defense performance is second to none.",
      "It stands out from the crowd compared to Tosis. algemini",
      "is equipped with huge shooting weapons and excels in long-range combat.",
      "There is. Even if you were able to evade the shots and get close,",
      "Its specially armored body also boasts a menacing DEF. near",
      "Always in combination with Elgemini, who is good at close combat.",
      "Team up to fight and cover each other's weak points.",
      "He also has high combat SKL. Truly protects the abyss of chaos",
      "It is the strongest defensive force in Japan.",
      "",
      "The shooting weapon in his hand can also be used as a sperm extraction machine.",
      "It is possible to be there. After the battle, the consumed energy",
      "She forcibly exploits men's semen in order to replenish herself.",
      "If that happens, every last drop will be squeezed out, making it an exceptional",
      "It will leave you breathless.",
      "",
      "Artist: Delphinus",
    ],
    839 => [
      "The highest class Apotoshi that appears in the deepest region of chaos.",
      "vinegar. It is said to be the strongest combat type multi-production type.",
      "We are proud of our ability to attack and attack, and our attack and defense performance is second to none.",
      "It stands out from the crowd compared to Tosis. elgemini",
      "is equipped with a huge slashing weapon and excels in close-range combat.",
      "There is. Even if you manage to block that slash, the special",
      "The armored body boasts a threatening DEF. long range combat",
      "We always work together with Algemini, which specializes in",
      "They fight, cover each other's weak points, and fight.",
      "He also has high fighting SKL. Truly the strongest protector of the abyss of chaos.",
      "It is the defensive force of",
      "",
      "The slashing weapon in his hand can also be used as a sperm extraction machine.",
      "It is possible to be there. After the battle, the consumed energy",
      "She forcibly exploits men's semen in order to replenish herself.",
      "If that happens, every last drop will be squeezed out, making it an exceptional",
      "It will leave you breathless.",
      "",
      "Artist: Delphinus",
    ],
    840 => [
      "The son of Luka and Alipheese the",
      "16th in the correct history, and",
      "the twin brother of Neris. He",
      "inherits angel blood from his",
      "father and monster blood from his",
      "mother, allowing him to wield the",
      "power that fuses both holy and",
      "dark elements. While they work",
      "diligently to resolve the chaos",
      "phenomenon, they have yet to",
      "uncover a definitive solution.",
      "",
      "Artist: Shiki",
    ],
    841 => [
      "The daughter of Luka and Alice the",
      "16th in the correct history, and",
      "the twin sister of Nero. She",
      "inherits angel blood from her",
      "father and monster blood from her",
      "mother, allowing her to wield the",
      "power that merges both holy and",
      "dark elements. While they work",
      "diligently to resolve the chaos",
      "phenomenon, they have yet to find",
      "a concrete solution.",
      "",
      "Artist: Shiki",
    ],
    842 => [
      "An apostle of chaos created based on information from the White Rabbit.",
      "Yes, and has a sense of self. Infinitely biased like the white rabbit",
      "It has the ability to exist, and this also has multiple failures.",
      "He is a one-sided individual. Still normal apoptosis",
      "He has combat abilities that are on a whole other level, and exists in this world.",
      "It is almost impossible for those who do so to counter it. This club",
      "If tens of thousands of Su appear, the ground will definitely be destroyed.",
      "I would.",
      "",
      "Artist: Nuppehof",
    ],
    843 => [
      "A new type of apoptosis created by the God of Chaos. battle",
      "It combines high ability and ease of mass reproduction, making it suitable for infantry and",
      "extremely useful. Close combat with a lance built into your body",
      "In addition to challenging you, you can also use holy energy and dark energy.",
      "It fires and attacks. Also has high DEF and maneuverability.",
      "A battle worthy of a new generation of apoptosis.",
      "Possesses fighting ability. Such a powerful apotheosis",
      "Even Su is an almost inexhaustible creation for the God of Chaos.",
      "They are capable infantrymen.",
      "",
      "Artist: xelvy",
    ],
    844 => [
      "A new type of apoptosis created by the God of Chaos. This world",
      "Apoptosis for investigation and sample collection.",
      "powerful mechanical weapons and sample capture capsules.",
      "It has many in its body. Irregularly patrolling this world",
      "Then, the organisms are captured as samples. that capsule",
      "The specimen will be analyzed in-house, and dissection and gene collection will be performed. captured",
      "If the target is a male, sperm must be collected.",
      "It seems like it will happen. Anticipating attacks by mortals, single",
      "His fighting ability is also very high. Especially the strength of the body",
      "It is extraordinary, and unless you are a chaotic being, destruction is almost impossible.",
      "It is possible.",
      "",
      "This research on apoptosis was created very early on.",
      "Because of this, the God of Chaos has a deep interest in this world.",
      "I can see that there is something going on. These research machines",
      "and reconnaissance planes come and go in this world, and the god of chaos greedily gathers information.",
      "They seem to be looking for knowledge.",
      "",
      "Artist: Delphinus",
    ],
    845 => [
      "The XX type was once the strongest in the world, and there were two of them.",
      "of apoptosis. every time it gets destroyed",
      "With the property of being strengthened and restarted,",
      "After repeated reinforcements, it finally reached its maximum strength.",
      "It seems so. However, when the three worlds merged, even the principles changed.",
      "Currently, Adramelech, who operates based on the principles of the past, is a relic of the old world.",
      "It has become a thing. The world itself becomes chaotic",
      "The extermination system in the middle and chaotic realms no longer exists.",
      "I have lost my righteousness and have no choice but to disappear.",
      "Maybe.",
      "",
      "Artist: xelvy",
    ],
    846 => [
      "The fifth law incarnated as the apostle of chaos. XX type apoptotic",
      "Created based on the data of Sonya Chaos belonging to Sith.",
      "The operation history includes Sonya's memories.",
      "It has been passed down from generation to generation. However, she has a different personality from Sonya.",
      "It seems that he desires the solemn destruction of the world.",
      "As an apostle of chaos, he has power that surpasses even God, and uses holy energy.",
      "Both Lugi and dark energy, as well as holy demon fusion anti-",
      "Also masters response. Due to past operating history, especially",
      "He seems to be skilled at emitting and controlling holy energy.",
      "",
      "Artist: Nuppehof",
    ],
    847 => [
      "The queen of the Alph Divine Clan that existed in ancient times, and the sudden death of her family.",
      "mutation. Boasts a military power that approaches that of God, and possesses overwhelming power.",
      "Unified the Alph Divine Clan. Thoroughly destroy the enemy",
      "and is feared as the great king of fear. Later, Alph",
      "Divine Clan were divided into queen factions and goddess worshipers, and a civil war broke out.",
      "Angolmois fought a fierce battle with the goddess Ilias.",
      "However, in the official history, he was unable to reach his full potential and died in defeat. fierce war",
      "Due to this, the Alph gods became extinct, and part of their blood became Elves.",
      "It was passed down to humans.",
      "",
      "However, in one of the many parallel worlds, the power of holy demon fusion",
      "The Angolmois you obtained will appear. Goddess Ilias",
      "Despite defeating the enemy, the world remains driven by the will of destruction.",
      "has been destroyed. This turned into a catastrophic event.",
      "Angolmois annihilated various worlds, and finally",
      "They were invited to the unified world.",
      "",
      "Artist: Makiya",
    ],
    848 => [
      "With a new type of apoptosis created by the God of Chaos, silver",
      "The embodiment of rivers and depletion. 'Black' was worshiped in the desert land.",
      "She is the embodiment of the Earth Mother Goddess, and she is the embodiment of the Earth Mother Goddess.",
      "I'm gaining strength. A protector and a destroyer at the same time",
      "It has one aspect of life, living beings, and the earth itself.",
      "It is said to suck the spirit out of things and deplete them.",
      "Stars were created based on this belief.",
      "The energy of galaxies and space-time can be manipulated with the help of a master. difference",
      "In addition, it squeezes the spirit from all living things with its countless tentacles.",
      "It has the ability to stand up.",
      "",
      "If the other person is a man, suck the tentacle into his genitals.",
      "First, remove every drop from the sperm.",
      "cormorant. The man who became the prey enjoys the sweet pleasure,",
      "It will be uprooted and its spirit will be taken away and it will dry up.",
      "",
      "Artist: Zawa",
    ],
    849 => [
      "A new type of apoptosis created by the god of chaos,",
      "The embodiment of anger and fertility. The 'Wrath' that was worshiped in the desert land",
      "She is the embodiment of the Earth Mother Goddess of Ri, and is filled with fierce anger.",
      "being controlled. At the same time, she also has the power of fertility and can interact with men.",
      "It is said to bring great blessings.",
      "Raji was created based on this belief.",
      "He is a yara, and boasts high combativeness and close combat ability. large",
      "He also received divine protection from the earth, and his fighting ability improved.",
      "There is no one in line.",
      "",
      "She was very amorous, and whenever she saw a man, she raped him.",
      "Ru. I put my penis in that meat pot and shook my hips violently.",
      "If you stand up to it, any man will emit semen within a few minutes without exception.",
      "It will wither and die. But the earth mother goddess",
      "It's not apoptosis, so what's the point even if you get sperm?",
      "It brings no blessings.",
      "",
      "Artist: Zawa",
    ],
    850 => [
      "Ilias, the goddess of heaven, uses apoptosis as a material.",
      "The angel Aptiel, who was created by",
      "The appearance. Ever since Aptiel, he has been unstable and in danger of going out of control.",
      "There were many dangers, but due to the unification of the world, chaos",
      "It finally broke after the concentration increased explosively.",
      "Ruin. causing large-scale mutations and de facto apoptosis",
      "It became Holy energy and dark energy at the same time",
      "It has gone out of control and has become the embodiment of destruction.",
      "Most of them remain unmoved from the Temple of Ilias, but please",
      "It is said that a small number of individuals have left the temple and are wandering.",
      "There is eyewitness testimony. Strangely, who is he?",
      "It does not attack automatically, and has a certain amount of power.",
      "It seems that they are only targeting people.",
      "",
      "When it sees a strong person, it attacks and takes it into its body.",
      "Ru. Absorption of the body is accompanied by intense pleasure, and is enjoyed by both men and women.",
      "I was taken in while repeating the orgasm.",
      "It will be.",
      "",
      "Artist: frfr",
    ],
    851 => [
      "A new type of plant apoptosis created by the God of Chaos.",
      "Designed to be the strongest plant species, edible",
      "The predatory organs of insect plants, the vines of the World Tree, and the pollen of destruction.",
      "Dangerous plant organs, such as scattered fairy flowers, gather together.",
      "It is composed of However, there are too many miscellaneous devices",
      "The body of officials gathered together lacks unity and is extremely unbalanced.",
      "It is stable and has the potential for out of control. for free",
      "Even his sadistic personality has reached the point of mental breakdown.",
      "has been reached.",
      "",
      "Greedily preys on all living things, including humans and demons.",
      "have the instinct to If the other person is a man, digest it.",
      "Thoroughly overrun before. Erecting the male genitalia with various plant organs",
      "It will give you pleasure that will make you writhe and go crazy.",
      "By the time he gets to the point where he's digested, he's gone crazy.",
      "It is said that it is not uncommon.",
      "",
      "Artist: Raichi",
    ],
    852 => [
      "Created by the God of Chaos, based on Curse Angels.",
      "A new type of apoptosis. Curse angels are",
      "Due to poor production, it has a viscous body, but this",
      "They designed the slime angel as a completed form from the beginning.",
      "has been done. In a land of deep spirituality, water containing magical essence",
      "Laws are set up so that holy elements in the atmosphere react and are generated.",
      "As a result, they began to appear in large quantities at water spirit springs.",
      "Ta. Manipulate holy energy freely with angel factors",
      "In addition, he uses his sticky body as a weapon and fights.",
      "His ability is very high.",
      "",
      "In addition, the desire to identify with all living things is extremely strong,",
      "It tries to take it into its body indiscriminately. Sly",
      "Many monsters from the Mu tribe were also taken in, and some became part of their bodies.",
      "It is said that it was lost.",
      "",
      "Artist: Mizukichi",
    ],
    853 => [
      "A new type of apoptosis created by the god of chaos,",
      "Image of a Chaos Priestess. complete without",
      "Through a dance dedicated to chaos, the surroundings become viscous.",
      "It is said to be able to manipulate the highly concentrated chaos that floats around. That dance is this world",
      "Even the laws of physics are twisted, and the chaotic slime floating around",
      "I wrap loose things and take them in. close to humans",
      "Apoptosis has a very scary appearance",
      "It is.",
      "",
      "Even when squeezing the sperm from a man, it is more chaotic than the man himself is intersecting.",
      "Prefers ejaculation using mucus. mucus covers the male genitals",
      "The semen is stimulated with a seductive dance, and what is it?",
      "Make him ejaculate many times and devour semen chaotically. As is",
      "I squeezed out all my energy and kept my prey alive until it dried up.",
      "I'll never go home.",
      "",
      "Artist: Setouchi",
    ],
    854 => [
      "A magician who has reached the ultimate truth, 'The All-Knowing'",
      "Subordinate. A chaotic being created using the chaotic Artificial.",
      "The composition is the same as that of apoptosis. General magic",
      "Although he is proficient at using black magic, he is particularly skilled at using chaos-prohibited magic.",
      "The more you use class magic. The magician of this world",
      "He is a powerful user who cannot even reach his feet. Built",
      "He has an independent sense of self even though he is a",
      "It seems that he worships those who know.",
      "",
      "Humans are the most efficient way to replenish energy",
      "It is the extraction of semen from a man, let alone reality, even from a dream.",
      "Invite a man and mingle. Once violated, it's the end, an exception.",
      "All my energy was taken away and I was squeezed until I was completely exhausted.",
      "It will be stolen. Even if you are squeezed in a dream,",
      "It is said that his body is exhausted and he dies.",
      "",
      "Artist: frfr",
    ],
    855 => [
      "A magician who has reached the ultimate truth, 'The All-Knowing'",
      "Subordinate. A chaotic being created using the chaotic Artificial.",
      "The composition is the same as that of apoptosis. General magic",
      "I am good at using it, especially when it comes to time magic and pleasure magic.",
      "is able to use Chaos Forbidden class magic. This world",
      "A user so powerful that it can't even come close to the level of a magician.",
      "be. Even though we are created, we have an independent sense of self.",
      "Well, it seems like they worship 'The All-Knowing.'",
      "",
      "Humans are the most efficient way to replenish energy",
      "It is the extraction of semen from men, and sometimes even in towns, villages, and cities.",
      "She appears and seduces men on the streets at night. The nature of enjoying pleasure",
      "Therefore, the other man will also have a heaven-like time.",
      "However, by the time dawn breaks, without exception, they are all dead.",
      "say.",
      "",
      "Artist: frfr",
    ],
    856 => [
      "A fragment of flesh from Hiruko,",
      "one of the Six Ancestors, used to",
      "create a split body. Although its",
      "abilities are inferior to the",
      "original, it still possesses power",
      "surpassing that of high-level",
      "monsters. Its gluttonous nature",
      "remains unchanged, allowing it to",
      "engulf and devour opponents larger",
      "than itself. Hiruko can create",
      "more than ten thousand of these",
      "split bodies at the same time,",
      "showcasing just a fraction of her",
      "immense power.",
      "",
      "Artist: Shiki",
    ],
    857 => [
      "The Fourth Law incarnates as an apostle of chaos. XX type apoptotic",
      "Created based on the data of Adramelech, who belongs to the Sith.",
      "The operation history is recorded by Adramelech.",
      "It is inherited, including memories. As an extermination system",
      "Since it has inherited the role of",
      "He has been given the strongest combat ability in history so that he can",
      "are. Attacks with a great sword can overwhelm any enemy, and",
      "Destroy everything with waves of heat. transcendental beings and chaotic beings",
      "surpassing the capabilities of all imaginable external enemies, including",
      "and surpasses Cleo Adra in terms of specs.",
      "is said to be the only god of chaos.",
      "",
      "Artist: Nuppehof",
    ],
    858 => [
      "An apostle of chaos created based on information from the White Rabbit.",
      "Yes, and has a sense of self. Infinitely biased like the white rabbit",
      "It has the ability to exist, and this also has multiple failures.",
      "He is a one-sided individual. Still normal apoptosis",
      "He has combat abilities that are on a whole other level, and exists in this world.",
      "It is almost impossible for those who do so to counter it. This club",
      "If tens of thousands of Su appear, the ground will definitely be destroyed.",
      "I would.",
      "",
      "Artist: Nuppehof",
    ],
    859 => [
      "The second law incarnated as the apostle of chaos. White rabbit information",
      "It is created based on and has the ability to be distributed infinitely.",
      "are. He also inherited the memories and abilities from Hakuto, but they are broken.",
      "The instinct to desire annihilation is extremely strong, and the living disappear into chaos.",
      "I feel the ultimate joy as I progress. space-time",
      "He is good at manipulation, and instead of traveling between parallel worlds, he",
      "You can combine and separate them as you wish. Manipulating time",
      "It is possible, and indeed, the super is omnipresent in all space-time.",
      "He is an overachiever.",
      "",
      "Artist: Nuppehof",
    ],
    860 => [
      "A mysterious super who is doing all he can to destroy in the Yamatai region.",
      "Overseer. It's a mistake to be one of the sixteen Calamities.",
      "He possesses the power to wipe out the world.",
      "It's hidden. All of the numerous weapons carried in his multiple arms",
      "A mysterious weapon that seems to be a sacred weapon, but does not remain in folklore.",
      "It is similar to the main body of Magatsu-Omikami.",
      "His identity is completely unknown.",
      "",
      "Artist: Setouchi",
    ],
    861 => [
      "The ultimate weapon designed by the goddess Ilias,",
      "One of the sixteen Calamities. Ilias in the Great Monster Wars",
      "When Su was being cornered by the Dark Goddess army,",
      "The weapon plan was scrapped because I couldn't control it, and I struggled with it.",
      "Reopened later. Designed with various new technologies and forbidden SKL",
      "Although the calligraphy is finished, it is worse than the previous weapon.",
      "Moreover, the risk of reckless behavior is increasing, and as expected, the Ilias",
      "Even the paper plan was discarded at the stage of development.",
      "did not start. The above is the official history, but",
      "In the countless parallel worlds that exist, you can't give up and complete the work.",
      "It seems that there was a world that let this happen. Naturally",
      "Magatsu-Omikami goes out of control and destroys the goddess and the Dark Goddess.",
      "It is said that I drove the world to ruin.",
      "",
      "A state-of-the-art Taoism furnace is used for power, and the Holy Demon",
      "Can generate fusion reactions. Ilias also poured his heart and soul into",
      "Futomitama sword, Yata mirror, Hasshaku Qiong magatama etc. finished with",
      "Possesses multiple sacred treasures and boasts overwhelming combat performance.",
      "Ru. It is possible to activate multiple forbidden SKL, and it is possible to use all kinds of SKL, including gods.",
      "It is said to have specs that surpass those of other creatures.",
      "",
      "Artist: Setouchi",
    ],
    862 => [
      "A living body captured by the ultimate intelligence Singularity.",
      "Android for hunting. Capturing various creatures, especially humans.",
      "Stored in the hunting unit and collected its genetic information",
      "The main mission is to do so. Appearance very similar to humans",
      "What they are doing is entering towns and cities and abducting people.",
      "In order to do so, in the world where the Singularity was born.",
      "Tens of thousands of people were abducted by Zoloct,",
      "It is said that it was made into a biological sample. Alone again in enemy territory",
      "Since there are many missions involved, individual combat ability is limited.",
      "Always highly designed.",
      "",
      "A human being captured in a capture unit has all the cells in his body under control.",
      "It is collected as a sample. If you are a man, semen",
      "Also uprooted and squeezed as a valuable sample of germ cells",
      "It is said that it will be taken. After sample collection, the human",
      "He is brought to Gularity's headquarters, but after that...",
      "'s fate is uncertain.",
      "",
      "Artist: Delphinus",
    ],
    863 => [
      "For combat created by the ultimate intelligence Singularity.",
      "elite android. Designed with an emphasis on mobility",
      ", with an overwhelming amount of energy both inside and outside the atmosphere.",
      "Boasts speed performance. Weapon despite its lightweight body",
      "is a powerful, singularity combat android",
      "It is said to boast the best performance among all.",
      "During the decisive battle with the Star Eater, more than 10,000 Tiamat members",
      "It seems that a strategy was devised to exhaust the enemy with troops.",
      "In anticipation of this, mass production has begun, but the price is high.",
      "Costs are high due to performance, and progress in mass production plans is slow.",
      "It seems so.",
      "",
      "Surprisingly, the fuel consumption is good, and if you squeeze the sperm from one man,",
      "It can operate without replenishment in 2018. of course,",
      "At that time, the man who has been squeezed out will take his last breath.",
      "Probably.",
      "",
      "Artist: xelvy",
    ],
    864 => [
      "The best machine civilization that existed in a parallel world created",
      "A highly intelligent AI and one of the 16 Calamities. Nearby",
      "Welcoming the galactic threat 'Star Eater' that will arrive on the stars.",
      "It was a military supervising AI created to attack, but",
      "It was determined that the existence of humanity would be a weak point in the fight against humans.",
      "No. Exterminate humanity and destroy the planet before the decisive battle with the Star Eaters.",
      "It was brought into a state of virtual destruction.",
      "",
      "The ability to interfere with any machine and incorporate it into its body.",
      "have In addition, the main body has been improved over and over again, making it perfect for ultimate battles.",
      "It is still being updated as a fighting machine.",
      "A base is built on the moon to intercept the Star Eater, and the decisive battle is about to begin.",
      "He is looking forward to it.",
      "",
      "Artist: Usuki",
    ],
    865 => [
      "A race from another world that is enslaved by an Dark Goddess from outer space. There are countless",
      "Although it is a lower class, in this world it is the best in the town.",
      "It has the power to destroy anything. manipulate water",
      "In addition to being powerful, its tentacle attacks are also a threat. deep sea",
      "It seems that it has a body adapted to",
      "is completely unknown. Have a shared consciousness among tribes",
      "There is a theory that it is, but it is not certain.",
      "",
      "Like monsters, they seem to feed on human semen, and they prey on men.",
      "There is a tendency towards sexual abuse. man with its tentacles",
      "In addition to draining the vessel and squeezing out the semen, the body is also squeezed out.",
      "It is suspected that the penis is sucked with an organ and the semen is sucked out.",
      "They also engage in similar mating. Also, humans, monsters, angels, etc.",
      "They kidnap intelligent creatures as 'sacrifices' and place them somewhere.",
      "It has the property of being carried away. thus taken away",
      "Not a single one returned, and what fate will they face?",
      "It is unclear whether it was.",
      "",
      "Artist: Yu",
    ],
    866 => [
      "A part of the body of the Dark Goddess 'The Nameless One' in outer space is",
      "Something with its own ego. Compared to the Serviceborne",
      "Possessing incredible power, it is worshiped as the earth mother goddess on its own.",
      "It is such an existence that it can be said that He can freely manipulate water and tentacles.",
      "It is said that he also has some ability to manipulate dimensions.",
      "Absolute obedience to the master, sacrifice for the master in this world",
      "are collecting. Those who were abducted were transported to the deep sea.",
      "Apparently, no one has returned.",
      "",
      "It seems that the bastard himself also needs semen replenishment.",
      "A man who is attacked may be sexually assaulted. touch",
      "In addition to squeezing with hands, the squeezing that the body has",
      "It is said that simulated sexual intercourse is performed using the spermatozoa. pleasure at that time",
      "The feeling was at a lethal level, and the man who had intercourse with the bastard was",
      "It seems to be drying up while crying out.",
      "",
      "Artist: Yu",
    ],
    867 => [
      "By the God of Chaos to command Samyaza and the others.",
      "A new type of apoptosis created. two angels",
      "It has a strange shape connected to the top of the body,",
      "The amount of sacred energy accumulated and radiated is extremely high.",
      "It has a tendency to prefer freedom and is similar to many types of apoptosis.",
      "In this world, they are left to roam free. Sisel is a spirit",
      "Prefers places with high sexual quality, such as the Forest of Spirits and Holy Mountain Amos.",
      "It seems that he is showing up. It's time to destroy the world",
      "Then, Sisel led a large number of Samyaza.",
      "It is said that a large army of people will overrun the land.",
      "",
      "They may have maternal feelings toward humans, and",
      "It is especially endearing. hug me sweetly",
      "It stimulates the male genitals and leads to sweet ejaculation over and over again.",
      "cormorant. Surprisingly, most of the men were released safely.",
      "It seems there is. A new type of apoptosis is a higher ego",
      "However, it does not necessarily follow a uniform way of thinking.",
      "This is a good example.",
      "",
      "Artist: Cool Cultist",
    ],
    868 => [
      "A new type of apoptosis created by the God of Chaos",
      "It was developed for the purpose of destroying bases with a single unit. that",
      "Therefore, the ability to break through alone is very high, and when equipped",
      "The defensive performance and propulsion of the combat auxiliary Machina are outstanding.",
      "are. Because the base is a demon fox, it has the energy of the earth.",
      "It also has a high affinity with the enemy, causing violent earthquakes and attacking enemies.",
      "It is also possible to destroy the entire facility. Also",
      "Possesses a strong sense of self and is flexible due to excellent autonomous thinking.",
      "Able to make flexible judgments and act according to the situation. Single machine failure",
      "As a destroyer, he is a strong man who can be expected to work as an Ikki Tousen.",
      "be.",
      "",
      "When she finds a man, she sometimes plays with him out of curiosity.",
      "Humiliating or forcibly tampering with male genitals",
      "It seems that he also violates the truth and sucks out his spirit. he",
      "It depends on the woman's whims, but in most cases",
      "Your essence will be squeezed out until you die.",
      "Dew.",
      "",
      "Artist: Usuki",
    ],
    869 => [
      "A new type of apoptosis created by the God of Chaos",
      "So, Exsera is further strengthened. shape the whole body",
      "The resulting mucus becomes liquid metal, which can deform and harden.",
      "freely. Contains concentrated dark energy",
      "As a result, he lost his angelic traits, but became a very powerful demon.",
      "The law can now be invoked. The body of liquid metal is",
      "Its performance is extremely high, and if it is deployed in a spherical shape it can be used as a physical attack.",
      "You can't even hurt it. It expands again",
      "It is also possible to attack in waves and has a very high",
      "Boasts great fighting ability.",
      "",
      "She is also greedy for male spirits, and uses her viscous substance to engulf the body of her partner.",
      "Wrap it up and squeeze it. Allow all actions to be taken as is.",
      "The mucus surrounding my crotch is expertly undulating.",
      "It is said that it leads to ejaculation many times. Breathe without exception",
      "It is said that the semen is squeezed out until it dies out.",
      "",
      "Artist: Mizukichi",
    ],
    870 => [
      "It seems that he was probably the Monster Lord in another world.",
      "Details are unknown. Chaotic mutation occurs when crossing between worlds,",
      "It has turned into a chaotic existence that closely resembles apoptosis.",
      "However, his original ego never wavered and he was determined to win.",
      "He seems to have inherited his arrogant nature. war",
      "His fighting ability is overwhelming, and he is skilled with Rapiers. Ma",
      "He freely handles the flames of nuclear heat and forgives those who do not meet his will.",
      "It seems like it will burn out. Dragon genes are strongly expressed",
      "It is suspected that it is related to the ancient dragon race, but the details are unknown.",
      "It is clear.",
      "",
      "Desires coercive sex with men and tortures them",
      "Insult like that. Fuck hard and cum over and over again",
      "Freshly squeezed, and when you feel excited, you can cloak your opponent.",
      "It is said that the meat and blood may be squeezed out by wrapping it in water.",
      "",
      "Artist: Usuki",
    ],
    871 => [
      "Ilias, the goddess of heaven, uses apoptosis as a material.",
      "The angel Aptiel, who was created by",
      "The appearance. Ever since Aptiel, he has been unstable and in danger of going out of control.",
      "There were many dangers, but due to the unification of the world, chaos",
      "As the concentration increased explosively, it finally broke down.",
      "Ruin. causing large-scale mutations and de facto apoptosis",
      "It became Holy energy and dark energy at the same time",
      "It has gone out of control and has become the embodiment of destruction.",
      "Most of them remain unmoved from the Temple of Ilias, but please",
      "It is said that a small number of individuals have left the temple and are wandering.",
      "There is eyewitness testimony. Strangely, who is he?",
      "It does not attack automatically, and has a certain amount of power.",
      "It seems that they are only targeting people.",
      "",
      "When it sees a strong person, it attacks and takes it into its body.",
      "Ru. Absorption of the body is accompanied by intense pleasure, and is enjoyed by both men and women.",
      "I was taken in while repeating the orgasm.",
      "It will be.",
      "",
      "Artist: frfr",
    ],
    872 => [
      "An unknown chaotic being that has entered from another world.",
      "Possesses angel genes and a large amount of holy energy",
      "Constituent factors that are accumulated in angels but cannot be possessed by angels",
      "There are many, and the lineage is still unknown. countless tentacles",
      "It is prepared and greedily devours the surrounding creatures.",
      "say. In addition to being able to emit holy energy, everything",
      "It is said that it can also breathe out a frigid breath that freezes.",
      "cormorant. Although it is unconfirmed, the body can survive outside the atmosphere.",
      "It is possible that the animal evolved in an abnormal environment.",
      "It is considered.",
      "",
      "Semen seems to be a very delicious bait, and it turns human men into enemies.",
      "If it happens, capture it without killing it, and use its tentacles to squeeze out the semen.",
      "It sucks it up. and semen stops coming out",
      "After squeezing her to the max, I swallowed her body whole.",
      "They even use their blood and flesh as nutrients.",
      "",
      "Artist: Mizukichi",
    ],
    873 => [
      "A new type of apoptosis created by the God of Chaos",
      "A heavily armed shooting type. vampire based",
      "However, his entire body is surrounded by countless firearms. So",
      "Its suppressing power was overwhelming, and even tens of thousands of troops were sunk by a single horse.",
      "It is said that he will be silenced. From the singularity",
      "It is said that the data is reflected in the data, but the truth is",
      "is unknown. Her personality is like that of a high-ranking demon, and she is arrogant.",
      "Therefore, I have a very high sense of pride. But it has a whimsical side",
      "If you desperately beg, they will let you go home alive.",
      "It is said that there is also a chance to receive it.",
      "",
      "Her nature is the same as that of a high-ranking demon, and when she looks at a man, she is overbearing.",
      "I'm going to commit a crime. If you ask with sincerity, you will be relieved without being killed.",
      "Let me release you and give you even more exquisite pleasure.",
      "It seems that it may also happen. But Russian roulette",
      "Being offered a game that's like a female genitalia version of",
      "Also forget that the other party is very capricious",
      "Must not be.",
      "",
      "Artist: xelvy",
    ],
    874 => [
      "A new type of apoptosis created by the God of Chaos",
      "It was built for the purpose of assassinating important people. complete humanoid",
      "It does not look like apoptosis, but the",
      "His physical performance is extremely high, and he has mastered many assassination SKL.",
      "He says he is making a profit.",
      "She is also skilled in pleasure SKL and can easily win over men with her sexual SKL.",
      "It can lead to death. Especially that female genitalia.",
      "She sucks out all of her energy and desperately pursues the man who inserted her.",
      "It is said that it can be done.",
      "",
      "However, any demon or angel can surpass God.",
      "If a powerful apostle of chaos hits it, it will break easily.",
      "In particular, this type of apoptosis is necessary.",
      "It is highly doubtful whether there is. In addition, the destruction of the earth",
      "Apotoshi is clearly an excessive force to use.",
      "There are a lot of people, and I wonder if their desire for destruction is that strong.",
      "It is unclear whether he has other intentions.",
      "",
      "Artist: Usuki",
    ],
    875 => [
      "An unidentified creature that appears in the Demon Cave. deep inside the cave",
      "In addition to the influence of the evil spirit sealed in the",
      "It seems that it has undergone some kind of erosion and mutated. Originally",
      "It seems to have been a caterpillar-like creature, but it is a strange tentacled lifeform.",
      "It has transformed into.",
      "Its vitality is extremely high, and countless tentacles extend from its mouth.",
      "and capture the enemy. It is said that they will just eat it.",
      "Extremely greedy, especially towards intelligent creatures such as humans and monsters.",
      "They seem to like it as bait. Also, they do not reproduce and have enough",
      "It is said that they divide and multiply after receiving nutrients.",
      "",
      "Artist: Nagito Akiba",
    ],
    876 => [
      "An unidentified creature that appears in the Demon Cave. deep inside the cave",
      "In addition to the influence of the evil spirit sealed in the",
      "It seems that it has undergone some kind of erosion and mutated. Originally",
      "It seems to have been a worm-type creature, but it is a strange tentacle life.",
      "It has transformed into a body.",
      "The whole body is made of tentacles, and the brain and internal organs are completely absent.",
      "Doesn't exist. Detects prey using sense of smell and touch, and uses tentacles to detect prey.",
      "If it stretches out and takes in the prey from one end,",
      "cormorant. Extremely greedy and possesses intelligent creatures such as humans and monsters.",
      "They seem to particularly like it as bait. Also, it does not reproduce, and",
      "It is said that they divide and multiply after receiving nutrients.",
      "",
      "Artist: Nagito Akiba",
    ],
    877 => [
      "An unidentified creature that appears in the Demon Cave. deep inside the cave",
      "In addition to the influence of the evil spirit sealed in the",
      "It seems that it has undergone some kind of erosion and mutated. Originally",
      "It seems to have been a terrestrial sea anemone, but it has strange tentacles.",
      "It has transformed into a living creature.",
      "It has a huge mouth connected directly to its stomach and is equipped with countless tentacles.",
      "It swallows the enemy it captures whole with its tentacles.",
      "I end up. Even opponents whose size is larger than its own are light.",
      "It is said that it is swallowed hard and is quickly digested.",
      "Extremely greedy, especially towards intelligent creatures such as humans and monsters.",
      "They seem to like it as bait. Also, they do not reproduce and have enough",
      "It is said that they divide and multiply after receiving nutrients.",
      "",
      "Artist: Nagito Akiba",
    ],
    878 => [
      "An unidentified creature that appears in the Demon Cave. deep inside the cave",
      "In addition to the influence of the evil spirit sealed in the",
      "It seems that it has undergone some kind of erosion and mutated. Female body part",
      "The part is a parasitic human being, and the plant part is the main body.",
      "Ru. Humans are not allowed to enter the cave due to the goddess's barrier.",
      "Because there are no",
      "It is thought that they parasitized humans in the area and returned to the cave.",
      "However, there are many mysteries about its detailed ecology. Anyway, it's rarely a cave.",
      "They come out and attack travelers passing by.",
      "Uda.",
      "",
      "When a man is encountered, the vines are stretched out to restrain the host.",
      "Force a woman to have sex. The inside of the female genitals is a plant",
      "The organs are eroded, and the inserted male genitals are severely damaged.",
      "It gives pleasure stimulation and leads to ejaculation. released semen",
      "Everything is exploited by the plants, and the man dies.",
      "It is said that he ejaculates repeatedly.",
      "",
      "Artist: Nagito Akiba",
    ],
    879 => [
      "An unidentified creature that appears in the Demon Cave. deep inside the cave",
      "In addition to the influence of the evil spirit sealed in the",
      "It seems that it has undergone some kind of erosion and mutated. Originally",
      "It seems to have been a worm-type creature, but other unidentified creatures",
      "It preys on living things and has an abnormally large body.",
      "It is said that it has reached this point.",
      "They don't have a brain, they just follow their primitive appetites.",
      "Yes, it swallows the prey it detects whole.",
      "Ku. In addition, a large amount of toxins are stored in the whole body, and breath",
      "It is possible to spit it out as Physical attack by giant body",
      "is also dangerous, and because of its strength there are no external enemies.",
      "That's what it means.",
      "",
      "Artist: Cool Cultist",
    ],
    880 => [
      "Papa became the embodiment of 'greed' due to the seven deadly sins.",
      "Pi. Although he gained great power, he and four other thieves",
      "Because the power is divided into four parts, it has less power than other embodiments.",
      "The range of increase is small. Greed rules the mind, and this",
      "I wish to obtain all the wealth in the world.",
      "The things that get in the way of that exercise are the memories of Master and Luka.",
      "It seems like it has completely disappeared from my mind.",
      "",
      "Artist: Nonhuman Modoki",
    ],
    881 => [
      "A sea race that existed in ancient times, similar to modern mermaids.",
      "There is a genetic link. Very high magical power",
      "Or has the ability to travel back in time. but,",
      "Time travel for personal reasons is strictly prohibited by family law.",
      "It seems that it is. once ruled the vast oceans",
      "However, the society was closed and all details are unknown.",
      "It is clear. There is no interaction with other races, and there is no history.",
      "Disappeared from the sea at a certain point in history. The footsteps after that",
      "Everything is unknown, and they are a mysterious race.",
      "However, in the unified world, World Drown appears.",
      "Regression in response to the present. However, regarding the intention",
      "He didn't say anything, just attacked the approaching ships.",
      "continues to do so.",
      "",
      "The only time she comes into contact with other races is when she mates with a man.",
      "When she saw a young man, she dragged him into the sea and forcibly raped him.",
      "I'll come. A sweet and melting exchange takes place",
      "However, in the end, it will be squeezed out until the end of life.",
      "It is said that it will become.",
      "",
      "Artist: Yu",
    ],
    882 => [
      "A subspecies of banshee that primarily eats meat. prey on its tail",
      "A very unique form with a mouth and a second stomach",
      "It becomes. Factors of marine predators in the evolutionary process",
      "It seems that it was adopted, but the details are unknown.",
      "Although he has a sociable personality for a banshee,",
      "Actually, it is a predator that ruthlessly eats the flesh of its prey. especially young",
      "She liked ugly men and attacked ships and captured them as bait.",
      "Apparently. Like other banshees, it disappeared from history.",
      "However, he reappeared in the united world.",
      "",
      "Basically, humans eat regardless of gender, but",
      "If a man enters the cage, he may mate before predation.",
      "She also sucks the penis with the ejaculation mouth of the tail and squeezes out the semen.",
      "It seems that sometimes it is taken away. At this time, I desperately beg",
      "In some cases, the fish may be released without being eaten.",
      "",
      "Artist: Cool Cultist",
    ],
    883 => [
      "Appears by repeating the journey back to the same time thousands of times",
      "A mutant Banshee. The power to manipulate time and space reaches its limit",
      "It has become more and more chaotic. That devil",
      "The tsunami he summons with his power is enough to submerge the world.",
      "It is also possible to control the weather on the entire planet. The world has been submerged many times",
      "He repeatedly destroys them and goes back in time to the past.",
      "I'm returning it.",
      "",
      "Appears in the United World as one of the 16 Calamities.",
      "As the head of the clan, he commanded many banshees and ruled the world.",
      "He is about to sink his body into the sea. But even that",
      "It's just something that has been repeated many times in the past.",
      "In the beginning there was love, but now there is malice.",
      "I have become a messenger of destruction, moving only on my own.",
      "It is.",
      "",
      "Artist: frfr",
    ],
    884 => [
      "Chaos mutation is caused by the magical power of cosmos that has been eroded by chaos.",
      "A tropical harpy. Before the mutation, the magical beast factor",
      "It is a species called Wild Harpy, and it is difficult to speak.",
      "The harpies used to be quite ferocious, but after the mutation they become even more fierce.",
      "The level of violence is increasing. His flight ability is extremely high,",
      "Attacks with sharp claws and fangs are also a threat. Also obtained from cosmos",
      "Using the energy of the galaxy on a small scale",
      "It is said that it can also be done. Accepting the great will of Cosmos,",
      "It seems to be acting as its limbs.",
      "",
      "Although they are ferocious, they are also highly reproductive, and are capable of mating with human males.",
      "I like it very much. If a man is attacked, the last thing to do is to root out the semen.",
      "She will be fucked until she empties out. partner",
      "It is an extremely dangerous monster that continues to shake its hips even if it dies.",
      "be.",
      "",
      "Artist: Yu",
    ],
    885 => [
      "Chaos mutation is caused by the magical power of cosmos that has been eroded by chaos.",
      "This is a tropical alraune. roots to be a plant",
      "It sucks up an excessive amount of miasma of chaos from the body, and an unknown",
      "It has formed organs. The ivy and plant vessels",
      "The government can expand, contract, and expand freely, and has outstanding vitality.",
      "Proud. Highly intelligent and extremely cruel, the prey screams",
      "It's fun to let your body digest it while listening to it.",
      "That's what it means.",
      "",
      "If a man is captured, he will be subjected to extreme sexual humiliation.",
      "Satisfy your lustful desires. The male genitalia is composed of various plant organs.",
      "She is completely fucked and played with until not a single drop of semen comes out.",
      "It will be. After the essence has dried up, the digestive organs",
      "swallowed up and melted in exquisite pleasure.",
      "It is uno.",
      "",
      "Artist: Yu",
    ],
    886 => [
      "The guardian butterfly Cosmos, which was sleeping on a fairy island, falls into chaos.",
      "It absorbs the energy of and mutates. Originally an adult",
      "It wasn't supposed to be, but it grew explosively and grew from a pupa.",
      "It turns into a feather. The star energy hidden within her body",
      "is further strengthened by the erosion of chaos. tremendous power",
      "It became the embodiment of the destruction it releases. I can no longer protect the stars",
      "A monster that follows the impulses of chaos and desires destruction.",
      "It has become a thing.",
      "The amount of chaos is on a whole other level than when I emerged in heaven.",
      "Therefore, it exerts power that is incomparable to before.",
      "Release the energy of the planet from your whole body and flap your wings.",
      "It has reached the point where a single attack can scorch the earth.",
      "Destruction spreads just by existing.",
      "It is a butterfly of destruction.",
      "",
      "Artist: UN_DO",
    ],
    887 => [
      "An unidentified undead that appeared in a haunted house in the north.",
      "Do. Do not move from inside the mansion and retreat to the back even if an intruder comes.",
      "It's only hard to push, but if you push hard, you'll develop strength beyond human comprehension.",
      "They will show off and attack. Extremely high playback ability,",
      "Even if it disappears without leaving a single speck of dust, it will instantly disappear.",
      "It is said that he will be revived. Therefore it is impossible to defeat",
      "It is an extremely dangerous existence. anti-life",
      "Possesses a virus that will lead to the destruction of the world",
      "It is said that they are doing so, but the details are unknown. Combined with that background,",
      "It is an extremely mysterious existence.",
      "",
      "Artist: UN_DO",
    ],
    888 => [
      "The Earth Mother Goddess, who was wandering in the underworld, changed due to the influence of chaos.",
      "Something different. In the past, as the god of weaving, a certain",
      "It seems that it was also worshiped locally. giant needle",
      "and weave the sticky thread secreted from its own body.",
      "He is said to be good at making clothes by raising them. but",
      "Now that it has been eroded by a high concentration of chaos, the wisdom of the past...",
      "Her motherhood was lost, and she was unable to even speak properly.",
      "It has turned into a monster.",
      "",
      "He shows no interest in women or even adult men, but",
      "When the hand becomes a boy, the desire for protection is overtaken, and a certain level of knowledge is acquired.",
      "Her sexuality returns and she begins to cradle. Sweet and sticky",
      "It is said that the cloth is woven into clothes and wrapped around the boy's body. As it is",
      "A seductive caress will lead you to climax over and over again.",
      "Uda. But regaining reason is temporary.",
      "Yes, let the other person ejaculate until he runs out of strength.",
      "It is said that it always happens.",
      "",
      "Artist: xelvy",
    ],
    889 => [
      "A tall woman, Apoptosis, wanders the underworld. that body",
      "is formed by a collection of mushrooms and slime molds.",
      "Yes, as if a sinister power dwells due to the erosion of chaos.",
      "It became. The archetype is found in otherworldly lore.",
      "Apparently, the details are unclear. rebirth of the body",
      "His raw power is extremely high, and his magical power is also enormous. Also uses powerful magic",
      "In the underworld, it is considered a very frightening existence.",
      "and is hated.",
      "",
      "He wanders around the underworld and attacks the living when he sees them.",
      "Take it into your body. But the boy is special",
      "He seems to like it, and has a particularly deep interest in immature penises.",
      "show. If such prey is captured, the male genitals are pierced.",
      "It will stimulate him and relentlessly squeeze out his semen.",
      "After the poor boy was repeatedly raped, his flesh was",
      "It follows the path of being embraced and absorbed by the body.",
      "Ru.",
      "",
      "Artist: Yu",
    ],
    890 => [
      "The First Law incarnated as the apostle of chaos. Information in the underworld",
      "Created based on the data of the Reaper being processed.",
      "The history of its operation, including the memory of the Reaper, has been inherited.",
      "It is accepted. Management of the underworld and the realms belonging to it",
      "He was not appointed, but he was incarnated as an apostle.",
      "Even today, there is a sense of territory in these areas.",
      "There is. He has a calm and collected personality and is extremely rational. chaos",
      "Anyone who goes against his will will be mercilessly condemned with his sickle.",
      "That's what it means.",
      "",
      "Artist: Nuppehof",
    ],
    891 => [
      "A genius magician takes the corpse of Chrome, who died in an unexpected accident.",
      "La Croix used many forbidden SKL to revive him.",
      "of. Multiple regeneration SKL and recovery SKL are applied to the body, and",
      "Even if it receives such damage, it will never perish.",
      "Not. In addition, treatments that bend the principles of this world also have an impact on the body.",
      "It resonates and has turned into a chaotic existence. especially",
      "The anti-life virus residing in its body is",
      "It is a threat to people, and if it spreads, it will threaten the world.",
      "Destruction is certain.",
      "",
      "Artist: UN_DO",
    ],
    892 => [
      "The queen of the Alph gods that existed in ancient times, and the sudden death of her family.",
      "mutation. Boasts a military power that approaches that of God, and possesses overwhelming power.",
      "Unified the Alph gods. Thoroughly destroy the enemy",
      "and is feared as the great king of fear. Later, Alph",
      "The gods were divided into queen factions and goddess worshipers, and a civil war broke out.",
      "Angolmois fought a fierce battle with the goddess Ilias.",
      "However, in the official history, he was unable to reach his full potential and died in defeat. fierce war",
      "Due to this, the Alph gods became extinct, and part of their blood became El.",
      "It was passed down to humans.",
      "",
      "However, in one of the many parallel worlds, the power of holy demon fusion",
      "The Angolmois you obtained will appear. Goddess Ilias",
      "Despite defeating the enemy, the world remains driven by the will of destruction.",
      "has been destroyed. This turned into a catastrophic event.",
      "Angolmois annihilated various worlds, and finally",
      "They were invited to the unified world.",
      "",
      "Artist: Makiya",
    ],
    893 => [
      "The ultimate weapon designed by the goddess Ilias,",
      "One of the sixteen Calamities. Iria in the Great Monster Wars",
      "When Su was being cornered by the Dark Goddess army,",
      "The weapon plan was scrapped because I couldn't control it, and I struggled with it.",
      "Reopened later. Designed with various new technologies and forbidden SKL",
      "Although the calligraphy is finished, it is worse than the previous weapon.",
      "Moreover, the risk of reckless behavior is increasing, and as expected, the Ilias",
      "Even the paper plan was discarded at the stage of development.",
      "did not start. The above is the official history, but",
      "In the countless parallel worlds that exist, you can't give up and complete the work.",
      "It seems that there was a world that let this happen. Naturally",
      "Magatsu-Omikami goes out of control and destroys the goddess and the Dark Goddess.",
      "It is said that I drove the world to ruin.",
      "",
      "A state-of-the-art Taoism furnace is used for power, and the Holy Demon",
      "Can generate fusion reactions. Ilias also poured his heart and soul into",
      "Futomitama sword, Yata mirror, Hasshaku Qiong magatama etc. finished with",
      "Possesses multiple sacred treasures and boasts overwhelming combat performance.",
      "Ru. It is possible to activate multiple forbidden SKL, and it is possible to use all kinds of SKL, including gods.",
      "It is said to have specs that surpass those of other creatures.",
      "",
      "Artist: Setouchi",
    ],
    894 => [
      "The third Monster Lord who took the throne after Saja. 'Monster Lord'",
      "was originally a nickname for Saja personally, but his daughter A",
      "Squirrelfeeds takes over as the monster's commander, and the demon",
      "The name 'King' also became a title that was passed down from generation to generation. Na",
      "In terms of genealogy, Osaya says, 'I call myself the first generation.'",
      "'That's presumptuous,' he said, calling the first Monster Lord an Dark Goddess.",
      "Sufizu positions himself as the second Monster Lord.",
      "Ru. Therefore, although Saja is the first Monster Lord, his lineage is",
      "The above is recorded as the second Monster Lord, and this is the later one.",
      "This has caused great confusion in folklore.",
      "",
      "The third Monster Lord Alipheese was born during the period of turmoil after the Great Monster Wars.",
      "govern. Losing the restraint of the Dark Goddess and the six ancestors, there was rebellion in various places.",
      "He spent his life suppressing the powerful demonic forces that caused the rebellion.",
      "vinegar. Due to the overwhelming power inherited from Saja, the number",
      "Even though I threw myself into an irresistible battle",
      "Undefeated in all games. In this era, most demons served the Monster Lord,",
      "Because of his work, the Third Monster Lord was also called the 'Martial King.'",
      "It is said that there is.",
      "",
      "Artist: UN_DO",
    ],
    895 => [
      "The fourth Monster Lord who greatly manifested the characteristics of an insect demon. Overlord",
      "Compared to his predecessor, who had a dignified personality, he had a gentle personality, and",
      "He is also a magician who specializes in magic. The Unarmed of the Third Monster Lord",
      "Because the demon forces had almost been unified by force,",
      "The fourth Monster Lord was responsible for establishing laws and establishing a hierarchy for the Monster Lords.",
      "Concentrates on domestic affairs. The system of governance by the Monster Lord's army is",
      "It would be an exaggeration to say that it was mostly established during the era of the Fourth Monster Lord.",
      "isn't it.",
      "",
      "The fourth Monster Lord himself is not only his grandmother, Saja, but also his mother.",
      "Throughout my life, I realized that I was far inferior in Haki even to the Third Monster Lord.",
      "It is said that he was doing so. However, in reality, the predecessor",
      "The governing system that was solidified by force was the internal affairs business of the fourth Monster Lord.",
      "Because of this, he was known as 'Bun-o' in later generations.",
      "It is praised. For the next thousand years, ruled by the Monster Lord",
      "Osamu does not waver, and the great achievements of the fourth Monster Lord are reflected in history.",
      "This has been proven.",
      "",
      "Artist: UN_DO",
    ],
    896 => [
      "The fifth Monster Lord who has developed the characteristics of a dragon through mutation.",
      "A problem child who appeared for the first time in the family, when the fourth Monster Lord was alive.",
      "Shut yourself up in a cave and fall asleep anywhere.",
      "Which problematic behavior did you repeat? But the power",
      "was amazing, surpassing even the three Monster Lords known as the martial kings.",
      "Until Black Alice appeared later, this Five Monster Lord",
      "He was considered the strongest Monster Lord of all time.",
      "",
      "After the death of the Fourth Monster Lord, he assumed the position of the Monster Lord, but was in charge of all political affairs.",
      "boycott. When my relative cried and complained, before I knew it,",
      "He created a grinning child and handed over the throne of Monster Lord to that child.",
      "It was. Immediately after, he withdrew to a small village in Yamatai and died.",
      "It is said that he did not return to the Monster Lord's Castle until he did so.",
      "In that village, he is greatly worshiped as a dragon god.",
      "For some reason, even the stories of heroes and adventures remained, but the Black A",
      "Records have been lost due to the Squirrel Rebellion.",
      "",
      "Artist: UN_DO",
    ],
    897 => [
      "He was born a king by his mother who gave up the title of Monster Lord.",
      "The fifth Monster Lord has taken the throne. He has been intelligent since childhood, and",
      "He carried out political affairs with the assistance of his ministers. After growing up,",
      "It is said that he ruled the world as a famous prince. Also, its beauty",
      "It also had a good reputation and is said to have fascinated Monster Lords.",
      "Although she cannot match her mother's outstanding strength, she is talented in battle.",
      "He is on par with the Monster Lord. Very hardworking and trained in Unarmed",
      "It is said that he did not neglect training throughout his life. Also, the mother's behavior",
      "Don't utter a single word of complaint about your situation.",
      "It is reported that it was.",
      "",
      "After raising his daughter as the next Monster Lord, he abdicated his position.",
      "Recluse. Coincidentally, the place I chose for my later years was the place where I lived with my mother.",
      "It is said that it was the same land as Yamatai. The end is a quiet cave",
      "Inside the cave, soak yourself in the refreshing flow of a waterfall and relax",
      "It is said that he took his last breath in the state of water.",
      "",
      "Artist: UN_DO",
    ],
    898 => [
      "The 7th Monster Lord who succeeded the 6th Monster Lord, who is highly rated as a wise king.",
      "King and mother of the infamous Black Alice. Mother since childhood",
      "He was trained as a leader by the king and showed great talent.",
      "However, when he became the Monster Lord, he suddenly changed into a tyrannical monarch.",
      "Using his strong authority, he changed the laws that had been in place since the Fourth Monster Lord one after another.",
      "Furthermore, he executed one after another the nobles who opposed it.",
      "That politics made the demons tremble. But industry",
      "bad government, such as the promotion of the",
      "I can't say that it's all about it. The most noteworthy evil",
      "Yuki taught his daughter, who would later become the Eighth Monster Lord, the ways of supremacy.",
      "It is said that this is true. The Seventh Monster Lord gives his daughter all the power of supremacy.",
      "I inherited it and made it into a rare monster, but I was satisfied.",
      "If you add it up, he took his own life at the same time as the Eighth Monster Lord ascended to the throne.",
      "It is said that",
      "However, the Seventh Monster Lord himself said, 'From the moment my daughter was born, she became the supreme king.'",
      "She said that Black Alice was influenced by her mother.",
      "Did I become a monster? Was I born a monster?",
      "It is still a matter of debate. Also, the Eighth Monster Lord Soku",
      "The death of the Seventh Monster Lord on the same day as his death was really suicide.",
      "There are endless doubts.",
      "",
      "Artist: UN_DO",
    ],
    899 => [
      "The younger sister of Black Alice, who is famous as the tyrannical Monster Lord, and the hero High.",
      "The story of Black Alice ended with Nrich's subjugation.",
      "The 9th Monster Lord who ascended the throne after the rebellion. Repairing relationships with humans",
      "He spent his life trying to calm the chaos caused by demon forces, and was left exhausted.",
      "It is said that he took his last breath.",
      "He has a bad relationship with his older sister and rebels against her who has turned into a tyrant. black ant",
      "Appointed by the Monster Lords of the opposition faction to become their ally.",
      "He was also defeated and imprisoned. From the prison with the death of Black Alice",
      "He was rescued and ascended the throne on the same day. Excellent in Unarmed,",
      "His skill with a spear was praised as the best in the world, but in combat",
      "It is said that she could never match her older sister in terms of ability.",
      "The night when I said, 'I spent my whole life wiping my sister's butt.'",
      "His close vassals often hear about the 2019 grudge festival. history",
      "He is the first and only Monster Lord in history to die from overwork.",
      "",
      "Artist: UN_DO",
    ],
    900 => [
      "He succeeded the 9th Monster Lord who died from overwork and immediately became the 10th Monster Lord.",
      "A daughter who was ranked. He was good at intellect, but his hobby was magic.",
      "It is said that he was obsessed with politics and paid no attention to political affairs.",
      "However, the previous king did most of the post-war handling of the Black Alice Rebellion.",
      "In addition to completing the project, a system of support from close retainers was in place.",
      "There were no major problems during his reign.",
      "It didn't happen. Also, the daughter who would later become the 11th Monster Lord immediately",
      "Having played a central role in political affairs even before the throne, the 10th generation",
      "It is said that abandonment of political duties was hardly a problem.",
      "are. An intelligent girl officially ascends the throne as the 11th Monster Lord.",
      "Then he went into seclusion, researching magical arts in the Gold region.",
      "He has finished his life. His skill as a magician is top notch,",
      "He has many accomplishments in this field.",
      "",
      "He is known as a foolish king who cares about his hobbies and does not care about political affairs.",
      "Although it is common, in reality, close vassals deliberately keep away from political affairs.",
      "There is also a theory that he was teased. black alice",
      "During the period when the government was shunned after the rebellion, the violent",
      "A close vassal took over real power in a roundabout way from the 10th generation, who showed his true potential.",
      "It is said that he used his hobby of magical arts as bait to keep him away from the center.",
      "It's a story that is often told, but the truth is unknown.",
      "",
      "Artist: UN_DO",
    ],
    901 => [
      "The 11th Monster Lord, famous as the late wise king. Considered a foolish king",
      "He has been in charge of political affairs since the time of the Ten Monster Lords, and officially ascended the throne.",
      "Since then, he has made numerous achievements in domestic politics. Non",
      "While always intelligent and logical, he is extremely cold and heartless.",
      "It is also said that it is good. Taking a stab at loose finances,",
      "Significant cost savings. Furthermore, we will reduce excessive personnel.",
      "It was said that the opposing aristocrats called him 'brazen-faced.'",
      "say.",
      "",
      "The 11th Monster Lord has a strong image of being cold-hearted and cold-blooded.",
      "However, he dotes on his only daughter, who later becomes the 12th Monster Lord.",
      "It seems like it was. Because he loved her so much, his daughter died for the rest of her life.",
      "It is also said that he could not get over his tendency to be spoiled. In later years",
      "Retire to a quiet village and use a secret SKL to become a human and love",
      "It is said that he lived his entire life with his spouse.",
      "",
      "Artist: UN_DO",
    ],
    902 => [
      "The 10th who succeeded his mother, who was famous as the wise king, to the demon throne.",
      "Second Monster Lord. My mother was a cat-like monster and a mermaid.",
      "Although they looked so similar that it was hard to believe that they were parent and child,",
      "They were on very good terms, and until her mother went into seclusion, she",
      "It is said that they never left.",
      "Although his combat ability is very high, his short-sighted personality makes him difficult.",
      "I'm not good at thinking clearly. However, a close vassal carefully selected by the mother",
      "He said that he provided full support and that there were no problems with political affairs.",
      "say. Furthermore, when I was little, I used to add nya at the end of words when I spoke.",
      "However, he corrected himself when he assumed the Monster Lord's throne. Still surprised",
      "It is said that when he was there, the ending nya appeared.",
      "",
      "Renowned for his valor, there were no rebellions during his reign.",
      "I never woke up. After peaceful abdication, Monster Lord Castle",
      "retired and retired. He turned into a human using a secret SKL and moved to a small village.",
      "It is recorded that he lived there, but his mother is said to be in seclusion.",
      "There is a theory that it is a village. I spent my later years with my mother.",
      "There are rumors that he did, but the truth is unknown.",
      "",
      "Artist: UN_DO",
    ],
    903 => [
      "The mysterious 13th Monster Lord. Successor to the throne of the Monster Lord",
      "He assumed the throne, but there are very few records of his birth and enthronement.",
      "There are only a few episodes that reveal his personality.",
      "There isn't much left. He also died shortly after ascending the throne.",
      "He disappeared, and remains missing. handwritten notes",
      "Since there was a letter, it seems that the person disappeared of his own free will.",
      "Although it is reliable, the content does not get the point at all and the",
      "The true intentions are unknown to this day.",
      "",
      "It is unclear where he died, but Alice",
      "There are five locations around the world that are believed to be the tomb of King Z.",
      "That's what it means. In fact, he is still alive today",
      "There is also a theory that the Thirteenth Generation did not exist in the first place.",
      "He is an extremely mysterious Monster Lord.",
      "",
      "Artist: UN_DO",
    ],
    904 => [
      "In response to the disappearance of his predecessor, the 13th Monster Lord, he immediately died at a young age.",
      "The 14th reigning Monster Lord. Fortunately, I was blessed with many vassals, and",
      "He has reached adulthood without any problems. left behind",
      "Most of the portraits are from her childhood, and most of them are from her childhood.",
      "The image is extremely strong.",
      "",
      "Although he built a peaceful reign with both literary and Unarmed, in his later years",
      "The Remina massacre broke out. The relationship between monsters and humans",
      "While feeling hopeless, he took responsibility for his situation and resigned from the Monster Lord's throne.",
      "Rank. My beloved daughter, who had high hopes for her talent, later became a",
      "I entrust everything to Squirrelfeeds XV. After that, oneself",
      "Seal your power and go into seclusion. Live a modest life until the end",
      "It is reported that.",
      "",
      "Artist: UN_DO",
    ],
    905 => [
      "A split body of Kanade, one of the",
      "Six Ancestors. Kanade holds an",
      "immense amount of life force",
      "within her body, allowing her to",
      "divide it and bestow it onto her",
      "split bodies. These can act",
      "completely independently, making",
      "them more akin to daughters than",
      "mere extensions. However, if",
      "defeated, they can be reabsorbed",
      "back into her original body. It is",
      "said that Kanade can produce an",
      "unlimited number of these split",
      "bodies.",
      "",
      "Artist: Shiki",
    ],
    906 => [
      "A fragment of flesh from Hiruko,",
      "one of the Six Ancestors, used to",
      "create a split body. Although its",
      "abilities are inferior to the",
      "original, it still possesses power",
      "surpassing that of high-level",
      "monsters. Its gluttonous nature",
      "remains unchanged, allowing it to",
      "engulf and devour opponents larger",
      "than itself. Hiruko can create",
      "more than ten thousand of these",
      "split bodies at the same time,",
      "showcasing just a fraction of her",
      "immense power.",
      "",
      "Artist: Shiki",
    ],
    907 => [
      "Part of the Gestalt hive mind.",
      "It takes the form of an insect demon in the spiritual realm, but in reality",
      "is a mental body. It takes into its body the organs of many insects.",
      "It has a hard shell and excellent attack performance.",
      "It is growing. Emerges from the spiritual realm and renders intelligent creatures powerless.",
      "It is said that it becomes part of the shared consciousness.",
      "",
      "If the target is male, mating will always occur. sperm",
      "After being uprooted into Gestalt's fallopian tubes,",
      "It is said that the spirit is assimilated. The pleasure at that time is heavenly",
      "It seems to rise, a gestalt hive mind",
      "Once you become a part of it, you will experience that pleasure forever.",
      "It is called eru.",
      "",
      "Artist: Raichi",
    ],
    908 => [
      "Part of the Gestalt hive mind.",
      "It takes the form of an insect demon in the spiritual realm, but in reality",
      "is a mental body. It has tentacle-like organs all over its body.",
      "The tail serves as a feeding mouth that can swallow humans whole.",
      "are. Its movements are agile and it can instantly prey on its target.",
      "When preyed upon by the hive mind, the body is digested,",
      "That spirit is said to be absorbed into the shared consciousness.",
      "",
      "If the target is a man, stimulate the penis when preying.",
      "In addition, make him ejaculate many times. Roots in the mouth that catch sperm",
      "After being squeezed out, the body is digested and the mind is assimilated.",
      "It is said that The pleasure at that time seemed to rise to the heavens,",
      "Become part of the gestalt hive mind",
      "It is said that you can enjoy that pleasure forever.",
      "",
      "Artist: Cool Cultist",
    ],
    909 => [
      "The core of the Gestalt Hivemind",
      "Thoughts. Although it takes the form of an insect demon in the spiritual realm,",
      "It is actually a spiritual body. excessively concentrated spiritual energy",
      "Lugi even has a physical body and wields overwhelming power.",
      "Physical attacks using the insect demon's body are also a threat, but the opponent's",
      "It is impossible to deal with SKL that directly interfere with the mind. further space-time",
      "It also has the ability to interfere in the spiritual realm.",
      "It is said that he can freely manipulate his time.",
      "",
      "Incorporate the consciousness of all living things into yourself, and ultimately",
      "The purpose is to unify the planet itself into one shared consciousness.",
      "be. I believe that this is happiness for all living things.",
      "We are promoting the sharing of all life with a sense of mission.",
      "It is a calamitous existence that is in danger.",
      "",
      "Artist: Setouchi",
    ],
    910 => [
      "Goth became the embodiment of 'greed' due to the seven deadly sins.",
      "Bu. Although he gained great power, he and four other thieves",
      "Because the power is divided into four parts, it has less power than other embodiments.",
      "The range of increase is small. Greed rules the mind, and this",
      "I wish to obtain all the wealth in the world.",
      "There are things that get in the way of that exercise, memories of my hometown and Luka.",
      "It seems like it has completely disappeared from my mind.",
      "",
      "Artist: frfr",
    ],
    911 => [
      "Due to the Seven Deadly Sins, Prince became the embodiment of 'greed'.",
      "blood. Although he gained great power, he and four other thieves",
      "Because the power is divided into four parts, it has less power than other embodiments.",
      "The range of increase is small. Greed rules the mind, and this",
      "I wish to obtain all the wealth in the world.",
      "Things that get in the way of its exercise, the memories of the wife and Ruka.",
      "seems to have completely disappeared from my mind.",
      "",
      "Artist: Nonhuman Modoki",
    ],
    912 => [
      "Vu became the embodiment of 'greed' due to the seven deadly sins.",
      "Fanilla. Although he gained great power, the other thieves",
      "Because the power is divided into four parts, compared to other embodiments.",
      "The increase in power is small. The mind is ruled by greed,",
      "I wish to have all the wealth in this world.",
      "Things that get in the way of that exercise, memories of the store and Luka, are in the head.",
      "It seems to have completely disappeared from within.",
      "",
      "Artist: Nonhuman Modoki",
    ],
    913 => [
      "I ate a dish that appeared in the Hall of Gluttony, and",
      "Lamia has been affected by power. overwhelming",
      "He is burdened with physical strength and hunger. reason remains",
      "However, the hunger is uncontrollable, and no one cares about it.",
      "Trying to drink it.",
      "In addition to using an Flail as a weapon, which is unsuitable for a lady,",
      "Attacks that wield a large snake body are a threat. Very high vitality",
      "It boasts strength that sets it apart from normal individuals.",
      "",
      "I often commit crimes against young men, but my appetite is high.",
      "If it's spinning, I'll swallow it whole right away. and",
      "It deftly cums in the stomach and causes ejaculation.",
      "The prey disappears while releasing semen in its stomach.",
      "it will be turned into a",
      "",
      "Artist: Setouchi",
    ],
    914 => [
      "Ri, who became the embodiment of 'jealousy' due to the seven deadly sins.",
      "Lee. That delusion distorts space, and",
      "He created a hall of jealousy by involving the neighboring towers.",
      "Overflowing jealousy dominates the mind, and the wealth and fame of others",
      "I want every voice to be my own. Luka",
      "I still have vivid memories of them, and their positive will.",
      "He also seems to be very jealous.",
      "",
      "Artist: Setouchi",
    ],
    915 => [
      "A cow that became the embodiment of 'wrath' due to the seven deadly sins.",
      "Monster Lord. His anger simmers around him, even in his home.",
      "The tower became a scorching space. dominated by intense anger",
      "and attacks anyone with overwhelming power.",
      "Come. After getting angry for a while, try to calm down a little.",
      "is. The surrounding environment, which has turned into a scorching heat space, is also irritating.",
      "This is a major factor.",
      "",
      "Artist: Makiya",
    ],
    916 => [
      "A person who became the embodiment of 'gluttony' due to the seven deadly sins.",
      "Sandra. Candy was the first choice.",
      "However, he devoured that power and became a better embodiment of it.",
      "Due to his uncontrollable appetite, his surroundings become otherworldly. Arayu",
      "It has become a space overflowing with food. but true",
      "What I was hungry for was not food, but what I had tasted in the past.",
      "It's like a remembrance of glory.",
      "",
      "Artist: Setouchi",
    ],
    917 => [
      "Ri, who became the embodiment of 'lust' due to the seven deadly sins.",
      "Squirrel and Lilim. The power given is not so much,",
      "It seems like he maintains a certain level of rationality.",
      "",
      "Artist: masha",
    ],
    918 => [
      "U who became the embodiment of 'lust' due to the seven deadly sins",
      "Witch succubus. On the surface, the attitude is normal, but",
      "His mind is dominated by sexual desire, and he",
      "He has devised a plan to rape his ultimate prey, Luka.",
      "The temple of lust transformed by that thought is so extravagant",
      "Is it because of his hidden hobby of making money?",
      "",
      "Artist: frfr",
    ],
    919 => [
      "Is it the lord Queen Vampire who gained the power of 'Pride'?",
      "Carmilla was given power. Just sublet",
      "Because it is the power of",
      "However, I still follow the orders of my master and follow the instructions of the invading army.",
      "He is in charge. Be violent towards others to begin with",
      "There seems to be no resistance to this.",
      "",
      "Artist: Shiruku",
    ],
    920 => [
      "Is it the lord Queen Vampire who gained the power of 'Price'?",
      "Carmilla was given power. Just sublet",
      "Because it is the power of",
      "However, I still follow the orders of my master and follow the instructions of the invading army.",
      "He is in charge. Be violent towards others to begin with",
      "There seems to be no resistance to this.",
      "",
      "Artist: Shiruku",
    ],
    921 => [
      "Ku, who became the embodiment of 'arrogance' due to the seven deadly sins.",
      "Queen Vampire. Gained enormous power, but",
      "Its fundamental nature has not changed much; it has lost its prudence.",
      "It just happened.",
      "",
      "Artist: Shiruku",
    ],
    922 => [
      "An unknown demon summoned as a follower of the Seven Deadly Sins.",
      "Although it has the qualities of a demon, it is the official racial lineage.",
      "He is an outlier, and there are many unknowns. wind",
      "In addition to being good at handling, he is also skilled at fighting. Even more Sexcraft SKL",
      "He has become skilled and can freely use his aura of pleasure.",
      "Furthermore, its presence, such as attacking in groups,",
      "is a threat.",
      "",
      "If a man is captured by Satanachia, he will be raped.",
      "He will do his best. To squeeze the prey to death from the beginning",
      "'s merciless intercourse will quickly make the other person",
      "It will become a dried up corpse.",
      "",
      "Artist: Zawa",
    ],
    923 => [
      "It seems that he was probably the Monster Lord in another world.",
      "Details are unknown. Chaotic mutation occurs when crossing between worlds,",
      "It has turned into a chaotic existence that closely resembles apoptosis.",
      "However, his original ego never wavered and he was determined to win.",
      "He seems to have inherited his arrogant nature. war",
      "His fighting ability is overwhelming, and he is skilled with Rapiers. Ma",
      "He freely handles the flames of nuclear heat and forgives those who do not meet his will.",
      "It seems like it will burn out. Dragon genes are strongly expressed",
      "It is suspected that it is related to the ancient dragon race, but the details are unknown.",
      "It is clear.",
      "",
      "Desires coercive sex with men and tortures them",
      "Insult like that. Fuck hard and cum over and over again",
      "Freshly squeezed, and when you feel excited, you can cloak your opponent.",
      "It is said that the meat and blood may be squeezed out by wrapping it in water.",
      "",
      "Artist: Usuki",
    ],
    924 => [
      "E, who became the embodiment of 'greed' due to the seven deadly sins.",
      "Va. Because he was the embodiment of a substitute, originally",
      "It is far from the power of the person who embodies it.",
      "",
      "Artist: kupala",
    ],
    925 => [
      "E, who became the embodiment of 'jealousy' due to the seven deadly sins.",
      "Va. Weaker than the first match, perhaps due to fatigue from consecutive matches.",
      "It has become.",
      "",
      "Artist: kupala",
    ],
    926 => [
      "E, who became the embodiment of 'laziness' due to the seven deadly sins.",
      "Va. Every time you lose, you become weaker and your belongings become more and more.",
      "They become poorer.",
      "",
      "Artist: kupala",
    ],
    927 => [
      "A monster from another world that turns the desires of humans and monsters into its own power.",
      "It seems that it was originally a spiritual body, but it absorbs various desires.",
      "By doing this, you gain a body. Appearing between parallel worlds",
      "It is also said that the lineage is not certain.",
      "isn't it. In the world where the seven deadly sins appeared, everyone",
      "The greed of the monsters and demons will be consumed, and without exception, there will be destruction.",
      "It is said that he is following the knowledge.",
      "",
      "It has characteristics very similar to vampires, and can attack with electricity.",
      "I am good at it. Turning the entire space into plasma,",
      "Destruction at the level of destroying the world is possible. ",
      "As one of the sixteen Calamities, we are proud of the degree of disaster risk.",
      "There is.",
      "",
      "Artist: Usuki",
    ],
    928 => [
      "When Kagetsumugi's workshop was eroded by chaos, a large amount of it was stockpiled.",
      "The Paizuri Doll Mk.2 that was also changed due to the erosion of chaos.",
      "Different. My ego grew and I began to move in search of spirit. chaos",
      "As an entity, we have a power that is incomparable to anything before.",
      "is hidden. They seem to recognize the dolls as friends.",
      "It is said that she is very attached to other doll mutants.",
      "",
      "It attacks in response to hostility, but it does not attack helpless humans.",
      "They do not attack, but show interest and approach. partner",
      "If she is a woman, she will be satisfied if she treats her like a doll.",
      "and leaves. If it's a man, it's a tit-fuck doll.",
      "Remember the function and perform restraint titty fuck. in that chest",
      "After making him ejaculate many times, he leaves satisfied as expected.",
      "It seems so.",
      "",
      "Artist: Cool Cultist",
    ],
    929 => [
      "It was under development when Kagetsumugi's workshop was corrupted by chaos.",
      "Iron Maiden also mutated due to the erosion of chaos. Self",
      "My self has sprouted and I have begun to move in search of my essence. chaotic existence",
      "It has a power that is incomparable to anything before.",
      "are. Is torturing others the reason for my existence?",
      "It seems to be thinking and wandering in search of humans.",
      "She is often followed by titty fuck dolls, but",
      "They don't seem to pay anything, and they don't seem to consider them enemies.",
      "",
      "Inside that body, the arms of chaos are packed tightly.",
      "It is. When he sees a human being, he draws him into it;",
      "Invade the whole body. Pleasure beyond human comprehension is given endlessly",
      "The next time they come out, they are all corpses without exception.",
      "It is said that",
      "",
      "Artist: Setouchi",
    ],
    930 => [
      "When Kagetsumugi's workshop was eroded by chaos, a large amount of it was stockpiled.",
      "The Japanese-made dolls that had been kept mutated due to the erosion of chaos. ego",
      "sprouted and began to move in search of spirit. A chaotic existence",
      "It has hidden power that is incomparable to anything before.",
      "There is. Pai seems to recognize the doll as a friend.",
      "It is said that she often plays with Zuri dolls.",
      "",
      "Having a desire to play with humans like dolls",
      "If a person is caught, they will be thoroughly treated like a toy.",
      "be treated. In the case of a man, his genitals are played with relentlessly, and",
      "It is said that no matter how much he ejaculates, he continues to be teased mercilessly.",
      "Because she is a doll, she knows no limits, and many men continue to act as she is.",
      "It is said that he exhaled all his semen and passed away.",
      "cormorant. And after playing with it for a while, it's time to move on to the next toy.",
      "They wander around in search of something.",
      "",
      "Artist: Yu",
    ],
    931 => [
      "Kagetsumugi's spare body moves with its own will.",
      "What you put out. Although it is a spare, the maintenance is perfect.",
      "It has a performance comparable to that of the main unit. Sara",
      "The spare bodies work together to strengthen themselves and equip them with weapons.",
      "etc. are now more powerful than originally. myself is",
      "The true Kagetsumugi, destroying all other bodies and becoming the only one",
      "I am thinking of becoming a unique Kagetsumugi. Now it's a shadow of the original",
      "They cooperate to destroy Tsumugi, but it is a success.",
      "After that, the bodies compete for the seat of the true shadow Tsumugi.",
      "They would have fought.",
      "",
      "Artist: UN_DO",
    ],
    932 => [
      "Angel-type Apotoshi created by the God of Chaos",
      "It was designed with the image of a watcher's eye in mind.",
      "The power of the demon eye is amazing, and with its powerful magical power, it can create various objects.",
      "Evoking physical phenomena and miracles. from a high place",
      "It is said to monitor people and punish those who do not comply with their wishes.",
      "The God of Chaos, who ultimately aims to destroy the world,",
      "We created this type of controlled apoptosis.",
      "It is unknown whether",
      "",
      "He also punished human males by coming into direct contact with them.",
      "It's coming. Inflicts severe sexual assault and drives her to death.",
      "It is. It is clearly a communion as a punishment",
      "And, squeezing and pleasure are of secondary importance, it is clearly an angel.",
      "A peculiar type of apoptosis that brings to the fore the characteristics of",
      "It is.",
      "",
      "Artist: Mizukichi",
    ],
    933 => [
      "By the God of Chaos to command Samyaza and the others.",
      "A new type of apoptosis created. two angels",
      "It has a strange shape connected to the top of the body,",
      "The amount of sacred energy accumulated and radiated is extremely high.",
      "It has a tendency to prefer freedom and is similar to many types of apoptosis.",
      "In this world, they are left to roam free. Sisel is a spirit",
      "Prefers places with high sexual quality, such as the Forest of Spirits and Holy Mountain Amos.",
      "It seems that he is showing up. It's time to destroy the world",
      "Then, Sisel led a large number of Samyaza.",
      "It is said that a large army of people will overrun the land.",
      "",
      "They may have maternal feelings toward humans, and",
      "It is especially endearing. hug me sweetly",
      "It stimulates the male genitals and leads to sweet ejaculation over and over again.",
      "cormorant. Surprisingly, most of the men were released safely.",
      "It seems there is. A new type of apoptosis is a higher ego",
      "However, it does not necessarily follow a uniform way of thinking.",
      "This is a good example.",
      "",
      "Artist: Cool Cultist",
    ],
    934 => [
      "A magician who has reached the ultimate truth, 'The All-Knowing'",
      "Subordinate. A chaotic being created using the chaotic Artificial.",
      "The composition is the same as that of apoptosis. General magic",
      "Although he is proficient at using black magic, he is particularly skilled at using chaos-prohibited magic.",
      "The more you use class magic. The magician of this world",
      "He is a powerful user who cannot even reach his feet. Built",
      "He has an independent sense of self even though he is a",
      "It seems that he worships those who know.",
      "",
      "Humans are the most efficient way to replenish energy",
      "It is the extraction of semen from a man, let alone reality, even from a dream.",
      "Invite a man and mingle. Once violated, it's the end, an exception.",
      "All my energy was taken away and I was squeezed until I was completely exhausted.",
      "It will be stolen. Even if you are squeezed in a dream,",
      "It is said that his body is exhausted and he dies.",
      "",
      "Artist: frfr",
    ],
    935 => [
      "A magician who has reached the ultimate truth, 'The All-Knowing'",
      "Subordinate. A chaotic being created using the chaotic Artificial.",
      "The composition is the same as that of apoptosis. General magic",
      "I am good at using it, especially when it comes to time magic and pleasure magic.",
      "is able to use Chaos Forbidden class magic. This world",
      "A user so powerful that it can't even come close to the level of a magician.",
      "be. Even though we are created, we have an independent sense of self.",
      "Well, it seems like they worship 'The All-Knowing.'",
      "",
      "Humans are the most efficient way to replenish energy",
      "It is the extraction of semen from men, and sometimes even in towns, villages, and cities.",
      "She appears and seduces men on the streets at night. The nature of enjoying pleasure",
      "Therefore, the other man will also have a heaven-like time.",
      "However, by the time dawn breaks, without exception, they are all dead.",
      "say.",
      "",
      "Artist: frfr",
    ],
    936 => [
      "The Nine-Tails appeared from another parallel world to the singularity world.",
      "fox. Perhaps because it became an object of worship for many people, it became a holy",
      "Its body is also white. swelling",
      "Boasting great magical power, he is the most powerful magician in the world.",
      "is hidden.",
      "",
      "Although she has a cruel personality, she is capricious and exploits men at will.",
      "Sometimes they are killed, and sometimes they are released after being petted.",
      "There is also. He is also a rational thinker and",
      "He doesn't seem to like fighting.",
      "",
      "Artist: Setouchi",
    ],
    937 => [
      "A spider that appeared from another parallel world to the singularity world.",
      "Queen. He once lost most of his companions in a civil war between races.",
      "He was in seclusion. But great power can be obtained",
      "Faced with an opportunity, they fight once again in search of lost time.",
      "I surrendered myself. Although he does not have a belligerent personality, he",
      "If he deems it beneficial, he will use his power ruthlessly. shadow",
      "Learn the family's secret forbidden SKL that combines diversion and time magic.",
      "It is said that it is profitable, but has anyone seen it?",
      "do not have.",
      "",
      "Although I think I have given up on desire, I have a good spirit.",
      "When faced with a man, they break the commandment and attack. the",
      "The body is entwined with sticky threads and the essence is carefully squeezed out.",
      "It will come. The long-forbidden appetite and sexual desire are released.",
      "If the man who falls prey to it, his life will be devoured.",
      "It must be.",
      "",
      "Artist: Setouchi",
    ],
    938 => [
      "Reached the truth and ascended as a great chaotic being.",
      "A famous magician. Master the many magics that exist in this world.",
      "He becomes a being who knows everything. Traveling through parallel worlds",
      "Then, once you get there, you will have to perform the succession ceremony.",
      "and select the world's best magician. That person",
      "He becomes 'The All-Knowing.'",
      "",
      "In the end, the body is just a temporary body, and I lived there.",
      "Vast knowledge itself is the true identity of 'The All-Knowing'",
      "I guess you could say that. As for the sorcerer who became the origin,",
      "It has also been deleted from Catholic Records, and its",
      "Even his true name is unknown.",
      "",
      "Artist: Usuki",
    ],
    939 => [
      "The youngest of the Lilith",
      "Sisters. Driven by fiery impulses",
      "that course through every part of",
      "her body, she is consumed by the",
      "desire to rape as many humans as",
      "possible. Although her memories",
      "remain intact, her reason has been",
      "completely overridden by lust,",
      "turning even her former allies",
      "into rape targets.",
      "",
      "Artist: Shiki",
    ],
    940 => [
      "The second-born of the Lilith",
      "Sisters. Driven by fiery impulses",
      "that course through every part of",
      "her body, she is consumed by the",
      "desire to rape as many humans as",
      "possible. Although her memories",
      "remain intact, her reason has been",
      "completely overridden by lust,",
      "turning even her former allies",
      "into rape targets.",
      "",
      "Artist: Shiki",
    ],
    941 => [
      "The eldest of the Lilith",
      "Sisters. Driven by fiery impulses",
      "that course through every part of",
      "her body, she is consumed by the",
      "desire to rape as many humans as",
      "possible. Although her memories",
      "remain intact, her reason has been",
      "completely overridden by lust,",
      "turning even her former allies",
      "into rape targets.",
      "",
      "Artist: Shiki",
    ],
    942 => [
      "The smallest demon in history that arose in ancient times. snake demon",
      "It seems that it is a thing, but it does not fit anywhere in the existing evolutionary lineage.",
      "A unique species that does not match. Causes chaotic mutation from virus",
      "It is believed that even the goddess Ilias did not know her true identity.",
      "I couldn't make it clear.",
      "",
      "It is the same size as a virus, and any monster or",
      "infected humans. The onset of the disease occurs within a day, and the sexual desire",
      "Raise it to the maximum. and transmitted through sexual intercourse,",
      "It will spread explosively. have high intelligence",
      "A super animal that concentrates only on its instinctive breeding activities.",
      "It is extremely dangerous.",
      "",
      "Artist: xelvy",
    ],
    943 => [
      "Queen of Echidna, the smallest monster in history. Echidna is a society",
      "They have instincts similar to sexual insects, and all follow the queen.",
      "Belongs. The queen gives instructions to her family with a wave of magical power.",
      "It is said that the infection is spreading. vice versa",
      "All echidnas are nothing without instructions from the queen.",
      "Unable to do so, they simply become extinct.",
      "",
      "Since it is a queen individual, its power is comparable to that of a normal echidna.",
      "Much better. Mastering many pleasure SKL,",
      "It is said that even the most difficult person will be exhausted in the pleasures of heaven.",
      "",
      "Artist: xelvy",
    ],
    944 => [
      "A race from another world that is enslaved by an Dark Goddess from outer space. There are countless",
      "Although it is a lower class, in this world it is the best in the town.",
      "It has the power to destroy anything. manipulate water",
      "In addition to being powerful, its tentacle attacks are also a threat. deep sea",
      "It seems that it has a body adapted to",
      "is completely unknown. Have a shared consciousness among tribes",
      "There is a theory that it is, but it is not certain.",
      "",
      "Like monsters, they seem to feed on human semen, and they prey on men.",
      "There is a tendency towards sexual abuse. man with its tentacles",
      "In addition to draining the vessel and squeezing out the semen, the body is also squeezed out.",
      "It is suspected that the penis is sucked with an organ and the semen is sucked out.",
      "They also engage in similar mating. Also, humans, monsters, angels, etc.",
      "They kidnap intelligent creatures as 'sacrifices' and place them somewhere.",
      "It has the property of being carried away. thus taken away",
      "Not a single one returned, and what fate will they face?",
      "It is unclear whether it was.",
      "",
      "Artist: Yu",
    ],
    945 => [
      "A part of the body of the Dark Goddess 'The Nameless One' in outer space is",
      "Something with its own ego. Compared to the Serviceborne",
      "Possessing incredible power, it is worshiped as the earth mother goddess on its own.",
      "It is such an existence that it can be said that He can freely manipulate water and tentacles.",
      "It is said that he also has some ability to manipulate dimensions.",
      "Absolute obedience to the master, sacrifice for the master in this world",
      "are collecting. Those who were abducted were transported to the deep sea.",
      "Apparently, no one has returned.",
      "",
      "It seems that the bastard himself also needs semen replenishment.",
      "A man who is attacked may be sexually assaulted. touch",
      "In addition to squeezing with hands, the squeezing that the body has",
      "It is said that simulated sexual intercourse is performed using the spermatozoa. pleasure at that time",
      "The feeling was at a lethal level, and the man who had intercourse with the bastard was",
      "It seems to be drying up while crying out.",
      "",
      "Artist: Yu",
    ],
    946 => [
      "An Dark Goddess from another world who came from outer space. beyond human knowledge",
      "It is endowed with power, and its full scope can be observed within the scope of this world.",
      "It is impossible to I can't keep my sanity even if I look straight at it.",
      "It is a destructive existence.",
      "Currently, it is sleeping peacefully in the demon city sunken in the deep sea,",
      "The relatives act according to the will of the fetus in deep sleep.",
      "Started the movement. Gathering sacrifices and preparing for the resurrection of the Lord",
      "say.",
      "",
      "Artist: Yu",
    ],
    947 => [
      "A mysterious and destructive being, a descendant of the Dimensional Eroder. that body",
      "It is said that it was born by splitting from the",
      "is active. Take in other creatures with its tentacles",
      "The purpose of existence is to greedily devour all life,",
      "Use it as your own nourishment. In this way, all the dependents",
      "devour all living things, then take in non-living things,",
      "In the end, the dimensional eroders themselves erode the entire space.",
      "That's what I said.",
      "",
      "When devouring a man, his sadism increases, and he carefully circles him with his tentacles.",
      "I'm going to drink it. At the same time, it stimulates the male genitals and leads to ejaculation.",
      "I enjoy guiding you and devouring your semen.",
      "be. In the end, her body is swallowed whole and she disappears in ecstasy.",
      "It is said that it will be turned into A dimensional eroder has appeared.",
      "In a world where all life forms follow the same fate,",
      "be.",
      "",
      "Artist: Stealth line break",
    ],
    948 => [
      "A mysterious and destructive being, a descendant of the Dimensional Eroder. that body",
      "It is said that it was born by splitting from the",
      "is active. The surface mucous membrane has a digestive function.",
      "The mucus dripping from the whole body has aphrodisiac and digestive properties.",
      "It has an effect. I was wrapped up in that body.",
      "At the end, my whole body melts in ecstasy.",
      "It is. Reel in multiple prey at the same time and at once",
      "It can be digested and is an extremely dangerous chaotic being.",
      "Ru.",
      "",
      "Dimensional eroders expel countless followers in worlds they have yet to see.",
      "I am sending him as a substitute. His descendants transcend the world",
      "It is said that when they do so, they sometimes mutate into the appearance of lower creatures.",
      "When you see lower creatures that look like these relatives,",
      "There is a high possibility that that world is being targeted by dimensional eroders.",
      "It is said that",
      "",
      "Artist: K2",
    ],
    949 => [
      "A mysterious and destructive being, a descendant of the Dimensional Eroder. that body",
      "It is said that it was born by splitting from the",
      "is active. It is a floating creature like a jellyfish,",
      "Swimming between parallel worlds. Discover the world where living things exist",
      "Then, it invades and devours the residents with its appetite. table",
      "On the surface, he is friendly and enjoys conversation, but in reality,",
      "They only see other creatures as food. touch",
      "Stronger and more independent than hand and mucous membrane relatives.",
      "There are many things that are taking action. Some even reach outer space",
      "Some people are said to be moving into the area.",
      "",
      "The whole body is a digestive system, and it uses its tentacles to catch prey.",
      "Even just holding it gives you the ultimate pleasure while digesting it.",
      "I will do it. If the other person has male genitalia,",
      "It seems that he is digesting this by carefully tinkering with it.",
      "The overflowing semen is also absorbed as food, nourishing the body completely.",
      "It is to be offered as a portion.",
      "",
      "Artist: Mizukichi",
    ],
    950 => [
      "A mysterious and destructive being, a descendant of the Dimensional Eroder. that body",
      "It is said that it was born by splitting from the",
      "is active. A large worm-like predator",
      "However, it also has primitive fish-like characteristics.",
      "Ru. He is a voracious eater and doesn't care about living or inanimate objects.",
      "Predation without hesitation. Swallow everything whole and take it into your body",
      "It is said that it will end up. Their vitality is extremely high, and",
      "It is difficult for existence to compete with it. This descendant is the world",
      "Once it appears in the world, it will be eaten up helplessly.",
      "There is no other choice but to be.",
      "",
      "When you find a young man, squeeze him between his huge breasts.",
      "I like to swallow it and digest it in my cleavage. The past",
      "In the process, the prey ejaculates again and again, and even the semen is used as bait.",
      "It is said that he will be devoured. Even residents of big cities",
      "It is an extremely dangerous kin that devours even people.",
      "",
      "Artist: Mizukichi",
    ],
    951 => [
      "It forms between dimensions and takes space itself as food.",
      "A chaotic singularity. Originally it does not belong to the realm of living things,",
      "It can be called an event. eat up the space",
      "It crosses over to another parallel world and doesn't eat there either.",
      "Travel between worlds. A creature is taken by this dimensional eroder.",
      "When you are absorbed in something, even if your life ends there, you will not regret it.",
      "It is said that you can experience incredible pleasure.",
      "",
      "There is no limit to this desire, and countless worlds",
      "It is said that even after devouring the world, his appetite is still unsatisfied.",
      "In the end, it will consume itself and disappear from this world.",
      "The expected outcome is that he will leave.",
      "",
      "Artist: Stealth line break",
    ],
    952 => [
      "Mini became Dark Phoenix's servant and went out of control.",
      "A mini version of the girl. My body grows and my power increases dramatically.",
      "increased to His personality becomes arrogant and belligerent, and he flies through the air.",
      "They find things and attack them, only to realize that they are stronger than them.",
      "They say they will destroy it to prove that. But the other person",
      "If he runs away, he will be satisfied with his victory and will not pursue him.",
      "Apparently not. Therefore, in the airship industry of the singularity world,",
      "The Phoenix girl's dealings are well known, and",
      "When it comes, I try to run away without fighting back.",
      "That's what it means.",
      "",
      "Now I'm satisfied with just winning, but the destruction of chaos",
      "Impulsiveness is slowly eating away at his will.",
      "Soon, reason will be lost and it will become a genuine catastrophic disaster.",
      "It wouldn't be long before that day came.",
      "",
      "Artist: Nonhuman Modoki",
    ],
    953 => [
      "A wave lifeform that cruises between planets, with the appearance of a black phoenix.",
      "take. If you fly to a planet where life exists, it will be the most similar.",
      "Transferred to a suitable Yorishiro and completely destroyed that planet.",
      "In the end, it generates a nuclear flame and destroys itself and itself into a star.",
      "It is said that the whole thing will be reduced to ashes. And rise from the ashes,",
      "It is said that he will fly off to destroy a new planet.",
      "From the perspective of the creatures living on that planet, it is a disaster, but",
      "The existence of this Dark Phoenix is ​​also the science of life and death.",
      "It is said that they were important for preserving the Kuru. death",
      "However, it is also a story from another world, and the story of sixteen Calamities.",
      "Now that we have been invited to the singularity world as one, what is happening?",
      "It has become a disaster that cannot be created.",
      "",
      "Artist: Shiki",
    ],
    954 => [
      "Wandering through space with hunger and eating the planet itself.",
      "A galactic interstellar predator. In the form of a giant demon",
      "However, it is actually an energy body, a cosmic energy.",
      "It is made up of an unknown power called Lugi. galaxy e",
      "Energy can also be used as an attack and is released randomly.",
      "Just shooting it destroys the entire surrounding space. Nothing",
      "The attack with the giant body sent out into orbit is also frightening,",
      "It is impossible for existence to compete with it.",
      "",
      "Although they have a high degree of intelligence, they are basically instinctual.",
      "Cruise between planets according to your appetite. to life energy",
      "It absorbs energy from a full star and lives there.",
      "It is said that it devours all life. Also, meals",
      "If there are any obstacles, remove them first.",
      "It is said that there is a habit of saying.",
      "",
      "Artist: Setouchi",
    ],
    955 => [
      "Wandering through space with hunger and eating the planet itself.",
      "A galactic interstellar predator. In the form of a giant demon",
      "However, it is actually an energy body, a cosmic energy.",
      "It is made up of an unknown power called Lugi. galaxy e",
      "Energy can also be used as an attack and is released randomly.",
      "Just shooting it destroys the entire surrounding space. Nothing",
      "The attack with the giant body sent out into orbit is also frightening,",
      "It is impossible for existence to compete with it.",
      "",
      "Although they have a high degree of intelligence, they are basically instinctual.",
      "Cruise between planets according to your appetite. to life energy",
      "It absorbs energy from a full star and lives there.",
      "It is said that it devours all life. Also, meals",
      "If there are any obstacles, remove them first.",
      "It is said that there is a habit of saying.",
      "",
      "Artist: Setouchi",
    ],
    956 => [
      "Mysterious tentacle monsters are appearing in large numbers in the Administrator's Tower.",
      "Tar. She looks very similar to Nuruko and is said to have a deep relationship with her.",
      "It seems. Contrary to its cute appearance, it possesses great strength.",
      "In addition to using the power of chaos, he also has tentacles.",
      "Attacks are also a threat. Curious and friendly personality",
      "Although they are very territorial, they are very territorial and don't like strangers' intrusions.",
      "It is said that they will first knock it out and then wait and see what happens.",
      "Three colors, red, blue and yellow, have been confirmed, but there are different benefits depending on the color.",
      "They seem to have different attributes and personalities. Blue has ice attribute",
      "He is calm and collected, and is said to be a little timid.",
      "",
      "She loves human semen, and when she finds a man, she",
      "Stimulates the vessel and causes ejaculation. Mainly uses tentacles,",
      "It is said that he sometimes squeezes it between his big breasts and makes it fire.",
      "cormorant.",
      "",
      "Artist: Cool Cultist",
    ],
    957 => [
      "Mysterious tentacle monsters are appearing in large numbers in the Administrator's Tower.",
      "Tar. She looks very similar to Nuruko and is said to have a deep relationship with her.",
      "It seems. Contrary to its cute appearance, it possesses great strength.",
      "In addition to using the power of chaos, he also has tentacles.",
      "Attacks are also a threat. Curious and friendly personality",
      "Although they are very territorial, they are very territorial and don't like strangers' intrusions.",
      "It is said that they will first knock it out and then wait and see what happens.",
      "Three colors, red, blue and yellow, have been confirmed, but there are different benefits depending on the color.",
      "They seem to have different attributes and personalities. Red has fire attribute",
      "It is said that he has an active and lively personality.",
      "",
      "She loves human semen, and when she finds a man, she",
      "Stimulates the vessel and causes ejaculation. Mainly uses tentacles,",
      "It is said that he sometimes squeezes it between his big breasts and makes it fire.",
      "cormorant.",
      "",
      "Artist: Cool Cultist",
    ],
    958 => [
      "Mysterious tentacle monsters are appearing in large numbers in the Administrator's Tower.",
      "Tar. She looks very similar to Nuruko and is said to have a deep relationship with her.",
      "It seems. Contrary to its cute appearance, it possesses great strength.",
      "In addition to using the power of chaos, he also has tentacles.",
      "Attacks are also a threat. Curious and friendly personality",
      "Although they are very territorial, they are very territorial and don't like strangers' intrusions.",
      "It is said that they will first knock it out and then wait and see what happens.",
      "Three colors, red, blue and yellow, have been confirmed, but there are different benefits depending on the color.",
      "They seem to have different attributes and personalities. Yellow gets lightning attribute",
      "It is said that he is a fashionable and pretentious person.",
      "",
      "She loves human semen, and when she finds a man, she",
      "Stimulates the vessel and causes ejaculation. Mainly uses tentacles,",
      "It is said that he sometimes squeezes it between his big breasts and makes it fire.",
      "cormorant.",
      "",
      "Artist: Cool Cultist",
    ],
    959 => [
      "Mysterious tentacle monsters are appearing in large numbers in the Administrator's Tower.",
      "Tar. The atmosphere is a little similar to Nuruko, and there is some kind of",
      "It seems that there is a connection. Despite its cute appearance",
      "Possesses great power and is able to master the power of chaos.",
      "Or manipulate the elements to cause destructive phenomena. curiosity",
      "He has a hearty and friendly personality, but is territorial.",
      "They are very knowledgeable and will first beat up unknown intruders.",
      "He said he would check on the situation.",
      "",
      "She loves human semen, and when she finds a man, she licks her torso.",
      "The man's genitals are sucked into his ejaculate cavity and he ejaculates. unexpected",
      "She is greedy for men and squeezes out their sperm until the man is weak and on the verge of death.",
      "It is said that sometimes it happens.",
      "",
      "Artist: Cool Cultist",
    ],
    960 => [
      "Mysterious giant tentacle monsters are appearing in large numbers in the Administrator's Tower.",
      "Star. There's something about Nuruko, some sort of",
      "It seems that there is a connection. Overwhelming power for its huge body",
      "Gamagiri and tentacle attacks are also very powerful. of destruction",
      "It is a very dangerous being with hidden power that resembles a personification.",
      "Ru. They have a very strong sense of territory and will step into their territory.",
      "It launches an attack on the opponent who is inside. On the other hand, outside",
      "He also seems to have an interest in the world, and rarely visits places other than the Administrator's Tower.",
      "It has also been seen in places. But in the end, the cave",
      "I'll hide myself in a place where no one can see me, such as in the back.",
      "Uda.",
      "",
      "They are extremely voracious eaters, and when they see a male creature, they extract semen with their tentacles.",
      "It uproots everything. human men are the best",
      "Like prey, violently squeezing the tentacles through his penis.",
      "By the time you finish inhaling, the other person will definitely stop breathing.",
      "It is said to be extinct.",
      "",
      "Artist: Cool Cultist",
    ],
    961 => [
      "Nuruko's true form awakened as a spirit of chaos. chaos",
      "You can freely manipulate it and store it in your body,",
      "It cannot be made to disappear. The world is chaos after all",
      "Because it is the fundamental element that makes up the",
      "To do so is to annihilate the world.",
      "Concentrating a large amount of chaos in the Administrator's Tower, the world",
      "It prevented erosion. Due to the power that leaked out at that time,",
      "There are many dependents such as Null's followers, QQ, TT, etc.",
      "It seems that it has occurred.",
      "",
      "It has enormous power, but in this form it is full of energy.",
      "Due to the high consumption of",
      "I like to do things. Thoughts become as simple as your body",
      "However, it is said that it is easier and better that way.",
      "",
      "Artist: xelvy",
    ],
    962 => [
      "A spider demon that appears from another world and spins space and time. accurate",
      "Although it is not apoptosis, it is a result of time-space movement.",
      "As a result, it possesses properties close to those of a chaotic being.",
      "DEF and AGI due to the shell, as well as interfering with space-time.",
      "Everything is a threat, including the ability to Keep an eye on this spider",
      "The lost prey will never be saved.",
      "say.",
      "",
      "This whole world is like her spider web,",
      "Search for prey across space. I'm targeting good-looking guys",
      "It is easy to break down, and the sticky threads from subspace instantly transform it into a grand.",
      "He is drawn to Aranje. That's right",
      "In the end, a violent mating hell awaits, and the result is",
      "They are preyed upon by humans, and even their blood and flesh are used as nutrients.",
      "It is uno.",
      "",
      "Artist: Setouchi",
    ],
    963 => [
      "To eliminate intruders from the forbidden area of ​​chaos, automatic",
      "It was a generated extermination system, but the three worlds merged.",
      "As a result, the established rules were broken and the situation became virtually out of control.",
      "It was. It was built based on a white rabbit, but the body",
      "It is becoming liquefied. Even in this state, it will collapse",
      "They will try to eliminate the intruders according to their principles.",
      "",
      "Artist: Shiruku",
    ],
    964 => [
      "To eliminate intruders from the forbidden area of ​​chaos, automatic",
      "It was a generated extermination system, but the three worlds merged.",
      "As a result, the established rules were broken and the situation became virtually out of control.",
      "It was. It was built based on the god of death, but the body",
      "It is becoming liquefied. Even in this state, it will collapse",
      "They will try to eliminate the intruders according to their principles.",
      "",
      "Artist: Shiruku",
    ],
    965 => [
      "To eliminate intruders from the forbidden area of ​​chaos, automatic",
      "It was a generated extermination system, but the three worlds merged.",
      "As a result, the established rules were broken and the situation became virtually out of control.",
      "It was. It was built based on a white rabbit, but the body",
      "It is becoming particulate. Even in this state, it will collapse",
      "They will try to eliminate the intruders according to their principles.",
      "",
      "Artist: Shiruku",
    ],
    966 => [
      "To eliminate intruders from the forbidden area of ​​chaos, automatic",
      "It was a generated extermination system, but the three worlds merged.",
      "As a result, the established rules were broken and the situation became virtually out of control.",
      "It was. It was built based on the god of death, but the body",
      "It is becoming particulate. Even in this state, it will collapse",
      "They will try to eliminate the intruders according to their principles.",
      "",
      "Artist: Shiruku",
    ],
    967 => [
      "The fifth law incarnated as the apostle of chaos. XX type apoptotic",
      "Created based on the data of Sonya Chaos belonging to Sith.",
      "The operation history includes Sonya's memories.",
      "It has been passed down from generation to generation. However, she has a different personality from Sonya.",
      "It seems that he desires the solemn destruction of the world.",
      "As an apostle of chaos, he has power that surpasses even God, and uses holy energy.",
      "Both Lugi and dark energy, as well as holy demon fusion anti-",
      "Also masters response. Due to past operating history, especially",
      "He seems to be skilled at emitting and controlling holy energy.",
      "",
      "Artist: Nuppehof",
    ],
    968 => [
      "A transcendent of the chaos that arises from all flesh and blood. Originally different",
      "He seems to have been the Monster Lord of the world, but there is no trace of him anymore.",
      "It has become an existence. Possessing overwhelming power, its",
      "The chaotic flesh it wears can expand at will. surrounding sky",
      "It is said that it is possible to take in the whole space with your own meat.",
      "cormorant. He is also good at magic, and his combat ability is overwhelming. 16 break",
      "It has a power second only to that of the dead, and if it wants, it can take over the entire world.",
      "It is even possible to wrap it in meat and eat it.",
      "",
      "Especially in places where space-time is distorted or where the miasma of chaos is strong.",
      "If you like, you can freely recognize it as your own territory. step into that",
      "Those who are ruthless will be preyed upon mercilessly. both men and women",
      "After sexually violating her and making her taste the hell of pleasure, her own",
      "It is absorbed into the body.",
      "",
      "Artist: Yu",
    ],
    969 => [
      "Daughter of the Dark Goddess Alipheese and the world's strongest dragon sword.",
      "Master. In the official history, he was assassinated by his mother, but he took revenge.",
      "There was a parallel world that existed. At that time, the power of chaos",
      "Manifestation, he gains the ability to rupture time and space with the flash of his sword.",
      "After that, he traveled through different worlds and single-mindedly defeated the strong.",
      "Each time they destroy the world, they increase their power and now they are on par with",
      "He has unparalleled power in his hands. Furthermore, the magic sword in the right hand",
      "is the 'Void Dragon' that bears her name, and her mother Alipheese.",
      "given by Sacred spear Longinus on the left hand",
      "was stolen from the goddess Ilias in a battle in another world.",
      "It is said that it was",
      "",
      "Artist: Shiki",
    ],
    970 => [
      "Daughter of the Dark Goddess Alipheese and the world's strongest dragon sword.",
      "Master. In the official history, he was assassinated by his mother, but he took revenge.",
      "There was a parallel world that existed. At that time, the power of chaos",
      "Manifestation, he gains the ability to rupture time and space with the flash of his sword.",
      "After that, he traveled through different worlds and single-mindedly defeated the strong.",
      "Each time they destroy the world, they increase their power and now they are on par with",
      "He has unparalleled power in his hands. Furthermore, the magic sword in the right hand",
      "is the 'Void Dragon' that bears her name, and her mother Alipheese.",
      "given by Sacred spear Longinus on the left hand",
      "was stolen from the goddess Ilias in a battle in another world.",
      "It is said that it was",
      "",
      "Artist: Shiki",
    ],
    971 => [
      "The second law incarnated as the apostle of chaos. White rabbit information",
      "It is created based on and has the ability to be distributed infinitely.",
      "are. He also inherited the memories and abilities from Hakuto, but they are broken.",
      "The instinct to desire annihilation is extremely strong, and the living disappear into chaos.",
      "I feel the ultimate joy as I progress. space-time",
      "He is good at manipulation, and instead of traveling between parallel worlds, he",
      "You can combine and separate them as you wish. Manipulating time",
      "It is possible, and indeed, the super is omnipresent in all space-time.",
      "He is an overachiever.",
      "",
      "Artist: Nuppehof",
    ],
    972 => [
      "A chaotic being of unknown origin that emerged from the gap between worlds. dimension",
      "It is said to be the same species as the erosive, but details are unknown.",
      "It is. It has the power to erode space-time itself,",
      "Eat. However, they are not as hungry as the dimensional eroders.",
      "Rather, he has a hedonistic precision that puts enjoyment first.",
      "Lord. Therefore, even if you appear in another world, you will be immediately",
      "A tendency to enjoy the world without destroying it.",
      "It seems to be in I also like talking and interacting with the residents,",
      "He was never a friendly person, and most of the people he came into contact with",
      "The pieces are taken in and digested by the gazers.",
      "",
      "Its huge mouth is also part of its body, swallowing everything whole.",
      "It is possible to look at it. However, it swallows human males.",
      "If you have sex, you may prefer to play with them sexually in a different space inside your mouth.",
      "nothing. After enjoying it for a while, it's like any other prey.",
      "It is ruthlessly digested.",
      "",
      "Artist: Nonhuman Modoki",
    ],
    973 => [
      "A battle-type apoptosis created by the God of Chaos,",
      "An existence that embodies the archetype of 'fighting god.'",
      "Therefore, it boasts unparalleled combat ability, and its military power is unparalleled.",
      "It is possible to subjugate any being in the world. overwhelming",
      "He has physical strength and advanced combat SKL, and has multiple arms.",
      "Use all kinds of weapons. very belligerent",
      "He has a strong reputation and will ruthlessly crush anyone who challenges him.",
      "say.",
      "",
      "Although he has a strong sexual desire, he prefers squeezing semen with his hands rather than having intercourse.",
      "I hope it comes out. Thoroughly infringes on the male genitals with multiple arms,",
      "You will be made to ejaculate countless times.",
      "And most men writhe in endless onanism hell.",
      "He dies in great pain.",
      "",
      "Artist: K2",
    ],
    974 => [
      "A monster shrouded in mystery. Appearing in the abyss of chaos,",
      "Tremendous power is condensed in its small body.",
      "Ru. Although there are physical characteristics similar to mermaids and marine creatures,",
      "Its origin is unknown, and it always carries a lantern and a knife.",
      "There is. When an intruder is detected, the robot moves slowly.",
      "Approach it and give it a blow with a knife. other powerful fires",
      "He masters fire arts and water arts, and his power knows no bounds.",
      "It is impossible to have a conversation without speaking, but these words",
      "He seems to understand. With creatures from another world with different logic",
      "There is a theory that this is the case, but the truth is unknown.",
      "",
      "If the person attacked is a woman, stab her with a knife.",
      "However, in the case of a man, he has huge breasts and male genitalia.",
      "are completely overrun. Keep it between the cleavage of your breasts.",
      "Continue the pleasure stimulation until you ejaculate and take your last breath.",
      "It is said that he will be punished.",
      "",
      "Artist: Alexi",
    ],
    975 => [
      "Tonberry Girl has many mysteries, but she seems to be acting in multiple groups.",
      "There are times when people see ro. No conversation etc.",
      "However, it is believed that they are acting in groups of three. in three bodies",
      "They formed a line and moved in silence, but where?",
      "I don't care if you're heading towards it or what your goal is.",
      "It is said to be unknown.",
      "",
      "Artist: Alexi",
    ],
    976 => [
      "A giant insect monster that appeared from another world. manager of the spiritual world",
      "It seems that there was a Gestalt Hive Mine.",
      "It seems that there was some connection with Do, but the details are unknown.",
      "It is. Currently wandering in the depths of chaos, time and space",
      "It devours intruders who accidentally wander in due to the twist of the",
      "are. His power is overwhelming, and he makes use of his strong body.",
      "In addition to advanced Unarmed, he can manipulate time and space with magical power, and is highly skilled.",
      "It is said that they even use extreme mental interference.",
      "",
      "The incapacitated opponent is rounded with the large mouth provided in the abdomen.",
      "I end up drinking it. Even if the other person is a woman",
      "If you are a man, you will be sexually assaulted.",
      "becomes increasingly severe. Make me ejaculate thoroughly",
      "I squeezed him until not a single drop of semen came out.",
      "Later, it will be swallowed whole.",
      "",
      "Artist: xelvy",
    ],
    977 => [
      "A new type of apoptosis created by the God of Chaos",
      "It was developed for the purpose of destroying bases with a single unit. that",
      "Therefore, the ability to break through alone is very high, and when equipped",
      "The defensive performance and propulsion of the combat auxiliary Machina are outstanding.",
      "are. Because the base is a demon fox, it has the energy of the earth.",
      "It also has a high affinity with the enemy, causing violent earthquakes and attacking enemies.",
      "It is also possible to destroy the entire facility. Also",
      "Possesses a strong sense of self and is flexible due to excellent autonomous thinking.",
      "Able to make flexible judgments and act according to the situation. Single machine failure",
      "As a destroyer, he is a strong man who can be expected to work as an Ikki Tousen.",
      "be.",
      "",
      "When she finds a man, she sometimes plays with him out of curiosity.",
      "Humiliating or forcibly tampering with male genitals",
      "It seems that he also violates the truth and sucks out his spirit. he",
      "It depends on the woman's whims, but in most cases",
      "Your essence will be squeezed out until you die.",
      "Dew.",
      "",
      "Artist: Usuki",
    ],
    978 => [
      "An appointment created by the god of chaos to interfere in space and time.",
      "Tosis. Maintain a good link with time and space",
      "It has the traits of a doll. But that body",
      "Tentacle organs born from chaos are swirling within the body.",
      "In fact, it is said that the organs packed inside are the main body.",
      "It will be possible.",
      "",
      "Most of the time they are omnipresent in the abyss of chaos and outside",
      "It never appears in the world. But when creatures meet",
      "If he is found dead, his body will be thoroughly searched.",
      "I have a particular interest in reproductive organs, which are the origin of life.",
      "The genitals of both men and women are carefully played with. Especially phase",
      "If the hand is a man's, sexual intercourse using one's own pseudo-female genitals",
      "Testing the function of the male genitals in various ways, such as",
      "Become. And without exception, they drain all their semen and die.",
      "This will lead to",
      "",
      "Artist: Yu",
    ],
    979 => [
      "The defeated hero Luka mates with Beelzebub, and their child",
      "An insect demon swordsman who came from a world full of grandchildren.",
      "All intelligent creatures in their world belong to Luka.",
      "Because he is a descendant and deviated too much from the official history.",
      "It is subject to unprecedented chaotic erosion. On the verge of destruction,",
      "They flew to the United World in search of a new world.",
      "Currently fighting against the Apoptosis in the abyss of chaos,",
      "He is said to be planning to expand into the outside world. I'm not a fan of my family.",
      "Although always belligerent, he never abandons those in need.",
      "He also seems to have a strong sense of chivalry.",
      "",
      "She has a very strong desire to breed, and when she sees an excellent man, she becomes strong.",
      "They try to leave descendants by violating the rules. Forcible mating",
      "It brings them in, gives them pleasure, and takes away their resistance.",
      "Insemination is carried out about five times, but the child born",
      "For Tatsu's sake, he doesn't kill the other man and lets him play the role of father.",
      "That's what it means.",
      "",
      "Artist: Setouchi",
    ],
    980 => [
      "A new type of decisive battle weapon created by the God of Chaos.",
      "potosis. Weapons once undertaken by goddesses and Dark Goddesss",
      "It was created with reference to the plan, so to speak, it was made in chaos.",
      "It's a weapon. Holy attribute weapon and dark attribute weapon",
      "I created both weapons, but the dark weapon is a demon.",
      "The induction furnace overheated and self-destructed. Stable but expanding",
      "Merkabah, a holy weapon that holds great power",
      "The only Chaos weapon left. the",
      "The power is overwhelming, and there are numerous",
      "Powerful enough to scorch the entire world with chaos weapons.",
      "We are prepared.",
      "",
      "Because it is based on the traits of an angel, if you see a human, you will be punished.",
      "want to give. Particularly sadistic toward men.",
      "The male genitals were subjected to thorough sexual torture.",
      "It will probably happen.",
      "",
      "Artist: xelvy",
    ],
    981 => [
      "A new type of apoptosis created by the God of Chaos",
      "So, Exsera is further strengthened. shape the whole body",
      "The resulting mucus becomes liquid metal, which can deform and harden.",
      "freely. Contains concentrated dark energy",
      "As a result, he lost his angelic traits, but became a very powerful demon.",
      "The law can now be invoked. The body of liquid metal is",
      "Its performance is extremely high, and if it is deployed in a spherical shape it can be used as a physical attack.",
      "You can't even hurt it. It expands again",
      "I